/**
 * This code was AUTOGENERATED using the codama library.
 * Please DO NOT EDIT THIS FILE, instead use visitors
 * to add features, then rerun codama to update it.
 *
 * @see https://github.com/codama-idl/codama
 */
import { fetchEncodedAccount, fetchEncodedAccounts, type Account, type Address, type Codec, type Decoder, type EncodedAccount, type Encoder, type FetchAccountConfig, type FetchAccountsConfig, type MaybeAccount, type MaybeEncodedAccount, type Option, type OptionOrNullable } from '@solana/kit';
import { type AccountState, type AccountStateArgs, type Extension, type ExtensionArgs } from '../types';
export type Token = {
    /** The mint associated with this account. */
    mint: Address;
    /** The owner of this account. */
    owner: Address;
    /** The amount of tokens this account holds. */
    amount: bigint;
    /**
     * If `delegate` is `Some` then `delegated_amount` represents
     * the amount authorized by the delegate.
     */
    delegate: Option<Address>;
    /** The account's state. */
    state: AccountState;
    /**
     * If is_native.is_some, this is a native token, and the value logs the
     * rent-exempt reserve. An Account is required to be rent-exempt, so
     * the value is used by the Processor to ensure that wrapped SOL
     * accounts do not drop below this threshold.
     */
    isNative: Option<bigint>;
    /** The amount delegated. */
    delegatedAmount: bigint;
    /** Optional authority to close the account. */
    closeAuthority: Option<Address>;
    /** The extensions activated on the token account. */
    extensions: Option<Array<Extension>>;
};
export type TokenArgs = {
    /** The mint associated with this account. */
    mint: Address;
    /** The owner of this account. */
    owner: Address;
    /** The amount of tokens this account holds. */
    amount: number | bigint;
    /**
     * If `delegate` is `Some` then `delegated_amount` represents
     * the amount authorized by the delegate.
     */
    delegate: OptionOrNullable<Address>;
    /** The account's state. */
    state: AccountStateArgs;
    /**
     * If is_native.is_some, this is a native token, and the value logs the
     * rent-exempt reserve. An Account is required to be rent-exempt, so
     * the value is used by the Processor to ensure that wrapped SOL
     * accounts do not drop below this threshold.
     */
    isNative: OptionOrNullable<number | bigint>;
    /** The amount delegated. */
    delegatedAmount: number | bigint;
    /** Optional authority to close the account. */
    closeAuthority: OptionOrNullable<Address>;
    /** The extensions activated on the token account. */
    extensions: OptionOrNullable<Array<ExtensionArgs>>;
};
export declare function getTokenEncoder(): Encoder<TokenArgs>;
export declare function getTokenDecoder(): Decoder<Token>;
export declare function getTokenCodec(): Codec<TokenArgs, Token>;
export declare function decodeToken<TAddress extends string = string>(encodedAccount: EncodedAccount<TAddress>): Account<Token, TAddress>;
export declare function decodeToken<TAddress extends string = string>(encodedAccount: MaybeEncodedAccount<TAddress>): MaybeAccount<Token, TAddress>;
export declare function fetchToken<TAddress extends string = string>(rpc: Parameters<typeof fetchEncodedAccount>[0], address: Address<TAddress>, config?: FetchAccountConfig): Promise<Account<Token, TAddress>>;
export declare function fetchMaybeToken<TAddress extends string = string>(rpc: Parameters<typeof fetchEncodedAccount>[0], address: Address<TAddress>, config?: FetchAccountConfig): Promise<MaybeAccount<Token, TAddress>>;
export declare function fetchAllToken(rpc: Parameters<typeof fetchEncodedAccounts>[0], addresses: Array<Address>, config?: FetchAccountsConfig): Promise<Account<Token>[]>;
export declare function fetchAllMaybeToken(rpc: Parameters<typeof fetchEncodedAccounts>[0], addresses: Array<Address>, config?: FetchAccountsConfig): Promise<MaybeAccount<Token>[]>;
//# sourceMappingURL=token.d.ts.map