import { Network } from 'bitcoinjs-lib';
import type { LedgerState } from './ledger';
import type { BIP32Interface } from 'bip32';
export declare const pkhBIP32: ({ masterNode, network, keyPath, account, change, index, isPublic }: {
    masterNode: BIP32Interface;
    network?: Network;
    account: number;
    change?: number | undefined;
    index?: number | undefined | '*';
    keyPath?: string;
    isPublic?: boolean;
}) => string;
export declare const shWpkhBIP32: ({ masterNode, network, keyPath, account, change, index, isPublic }: {
    masterNode: BIP32Interface;
    network?: Network;
    account: number;
    change?: number | undefined;
    index?: number | undefined | '*';
    keyPath?: string;
    isPublic?: boolean;
}) => string;
export declare const wpkhBIP32: ({ masterNode, network, keyPath, account, change, index, isPublic }: {
    masterNode: BIP32Interface;
    network?: Network;
    account: number;
    change?: number | undefined;
    index?: number | undefined | '*';
    keyPath?: string;
    isPublic?: boolean;
}) => string;
export declare const pkhLedger: ({ ledgerClient, ledgerState, network, account, keyPath, change, index }: {
    ledgerClient: unknown;
    ledgerState: LedgerState;
    network?: Network;
    account: number;
    keyPath?: string;
    change?: number | undefined;
    index?: number | undefined | '*';
}) => Promise<string>;
export declare const shWpkhLedger: ({ ledgerClient, ledgerState, network, account, keyPath, change, index }: {
    ledgerClient: unknown;
    ledgerState: LedgerState;
    network?: Network;
    account: number;
    keyPath?: string;
    change?: number | undefined;
    index?: number | undefined | '*';
}) => Promise<string>;
export declare const wpkhLedger: ({ ledgerClient, ledgerState, network, account, keyPath, change, index }: {
    ledgerClient: unknown;
    ledgerState: LedgerState;
    network?: Network;
    account: number;
    keyPath?: string;
    change?: number | undefined;
    index?: number | undefined | '*';
}) => Promise<string>;
