import { cbc, ctr } from "@noble/ciphers/aes";
function getCipher(key, iv, mode, pkcs7PaddingEnabled = true) {
    if (!mode.startsWith("aes-")) {
        throw new Error("AES: unsupported mode");
    }
    const len = key.length;
    if ((mode.startsWith("aes-128") && len !== 16) ||
        (mode.startsWith("aes-256") && len !== 32)) {
        throw new Error("AES: wrong key length");
    }
    if (iv.length !== 16) {
        throw new Error("AES: wrong IV length");
    }
    if (["aes-128-cbc", "aes-256-cbc"].includes(mode)) {
        return cbc(key, iv, { disablePadding: !pkcs7PaddingEnabled });
    }
    if (["aes-128-ctr", "aes-256-ctr"].includes(mode)) {
        return ctr(key, iv);
    }
    throw new Error("AES: unsupported mode");
}
export function encrypt(msg, key, iv, mode = "aes-128-ctr", pkcs7PaddingEnabled = true) {
    return getCipher(key, iv, mode, pkcs7PaddingEnabled).encrypt(msg);
}
export function decrypt(ciphertext, key, iv, mode = "aes-128-ctr", pkcs7PaddingEnabled = true) {
    return getCipher(key, iv, mode, pkcs7PaddingEnabled).decrypt(ciphertext);
}
