# Installation
> `npm install --save @types/base64-js`

# Summary
This package contains type definitions for base64-js (https://github.com/beatgammit/base64-js).

# Details
Files were exported from https://github.com/DefinitelyTyped/DefinitelyTyped/tree/master/types/base64-js.
## [index.d.ts](https://github.com/DefinitelyTyped/DefinitelyTyped/tree/master/types/base64-js/index.d.ts)
````ts
/**
 * Takes a base64 string and returns length of byte array
 */
export function byteLength(encoded: string): number;
/**
 * Takes a base64 string and returns a byte array
 */
export function toByteArray(encoded: string): Uint8Array;
/**
 * Takes a byte array and returns a base64 string
 */
export function fromByteArray(bytes: Uint8Array): string;

/**
 * base64-js does basic base64 encoding/decoding in pure JS.
 */
export as namespace base64js;

````

### Additional Details
 * Last updated: Mon, 06 Nov 2023 22:41:04 GMT
 * Dependencies: none

# Credits
These definitions were written by [Peter Safranek](https://github.com/pe8ter), and [Piotr Błażejewicz](https://github.com/peterblazejewicz).
