export const isWhitelistedHost = (hostname, whitelist = ['127.0.0.1', 'localhost']) => {
    if (typeof hostname !== 'string') {
        return false;
    }
    if (hostname.trim() === '') {
        return false;
    }
    return whitelist.some(whitelistedUrl => whitelistedUrl === hostname ||
        hostname.endsWith(`.${whitelistedUrl}`));
};
//# sourceMappingURL=isWhitelistedHost.js.map