"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.convertTaprootXpub = void 0;
const convertTaprootXpub = ({ xpub, direction }) => {
    const find = direction === 'h-to-apostrophe' ? 'h' : "'";
    const replace = direction === 'h-to-apostrophe' ? "'" : 'h';
    const openingSquareBracketSplit = xpub.split('[');
    if (openingSquareBracketSplit.length === 2) {
        const [beforeOpeningBracket, afterOpeningBracket] = openingSquareBracketSplit;
        const closingSquareBracketSplit = afterOpeningBracket.split(']');
        if (closingSquareBracketSplit.length === 2) {
            const [path, afterClosingBracket] = closingSquareBracketSplit;
            const correctedPath = path.replace(new RegExp(find, 'g'), replace);
            return `${beforeOpeningBracket}[${correctedPath}]${afterClosingBracket}`;
        }
    }
    return null;
};
exports.convertTaprootXpub = convertTaprootXpub;
//# sourceMappingURL=convertTaprootXpub.js.map