"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isChanged = exports.deepEqual = void 0;
const deepEqual = (a, b) => {
    if (a === b)
        return true;
    if (typeof a !== typeof b)
        return false;
    if (a === null || b === null)
        return false;
    if (typeof a !== 'object')
        return false;
    if (Array.isArray(a) !== Array.isArray(b))
        return false;
    if (Array.isArray(a)) {
        if (a.length !== b.length)
            return false;
        for (let i = 0; i < a.length; i++) {
            if (!(0, exports.deepEqual)(a[i], b[i]))
                return false;
        }
        return true;
    }
    const keysA = Object.keys(a);
    const keysB = Object.keys(b);
    if (keysA.length !== keysB.length)
        return false;
    for (const key of keysA) {
        if (!Object.prototype.hasOwnProperty.call(b, key))
            return false;
        if (!(0, exports.deepEqual)(a[key], b[key]))
            return false;
    }
    return true;
};
exports.deepEqual = deepEqual;
const isChanged = (prev, current, filter) => {
    if (prev === current)
        return false;
    if (!prev || !current)
        return true;
    const prevType = Object.prototype.toString.call(prev);
    const currentType = Object.prototype.toString.call(current);
    if (prevType !== currentType)
        return true;
    if (currentType === '[object Array]') {
        if (prev.length !== current.length)
            return true;
        for (let i = 0; i < current.length; i++) {
            if ((0, exports.isChanged)(prev[i], current[i], filter))
                return true;
        }
    }
    else if (currentType === '[object Object]') {
        const prevKeys = Object.keys(prev);
        const currentKeys = Object.keys(current);
        if (prevKeys.length !== currentKeys.length)
            return true;
        const prevDifference = prevKeys.find(k => currentKeys.indexOf(k) < 0);
        if (prevDifference)
            return true;
        for (let i = 0; i < currentKeys.length; i++) {
            const key = currentKeys[i];
            if (filter &&
                Object.prototype.hasOwnProperty.call(filter, key) &&
                prev[key] &&
                current[key]) {
                const prevFiltered = {};
                const currentFiltered = {};
                for (let i2 = 0; i2 < filter[key].length; i2++) {
                    const field = filter[key][i2];
                    prevFiltered[field] = prev[key][field];
                    currentFiltered[field] = current[key][field];
                }
                if ((0, exports.isChanged)(prevFiltered, currentFiltered))
                    return true;
            }
            else if ((0, exports.isChanged)(prev[key], current[key])) {
                return true;
            }
        }
    }
    else if (prev !== current) {
        return true;
    }
    return false;
};
exports.isChanged = isChanged;
//# sourceMappingURL=comparison.js.map