"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.exhaustive = void 0;
class UnreachableCaseError extends Error {
    constructor(val, message) {
        super(`${message}: [${JSON.stringify(val)}]`);
    }
}
const exhaustive = (unhandledCase, message = 'Unreachable case') => {
    throw new UnreachableCaseError(unhandledCase, message);
};
exports.exhaustive = exhaustive;
//# sourceMappingURL=exhaustive.js.map