"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.readMessageBuffer = void 0;
const utils_1 = require("@trezor/utils");
const result_1 = require("./result");
const errors_1 = require("../errors");
const readMessageBuffer = () => {
    const readBuffer = {};
    const readRequests = {};
    const onMessage = (path, data) => {
        if (readRequests[path]) {
            readRequests[path].resolve((0, result_1.success)(data));
            delete readRequests[path];
        }
        else {
            if (!readBuffer[path]) {
                readBuffer[path] = [];
            }
            readBuffer[path].push(data);
        }
    };
    const read = (path, signal) => {
        const bufferMessage = readBuffer[path]?.shift();
        if (bufferMessage) {
            return Promise.resolve((0, result_1.success)(bufferMessage));
        }
        if (readRequests[path]) {
            return readRequests[path].promise;
        }
        const dfd = (0, utils_1.createDeferred)();
        readRequests[path] = dfd;
        const abortListener = () => {
            dfd.resolve((0, result_1.error)({ error: errors_1.ABORTED_BY_SIGNAL }));
        };
        signal?.addEventListener('abort', abortListener);
        return dfd.promise.finally(() => {
            signal?.removeEventListener('abort', abortListener);
            delete readRequests[path];
        });
    };
    const cancelRead = (path) => {
        if (readRequests[path]) {
            readRequests[path].resolve((0, result_1.error)({ error: errors_1.INTERFACE_DATA_TRANSFER }));
        }
        delete readRequests[path];
        delete readBuffer[path];
    };
    return {
        onMessage,
        read,
        cancelRead,
    };
};
exports.readMessageBuffer = readMessageBuffer;
//# sourceMappingURL=readMessageBuffer.js.map