"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.generate = generate;
exports.generateForFile = generateForFile;
const tslib_1 = require("tslib");
const Codegen = tslib_1.__importStar(require("@sinclair/typebox-codegen/typescript"));
const fs_1 = tslib_1.__importDefault(require("fs"));
function generate(code) {
    code = code.replace(/typeof undefined/g, 'undefined');
    code = code.replace(/keyof typeof/g, 'keyof');
    let helpers = '';
    const helpersIndex = code.indexOf('// @COPY');
    if (helpersIndex >= 0) {
        helpers = code.substring(helpersIndex);
        code = code.substring(0, helpersIndex);
    }
    const customTypesMapping = {
        ArrayBuffer: 'Type.ArrayBuffer()',
        Buffer: 'Type.Buffer()',
        UintType: 'Type.Uint()',
        SintType: 'Type.Uint({ allowNegative: true })',
    };
    const customTypePlaceholder = Object.keys(customTypesMapping).map(t => `type ${t} = any;`);
    let output = Codegen.TypeScriptToTypeBox.Generate(customTypePlaceholder + code, {
        useTypeBoxImport: false,
        useIdentifiers: true,
    });
    const lastKey = Object.keys(customTypesMapping)[Object.keys(customTypesMapping).length - 1];
    const index = output.lastIndexOf(`const ${lastKey} = `);
    const blankLineIndex = output.indexOf('\n\n', index);
    output = output.substring(blankLineIndex + 1);
    Object.entries(customTypesMapping).forEach(([key, value]) => {
        output = output.replace(new RegExp(`\\b${key}\\b`, 'g'), value);
    });
    const enums = [...output.matchAll(/enum Enum(\w+) {/g)].map(m => m[1]);
    enums.forEach(e => {
        output = output.replace(new RegExp(`\\b${e}\\b`, 'g'), `Enum${e}`);
        output = output.replace(new RegExp(`type Enum${e} = Static\\<typeof Enum${e}\\>`, 'g'), `type Enum${e} = Static<typeof Enum${e}>`);
        output = output.replace(new RegExp(`const Enum${e} = Type\\.Enum\\(Enum${e}\\)`, 'g'), `const Enum${e} = Type.Enum(${e})`);
        output = output.replace(new RegExp(`enum Enum${e} \\{`, 'g'), `enum ${e} {`);
        output = output.replace(new RegExp(`Type\\.KeyOf\\(Enum${e}(,?.*)\\)`, 'g'), `Type.KeyOfEnum(${e}$1)`);
    });
    output = `import { Type, Static, CloneType } from '@trezor/schema-utils';\n\n${output}`;
    output = `/* eslint-disable camelcase */\n${output}`;
    if (output.indexOf('export type MessageType =') > -1) {
        output = `${output}\n\n${helpers}`;
    }
    return output;
}
function generateForFile(fileName) {
    const code = fs_1.default.readFileSync(fileName, 'utf-8');
    return generate(code);
}
if (require.main === module) {
    const fileName = process.argv[2];
    if (!fileName || !fs_1.default.existsSync(fileName)) {
        throw new Error('File not found');
    }
    const output = generateForFile(fileName);
    process.stdout.write(output);
}
//# sourceMappingURL=codegen.js.map