"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getProtobufDefinitions = void 0;
const getProtobufDefinitions = () => ({
    ThpPairingMethod: { values: { SkipPairing: 1, CodeEntry: 2, QrCode: 3, NFC: 4 } },
    ThpDeviceProperties: {
        fields: {
            internal_model: { rule: 'required', type: 'string', id: 1 },
            model_variant: { type: 'uint32', id: 2, options: { default: 0 } },
            protocol_version_major: { rule: 'required', type: 'uint32', id: 3 },
            protocol_version_minor: { rule: 'required', type: 'uint32', id: 4 },
            pairing_methods: {
                rule: 'repeated',
                type: 'ThpPairingMethod',
                id: 5,
                options: { packed: false },
            },
        },
    },
    ThpHandshakeCompletionReqNoisePayload: {
        fields: { host_pairing_credential: { type: 'bytes', id: 1 } },
    },
    ThpCreateNewSession: {
        fields: {
            passphrase: { type: 'string', id: 1 },
            on_device: { type: 'bool', id: 2, options: { default: false } },
            derive_cardano: { type: 'bool', id: 3, options: { default: false } },
        },
    },
    ThpPairingRequest: {
        fields: { host_name: { type: 'string', id: 1 }, app_name: { type: 'string', id: 2 } },
    },
    ThpPairingRequestApproved: { fields: {} },
    ThpSelectMethod: {
        fields: { selected_pairing_method: { rule: 'required', type: 'ThpPairingMethod', id: 1 } },
    },
    ThpPairingPreparationsFinished: { fields: {} },
    ThpCodeEntryCommitment: { fields: { commitment: { rule: 'required', type: 'bytes', id: 1 } } },
    ThpCodeEntryChallenge: { fields: { challenge: { rule: 'required', type: 'bytes', id: 1 } } },
    ThpCodeEntryCpaceTrezor: {
        fields: { cpace_trezor_public_key: { rule: 'required', type: 'bytes', id: 1 } },
    },
    ThpCodeEntryCpaceHostTag: {
        fields: {
            cpace_host_public_key: { rule: 'required', type: 'bytes', id: 1 },
            tag: { rule: 'required', type: 'bytes', id: 2 },
        },
    },
    ThpCodeEntrySecret: { fields: { secret: { rule: 'required', type: 'bytes', id: 1 } } },
    ThpQrCodeTag: { fields: { tag: { rule: 'required', type: 'bytes', id: 1 } } },
    ThpQrCodeSecret: { fields: { secret: { rule: 'required', type: 'bytes', id: 1 } } },
    ThpNfcTagHost: { fields: { tag: { rule: 'required', type: 'bytes', id: 1 } } },
    ThpNfcTagTrezor: { fields: { tag: { rule: 'required', type: 'bytes', id: 1 } } },
    ThpCredentialRequest: {
        fields: {
            host_static_public_key: { rule: 'required', type: 'bytes', id: 1 },
            autoconnect: { type: 'bool', id: 2, options: { default: false } },
            credential: { type: 'bytes', id: 3 },
        },
    },
    ThpCredentialResponse: {
        fields: {
            trezor_static_public_key: { rule: 'required', type: 'bytes', id: 1 },
            credential: { rule: 'required', type: 'bytes', id: 2 },
        },
    },
    ThpEndRequest: { fields: {} },
    ThpEndResponse: { fields: {} },
    MessageType: {
        options: { '(has_bitcoin_only_values)': true, '(wire_enum)': true },
        values: {
            ThpCreateNewSession: 1000,
            ThpCredentialRequest: 1016,
            ThpCredentialResponse: 1017,
            ThpPairingRequest: 1008,
            ThpPairingRequestApproved: 1009,
            ThpSelectMethod: 1010,
            ThpPairingPreparationsFinished: 1011,
            ThpEndRequest: 1018,
            ThpEndResponse: 1019,
            ThpCodeEntryCommitment: 1024,
            ThpCodeEntryChallenge: 1025,
            ThpCodeEntryCpaceTrezor: 1026,
            ThpCodeEntryCpaceHostTag: 1027,
            ThpCodeEntrySecret: 1028,
            ThpQrCodeTag: 1032,
            ThpQrCodeSecret: 1033,
            ThpNfcTagHost: 1040,
            ThpNfcTagTrezor: 1041,
        },
    },
});
exports.getProtobufDefinitions = getProtobufDefinitions;
//# sourceMappingURL=protobufDefinitions.js.map