"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getBootloaderVersion = exports.getBootloaderHash = void 0;
const modeUtils_1 = require("./modeUtils");
const getBootloaderHash = (device) => device?.features?.bootloader_hash || '';
exports.getBootloaderHash = getBootloaderHash;
const getBootloaderVersion = (device) => {
    if (!device?.features) {
        return '';
    }
    const { features } = device;
    if ((0, modeUtils_1.isDeviceInBootloaderMode)(device) && features.major_version) {
        return `${features.major_version}.${features.minor_version}.${features.patch_version}`;
    }
    return '';
};
exports.getBootloaderVersion = getBootloaderVersion;
//# sourceMappingURL=bootloaderUtils.js.map