"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createUiPromiseManager = void 0;
const utils_1 = require("@trezor/utils");
const events_1 = require("../events");
const createUiPromiseManager = (interactionTimeout) => {
    let _uiPromises = [];
    const exists = (type) => _uiPromises.some(p => p.id === type);
    const create = (promiseEvent, device) => {
        const uiPromise = {
            ...(0, utils_1.createDeferred)(promiseEvent),
            device,
        };
        _uiPromises.push(uiPromise);
        interactionTimeout();
        return uiPromise;
    };
    const resolve = (event) => {
        const uiPromise = _uiPromises.find(p => p.id === event.type);
        if (!uiPromise)
            return false;
        uiPromise.resolve(event);
        _uiPromises = _uiPromises.filter(p => p !== uiPromise);
        return true;
    };
    const rejectAll = (error) => {
        _uiPromises.forEach(p => p.reject(error));
        _uiPromises = [];
    };
    const disconnected = (devicePath) => {
        const [toResolve, toKeep] = (0, utils_1.arrayPartition)(_uiPromises, (p) => p.device?.getUniquePath() === devicePath && p.id === events_1.DEVICE.DISCONNECT);
        toResolve.forEach(p => p.resolve({ type: events_1.DEVICE.DISCONNECT }));
        _uiPromises = toKeep;
        return !!toResolve.length || toKeep.some(p => p.device?.getUniquePath() === devicePath);
    };
    const get = (type) => {
        const uiPromise = _uiPromises.find(p => p.id === type);
        return uiPromise?.promise ?? Promise.reject(new Error(`UiPromise ${type} doesn't exist`));
    };
    const clear = () => {
        _uiPromises = [];
    };
    return { exists, create, resolve, rejectAll, disconnected, get, clear };
};
exports.createUiPromiseManager = createUiPromiseManager;
//# sourceMappingURL=uiPromiseManager.js.map