"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CardanoComposeTransactionParamsSchema = exports.AccountAddress = void 0;
const schema_utils_1 = require("@trezor/schema-utils");
const exports_1 = require("../../exports");
const params_1 = require("../params");
const cardano_1 = require("./cardano");
exports.AccountAddress = schema_utils_1.Type.Object({
    address: schema_utils_1.Type.String(),
    path: schema_utils_1.Type.String(),
    transfers: schema_utils_1.Type.Number(),
    balance: schema_utils_1.Type.Optional(schema_utils_1.Type.String()),
    sent: schema_utils_1.Type.Optional(schema_utils_1.Type.String()),
    received: schema_utils_1.Type.Optional(schema_utils_1.Type.String()),
}, {
    $id: 'AccountAddress',
});
exports.CardanoComposeTransactionParamsSchema = schema_utils_1.Type.Object({
    account: schema_utils_1.Type.Object({
        descriptor: schema_utils_1.Type.String(),
        utxo: schema_utils_1.Type.Array(schema_utils_1.Type.Object({
            txid: schema_utils_1.Type.String(),
            vout: schema_utils_1.Type.Number(),
            amount: schema_utils_1.Type.String(),
            blockHeight: schema_utils_1.Type.Number(),
            address: schema_utils_1.Type.String(),
            path: schema_utils_1.Type.String(),
            confirmations: schema_utils_1.Type.Number(),
            coinbase: schema_utils_1.Type.Optional(schema_utils_1.Type.Boolean()),
            cardanoSpecific: schema_utils_1.Type.Optional(schema_utils_1.Type.Object({
                unit: schema_utils_1.Type.String(),
            })),
        }, { $id: 'AccountUtxo' })),
    }),
    feeLevels: schema_utils_1.Type.Optional(schema_utils_1.Type.Array(schema_utils_1.Type.Object({
        feePerUnit: schema_utils_1.Type.Optional(schema_utils_1.Type.String()),
    }))),
    outputs: schema_utils_1.Type.Optional(schema_utils_1.Type.Array(schema_utils_1.Type.Intersect([
        schema_utils_1.Type.Object({
            isChange: schema_utils_1.Type.Optional(schema_utils_1.Type.Boolean()),
            assets: schema_utils_1.Type.Array(schema_utils_1.Type.Object({
                unit: schema_utils_1.Type.String(),
                quantity: schema_utils_1.Type.String(),
            })),
        }, { $id: 'BaseOutput' }),
        schema_utils_1.Type.Union([
            schema_utils_1.Type.Object({
                address: schema_utils_1.Type.String(),
                amount: schema_utils_1.Type.String(),
                setMax: schema_utils_1.Type.Optional(schema_utils_1.Type.Literal(false)),
            }, { $id: 'ExternalOutput' }),
            schema_utils_1.Type.Object({
                address: schema_utils_1.Type.Optional(schema_utils_1.Type.String()),
                amount: schema_utils_1.Type.Optional(schema_utils_1.Type.String()),
                setMax: schema_utils_1.Type.Boolean(),
            }, { $id: 'ExternalOutputIncomplete' }),
        ]),
    ], { $id: 'UserOutput' }))),
    certificates: schema_utils_1.Type.Optional(schema_utils_1.Type.Array(cardano_1.CardanoCertificate)),
    withdrawals: schema_utils_1.Type.Optional(schema_utils_1.Type.Array(schema_utils_1.Type.Object({
        stakeAddress: schema_utils_1.Type.String(),
        amount: schema_utils_1.Type.String(),
    }, { $id: 'Withdrawal' }))),
    changeAddress: schema_utils_1.Type.Object({
        address: schema_utils_1.Type.String(),
        path: schema_utils_1.Type.String(),
    }),
    addressParameters: schema_utils_1.Type.Object({
        addressType: exports_1.PROTO.EnumCardanoAddressType,
        path: params_1.DerivationPath,
        stakingPath: schema_utils_1.Type.Optional(params_1.DerivationPath),
        stakingKeyHash: schema_utils_1.Type.Optional(schema_utils_1.Type.String()),
        certificatePointer: schema_utils_1.Type.Optional(cardano_1.CardanoCertificatePointer),
    }, { $id: 'CardanoAddressParameters' }),
    testnet: schema_utils_1.Type.Optional(schema_utils_1.Type.Boolean()),
});
const _params = {};
const _paramsOld = {};
[_params, _paramsOld];
//# sourceMappingURL=cardanoComposeTransaction.js.map