import { Static } from '@trezor/schema-utils';
import { PROTO } from '../../constants';
import type { Params, Response } from '../params';
export type AuthorizeCoinjoin = Static<typeof AuthorizeCoinjoin>;
export declare const AuthorizeCoinjoin: import("@trezor/schema-utils").TObject<{
    path: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TString, import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>]>;
    coordinator: import("@trezor/schema-utils").TString;
    maxRounds: import("@trezor/schema-utils").TNumber;
    maxCoordinatorFeeRate: import("@trezor/schema-utils").TNumber;
    maxFeePerKvbyte: import("@trezor/schema-utils").TNumber;
    coin: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    scriptType: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TLiteral<"SPENDADDRESS">, import("@trezor/schema-utils").TLiteral<"SPENDMULTISIG">, import("@trezor/schema-utils").TLiteral<"SPENDWITNESS">, import("@trezor/schema-utils").TLiteral<"SPENDP2SHWITNESS">, import("@trezor/schema-utils").TLiteral<"SPENDTAPROOT">]>>;
    amountUnit: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TEnum<typeof PROTO.AmountUnit>>;
    preauthorized: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
}>;
export declare function authorizeCoinjoin(params: Params<AuthorizeCoinjoin>): Response<PROTO.Success>;
//# sourceMappingURL=authorizeCoinjoin.d.ts.map