import { Static } from '@trezor/schema-utils';
import { PROTO } from '../../constants';
import type { Params, Response } from '../params';
export type ApplySettings = Static<typeof ApplySettings>;
export declare const ApplySettings: import("@trezor/schema-utils").TObject<{
    language: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    label: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    passphrase_always_on_device: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
    safety_checks: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils/lib/custom-types/keyof-enum").TKeyOfEnum<typeof PROTO.Enum_SafetyCheckLevel>>;
    auto_lock_delay_ms: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
    display_rotation: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils/lib/custom-types/keyof-enum").TKeyOfEnum<typeof PROTO.Enum_DisplayRotation>, import("@trezor/schema-utils").TEnum<typeof PROTO.Enum_DisplayRotation>]>>;
    experimental_features: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
    hide_passphrase_from_host: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
    haptic_feedback: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
    use_passphrase: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
    homescreen: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    _passphrase_source: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
    homescreen_length: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
    passphrase_source: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
}>;
export declare function applySettings(params: Params<ApplySettings>): Response<PROTO.Success>;
//# sourceMappingURL=applySettings.d.ts.map