"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.calculateRevisionForDevice = void 0;
const versionUtils_1 = require("@trezor/utils/lib/versionUtils");
const calculateRevisionForDevice = ({ commitRevision, version, }) => {
    if ((0, versionUtils_1.isNewer)(version, '2.4.0')) {
        return commitRevision;
    }
    if ((0, versionUtils_1.isNewer)(version, '2.2.0')) {
        return commitRevision.slice(0, 9);
    }
    if ((0, versionUtils_1.isNewer)(version, '2.1.8')) {
        return commitRevision;
    }
    if ((0, versionUtils_1.isNewer)(version, '2.0.0')) {
        return commitRevision.slice(0, 8);
    }
    return commitRevision;
};
exports.calculateRevisionForDevice = calculateRevisionForDevice;
//# sourceMappingURL=calculateRevisionForDevice.js.map