import { PROTO } from '../../constants';
import { TezosOperation } from '../../types/api/tezos';
export declare const createTx: (address_n: number[], branch: string, operation: TezosOperation, chunkify?: boolean) => {
    chunkify?: boolean | undefined;
    transaction?: {
        parameters?: number[] | undefined;
        parameters_manager?: {
            transfer?: {
                amount: string | number;
                destination: {
                    hash: Uint8Array<ArrayBufferLike>;
                    tag: number;
                };
            } | undefined;
            set_delegate?: Uint8Array<ArrayBufferLike> | undefined;
            cancel_delegate?: boolean | undefined;
        } | undefined;
        fee: string | number;
        amount: string | number;
        destination: {
            hash: Uint8Array<ArrayBufferLike>;
            tag: number;
        };
        source: Uint8Array<ArrayBufferLike>;
        counter: number;
        gas_limit: number;
        storage_limit: number;
    } | undefined;
    reveal?: {
        fee: string | number;
        public_key: Uint8Array<ArrayBufferLike>;
        source: Uint8Array<ArrayBufferLike>;
        counter: number;
        gas_limit: number;
        storage_limit: number;
    } | undefined;
    origination?: {
        delegate?: Uint8Array<ArrayBufferLike> | undefined;
        manager_pubkey?: string | undefined;
        spendable?: boolean | undefined;
        delegatable?: boolean | undefined;
        fee: string | number;
        script: string | number[];
        balance: number;
        source: Uint8Array<ArrayBufferLike>;
        counter: number;
        gas_limit: number;
        storage_limit: number;
    } | undefined;
    delegation?: {
        fee: string | number;
        source: Uint8Array<ArrayBufferLike>;
        counter: number;
        gas_limit: number;
        storage_limit: number;
        delegate: Uint8Array<ArrayBufferLike>;
    } | undefined;
    proposal?: {
        source: string;
        period: number;
        proposals: string[];
    } | undefined;
    ballot?: {
        source: string;
        period: number;
        proposal: string;
        ballot: PROTO.TezosBallotType;
    } | undefined;
    address_n: number[];
    branch: Uint8Array<ArrayBufferLike>;
};
//# sourceMappingURL=tezosSignTx.d.ts.map