"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const schema_utils_1 = require("@trezor/schema-utils");
const AbstractMethod_1 = require("../../../core/AbstractMethod");
const coinInfo_1 = require("../../../data/coinInfo");
const ripple_1 = require("../../../types/api/ripple");
const pathUtils_1 = require("../../../utils/pathUtils");
const paramsValidator_1 = require("../../common/paramsValidator");
class RippleSignTransaction extends AbstractMethod_1.AbstractMethod {
    init() {
        this.requiredPermissions = ['read', 'write'];
        this.requiredDeviceCapabilities = ['Capability_Ripple'];
        this.firmwareRange = (0, paramsValidator_1.getFirmwareRange)(this.name, (0, coinInfo_1.getMiscNetwork)('Ripple'), this.firmwareRange);
        const { payload } = this;
        (0, schema_utils_1.AssertWeak)(ripple_1.RippleSignTransaction, payload);
        const path = (0, pathUtils_1.validatePath)(payload.path, 5);
        const { transaction, chunkify } = payload;
        this.params = {
            address_n: path,
            fee: transaction.fee,
            flags: transaction.flags,
            sequence: transaction.sequence,
            last_ledger_sequence: transaction.maxLedgerVersion,
            payment: {
                amount: transaction.payment.amount,
                destination: transaction.payment.destination,
                destination_tag: transaction.payment.destinationTag,
            },
            chunkify: typeof chunkify === 'boolean' ? chunkify : false,
        };
    }
    get info() {
        return 'Sign Ripple transaction';
    }
    async run() {
        const cmd = this.device.getCommands();
        const { message } = await cmd.typedCall('RippleSignTx', 'RippleSignedTx', this.params);
        return {
            serializedTx: message.serialized_tx,
            signature: message.signature,
        };
    }
}
exports.default = RippleSignTransaction;
//# sourceMappingURL=rippleSignTransaction.js.map