"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const schema_utils_1 = require("@trezor/schema-utils");
const constants_1 = require("../constants");
const AbstractMethod_1 = require("../core/AbstractMethod");
const events_1 = require("../events");
const paramsValidator_1 = require("./common/paramsValidator");
class LoadDevice extends AbstractMethod_1.AbstractMethod {
    init() {
        this.allowDeviceMode = [events_1.UI.INITIALIZE];
        this.useDeviceState = false;
        this.requiredPermissions = ['management'];
        this.skipFinalReload = false;
        this.firmwareRange = (0, paramsValidator_1.getFirmwareRange)(this.name, null, this.firmwareRange);
        const { payload } = this;
        (0, schema_utils_1.Assert)(constants_1.PROTO.LoadDevice, payload);
        this.params = {
            mnemonics: payload.mnemonics,
            pin: payload.pin,
            passphrase_protection: payload.passphrase_protection,
            language: payload.language,
            label: payload.label,
            skip_checksum: payload.skip_checksum,
            u2f_counter: payload.u2f_counter,
            needs_backup: payload.needs_backup,
            no_backup: payload.no_backup,
        };
    }
    get info() {
        return 'Load seed and related internal settings.';
    }
    get confirmation() {
        return {
            view: 'device-management',
            label: 'Do you really you want to load device?',
        };
    }
    async run() {
        const cmd = this.device.getCommands();
        const response = await cmd.typedCall('LoadDevice', 'Success', this.params);
        return response.message;
    }
}
exports.default = LoadDevice;
//# sourceMappingURL=loadDevice.js.map