import { AbstractMethod } from '../core/AbstractMethod';
export default class GetFeatures extends AbstractMethod<'getFeatures'> {
    init(): void;
    run(): Promise<{
        busy?: boolean | undefined;
        _passphrase_cached?: boolean | undefined;
        homescreen_format?: "Toif" | "Jpeg" | "ToiG" | undefined;
        hide_passphrase_from_host?: boolean | undefined;
        unit_color?: number | undefined;
        unit_btconly?: boolean | undefined;
        homescreen_width?: number | undefined;
        homescreen_height?: number | undefined;
        bootloader_locked?: boolean | undefined;
        language_version_matches?: boolean | undefined;
        unit_packaging?: number | undefined;
        haptic_feedback?: boolean | undefined;
        recovery_type?: "NormalRecovery" | "DryRun" | "UnlockRepeatedBackup" | undefined;
        optiga_sec?: number | undefined;
        soc?: number | undefined;
        vendor: string;
        major_version: number;
        minor_version: number;
        patch_version: number;
        bootloader_mode: boolean | null;
        device_id: string | null;
        pin_protection: boolean | null;
        passphrase_protection: boolean | null;
        language: string | null;
        label: string | null;
        initialized: boolean | null;
        revision: string | null;
        bootloader_hash: string | null;
        imported: boolean | null;
        unlocked: boolean | null;
        firmware_present: boolean | null;
        backup_availability: "NotAvailable" | "Required" | "Available" | null;
        flags: number | null;
        model: string;
        fw_major: number | null;
        fw_minor: number | null;
        fw_patch: number | null;
        fw_vendor: string | null;
        unfinished_backup: boolean | null;
        no_backup: boolean | null;
        recovery_status: "Nothing" | "Recovery" | "Backup" | null;
        capabilities: ("Capability_Bitcoin" | "Capability_Bitcoin_like" | "Capability_Binance" | "Capability_Cardano" | "Capability_Crypto" | "Capability_EOS" | "Capability_Ethereum" | "Capability_Lisk" | "Capability_Monero" | "Capability_NEM" | "Capability_Ripple" | "Capability_Stellar" | "Capability_Tezos" | "Capability_U2F" | "Capability_Shamir" | "Capability_ShamirGroups" | "Capability_PassphraseEntry" | "Capability_Solana" | "Capability_Translations" | "Capability_Brightness" | "Capability_Haptic" | "Capability_BLE" | "Capability_NFC")[];
        backup_type: "Bip39" | "Slip39_Basic" | "Slip39_Advanced" | "Slip39_Single_Extendable" | "Slip39_Basic_Extendable" | "Slip39_Advanced_Extendable" | null;
        sd_card_present: boolean | null;
        sd_protection: boolean | null;
        wipe_code_protection: boolean | null;
        session_id: string | null;
        passphrase_always_on_device: boolean | null;
        safety_checks: "Strict" | "PromptAlways" | "PromptTemporarily" | null;
        auto_lock_delay_ms: number | null;
        display_rotation: "North" | "East" | "South" | "West" | null;
        experimental_features: boolean | null;
        internal_model: import("@trezor/protobuf/lib/messages-schema").DeviceModelInternal;
    }>;
}
//# sourceMappingURL=getFeatures.d.ts.map