import { Client } from 'xrpl';
import type * as MessageTypes from '@trezor/blockchain-link-types/lib/messages';
import { TimerId } from '@trezor/type-utils';
import { BaseWorker } from '../baseWorker';
declare class RippleWorker extends BaseWorker<Client> {
    pingTimeout?: TimerId;
    cleanup(): void;
    protected isConnected(client: Client | undefined): client is Client;
    tryConnect(url: string): Promise<Client>;
    disconnect(): Promise<void>;
    messageHandler(event: {
        data: MessageTypes.Message;
    }): Promise<true | undefined>;
    setPingTimeout(): void;
    onPing(): Promise<void>;
}
export default function Ripple(): RippleWorker;
export {};
//# sourceMappingURL=index.d.ts.map