"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TorSocket = void 0;
const base_1 = require("./base");
class TorSocket extends base_1.SocketBase {
    proxyAgent;
    constructor({ proxyAgent, ...rest }) {
        super(rest);
        this.proxyAgent = proxyAgent;
    }
    async openSocket(listener) {
        const { host, port } = this;
        const socket = await this.proxyAgent
            .connect(null, { host, port, timeout: this.timeout, secureEndpoint: false })
            .catch(e => {
            listener.onError(e);
            throw e;
        });
        listener.onConnect();
        this.configureSocket(socket);
        this.bindSocket(socket, listener);
        return socket;
    }
}
exports.TorSocket = TorSocket;
//# sourceMappingURL=tor.js.map