"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const utils_1 = require("@trezor/utils");
const utxo_lib_1 = require("@trezor/utxo-lib");
const utils_2 = require("../utils");
const transformUtxo = (currentHeight, addressInfo = {}) => ({ height, tx_hash, tx_pos, value }) => ({
    txid: tx_hash,
    vout: tx_pos,
    amount: value.toString(),
    address: '',
    path: '',
    ...addressInfo,
    ...(height
        ? {
            blockHeight: height,
            confirmations: currentHeight - height + 1,
        }
        : {
            blockHeight: -1,
            confirmations: 0,
        }),
});
const getAccountUtxo = async (client, descriptor) => {
    const { block: { height }, network, } = client.getInfo() || (0, utils_1.throwError)('Client not initialized');
    const parsed = (0, utils_2.tryGetScripthash)(descriptor, network);
    if (parsed.valid) {
        const utxos = await client.request('blockchain.scripthash.listunspent', parsed.scripthash);
        return utxos.map(transformUtxo(height));
    }
    const discover = (0, utils_2.discoverAddress)(client);
    const receive = await (0, utxo_lib_1.discovery)(discover, descriptor, 'receive', network);
    const change = await (0, utxo_lib_1.discovery)(discover, descriptor, 'change', network);
    const result = await Promise.all(receive
        .concat(change)
        .filter(a => a.history.length)
        .map(({ address, path, scripthash }) => client
        .request('blockchain.scripthash.listunspent', scripthash)
        .then(utxos => utxos.map(transformUtxo(height, { address, path }))))).then(res => res.flat());
    return result;
};
exports.default = getAccountUtxo;
//# sourceMappingURL=getAccountUtxo.js.map