/**
 * This code was AUTOGENERATED using the codama library.
 * Please DO NOT EDIT THIS FILE, instead use visitors
 * to add features, then rerun codama to update it.
 *
 * @see https://github.com/codama-idl/codama
 */
import { type Address, type Codec, type Decoder, type Encoder, type IAccountMeta, type IAccountSignerMeta, type IInstruction, type IInstructionWithAccounts, type IInstructionWithData, type ReadonlyAccount, type ReadonlySignerAccount, type TransactionSigner, type WritableAccount } from '@solana/kit';
import { TOKEN_2022_PROGRAM_ADDRESS } from '../programs';
import { type DecryptableBalance, type DecryptableBalanceArgs } from '../types';
export declare const CONFIDENTIAL_TRANSFER_WITH_FEE_DISCRIMINATOR = 27;
export declare function getConfidentialTransferWithFeeDiscriminatorBytes(): import("@solana/kit").ReadonlyUint8Array;
export declare const CONFIDENTIAL_TRANSFER_WITH_FEE_CONFIDENTIAL_TRANSFER_DISCRIMINATOR = 13;
export declare function getConfidentialTransferWithFeeConfidentialTransferDiscriminatorBytes(): import("@solana/kit").ReadonlyUint8Array;
export type ConfidentialTransferWithFeeInstruction<TProgram extends string = typeof TOKEN_2022_PROGRAM_ADDRESS, TAccountSourceToken extends string | IAccountMeta<string> = string, TAccountMint extends string | IAccountMeta<string> = string, TAccountDestinationToken extends string | IAccountMeta<string> = string, TAccountInstructionsSysvar extends string | IAccountMeta<string> = string, TAccountEqualityRecord extends string | IAccountMeta<string> = string, TAccountTransferAmountCiphertextValidityRecord extends string | IAccountMeta<string> = string, TAccountFeeSigmaRecord extends string | IAccountMeta<string> = string, TAccountFeeCiphertextValidityRecord extends string | IAccountMeta<string> = string, TAccountRangeRecord extends string | IAccountMeta<string> = string, TAccountAuthority extends string | IAccountMeta<string> = string, TRemainingAccounts extends readonly IAccountMeta<string>[] = []> = IInstruction<TProgram> & IInstructionWithData<Uint8Array> & IInstructionWithAccounts<[
    TAccountSourceToken extends string ? WritableAccount<TAccountSourceToken> : TAccountSourceToken,
    TAccountMint extends string ? ReadonlyAccount<TAccountMint> : TAccountMint,
    TAccountDestinationToken extends string ? WritableAccount<TAccountDestinationToken> : TAccountDestinationToken,
    TAccountInstructionsSysvar extends string ? ReadonlyAccount<TAccountInstructionsSysvar> : TAccountInstructionsSysvar,
    TAccountEqualityRecord extends string ? ReadonlyAccount<TAccountEqualityRecord> : TAccountEqualityRecord,
    TAccountTransferAmountCiphertextValidityRecord extends string ? ReadonlyAccount<TAccountTransferAmountCiphertextValidityRecord> : TAccountTransferAmountCiphertextValidityRecord,
    TAccountFeeSigmaRecord extends string ? ReadonlyAccount<TAccountFeeSigmaRecord> : TAccountFeeSigmaRecord,
    TAccountFeeCiphertextValidityRecord extends string ? ReadonlyAccount<TAccountFeeCiphertextValidityRecord> : TAccountFeeCiphertextValidityRecord,
    TAccountRangeRecord extends string ? ReadonlyAccount<TAccountRangeRecord> : TAccountRangeRecord,
    TAccountAuthority extends string ? ReadonlyAccount<TAccountAuthority> : TAccountAuthority,
    ...TRemainingAccounts
]>;
export type ConfidentialTransferWithFeeInstructionData = {
    discriminator: number;
    confidentialTransferDiscriminator: number;
    /** The new source decryptable balance if the transfer succeeds. */
    newSourceDecryptableAvailableBalance: DecryptableBalance;
    /**
     * Relative location of the
     * `ProofInstruction::VerifyCiphertextCommitmentEquality` instruction
     * to the `TransferWithFee` instruction in the transaction. If the offset
     * is `0`, then use a context state account for the proof.
     */
    equalityProofInstructionOffset: number;
    /**
     * Relative location of the
     * `ProofInstruction::VerifyBatchedGroupedCiphertext3HandlesValidity`
     * instruction to the `TransferWithFee` instruction in the transaction.
     * If the offset is `0`, then use a context state account for the
     * proof.
     */
    transferAmountCiphertextValidityProofInstructionOffset: number;
    /**
     * Relative location of the `ProofInstruction::VerifyPercentageWithFee`
     * instruction to the `TransferWithFee` instruction in the transaction.
     * If the offset is `0`, then use a context state account for the
     * proof.
     */
    feeSigmaProofInstructionOffset: number;
    /**
     * Relative location of the
     * `ProofInstruction::VerifyBatchedGroupedCiphertext2HandlesValidity`
     * instruction to the `TransferWithFee` instruction in the transaction.
     * If the offset is `0`, then use a context state account for the
     * proof.
     */
    feeCiphertextValidityProofInstructionOffset: number;
    /**
     * Relative location of the `ProofInstruction::BatchedRangeProofU256Data`
     * instruction to the `TransferWithFee` instruction in the transaction.
     * If the offset is `0`, then use a context state account for the
     * proof.
     */
    rangeProofInstructionOffset: number;
};
export type ConfidentialTransferWithFeeInstructionDataArgs = {
    /** The new source decryptable balance if the transfer succeeds. */
    newSourceDecryptableAvailableBalance: DecryptableBalanceArgs;
    /**
     * Relative location of the
     * `ProofInstruction::VerifyCiphertextCommitmentEquality` instruction
     * to the `TransferWithFee` instruction in the transaction. If the offset
     * is `0`, then use a context state account for the proof.
     */
    equalityProofInstructionOffset: number;
    /**
     * Relative location of the
     * `ProofInstruction::VerifyBatchedGroupedCiphertext3HandlesValidity`
     * instruction to the `TransferWithFee` instruction in the transaction.
     * If the offset is `0`, then use a context state account for the
     * proof.
     */
    transferAmountCiphertextValidityProofInstructionOffset: number;
    /**
     * Relative location of the `ProofInstruction::VerifyPercentageWithFee`
     * instruction to the `TransferWithFee` instruction in the transaction.
     * If the offset is `0`, then use a context state account for the
     * proof.
     */
    feeSigmaProofInstructionOffset: number;
    /**
     * Relative location of the
     * `ProofInstruction::VerifyBatchedGroupedCiphertext2HandlesValidity`
     * instruction to the `TransferWithFee` instruction in the transaction.
     * If the offset is `0`, then use a context state account for the
     * proof.
     */
    feeCiphertextValidityProofInstructionOffset: number;
    /**
     * Relative location of the `ProofInstruction::BatchedRangeProofU256Data`
     * instruction to the `TransferWithFee` instruction in the transaction.
     * If the offset is `0`, then use a context state account for the
     * proof.
     */
    rangeProofInstructionOffset: number;
};
export declare function getConfidentialTransferWithFeeInstructionDataEncoder(): Encoder<ConfidentialTransferWithFeeInstructionDataArgs>;
export declare function getConfidentialTransferWithFeeInstructionDataDecoder(): Decoder<ConfidentialTransferWithFeeInstructionData>;
export declare function getConfidentialTransferWithFeeInstructionDataCodec(): Codec<ConfidentialTransferWithFeeInstructionDataArgs, ConfidentialTransferWithFeeInstructionData>;
export type ConfidentialTransferWithFeeInput<TAccountSourceToken extends string = string, TAccountMint extends string = string, TAccountDestinationToken extends string = string, TAccountInstructionsSysvar extends string = string, TAccountEqualityRecord extends string = string, TAccountTransferAmountCiphertextValidityRecord extends string = string, TAccountFeeSigmaRecord extends string = string, TAccountFeeCiphertextValidityRecord extends string = string, TAccountRangeRecord extends string = string, TAccountAuthority extends string = string> = {
    /** The source SPL Token account. */
    sourceToken: Address<TAccountSourceToken>;
    /** The corresponding SPL Token mint. */
    mint: Address<TAccountMint>;
    /** The destination SPL Token account. */
    destinationToken: Address<TAccountDestinationToken>;
    /**
     * (Optional) Instructions sysvar if at least one of the
     * `zk_elgamal_proof` instructions are included in the same
     * transaction.
     */
    instructionsSysvar?: Address<TAccountInstructionsSysvar>;
    /** (Optional) Equality proof record account or context state account. */
    equalityRecord?: Address<TAccountEqualityRecord>;
    /**
     * (Optional) Transfer amount ciphertext validity proof record
     * account or context state account.
     */
    transferAmountCiphertextValidityRecord?: Address<TAccountTransferAmountCiphertextValidityRecord>;
    /** (Optional) Fee sigma proof record account or context state account. */
    feeSigmaRecord?: Address<TAccountFeeSigmaRecord>;
    /** (Optional) Fee ciphertext validity proof record account or context state account. */
    feeCiphertextValidityRecord?: Address<TAccountFeeCiphertextValidityRecord>;
    /** (Optional) Range proof record account or context state account. */
    rangeRecord?: Address<TAccountRangeRecord>;
    /** The source account's owner/delegate or its multisignature account. */
    authority: Address<TAccountAuthority> | TransactionSigner<TAccountAuthority>;
    newSourceDecryptableAvailableBalance: ConfidentialTransferWithFeeInstructionDataArgs['newSourceDecryptableAvailableBalance'];
    equalityProofInstructionOffset: ConfidentialTransferWithFeeInstructionDataArgs['equalityProofInstructionOffset'];
    transferAmountCiphertextValidityProofInstructionOffset: ConfidentialTransferWithFeeInstructionDataArgs['transferAmountCiphertextValidityProofInstructionOffset'];
    feeSigmaProofInstructionOffset: ConfidentialTransferWithFeeInstructionDataArgs['feeSigmaProofInstructionOffset'];
    feeCiphertextValidityProofInstructionOffset: ConfidentialTransferWithFeeInstructionDataArgs['feeCiphertextValidityProofInstructionOffset'];
    rangeProofInstructionOffset: ConfidentialTransferWithFeeInstructionDataArgs['rangeProofInstructionOffset'];
    multiSigners?: Array<TransactionSigner>;
};
export declare function getConfidentialTransferWithFeeInstruction<TAccountSourceToken extends string, TAccountMint extends string, TAccountDestinationToken extends string, TAccountInstructionsSysvar extends string, TAccountEqualityRecord extends string, TAccountTransferAmountCiphertextValidityRecord extends string, TAccountFeeSigmaRecord extends string, TAccountFeeCiphertextValidityRecord extends string, TAccountRangeRecord extends string, TAccountAuthority extends string, TProgramAddress extends Address = typeof TOKEN_2022_PROGRAM_ADDRESS>(input: ConfidentialTransferWithFeeInput<TAccountSourceToken, TAccountMint, TAccountDestinationToken, TAccountInstructionsSysvar, TAccountEqualityRecord, TAccountTransferAmountCiphertextValidityRecord, TAccountFeeSigmaRecord, TAccountFeeCiphertextValidityRecord, TAccountRangeRecord, TAccountAuthority>, config?: {
    programAddress?: TProgramAddress;
}): ConfidentialTransferWithFeeInstruction<TProgramAddress, TAccountSourceToken, TAccountMint, TAccountDestinationToken, TAccountInstructionsSysvar, TAccountEqualityRecord, TAccountTransferAmountCiphertextValidityRecord, TAccountFeeSigmaRecord, TAccountFeeCiphertextValidityRecord, TAccountRangeRecord, (typeof input)['authority'] extends TransactionSigner<TAccountAuthority> ? ReadonlySignerAccount<TAccountAuthority> & IAccountSignerMeta<TAccountAuthority> : TAccountAuthority>;
export type ParsedConfidentialTransferWithFeeInstruction<TProgram extends string = typeof TOKEN_2022_PROGRAM_ADDRESS, TAccountMetas extends readonly IAccountMeta[] = readonly IAccountMeta[]> = {
    programAddress: Address<TProgram>;
    accounts: {
        /** The source SPL Token account. */
        sourceToken: TAccountMetas[0];
        /** The corresponding SPL Token mint. */
        mint: TAccountMetas[1];
        /** The destination SPL Token account. */
        destinationToken: TAccountMetas[2];
        /**
         * (Optional) Instructions sysvar if at least one of the
         * `zk_elgamal_proof` instructions are included in the same
         * transaction.
         */
        instructionsSysvar?: TAccountMetas[3] | undefined;
        /** (Optional) Equality proof record account or context state account. */
        equalityRecord?: TAccountMetas[4] | undefined;
        /**
         * (Optional) Transfer amount ciphertext validity proof record
         * account or context state account.
         */
        transferAmountCiphertextValidityRecord?: TAccountMetas[5] | undefined;
        /** (Optional) Fee sigma proof record account or context state account. */
        feeSigmaRecord?: TAccountMetas[6] | undefined;
        /** (Optional) Fee ciphertext validity proof record account or context state account. */
        feeCiphertextValidityRecord?: TAccountMetas[7] | undefined;
        /** (Optional) Range proof record account or context state account. */
        rangeRecord?: TAccountMetas[8] | undefined;
        /** The source account's owner/delegate or its multisignature account. */
        authority: TAccountMetas[9];
    };
    data: ConfidentialTransferWithFeeInstructionData;
};
export declare function parseConfidentialTransferWithFeeInstruction<TProgram extends string, TAccountMetas extends readonly IAccountMeta[]>(instruction: IInstruction<TProgram> & IInstructionWithAccounts<TAccountMetas> & IInstructionWithData<Uint8Array>): ParsedConfidentialTransferWithFeeInstruction<TProgram, TAccountMetas>;
//# sourceMappingURL=confidentialTransferWithFee.d.ts.map