/**
 * This code was AUTOGENERATED using the codama library.
 * Please DO NOT EDIT THIS FILE, instead use visitors
 * to add features, then rerun codama to update it.
 *
 * @see https://github.com/codama-idl/codama
 */
import { fetchEncodedAccount, fetchEncodedAccounts, type Account, type Address, type Codec, type Decoder, type EncodedAccount, type Encoder, type FetchAccountConfig, type FetchAccountsConfig, type MaybeAccount, type MaybeEncodedAccount, type Option, type OptionOrNullable } from '@solana/kit';
import { type Extension, type ExtensionArgs } from '../types';
export type Mint = {
    /**
     * Optional authority used to mint new tokens. The mint authority may only
     * be provided during mint creation. If no mint authority is present
     * then the mint has a fixed supply and no further tokens may be minted.
     */
    mintAuthority: Option<Address>;
    /** Total supply of tokens. */
    supply: bigint;
    /** Number of base 10 digits to the right of the decimal place. */
    decimals: number;
    /** Is `true` if this structure has been initialized. */
    isInitialized: boolean;
    /** Optional authority to freeze token accounts. */
    freezeAuthority: Option<Address>;
    /** The extensions activated on the mint account. */
    extensions: Option<Array<Extension>>;
};
export type MintArgs = {
    /**
     * Optional authority used to mint new tokens. The mint authority may only
     * be provided during mint creation. If no mint authority is present
     * then the mint has a fixed supply and no further tokens may be minted.
     */
    mintAuthority: OptionOrNullable<Address>;
    /** Total supply of tokens. */
    supply: number | bigint;
    /** Number of base 10 digits to the right of the decimal place. */
    decimals: number;
    /** Is `true` if this structure has been initialized. */
    isInitialized: boolean;
    /** Optional authority to freeze token accounts. */
    freezeAuthority: OptionOrNullable<Address>;
    /** The extensions activated on the mint account. */
    extensions: OptionOrNullable<Array<ExtensionArgs>>;
};
export declare function getMintEncoder(): Encoder<MintArgs>;
export declare function getMintDecoder(): Decoder<Mint>;
export declare function getMintCodec(): Codec<MintArgs, Mint>;
export declare function decodeMint<TAddress extends string = string>(encodedAccount: EncodedAccount<TAddress>): Account<Mint, TAddress>;
export declare function decodeMint<TAddress extends string = string>(encodedAccount: MaybeEncodedAccount<TAddress>): MaybeAccount<Mint, TAddress>;
export declare function fetchMint<TAddress extends string = string>(rpc: Parameters<typeof fetchEncodedAccount>[0], address: Address<TAddress>, config?: FetchAccountConfig): Promise<Account<Mint, TAddress>>;
export declare function fetchMaybeMint<TAddress extends string = string>(rpc: Parameters<typeof fetchEncodedAccount>[0], address: Address<TAddress>, config?: FetchAccountConfig): Promise<MaybeAccount<Mint, TAddress>>;
export declare function fetchAllMint(rpc: Parameters<typeof fetchEncodedAccounts>[0], addresses: Array<Address>, config?: FetchAccountsConfig): Promise<Account<Mint>[]>;
export declare function fetchAllMaybeMint(rpc: Parameters<typeof fetchEncodedAccounts>[0], addresses: Array<Address>, config?: FetchAccountsConfig): Promise<MaybeAccount<Mint>[]>;
//# sourceMappingURL=mint.d.ts.map