/// <reference types="node" />
/// <reference types="node" />
import type { DeviceModel } from "@ledgerhq/devices";
import Transport from "@ledgerhq/hw-transport";
type DeviceObj = {
    vendorId: number;
    productId: number;
};
/**
 * Ledger's React Native HID Transport implementation
 * @example
 * import TransportHID from "@ledgerhq/react-native-hid";
 * ...
 * TransportHID.create().then(transport => ...)
 */
export default class HIDTransport extends Transport {
    id: number;
    deviceModel: DeviceModel | null | undefined;
    constructor(nativeId: number, productId: number);
    /**
     * Check if the transport is supported (basically true on Android)
     */
    static isSupported: () => Promise<boolean>;
    /**
     * List currently connected devices.
     * @returns Promise of devices
     */
    static list(): Promise<any[]>;
    /**
     * Listen to ledger devices events
     */
    static listen(observer: any): any;
    /**
     * Open a the transport with a Ledger device
     */
    static open(deviceObj: DeviceObj): Promise<HIDTransport>;
    /**
     * @param {*} apdu input value
     * @returns Promise of apdu response
     */
    exchange(apdu: Buffer): Promise<any>;
    /**
     * Close the transport
     * @returns Promise
     */
    close(): Promise<any>;
    setScrambleKey(): void;
}
export {};
//# sourceMappingURL=index.d.ts.map