<img src="https://user-images.githubusercontent.com/4631227/191834116-59cf590e-25cc-4956-ae5c-812ea464f324.png" height="100" />

[GitHub](https://github.com/LedgerHQ/ledger-live/),
[Ledger Devs Discord](https://developers.ledger.com/discord-pro),
[Developer Portal](https://developers.ledger.com/)

## @ledgerhq/hw-transport-webhid

Allows to communicate with Ledger Hardware Wallets.

**\[Web]** **(WebHID)** – WebHID [check browser support](https://caniuse.com/webhid).

***

## Are you adding Ledger support to your software wallet?

You may be using this package to open a USB connection between your web application and the device.

For a smooth and quick integration:

*   See the developers’ documentation on the [Developer Portal](https://developers.ledger.com/docs/transport/overview/) and
*   Go on [Discord](https://developers.ledger.com/discord-pro/) to chat with developer support and the developer community.

***

### FAQ: "DOM Exception" is triggered when creating the transport

The transport functions `create()` and `listen()` must be called in the context of a user interaction (like a **"click"** event), otherwise it fails with DOM Exception. This is by WebUSB design. You also must run on HTTPS.

### How to use this transport?

Please check `@ledgerhq/hw-transport-webusb` documentation because it is very similar paradigm.

### Support status

WebUSB is currently only supported on Google Chrome / Chromium DEV version and by explicitly enabling `chrome://flags/#enable-experimental-web-platform-features`

## API

<!-- Generated by documentation.js. Update this documentation by updating the source code. -->

#### Table of Contents

*   [TransportWebHID](#transportwebhid)
    *   [Parameters](#parameters)
    *   [Examples](#examples)
    *   [close](#close)
    *   [exchange](#exchange)
        *   [Parameters](#parameters-1)
    *   [isSupported](#issupported)
    *   [list](#list)
    *   [listen](#listen)
        *   [Parameters](#parameters-2)
    *   [request](#request)
    *   [openConnected](#openconnected)
    *   [open](#open)
        *   [Parameters](#parameters-3)

### TransportWebHID

**Extends Transport**

WebHID Transport implementation

#### Parameters

*   `device` **HIDDevice**&#x20;

#### Examples

```javascript
import TransportWebHID from "@ledgerhq/hw-transport-webhid";
...
TransportWebHID.create().then(transport => ...)
```

#### close

Release the transport device

Returns **[Promise](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Promise)\<void>**&#x20;

#### exchange

Exchange with the device using APDU protocol.

##### Parameters

*   `apdu` **[Buffer](https://nodejs.org/api/buffer.html)**&#x20;

Returns **[Promise](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Promise)<[Buffer](https://nodejs.org/api/buffer.html)>** a promise of apdu response

#### isSupported

Check if WebUSB transport is supported.

#### list

List the WebUSB devices that was previously authorized by the user.

#### listen

Actively listen to WebUSB devices and emit ONE device
that was either accepted before, if not it will trigger the native permission UI.

Important: it must be called in the context of a UI click!

##### Parameters

*   `observer` **Observer\<DescriptorEvent\<HIDDevice>>**&#x20;

Returns **Subscription**&#x20;

#### request

Similar to create() except it will always display the device permission (even if some devices are already accepted).

#### openConnected

Similar to create() except it will never display the device permission (it returns a Promise\<?Transport>, null if it fails to find a device).

#### open

Create a Ledger transport with a HIDDevice

##### Parameters

*   `device` **HIDDevice**&#x20;
