/*!
 * Font Awesome Free 7.0.1 by @fontawesome - https://fontawesome.com
 * License - https://fontawesome.com/license/free (Icons: CC BY 4.0, Fonts: SIL OFL 1.1, Code: MIT License)
 * Copyright 2025 Fonticons, Inc.
 */
(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports) :
  typeof define === 'function' && define.amd ? define(['exports'], factory) :
  (factory((global['free-brands-svg-icons'] = {})));
}(this, (function (exports) { 'use strict';

  var prefix = "fab";
  var faSquareGithub = {
    prefix: 'fab',
    iconName: 'square-github',
    icon: [448, 512, ["github-square"], "f092", "M448 96c0-35.3-28.7-64-64-64L64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320zM265.8 407.7c0-1.8 0-6 .1-11.6 .1-11.4 .1-28.8 .1-43.7 0-15.6-5.2-25.5-11.3-30.7 37-4.1 76-9.2 76-73.1 0-18.2-6.5-27.3-17.1-39 1.7-4.3 7.4-22-1.7-45-13.9-4.3-45.7 17.9-45.7 17.9-26.6-7.5-56.6-7.5-83.2 0 0 0-31.8-22.2-45.7-17.9-9.1 22.9-3.5 40.6-1.7 45-10.6 11.7-15.6 20.8-15.6 39 0 63.6 37.3 69 74.3 73.1-4.8 4.3-9.1 11.7-10.6 22.3-9.5 4.3-33.8 11.7-48.3-13.9-9.1-15.8-25.5-17.1-25.5-17.1-16.2-.2-1.1 10.2-1.1 10.2 10.8 5 18.4 24.2 18.4 24.2 9.7 29.7 56.1 19.7 56.1 19.7 0 9 .1 21.7 .1 30.6 0 4.8 .1 8.6 .1 10 0 4.3-3 9.5-11.5 8-66-22.1-112.2-84.9-112.2-158.3 0-91.8 70.2-161.5 162-161.5S388 165.6 388 257.4c.1 73.4-44.7 136.3-110.7 158.3-8.4 1.5-11.5-3.7-11.5-8zm-90.5-54.8c-.2-1.5 1.1-2.8 3-3.2 1.9-.2 3.7 .6 3.9 1.9 .3 1.3-1 2.6-3 3-1.9 .4-3.7-.4-3.9-1.7zm-9.1 3.2c-2.2 .2-3.7-.9-3.7-2.4 0-1.3 1.5-2.4 3.5-2.4 1.9-.2 3.7 .9 3.7 2.4 0 1.3-1.5 2.4-3.5 2.4zm-14.3-2.2c-1.9-.4-3.2-1.9-2.8-3.2s2.4-1.9 4.1-1.5c2 .6 3.3 2.1 2.8 3.4-.4 1.3-2.4 1.9-4.1 1.3zm-12.5-7.3c-1.5-1.3-1.9-3.2-.9-4.1 .9-1.1 2.8-.9 4.3 .6 1.3 1.3 1.8 3.3 .9 4.1-.9 1.1-2.8 .9-4.3-.6zm-8.5-10c-1.1-1.5-1.1-3.2 0-3.9 1.1-.9 2.8-.2 3.7 1.3 1.1 1.5 1.1 3.3 0 4.1-.9 .6-2.6 0-3.7-1.5zm-6.3-8.8c-1.1-1.3-1.3-2.8-.4-3.5 .9-.9 2.4-.4 3.5 .6 1.1 1.3 1.3 2.8 .4 3.5-.9 .9-2.4 .4-3.5-.6zm-6-6.4c-1.3-.6-1.9-1.7-1.5-2.6 .4-.6 1.5-.9 2.8-.4 1.3 .7 1.9 1.8 1.5 2.6-.4 .9-1.7 1.1-2.8 .4z"]
  };
  var faGithubSquare = faSquareGithub;
  var faThinkPeaks = {
    prefix: 'fab',
    iconName: 'think-peaks',
    icon: [576, 512, [], "f731", "M465.4 409.4l87.1-150.2-32-.3-55.1 95-206.2-353.9-236.2 407.4 32 .3 204.2-352.1 206.2 353.8zM110.1 365.3l32.1 0 117.4-202.5 203.4 349.1 32.5 .1-235.8-404.6-149.6 257.9z"]
  };
  var faGoogleDrive = {
    prefix: 'fab',
    iconName: 'google-drive',
    icon: [512, 512, [], "f3aa", "M339 314.9L175.4 32 336.6 32 500.2 314.9 339 314.9zM201.5 338.5l-80.6 141.5 310.5 0 80.6-141.5-310.5 0zM154.1 67.4L0 338.5 80.6 480 237 208.8 154.1 67.4z"]
  };
  var faAutoprefixer = {
    prefix: 'fab',
    iconName: 'autoprefixer',
    icon: [640, 512, [], "f41c", "M318.4 16l-161 480 77.5 0 25.4-81.4 119.5 0 25.2 81.4 77.5 0-164.1-480zM278.1 357.9l41.2-130.4 1.5 0 40.9 130.4-83.6 0zM640 405L630 373.6 462.1 358 481.5 414.5 640 405zM177.9 358L10 373.7 0 405 158.5 414.4 177.9 358z"]
  };
  var faSquareViadeo = {
    prefix: 'fab',
    iconName: 'square-viadeo',
    icon: [448, 512, ["viadeo-square"], "f2aa", "M448 96c0-35.3-28.7-64-64-64L64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320zM118.3 381.2c-68-73.6-19.8-196.1 81.2-196.1 13.3 0 26.6 2.1 39.1 6.7-4.3 8.4-7.3 17.6-8.4 27.1-9.7-4.1-20.2-6-30.7-6-48.8 0-84.6 41.7-84.6 88.9 0 43 28.5 78.7 69.5 85.9 61.5-24 72.9-117.6 72.9-175 0-7.3 0-14.8-.6-22.1-11.2-32.9-26.6-64.6-44.2-94.5 27.1 18.3 41.9 62.5 44.2 94.1l0 .4c7.7 22.5 11.8 46.2 11.8 70 0 54.1-21.9 99-68.3 128.2l-2.4 .2c50 1 86.2-38.6 86.2-87.2 0-12.2-2.1-24.3-6.9-35.7 9.5-1.9 18.5-5.6 26.4-10.5 15.3 36.6 12.6 87.3-22.8 125.6-42.4 46.2-120 46.6-162.4 0zM274.6 217.6c21.9-12 49.6-30.7 62.3-53 1.5-3 4.1-8.6 4.5-12-12.5 27.9-44.2 49.8-73.9 56.7-4.7-7.3-7.5-15.5-7.5-24.3 0-10.3 5.2-24.1 12.9-31.6 8.3-7.9 18-10.9 27.9-14.1 16-5.1 32.5-10.3 44.5-35.9 32.5 46.2 13.1 130.3-36.3 130.3-13.3 0-25.1-7.1-34.4-16.1z"]
  };
  var faViadeoSquare = faSquareViadeo;
  var faCpanel = {
    prefix: 'fab',
    iconName: 'cpanel',
    icon: [640, 512, [], "f388", "M210.3 220.2c-5.6-24.8-26.9-41.2-51-41.2l-37 0c-7.1 0-12.5 4.5-14.3 10.9L73.1 320 97.8 319.9c6.8 0 12.3-4.5 14.2-10.7l25.8-95.7 19.8 0c8.4 0 16.2 5.6 18.3 14.8 2.5 10.9-5.9 22.6-18.3 22.6l-10.3 0c-7 0-12.5 4.6-14.3 10.8l-6.4 23.8 32 0c37.2 0 58.3-36.2 51.7-65.3zm-156.5 28l18.6 0c6.9 0 12.4-4.4 14.3-10.9l6.2-23.6-40 0C30 213.7 9 227.8 1.7 254.8-7 288.6 18.5 320 52 320l12.4 0 7.1-26.1c1.2-4.4-2.2-8.3-6.4-8.3l-11.3 0c-24.7 0-24.9-37.4 0-37.4zm247.5-34.8l-77.9 0-3.5 13.4c-2.4 9.6 4.5 18.5 14.2 18.5l57.5 0c4 0 2.4 4.3 2.1 5.3l-8.6 31.8c-.4 1.4-.9 5.3-5.5 5.3l-34.9 0c-5.3 0-5.3-7.9 0-7.9l21.6 0c6.8 0 12.3-4.6 14.2-10.8l3.5-13.2-48.4 0c-39.2 0-43.6 63.8-.7 63.8l57.5 .2c11.2 0 20.6-7.2 23.4-17.8l14-51.8c4.8-19.2-9.7-36.8-28.5-36.8zM633.1 179l-18.9 0c-4.9 0-9.2 3.2-10.4 7.9L568.2 320c20.7 0 39.8-13.8 44.9-34.5l26.5-98.2c1.2-4.3-2-8.3-6.5-8.3zM396.8 213.7l0 .1-48.3 0-26.2 98c-1.2 4.4 2.2 8.3 6.4 8.3l18.9 0c4.8 0 9.2-3 10.4-7.8l17.2-64 19.8 0c12.5 0 21.4 11.8 18.1 23.4l-10.6 40c-1.2 4.3 1.9 8.3 6.4 8.3l19.1 0c4.6 0 9.1-2.9 10.3-7.8l8.8-33.1c9-33.1-15.9-65.4-50.3-65.4zm98.3 74.6c-3.6 0-6-3.4-5.1-6.7l8-30c.9-3.9 3.7-6 7.8-6l32.9 0c2.6 0 4.6 2.4 3.9 5.1l-.7 2.6c-.6 2-1.9 3-3.9 3l-21.6 0c-7 0-12.6 4.6-14.2 10.8l-3.5 13 53.4 0c10.5 0 20.3-6.6 23.2-17.6l3.2-12c4.9-19.1-9.3-36.8-28.3-36.8l-47.3 0c-17.9 0-33.8 12-38.6 29.6l-10.8 40c-5 17.7 8.3 36.7 28.3 36.7l66.7 0c6.8 0 12.3-4.5 14.2-10.7l5.7-21-73.3 0z"]
  };
  var faMendeley = {
    prefix: 'fab',
    iconName: 'mendeley',
    icon: [640, 512, [], "f7b3", "M624.6 325.2c-12.3-12.4-29.7-19.2-48.4-17.2-43.3-1-49.7-34.9-37.5-98.8 22.8-57.5-14.9-131.5-87.4-130.8-77.4 .7-81.7 82-130.9 82-48.1 0-54-81.3-130.9-82-72.9-.8-110.1 73.3-87.4 130.8 12.2 63.9 5.8 97.8-37.5 98.8-21.2-2.3-37 6.5-53 22.5-19.9 19.7-19.3 94.8 42.6 102.6 47.1 5.9 81.6-42.9 61.2-87.8-47.3-103.7 185.9-106.1 146.5-8.2-.1 .1-.2 .2-.3 .4-26.8 42.8 6.8 97.4 58.8 95.2 52.1 2.1 85.4-52.6 58.8-95.2-.1-.2-.2-.3-.3-.4-39.4-97.9 193.8-95.5 146.5 8.2-4.6 10-6.7 21.3-5.7 33 4.9 53.4 68.7 74.1 104.9 35.2 17.8-14.8 23.1-65.6 0-88.3zM320.7 306.1l-.6 0c-43.4 0-62.8-37.5-62.8-62.8 0-34.7 28.2-62.8 62.8-62.8l.6 0c34.7 0 62.8 28.1 62.8 62.8 0 25-19.2 62.8-62.8 62.8z"]
  };
  var faDraft2digital = {
    prefix: 'fab',
    iconName: 'draft2digital',
    icon: [512, 512, [], "f396", "M496 398.1l-144-82.2 0 64.7-91.3 0c30.8-35 81.8-95.9 111.8-149.3 35.2-62.6 16.1-123.4-12.8-153.3-4.4-4.6-62.2-62.9-166-41.2-59.1 12.4-89.4 43.4-104.3 67.3-13.1 20.9-17 39.8-18.2 47.7-5.5 33 19.4 67.1 56.7 67.1 31.7 0 57.3-25.7 57.3-57.4 0-27.1-19.7-52.1-48-56.8 1.8-7.3 17.7-21.1 26.3-24.7 41.1-17.3 78 5.2 83.3 33.5 8.3 44.3-37.1 90.4-69.7 127.6-76.6 87-142.8 155.7-161.1 174.8l336-.1 0 64.2 144-81.9zM385.9 371l47.1 27.2-47.1 27.2 0-54.4zM105.4 161.4a22.4 22.4 0 1 1 44.8 0 22.4 22.4 0 1 1 -44.8 0zM98.5 380.5c25.6-27.4 97.7-104.7 150.8-169.9 35.1-43.1 40.3-82.4 28.4-112.7-7.4-18.8-17.5-30.2-24.3-35.7 45.3 2.1 68 23.4 82.2 38.3 0 0 42.4 48.2 5.8 113.3-37 65.9-110.9 147.5-128.5 166.7l-114.4 0z"]
  };
  var faReplyd = {
    prefix: 'fab',
    iconName: 'replyd',
    icon: [448, 512, [], "f3e6", "M320 480l-192 0C57.6 480 0 422.4 0 352L0 160C0 89.6 57.6 32 128 32l192 0c70.4 0 128 57.6 128 128l0 192c0 70.4-57.6 128-128 128zM193.4 273.2c-6.1-2-11.6-3.1-16.4-3.1-7.2 0-13.5 1.9-18.9 5.6s-9.6 9-12.8 15.8l-1.1 0-4.2-18.3-28 0 0 138.9 36.1 0 0-89.7c1.5-5.4 4.4-9.8 8.7-13.2s9.8-5.1 16.2-5.1c4.6 0 9.8 1 15.6 3.1l4.8-34zM308.6 376.6c-3.2 2.4-7.7 4.8-13.7 7.1s-12.8 3.5-20.4 3.5c-12.2 0-21.1-3-26.5-8.9-5.5-5.9-8.5-14.7-9-26.4l83.3 0c.9-4.8 1.6-9.4 2.1-13.9 .5-4.4 .7-8.6 .7-12.5 0-10.7-1.6-19.7-4.7-26.9-3.2-7.2-7.3-13-12.5-17.2-5.2-4.3-11.1-7.3-17.8-9.2-6.7-1.8-13.5-2.8-20.6-2.8-21.1 0-37.5 6.1-49.2 18.3s-17.5 30.5-17.5 55c0 22.8 5.2 40.7 15.6 53.7 10.4 13.1 26.8 19.6 49.2 19.6 10.7 0 20.9-1.5 30.4-4.6s17.1-6.8 22.6-11.2l-12-23.6zm-21.8-70.3c3.8 5.4 5.3 13.1 4.6 23.1l-51.7 0c.9-9.4 3.7-17 8.2-22.6s11.5-8.5 21-8.5c8.2-.1 14.1 2.6 17.9 8zm79.9 2.5c4.1 3.9 9.4 5.8 16.1 5.8 7 0 12.6-1.9 16.7-5.8s6.1-9.1 6.1-15.6-2-11.6-6.1-15.4-9.6-5.7-16.7-5.7c-6.7 0-12 1.9-16.1 5.7s-6.1 8.9-6.1 15.4 2 11.7 6.1 15.6zm0 100.5c4.1 3.9 9.4 5.8 16.1 5.8 7 0 12.6-1.9 16.7-5.8s6.1-9.1 6.1-15.6-2-11.6-6.1-15.4-9.6-5.7-16.7-5.7c-6.7 0-12 1.9-16.1 5.7s-6.1 8.9-6.1 15.4c0 6.6 2 11.7 6.1 15.6z"]
  };
  var faEmpire = {
    prefix: 'fab',
    iconName: 'empire',
    icon: [512, 512, [], "f1d1", "M295.6 54.2c-10.8-2.2-22.1-3.3-33.5-3.6l0-18.2c78.1 2.2 146.1 44 184.6 106.6l-15.8 9.1c-6.1-9.7-12.7-18.8-20.2-27.1l-18 15.5c-26-29.6-61.4-50.7-101.9-58.4l4.8-23.9zM61.4 322.4l23-7.7c-6.4-18.3-10-38.2-10-58.7s3.3-40.4 9.7-58.7l-22.7-7.7c3.6-10.8 8.3-21.3 13.6-31l-15.8-9.1C42 181 32.1 217.5 32.1 256s10 75 27.1 106.6L75 353.5c-5.3-10-9.7-20.3-13.6-31.1zM221.1 434c-40.4-8-75.8-29.1-101.9-58.7l-18 15.8c-7.5-8.6-14.4-17.7-20.2-27.4l-16 9.4c38.5 62.3 106.8 104.3 184.9 106.6l0-18.3c-11.3-.3-22.7-1.7-33.5-3.6l4.7-23.8zM101.3 120.9l18 15.5c26-29.6 61.4-50.7 101.9-58.4l-4.7-23.8c10.8-2.2 22.1-3.3 33.5-3.6l0-18.2C171.9 34.6 103.9 76.4 65.4 139l15.8 9.1c6-9.7 12.6-18.9 20.1-27.2zM410.7 391.1l-18-15.8c-26 29.6-61.4 50.7-101.9 58.7l4.7 23.8c-10.8 1.9-22.1 3.3-33.5 3.6l0 18.3c78.1-2.2 146.4-44.3 184.9-106.6l-16.1-9.4c-5.7 9.7-12.6 18.8-20.1 27.4zM8 256a248 248 0 1 1 496 0 248 248 0 1 1 -496 0zm483.8 0a235.8 235.8 0 1 0 -471.6 0 235.8 235.8 0 1 0 471.6 0zm-39-106.6L437 158.5c5.3 9.7 10 20.2 13.6 31l-22.7 7.7c6.4 18.3 9.7 38.2 9.7 58.7s-3.6 40.4-10 58.7l23 7.7c-3.9 10.8-8.3 21-13.6 31l15.8 9.1C470 331 479.9 294.5 479.9 256s-9.9-75-27.1-106.6zm-183 177.7c16.3-3.3 30.4-11.6 40.7-23.5l51.2 44.8c11.9-13.6 21.3-29.3 27.1-46.8l-64.2-22.1c2.5-7.5 3.9-15.2 3.9-23.5s-1.4-16.1-3.9-23.5l64.5-22.1c-6.1-17.4-15.5-33.2-27.4-46.8l-51.2 44.8c-10.2-11.9-24.4-20.5-40.7-23.8l13.3-66.4c-8.6-1.9-17.7-2.8-27.1-2.8s-18.5 .8-27.1 2.8l13.3 66.4c-16.3 3.3-30.4 11.9-40.7 23.8l-51.2-44.8c-11.9 13.6-21.3 29.3-27.4 46.8l64.5 22.1c-2.5 7.5-3.9 15.2-3.9 23.5s1.4 16.1 3.9 23.5l-64.2 22.1c5.8 17.4 15.2 33.2 27.1 46.8l51.2-44.8c10.2 11.9 24.4 20.2 40.7 23.5l-13.3 66.7c8.6 1.7 17.7 2.8 27.1 2.8s18.5-1.1 27.1-2.8l-13.3-66.7z"]
  };
  var faAccessibleIcon = {
    prefix: 'fab',
    iconName: 'accessible-icon',
    icon: [448, 512, [62107], "f368", "M423.9 255.8L411 413.1c-3.3 40.7-63.9 35.1-60.6-4.9l10-122.5-41.1 2.3c10.1 20.7 15.8 43.9 15.8 68.5 0 41.2-16.1 78.7-42.3 106.5l-39.3-39.3c57.9-63.7 13.1-167.2-74-167.2-25.9 0-49.5 9.9-67.2 26L73 243.2c22-20.7 50.1-35.1 81.4-40.2l75.3-85.7-42.6-24.8-51.6 46C105.5 165.3 64.9 120 95 93.1l68-60.7c9.8-8.8 24.1-10.2 35.5-3.6 0 0 139.3 80.9 139.5 81.1 16.2 10.1 20.7 36 6.1 52.6l-58.4 66.5 106.1-5.9c18.5-1.1 33.6 14.4 32.1 32.7zM359 101.8A50.9 50.9 0 1 0 359 0 50.9 50.9 0 1 0 359 101.8zM179.6 456.5c-80.6 0-127.4-90.6-82.7-156.1L57.2 260.7C36.4 287 24 320.3 24 356.4 24 487.1 174.7 557.8 275.4 478.9l-39.7-39.7c-16 10.9-35.3 17.3-56.1 17.3z"]
  };
  var faQuora = {
    prefix: 'fab',
    iconName: 'quora',
    icon: [448, 512, [], "f2c4", "M440.7 386.7l-29.3 0c-1.5 13.5-10.5 30.8-33 30.8-20.5 0-35.3-14.2-49.5-35.8 44.2-34.2 74.7-87.5 74.7-153 .1-117.5-96.6-196.7-198.4-196.7-99.7 0-197.7 79.7-197.7 196.7 0 134.1 131.3 221.6 249 189 19.7 33.6 45.7 62.3 95.2 62.3 81.8 0 90.8-75.3 89-93.3zM297.2 329.2c-19.5-29.2-43.7-52.2-91.5-52.2-30.5 0-54.3 10-69 22.8l12.2 24.3c6.2-3 13-4 19.8-4 35.5 0 53.7 30.8 69.2 61.3-10 3-20.7 4.2-32.7 4.2-75 0-107.5-53-107.5-156.7 0-104.4 32.5-157.9 107.5-157.9 76.2 0 108.7 53.5 108.7 157.7 .1 41.8-5.4 75.6-16.7 100.5z"]
  };
  var faCcJcb = {
    prefix: 'fab',
    iconName: 'cc-jcb',
    icon: [576, 512, [], "f24b", "M431.5 244.3l0-32.3c41.2 0 38.5 .2 38.5 .2 7.3 1.3 13.3 7.3 13.3 16 0 8.8-6 14.5-13.3 15.8-1.2 .4-3.3 .3-38.5 .3zm42.8 20.2c-2.8-.7-3.3-.5-42.8-.5l0 35c39.6 0 40 .2 42.8-.5 7.5-1.5 13.5-8 13.5-17 0-8.7-6-15.5-13.5-17zM576 80l0 352c0 26.5-21.5 48-48 48L48 480c-26.5 0-48-21.5-48-48L0 80C0 53.5 21.5 32 48 32l480 0c26.5 0 48 21.5 48 48zM182 192.3l-57 0c0 67.1 10.7 109.7-35.8 109.7-19.5 0-38.8-5.7-57.2-14.8l0 28c30 8.3 68 8.3 68 8.3 97.9 0 82-47.7 82-131.2zm178.5 4.5c-63.4-16-165-14.9-165 59.3 0 77.1 108.2 73.6 165 59.2l0-28.3C312.9 311.7 253 309 253 256s59.8-55.6 107.5-31.2l0-28zM544 286.5c0-18.5-16.5-30.5-38-32l0-.8c19.5-2.7 30.3-15.5 30.3-30.2 0-19-15.7-30-37-31 0 0 6.3-.3-120.3-.3l0 127.5 122.7 0c24.3 .1 42.3-12.9 42.3-33.2z"]
  };
  var faFedora = {
    prefix: 'fab',
    iconName: 'fedora',
    icon: [448, 512, [], "f798", "M0 255.8C.1 132.2 100.3 32 224 32S448 132.3 448 256 347.8 479.9 224.1 480L50.9 480C22.8 480 .1 457.3 0 429.2l0 0 0-173.4 0 0zm342.6-63.1c0-39.7-35.6-68.5-73.2-68.5-34.9 0-65.8 26.3-70.1 59.9-.2 3.8-.4 5-.4 8.5-.1 21.1 0 42.8-.8 64.4 .9 26.1 1 52.1 0 76.6 0 27.1-19.4 45.5-44.7 45.5s-45.8-20.2-45.8-45.5c.5-27.7 22.6-45.3 48.5-46.1l.2 0 26.3-.2 0-37.3-26.3 .2c-47.1-.4-84.6 36.5-85.9 83.4 0 45.6 37.5 82.9 83 82.9 43 0 78.7-33.6 82.6-75.6l.2-53.5 32.6-.3c25.3 .2 25-37.8-.2-37.3l-32.4 .3c0-6.4 .1-12.8 .1-19.2 .1-12.7 .1-25.4-.1-38.2 .1-16.5 15.8-31.2 33.2-31.2 17.5 0 35.9 8.7 35.9 31.2 0 3.2-.1 5.1-.3 6.3-1.9 10.5 5.2 20.4 15.7 21.9 10.6 1.5 20.2-6.1 21.2-16.6 .6-4.2 .7-7.9 .7-11.6z"]
  };
  var faDuolingo = {
    prefix: 'fab',
    iconName: 'duolingo',
    icon: [576, 512, [], "e812", "M504.3 230.5c10.4 88.5-43.4 172.1-128.2 199s-176.6-10.3-218.9-88.7c-72 3-137.4-39.8-163.2-105.5-2.6-6.6-1.9-14 1.9-19.9s10.2-9.7 17.2-10.1l96.1-6-23.8-75.9c-6.3-20-2.2-41.9 11-58.3s33.7-25 54.5-23c52.2 5 86.8 4.8 104-.6S300 16.7 339-16.9c15.9-13.7 37.7-18.5 57.8-12.7s36.1 21.3 42.4 41.4L462.8 87 543.6 37.3c6-3.7 13.4-4.3 19.9-1.6s11.3 8.3 12.9 15.2c16.2 68.2-12.4 140.3-72.1 179.5zM258.5 475.9l0 0c15.1 7.5 21.5 25.8 14.2 41s-25.4 21.9-40.7 14.9l-43.9-21c-15.1-7.5-21.5-25.8-14.2-41s25.4-21.9 40.7-14.9l43.8 21zM564.6 345.7c14.8 8.4 20 27.3 11.6 42.2l-23.9 42.4c-8.7 14.3-27.1 19.2-41.6 10.9s-19.9-26.6-12-41.4l23.9-42.4c4-7.1 10.7-12.4 18.6-14.6s16.3-1.2 23.4 2.9z"]
  };
  var faFirstdraft = {
    prefix: 'fab',
    iconName: 'firstdraft',
    icon: [384, 512, [], "f3a1", "M384 192l-64 0 0 128-128 0 0 128-192 0 0-25.6 166.4 0 0-128 128 0 0-128 89.6 0 0 25.6zm-25.6 38.4l0 128-128 0 0 128-166.4 0 0 25.6 192 0 0-128 128 0 0-153.6-25.6 0zm25.6 192l-89.6 0 0 89.6 25.6 0 0-64 64 0 0-25.6zM0 0l0 384 128 0 0-128 128 0 0-128 128 0 0-128-384 0z"]
  };
  var faFreebsd = {
    prefix: 'fab',
    iconName: 'freebsd',
    icon: [448, 512, [], "f3a4", "M303.7 96.2c11.1-11.1 115.5-77 139.2-53.2 23.7 23.7-42.1 128.1-53.2 139.2s-39.4 .9-63.1-22.9c-23.8-23.7-34.1-52-22.9-63.1zM109.9 68.1C73.6 47.5 22 24.6 5.6 41.1-11 57.7 12.7 110.5 33.5 146.8 52 114.6 78.3 87.5 109.9 68.1zM406.7 174c3.3 11.3 2.7 20.7-2.7 26.1-20.3 20.3-87.5-27-109.3-70.1-18-32.3-11.1-53.4 14.9-48.7 5.7-3.6 12.3-7.6 19.6-11.6-29.8-15.5-63.6-24.3-99.5-24.3-119.1 0-215.6 96.5-215.6 215.6 0 119 96.5 215.6 215.6 215.6S445.3 380.1 445.3 261c0-38.4-10.1-74.5-27.7-105.8-3.9 7-7.6 13.3-10.9 18.8z"]
  };
  var faOdysee = {
    prefix: 'fab',
    iconName: 'odysee',
    icon: [512, 512, [], "e5c6", "M406.7 463c-42.3 30.8-94.4 49-150.7 49-111.1 0-205.7-70.8-241.1-169.8 2.4 1.7 5.9 3.6 7.9 4.4 16.3 7.4 40.1-5.4 62.9-28.7 6.9-6.9 14.4-12.4 22.8-17.3 18.3-11.9 37.6-20.8 58.4-27.2 0 0 22.3 34.2 43.1 74.8s-22.3 54-27.2 54c-.3 0-.8 0-1.5-.1-11-.5-70-3-56 51.1 14.9 57.4 97.5 36.6 139.6 8.9s31.7-118.3 31.7-118.3c41.1-6.4 54 37.1 57.9 59.4 .8 4.6 1.1 9.9 1.4 15.5 1.1 21.2 2.3 45.6 35.3 46.4 5.3 0 10.6-.8 15.5-2l0-.1zm-95.3-23.7c-2-.5-3.5-2.5-3-5 1-2.5 3-3.5 5-3s3.5 3 3 5-2.5 3.5-5 3zm-207-95.6c1.5-.5 3.5 1 4 3 0 2-1 4-3 4-1.5 .5-3.5-1-4-3-.5-1.5 1-3.5 3-4zM451.8 421c37.5-44.6 60.2-102.2 60.2-165 0-67.5-26.1-128.9-68.8-174.7-.1 23.5-6.1 48.2-16.8 69.2-11.9 20.3-49 58.9-69.8 78.7-.7 .3-1.1 .9-1.5 1.4-.2 .2-.3 .4-.5 .6-5 6.9-4 16.8 3 21.8 21.3 15.8 56.4 45.6 59.4 72.8 3.5 34.9 27.9 75.6 34.2 86.2 .8 1.3 1.3 2.1 1.4 2.4 0 2.2-.4 4.3-.8 6.5l0 .1zM390.7 251c-.5 3 1 5.9 4 6.4s5.9-1 6.4-4-1-5.9-4-6.4c-3-1-5.9 1-6.4 4zm61.4-60.9l-11.4 5.4-3 12.9-5.4-11.4-12.9-3 11.4-5.4 3-12.9 5.4 11.4 12.9 3zM395.5 41.3c-16.2 8.2-22.1 32.8-29 61.4-.3 1.4-.7 2.8-1 4.2-9.5 38.5-30.6 37.6-41.7 37.2-1.1 0-2-.1-2.9-.1-5.1 0-6-4-8.9-17.1-2.6-12.1-6.9-32-17.9-63.6-22.7-65.8-82.7-49.4-128.2-22.2-55.3 33.1-34.4 101.9-19.8 149.4 .7 2.2 1.4 4.4 2 6.6-4 4-13.8 7.5-26 11.9-12.1 4.3-26.6 9.5-40.3 16.9-33.9 18-70.3 49-79.8 62.6-1.3-10.7-2-21.5-2-32.5 0-141.4 114.6-256 256-256 51.4 0 99.4 15.2 139.5 41.3zM58.9 189.6c-1.5-2-4.5-3-6.4-1.5s-3 4.5-1.5 6.4 4.5 3 6.4 1.5c2.5-1.5 3-4.5 1.5-6.4zM327.3 64.9c2-1.5 5-.5 6.4 1.5 1.5 2.5 1 5.4-1.5 6.4-2 1.5-5 .5-6.4-1.5s-.5-5 1.5-6.4zM95.1 105c-.5 1.5 .5 3 2 3 1.5 .5 3-.5 3-2 .5-1.5-.5-3-2-3s-3 .5-3 2zm84.7-.5c-3.5-43.1 37.1-54 37.1-54 44.1-15.4 56 5.9 66.4 37.6s3 42.6-38.6 58.9-61.9-4.5-64.9-42.6l0 .1zm89.6 14.9l1 0c2.5 0 5-2 5-5 2-6.9 1-14.4-2-20.8-1.5-2-4-3.5-6.4-2.5-3 1-4.5 4-3.5 6.9 2 4.5 3 9.9 1.5 14.9-.5 3 1.5 5.9 4.5 6.4l-.1 .1zm-9.9-41.6c-2 0-4-1-5-3s-2-3.5-3-5c-2-2-2-5.4 0-7.4s5.4-2 7.4 0c2 2.5 3.5 5 5 7.4s.5 5.9-2.5 7.4c-.6 0-1 .2-1.3 .3-.2 .1-.4 .2-.6 .2l0 .1z"]
  };
  var faGgCircle = {
    prefix: 'fab',
    iconName: 'gg-circle',
    icon: [512, 512, [], "f261", "M257.5 8a248 248 0 1 0 0 496 248 248 0 1 0 0-496zM208 382.8l-125.7-125.7 125.7-125.7 35.2 35.4-24.2 24.2-11.1-11.1-77.2 77.2 77.2 77.2 26.6-26.6-53.1-52.9 24.4-24.4 77.2 77.2-75 75.2zm99-2.2l-35.2-35.2 24.1-24.4 11.1 11.1 77.2-77.2-77.2-77.2-26.5 26.5 53.1 52.9-24.4 24.4-77.2-77.2 75-75 125.7 125.7-125.7 125.6z"]
  };
  var faCloudflare = {
    prefix: 'fab',
    iconName: 'cloudflare',
    icon: [640, 512, [], "e07d", "M407.9 319.9L177.1 317c-.7 0-1.4-.2-2-.5s-1.2-.8-1.6-1.4c-.4-.6-.7-1.3-.7-2s0-1.4 .2-2.1c.4-1.1 1.1-2.1 2.1-2.8s2.1-1.2 3.3-1.2l232.9-2.9c27.6-1.3 57.5-23.6 68-50.8l13.3-34.5c.4-.9 .5-1.9 .5-2.9 0-.5-.1-1.1-.2-1.6-7.4-32.2-25-61.1-50.3-82.3s-56.7-33.7-89.7-35.5-65.6 7.3-93 25.7-48 45.3-58.8 76.5c-11.3-8.5-24.9-13.3-39-13.7s-28 3.5-39.8 11.4-20.8 19.1-25.9 32.3-5.9 27.6-2.4 41.3c-52.3 1.5-94.2 44.1-94.2 96.5 0 4.7 .3 9.3 1 14 .2 1.1 .7 2.1 1.5 2.8s1.9 1.1 2.9 1.1l426.1 .1c0 0 .1 0 .1 0 1.2 0 2.3-.4 3.3-1.1s1.6-1.7 2-2.9l3.3-11.3c3.9-13.4 2.4-25.8-4.1-34.9-6-8.4-16.1-13.3-28.2-13.9zm105.9-98.8c-2.1 0-4.3 .1-6.4 .2-.8 .1-1.5 .3-2.1 .8s-1 1.1-1.3 1.8l-9.1 31.2c-3.9 13.4-2.4 25.8 4.1 34.9 6 8.4 16.1 13.3 28.2 13.9l49.2 2.9c.7 0 1.4 .2 2 .5s1.1 .8 1.5 1.4c.4 .6 .7 1.3 .8 2s0 1.5-.2 2.1c-.4 1.1-1.1 2.1-2.1 2.8s-2.1 1.2-3.3 1.2l-51.1 2.9c-27.8 1.3-57.7 23.6-68.1 50.8l-3.7 9.6c-.2 .4-.2 .8-.2 1.3s.2 .8 .4 1.2 .6 .7 .9 .9 .8 .3 1.2 .3c0 0 .1 0 .1 0l175.9 0c1 0 2-.3 2.8-.9s1.4-1.5 1.7-2.4c3.1-11.1 4.7-22.5 4.7-34 0-69.3-56.5-125.5-126.1-125.5z"]
  };
  var faHackerrank = {
    prefix: 'fab',
    iconName: 'hackerrank',
    icon: [512, 512, [], "f5f7", "M477.9 128C463.4 103 285.5 0 256.5 0s-206.9 102.8-221.3 128-14.5 230.8 0 256 192.4 128 221.3 128 206.8-102.9 221.3-128 14.5-231 0-256zM316.5 414.2c-4 0-40.9-35.8-38-38.7 .9-.9 6.3-1.5 17.5-1.8 0-26.2 .6-68.6 .9-86.3 0-2-.4-3.4-.4-5.8l-79.9 0c0 7.1-.5 36.2 1.4 72.9 .2 4.5-1.6 6-5.7 5.9-10.1 0-20.3-.1-30.4-.1-4.1 0-5.9-1.5-5.7-6.1 .9-33.4 3-84-.2-212.7l0-3.2c-9.7-.4-16.4-1-17.3-1.8-2.9-2.9 34.5-38.7 38.5-38.7s41.2 35.8 38.3 38.7c-.9 .9-7.9 1.5-16.8 1.8l0 3.2c-2.4 25.8-2 79.6-2.6 105.4l80.3 0c0-4.6 .4-34.7-1.2-83.6-.1-3.4 1-5.2 4.2-5.2 11.1-.1 22.2-.1 33.2-.1 3.5 0 4.6 1.7 4.5 5.4-3.7 191.3-.7 177.9-.7 210.3 8.9 .4 16.8 1 17.7 1.8 2.9 2.9-33.6 38.7-37.6 38.7l0 0z"]
  };
  var faSkyatlas = {
    prefix: 'fab',
    iconName: 'skyatlas',
    icon: [640, 512, [], "f216", "M640 329.3c0 65.9-52.5 114.4-117.5 114.4-165.9 0-196.6-249.7-359.7-249.7-146.9 0-147.1 212.2 5.6 212.2 42.5 0 90.9-17.8 125.3-42.5 5.6-4.1 16.9-16.3 22.8-16.3s10.9 5 10.9 10.9c0 7.8-13.1 19.1-18.7 24.1-40.9 35.6-100.3 61.2-154.7 61.2-83.4 .1-154-59-154-144.9S67.5 149.6 152.8 149.6c185.3 0 222.5 245.9 361.9 245.9 99.9 0 94.8-139.7 3.4-139.7-17.5 0-35 11.6-46.9 11.6-8.4 0-15.9-7.2-15.9-15.6 0-11.6 5.3-23.7 5.3-36.3 0-66.6-50.9-114.7-116.9-114.7-53.1 0-80 36.9-88.8 36.9-6.2 0-11.2-5-11.2-11.2 0-5.6 4.1-10.3 7.8-14.4 25.3-28.8 64.7-43.7 102.8-43.7 79.4 0 139.1 58.4 139.1 137.8 0 6.9-.3 13.7-1.2 20.6 11.9-3.1 24.1-4.7 35.9-4.7 60.7 0 111.9 45.3 111.9 107.2z"]
  };
  var faDeskpro = {
    prefix: 'fab',
    iconName: 'deskpro',
    icon: [512, 512, [], "f38f", "M222 512l31.1-38.4c12.3-.2 25.6-1.4 36.5-6.6 38.9-18.6 38.4-61.9 38.3-63.8-.1-5-.8-4.4-28.9-37.4l79.1 0c-.2 50.1-7.3 68.5-10.2 75.7-9.4 23.7-43.9 62.8-95.2 69.4-8.7 1.1-32.8 1.2-50.7 1.1zM422.4 344.3c38.6 0 58.5-13.6 73.7-30.9l-175.5-.3-17.4 31.3 119.2-.1zM378.8 120.4l0 168.3-73.5 0-32.7 55.5-6.5 0c-52.3 0-58.1-56.5-58.3-58.9-1.2-13.2-21.3-11.6-20.1 1.8 1.4 15.8 8.8 40 26.4 57.1l-91 0c-25.5 0-110.8-26.8-107-114l0-213.3c0-16 9.7-16.6 15-16.8l82 0c.2 0 .3 .1 .5 .1 4.3-.4 50.1-2.1 50.1 43.7 0 13.3 20.2 13.4 20.2 0 0-18.2-5.5-32.8-15.8-43.7l84.2 0C361-.2 378.8 79.6 378.8 120.4zm-132.5 56l64 29.3c13.3-45.5-42.2-71.7-64-29.3z"]
  };
  var faResolving = {
    prefix: 'fab',
    iconName: 'resolving',
    icon: [512, 512, [], "f3e7", "M289.2 278.2c46-13.3 49.6-23.5 44-43.4L322 195.5c-6.1-20.9-18.4-28.1-71.1-12.8l-188.2 54.1 28.6 98.6 197.9-57.2zM256.5 8C139.4 8 41.2 88.7 15.2 197.5l221.9-63.9c34.8-10.2 54.2-11.7 79.3-8.2 36.3 6.1 52.7 25 61.4 55.2l10.7 37.8c8.2 28.1 1 50.6-23.5 73.6-19.4 17.4-31.2 24.5-61.4 33.2l-92.6 26.6 220.4 27.1 9.7 34.2-48.1 13.3-286.8-37.3 23 80.2C166 491.3 209.5 504 255.5 504 392.5 504 504 392.6 504 255.7 505 119.4 393.5 8 256.5 8zM46.3 388.6L8 256.8c0 48.5 14.3 93.4 38.3 131.8z"]
  };
  var faBlackberry = {
    prefix: 'fab',
    iconName: 'blackberry',
    icon: [512, 512, [], "f37b", "M166 116.9c0 23.4-16.4 49.1-72.5 49.1l-70.1 0 21-88.8 67.8 0c42.1 0 53.8 23.3 53.8 39.7zM292.2 77.2l-67.8 0-18.7 88.8 70.1 0c53.8 0 70.1-25.7 70.1-49.1 .1-16.4-11.6-39.7-53.7-39.7zM88.8 208.1l-67.8 0-21 88.8 70.1 0c56.1 0 72.5-23.4 72.5-49.1 0-16.3-11.7-39.7-53.8-39.7zm180.1 0l-67.8 0-18.7 88.8 70.1 0c53.8 0 70.1-23.4 70.1-49.1 0-16.3-11.7-39.7-53.7-39.7zm189.3-53.8l-67.8 0-18.7 88.8 70.1 0c53.8 0 70.1-23.4 70.1-49.1 .1-16.3-11.6-39.7-53.7-39.7zm-28 137.9l-67.8 0-18.7 88.8 70.1 0c56.1 0 70.1-23.4 70.1-49.1 0-16.3-11.6-39.7-53.7-39.7zM240.8 346l-67.8 0-18.7 88.8 70.1 0c56.1 0 70.1-25.7 70.1-49.1 .1-16.3-11.6-39.7-53.7-39.7z"]
  };
  var faStripeS = {
    prefix: 'fab',
    iconName: 'stripe-s',
    icon: [384, 512, [], "f42a", "M155.6 154.6c0-22.3 18.6-30.9 48.4-30.9 43.4 0 98.5 13.3 141.9 36.7l0-134.3c-47.3-18.9-94.5-26.1-141.8-26.1-115.7 0-192.8 60.4-192.8 161.4 0 157.9 216.8 132.3 216.8 200.4 0 26.4-22.9 34.9-54.7 34.9-47.2 0-108.2-19.5-156.1-45.5l0 128.5c49.3 21.3 102.3 32.3 156 32.4 118.6 0 200.3-51 200.3-153.6 0-170.2-218-139.7-218-203.9z"]
  };
  var faSquareBehance = {
    prefix: 'fab',
    iconName: 'square-behance',
    icon: [448, 512, ["behance-square"], "f1b5", "M155.3 318.4c17.2 0 31.2-6.1 31.2-25.4 0-19.7-11.7-27.4-30.3-27.5l-46 0 0 52.9 45.1 0zm-5.4-129.6l-39.6 0 0 44.8 42.7 0c15.1 0 25.8-6.6 25.8-22.9 0-17.7-13.7-21.9-28.9-21.9zm129.5 74.8l62.2 0c-1.7-18.5-11.3-29.7-30.5-29.7-18.3 0-30.5 11.4-31.7 29.7zM384 32L64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64zM349.5 185l-77.8 0 0-18.9 77.8 0 0 18.9zM193.7 243.7c23.6 6.7 35 27.5 35 51.6 0 39-32.7 55.7-67.6 55.9l-93.1 0 0-192 90.5 0c32.9 0 61.4 9.3 61.4 47.5 0 19.3-9 28.8-26.2 37zm118.7-38.6c43.5 0 67.6 34.3 67.6 75.4 0 1.6-.1 3.3-.2 5 0 .8-.1 1.5-.1 2.2l-100.2 0c0 22.2 11.7 35.3 34.1 35.3 11.6 0 26.5-6.2 30.2-18.1l33.7 0c-10.4 31.9-31.9 46.8-65.1 46.8-43.8 0-71.1-29.7-71.1-73 0-41.8 28.7-73.6 71.1-73.6z"]
  };
  var faBehanceSquare = faSquareBehance;
  var faServicestack = {
    prefix: 'fab',
    iconName: 'servicestack',
    icon: [512, 512, [], "f3ec", "M96 216c81.7 10.2 273.7 102.3 304 232L8 448c99.5-8.1 184.5-137 88-232zM128 64c32.3 35.6 47.7 83.9 46.4 133.6 82.9 33.7 207.3 123.7 233.6 250.4l96 0C463.3 231.9 230.8 79.5 128 64z"]
  };
  var faRocketchat = {
    prefix: 'fab',
    iconName: 'rocketchat',
    icon: [576, 512, [], "f3e8", "M284.5 224.8c-6.7 0-13.3 2.1-18.9 5.8s-9.9 9.1-12.5 15.4-3.2 13.1-1.9 19.7 4.6 12.7 9.4 17.4 10.9 8 17.5 9.3 13.5 .6 19.7-2 11.5-7 15.3-12.6 5.7-12.2 5.7-18.9c0-9.1-3.7-17.8-10.1-24.2s-15.1-10-24.2-9.9zm-110.4 0c-6.7 0-13.3 2.1-18.9 5.8s-9.9 9.1-12.5 15.4-3.2 13.1-1.9 19.7 4.6 12.7 9.4 17.4 10.9 8 17.5 9.3 13.5 .6 19.7-2 11.5-7 15.3-12.6 5.7-12.2 5.7-18.9c0-9.1-3.7-17.8-10.1-24.2s-15.1-10-24.2-10l0 0zm220.9 0a34.1 34.1 0 1 0 .4 68.2 34.1 34.1 0 1 0 -.4-68.2zm153.8-55.3c-15.5-24.2-37.3-45.6-64.7-63.6-52.9-34.8-122.4-54-195.7-54-24.2 0-48.3 2.1-72 6.4-14.9-14.3-31.5-26.6-49.5-36.6-66.8-33.3-125.6-20.9-155.3-10.2-2.3 .8-4.3 2.1-5.9 3.9s-2.7 3.9-3.3 6.2-.5 4.7 .1 7.1 1.8 4.4 3.5 6.1C27 56.5 61.6 99.3 53.1 138.3 20 172.2 2 213 2 255.6 2 299 20 339.8 53.1 373.7 61.6 412.7 27 455.6 6 477.2 4.3 479 3.2 481.1 2.5 483.4s-.7 4.7-.1 7 1.7 4.5 3.3 6.2 3.6 3.1 5.9 3.9c29.7 10.7 88.5 23.1 155.3-10.2 18-10 34.7-22.3 49.5-36.6 23.8 4.3 47.9 6.4 72 6.4 73.3 0 142.8-19.2 195.7-54 27.4-18 49.1-39.4 64.7-63.6 17.3-26.9 26.1-55.9 26.1-86.1 0-31-8.8-60-26.1-86.9l0 0zM285.4 409.9c-30.2 .1-60.3-3.8-89.4-11.5l-20.1 19.4c-11.2 10.7-23.6 20-37.1 27.6-16.4 8.2-34.2 13.3-52.5 14.9 1-1.8 1.9-3.6 2.8-5.4 20.2-37.1 25.6-70.5 16.3-100.1-33-26-52.8-59.2-52.8-95.4 0-83.1 104.3-150.5 232.8-150.5s232.9 67.4 232.9 150.5c0 83.1-104.3 150.5-232.9 150.5z"]
  };
  var faRebel = {
    prefix: 'fab',
    iconName: 'rebel',
    icon: [512, 512, [], "f1d0", "M256.9 504c-139.3 0-247.5-116.2-243.3-254.1 2.8-79.2 43.2-152.2 116.5-200.4 .3 0 1.9-.6 1.1 .8-5.8 5.5-111.3 129.8-14.1 226.4 49.8 49.5 90 2.5 90 2.5 38.5-50.1-.6-125.9-.6-125.9-10-24.9-45.7-40.1-45.7-40.1l28.8-31.8c24.4 10.5 43.2 38.7 43.2 38.7 .8-29.6-21.9-61.4-21.9-61.4L255.5 8 299.8 58.1c-20.5 28.8-21.9 62.6-21.9 62.6 13.8-23 43.5-39.3 43.5-39.3l28.5 31.8c-27.4 8.9-45.4 39.9-45.4 39.9-15.8 28.5-27.1 89.4 .6 127.3 32.4 44.6 87.7-2.8 87.7-2.8 102.7-91.9-10.5-225-10.5-225-6.1-5.5 .8-2.8 .8-2.8 50.1 36.5 114.6 84.4 116.2 204.8 2 145.6-99.9 249.4-242.4 249.4z"]
  };
  var faSquareWebAwesome = {
    prefix: 'fab',
    iconName: 'square-web-awesome',
    icon: [448, 512, [], "e683", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zM235 177.6l53 46.4 52.2-10.4c-2.6-3.9-4.2-8.5-4.2-13.6 0-13.3 10.7-24 24-24s24 10.7 24 24c0 13-10.3 23.6-23.2 24L304.5 349.1c-5.2 11.5-16.6 18.9-29.2 18.9l-102.6 0c-12.6 0-24-7.4-29.2-18.9L87.2 224c-12.9-.4-23.2-11-23.2-24 0-13.3 10.7-24 24-24s24 10.7 24 24c0 5-1.5 9.7-4.2 13.6L160 224 213.1 177.6c-8.9-4.1-15-13.1-15-23.6 0-14.4 11.6-26 26-26s26 11.6 26 26c0 10.5-6.2 19.5-15.1 23.6z"]
  };
  var faLinktree = {
    prefix: 'fab',
    iconName: 'linktree',
    icon: [448, 512, [], "e7d8", "M32 173.4l125.8 0-89.4-85.4 49.5-51 85.2 87.8 0-124.8 73.9 0 0 124.8 85.2-87.6 49.4 50.8-89.4 85.2 125.7 0 0 70.5-126.4 0 90 87.6-49.3 49.8-122.2-123-122.2 123-49.5-49.6 90-87.6-126.4 0 0-70.5zM202.9 344.8l73.9 0 0 167.2-73.9 0 0-167.2z"]
  };
  var faSimplybuilt = {
    prefix: 'fab',
    iconName: 'simplybuilt',
    icon: [512, 512, [], "f215", "M481.6 64l-106 0C361.1 64 349 75.8 349 90.3l0 39.6-185.3 0 0-39.6c0-14.5-12-26.3-26.6-26.3l-106 0C16.5 64 4.7 75.8 4.7 90.3l0 331.4c0 14.5 11.8 26.3 26.6 26.3l450.4 0c14.8 0 26.6-11.8 26.6-26.3l0-331.4c-.2-14.5-12-26.3-26.7-26.3zM150.5 222.7a66.5 66.5 0 1 1 -.3 133.1 66.5 66.5 0 1 1 .3-133.1zm211.9 .1a66.5 66.5 0 1 1 .3 132.9 66.5 66.5 0 1 1 -.3-132.9z"]
  };
  var faStubber = {
    prefix: 'fab',
    iconName: 'stubber',
    icon: [448, 512, [], "e5c7", "M136.5 294.2l58.8 22.9c9.1-36.8 25.4-61.1 55-61.1 49.4 0 71.4 63.6 142.4 63.6 15.6 0 35.9-2.8 55.3-13.3l0 61.7c0 61.8-50.4 112-112.3 112L0 480 41.8 424 0 368 41.7 312 0 256.1 41.8 200.1 0 144.1 41.8 88 0 32 335.7 32C397.6 32 448 82.3 448 144.1l0 51.3c-9.2 36.3-25.9 60.6-55 60.6-49.6 0-71.6-63.5-142.4-63.5-35.9 0-95.2 14.6-114.1 101.6l0 .1z"]
  };
  var faApper = {
    prefix: 'fab',
    iconName: 'apper',
    icon: [640, 512, [], "f371", "M42.1 239.1c22.2 0 29 2.8 33.5 14.6l.8 0 0-22.9c0-11.3-4.8-15.4-17.9-15.4-11.3 0-14.4 2.5-15.1 12.8l-38.6 0c.3-13.9 1.5-19.1 5.8-24.4 7.3-8.8 18.9-11.8 46.1-11.8 33 0 47.1 5 53.9 18.9 2 4.3 4 15.6 4 23.7l0 76.3-38.3 0 1.3-19.1-1 0c-5.3 15.6-13.6 20.4-35.5 20.4-30.3 0-41.1-10.1-41.1-37.3 0-25.2 12.3-35.8 42.1-35.8zm17.1 48.1c13.1 0 16.9-3 16.9-13.4 0-9.1-4.3-11.6-19.6-11.6-13.1 0-17.9 3-17.9 12.1-.1 10.4 3.7 12.9 20.6 12.9zM137 192.3l38.3 0-1.5 20.6 .8 0c9.1-17.1 15.9-20.9 37.5-20.9 14.4 0 24.7 3 31.5 9.1 9.8 8.6 12.8 20.4 12.8 48.1 0 30-3 43.1-12.1 52.9-6.8 7.3-16.4 10.1-33.2 10.1-20.4 0-29.2-5.5-33.8-21.2l-.8 0 0 70.3-39.5 0 0-169zM217.9 253c0-27.5-3.3-32.5-20.7-32.5-16.9 0-20.7 5-20.7 28.7 0 28 3.5 33.5 21.2 33.5 16.4 0 20.2-5.6 20.2-29.7zm57.9-60.7l38.3 0-1.5 20.6 .8 0c9.1-17.1 15.9-20.9 37.5-20.9 14.4 0 24.7 3 31.5 9.1 9.8 8.6 12.8 20.4 12.8 48.1 0 30-3 43.1-12.1 52.9-6.8 7.3-16.4 10.1-33.3 10.1-20.4 0-29.2-5.5-33.8-21.2l-.8 0 0 70.3-39.5 0 0-169 .1 0zM356.7 253c0-27.5-3.3-32.5-20.7-32.5-16.9 0-20.7 5-20.7 28.7 0 28 3.5 33.5 21.2 33.5 16.4 0 20.2-5.6 20.2-29.7zm53.8-3.8c0-25.4 3.3-37.8 12.3-45.8 8.8-8.1 22.2-11.3 45.1-11.3 42.8 0 55.7 12.8 55.7 55.7l0 11.1-75.3 0c-.3 2-.3 4-.3 4.8 0 16.9 4.5 21.9 20.1 21.9 13.9 0 17.9-3 17.9-13.9l37.5 0 0 2.3c0 9.8-2.5 18.9-6.8 24.7-7.3 9.8-19.6 13.6-44.3 13.6-27.5 0-41.6-3.3-50.6-12.3-8.5-8.5-11.3-21.3-11.3-50.8zm76.4-11.6c-.3-1.8-.3-3.3-.3-3.8 0-12.3-3.3-14.6-19.6-14.6-14.4 0-17.1 3-18.1 15.1l-.3 3.3 38.3 0zm55.6-45.3l38.3 0-1.8 19.9 .7 0c6.8-14.9 14.4-20.2 29.7-20.2 10.8 0 19.1 3.3 23.4 9.3 5.3 7.3 6.8 14.4 6.8 34 0 1.5 0 5 .2 9.3l-35 0c.3-1.8 .3-3.3 .3-4 0-15.4-2-19.4-10.3-19.4-6.3 0-10.8 3.3-13.1 9.3-1 3-1 4.3-1 12.3l0 68-38.3 0 0-118.5 .1 0z"]
  };
  var faGoogleScholar = {
    prefix: 'fab',
    iconName: 'google-scholar',
    icon: [512, 512, [], "e63b", "M390.9 298.5s0 .1 .1 .1c9.2 19.4 14.4 41.1 14.4 64-.1 82.5-66.9 149.4-149.4 149.4S106.7 445.1 106.7 362.7c0-22.9 5.2-44.6 14.4-64 1.7-3.6 3.6-7.2 5.6-10.7 4.4-7.6 9.4-14.7 15-21.3 27.4-32.6 68.5-53.3 114.4-53.3 33.6 0 64.6 11.1 89.6 29.9 9.1 6.9 17.4 14.7 24.8 23.5 5.6 6.6 10.6 13.8 15 21.3 2 3.4 3.8 7 5.5 10.5l-.1-.1zm26.4-18.8c-30.1-58.4-91-98.4-161.3-98.4s-131.2 40-161.3 98.4l-94.7-77 256-202.7 256 202.7-94.7 77.1 0-.1z"]
  };
  var faYarn = {
    prefix: 'fab',
    iconName: 'yarn',
    icon: [512, 512, [], "f7e3", "M401.9 345.2c-39 9.3-48.4 32.1-104 47.4 0 0-2.7 4-10.4 5.8-13.4 3.3-63.9 6-68.5 6.1-12.4 .1-19.9-3.2-22-8.2-6.4-15.3 9.2-22 9.2-22-8.1-5-9-9.9-9.8-8.1-2.4 5.8-3.6 20.1-10.1 26.5-8.8 8.9-25.5 5.9-35.3 .8-10.8-5.7 .8-19.2 .8-19.2s-5.8 3.4-10.5-3.6c-6-9.3-17.1-37.3 11.5-62-1.3-10.1-4.6-53.7 40.6-85.6 0 0-20.6-22.8-12.9-43.3 5-13.4 7-13.3 8.6-13.9 5.7-2.2 11.3-4.6 15.4-9.1 20.6-22.2 46.8-18 46.8-18s12.4-37.8 23.9-30.4c3.5 2.3 16.3 30.6 16.3 30.6s13.6-7.9 15.1-5c8.2 16 9.2 46.5 5.6 65.1-6.1 30.6-21.4 47.1-27.6 57.5-1.4 2.4 16.5 10 27.8 41.3 10.4 28.6 1.1 52.7 2.8 55.3 .8 1.4 13.7 .8 36.4-13.2 12.8-7.9 28.1-16.9 45.4-17 16.7-.5 17.6 19.2 4.9 22.2zM8 256a248 248 0 1 1 496 0 248 248 0 1 1 -496 0zm416.7 75.2c-1.7-13.6-13.2-23-28-22.8-22 .3-40.5 11.7-52.8 19.2-4.8 3-8.9 5.2-12.4 6.8 3.1-44.5-22.5-73.1-28.7-79.4 7.8-11.3 18.4-27.8 23.4-53.2 4.3-21.7 3-55.5-6.9-74.5-1.6-3.1-7.4-11.2-21-7.4-9.7-20-13-22.1-15.6-23.8-1.1-.7-23.6-16.4-41.4 28-12.2 .9-31.3 5.3-47.5 22.8-2 2.2-5.9 3.8-10.1 5.4l.1 0c-8.4 3-12.3 9.9-16.9 22.3-6.5 17.4 .2 34.6 6.8 45.7-17.8 15.9-37 39.8-35.7 82.5-34 36-11.8 73-5.6 79.6-1.6 11.1 3.7 19.4 12 23.8 12.6 6.7 30.3 9.6 43.9 2.8 4.9 5.2 13.8 10.1 30 10.1 6.8 0 58-2.9 72.6-6.5 6.8-1.6 11.5-4.5 14.6-7.1 9.8-3.1 36.8-12.3 62.2-28.7 18-11.7 24.2-14.2 37.6-17.4 12.9-3.2 21-15.1 19.4-28.2z"]
  };
  var faStackOverflow = {
    prefix: 'fab',
    iconName: 'stack-overflow',
    icon: [384, 512, [], "f16c", "M291 311l-195.7-41.3-8.2 39.3 195.7 41 8.2-39zm51-87L188.5 95.7 163 126.5 316.5 254.8 342 224zm-31.2 39.7L129.5 179 112.8 215.5 294 300 310.8 263.7zM262.3 32l-32 24 119.3 160.3 32-24-119.3-160.3zm20.5 328l-200 0 0 39.7 200 0 0-39.7zm39.7 80l-279.5 0 0-120-40 0 0 160 359.5 0 0-160-40 0 0 120z"]
  };
  var faBluetooth = {
    prefix: 'fab',
    iconName: 'bluetooth',
    icon: [384, 512, [], "f293", "M260.6 171.1l-42.9 42.9-.3-86 43.2 43.1zM217.4 390.9l43.1-43.1-42.9-42.9-.2 86zM384 259.4C384 465 312.1 512 198.9 512S0 465 0 259.4 83.4 0 196.6 0 384 53.9 384 259.4zm-158.5 0l79.4-88.6-125.1-134.3 0 176.9-73.8-73.8-27 26.9 92.7 93-92.7 93 26.9 26.9 73.8-73.8 2.3 170 127.4-127.5-83.9-88.7z"]
  };
  var faCreativeCommonsNcJp = {
    prefix: 'fab',
    iconName: 'creative-commons-nc-jp',
    icon: [512, 512, [], "f4ea", "M255.7 8C111.6 8 8 124.8 8 256 8 392.4 119.8 504 255.7 504 385.9 504 504 403.2 504 256 504 117.2 396.5 8 255.7 8zm.6 450.7c-112 0-203.6-92.5-203.6-202.7 0-21.1 3-41.2 9-60.3l127 56.5-27.9 0 0 38.6 58.1 0 5.7 11.8 0 18.7-63.8 0 0 38.7 63.8 0 0 56 61.7 0 0-56 64.2 0 0-35.7 81 36.1c-1.5 2.2-57.1 98.3-175.2 98.3zm87.6-137.3l-57.6 0 0-18.7 2.9-5.6 54.7 24.3zm6.5-51.4l0-17.8-38.6 0 63-116-65.8 0-43.4 96-23-10.2-39.6-85.7-65.8 0 27.3 51-81.9-36.5c27.8-44.1 82.6-98.1 173.7-98.1 112.8 0 203 90 203 203.4 0 21-2.7 40.6-7.9 59L350.4 270z"]
  };
  var faReddit = {
    prefix: 'fab',
    iconName: 'reddit',
    icon: [512, 512, [], "f1a1", "M0 256C0 114.6 114.6 0 256 0S512 114.6 512 256 397.4 512 256 512L37.1 512c-13.7 0-20.5-16.5-10.9-26.2L75 437C28.7 390.7 0 326.7 0 256zM349.6 153.6c23.6 0 42.7-19.1 42.7-42.7s-19.1-42.7-42.7-42.7c-20.6 0-37.8 14.6-41.8 34-34.5 3.7-61.4 33-61.4 68.4l0 .2c-37.5 1.6-71.8 12.3-99 29.1-10.1-7.8-22.8-12.5-36.5-12.5-33 0-59.8 26.8-59.8 59.8 0 24 14.1 44.6 34.4 54.1 2 69.4 77.6 125.2 170.6 125.2s168.7-55.9 170.6-125.3c20.2-9.6 34.1-30.2 34.1-54 0-33-26.8-59.8-59.8-59.8-13.7 0-26.3 4.6-36.4 12.4-27.4-17-62.1-27.7-100-29.1l0-.2c0-25.4 18.9-46.5 43.4-49.9 4.4 18.8 21.3 32.8 41.5 32.8l.1 .2zM177.1 246.9c16.7 0 29.5 17.6 28.5 39.3s-13.5 29.6-30.3 29.6-31.4-8.8-30.4-30.5 15.4-38.3 32.1-38.3l.1-.1zm190.1 38.3c1 21.7-13.7 30.5-30.4 30.5s-29.3-7.9-30.3-29.6 11.8-39.3 28.5-39.3 31.2 16.6 32.1 38.3l.1 .1zm-48.1 56.7c-10.3 24.6-34.6 41.9-63 41.9s-52.7-17.3-63-41.9c-1.2-2.9 .8-6.2 3.9-6.5 18.4-1.9 38.3-2.9 59.1-2.9s40.7 1 59.1 2.9c3.1 .3 5.1 3.6 3.9 6.5z"]
  };
  var faConnectdevelop = {
    prefix: 'fab',
    iconName: 'connectdevelop',
    icon: [576, 512, [], "f20e", "M550.8 241l-50.1-86.8c1.1-2.1 1.9-4.6 1.9-7.2 0-8-6.7-14.7-14.7-15L432.4 36.1c.5-1.6 1.1-3.2 1.1-4.8 0-8.6-7-15.3-15.3-15.3-4.8 0-8.8 2.1-11.8 5.6l-106.6 0c-2.7-3.5-6.7-5.6-11.5-5.6s-8.8 2.1-11.5 5.6l-106.1 0c-2.9-3.5-7-5.6-11.8-5.6-8.3 0-15.3 6.7-15.3 15.3 0 1.6 .5 3.5 1.1 4.8l-56 97.2c-5.4 2.4-9.1 7.5-9.1 13.7 0 .5 .3 1.1 .3 1.6L26.6 240.7c-7.2 1.3-12.6 7.5-12.6 15 0 7.2 5.1 13.4 12.1 15l55.2 95.4c-.5 1.6-.8 2.9-.8 4.8 0 7.2 5.1 13.4 12.1 14.7l51.7 89.7c-.5 1.6-1.1 3.5-1.1 5.4 0 8.6 7 15.3 15.3 15.3 4.8 0 8.8-2.1 11.5-5.4l106.9 0c2.7 3.2 7 5.4 11.5 5.4s8.8-2.1 11.5-5.4l107.1 0c2.7 2.9 6.7 4.8 11 4.8 8.6 0 15.3-7 15.3-15.3 0-1.6-.3-2.9-.8-4.3l51.7-90.3c7-1.3 12.1-7.5 12.1-14.7 0-1.6-.3-3.2-.8-4.8l54.9-95.4c7-1.3 12.3-7.5 12.3-15 0-7.2-5.1-13.4-11.8-14.7zm-397 209.7l-43.7-75.8 43.7 0 0 75.8zm0-83.8l-43.7 0c-.3-1.1-.8-2.1-1.3-3.2l45-47.4 0 50.6zm0-62.4l-50.4 53.3c-1.3-.5-2.7-1.3-4-1.6L43.7 259.8c.5-1.3 .5-2.7 .5-4s0-2.4-.3-3.5l52-90c2.7-.3 5.4-1.1 7.8-2.7l50.1 52 0 92.9zm0-102.3L108 154.8c1.3-2.1 2.1-4.8 2.1-7.8 0-.3-.3-.8-.3-1.1l43.9-15.8 0 72.1zm0-80.6l-43.7 15.8 43.7-75.5 0 59.7zm326.5 39.1l.8 1.3-35.4 167.1-63.8-67.2 98-101.5 .3 .3zM292.1 355.1l11.5 11.8-22.8 0 11.3-11.8zm-.3-11.3l-83.3-85.4 79.6-84.4 83 87.6-79.3 82.2zm5.4 5.9l79.3-82.2 67.5 71.3-5.9 28.1-124 0-16.9-17.1zM410.7 44.4c1.1 .5 2.1 1.1 3.5 1.3l57.9 100.7 0 .5c0 2.9 .8 5.6 2.1 7.8l-97.5 101.2-83-87.6 117.1-124zm-9.1-2.1l-113.6 120.3-57.1-60.3 166.3-60 4.3 0zm-123.5 0c2.7 2.7 6.2 4.3 10.2 4.3s7.5-1.6 10.2-4.3l75 0-148.4 53.6-50.9-53.6 103.9 0zM161.9 47.9l1.1-2.1c.9-.2 1.8-.5 2.7-.8l51.2 53.8-54.9 19.8 0-70.7zm0 79.3l60.8-22 59.7 63.2-79.6 84.1-41-42.1 0-83.3zm0 92.7l36.4 37.8-36.4 38.3 0-76.1zm0 87.9l42.1-44.5 82.8 86-17.1 17.7-107.7 0 0-59.2zm7 162.1c-1.6-1.6-3.5-2.7-5.9-3.5l-1.1-1.6 0-89.7 99.9 0-91.6 94.8-1.3 0zm129.9 0c-2.7-2.4-6.4-4.3-10.4-4.3s-7.8 1.9-10.4 4.3l-96.4 0 91.6-94.8 38.3 0 91.6 94.8-104.2 0zm120-11.8l-4.3 7.5c-1.3 .3-2.4 .8-3.5 1.3l-89.2-91.9 114.4 0-17.4 83zm12.9-22.2l12.9-60.8 22 0-34.8 60.8zm34.8-68.8l-20.4 0 4.6-21.2 17.1 18.2c-.5 .8-1.1 1.9-1.3 2.9zm66.2-107.4l-55.4 96.7c-1.3 .5-2.7 1.1-4 1.9l-20.6-22 34.6-163.9 45.8 79.3c-.3 1.3-.8 2.7-.8 4.3 0 1.3 .3 2.4 .5 3.7z"]
  };
  var faResearchgate = {
    prefix: 'fab',
    iconName: 'researchgate',
    icon: [448, 512, [], "f4f8", "M0 32l0 448 448 0 0-448-448 0zM262.2 366.4c-6.6 3-33.2 6-50-14.2-9.2-10.6-25.3-33.3-42.2-63.6-8.9 0-14.7 0-21.4-.6l0 46.4c0 23.5 6 21.2 25.8 23.9l0 8.1c-6.9-.3-23.1-.8-35.6-.8-13.1 0-26.1 .6-33.6 .8l0-8.1c15.5-2.9 22-1.3 22-23.9l0-109.4c0-22.6-6.4-21-22-23.9l0-8.1c25.8 1 53.1-.6 70.9-.6 31.7 0 55.9 14.4 55.9 45.6 0 21.1-16.7 42.2-39.2 47.5 13.6 24.2 30 45.6 42.2 58.9 7.2 7.8 17.2 14.7 27.2 14.7l0 7.3zm22.9-135c-23.3 0-32.2-15.7-32.2-32.2l0-32.2c0-12.2 8.8-30.4 34-30.4s30.4 17.9 30.4 17.9l-10.7 7.2s-5.5-12.5-19.7-12.5c-7.9 0-19.7 7.3-19.7 19.7l0 26.8c0 13.4 6.6 23.3 17.9 23.3 14.1 0 21.5-10.9 21.5-26.8l-17.9 0 0-10.7 30.4 0c0 20.5 4.7 49.9-34 49.9zM168.6 276.1c-9.4 0-13.6-.3-20-.8l0-69.7c6.4-.6 15-.6 22.5-.6 23.3 0 37.2 12.2 37.2 34.5 0 21.9-15 36.6-39.7 36.6z"]
  };
  var faSignalMessenger = {
    prefix: 'fab',
    iconName: 'signal-messenger',
    icon: [512, 512, [], "e663", "M256 0c-13.3 0-26.3 1-39.1 3l3.7 23.7C232.1 24.9 244 24 256 24s23.9 .9 35.4 2.7L295.1 3C282.3 1 269.3 0 256 0zm60.8 7.3l-5.7 23.3c23.4 5.7 45.4 14.9 65.4 27.1l12.5-20.5c-22.1-13.4-46.4-23.6-72.2-29.9zm76.4 61.6c19.1 14 36 30.9 50.1 50.1l19.4-14.2C447 83.6 428.4 65 407.3 49.5L393.1 68.8zm81.7 54.2l-20.5 12.5c12.2 20 21.4 42 27.1 65.4l23.3-5.7c-6.3-25.8-16.5-50.1-29.9-72.2zm10.5 97.5c1.8 11.5 2.7 23.4 2.7 35.4s-.9 23.9-2.7 35.4l23.7 3.7c1.9-12.7 3-25.8 3-39.1s-1-26.3-3-39.1l-23.7 3.7zm-31 155.9l20.5 12.5c13.4-22.1 23.6-46.4 29.9-72.2l-23.3-5.7c-5.7 23.4-14.9 45.4-27.1 65.4zm8.2 30.8l-19.4-14.2c-14 19.1-30.9 36-50.1 50.1l14.2 19.4c21.1-15.5 39.8-34.1 55.2-55.2zm-86.1 47c-20 12.2-42 21.4-65.4 27.1l5.7 23.3c25.8-6.3 50.1-16.5 72.2-29.9l-12.5-20.5zM295.1 509l-3.7-23.7C279.9 487.1 268 488 256 488s-23.9-.9-35.4-2.7L216.9 509c12.7 1.9 25.8 3 39.1 3s26.3-1 39.1-3zm-94.1-27.6c-17.6-4.3-34.4-10.6-50.1-18.6l-7.8-4-32.8 7.7 5.5 23.4 24.3-5.7c17.4 8.9 35.9 15.8 55.3 20.5l5.7-23.3zM95.4 494.6L90 471.3 48.3 481c-10.4 2.4-19.7-6.9-17.3-17.3l9.7-41.6-23.4-5.5-9.7 41.6C1.2 486 26 510.8 53.8 504.4l41.6-9.7zm-50-92.9l7.7-32.8-4-7.8c-8-15.7-14.3-32.5-18.6-50.1L7.3 316.7C12 336.1 18.9 354.7 27.7 372l-5.7 24.3 23.4 5.5zM3 295.1l23.7-3.7C24.9 279.9 24 268 24 256s.9-23.9 2.7-35.4L3 216.9C1 229.7 0 242.7 0 256s1 26.3 3 39.1zm27.6-94.1c5.7-23.4 14.9-45.4 27.1-65.4L37.2 123.1c-13.4 22.1-23.6 46.4-29.9 72.2l23.3 5.7zm18.9-96.2l19.4 14.2c14-19.1 30.9-36 50.1-50.1L104.7 49.5C83.6 65 65 83.6 49.5 104.7zm86.1-47c20-12.2 42-21.4 65.4-27.1L195.2 7.3c-25.8 6.3-50.1 16.5-72.2 29.9l12.5 20.5zM256 464c114.9 0 208-93.1 208-208S370.9 48 256 48 48 141.1 48 256c0 36.4 9.4 70.7 25.8 100.5 1.6 2.9 2.1 6.2 1.4 9.4l-21.6 92.5 92.5-21.6c3.2-.7 6.5-.2 9.4 1.4 29.8 16.5 64 25.8 100.5 25.8z"]
  };
  var faXing = {
    prefix: 'fab',
    iconName: 'xing',
    icon: [384, 512, [], "f168", "M162.7 210c-1.8 3.3-25.2 44.4-70.1 123.5-4.9 8.3-10.8 12.5-17.7 12.5L9.8 346c-7.7 0-12.1-7.5-8.5-14.4l69-121.3c.2 0 .2-.1 0-.3L26.4 134.4c-4.3-7.8 .3-14.1 8.5-14.1l65.1 0c7.3 0 13.3 4.1 18 12.2L162.7 210zM382.6 46.1l-144 253 0 .3 91.6 166.6c3.9 7.1 .2 14.1-8.5 14.1l-65.2 0c-7.6 0-13.6-4-18-12.2L146.1 299.4c3.3-5.8 51.5-90.8 144.8-255.2 4.6-8.1 10.4-12.2 17.5-12.2l65.7 0c8 0 12.3 6.7 8.5 14.1z"]
  };
  var faSquareJs = {
    prefix: 'fab',
    iconName: 'square-js',
    icon: [448, 512, ["js-square"], "f3b9", "M448 96c0-35.3-28.7-64-64-64L64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320zM180.9 444.9c-33.7 0-53.2-17.4-63.2-38.5L152 385.7c6.6 11.7 12.6 21.6 27.1 21.6 13.8 0 22.6-5.4 22.6-26.5l0-143.1 42.1 0 0 143.7c0 43.6-25.6 63.5-62.9 63.5zm85.8-43L301 382.1c9 14.7 20.8 25.6 41.5 25.6 17.4 0 28.6-8.7 28.6-20.8 0-14.4-11.4-19.5-30.7-28l-10.5-4.5c-30.4-12.9-50.5-29.2-50.5-63.5 0-31.6 24.1-55.6 61.6-55.6 26.8 0 46 9.3 59.8 33.7L368 290c-7.2-12.9-15-18-27.1-18-12.3 0-20.1 7.8-20.1 18 0 12.6 7.8 17.7 25.9 25.6l10.5 4.5c35.8 15.3 55.9 31 55.9 66.2 0 37.8-29.8 58.6-69.7 58.6-39.1 0-64.4-18.6-76.7-43z"]
  };
  var faJsSquare = faSquareJs;
  var faFonticons = {
    prefix: 'fab',
    iconName: 'fonticons',
    icon: [448, 512, [], "f280", "M0 32l0 448 448 0 0-448-448 0zM187 172.9c-18.4 0-19 9.9-19 27.4l0 23.3c0 2.4-3.5 4.4-.6 4.4l67.4 0-11.1 37.3-55.7 0 0 112.9c0 5.8-2 6.7 3.2 7.3l43.5 4.1 0 25.1-130.7 0 0-25.7 21.3-2c5.2-.6 6.7-2.3 6.7-7.9l0-111.4c0-2.3-2.9-2.3-5.8-2.3l-22.2 0 0-37.4 28 0 0-21c0-49.6 26.5-70 77.3-70 34.1 0 64.7 8.2 64.7 52.8l-50.7 6.1c.3-18.7-4.4-23-16.3-23zm74.3 241.8l0-25.1 20.4-2.6c5.2-.6 7.6-1.7 7.6-7.3l0-107.9c0-4.1-2.9-6.7-6.7-7.9l-24.2-6.4 6.7-29.5 80.2 0 0 151.7c0 5.8-2.6 6.4 2.9 7.3l15.7 2.6 0 25.1-102.6 0zm80.8-255.5l9 33.2-7.3 7.3-31.2-16.6-31.2 16.6-7.3-7.3 9-33.2-21.8-24.2 3.5-9.6 27.7 0 15.5-28 9.3 0 15.5 28 27.7 0 3.5 9.6-21.9 24.2z"]
  };
  var faUps = {
    prefix: 'fab',
    iconName: 'ups',
    icon: [384, 512, [], "f7e0", "M103.2 303c-5.2 3.6-32.6 13.1-32.6-19l0-104-32.7 0 0 102.6c0 74.9 80.2 51.1 97.9 39l0-141.6-32.6 0 0 123zM4 74.8L4 295.7c0 103.7 74.9 135.2 187.7 184.1 112.4-48.9 187.7-80.2 187.7-184.1l0-220.9C263.1 13.2 97.6 25.2 4 74.8zM362.1 295.7c0 86.6-53.2 113.6-170.4 165.3-117.5-51.8-170.5-78.7-170.5-165.3l0-126.4c102.3-93.8 231.6-100 340.9-89.8l0 216.2zM152.5 188.3l0 212.8 32.7 0 0-68.7c24.4 7.3 71.7-2.6 71.7-78.5 0-97.4-80.7-80.9-104.4-65.6zm32.7 117.3l0-100.3c8.4-4.2 38.4-12.7 38.4 49.3 0 67.9-36.4 51.8-38.4 51zm79.1-86.4c.1 47.3 51.6 42.5 52.2 70.4 .6 23.5-30.4 23-50.8 4.9l0 30.1c36.2 21.5 81.9 8.1 83.2-33.5 1.7-51.5-54.1-46.6-53.4-73.2 .6-20.3 30.6-20.5 48.5-2.2l0-28.4c-28.5-22-79.9-9.2-79.7 31.9z"]
  };
  var faAmazonPay = {
    prefix: 'fab',
    iconName: 'amazon-pay',
    icon: [640, 512, [], "f42c", "M14 325.3c2.3-4.2 5.2-4.9 9.7-2.5 10.4 5.6 20.6 11.4 31.2 16.7 40.6 20.2 83.3 35.8 127.4 46.3 20.8 5 41.9 9 63.2 11.8 31.5 4.2 63.2 6 95 5.2 17.4-.4 34.8-1.8 52.1-3.8 56.2-6.6 111.1-21 163.3-42.8 2.9-1.2 5.9-2 9.1-1.2 6.7 1.8 9 9 4.1 13.9-3 2.7-6.2 5.2-9.6 7.4-30.7 21.1-64.2 36.4-99.6 47.9-24.5 7.9-49.6 13.8-75.1 17.6-17.6 2.7-35.4 4.3-53.2 4.8-.8 0-1.7 .2-2.5 .3l-21.1 0c-.8-.1-1.7-.2-2.5-.3-3.6-.2-7.2-.3-10.7-.4-16.9-.8-33.7-2.5-50.4-5.3-27.4-4.5-54.3-11.5-80.4-20.9-53.7-19.4-103.1-48.9-145.6-87-1.8-1.6-3-3.8-4.4-5.7l0-2zM172 65.1l-4.3 .6c-13.8 1.7-26.8 6.9-38 15.1-2.4 1.7-4.6 3.5-7.1 5.4-.2-.4-.3-.9-.4-1.4-.4-2.7-.8-5.5-1.3-8.2-.7-4.6-3-6.6-7.6-6.6l-11.5 0c-6.9 0-8.2 1.3-8.2 8.2l0 209.3c0 1 0 2 .1 3 .2 3 2 4.9 4.9 5 7 .1 14.1 .1 21.1 0 2.9 0 4.7-2 5-5 .1-1 .1-2 .1-3l0-72.4c1.1 .9 1.7 1.4 2.2 1.9 17.9 14.9 38.5 19.8 61 15.4 20.4-4 34.6-16.5 43.8-34.9 7-13.9 9.9-28.7 10.3-44.1 .5-17.1-1.2-33.9-8.1-49.8-8.5-19.6-22.6-32.5-43.9-36.9-3.2-.7-6.5-1-9.8-1.5-2.8-.1-5.5-.1-8.3-.1zM124.6 107c-.1-.7 .1-1.3 .4-1.9s.8-1.1 1.3-1.4c13.7-9.5 28.8-14.5 45.6-13.2 14.9 1.1 27.1 8.4 33.5 25.9 3.9 10.7 4.9 21.8 4.9 33 0 10.4-.8 20.6-4 30.6-6.8 21.3-22.4 29.4-42.6 28.5-14-.6-26.2-6-37.4-13.9-.6-.3-1-.8-1.3-1.4s-.4-1.2-.4-1.9c.1-14.1 0-28.1 0-42.2s.1-28 0-42.1zM330.3 65.1c-1 .1-2 .3-2.9 .4-9.7 .4-19.4 1.8-28.9 4.1-6.1 1.6-12 3.8-17.9 5.8-3.6 1.2-5.4 3.8-5.3 7.7 .1 3.3-.1 6.6 0 9.9 .1 4.8 2.1 6.1 6.8 4.9 7.8-2 15.6-4.2 23.5-5.7 12.3-2.3 24.7-3.3 37.2-1.4 6.5 1 12.6 2.9 16.8 8.4 3.7 4.8 5.1 10.5 5.3 16.4 .3 8.3 .2 16.6 .3 24.9 0 .5-.1 .9-.2 1.4-.5-.1-.9 0-1.3-.1-10.5-2.6-21.2-4.2-32-4.9-11.3-.6-22.5 .1-33.3 3.9-12.9 4.5-23.3 12.3-29.4 24.9-4.7 9.8-5.4 20.2-3.9 30.7 2 14 9 24.8 21.4 31.7 11.9 6.6 24.8 7.4 37.9 5.4 15.1-2.3 28.5-8.7 40.3-18.4 .5-.4 1-.8 1.6-1.1 .6 3.8 1.1 7.4 1.8 11 .6 3.1 2.5 5.1 5.4 5.2 5.4 .1 10.9 .1 16.3 0 1.3 0 2.5-.5 3.4-1.4s1.4-2.1 1.5-3.3c.1-.9 .1-1.9 .1-2.8l0-106c0-4.3-.3-8.6-.9-12.9-1.9-12.9-7.4-23.5-19-30.4-6.7-4-14.1-6-21.8-7.1-3.6-.5-7.2-.8-10.8-1.3-3.9 .1-7.9 .1-11.9 .1zm35 127.7c0 .6-.1 1.2-.3 1.7s-.7 1-1.2 1.3c-11.2 8.1-23.5 13.5-37.4 14.9-5.7 .6-11.4 .4-16.8-1.8-3-1.1-5.6-2.9-7.8-5.2s-3.7-5.1-4.6-8.1c-2-6.3-2-13.1-.1-19.4 2.5-8.3 8.4-13 16.4-15.6 8-2.4 16.5-3.2 24.8-2.2 8.4 .7 16.6 2.3 25 3.4 1.6 .2 2.1 1 2.1 2.6-.1 4.8 0 9.5 0 14.3s-.2 9.4-.1 14.1zM625.2 322.2c-1-5-4.8-6.9-9.1-8.3-6.8-2.1-13.9-3.5-21-3.9-13.1-1.1-26.3-.5-39.2 1.9-14.3 2.7-27.9 7.3-40 15.6-1.4 .9-2.7 2.1-3.7 3.5-.4 .6-.6 1.3-.7 1.9s0 1.4 .2 2.1c.4 1.5 2.1 1.9 3.6 1.8 .7 0 1.5 0 2.2-.1 7.8-.8 15.5-1.7 23.3-2.5 11.4-1.1 22.9-1.8 34.3-.9 4.9 .4 9.7 1.3 14.4 2.7 5.1 1.4 7.4 5.2 7.6 10.4 .4 8-1.4 15.7-3.5 23.3-4.1 15.4-10 30.3-15.8 45.1-.4 1-.8 2-1 3-.5 2.9 1.2 4.8 4.1 4.1 1.8-.4 3.4-1.3 4.8-2.5 4.5-4.2 8.8-8.7 12.7-13.4 12.8-16.4 20.3-35.3 24.7-55.6 .8-3.6 1.4-7.3 2.1-10.9l0-17.3zM493.1 199c-12.9-35.7-25.8-71.4-38.7-107.2-2-5.7-4.2-11.3-6.3-16.9-1.1-2.9-3.2-4.8-6.4-4.8-7.6-.1-15.2-.2-22.9-.1-2.5 0-3.7 2-3.2 4.5 .5 2.1 1.1 4.1 1.9 6.1 19.6 48.5 39.3 97 59.1 145.5 1.7 4.1 2.1 7.6 .2 11.8-3.3 7.3-5.9 15-9.3 22.3-3 6.5-8 11.4-15.2 13.3-5 1.3-10.2 1.7-15.4 1.1-2.5-.2-5-.8-7.5-1-3.4-.2-5.1 1.3-5.2 4.8-.1 3.3-.1 6.6 0 9.9 .1 5.5 2 8 7.4 8.9 5.6 1.1 11.2 1.8 16.9 2 17.1 .4 30.7-6.5 39.5-21.4 3.5-5.9 6.6-12 9.2-18.4 23.7-59.8 47.2-119.7 70.6-179.6 .7-1.8 1.3-3.6 1.6-5.5 .4-2.8-.9-4.4-3.7-4.4-6.6-.1-13.3 0-19.9 0-1.7-.1-3.4 .3-4.7 1.3s-2.4 2.3-3 3.9c-.5 1.4-1.1 2.7-1.6 4.1l-34.8 100c-2.5 7.2-5.1 14.5-7.7 22.2-.4-1.1-.6-1.7-.9-2.4z"]
  };
  var faPandora = {
    prefix: 'fab',
    iconName: 'pandora',
    icon: [384, 512, [], "e7da", "M201.3 32L0 32 0 480 120.2 480c11.2 0 20.3-9.1 20.3-20.3l0-86.1 30.1 0c147.1 0 207.3-82.9 207.3-179.9 0-119.7-90.9-161.8-176.5-161.8z"]
  };
  var faOpenid = {
    prefix: 'fab',
    iconName: 'openid',
    icon: [448, 512, [], "f19b", "M271.5 432l-68 32C88.5 453.7 0 392.5 0 318.2 0 246.7 82.5 187.2 191.7 173.9l0 43c-71.5 12.5-124 53-124 101.3 0 51 58.5 93.3 135.7 103l0-340 68-33.2 0 384 .1 0zM448 291l-131.3-28.5 36.8-20.7c-19.5-11.5-43.5-20-70-24.8l0-43c46.2 5.5 87.7 19.5 120.3 39.3l35-19.8 9.2 97.5z"]
  };
  var faVsco = {
    prefix: 'fab',
    iconName: 'vsco',
    icon: [512, 512, [], "e7dd", "M357.6 256c0-27.1-10.6-52.5-29.7-71.7s-44.6-29.7-71.7-29.7l-.1 0c-27.1 0-52.6 10.6-71.7 29.7s-29.7 44.6-29.7 71.7c0 27.1 10.6 52.5 29.7 71.7 19.2 19.2 44.6 29.7 71.7 29.7l.1 0c27.1 0 52.6-10.6 71.7-29.7 19.2-19.2 29.7-44.6 29.7-71.7zM176.3 482.1c23 8.1 47 12.6 71.6 13.4l0-59.1c-17.1-.7-33.5-3.8-49-8.9l-22.6 54.6zm137-54.6c-15.5 5.1-32 8.2-49 8.9l0 59.1c24.6-.8 48.6-5.3 71.6-13.4l-22.6-54.6zM92.5 431.2c20.2 18.9 43.3 34 68.7 45l22.5-54.5c-18.3-7.9-35.1-18.8-49.8-31.9L92.5 431.2zm285.9-41.4c-14.6 13.2-31.4 24-49.8 31.9l22.5 54.5c25.4-11 48.4-26.1 68.7-45l-41.4-41.4zM145.4 378.2c13.6 12.1 29 21.9 45.8 29 18 7.6 37.1 12 56.7 12.9l0-46.8c-26.4-1.8-50.3-12.3-69.1-28.6l-33.4 33.4zm188-33.4c-18.8 16.3-42.7 26.8-69.1 28.6l0 46.8c19.6-.9 38.7-5.3 56.7-12.9 16.8-7.1 32.2-16.9 45.8-29l-33.4-33.4zM38.5 356.6c10.7 23.2 25 44.3 42.5 63.1l41.3-41.3c-12.4-13.4-22.9-28.6-30.9-45.2L38.5 356.6zm382.4-23.5c-8 16.6-18.5 31.9-30.9 45.2l41.3 41.3c17.5-18.7 31.8-39.9 42.5-63.1l-52.9-23.5zm-331-69c1.1 18.8 5.4 37.2 12.8 54.5 7.5 17.8 18 34 31.2 48.2l33.5-33.5c-16.4-18.8-26.9-42.8-28.7-69.2l-48.8 0zm283.7 0c-1.8 26.4-12.3 50.4-28.7 69.2l33.5 33.5c13.1-14.2 23.6-30.4 31.2-48.2 7.3-17.4 11.6-35.7 12.7-54.5l-48.7 0zm-357.1 0c.9 26.7 6.1 52.7 15.6 77.5L85 318.2c-6.4-17-10.3-35.1-11.3-54l-57.1 0zm422.1 0c-1 18.9-5 37.1-11.3 54l52.8 23.5c9.5-24.8 14.7-50.8 15.6-77.5l-57.1 0zM32.1 170.4c-9.5 24.8-14.7 50.8-15.6 77.5l57.1 0c1-18.9 5-37.1 11.3-54L32.1 170.4zm101.7-25.2c-13.1 14.2-23.6 30.4-31.2 48.2-7.3 17.4-11.6 35.7-12.8 54.5l48.8 0c1.8-26.4 12.3-50.4 28.7-69.2l-33.5-33.5zm211.1 33.5c16.4 18.8 26.9 42.8 28.7 69.2l48.7 0c-1.1-18.8-5.4-37.2-12.7-54.5-7.5-17.8-18-34-31.2-48.2l-33.5 33.5zm82.4 15.2c6.4 17 10.3 35.1 11.3 54l57.1 0c-.9-26.7-6.1-52.7-15.6-77.5l-52.8 23.5zM81 92.3C63.4 111 49.2 132.2 38.5 155.4l52.9 23.5c8-16.6 18.5-31.9 30.9-45.2L81 92.3zm309 41.3c12.4 13.4 22.9 28.6 30.9 45.2l52.9-23.5c-10.7-23.2-25-44.3-42.5-63.1L390 133.7zM248 91.8c-19.6 .9-38.7 5.3-56.7 12.9-16.8 7.1-32.2 16.9-45.8 29l33.4 33.4c18.8-16.3 42.7-26.8 69.1-28.6l0-46.7zm16.3 46.7c26.4 1.8 50.3 12.3 69.1 28.6l33.4-33.4c-13.6-12.1-29-21.9-45.8-29-18-7.6-37.1-12-56.7-12.9l0 46.7zM161.2 35.8c-25.4 11-48.4 26.1-68.7 45l41.4 41.4c14.7-13.2 31.4-24 49.8-31.9L161.2 35.8zM328.6 90.3c18.3 7.9 35.1 18.8 49.8 31.9l41.4-41.4c-20.2-18.9-43.3-34-68.7-45L328.6 90.3zM248 16.4c-24.6 .8-48.6 5.3-71.6 13.4l22.6 54.6c15.5-5.1 32-8.2 49-8.9l0-59.1zm16.3 59.1c17.1 .7 33.5 3.8 49 8.9l22.6-54.6c-23-8.1-47-12.6-71.6-13.4l0 59.1zM512.2 264.2l-.2 0C507.8 399 399.2 507.7 264.3 511.9l0 .1-16.3 0 0-.1C113.1 507.7 4.5 399 .2 264.1l-.2 0 0-16.3 .2 0C4.5 113 113.1 4.3 248 .1l0-.1 16.3 0 0 .1C399.2 4.3 507.8 113 512 247.9l.2 0 0 16.3z"]
  };
  var faUbuntu = {
    prefix: 'fab',
    iconName: 'ubuntu',
    icon: [576, 512, [], "f7df", "M469.2 75c0-20.1-8-39.3-22.2-53.5s-33.4-22.2-53.5-22.2-39.3 8-53.5 22.2-22.2 33.4-22.2 53.5c0 20.1 8 39.3 22.1 53.5s33.4 22.1 53.5 22.1 39.3-8 53.5-22.1 22.1-33.4 22.1-53.5l.1 0zm-315 165.7a75.6 75.6 0 1 0 -151.2 0 75.6 75.6 0 1 0 151.2 0zM57 346c18.6 46.9 51 87 93 115.1s91.5 42.6 142 41.7c-14.7-18.6-22.9-41.5-23.2-65.2-6.8-.9-13.3-2.1-19.5-3.4-26.8-5.7-51.9-17.3-73.6-34s-39.3-38.1-51.7-62.5c-20.9 9.9-44.5 12.8-67.1 8.2l.1 .1zm395.1 89.8a75.6 75.6 0 1 0 -151.2 0 75.6 75.6 0 1 0 151.2 0zM444 351.6c18.5 14.8 31.6 35.2 37.2 58.2 33.3-41.3 52.6-92.2 54.8-145.2s-12.5-105.4-42.2-149.4c-8.6 21.5-24 39.6-43.8 51.6 15.4 28.6 22.9 60.8 21.9 93.2s-10.7 64-28 91.6l.1 0zM101.1 135.4c12.4 2.7 24.3 7.5 35.1 14.3 16.6-24.2 38.9-44.1 64.8-58S255.8 70.4 285.2 70c.2-5.9 .9-11.9 2-17.7 3.6-16.7 11.1-32.3 21.8-45.5-47.7-3.8-95.4 6-137.6 28.5S94.3 91.7 70.8 133.4c2.7-.2 5.3-.3 8-.3 7.5 0 15 .8 22.4 2.3l-.1 0z"]
  };
  var faViacoin = {
    prefix: 'fab',
    iconName: 'viacoin',
    icon: [384, 512, [], "f237", "M384 32l-64 0-80.7 192-94.5 0-80.8-192-64 0 48 112-48 0 0 48 68.5 0 13.8 32-82.3 0 0 48 102.8 0 89.2 208 89.2-208 102.8 0 0-48-82.3 0 13.8-32 68.5 0 0-48-48 0 48-112zM192 336l-27-64 54 0-27 64z"]
  };
  var faZhihu = {
    prefix: 'fab',
    iconName: 'zhihu',
    icon: [640, 512, [], "f63f", "M170.5 148.1l0 217.5 23.4 0 7.7 26.4 42-26.4 49.5 0 0-217.5-122.7 0zm97.8 193.9l-27.9 0-27.9 17.5-5.1-17.5-11.9 0 0-170.3 72.8 0 0 170.3zM149.8 247.7l-52.3 0c1.7-27.1 2.2-51.6 2.2-73.5l51.2 0s2-22.6-8.6-22.3l-88.5 0c3.5-13.1 7.9-26.7 13.1-40.7 0 0-24.1 0-32.3 21.6-3.4 8.9-13.2 43.1-30.7 78.1 5.9-.6 25.4-1.2 36.8-22.2 2.1-5.9 2.5-6.7 5.1-14.5l28.9 0c0 10.5-1.2 66.9-1.7 73.4l-52.3 0c-11.7 0-15.6 23.6-15.6 23.6l65.6 0c-4.4 49.9-28 91.9-70.8 125.1 20.5 5.9 40.9-.9 51-9.9 0 0 23-20.9 35.6-69.3l54 64.9s7.9-26.9-1.2-40c-7.6-8.9-28.1-33.1-36.8-41.8L87.9 312c4.4-14 7-27.6 7.9-40.7l61.6 0s-.1-23.6-7.6-23.6l0 0zm412-1.6c20.8-25.6 45-58.6 45-58.6s-18.6-14.8-27.4-4.1c-6 8.2-36.8 48.2-36.8 48.2l19.2 14.4zM411.8 187c-9-8.2-25.9 2.1-25.9 2.1s39.5 55 41.1 57.4l19.5-13.7s-25.7-37.6-34.7-45.9l0 0 0 0zM640 258.4c-19.8 0-130.9 .9-131.1 .9l0-101c4.8 0 12.4-.4 22.8-1.2 40.9-2.4 70.1-4 87.8-4.8 0 0 12.2-27.2-.6-33.4-3.1-1.2-23.2 4.6-23.2 4.6s-165.2 16.5-232.4 18c1.6 8.8 7.6 17.1 15.8 19.6 13.3 3.5 22.7 1.7 49.2 .9 24.8-1.6 43.7-2.4 56.5-2.4l0 99.8-133.5 0s2.8 22.3 25.5 22.9l107.9 0 0 70.9c0 14-11.2 22-24.5 21.1-14.1 .1-26.1-1.1-41.7-1.8 2 4 6.3 14.4 19.3 21.8 9.9 4.8 16.2 6.6 26 6.6 29.6 0 45.7-17.3 44.9-45.3l0-73.3 122.4 0c9.7 0 8.7-23.8 8.7-23.8l0 0z"]
  };
  var faYandex = {
    prefix: 'fab',
    iconName: 'yandex',
    icon: [256, 512, [], "f413", "M153.1 315.8L65.7 512 2 512 98 302.2C52.9 279.3 22.8 237.8 22.8 161.1 22.7 53.7 90.8 0 171.7 0l82.3 0 0 512-55.1 0 0-196.2-45.8 0zM198.9 46.5l-29.4 0c-44.4 0-87.4 29.4-87.4 114.6 0 82.3 39.4 108.8 87.4 108.8l29.4 0 0-223.4z"]
  };
  var faPixiv = {
    prefix: 'fab',
    iconName: 'pixiv',
    icon: [448, 512, [], "e640", "M96 32C43 32 0 75 0 128L0 384c0 53 43 96 96 96l256 0c53 0 96-43 96-96l0-256c0-53-43-96-96-96L96 32zm77.7 217.3a60.1 60.1 0 1 0 120.3 0 60.1 60.1 0 1 0 -120.3 0zM119.1 387.8c-.3-.8-.5-1.7-.5-2.6l0-244.3c0-1.8 .7-3.6 2-4.9s3-2 4.9-2l16.9 0c1.2 0 2.3 .3 3.3 .8s1.9 1.3 2.5 2.3l14 21.8c19.7-15.6 44.5-25 71.6-25 63.6 0 115.2 51.6 115.2 115.2S297.5 364.5 233.8 364.5c-22 0-42.6-6.2-60.1-16.9l0 37.6c0 .9-.2 1.8-.5 2.6s-.9 1.6-1.5 2.2-1.4 1.1-2.2 1.5-1.7 .5-2.6 .5l-41.3 0c-.9 0-1.8-.2-2.6-.5s-1.6-.9-2.2-1.5-1.1-1.4-1.5-2.2z"]
  };
  var faOpenai = {
    prefix: 'fab',
    iconName: 'openai',
    icon: [512, 512, [], "e7cf", "M196.4 185.8l0-48.6c0-4.1 1.5-7.2 5.1-9.2l97.8-56.3c13.3-7.7 29.2-11.3 45.6-11.3 61.4 0 100.4 47.6 100.4 98.3 0 3.6 0 7.7-.5 11.8L343.3 111.1c-6.1-3.6-12.3-3.6-18.4 0L196.4 185.8zM424.7 375.2l0-116.2c0-7.2-3.1-12.3-9.2-15.9L287 168.4 329 144.3c3.6-2 6.7-2 10.2 0L437 200.7c28.2 16.4 47.1 51.2 47.1 85 0 38.9-23 74.8-59.4 89.6l0 0zM166.2 272.8l-42-24.6c-3.6-2-5.1-5.1-5.1-9.2l0-112.6c0-54.8 42-96.3 98.8-96.3 21.5 0 41.5 7.2 58.4 20L175.4 108.5c-6.1 3.6-9.2 8.7-9.2 15.9l0 148.5 0 0zm90.4 52.2l-60.2-33.8 0-71.7 60.2-33.8 60.2 33.8 0 71.7-60.2 33.8zm38.7 155.7c-21.5 0-41.5-7.2-58.4-20l100.9-58.4c6.1-3.6 9.2-8.7 9.2-15.9l0-148.5 42.5 24.6c3.6 2 5.1 5.1 5.1 9.2l0 112.6c0 54.8-42.5 96.3-99.3 96.3l0 0zM173.8 366.5L76.1 310.2c-28.2-16.4-47.1-51.2-47.1-85 0-39.4 23.6-74.8 59.9-89.6l0 116.7c0 7.2 3.1 12.3 9.2 15.9l128 74.2-42 24.1c-3.6 2-6.7 2-10.2 0zm-5.6 84c-57.9 0-100.4-43.5-100.4-97.3 0-4.1 .5-8.2 1-12.3l100.9 58.4c6.1 3.6 12.3 3.6 18.4 0l128.5-74.2 0 48.6c0 4.1-1.5 7.2-5.1 9.2l-97.8 56.3c-13.3 7.7-29.2 11.3-45.6 11.3l0 0zm127 60.9c62 0 113.7-44 125.4-102.4 57.3-14.9 94.2-68.6 94.2-123.4 0-35.8-15.4-70.7-43-95.7 2.6-10.8 4.1-21.5 4.1-32.3 0-73.2-59.4-128-128-128-13.8 0-27.1 2-40.4 6.7-23-22.5-54.8-36.9-89.6-36.9-62 0-113.7 44-125.4 102.4-57.3 14.8-94.2 68.6-94.2 123.4 0 35.8 15.4 70.7 43 95.7-2.6 10.8-4.1 21.5-4.1 32.3 0 73.2 59.4 128 128 128 13.8 0 27.1-2 40.4-6.7 23 22.5 54.8 36.9 89.6 36.9z"]
  };
  var faSith = {
    prefix: 'fab',
    iconName: 'sith',
    icon: [448, 512, [], "f512", "M0 32l69.7 118.8-58.9-11.5 69.8 91c-3 17-3 34.4 0 51.4l-69.8 91 58.9-11.5-69.7 118.8 118.8-69.7-11.5 58.9 91-69.8c17 3 34.5 3 51.5 0l91 69.8-11.5-58.9 118.7 69.7-69.7-118.8 58.9 11.5-69.8-91c3-17 3-34.4 0-51.4l69.8-91-58.9 11.5 69.7-118.8-118.7 69.7 11.5-58.9-91.1 69.9c-8.5-1.5-17.1-2.3-25.7-2.3s-17.2 .8-25.7 2.3L107.2 42.8 118.8 101.7 0 32zM224 380.2a124.2 124.2 0 1 1 0-248.4 124.2 124.2 0 1 1 0 248.4zm0-211.8a87.6 87.6 0 1 0 0 175.1 87.6 87.6 0 1 0 0-175.1z"]
  };
  var faNfcDirectional = {
    prefix: 'fab',
    iconName: 'nfc-directional',
    icon: [512, 512, [], "e530", "M211.8 488.6c1.6 2.5 2.1 5.6 1.4 8.5-.6 2.9-2.4 5.5-4.9 7.1-2.6 1.6-5.6 2.1-8.6 1.5-61.4-13.9-115.6-49.9-152.2-101.2S-5.4 290.3 1.6 227.7c7-62.7 36.8-120.5 83.7-162.5 46.9-42 107.7-65.2 170.7-65.2 1.5 0 2.1 .3 4.3 .9 1.4 .6 1.8 1.4 3.7 2.5 1.1 1.1 1.9 2.3 2.5 3.7 .5 1.4 .8 2.8 .8 4.3l0 101 24.5-25.9c1-1.1 2.2-2 3.6-2.6 1.3-.6 2.8-.9 4.3-1 1.5-.1 2.9 .2 4.3 .7s2.7 1.3 3.8 2.4c1 1 1.9 2.2 2.5 3.6 .6 1.3 1 2.8 1 4.3s-.2 3-.7 4.3c-.6 1.4-1.4 2.6-2.4 3.7l-44 46.6c-1.1 1.1-2.3 2-3.7 2.6-1.5 .6-3 .9-5.4 .9-.6 0-2.2-.3-3.6-.9s-2.7-1.5-3.7-2.6l-44.1-46.6c-2-2.2-3.1-5.1-3-8.1 0-3 1.3-6.7 3.5-7.9 2.2-2.1 5.1-3.2 8.1-3.1 3 .1 5.8 1.3 7.9 3.5l24.5 26 0-89.5c-56.4 2.8-109.8 25.8-150.5 65-40.6 39.1-65.7 91.7-70.6 147.9S34.4 348.1 67.7 393.7c32.4 45.5 82 77.5 137 89.9 2.9 .7 5.5 2.5 7.1 5zM171.4 126.1c-.8 1.3-1.9 2.4-3.1 3.2-20.5 13.9-37.2 32.6-48.8 54.5s-17.7 46.3-17.7 71.1 6.1 49.2 17.7 70.2c11.6 22.8 28.3 41.5 48.8 55.4 2.5 1.7 4.2 4.3 4.7 7.3 .6 2.9-.9 6-1.7 8.4-1.7 2.5-5.2 4.2-7.3 3.9-2.9 1.4-6 .8-8.4-.9-23.6-16-42.8-37.5-56.1-62.7-13.3-25.1-20.3-53.1-20.3-81.6 0-28.4 7-56.5 20.3-81.6 13.3-25.2 32.5-46.7 56.1-62.7 1.2-.8 2.6-1.4 4-1.8 1.5-.3 3-.3 4.5 0 1.4 .2 2.8 .8 4.1 1.6s2.3 1.9 3.2 3.1c.8 1.2 1.4 2.6 1.7 4.1s.3 3 0 4.4c-.3 1.5-.8 2.9-1.7 4.1zM340.9 383.5c.8-1.2 1.9-2.3 2.2-3.1l0-.1c21.3-14 38-32.7 49.6-54.6 11.5-21.8 17.5-46.2 17.5-70.9s-6-49.1-17.5-71c-11.6-22.7-28.3-40.5-49.6-54.5-.3-.8-1.4-1.9-2.2-3.1-.8-1.3-1.4-2.7-1.6-4.1-1.2-1.5-.3-3 0-4.4 .3-1.5 .9-2.9 1.7-4.1 .9-1.2 1.1-2.3 3.2-3.1 1.2-.8 2.6-1.3 4.1-1.6s2.9-.3 4.4 0 2.8 .9 4.1 1.8c23.4 16 42.7 37.5 55.9 62.6 13.3 25.1 19.4 53.1 19.4 81.5 0 28.5-6.1 56.5-19.4 81.6-13.2 25.1-32.5 46.6-55.9 62.6-1.3 .9-2.6 1.5-4.1 1.8s-2.9 .3-4.4 0-2.9-1.7-4.1-1.6c-2.1-.8-2.3-1.9-3.2-3.1-.8-1.2-1.4-2.6-1.7-4.1-.3-1.4-1.2-2.9 0-4.4 .2-1.4 .8-2.8 1.6-4.1zM312.3 6.3c56.2 12.7 106.4 44 142.7 88.7 30.4 37.6 49.6 83 55.3 131 5.6 48-2.4 96.7-23.2 140.3-20.9 43.6-53.6 80.5-94.5 106.3-40.9 25.7-88.2 39.4-136.6 39.4-1.5 0-2.9-.3-4.3-.9-1.4-.5-2.6-1.4-3.7-2.4-1.9-1.1-1.9-2.3-2.4-3.7-.6-1.4-.9-2.8-.9-4.3l0-99.2-24.5 26c-2.1 2.2-4.9 2.6-7.9 3.6-3 .1-5.9-1.1-8.1-4-2.2-1.2-3.5-4-3.5-7-.1-3 1-5.9 3-8.1l44.1-46.6c1.3-2.2 5.1-3.4 7.3-3.4 4 0 6.9 1.2 9.1 3.4l44 46.6c2.1 2.2 3.2 5.1 3.1 8.1s-1.4 5.8-3.5 7c-2.2 2.9-5.1 4.1-8.1 4-3-1-5.9-1.4-7.9-3.6l-24.5-25.9 0 87.5c56.4-2.8 109.8-25.8 150.5-65 40.7-40 65.8-91.7 70.7-147.9 4.8-57.1-10.8-112.3-44.1-157.9-33.3-45.6-82-77.5-137-89.9-1.5-.3-2.8-.9-4.1-1.8-1.2-.9-2.2-1.9-3-3.2-.8-1.2-2.2-2.6-1.6-4.1-.2-1.5-.2-3 .1-4.4 .4-1.4 1-2.8 1.8-4 .9-1.2 2-2.2 3.2-3 1.3-.8 2.7-1.3 4.1-1.6 1.5-.3 3-.2 4.4 .1zm40.8 249.8c0 31.4-17.5 61.1-49.3 83.5-2.1 1.5-4.8 2.3-7.4 2-2.7-.2-5.2-1.3-7-3.2l-70.1-69.8c-2.2-2.1-4.2-5-3.4-8 0-3 1.2-5.9 3.3-8 2.2-2.1 5-3.3 8-3.3s5.9 1.2 8 3.3l63.1 62.8c20.8-17.1 32.2-37.9 32.2-59.3 0-23.9-14.1-47-39.7-65.1-2.5-1.7-4.1-4.3-4.6-7.3-.5-2.9 .1-6 1.9-8.4 1.7-2.5 4.3-4.1 7.3-4.6 2.9-.5 6 .1 8.4 1.9 31.8 22.4 49.3 52.1 49.3 83.5zM216.7 341.5c-3 .5-6-.2-8.5-1.9-31.7-22.4-50.1-52.1-50.1-83.5s18.4-61.1 50.1-83.5c2.2-1.6 4.9-2.3 7.5-2.1 2.7 .3 5.1 1.4 7 3.3l70.1 69.8c2.1 2.1 3.3 5 3.3 8s-2 5.8-3.3 8c-2.1 2.1-5 3.3-7.9 3.3-3 0-6.8-1.2-8-3.3l-63.1-62.9c-20.9 17.3-32.2 38-32.2 59.4 0 23 14.1 47 39.7 65 2.4 1.8 4.1 4.4 4.6 7.4 .5 2.9-.2 5.9-1.9 8.4-1.7 2.4-4.4 4.1-7.3 4.6z"]
  };
  var faCreativeCommonsBy = {
    prefix: 'fab',
    iconName: 'creative-commons-by',
    icon: [512, 512, [], "f4e7", "M322.9 194.4l0 101.4-28.3 0 0 120.5-77.1 0 0-120.4-28.3 0 0-101.5c0-4.4 1.6-8.2 4.6-11.3 3.1-3.1 6.9-4.7 11.3-4.7l101.9 0c4.1 0 7.8 1.6 11.1 4.7 3.1 3.2 4.8 6.9 4.8 11.3zm-32.5-64.5a34.5 34.5 0 1 1 -69 .8 34.5 34.5 0 1 1 69-.8zM255.6 8C397.4 8 504 118.1 504 256 504 403.1 385.5 504 255.6 504 121.6 504 8 394.5 8 256 8 123.1 112.7 8 255.6 8zm.8 44.7c-118.2 0-203.7 97.9-203.7 203.3 0 109.8 91.2 202.8 203.7 202.8 103.2 0 202.8-81.1 202.8-202.8 .1-113.8-90.2-203.3-202.8-203.3z"]
  };
  var faUmbraco = {
    prefix: 'fab',
    iconName: 'umbraco',
    icon: [512, 512, [], "f8e8", "M256.3 8a248 248 0 1 0 -.7 496 248 248 0 1 0 .7-496zm145 266c-.8 27.1-5.4 48.8-14 65s-23.1 27.9-43.5 35c-20.4 7.1-48.9 10.6-85.4 10.5l-4.6 0c-36.5 .1-65-3.3-85.4-10.5s-34.9-18.8-43.5-35c-8.6-16.2-13.2-37.9-14-65-.7-10.2-.7-20.5 0-30.7 .4-14.7 1.6-29.3 3.6-43.9 1.9-13.4 3.6-22.6 5.4-32 1-4.9 1.3-6.4 1.8-8.4 .3-1.1 .9-2.1 1.8-2.8s2-1.1 3.1-1.1l.7 0 32 5c1.2 .2 2.2 .8 3 1.7s1.2 2.1 1.2 3.3c0 .3 0 .5 0 .8l-1.7 8.8c-1.6 8.8-3.2 20.1-4.8 33.7-1.7 14-2.5 28.1-2.6 42.2-.2 27 2.5 46.9 8.1 59.8 2.8 6.4 7.2 12 12.6 16.4s11.9 7.4 18.7 8.8c18.8 4 38.1 5.7 57.3 5.1l10.3 0c19.2 .6 38.5-1.2 57.3-5.2 6.8-1.4 13.2-4.5 18.6-8.8s9.7-10 12.5-16.4c5.7-12.9 8.4-32.9 8.1-59.8-.1-14.1-1-28.2-2.6-42.1-1.7-13.6-3.3-24.8-4.9-33.7l-1.7-8.8c0-.3 0-.5 0-.8 0-1.2 .4-2.4 1.2-3.3s1.8-1.5 3-1.7l32-5 .8 0c1.1 0 2.2 .4 3.1 1.1s1.5 1.7 1.8 2.8c.6 2 .8 3.6 1.8 8.4 1.8 9.6 3.5 18.8 5.4 32 2 14.6 3.2 29.2 3.6 43.9 .7 10.2 .7 20.5 0 30.7l0 0z"]
  };
  var faHooli = {
    prefix: 'fab',
    iconName: 'hooli',
    icon: [640, 512, [], "f427", "M144.5 352l38.3 .8c-13.2-4.6-26-10.2-38.3-16.8l0 16zm57.7-5.3l0 5.3-19.4 .8c36.5 12.5 69.9 14.2 94.7 7.2-19.9 .2-45.8-2.6-75.3-13.3zM611.1 231.5c15.9 0 28.9-12.9 28.9-28.9s-12.9-24.5-28.9-24.5c-15.9 0-28.9 8.6-28.9 24.5s12.9 28.9 28.9 28.9zM582.1 352l57.9 0 0-110.5-57.9 0 0 110.5zm-73.7 0l57.9 0 0-195.3-57.9 27.3 0 168zm-31-119.4c-18.2-18.2-50.4-17.1-50.4-17.1s-32.3-1.1-50.4 17.1c-18.2 18.2-16.8 33.9-16.8 52.6s-1.4 34.3 16.8 52.5 50.4 17.1 50.4 17.1 32.3 1.1 50.4-17.1c18.2-18.2 16.8-33.8 16.8-52.5-.1-18.8 1.3-34.5-16.8-52.6zm-39.8 71.9c0 3.6-1.8 12.5-10.7 12.5s-10.7-8.9-10.7-12.5l0-40.4c0-8.7 7.3-10.9 10.7-10.9s10.7 2.1 10.7 10.9l0 40.4zM331.4 232.6c-18.2-18.2-50.4-17.1-50.4-17.1s-32.2-1.1-50.4 17.1c-1.9 1.9-3.7 3.9-5.3 6-38.2-29.6-72.5-46.5-102.1-61.1l0-20.7-22.5 10.6c-54.4-22.1-89-18.2-97.3 .1 0 0-24.9 32.8 61.8 110.8l0 73.7 57.9 0 0-28.6c-6.5-4.2-13-8.7-19.4-13.6-14.8-11.2-27.4-21.6-38.4-31.4l0-31c13.1 14.7 30.5 31.4 53.4 50.3l4.5 3.6 0-29.8c0-6.9 1.7-18.2 10.8-18.2s10.6 6.9 10.6 15l0 48.7c18 12.2 37.3 22.1 57.7 29.6l0-93.9c0-18.7-13.4-37.4-40.6-37.4-15.8-.1-30.5 8.2-38.5 21.9l0-54.3c41.9 20.9 83.9 46.5 99.9 58.3-10.2 14.6-9.3 28.1-9.3 43.7 0 18.7-1.4 34.3 16.8 52.5s50.4 17.1 50.4 17.1 32.3 1.1 50.4-17.1c18.2-18.2 16.7-33.8 16.7-52.5 0-18.5 1.5-34.2-16.7-52.3zM65.2 184l0 63.3c-48.7-54.5-38.9-76-35.2-79.1 13.5-11.4 37.5-8 64.4 2.1L65.2 184zM291.7 304.5c0 3.6-1.8 12.5-10.7 12.5s-10.7-8.9-10.7-12.5l0-40.4c0-8.7 7.3-10.9 10.7-10.9s10.7 2.1 10.7 10.9l0 40.4z"]
  };
  var faSquareGit = {
    prefix: 'fab',
    iconName: 'square-git',
    icon: [448, 512, ["git-square"], "f1d2", "M120.8 335.5c-5.9-.4-12.6-.8-20.2-1.3-3.3 4.1-6.6 8.4-6.6 13.5 0 18.5 65.5 18.5 65.5-1.5 0-8.3-7.4-8.7-38.8-10.7l.1 0zm7.8-117.9c-32.3 0-33.7 44.5-.7 44.5 32.5 0 31.7-44.5 .7-44.5zM384 32L64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64zM243.9 172.2c-14.5 0-22.9-8.4-22.9-22.9s8.4-22.3 22.9-22.3c14.7 0 23.1 7.8 23.1 22.3s-8.4 22.9-23.1 22.9zM149.6 195l49.5 0 0 21.6-23.4 1.8c4.6 5.8 9.4 14 9.4 25.7 0 48.7-57.2 47.2-74.2 42.4l-8.4 13.4c5 .3 9.8 .6 14.3 .8 56.3 3.2 80.5 4.6 80.5 38.5 0 29.2-25.7 45.7-69.9 45.7-46 0-63.5-11.6-63.5-31.7 0-11.4 5.1-17.5 14-25.9-8.4-3.5-11.2-9.9-11.2-16.8 0-9.6 7.4-16.3 23-30.6l.2-.2c-12.4-6.1-21.8-19.3-21.8-38.1 0-51.6 56.6-53.3 81.6-46.8l-.1 .2zM270.5 303.1l13 1.8 0 20.1-72.4 0 0-20.1c2.7-.4 5-.7 6.9-.9 9.9-1.2 10.1-1.3 10.1-6l0-74.7c0-4.4-.9-4.7-10.1-7.8-1.9-.7-4.2-1.4-6.9-2.4l2.8-20.6 52.6 0 0 105.5c0 4.1 .2 4.6 4.1 5.1l-.1 0zm106.6-10.4L384 315c-10.9 5.4-26.9 10.2-41.4 10.2-30.2 0-41.7-12.2-41.7-40.9l0-66.6c0-.8 0-1.4-.2-1.8-.8-1.2-4.2-.7-19.6-.7l0-22.6c22.3-2.5 31.2-13.7 34-41.4l24.2 0c0 33.3-.6 38 .7 38.6 .3 .1 .7 0 1.3 0l35.8 0 0 25.4-37.8 0 0 61.6c-.2 6.3-.9 30.4 37.9 15.9l-.1 0z"]
  };
  var faGitSquare = faSquareGit;
  var faOdnoklassniki = {
    prefix: 'fab',
    iconName: 'odnoklassniki',
    icon: [320, 512, [], "f263", "M275.1 334c-27.4 17.4-65.1 24.3-90 26.9l20.9 20.6 76.3 76.3c27.9 28.6-17.5 73.3-45.7 45.7-19.1-19.4-47.1-47.4-76.3-76.6L84 503.4c-28.2 27.5-73.6-17.6-45.4-45.7 19.4-19.4 47.1-47.4 76.3-76.3l20.6-20.6c-24.6-2.6-62.9-9.1-90.6-26.9-32.6-21-46.9-33.3-34.3-59 7.4-14.6 27.7-26.9 54.6-5.7 0 0 36.3 28.9 94.9 28.9S255 269.2 255 269.2c26.9-21.1 47.1-8.9 54.6 5.7 12.4 25.7-1.9 38-34.5 59.1zm14.6-204.7a129.7 129.7 0 1 1 -259.4 .4 129.7 129.7 0 1 1 259.4-.4zm-193.4 .4a63.7 63.7 0 1 0 127.4-.4 63.7 63.7 0 1 0 -127.4 .4z"]
  };
  var faDrupal = {
    prefix: 'fab',
    iconName: 'drupal',
    icon: [384, 512, [], "f1a9", "M272.3 108.1C236.5 72.5 202.5 38.4 192.4 0 182.4 38.4 148.1 72.5 112.4 108.1 58.8 161.7-1.9 222.4-1.9 313.4-4.3 420.7 80.8 509.6 188.1 512s196.2-82.8 198.5-190.1c.1-2.8 .1-5.6 0-8.5 0-91.1-60.8-151.7-114.3-205.3zM98 331.1c-5.9 7.5-11 15.6-15.2 24.2-.3 .7-.8 1.3-1.3 1.8s-1.2 .8-2 1l-1.7 0c-4.3 0-9.2-8.5-9.2-8.5-1.3-2-2.5-4.2-3.7-6.4l-.8-1.8c-11.2-25.7-1.5-62.3-1.5-62.3 4.8-17.8 12.7-34.7 23.2-49.9 6.4-9.6 13.5-18.9 21-27.7l9.2 9.2 43.5 44.4c.8 .9 1.3 2.1 1.3 3.3s-.5 2.4-1.3 3.3L114.1 312.3 98 331.1zm96.6 127.3c-12.9-.1-25.6-3.9-36.4-11s-19.4-17.1-24.6-28.9-7-24.9-5-37.7 7.6-24.7 16.2-34.4c14.2-16.9 31.5-33.5 50.3-55.3 22.3 23.8 36.9 40.1 51.2 58 1.1 1.4 2.1 2.9 3 4.4 7.8 11.1 12 24.4 12 38 0 8.8-1.7 17.4-5 25.5s-8.2 15.5-14.4 21.7-13.5 11.1-21.6 14.5-16.7 5.1-25.5 5.1l-.2 0zM320.7 351.6c-.4 1.4-1.2 2.6-2.3 3.6s-2.4 1.6-3.8 1.8l-1.3 0c-2.6-.9-4.9-2.7-6.3-5.1-11.6-17.5-24.9-33.9-39.5-49l-17.8-18.4-59.1-61.3c-12.4-11.5-24.2-23.6-35.4-36.3-.3-.5-.6-.9-.9-1.4-2-2.8-3.6-5.9-4.7-9.2l0-1.8c-.8-5-.4-10.1 1.2-15s4.4-9.2 8-12.7c11.4-11.4 23-23 33.8-34.9 12 13.3 24.8 26 37.4 38.6 25.8 24 49.1 50.5 69.6 79.1 17.3 24.5 26.7 53.8 27 83.8-.1 12.9-2.2 25.8-6 38.2z"]
  };
  var faBloggerB = {
    prefix: 'fab',
    iconName: 'blogger-b',
    icon: [448, 512, [], "f37d", "M446.6 222.7c-1.8-8-6.8-15.4-12.5-18.5-1.8-1-13-2.2-25-2.7-20.1-.9-22.3-1.3-28.7-5-10.1-5.9-12.8-12.3-12.9-29.5-.1-33-13.8-63.7-40.9-91.3-19.3-19.7-40.9-33-65.5-40.5-5.9-1.8-19.1-2.4-63.3-2.9-69.4-.8-84.8 .6-108.4 10-43.5 17.2-74.7 53.8-86.1 100.6-2.1 8.8-2.6 22.9-3.1 103.9-.6 101.5 .1 116.4 6.4 136.5 15.6 49.6 59.9 86.3 104.4 94.3 14.8 2.7 197.3 3.3 216 .8 32.5-4.4 58-17.5 81.9-41.9 17.3-17.7 28.1-36.8 35.2-62.1 4.9-17.6 4.5-142.8 2.5-151.7zM124.5 159.1c7.8-7.9 10-8.2 58.8-8.2 43.9 0 45.4 .1 51.8 3.4 9.3 4.7 13.4 11.3 13.4 21.9 0 9.5-3.8 16.2-12.3 21.6-4.6 2.9-7.3 3.1-50.3 3.3-26.5 .2-47.7-.4-50.8-1.2-16.6-4.7-22.8-28.5-10.6-40.8zM316.3 358.9l-14.9 2.4-77.5 .9c-68.1 .8-87.3-.4-90.9-2-7.1-3.1-13.8-11.7-14.9-19.4-1.1-7.3 2.6-17.3 8.2-22.4 7.1-6.4 10.2-6.6 97.3-6.7 89.6-.1 89.1-.1 97.6 7.8 12.1 11.3 9.5 31.2-4.9 39.4z"]
  };
  var faInvision = {
    prefix: 'fab',
    iconName: 'invision',
    icon: [448, 512, [], "f7b0", "M407.4 32L40.6 32C18.2 32 0 50.2 0 72.6L0 439.4C0 461.8 18.2 480 40.6 480l366.8 0c22.4 0 40.6-18.2 40.6-40.6l0-366.8C448 50.2 429.8 32 407.4 32zM176.1 145.6c.4 23.4-22.4 27.3-26.6 27.4-14.9 0-27.1-12-27.1-27 .1-35.2 53.1-35.5 53.7-.4zM332.8 377c-65.6 0-34.1-74-25-106.6 14.1-46.4-45.2-59-59.9 .7l-25.8 103.3-45.1 0 8.1-32.5c-31.5 51.8-94.6 44.4-94.6-4.3 .1-14.3 .9-14 23-104.1l-31.8 0 9.7-35.6 76.4 0c-33.6 133.7-32.6 126.9-32.9 138.2 0 20.9 40.9 13.5 57.4-23.2l19.8-79.4-32.3 0 9.7-35.6 68.8 0-8.9 40.5c40.5-75.5 127.9-47.8 101.8 38-14.2 51.1-14.6 50.7-14.9 58.8 0 15.5 17.5 22.6 31.8-16.9L386 325c-10.5 36.7-29.4 52-53.2 52z"]
  };
  var faFacebookF = {
    prefix: 'fab',
    iconName: 'facebook-f',
    icon: [320, 512, [], "f39e", "M80 299.3l0 212.7 116 0 0-212.7 86.5 0 18-97.8-104.5 0 0-34.6c0-51.7 20.3-71.5 72.7-71.5 16.3 0 29.4 .4 37 1.2l0-88.7C291.4 4 256.4 0 236.2 0 129.3 0 80 50.5 80 159.4l0 42.1-66 0 0 97.8 66 0z"]
  };
  var faCentos = {
    prefix: 'fab',
    iconName: 'centos',
    icon: [448, 512, [], "f789", "M289.6 97.5l31.6 31.7-76.3 76.5 0-108.2 44.7 0zM127.2 129.2l76.3 76.5 0-108.2-44.7 0-31.6 31.7zm41.5-41.6l44.7 0 0 127.9 10.8 10.8 10.8-10.8 0-127.9 44.7 0-55.5-55.6-55.5 55.6zm26.2 168.1l-10.8-10.8-128.6 0 0-44.8-55.5 55.6 55.5 55.6 0-44.8 128.6 0 10.8-10.8zM274.2 235l107.9 0 0-44.8-31.6-31.7-76.3 76.5zm173.3 20.7l-55.5-55.6 0 44.8-127.7 0-10.8 10.8 10.8 10.8 127.7 0 0 44.8 55.5-55.6zM65.4 176.2l32.5-31.7 90.3 90.5 15.3 0 0-15.3-90.3-90.5 31.6-31.7-79.4 0 0 78.7zM382.1 97.5l-78.5 0 31.6 31.7-90.3 90.5 0 15.3 15.3 0 90.3-90.5 31.6 31.7 0-78.7zM203.5 413.9l0-108.1-76.3 76.5 31.6 31.7 44.7 0 0-.1zM65.4 235l108.8 0-76.3-76.5-32.5 31.7 0 44.8zM382.1 335.2l-31.6 31.7-90.3-90.5-15.3 0 0 15.3 90.3 90.5-31.6 31.7 78.5 0 0-78.7zm0-58.8l-107.9 0 76.3 76.5 31.6-31.7 0-44.8zM321.2 382.2l-76.3-76.5 0 108.1 44.7 0 31.6-31.6zM97.9 352.9l76.3-76.5-108.8 0 0 44.8 32.5 31.7zm181.8 70.9l-44.7 0 0-127.9-10.8-10.8-10.8 10.8 0 127.9-44.7 0 55.5 55.6 55.5-55.6zM113.2 382.2l90.3-90.5 0-15.3-15.3 0-90.3 90.5-32.5-31.7 0 78.7 79.4 0-31.6-31.7z"]
  };
  var faCcAmazonPay = {
    prefix: 'fab',
    iconName: 'cc-amazon-pay',
    icon: [576, 512, [], "f42d", "M124.7 201.8c.1-11.8 0-23.5 0-35.3l0-35.3c0-1.3 .4-2 1.4-2.7 11.5-8 24.1-12.1 38.2-11.1 12.5 .9 22.7 7 28.1 21.7 3.3 8.9 4.1 18.2 4.1 27.7 0 8.7-.7 17.3-3.4 25.6-5.7 17.8-18.7 24.7-35.7 23.9-11.7-.5-21.9-5-31.4-11.7-.9-.8-1.4-1.6-1.3-2.8zm154.9 14.6c4.6 1.8 9.3 2 14.1 1.5 11.6-1.2 21.9-5.7 31.3-12.5 .9-.6 1.3-1.3 1.3-2.5-.1-3.9 0-7.9 0-11.8 0-4-.1-8 0-12 0-1.4-.4-2-1.8-2.2-7-.9-13.9-2.2-20.9-2.9-7-.6-14-.3-20.8 1.9-6.7 2.2-11.7 6.2-13.7 13.1-1.6 5.4-1.6 10.8 .1 16.2 1.6 5.5 5.2 9.2 10.4 11.2zM576 80l0 352c0 26.5-21.5 48-48 48L48 480c-26.5 0-48-21.5-48-48L0 80C0 53.5 21.5 32 48 32l480 0c26.5 0 48 21.5 48 48zM368.5 103.9c.4 1.7 .9 3.4 1.6 5.1 16.5 40.6 32.9 81.3 49.5 121.9 1.4 3.5 1.7 6.4 .2 9.9-2.8 6.2-4.9 12.6-7.8 18.7-2.6 5.5-6.7 9.5-12.7 11.2-4.2 1.1-8.5 1.3-12.9 .9-2.1-.2-4.2-.7-6.3-.8-2.8-.2-4.2 1.1-4.3 4-.1 2.8-.1 5.6 0 8.3 .1 4.6 1.6 6.7 6.2 7.5 4.7 .8 9.4 1.6 14.2 1.7 14.3 .3 25.7-5.4 33.1-17.9 2.9-4.9 5.6-10.1 7.7-15.4 19.8-50.1 39.5-100.3 59.2-150.5 .6-1.5 1.1-3 1.3-4.6 .4-2.4-.7-3.6-3.1-3.7-5.6-.1-11.1 0-16.7 0-3.1 0-5.3 1.4-6.4 4.3-.4 1.1-.9 2.3-1.3 3.4l-29.1 83.7c-2.1 6.1-4.2 12.1-6.5 18.6-.4-.9-.6-1.4-.8-1.9-10.8-29.9-21.6-59.9-32.4-89.8-1.7-4.7-3.5-9.5-5.3-14.2-.9-2.5-2.7-4-5.4-4-6.4-.1-12.8-.2-19.2-.1-2.2 0-3.3 1.6-2.8 3.7zM242.4 206c1.7 11.7 7.6 20.8 18 26.6 9.9 5.5 20.7 6.2 31.7 4.6 12.7-1.9 23.9-7.3 33.8-15.5 .4-.3 .8-.6 1.4-1 .5 3.2 .9 6.2 1.5 9.2 .5 2.6 2.1 4.3 4.5 4.4 4.6 .1 9.1 .1 13.7 0 2.3-.1 3.8-1.6 4-3.9 .1-.8 .1-1.6 .1-2.3l0-88.8c0-3.6-.2-7.2-.7-10.8-1.6-10.8-6.2-19.7-15.9-25.4-5.6-3.3-11.8-5-18.2-5.9-3-.4-6-.7-9.1-1.1l-10 0c-.8 .1-1.6 .3-2.5 .3-8.2 .4-16.3 1.4-24.2 3.5-5.1 1.3-10 3.2-15 4.9-3 1-4.5 3.2-4.4 6.5 .1 2.8-.1 5.6 0 8.3 .1 4.1 1.8 5.2 5.7 4.1 6.5-1.7 13.1-3.5 19.7-4.8 10.3-1.9 20.7-2.7 31.1-1.2 5.4 .8 10.5 2.4 14.1 7 3.1 4 4.2 8.8 4.4 13.7 .3 6.9 .2 13.9 .3 20.8 0 .4-.1 .7-.2 1.2-.4 0-.8 0-1.1-.1-8.8-2.1-17.7-3.6-26.8-4.1-9.5-.5-18.9 .1-27.9 3.2-10.8 3.8-19.5 10.3-24.6 20.8-4.1 8.3-4.6 17-3.4 25.8zM98.7 106.9l0 175.3c0 .8 0 1.7 .1 2.5 .2 2.5 1.7 4.1 4.1 4.2 5.9 .1 11.8 .1 17.7 0 2.5 0 4-1.7 4.1-4.1 .1-.8 .1-1.7 .1-2.5l0-60.7c.9 .7 1.4 1.2 1.9 1.6 15 12.5 32.2 16.6 51.1 12.9 17.1-3.4 28.9-13.9 36.7-29.2 5.8-11.6 8.3-24.1 8.7-37 .5-14.3-1-28.4-6.8-41.7-7.1-16.4-18.9-27.3-36.7-30.9-2.7-.6-5.5-.8-8.2-1.2l-7 0c-1.2 .2-2.4 .3-3.6 .5-11.7 1.4-22.3 5.8-31.8 12.7-2 1.4-3.9 3-5.9 4.5-.1-.5-.3-.8-.4-1.2-.4-2.3-.7-4.6-1.1-6.9-.6-3.9-2.5-5.5-6.4-5.6l-9.7 0c-5.9-.1-6.9 1-6.9 6.8zM493.6 339c-2.7-.7-5.1 0-7.6 1-43.9 18.4-89.5 30.2-136.8 35.8-14.5 1.7-29.1 2.8-43.7 3.2-26.6 .7-53.2-.8-79.6-4.3-17.8-2.4-35.5-5.7-53-9.9-37-8.9-72.7-21.7-106.7-38.8-8.8-4.4-17.4-9.3-26.1-14-3.8-2.1-6.2-1.5-8.2 2.1l0 1.7c1.2 1.6 2.2 3.4 3.7 4.8 36 32.2 76.6 56.5 122 72.9 21.9 7.9 44.4 13.7 67.3 17.5 14 2.3 28 3.8 42.2 4.5 3 .1 6 .2 9 .4 .7 0 1.4 .2 2.1 .3l17.7 0c.7-.1 1.4-.3 2.1-.3 14.9-.4 29.8-1.8 44.6-4 21.4-3.2 42.4-8.1 62.9-14.7 29.6-9.6 57.7-22.4 83.4-40.1 2.8-1.9 5.7-3.8 8-6.2 4.3-4.4 2.3-10.4-3.3-11.9zM544 311.3c-.8-4.2-4-5.8-7.6-7-5.7-1.9-11.6-2.8-17.6-3.3-11-.9-22-.4-32.8 1.6-12 2.2-23.4 6.1-33.5 13.1-1.2 .8-2.4 1.8-3.1 3-.6 .9-.7 2.3-.5 3.4 .3 1.3 1.7 1.6 3 1.5 .6 0 1.2 0 1.8-.1l19.5-2.1c9.6-.9 19.2-1.5 28.8-.8 4.1 .3 8.1 1.2 12 2.2 4.3 1.1 6.2 4.4 6.4 8.7 .3 6.7-1.2 13.1-2.9 19.5-3.5 12.9-8.3 25.4-13.3 37.8-.3 .8-.7 1.7-.8 2.5-.4 2.5 1 4 3.4 3.5 1.4-.3 3-1.1 4-2.1 3.7-3.6 7.5-7.2 10.6-11.2 10.7-13.8 17-29.6 20.7-46.6 .7-3 1.2-6.1 1.7-9.1 .2-4.7 .2-9.6 .2-14.5z"]
  };
  var faEbay = {
    prefix: 'fab',
    iconName: 'ebay',
    icon: [640, 512, [], "f4f4", "M606.5 189.5l-54.8 109.9-54.9-109.9-37.5 0 10.9 20.6c-11.5-19-35.9-26-63.3-26-31.8 0-67.9 8.7-71.5 43.1l33.7 0c1.4-13.8 15.7-21.8 35-21.8 26 0 41 9.6 41 33l0 3.4c-12.7 0-28 .1-41.7 .4-42.4 .9-69.6 10-76.7 34.4 1-5.2 1.5-10.6 1.5-16.2 0-52.1-39.7-76.2-75.4-76.2-21.3 0-43 5.5-58.7 24.2l0-80.6-32.1 0 0 169.5c0 10.3-.6 22.9-1.1 33.1l31.5 0c.7-6.3 1.1-12.9 1.1-19.5 13.6 16.6 35.4 24.9 58.7 24.9 36.9 0 64.9-21.9 73.3-54.2-.5 2.8-.7 5.8-.7 9 0 24.1 21.1 45 60.6 45 26.6 0 45.8-5.7 61.9-25.5 0 6.6 .3 13.3 1.1 20.2l29.8 0c-.7-8.2-1-17.5-1-26.8l0-65.6c0-9.3-1.7-17.2-4.8-23.8l61.5 116.1-28.5 54.1 35.9 0 99.2-194.8-34 0zM244.2 313.8c-29.6 0-50.2-21.5-50.2-53.8 0-32.4 20.6-53.8 50.2-53.8 29.8 0 50.2 21.4 50.2 53.8 0 32.3-20.4 53.8-50.2 53.8zm200.9-47.3c0 30-17.9 48.4-51.6 48.4-25.1 0-35-13.4-35-25.8 0-19.1 18.1-24.4 47.2-25.3 13.1-.5 27.6-.6 39.4-.6l0 3.3zM33.2 268.1l128.8 0 0-8.5c0-51.7-33.1-75.4-78.4-75.4-56.8 0-83 30.8-83 77.6 0 42.5 25.3 74 82.5 74 31.4 0 68-11.7 74.4-46.1l-33.1 0c-12 35.8-87.7 36.7-91.2-21.6zm95-21.4l-94.4 0c6.9-56.6 92.1-54.7 94.4 0z"]
  };
  var faContao = {
    prefix: 'fab',
    iconName: 'contao',
    icon: [512, 512, [], "f26d", "M45.4 305c14.4 67.1 26.4 129 68.2 175L34 480c-18.7 0-34-15.2-34-34L0 66C0 47.3 15.2 32 34 32l57.7 0c-13.8 12.6-26.1 27.2-36.9 43.6-45.4 70-27 146.8-9.4 229.4zM478 32l-90.2 0c21.4 21.4 39.2 49.5 52.7 84.1L303.4 145.4c-14.9-29-37.8-53.3-82.6-43.9-24.6 5.3-41 19.3-48.3 34.6-8.8 18.7-13.2 39.8 8.2 140.3 21.1 100.2 33.7 117.7 49.5 131.2 12.9 11.1 33.4 17 58.3 11.7 44.5-9.4 55.7-40.7 57.4-73.2l137.4-29.6c3.2 71.5-18.7 125.2-57.4 163.6l52.1 0c18.7 0 34-15.2 34-34L512 66c0-18.8-15.2-34-34-34z"]
  };
  var faEllo = {
    prefix: 'fab',
    iconName: 'ello',
    icon: [512, 512, [], "f5f1", "M256 8a248 248 0 1 0 0 496 248 248 0 1 0 0-496zM399.8 293.2C383.3 358.5 323.8 404.8 256 404.8S128.7 358.5 112.2 293.2c-1.6-7.4 2.5-15.7 9.9-17.4s15.7 2.5 17.4 9.9c14 52.9 62 90.1 116.6 90.1s102.5-37.2 116.6-90.1c1.7-7.4 9.9-12.4 17.4-9.9 7.4 1.7 12.4 9.9 9.9 17.4z"]
  };
  var faSistrix = {
    prefix: 'fab',
    iconName: 'sistrix',
    icon: [448, 512, [], "f3ee", "M448 449L301.2 300.2c20-27.9 31.9-62.2 31.9-99.2 0-93.1-74.7-168.9-166.5-168.9-91.9-.1-166.6 75.7-166.6 168.8S74.7 369.8 166.5 369.8c39.8 0 76.3-14.2 105-37.9L417.5 480 448 449zM166.5 330.8c-70.6 0-128.1-58.3-128.1-129.9S95.9 71 166.5 71 294.6 129.3 294.6 200.9 237.2 330.8 166.5 330.8z"]
  };
  var faPeriscope = {
    prefix: 'fab',
    iconName: 'periscope',
    icon: [448, 512, [], "f3da", "M370 63.6c-38.6-41-89.5-63.6-143.4-63.6-114.7 0-208.1 96.2-208.1 214.4 0 75.1 57.8 159.8 82.7 192.7 36.6 48.4 91.4 104.9 125.4 104.9 41.6 0 112.9-94.2 120.9-105 24.6-33.1 82-118.3 82-192.6 0-56.5-21.1-110.1-59.5-150.8zM226.6 493.9c-42.5 0-190-167.3-190-279.4 0-107.4 83.9-196.3 190-196.3 100.8 0 184.7 89 184.7 196.3 .1 112.1-147.4 279.4-184.7 279.4zM338 206.8c0 59.1-51.1 109.7-110.8 109.7-100.6 0-150.7-108.2-92.9-181.8l0 .4c0 24.5 20.1 44.4 44.8 44.4s44.8-19.9 44.8-44.4c0-18.2-11.1-33.8-26.9-40.7 76.6-19.2 141 39.3 141 112.4z"]
  };
  var faExpeditedssl = {
    prefix: 'fab',
    iconName: 'expeditedssl',
    icon: [512, 512, [], "f23e", "M256 43.4a212.6 212.6 0 1 0 0 425.2 212.6 212.6 0 1 0 0-425.2zM158.6 176.3c0-53.7 43.7-97.4 97.4-97.4s97.4 43.7 97.4 97.4l0 26.6c0 5-3.9 8.9-8.9 8.9l-17.7 0c-5 0-8.9-3.9-8.9-8.9l0-26.6c0-82.1-124-82.1-124 0l0 26.6c0 5-3.9 8.9-8.9 8.9l-17.7 0c-5 0-8.9-3.9-8.9-8.9l0-26.6 .2 0zM397.7 380c0 9.7-8 17.7-17.7 17.7l-248 0c-9.7 0-17.7-8-17.7-17.7l0-141.7c0-9.7 8-17.7 17.7-17.7l248 0c9.7 0 17.7 8 17.7 17.7l0 141.7zm-248-137.3l0 132.9c0 2.5-1.9 4.4-4.4 4.4l-8.9 0c-2.5 0-4.4-1.9-4.4-4.4l0-132.9c0-2.5 1.9-4.4 4.4-4.4l8.9 0c2.5 0 4.4 1.9 4.4 4.4zm141.7 48.7c0 13-7.2 24.4-17.7 30.4l0 31.6c0 5-3.9 8.9-8.9 8.9l-17.7 0c-5 0-8.9-3.9-8.9-8.9l0-31.6c-10.5-6.1-17.7-17.4-17.7-30.4 0-19.7 15.8-35.4 35.4-35.4s35.5 15.8 35.5 35.4zM256 8a248 248 0 1 0 0 496 248 248 0 1 0 0-496zm0 17.7a230.3 230.3 0 1 1 0 460.6 230.3 230.3 0 1 1 0-460.6z"]
  };
  var faNapster = {
    prefix: 'fab',
    iconName: 'napster',
    icon: [512, 512, [], "f3d2", "M306.3 373.6c-14.2 13.6-31.3 24.1-50.4 30.5-19-6.4-36.2-16.9-50.3-30.5l100.7 0zm44-199.6c20-16.9 43.6-29.2 69.6-36.2l0 161.2c0 219.4-328 217.6-328 .3l0-161.6c25.9 6.9 49.6 19.6 69.5 36.4 56.8-40 132.5-39.9 188.9-.1zM141.5 115.5c64.4-60 164.3-60.1 228.9-.2-7.1 3.5-13.9 7.3-20.6 11.5-58.7-30.5-129.2-30.4-187.9 .1-6.3-4-13.9-8.2-20.4-11.4zM51.8 93.2l0 69.3c-58.4 36.5-58.4 121.1 .1 158.3 26.4 245.1 381.7 240.3 407.6 1.5l.3-1.7c58.7-36.3 58.9-121.7 .2-158.2l0-69.2c-17.3 .5-34 3-50.1 7.4-82-91.5-225.5-91.5-307.5 .1-16.3-4.4-33.1-7-50.6-7.5zM267.2 352s36-.3 61.3-1.5c10.2-.5 21.1-4 25.5-6.5 26.3-15.1 25.4-39.2 26.2-47.4-79.5-.6-99.9-3.9-113 55.4zM131.7 296.7c.8 8.2-.1 32.3 26.2 47.4 4.4 2.5 15.2 6 25.5 6.5 25.3 1.1 61.3 1.5 61.3 1.5-13.2-59.4-33.7-56.1-113-55.4zM300.8 420.1c-3.2-5.3-6.9-7.3-6.9-7.3-24.8 7.3-52.2 6.9-75.9 0 0 0-2.9 1.5-6.4 6.6-2.8 4.1-3.7 9.6-3.7 9.6 29.1 17.6 67.1 17.6 96.2 0-.1-.1-.3-4-3.3-8.9z"]
  };
  var faDelicious = {
    prefix: 'fab',
    iconName: 'delicious',
    icon: [448, 512, [], "f1a5", "M446.6 68c-.4-1.5-.9-3-1.4-4.5-.9-2.5-2-4.8-3.3-7.1-1.4-2.4-3-4.8-4.7-6.9-2.1-2.5-4.4-4.8-6.9-6.8-1.1-.9-2.2-1.7-3.3-2.5-1.3-.9-2.6-1.7-4-2.4-1.8-1-3.6-1.8-5.5-2.5-1.7-.7-3.5-1.3-5.4-1.7-3.8-1-7.9-1.5-12-1.5l-352 0C21.6 32 .1 53.5 .1 80l0 352c0 4.1 .5 8.2 1.5 12 2 7.7 5.8 14.6 11 20.3 1 1.1 2.1 2.2 3.3 3.3 5.7 5.2 12.6 9 20.3 11 3.8 1 7.9 1.5 12 1.5l352 0c26.5 0 48-21.5 48-48l0-352.1c-.1-4.1-.6-8.2-1.6-12zM416.1 432c0 8.8-7.2 16-16 16l-176 0 0-192-192 0 0-176c0-8.8 7.2-16 16-16l176 0 0 192 192 0 0 176z"]
  };
  var faGuilded = {
    prefix: 'fab',
    iconName: 'guilded',
    icon: [448, 512, [], "e07e", "M443.9 64L5 64c0 103.3 22.2 180.1 43.4 222.4 64.1 127.8 176 161.6 177.3 161.6 55.7-20.5 104.5-56.3 140.6-103.5 25.9-33.9 53.1-87.2 65.9-145.8l-259.9 0c4.1 36.4 22.2 67.9 45.1 86.9l88.6 0c-17 28.2-48.2 54.4-80.5 69.5-31.2-13.3-69.1-46.5-96.5-98.4-26.7-53.8-27.1-105.9-27.1-105.9l336.1 0c4-28.8 5.9-57.9 5.9-86.9z"]
  };
  var faXbox = {
    prefix: 'fab',
    iconName: 'xbox',
    icon: [512, 512, [], "f412", "M369.9 318.2c44.3 54.3 64.7 98.8 54.4 118.7-7.9 15.1-56.7 44.6-92.6 55.9-29.6 9.3-68.4 13.3-100.4 10.2-38.2-3.7-76.9-17.4-110.1-39-27.9-18.2-34.2-25.7-34.2-40.6 0-29.9 32.9-82.3 89.2-142.1 32-33.9 76.5-73.7 81.4-72.6 9.4 2.1 84.3 75.1 112.3 109.5zM188.6 143.8c-29.7-26.9-58.1-53.9-86.4-63.4-15.2-5.1-16.3-4.8-28.7 8.1-29.2 30.4-53.5 79.7-60.3 122.4-5.4 34.2-6.1 43.8-4.2 60.5 5.6 50.5 17.3 85.4 40.5 120.9 9.5 14.6 12.1 17.3 9.3 9.9-4.2-11-.3-37.5 9.5-64 14.3-39 53.9-112.9 120.3-194.4zm311.6 63.5c-16.9-80-67.5-130.3-74.6-130.3-7.3 0-24.2 6.5-36 13.9-23.3 14.5-41 31.4-64.3 52.8 42.4 53.3 102.2 139.4 122.9 202.3 6.8 20.7 9.7 41.1 7.4 52.3-1.7 8.5-1.7 8.5 1.4 4.6 6.1-7.7 19.9-31.3 25.4-43.5 7.4-16.2 15-40.2 18.6-58.7 4.3-22.5 3.9-70.8-.8-93.4zM141.3 43c47.7-2.5 109.7 34.5 114.3 35.4 .7 .1 10.4-4.2 21.6-9.7 63.9-31.1 94-25.8 107.4-25.2-63.9-39.3-152.7-50-233.9-11.7-23.4 11.1-24 11.9-9.4 11.2z"]
  };
  var faUntappd = {
    prefix: 'fab',
    iconName: 'untappd',
    icon: [640, 512, [], "f405", "M401.5 49.9C321.7 210 316.9 202.4 313.6 223.1l-5.2 32.8c-1.9 12-6.6 23.5-13.7 33.4L145.8 497.1c-7.6 10.6-20.4 16.2-33.4 14.6-40.3-5-77.8-32.2-95.3-68.5-5.7-11.8-4.5-25.8 3.1-36.4L169.1 198.9c7.1-9.9 16.4-18 27.2-23.7l29.3-15.5c18.5-9.8 9.7-11.9 135.6-138.9 1-4.8 1-7.3 3.6-8 3-.7 6.6-1 6.3-4.6l-.4-4.6c-.2-1.9 1.3-3.6 3.2-3.6 4.5-.1 13.2 1.2 25.6 10 12.3 8.9 16.4 16.8 17.7 21.1 .6 1.8-.6 3.7-2.4 4.2l-4.5 1.1c-3.4 .9-2.5 4.4-2.3 7.4 .1 2.8-2.3 3.6-6.5 6.1zM230.3 36.4c3.4 .9 2.5 4.4 2.3 7.4-.2 2.7 2.1 3.5 6.4 6 7.9 15.9 15.3 30.5 22.2 44 .7 1.3 2.3 1.5 3.3 .5 11.2-12 24.6-26.2 40.5-42.6 1.3-1.4 1.4-3.5 .1-4.9-8-8.2-16.5-16.9-25.6-26.1-1-4.7-1-7.3-3.6-8-3-.8-6.6-1-6.3-4.6 .3-3.3 1.4-8.1-2.8-8.2-4.5-.1-13.2 1.1-25.6 10-12.3 8.9-16.4 16.8-17.7 21.1-1.4 4.2 3.6 4.6 6.8 5.4zM620.2 406.7L471.4 198.8c-13.2-18.5-26.6-23.4-56.4-39.1-11.2-5.9-14.2-10.9-30.5-28.9-1-1.1-2.9-.9-3.6 .5-46.3 88.8-47.1 82.8-49 94.8-1.7 10.7-1.3 20 .3 29.8 1.9 12 6.6 23.5 13.7 33.4L494.8 497.2c7.6 10.6 20.2 16.2 33.1 14.7 40.3-4.9 78-32 95.7-68.6 5.4-11.9 4.3-25.9-3.4-36.6z"]
  };
  var faGooglePlusG = {
    prefix: 'fab',
    iconName: 'google-plus-g',
    icon: [640, 512, [], "f0d5", "M386.3 228.5c1.8 9.7 3.1 19.4 3.1 32 0 109.8-73.6 187.5-184.4 187.5-106.1 0-192-85.9-192-192S98.9 64 205 64c51.9 0 95.1 18.9 128.6 50.3l-52.1 50c-14.1-13.6-39-29.6-76.5-29.6-65.5 0-118.9 54.2-118.9 121.3S139.5 377.3 205 377.3c76 0 104.5-54.7 109-82.8l-109 0 0-66 181.3 0 0 0zm185.4 6.4l0-55.7-56 0 0 55.7-55.7 0 0 56 55.7 0 0 55.7 56 0 0-55.7 55.7 0 0-56-55.7 0z"]
  };
  var faGithubAlt = {
    prefix: 'fab',
    iconName: 'github-alt',
    icon: [512, 512, [], "f113", "M202.1 328.7c0 20.9-10.9 55.1-36.7 55.1s-36.7-34.2-36.7-55.1 10.9-55.1 36.7-55.1 36.7 34.2 36.7 55.1zM496 278.2c0 31.9-3.2 65.7-17.5 95-37.9 76.6-142.1 74.8-216.7 74.8-75.8 0-186.2 2.7-225.6-74.8-14.6-29-20.2-63.1-20.2-95 0-41.9 13.9-81.5 41.5-113.6-5.2-15.8-7.7-32.4-7.7-48.8 0-21.5 4.9-32.3 14.6-51.8 45.3 0 74.3 9 108.8 36 29-6.9 58.8-10 88.7-10 27 0 54.2 2.9 80.4 9.2 34-26.7 63-35.2 107.8-35.2 9.8 19.5 14.6 30.3 14.6 51.8 0 16.4-2.6 32.7-7.7 48.2 27.5 32.4 39 72.3 39 114.2zm-64.3 50.5c0-43.9-26.7-82.6-73.5-82.6-18.9 0-37 3.4-56 6-14.9 2.3-29.8 3.2-45.1 3.2-15.2 0-30.1-.9-45.1-3.2-18.7-2.6-37-6-56-6-46.8 0-73.5 38.7-73.5 82.6 0 87.8 80.4 101.3 150.4 101.3l48.2 0c70.3 0 150.6-13.4 150.6-101.3zm-82.6-55.1c-25.8 0-36.7 34.2-36.7 55.1s10.9 55.1 36.7 55.1 36.7-34.2 36.7-55.1-10.9-55.1-36.7-55.1z"]
  };
  var faGetPocket = {
    prefix: 'fab',
    iconName: 'get-pocket',
    icon: [448, 512, [], "f265", "M407.6 64l-367 0C18.5 64 0 82.5 0 104.6L0 239.8C0 364.5 99.7 464 224.2 464 348.2 464 448 364.5 448 239.8l0-135.2C448 82.2 430.3 64 407.6 64zm-162 268.5c-12.4 11.8-31.4 11.1-42.4 0-113.7-108.9-114.9-105.1-114.9-123.2 0-16.9 13.8-30.7 30.7-30.7 17 0 16.1 3.8 105.2 89.3 90.6-86.9 88.6-89.3 105.5-89.3s30.7 13.8 30.7 30.7c0 17.8-2.9 15.7-114.8 123.2z"]
  };
  var faGlide = {
    prefix: 'fab',
    iconName: 'glide',
    icon: [448, 512, [], "f2a5", "M252.8 148.6c0 8.8-1.6 17.7-3.4 26.4-5.8 27.8-11.6 55.8-17.3 83.6-1.4 6.3-8.3 4.9-13.7 4.9-23.8 0-30.5-26-30.5-45.5 0-29.3 11.2-68.1 38.5-83.1 4.3-2.5 9.2-4.2 14.1-4.2 11.4 0 12.3 8.3 12.3 17.9zM448 80l0 352c0 26.5-21.5 48-48 48L48 480c-26.5 0-48-21.5-48-48L0 80C0 53.5 21.5 32 48 32l352 0c26.5 0 48 21.5 48 48zM384 267c0-5.1-20.8-37.7-25.5-39.5-2.2-.9-7.2-2.3-9.6-2.3-23.1 0-38.7 10.5-58.2 21.5l-.5-.5c4.3-29.4 14.6-57.2 14.6-87.4 0-44.6-23.8-62.7-67.5-62.7-71.7 0-108 70.8-108 123.5 0 54.7 32 85 86.3 85 7.5 0 6.9-.6 6.9 2.3-10.5 80.3-56.5 82.9-56.5 58.9 0-24.4 28-36.5 28.3-38-.2-7.6-29.3-17.2-36.7-17.2-21.1 0-32.7 33-32.7 50.6 0 32.3 20.4 54.7 53.3 54.7 48.2 0 83.4-49.7 94.3-91.7 9.4-37.7 7-39.4 12.3-42.1 20-10.1 35.8-16.8 58.4-16.8 11.1 0 19 2.3 36.7 5.2 1.8 .1 4.1-1.7 4.1-3.5z"]
  };
  var faBity = {
    prefix: 'fab',
    iconName: 'bity',
    icon: [512, 512, [], "f37a", "M86.5 67.2c95.4-89.2 246.1-91.2 343.1 3.8 14.3 14.1-6.4 37.1-22.4 21.5-84.8-82.4-215.8-80.3-298.9-3.2-16.3 15.1-36.5-8.3-21.8-22.1zm98.9 418.6c19.3 5.7 29.3-23.6 7.9-30-112.2-33.9-175.8-149.7-147.5-261 5-19.6-24.9-28.1-30.2-7.1-32.1 127.4 41.1 259.8 169.8 298.1zm148.1-2c121.9-40.2 192.9-166.9 164.4-291-4.5-19.7-34.9-13.8-30 7.9 24.2 107.7-37.1 217.9-143.2 253.4-21.2 7-10.4 36 8.8 29.7zm-62.9-79l.2-71.8c0-8.2-6.6-14.8-14.8-14.8s-14.8 6.7-14.8 14.8l-.2 71.8c0 8.2 6.6 14.8 14.8 14.8s14.8-6.6 14.8-14.8zm71-269c2.1 90.9 4.7 131.9-85.5 132.5-92.5-.7-86.9-44.3-85.5-132.5 0-21.8-32.5-19.6-32.5 0l0 71.6c0 69.3 60.7 90.9 118 90.1 57.3 .8 118-20.8 118-90.1l0-71.6c0-19.6-32.5-21.8-32.5 0z"]
  };
  var faWpexplorer = {
    prefix: 'fab',
    iconName: 'wpexplorer',
    icon: [512, 512, [], "f2de", "M0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0zm480 0a224 224 0 1 0 -448 0 224 224 0 1 0 448 0zM160.9 124.6l86.9 37.1-37.1 86.9-86.9-37.1 37.1-86.9zm110 169.1l46.6 94-14.6 0-50-100-48.9 100-14 0 51.1-106.9-22.3-9.4 6-14 68.6 29.1-6 14.3-16.5-7.1zM259.1 177.4l68.6 29.4-29.4 68.3-68.3-29.1 29.1-68.6zm80.3 42.9l54.6 23.1-23.4 54.3-54.3-23.1 23.1-54.3z"]
  };
  var faMegaport = {
    prefix: 'fab',
    iconName: 'megaport',
    icon: [512, 512, [], "f5a3", "M222.5 209.6l0 66.2 33.5 33.5 33.3-33.3 0-66.4-33.4-33.4-33.4 33.4zM256 8a248 248 0 1 0 0 496 248 248 0 1 0 0-496zM401.1 422.4l-26.1 19.2-26-19.2 0-65.5-33.4-33.4-33.4 33.4 0 65.5-26.2 19.2-26.1-19.2 0-65.5-33.4-33.4-33.5 33.4 0 65.5-26.1 19.2-26.1-19.2 0-87 59.5-59.5 0-87.9 59.5-59.5 0-75.6 26.1-19.2 26.1 19.2 0 75.6 59.5 59.5 0 87.6 59.7 59.7 0 87.1-.1 0z"]
  };
  var faMdb = {
    prefix: 'fab',
    iconName: 'mdb',
    icon: [576, 512, [], "f8ca", "M17.4 160.4l-10.4 191.6 43.9 0 5.6-79.8 27.9 79.8 44.7 0 25.5-77.4 4.8 77.4 45.5 0-12.8-191.6-45.5 0-40.7 117.3-42.3-117.3-46.3 0zm281 0l-47.9 0 0 191.6 47.9 0s95 .8 94.2-95.8c-.8-94.2-94.2-95.8-94.2-95.8l0 0zm-1.2 146.5l0-102.1s46 4.3 46.8 50.6-46.8 51.5-46.8 51.5l0 0zm238.3-74.2c7.2-11.4 10-25 8-38.3-5.3-35.8-55.1-34.3-55.1-34.3l-51.9 0 0 191.6 45.5 0s87 4.8 87-63.8c0-43.1-33.5-55.1-33.5-55.1l0 0zm-51.9-31.9s13.6-1.6 16 9.6c1.4 6.7-4 12-4 12l-12 0 0-21.6zm-.1 109.5l.1-24.9 0-18.2 .1 0s41.6-4.7 41.2 22.4c-.3 25.7-41.3 20.7-41.3 20.7l0 0z"]
  };
  var faPage4 = {
    prefix: 'fab',
    iconName: 'page4',
    icon: [512, 512, [], "f3d7", "M256 504C119 504 8 393 8 256S119 8 256 8c20.9 0 41.3 2.6 60.7 7.5L50.3 392 256 392 256 504zm0-143.6l0-213.6-149.4 213.6 149.4 0zM352 392l0 92.7c45.7-19.2 84.5-51.7 111.4-92.7L352 392zm57.4-138.2l-21.2 8.4 21.2 8.3 0-16.7zm-20.3 54.5c-6.7 0-8 6.3-8 12.9l0 7.7 16.2 0 0-10c0-5.9-2.3-10.6-8.2-10.6zM504 256c0 37.3-8.2 72.7-23 104.4l-129 0 0-333.1C441.3 64.8 504 153.1 504 256zM368.4 143.6l68.2 0 0-47.6-13.9 0 0 32.6-13.9 0 0-29.6-13.9 0 0 29.6-12.7 0 0-32.6-13.9 0 0 47.6 .1 0zm68.1 185.3l-26.5 0 0-11c0-15.4-5.6-25.2-20.9-25.2-15.4 0-20.7 10.6-20.7 25.9l0 25.3 68.2 0 0-15-.1 0zm0-103l-68.2 29.7 0 12.4 68.2 29.5 0-16.6-14.4-5.7 0-26.5 14.4-5.9 0-16.9zm-4.8-68.5l-35.6 0 0 26.6 13.9 0 0-12.2 11 0c8.6 15.8 1.3 35.3-18.6 35.3-22.5 0-28.3-25.3-15.5-37.7l-11.6-10.6c-16.2 17.5-12.2 63.9 27.1 63.9 34 0 44.7-35.9 29.3-65.3z"]
  };
  var faTheRedYeti = {
    prefix: 'fab',
    iconName: 'the-red-yeti',
    icon: [512, 512, [], "f69d", "M488.7 241.7l20.7 7.1c-9.6-23.9-23.9-37-31.7-44.8l7.1-18.2c.2 0 12.3-27.8-2.5-30.7-.6-11.3-6.6-27-18.4-27-7.6-10.6-17.7-12.3-30.7-5.9-9.1 4.4-17.6 10-25.3 16.5-5.3-6.4-3 .4-3-29.8-37.1-24.3-45.4-11.7-74.8 3l.5 .5c-22-7.7-45.1-12.2-68.4-13.3-5.5-8.7-18.6-19.1-25.1-25.1l24.8 7.1c-5.5-5.5-26.8-12.9-34.2-15.2 18.2-4.1 29.8-20.8 42.5-33-34.9-10.1-67.9-5.9-97.9 11.8l12-44.2-1.8-.5c-31.6 24.2-33 41.9-33.7 45.5-.9-2.4-6.3-19.6-15.2-27-3.3 8.1-3.5 17.1-.5 25.3 3 8.4 5.9 14.8 8.4 18.9-16-3.3-28.3-4.9-49.2 0l-3.7 0 33 14.3c-20.2 18.9-36.1 41.9-46.7 67.4l-1.7 8.4 1.7 1.7 7.6-4.7c-3.3 11.6-5.3 19.4-6.6 25.8-10.9 12.2-20.2 25.8-27.8 40.3-15 1-31.8 10.8-40.3 14.3l3 3.4 28.8 1c-.5 1-.7 2.2-1.2 3.2-7.3 6.4-39.8 37.7-33 80.7l20.2-22.4c.5 1.7 .7 3.4 1.2 5.2 0 25.5 .4 89.6 64.9 150.5 43.6 40 96 60.2 157.5 60.2 121.7 0 223-87.3 223-211.5 6.8-9.7-1.2 3 16.7-25.1l13 14.3 2.5-.5c-1.8-11.7-4.8-23.1-8.9-34.2-1.5-4.8-3.8-9.3-6.8-13.3l0 0zM398.5 111.2l-.5 21.9c5.5 18.1 16.9 17.2 22.4 17.2l-3.4-4.7 22.4-5.4c-9 .5-18 .5-27 0 12.8-2.1 33.3-29 43-11.3 3.4 7.6 6.4 17.2 9.3 27.8l1.7-5.9c-1.3-5-1.8-10.1-1.7-15.2 5.4 .5 8.8 3.4 9.3 10.1 .5 6.4 1.7 14.8 3.4 25.3l4.7-11.3c4.6 0 4.5-3.6-2.5 20.7-20.9-8.7-35.1-8.4-46.5-8.4l18.2-16c-25.3 8.2-33 10.8-54.8 20.9-1.1-5.4-5-13.5-16-19.9-3.2 3.8-2.8 .9-.7 14.8l-2.5 0c-1.2-8.2-4.1-16-8.4-23.1l4.2-3.4c8.4-7.1 11.8-14.3 10.6-21.9-.5-6.4-5.4-13.5-13.5-20.7 5.6-3.4 15.2-.4 28.3 8.5zm-39.6-10.1c2.7 1.9 11.4 5.4 18.9 17.2 4.2 8.4 4 9.8 3.4 11.1-.5 2.4-.5 4.3-3 7.1-1.7 2.5-5.4 4.7-11.8 7.6-7.6-13-16.5-23.6-27.8-31.2l20.3-11.8zm-267.4 42l1.2-1.7c1.2-2.9 4.2-7.6 9.3-15.2l2.5-3.4-13 12.3 5.4-4.7-10.1 9.3-4.2 1.2c12.3-24.1 23.1-41.3 32.5-50.2 9.3-9.3 16-16 20.2-19.4l-6.4 1.2c-11.3-4.2-19.4-7.1-24.8-8.4 2.5-.5 3.7-.5 3.2-.5 10.3 0 17.5 .5 20.9 1.2 5.2 1.7 10.6 2.5 16 2.5l.5-1.7-8.4-35.8 13.5 29c2.8-4.4 4.8-9.2 5.9-14.3 1.7-6.4 5.4-13 10.1-19.4s7.6-10.6 9.3-11.3c-2.6 8.3-4.7 16.8-6.4 25.3l-1.7 7.1-.5 4.7 2.5 2.5c21.9-13.5 45.5-19.4 71.3-18.9l21.1 .5c-11.8 13.5-27.8 21.9-48.5 24.8-7.7 1.4-15.6 2.4-23.4 2.9l-.2-.5-2.5-1.2c-4.8-1-9.7-.3-14 2-2.5-.2-4.9-.5-7.1-.7l-2.5 1.7 .5 1.2c2 .2 3.9 .5 6.2 .7l-2 3.4 3.4-.5-10.6 11.3c-4.2 3-5.4 6.4-4.2 9.3l5.4-3.4 1.2 0c6.1-8.2 15.2-13.6 25.3-15.2l0-3c6.4 .5 13 1 19.4 1.2 6.4 0 8.4 .5 5.4 1.2 7.2 4 14.1 8.6 20.7 13.5 13.5 10.1 23.6 21.9 30 35.4 8.8 18.2 13.5 37.1 13.5 56.6 0 9.5-1 19-3 28.3-3.5 15.9-8.9 31.3-16 46l2.5 .5c18.2-19.7 41.9-16 49.2-16l-6.4 5.9 22.4 17.7-1.7 30.7c-5.4-12.3-16.5-21.1-33-27.8 16.5 14.8 23.6 21.1 21.9 20.2-4.8-2.8-3.5-1.9-10.8-3.7 4.1 4.1 17.5 18.8 18.2 20.7l.2 .2-.2 .2c0 1.8 1.6-1.2-14 22.9-75.2-15.3-106.3-42.7-141.2-63.2l11.8 1.2c-11.8-18.5-15.6-17.7-38.4-26.1l10.6-8.4c-8.8-3-18.2-3-28.3 .5l7.6-10.6-1.2-1.7c-14.9 4.3-19.8 9.2-22.6 11.3-1.1-5.5-2.8-12.4-12.3-28.8l-1.2 27-13.2-5c1.5-25.2 5.4-50.5 13.2-74.6zM368 473.1c-49.9 25-56.1 22.4-59 23.9-29.8-11.8-50.9-31.7-63.5-58.8l30 16.5c-9.8-9.3-18.3-16.5-38.4-44.3l11.8 23.1-17.7-7.6c14.2 21.1 23.5 51.7 66.6 73.5-120.8 24.2-199-72.1-200.9-74.3 11.1 9.2 22.9 17.5 35.4 24.8 3.4 1.7 7.1 2.5 10.1 1.2l-16-20.7c9.2 4.2 9.5 4.5 69.1 29-42.5-20.7-73.8-40.8-93.2-60.2-.5 6.4-1.2 10.1-1.2 10.1 8.7 7.3 15.8 16.4 20.7 26.6-39-18.9-57.6-47.6-71.3-82.6 49.9 55.1 118.9 37.5 120.5 37.1 34.8 16.4 69.9 23.6 113.9 10.6 3.3 0 20.3 17 25.3 39.1l4.2-3-2.5-23.6c9 9 24.9 22.6 34.4 13-15.6-5.3-23.5-9.5-29.5-31.7 4.6 4.2 7.6 9 27.8 15l1.2-1.2-10.5-14.2c11.7-4.8-3.5 1 32-10.8 4.3 34.3 9 49.2 .7 89.5zM483.3 258.7l-2.5 .5 3 9.3c-3.5 5.9-23.7 44.3-71.6 79.7-39.5 29.8-76.6 39.1-80.9 40.3l-7.6-7.1-1.2 3 14.3 16-7.1-4.7 3.4 4.2-1.2 0-21.9-13.5 9.3 26.6-19-27.9-1.2 2.5 7.6 29c-6.1-8.2-21-32.6-56.8-39.6l32.5 21.2c-31.2 4.7-63 2.5-93.2-6.4-4.2-1.2-8.9-2.5-13.5-4.2l1.2-3-44.8-22.4 26.1 22.4c-57.7 9.1-113-25.4-126.4-83.4L29.3 284.8 7 307.1c19.5-57.5 25.6-57.9 51.4-70.1-9.1-5.3-1.6-3.3-38.4-9.3 15.8-5.8 33-15.4 73 5.2 1.2-.7 2.4-1.3 3.7-1.7 .6-3.2 .4-.8 1-11.8 3.9 10 3.6 8.7 3 9.3l1.7 .5c12.7-6.5 8.9-4.5 17-8.9l-5.4 13.5 22.3-5.8-8.4 8.4 2.5 2.5c4.5-1.8 30.3 3.4 40.8 16l-23.6-2.5c39.4 23 51.5 54 55.8 69.6l1.7-1.2c-2.8-22.3-12.4-33.9-16-40.1 4.2 5 39.2 34.6 110.4 46-11.3-.5-23.1 5.4-34.9 18.9l46.7-20.2-9.3 21.9c7.6-10.1 14.8-23.6 21.2-39.6l0-.5 1.2-3-1.2 16c13.5-41.8 25.3-78.5 35.4-109.7l13.5-27.8 0-2-5.4-4.2 10.1 0 5.9 4.2 2.5-1.2-3.4-16 12.3 18.9 41.8-20.2-14.8 13 .5 2.9 17.7-.5c11.1 .4 22.1 1.8 33 4.2l-23.6 2.5-1.2 3 26.6 23.1c9.9 9.9 18.9 20.6 27 32-11.2-3.3-10.3-3.4-21.2-3.4l12.3 32.5-8.9-12.8zm-6.1-71.3l-3.9 13-14.3-11.8 18.2-1.2zm-254.8 7.1c1.7 10.6 4.7 17.7 8.8 21.9-9.3 6.6-27.5 13.9-46.5 16l.5 1.2c8.3 1.3 16.9 .4 24.8-2.5l-7.1 13c4.2-1.7 10.1-7.1 17.7-14.8 11.9-5.5 12.7-5.1 20.2-16-12.7-6.4-15.7-13.7-18.4-18.8zm3.7-102.3c-6.4-3.4-10.6 3-12.3 18.9s2.5 29.5 11.8 39.6 18.2 10.6 26.1 3 3.4-23.6-11.3-47.7c-3.5-5.7-8.4-10.5-14.3-13.8l0 0zm-4.7 46.3c5.4 2.2 10.5 1.9 12.3-10.6l0-4.7-1.2 .5c-4.3-3.1-2.5-4.5-1.7-6.2l.5-.5c-.9-1.2-5-8.1-12.5 4.7-.5-13.5 .5-21.9 3-24.8 1.2-2.5 4.7-1.2 11.3 4.2 6.4 5.4 11.3 16 15.2 32.5 6.5 28-19.8 26.2-26.9 4.9zm-45-5.5c1.6 .3 9.3-1.1 9.3-14.8l-.5 0c-5.4-1.1-2.2-5.5-.7-5.9-1.7-3-3.4-4.2-5.4-4.7-8.1 0-11.6 12.7-8.1 21.2 .5 1.1 1.3 2 2.2 2.8s2 1.2 3.2 1.4l0 0zm40.1-50.1l-2.5 .5 .5 3c9.1-.5 18.1 1.5 26.1 5.9-2.5-5.5-10-14.3-28.3-14.3l.5 2.5 3.7 2.4zm-71.8 49.4c21.7 16.8 16.5 21.4 46.5 23.6l-2.9-4.7c8.4-7.2 13.7-17.3 14.8-28.3 1.7-16-1.2-29.5-8.8-41.3l13-7.6c0-.3 0-.6-.1-.9s-.2-.6-.4-.8c-2.2-.9-4.6-1.2-7-.9s-4.6 1.2-6.5 2.6c-12.7 6.7-28 20.9-29 22.4-1.7 1.7-3.4 5.9-5.4 13.5-1.9 7.7-2.9 15.6-2.9 23.6-4.7-8-10.5-6.4-19.9-5.9l7.1 7.6c-16.5 0-23.3 15.4-23.6 16 6.8 0 4.6-7.6 30-12.3-4.3-6.3-3.3-5-4.9-6.6zm18.7-18.7c1.2-7.6 3.4-13 6.4-17.2 5.4-6.4 10.6-10.1 16-11.8 4.2-1.7 7.1 1.2 10.1 9.3 2.5 8.2 3.5 16.8 3 25.3-.5 9.3-3.4 17.2-8.4 23.1-2.9 3.4-5.4 5.9-6.4 7.6-3.8 .4-7.6 .2-11.3-.5l-7.1-3.4-5.4-6.4c.8-10 1.3-18.8 3.1-26zm42 56.1c-34.8 14.4-34.7 14-36.1 14.3-20.8 4.7-19-24.4-18.9-24.8l5.9-1.2-.5-2.5c-20.2-2.6-31 4.2-32.5 4.9 .5 .5 3 3.4 5.9 9.3 4.2-6.4 8.8-10.1 15.2-10.6-1.7 11.2-1.2 22.7 1.7 33.7 .1 .5 2.6 17.4 27.5 24.1 11.3 3 27 1.2 48.9-5.4l-9.2 .5c-4.2-14.8-6.4-24.8-5.9-29.5 11.3-8.8 21.9-11.3 30.7-7.6l2.5 0-11.8-7.6-7.1 .5c-5.9 1.2-12.3 4.2-19.4 8.4l3.1-6.5z"]
  };
  var faJira = {
    prefix: 'fab',
    iconName: 'jira',
    icon: [512, 512, [], "f7b1", "M498.5 241.7c-72.9-72.7-169.4-169.9-241.5-241.7-165.5 164.9-242.5 241.7-242.5 241.7-7.9 7.9-7.9 20.7 0 28.7 132.8 132.3 61.8 61.5 242.5 241.6 379.4-378 15.7-16.7 241.5-241.7 8-7.9 8-20.7 0-28.6zM257 331.7l-76-75.7 76-75.7 76 75.7-76 75.7z"]
  };
  var faFedex = {
    prefix: 'fab',
    iconName: 'fedex',
    icon: [640, 512, [], "f797", "M586 284.5l53.3-59.9-62.4 0-21.7 24.8-22.5-24.8-118.7 0 0-16 56.1 0 0-48.1-151.2 0 0 75.5-.5 0c-9.6-11-21.5-14.8-35.4-14.8-28.4 0-49.8 19.4-57.3 44.9-18-59.4-97.4-57.6-121.9-14l0-24.2-54.8 0 0-26.2 60 0 0-41.1-109 0 0 184.4 49 0 0-77.5 48.9 0c-1.5 5.7-2.3 11.8-2.3 18.2 0 73.1 102.6 91.4 130.2 23.7l-42 0c-14.7 20.9-45.8 8.9-45.8-14.6l85.5 0c3.7 30.5 27.4 56.9 60.1 56.9 14.1 0 27-6.9 34.9-18.6l.5 0 0 11.9 212.2 0 22.1-25 22.3 25 64.4 0-54-60.5zM139.3 267.9c6.1-26.3 41.7-25.6 46.5 0l-46.5 0zm153.4 48.9c-34.6 0-34-62.8 0-62.8 32.6 0 34.5 62.8 0 62.8zm167.8 19.1l-94.4 0 0-166.5 95 0 0 30.2-56.1 0 0 33.9 55.5 0 0 28.1-56.1 0 0 44.7 56.1 0 0 29.6zm-45.9-39.8l0-24.4 56.1 0 0-44 50.7 57-50.7 57 0-45.6-56.1 0zm138.6 10.3l-26.1 29.5-38.1 0 45.6-51.2-45.6-51.2 39.7 0 26.6 29.3 25.6-29.3 38.5 0-45.4 51 46 51.4-40.5 0-26.3-29.5z"]
  };
  var faEvernote = {
    prefix: 'fab',
    iconName: 'evernote',
    icon: [384, 512, [], "f839", "M121.1 132.2c1.6 22.3-17.6 21.6-21.6 21.6-68.9 0-73.6-1-83.6 3.3-.6 .2-.7 0-.4-.4L124.1 46.4c.4-.4 .6-.2 .4 .4-4.4 10-3.4 15.1-3.4 85.4zm79 308c-14.7-37.1 13-76.9 52.5-76.6 17.5 0 22.6 23.2 7.9 31.4-6.2 3.3-24.9 1.7-25.1 19.2 0 17.1 19.7 25 31.2 24.9 6 0 11.9-1.2 17.5-3.5s10.6-5.7 14.8-9.9 7.6-9.3 9.9-14.8 3.5-11.5 3.5-17.5l0-.1c0-11.6-7.8-47.2-47.5-55.3-7.7-1.5-65-6.3-68.4-50.5-3.7 16.9-17.4 63.5-43.1 69.1-8.7 1.9-69.7 7.6-112.9-36.8 0 0-18.6-15.2-28.2-58-3.4-15.7-9.3-39.7-11.1-62 0-18 11.1-30.4 25.1-32.2 81 0 90 2.3 101-7.8 9.8-9.2 7.8-15.5 7.8-102.8 1-8.3 7.8-30.8 53.4-24.1 6 .9 31.9 4.2 37.5 30.6L290 74.8c20.4 3.7 70.9 7 80.6 57.9 22.7 121.1 8.9 238.5 7.8 238.5-16 114.4-111.1 108.9-111.1 108.9-19-.2-54.2-9.4-67.3-39.8l0 0zM281 235.4c-1 1.9-2.2 6 .9 7 14.1 4.9 39.8 6.8 45.9 5.5 3.1-.2 3.1-4.4 2.5-6.6-3.5-21.8-40.8-26.5-49.2-5.9l0 0z"]
  };
  var faUsb = {
    prefix: 'fab',
    iconName: 'usb',
    icon: [640, 512, [], "f287", "M633.5 256c0 3.1-1.7 6.1-4.5 7.5L539.9 317c-1.4 .8-2.8 1.4-4.5 1.4-1.4 0-3.1-.3-4.5-1.1-2.8-1.7-4.5-4.5-4.5-7.8l0-35.6-230.7 0c25.3 39.6 40.5 106.9 69.6 106.9l26.7 0 0-26.8c0-5 3.9-8.9 8.9-8.9l89.1 0c5 0 8.9 3.9 8.9 8.9l0 89.1c0 5-3.9 8.9-8.9 8.9l-89.1 0c-5 0-8.9-3.9-8.9-8.9l0-26.7-26.7 0c-75.4 0-81.1-142.5-124.7-142.5l-100.3 0c-8.1 30.6-35.9 53.5-69 53.5-39.3-.1-71.3-32.1-71.3-71.4s32-71.3 71.3-71.3c33.1 0 61 22.8 69 53.5 39.1 0 43.9 9.5 74.6-60.4 40.1-89.1 58.1-82.1 108.9-82.1 7.5-20.9 27-35.6 50.4-35.6 29.5 0 53.5 23.9 53.5 53.5s-23.9 53.5-53.5 53.5c-23.4 0-42.9-14.8-50.4-35.6l-29.8 0c-29.1 0-44.3 67.4-69.6 106.9l302.1 0 0-35.6c0-3.3 1.7-6.1 4.5-7.8s6.4-1.4 8.9 .3L629 248.8c2.8 1.1 4.5 4.1 4.5 7.2z"]
  };
  var faAngrycreative = {
    prefix: 'fab',
    iconName: 'angrycreative',
    icon: [640, 512, [], "f36e", "M640 238.2l-3.2 28.2-34.5 2.3-2 18.1 34.5-2.3-3.2 28.2-34.4 2.2-2.3 20.1 34.4-2.2-3 26.1-64.7 4.1 12.7-113.2-47.3 115.4-31.9 2-23.8-117.8 30.3-2 13.6 79.4 31.7-82.4 93.1-6.2zM426.8 371.5l28.3-1.8 12.9-120.1-28.4 1.9-12.8 120zM162 388.1l-19.4-36-3.5 37.4-28.2 1.7 2.7-29.1c-11 18-32 34.3-56.9 35.8-32.8 2-59.7-20.9-56.4-58.2 2.6-29.3 26.7-62.8 67.5-65.4 37.7-2.4 47.6 23.2 51.3 28.8l2.8-30.8 38.9-2.5c20.1-1.3 38.7 3.7 42.5 23.7l2.6-26.6 64.8-4.2-2.7 27.9-36.4 2.4-1.7 17.9 36.4-2.3-2.7 27.9-36.4 2.3-1.9 19.9 36.3-2.3-2.1 20.8 55-117.2 23.8-1.6 32.1 110.6 8.9-85.6-22.3 1.4 2.9-27.9 75-4.9-3 28-24.3 1.6-9.7 91.9-58 3.7-4.3-15.6-39.4 2.5-8 16.3-126.2 7.7zm-44.3-70.2l-26.4 1.7c-6.7-12.4-14.4-16.6-26.3-15.8-19 1.2-33.3 17.5-34.6 33.3-1.4 16 7.3 32.5 28.7 31.2 12.8-.8 21.3-8.6 28.9-18.9l27-1.7 2.7-29.8zm56.1-7.7c1.2-12.9-7.6-13.6-26.1-12.4L145 326.3c14.2-.9 27.5-2.1 28.8-16.1zM194.9 381l5.8-60c-5 13.5-14.7 21.1-27.9 26.6L194.9 381zm135.4-45l-7.9-37.8-15.8 39.3 23.7-1.5zM160.2 261.4l-4.3-17.5-39.6 2.6-8.1 18.2-31.9 2.1 57-121.9 23.9-1.6 30.7 102 9.9-104.7 27-1.8 37.8 63.6 6.5-66.6 28.5-1.9-4 41.2c7.4-13.5 22.9-44.7 63.6-47.5 40.5-2.8 52.4 29.3 53.4 30.3l3.3-32 39.3-2.7c12.7-.9 27.8 .3 36.3 9.7l-4.4-11.9 32.2-2.2 12.9 43.2 23-45.7 31-2.2-43.6 78.4-4.8 44.3-28.4 1.9 4.8-44.3-15.8-43c1 22.3-9.2 40.1-32 49.6l25.2 38.8-36.4 2.4-19.2-36.8-4 38.3-28.4 1.9 3.3-31.5c-6.7 9.3-19.7 35.4-59.6 38-26.2 1.7-45.6-10.3-55.4-39.2l-4 40.3-25 1.6-37.6-63.3-6.3 66.2-56.8 3.7zm276.6-82.1c10.2-.7 17.5-2.1 21.6-4.3 4.5-2.4 7-6.4 7.6-12.1 .6-5.3-.6-8.8-3.4-10.4-3.6-2.1-10.6-2.8-22.9-2l-2.9 28.8zM327.7 214c5.6 5.9 12.7 8.5 21.3 7.9 4.7-.3 9.1-1.8 13.3-4.1 5.5-3 10.6-8 15.1-14.3l-34.2 2.3 2.4-23.9 63.1-4.3 1.2-12-31.2 2.1c-4.1-3.7-7.8-6.6-11.1-8.1-4-1.7-8.1-2.8-12.2-2.5-8 .5-15.3 3.6-22 9.2-7.7 6.4-12 14.5-12.9 24.4-1.1 9.6 1.4 17.3 7.2 23.3zm-201.3 8.2l23.8-1.6-8.3-37.6-15.5 39.2z"]
  };
  var faMizuni = {
    prefix: 'fab',
    iconName: 'mizuni',
    icon: [512, 512, [], "f3cc", "M256 8a248 248 0 1 0 0 496 248 248 0 1 0 0-496zM176 359.9c-31.4 10.6-58.8 27.3-80 48.2L96 136c0-22.1 17.9-40 40-40s40 17.9 40 40l0 223.9zM296 350c-12.9-2-26.2-3.1-39.8-3.1-13.8 0-27.2 1.1-40.2 3.1l0-214c0-22.1 17.9-40 40-40s40 17.9 40 40l0 214zm120 57.7c-21.2-20.8-48.6-37.4-80-48L336 136c0-22.1 17.9-40 40-40s40 17.9 40 40l0 271.7z"]
  };
  var faItchIo = {
    prefix: 'fab',
    iconName: 'itch-io',
    icon: [512, 512, [], "f83a", "M71.9 34.8C50.2 47.7 7.4 96.8 7 109.7l0 21.3c0 27.1 25.3 50.8 48.2 50.8 27.6 0 50.5-22.8 50.5-50 0 27.1 22.2 50 49.8 50s49-22.8 49-50c0 27.1 23.6 50 51.2 50l.5 0c27.6 0 51.2-22.8 51.2-50 0 27.1 21.5 50 49 50s49.8-22.8 49.8-50c0 27.1 23 50 50.5 50 23 0 48.3-23.8 48.3-50.8l0-21.3c-.4-12.9-43.2-62.1-64.9-75-67.4-2.3-114.2-2.7-184-2.7S91.1 33.1 71.9 34.8zM204.2 169.2c-22 38.4-77.9 38.7-99.8 .2-13.2 23.1-43.2 32.1-56 27.7-3.9 40.2-13.7 237.1 17.7 269.2 80 18.7 302.1 18.1 379.8 0 31.6-32.3 21.3-232 17.7-269.2-12.9 4.4-42.9-4.6-56-27.7-22 38.5-77.8 38.1-99.8-.2-7.1 12.5-23 28.9-51.8 28.9-10.4 .3-20.8-2.2-29.9-7.3s-16.7-12.6-21.9-21.6l0 0zm-41.6 53.8c16.5 0 31.1 0 49.2 19.8 29.3-3 58.9-3 88.2 0 18.2-19.7 32.8-19.7 49.2-19.7 52.3 0 65.2 77.5 83.9 144.4 17.3 62.2-5.5 63.7-34 63.7-42.1-1.6-65.5-32.2-65.5-62.8-39.3 6.4-101.9 8.8-155.6 0 0 30.6-23.3 61.2-65.5 62.8-28.4-.1-51.2-1.6-33.9-63.7 18.7-67 31.6-144.4 83.9-144.4l0-.1zM256 270.8s-44.4 40.8-52.4 55.2l29-1.2 0 25.3c0 1.5 21.3 .2 23.3 .2 11.6 .5 23.3 1 23.3-.2l0-25.3 29 1.2c-8-14.5-52.4-55.2-52.4-55.2l.1 0z"]
  };
  var faWindows = {
    prefix: 'fab',
    iconName: 'windows',
    icon: [448, 512, [], "f17a", "M0 93.7l183.6-25.3 0 177.4-183.6 0 0-152.1zM0 418.3l183.6 25.3 0-175.2-183.6 0 0 149.9zm203.8 28l244.2 33.7 0-211.6-244.2 0 0 177.9zm0-380.6l0 180.1 244.2 0 0-213.8-244.2 33.7z"]
  };
  var faStumbleupon = {
    prefix: 'fab',
    iconName: 'stumbleupon',
    icon: [512, 512, [], "f1a4", "M502.9 266l0 69.7c0 62.1-50.3 112.4-112.4 112.4-61.8 0-112.4-49.8-112.4-111.3l0-70.2 34.3 16 51.1-15.2 0 70.6c0 14.7 12 26.5 26.7 26.5S417 352.7 417 338l0-72 85.9 0zM278.2 207.8l34.3 16 51.1-15.2 0-35.6c0-60.5-51.1-109-112.1-109-60.8 0-112.1 48.2-112.1 108.2l0 162.4c0 14.9-12 26.7-26.7 26.7S86 349.5 86 334.6l0-68.6-86 0 0 69.7c0 62 50.3 112.3 112.4 112.3 61.6 0 112.4-49.5 112.4-110.8l0-160.3c0-14.7 12-26.7 26.7-26.7s26.7 12 26.7 26.7l0 30.9z"]
  };
  var faGoogle = {
    prefix: 'fab',
    iconName: 'google',
    icon: [512, 512, [], "f1a0", "M500 261.8C500 403.3 403.1 504 260 504 122.8 504 12 393.2 12 256S122.8 8 260 8c66.8 0 123 24.5 166.3 64.9l-67.5 64.9c-88.3-85.2-252.5-21.2-252.5 118.2 0 86.5 69.1 156.6 153.7 156.6 98.2 0 135-70.4 140.8-106.9l-140.8 0 0-85.3 236.1 0c2.3 12.7 3.9 24.9 3.9 41.4z"]
  };
  var faDiscord = {
    prefix: 'fab',
    iconName: 'discord',
    icon: [576, 512, [], "f392", "M492.5 69.8c-.2-.3-.4-.6-.8-.7-38.1-17.5-78.4-30-119.7-37.1-.4-.1-.8 0-1.1 .1s-.6 .4-.8 .8c-5.5 9.9-10.5 20.2-14.9 30.6-44.6-6.8-89.9-6.8-134.4 0-4.5-10.5-9.5-20.7-15.1-30.6-.2-.3-.5-.6-.8-.8s-.7-.2-1.1-.2c-41.3 7.1-81.6 19.6-119.7 37.1-.3 .1-.6 .4-.8 .7-76.2 113.8-97.1 224.9-86.9 334.5 0 .3 .1 .5 .2 .8s.3 .4 .5 .6c44.4 32.9 94 58 146.8 74.2 .4 .1 .8 .1 1.1 0s.7-.4 .9-.7c11.3-15.4 21.4-31.8 30-48.8 .1-.2 .2-.5 .2-.8s0-.5-.1-.8-.2-.5-.4-.6-.4-.3-.7-.4c-15.8-6.1-31.2-13.4-45.9-21.9-.3-.2-.5-.4-.7-.6s-.3-.6-.3-.9 0-.6 .2-.9 .3-.5 .6-.7c3.1-2.3 6.2-4.7 9.1-7.1 .3-.2 .6-.4 .9-.4s.7 0 1 .1c96.2 43.9 200.4 43.9 295.5 0 .3-.1 .7-.2 1-.2s.7 .2 .9 .4c2.9 2.4 6 4.9 9.1 7.2 .2 .2 .4 .4 .6 .7s.2 .6 .2 .9-.1 .6-.3 .9-.4 .5-.6 .6c-14.7 8.6-30 15.9-45.9 21.8-.2 .1-.5 .2-.7 .4s-.3 .4-.4 .7-.1 .5-.1 .8 .1 .5 .2 .8c8.8 17 18.8 33.3 30 48.8 .2 .3 .6 .6 .9 .7s.8 .1 1.1 0c52.9-16.2 102.6-41.3 147.1-74.2 .2-.2 .4-.4 .5-.6s.2-.5 .2-.8c12.3-126.8-20.5-236.9-86.9-334.5zm-302 267.7c-29 0-52.8-26.6-52.8-59.2s23.4-59.2 52.8-59.2c29.7 0 53.3 26.8 52.8 59.2 0 32.7-23.4 59.2-52.8 59.2zm195.4 0c-29 0-52.8-26.6-52.8-59.2s23.4-59.2 52.8-59.2c29.7 0 53.3 26.8 52.8 59.2 0 32.7-23.2 59.2-52.8 59.2z"]
  };
  var faHackerNews = {
    prefix: 'fab',
    iconName: 'hacker-news',
    icon: [448, 512, [], "f1d4", "M0 32l0 448 448 0 0-448-448 0zM21.2 229.2l-.2 0c.1-.1 .2-.3 .3-.4 0 .1 0 .3-.1 .4zm218 53.9l0 100.9-31.4 0 0-102.7-79.8-153.3 37.3 0c52.5 98.3 49.2 101.2 59.3 125.6 12.3-27 5.8-24.4 60.6-125.6l34.8 0-80.8 155.1z"]
  };
  var faEleventy = {
    prefix: 'fab',
    iconName: 'eleventy',
    icon: [640, 512, ["11ty"], "e7d6", "M615.3 168.5c2.3 0 4.6 .7 6.6 2.2 1.9 1.4 3.1 3.3 3.8 5 1.4 3.3 1.8 7.3 1.8 11.3 0 2.2-.3 4.9-.7 7.6l0 .4-50.9 264.9 0 0c-4 22.1-8.5 39.4-13.6 51.7-5 12.1-10.9 21.6-18.6 27l0 0c-7.5 5.3-16.9 7.7-27.6 8l-3 0c-16 0-29.3-4.2-36.9-14.8-.1-.1-.1-.1-.2-.2-.1-.2-.3-.4-.5-.6l0 0c-1.8-2.4-2.5-5.2-2.9-7.4-.5-2.8-.7-6.1-.7-9.8 0-7.3 .6-13.5 2.1-18.2 1.4-4.4 4.8-10.4 12.2-10.4l1.3 .1c.2 0 .4 .1 .5 .1 .3 .1 .6 .1 .8 .2 .6 .1 1.3 .3 2.2 .6l7.6 2.2 .1 0 7.6 2.1c.9 .2 1.7 .4 2.2 .5 .4 .1 .6 .1 .7 .1 0 0 .1 0 .2-.1 .1-.1 .4-.2 .8-.6 .9-.9 2.2-2.6 3.6-5.7 2.6-5.8 4.2-14.7 4.2-27.4 0-.7-.3-3.4-1.3-8.9-.9-5.1-2.3-12.2-4.2-21.1l-56-232.9-.1-.4 0-.3c-.4-2.7-.7-5.3-.7-7.3 0-3.7 .4-7.5 1.7-10.6 .7-1.6 1.8-3.4 3.5-4.9 1.9-1.5 4.2-2.3 6.5-2.3l34.6 0c4.6 0 8.7 1.7 11.9 5l1.3 1.5c1.2 1.6 2 3.4 2.7 5.2 .9 2.4 1.5 5.1 2 8.1l30.4 161.2 23.8-160c.8-5.8 2.2-11.4 5.1-15.1 3-3.8 7.2-5.8 12-5.8l24 0zM375.1 34.6c2.6 0 5.1 .7 7.4 2.3 2.2 1.5 3.7 3.6 4.7 5.7 1.9 4 2.5 9.1 2.5 14.5l0 111.2c0 .1 0 .2 0 .3l32.4 0c2.5 0 5 .6 7.2 2.1 2.2 1.4 3.7 3.4 4.8 5.5 2 3.9 2.6 8.8 2.6 13.9l0 15.4c0 5-.6 9.8-2.6 13.7-1.1 2-2.6 4-4.8 5.4-2.2 1.4-4.7 2-7.1 2l-32.5 0 0 145.8c0 10.8 .7 19.5 2 26.2 1.4 6.9 3.1 10.9 4.7 12.9 1.2 1.5 2.2 2.5 3.1 3.2l2.2 1.4 .1 .1 2.9 .8c1.2 .2 2.6 .3 4.3 .3l20.3 0c4.5 0 8.9 1.7 11.8 5.8 2.6 3.6 3.3 8.1 3.3 12.2l0 17.2c0 4.5-.8 9.3-3.4 13.1-3 4.2-7.5 6-12.3 6l0 0-29.1 .1c-8 0-15-.6-21.2-1.7-6.7-1.3-13.4-4.1-20.1-8.1-7.2-4.4-13-10.3-17.5-17.8-4.5-7.5-7.9-17.5-10.5-29.5-2.6-12.2-3.9-26.6-3.9-43l0-144.9-13.4 0c-2.4 0-4.9-.6-7.1-2-2.2-1.4-3.7-3.4-4.8-5.4-2-3.9-2.6-8.7-2.6-13.7l0-15.4c0-5.1 .6-10 2.6-13.9 1.1-2.1 2.6-4 4.8-5.5 2.2-1.5 4.7-2.1 7.2-2.1l13.4 0 0-.6 5.2-111.2 0-.1 .3-3.9c.5-3.8 1.3-7.4 2.7-10.3 2.1-4.2 6-7.9 11.8-7.9l28.6 0zm-268 11.7c1.8 .3 3.6 .9 5.3 2.1 2.1 1.5 3.5 3.5 4.4 5.4 1.7 3.7 2.3 8.4 2.3 13.2l0 377.8c0 6.7-.6 12.6-2.4 17.1-.9 2.3-2.3 4.7-4.4 6.5-2.3 2-5.1 3-8.1 3l-43.7 0c-3 0-5.8-1.1-8.1-3.1-2.1-1.9-3.4-4.3-4.2-6.5-1.7-4.5-2.3-10.3-2.3-17l0-315.8c-4.8 1.2-8.7 2.2-11.5 2.9-1.9 .5-3.4 .8-4.4 1.1-.5 .1-.9 .2-1.2 .3-.1 0-.3 .1-.5 .1-.1 0-.2 0-.3 .1 0 0-.2 0-.3 0 0 0-.2 0-.4 0l0 0c-.1 0-.3 0-.4 0-.1 0-.2 0-.2 0-2.2 .1-4.5-.4-6.6-1.7-2.3-1.4-3.8-3.4-4.7-5.3-1.8-3.7-2.3-8.4-2.3-13l0-27.4c0-4.4 .7-8.8 2.6-12.4 2.1-3.9 5.5-6.6 9.8-7.6l75.5-19.5c1.4-.4 2.9-.5 4.4-.5l1.8 .1zm143.8-.5c1.8 .3 3.6 .9 5.2 2.1 2.1 1.5 3.5 3.5 4.4 5.4 1.7 3.7 2.2 8.4 2.2 13.2l0 377.8c0 6.7-.6 12.6-2.4 17.1-.9 2.3-2.3 4.7-4.4 6.5-2.3 2-5.1 3-8.1 3l-43.7 0c-3 0-5.8-1.1-8.1-3.1-2.1-1.9-3.4-4.3-4.2-6.5-1.7-4.5-2.3-10.3-2.3-17l0-315.8c-4.8 1.2-8.7 2.2-11.5 2.9-1.9 .5-3.4 .8-4.4 1.1-.5 .1-.9 .2-1.2 .3-.1 0-.3 .1-.5 .1-.1 0-.2 0-.3 .1-.1 0-.2 0-.3 0 0 0-.2 0-.4 0l0 0c-.1 0-.2 0-.3 0-.1 0-.2 0-.3 0-2.2 .1-4.5-.4-6.6-1.7-2.3-1.4-3.8-3.4-4.7-5.3-1.8-3.7-2.3-8.3-2.3-13l0-27.4c0-4.4 .7-8.7 2.6-12.4 2.1-3.9 5.5-6.6 9.8-7.6l75.4-19.4c1.4-.4 2.9-.5 4.4-.5l1.8 .1z"]
  };
  var fa11ty = faEleventy;
  var faTeamspeak = {
    prefix: 'fab',
    iconName: 'teamspeak',
    icon: [576, 512, [], "f4f9", "M152.8 37.2c-32.2 38.1-56.1 82.6-69.9 130.5 0 .2-.1 .3-.1 .5-39.3 16.2-66.8 54.8-66.8 99.8 0 59.6 48.4 108 108 108s108-48.4 108-108c0-53.5-38.9-97.9-90-106.5 15.7-41.8 40.4-79.6 72.3-110.7 1.8-1.6 4-2.6 6.3-3.1 37.2-11.5 76.7-13.3 114.8-5.2 119.3 25.1 198.6 138.2 181.7 258.8-8.4 62.6-38.6 112.7-87.7 151.4-50.1 39.7-107.5 54.3-170.2 52.2l-24-1c12.4 2.8 25 4.9 37.6 6.3 40.7 4.2 81.4 2.1 120.1-12.5 94-35.5 149.3-102.3 162.9-202.5 4.8-52.6-5.8-105.4-30.8-152-70.4-131.9-234.2-181.6-366-111.2-2.4 1.4-4.5 3.1-6.3 5.2l.1 0zM309.4 433.9c-2.1 11.5-4.2 21.9-14.6 31.3 53.2-1 123.2-29.2 161.8-97.1 39.7-69.9 37.6-139.9-6.3-207.8-36.5-55.3-89.8-82.4-156.6-86.6 1.5 2.3 3.2 4.4 5.2 6.3l5.2 6.3c25.1 31.3 37.6 67.9 42.8 107.5 2.1 15.7-1 30.3-13.6 41.8-4.2 3.1-5.2 6.3-4.2 10.4l7.3 17.7 29.3 54.3c5.2 11.5 4.2 19.8-6.3 28.2-3.2 2.5-6.7 4.6-10.4 6.3l-18.8 8.4 3.1 13.6c3.1 6.3 1 12.5-3.1 17.7-2.5 2.4-3.8 5.9-3.1 9.4 2.1 11.5-2.1 19.8-12.5 25.1-2.1 1-4.2 5.2-5.2 7.3l0-.1zm-133.6-3.1c16.7 11.5 34.5 20.9 53.2 26.1 24 5.2 41.8-6.3 44.9-30.3 1-8.4 5.2-14.6 12.5-17.7 7.3-4.2 8.4-7.3 2.1-13.6l-9.4-8.4 13.6-4.2c6.3-2.1 7.3-5.2 5.2-11.5-1.4-3-2.4-6.2-3.1-9.4-3.1-14.6-2.1-15.7 11.5-18.8 8.4-3.1 15.7-6.3 21.9-12.5 3.1-2.1 3.1-4.2 1-8.4l-16.7-30.3c-1-1.9-2.1-3.8-3.1-5.7-6.4-11.7-13-23.6-15.7-37.1-2.1-9.4-1-17.7 8.4-24 5.2-4.2 8.4-9.4 8.4-16.7-.4-10.1-1.5-20.3-3.1-30.3-6.3-37.6-23-68.9-51.2-95-5.2-4.2-9.4-6.3-16.7-4.2l-35.6 12.7 6 3.6c6.3 3.7 12.2 7.3 17 12.1 30.3 26.1 41.8 61.6 45.9 100.2 1 8.4 0 16.7-7.3 21.9-8.4 5.2-10.4 12.5-7.3 20.9 4.9 13.2 10.4 26 16.7 38.6L291.6 318c-6.3 8.4-13.6 11.5-21.9 14.6-12.5 3.1-14.6 7.3-10.4 20.9 .6 1.5 1.4 2.8 2.1 4.2 2.1 5.2 1 8.4-4.2 10.4l-12.5 3.1 5.2 4.2 4.2 4.2c4.2 5.2 4.2 8.4-2.1 10.4-7.3 4.2-11.5 9.4-11.5 17.7 0 12.5-7.3 19.8-18.8 24-3.8 1-7.6 1.5-11.5 1l-34.5-2.1 .1 .2z"]
  };
  var faSupple = {
    prefix: 'fab',
    iconName: 'supple',
    icon: [640, 512, [], "f3f9", "M640 262.5c0 64.1-109 116.1-243.5 116.1-24.8 0-48.6-1.8-71.1-5 7.7 .4 15.5 .6 23.4 .6 134.5 0 243.5-56.9 243.5-127.1 0-29.4-19.1-56.4-51.2-78 60 21.1 98.9 55.1 98.9 93.4zM47.7 227.9c-.1-70.2 108.8-127.3 243.3-127.6 7.9 0 15.6 .2 23.3 .5-22.5-3.2-46.3-4.9-71-4.9-134.5 .4-243.4 52.6-243.3 116.7 .1 38.3 39.1 72.3 99.3 93.3-32.3-21.5-51.5-48.6-51.6-78zm60.2 39.9S118.4 281 137.2 281c17.9 0 28.4-11.5 28.4-25.1 0-28-40.2-25.1-40.2-39.7 0-5.4 5.3-9.1 12.5-9.1 5.7 0 11.3 2.6 11.3 6.6l0 3.9 14.2 0 0-7.9c0-12.1-15.4-16.8-25.4-16.8-16.5 0-28.5 10.2-28.5 24.1 0 26.6 40.2 25.4 40.2 39.9 0 6.6-5.8 10.1-12.3 10.1-11.9 0-20.7-10.1-20.7-10.1l-8.8 10.9zm120.8-73.6l0 54.4c0 11.3-7.1 17.8-17.8 17.8s-17.8-6.5-17.8-17.7l0-54.5-15.8 0 0 55c0 18.9 13.4 31.9 33.7 31.9 20.1 0 33.4-13 33.4-31.9l0-55-15.7 0zm34.4 85.4l15.8 0 0-29.5 15.5 0c16 0 27.2-11.5 27.2-28.1s-11.2-27.8-27.2-27.8l-39.1 0 0 13.4 7.8 0 0 72zm15.8-43l0-29.1 12.9 0c8.7 0 13.7 5.7 13.7 14.4 0 8.9-5.1 14.7-14 14.7l-12.6 0zm57 43l15.8 0 0-29.5 15.5 0c16 0 27.2-11.5 27.2-28.1s-11.2-27.8-27.2-27.8l-39.1 0 0 13.4 7.8 0 0 72zm15.7-43l0-29.1 12.9 0c8.7 0 13.7 5.7 13.7 14.4 0 8.9-5 14.7-14 14.7l-12.6 0zm57.1 34.8c0 5.8 2.4 8.2 8.2 8.2l37.6 0c5.8 0 8.2-2.4 8.2-8.2l0-13-14.3 0 0 5.2c0 1.7-1 2.6-2.6 2.6l-18.6 0c-1.7 0-2.6-1-2.6-2.6l0-61.2c0-5.7-2.4-8.2-8.2-8.2l-15.4 0 0 13.4 5.2 0c1.7 0 2.6 1 2.6 2.6l0 61.2-.1 0zm63.4 0c0 5.8 2.4 8.2 8.2 8.2l38.7 0c5.7 0 8.2-2.4 8.2-8.2l0-13-14.3 0 0 5.2c0 1.7-1 2.6-2.6 2.6l-19.7 0c-1.7 0-2.6-1-2.6-2.6l0-20.3 27.7 0 0-13.4-27.7 0 0-22.4 19.2 0c1.7 0 2.6 1 2.6 2.6l0 5.2 14.2 0 0-13c0-5.7-2.5-8.2-8.2-8.2l-51.6 0 0 13.4 7.8 0 0 63.9 .1 0zm58.9-76l0 5.9 1.6 0 0-5.9 2.7 0 0-1.2-7 0 0 1.2 2.7 0zm5.7-1.2l0 7.1 1.5 0 0-5.7 2.3 5.7 1.3 0 2.3-5.7 0 5.7 1.5 0 0-7.1-2.3 0-2.1 5.1-2.1-5.1-2.4 0z"]
  };
  var faSquareTwitter = {
    prefix: 'fab',
    iconName: 'square-twitter',
    icon: [448, 512, ["twitter-square"], "f081", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zM351.3 199.3c0 86.7-66 186.6-186.6 186.6-37.2 0-71.7-10.8-100.7-29.4 5.3 .6 10.4 .8 15.8 .8 30.7 0 58.9-10.4 81.4-28-28.8-.6-53-19.5-61.3-45.5 10.1 1.5 19.2 1.5 29.6-1.2-30-6.1-52.5-32.5-52.5-64.4l0-.8c8.7 4.9 18.9 7.9 29.6 8.3-9-6-16.4-14.1-21.5-23.6s-7.8-20.2-7.7-31c0-12.2 3.2-23.4 8.9-33.1 32.3 39.8 80.8 65.8 135.2 68.6-9.3-44.5 24-80.6 64-80.6 18.9 0 35.9 7.9 47.9 20.7 14.8-2.8 29-8.3 41.6-15.8-4.9 15.2-15.2 28-28.8 36.1 13.2-1.4 26-5.1 37.8-10.2-8.9 13.1-20.1 24.7-32.9 34 .2 2.8 .2 5.7 .2 8.5z"]
  };
  var faTwitterSquare = faSquareTwitter;
  var faFontAwesome = {
    prefix: 'fab',
    iconName: 'font-awesome',
    icon: [512, 512, [62501, 62694, "font-awesome-flag", "font-awesome-logo-full"], "f2b4", "M91.7 96C106.3 86.8 116 70.5 116 52 116 23.3 92.7 0 64 0S12 23.3 12 52c0 16.7 7.8 31.5 20 41l0 419 64 0 0-64 373.6 0c14.6 0 26.4-11.8 26.4-26.4 0-3.7-.8-7.3-2.3-10.7L432 272 493.7 133.1c1.5-3.4 2.3-7 2.3-10.7 0-14.6-11.8-26.4-26.4-26.4L91.7 96z"]
  };
  var faFontAwesomeFlag = faFontAwesome;
  var faFontAwesomeLogoFull = faFontAwesome;
  var faWirsindhandwerk = {
    prefix: 'fab',
    iconName: 'wirsindhandwerk',
    icon: [448, 512, ["wsh"], "e2d0", "M18.9 479.8l83.4 0 0-112-83.4 47 0 65zm329 0l82.4 0 0-65-82.4-47 0 112zm0-448l0 219.8-123.6-72.4-121.7 72.4 0-219.8-83.7 0 0 360.8 205.4-122.3 206 122.3 0-360.8-82.3 0z"]
  };
  var faWsh = faWirsindhandwerk;
  var faConfluence = {
    prefix: 'fab',
    iconName: 'confluence',
    icon: [512, 512, [], "f78d", "M2.8 412.2c-4.5 7.6-2.1 17.5 5.5 22.2l105.9 65.2c7.7 4.7 17.7 2.4 22.4-5.3 0-.1 .1-.2 .1-.2 67.1-112.2 80.5-95.9 280.9-.7 8.1 3.9 17.8 .4 21.7-7.7 .1-.1 .1-.3 .2-.4l50.4-114.1c3.6-8.1-.1-17.6-8.1-21.3-22.2-10.4-66.2-31.2-105.9-50.3-247.9-120.6-330.8 45.7-373.1 112.6zM510.2 100.1c4.5-7.6 2.1-17.5-5.5-22.2L398.9 12.8c-7.5-5-17.6-3.1-22.6 4.4-.2 .3-.4 .6-.6 1-67.3 112.6-81.1 95.6-280.6 .9-8.1-3.9-17.8-.4-21.7 7.7-.1 .1-.1 .3-.2 .4L22.7 141.3c-3.6 8.1 .1 17.6 8.1 21.3 22.2 10.4 66.3 31.2 106 50.4 248 120 330.8-45.4 373.4-112.9z"]
  };
  var faDigg = {
    prefix: 'fab',
    iconName: 'digg',
    icon: [512, 512, [], "f1a6", "M81.7 172.3l-81.7 0 0 174.4 132.7 0 0-250.7-51 0 0 76.3zm0 133.4l-30.8 0 0-92.3 30.8 0 0 92.3zM378.9 172.3l0 174.4 81.8 0 0 28.5-81.8 0 0 40.8 133.1 0 0-243.7-133.1 0zm81.8 133.4l-30.8 0 0-92.3 30.8 0 0 92.3zm-235.6 41l82.1 0 0 28.5-82.1 0 0 40.8 133.3 0 0-243.7-133.3 0 0 174.4zm51.2-133.3l30.8 0 0 92.3-30.8 0 0-92.3zM153.3 96l51.3 0 0 51-51.3 0 0-51zm0 76.3l51.3 0 0 174.4-51.3 0 0-174.4z"]
  };
  var faThreads = {
    prefix: 'fab',
    iconName: 'threads',
    icon: [448, 512, [], "e618", "M331.5 235.7c2.2 .9 4.2 1.9 6.3 2.8 29.2 14.1 50.6 35.2 61.8 61.4 15.7 36.5 17.2 95.8-30.3 143.2-36.2 36.2-80.3 52.5-142.6 53l-.3 0c-70.2-.5-124.1-24.1-160.4-70.2-32.3-41-48.9-98.1-49.5-169.6l0-.5C17 184.3 33.6 127.2 65.9 86.2 102.2 40.1 156.2 16.5 226.4 16l.3 0c70.3 .5 124.9 24 162.3 69.9 18.4 22.7 32 50 40.6 81.7l-40.4 10.8c-7.1-25.8-17.8-47.8-32.2-65.4-29.2-35.8-73-54.2-130.5-54.6-57 .5-100.1 18.8-128.2 54.4-26.2 33.3-39.8 81.5-40.3 143.2 .5 61.7 14.1 109.9 40.3 143.3 28 35.6 71.2 53.9 128.2 54.4 51.4-.4 85.4-12.6 113.7-40.9 32.3-32.2 31.7-71.8 21.4-95.9-6.1-14.2-17.1-26-31.9-34.9-3.7 26.9-11.8 48.3-24.7 64.8-17.1 21.8-41.4 33.6-72.7 35.3-23.6 1.3-46.3-4.4-63.9-16-20.8-13.8-33-34.8-34.3-59.3-2.5-48.3 35.7-83 95.2-86.4 21.1-1.2 40.9-.3 59.2 2.8-2.4-14.8-7.3-26.6-14.6-35.2-10-11.7-25.6-17.7-46.2-17.8l-.7 0c-16.6 0-39 4.6-53.3 26.3l-34.4-23.6c19.2-29.1 50.3-45.1 87.8-45.1l.8 0c62.6 .4 99.9 39.5 103.7 107.7l-.2 .2 .1 0zm-156 68.8c1.3 25.1 28.4 36.8 54.6 35.3 25.6-1.4 54.6-11.4 59.5-73.2-13.2-2.9-27.8-4.4-43.4-4.4-4.8 0-9.6 .1-14.4 .4-42.9 2.4-57.2 23.2-56.2 41.8l-.1 .1z"]
  };
  var faWpressr = {
    prefix: 'fab',
    iconName: 'wpressr',
    icon: [512, 512, ["rendact"], "f3e4", "M256 8a248 248 0 1 0 0 496 248 248 0 1 0 0-496zM427.3 166.6c-15.2 34.5-30.4 69-45.6 103.5-2.4 5.5-6.9 8.2-13 8.2-23 0-46 .1-69 0-5.1 0-8.2 1.9-10.3 6.7-10.2 23.6-20.6 47-31 70.5-1.5 3.5-4.1 5.3-7.9 5.3-45.9 0-91.9 0-137.8 0-3.1 0-5.6-1.1-7.7-3.4-11.2-12.3-22.5-24.6-33.7-36.9-2.7-3-2.8-6.2-1.2-9.7 8.7-19.5 17.3-39.1 25.9-58.7 12.9-29.4 25.9-58.7 38.7-88.1 1.7-3.9 4.3-5.7 8.5-5.7 14.2 .1 28.5 0 42.7 0 6.2 0 9.2 4.8 6.7 10.6-13.6 30.8-27.2 61.6-40.7 92.3-5.7 13-11.4 26-17.1 39-3.9 9 7.1 12 11 5.6 .2-.4-1.4 4.2 30-67.7 1.4-3.1 3.4-4.4 6.8-4.4 15.2 .1 30.4 0 45.6 0 5.6 0 7.9 3.6 5.7 8.7-8.3 19-16.7 37.9-25 56.9-5 11.4 8.1 12.5 11.3 5.3 0-.1 27.9-63.3 32.2-73.2 2-4.6 5.4-6.5 10.3-6.5 26.4 .1 52.9 0 79.3 0 12.4 0 13.9-13.6 3.9-13.6-25.3 0-50.5 0-75.8 0-6.3 0-7.8-2.5-5.3-8.3 5.8-13.1 11.6-26.1 17.3-39.2 1.7-4 4.5-5.8 8.8-5.8 23.1 .1 26 0 130.8 0 6.1 0 8 2.8 5.6 8.3z"]
  };
  var faRendact = faWpressr;
  var faYoast = {
    prefix: 'fab',
    iconName: 'yoast',
    icon: [448, 512, [], "f2b1", "M91.3 76l186 0-7 18.9-179 0c-39.7 0-71.9 31.6-71.9 70.3l0 205.4c0 35.4 24.9 70.3 84 70.3l0 19.1-12.1 0C41.2 460 0 419.8 0 370.5L0 165.2C0 115.9 40.7 76 91.3 76zM320.4 20l66.5 0c-143.8 378.1-145.7 398.9-184.7 439.3-20.8 21.6-49.3 31.7-78.3 32.7l0-51.1c49.2-7.7 64.6-49.9 64.6-75.3 0-20.1 .6-12.6-82.1-223.2l61.4 0 50.4 156.6 102.2-279zM448 161.5l0 298.5-214 0c6.6-9.6 10.7-16.3 12.1-19.4l182.5 0 0-279.1c0-32.5-17.1-51.9-48.2-62.9L387.1 81c41.7 13.6 60.9 43.1 60.9 80.5z"]
  };
  var faNimblr = {
    prefix: 'fab',
    iconName: 'nimblr',
    icon: [384, 512, [], "f5a8", "M246.6 353.3a27 27 0 1 1 0-54 27 27 0 1 1 0 54zm-79.4-27a27.1 27.1 0 1 1 -54.3 0 27.1 27.1 0 1 1 54.3 0zM191.8 159C157 159 89.4 178.8 59.2 227L14 0 14 335.5C14 433.1 93.6 512 191.8 512S369.5 433 369.5 335.5 290.1 159 191.8 159zm0 308.1c-73.3 0-132.5-58.9-132.5-131.6s59.2-131.6 132.5-131.6 132.5 58.9 132.5 131.5-59.3 131.6-132.5 131.6l0 .1z"]
  };
  var faPixelfed = {
    prefix: 'fab',
    iconName: 'pixelfed',
    icon: [512, 512, [], "e7db", "M256 0a256 256 0 1 1 0 512 256 256 0 1 1 0-512zM235.7 311.9l47 0c44.2 0 80.1-34.9 80.1-78s-35.9-78-80.1-78l-67.8 0c-25.5 0-46.2 20.1-46.2 45l0 175.1 67-64.1z"]
  };
  var faYahoo = {
    prefix: 'fab',
    iconName: 'yahoo',
    icon: [512, 512, [], "f19e", "M223.8 141.1l-56.7 143.2-56-143.2-96.1 0 105.8 249.1-38.6 89.8 94.2 0 140.9-338.9-93.6 0zM329.2 276.9a58.2 58.2 0 1 0 0 116.4 58.2 58.2 0 1 0 0-116.4zM394.7 32l-93 223.5 104.8 0 92.6-223.5-104.4 0z"]
  };
  var faBluesky = {
    prefix: 'fab',
    iconName: 'bluesky',
    icon: [576, 512, [], "e671", "M407.8 294.7c-3.3-.4-6.7-.8-10-1.3 3.4 .4 6.7 .9 10 1.3zM288 227.1C261.9 176.4 190.9 81.9 124.9 35.3 61.6-9.4 37.5-1.7 21.6 5.5 3.3 13.8 0 41.9 0 58.4S9.1 194 15 213.9c19.5 65.7 89.1 87.9 153.2 80.7 3.3-.5 6.6-.9 10-1.4-3.3 .5-6.6 1-10 1.4-93.9 14-177.3 48.2-67.9 169.9 120.3 124.6 164.8-26.7 187.7-103.4 22.9 76.7 49.2 222.5 185.6 103.4 102.4-103.4 28.1-156-65.8-169.9-3.3-.4-6.7-.8-10-1.3 3.4 .4 6.7 .9 10 1.3 64.1 7.1 133.6-15.1 153.2-80.7 5.9-19.9 15-138.9 15-155.5s-3.3-44.7-21.6-52.9c-15.8-7.1-40-14.9-103.2 29.8-66.1 46.6-137.1 141.1-163.2 191.8z"]
  };
  var faScribd = {
    prefix: 'fab',
    iconName: 'scribd',
    icon: [384, 512, [], "f28a", "M42.6 252.7c-16.1-19-24.7-45.9-24.8-79.9 0-100.4 75.2-153.1 167.2-153.1 98.6-1.6 156.8 49 184.3 70.6l-50.5 72.1-37.3-24.6 26.9-38.6c-36.5-24-79.4-36.5-123-35.8-50.7-.8-111.7 27.2-111.7 76.2 0 18.7 11.2 20.7 28.6 15.6 23.3-5.3 41.9 .6 55.8 14 26.4 24.3 23.2 67.6-.7 91.9-29.2 29.5-85.2 27.3-114.8-8.4zm317.7 5.9c-15.5-18.8-38.9-29.4-63.2-28.6-38.1-2-71.1 28-70.5 67.2-.7 16.8 6 33 18.4 44.3 14.1 13.9 33 19.7 56.3 14.4 17.4-5.1 28.6-3.1 28.6 15.6 0 4.3-.5 8.5-1.4 12.7-16.7 40.9-59.5 64.4-121.4 64.4-51.9 .2-102.4-16.4-144.1-47.3l33.7-39.4-35.6-27.4-60.8 71.8 15.4 13.8c52.5 46.8 120.4 72.5 190.7 72.2 51.4 0 94.4-10.5 133.6-44.1 57.1-51.4 54.2-149.2 20.3-189.6z"]
  };
  var faCreativeCommonsPd = {
    prefix: 'fab',
    iconName: 'creative-commons-pd',
    icon: [512, 512, [], "f4ec", "M256 8a248 248 0 1 0 0 496 248 248 0 1 0 0-496zm0 449.5c-139.2 0-235.8-138-190.2-267.9l78.8 35.1c-2.1 10.5-3.3 21.5-3.3 32.9 0 99 73.9 126.9 120.4 126.9 22.9 0 53.5-6.7 79.4-29.5L305 311.1c-5.5 6.3-17.6 16.7-36.3 16.7-37.8 0-53.7-39.9-53.9-71.9 230.4 102.6 216.5 96.5 217.9 96.8-34.3 62.4-100.6 104.8-176.7 104.8zm194.2-150l-224-100c18.8-34 54.9-30.7 74.7-11l40.4-41.6c-27.1-23.3-58-27.5-78.1-27.5-47.4 0-80.9 20.5-100.7 51.6L87.6 145.6c36.1-54.9 98.1-91.2 168.5-91.2 111.1 0 201.5 90.4 201.5 201.5 0 18-2.4 35.4-6.8 52-.3-.1-.4-.2-.6-.4z"]
  };
  var faEarlybirds = {
    prefix: 'fab',
    iconName: 'earlybirds',
    icon: [512, 512, [], "f39a", "M329.3 47.5c1.2-13 21.3-14 36.6-8.7 .9 .3 26.2 9.7 19 15.2-27.9-7.4-56.4 18.2-55.6-6.5zm-201 6.9c30.7-8.1 62 20 61.1-7.1-1.3-14.2-23.4-15.3-40.2-9.6-1 .3-28.7 10.5-20.9 16.7zM335.5 160a16 16 0 1 0 0 32 16 16 0 1 0 0-32zm-159.7 0a16 16 0 1 0 0 32 16 16 0 1 0 0-32zM494.3 323.2c-9.9 24-40.7 11-63.9-1.2-13.5 69.1-58.1 111.4-126.3 124.2 .3 .9-2-.1 24 1 33.6 1.4 63.8-3.1 97.4-8-19.8-13.8-11.4-37.1-9.8-38.1 1.4-.9 14.7 1.7 21.6 11.5 8.6-12.5 28.4-14.8 30.2-13.6 1.6 1.1 6.6 20.9-6.9 34.6 4.7-.9 8.2-1.6 9.8-2.1 2.6-.8 17.7 11.3 3.1 13.3-14.3 2.3-22.6 5.1-47.1 10.8-45.9 10.7-85.9 11.8-117.7 12.8l1 11.6c3.8 18.1-23.4 24.3-27.6 6.2 .8 17.9-27.1 21.8-28.4-1l-.5 5.3c-.7 18.4-28.4 17.9-28.3-.6-7.5 13.5-28.1 6.8-26.4-8.5l1.2-12.4c-36.7 .9-59.7 3.1-61.8 3.1-20.9 0-20.9-31.6 0-31.6 2.4 0 27.7 1.3 63.2 2.8-61.1-15.5-103.7-55-114.9-118.2-25 12.8-57.5 26.8-68.2 .8-10.5-25.4 21.5-42.6 66.8-73.4 .7-6.6 1.6-13.3 2.7-19.8-14.4-19.6-11.6-36.3-16.1-60.4-16.8 2.4-23.2-9.1-23.6-23.1 .3-7.3 2.1-14.9 2.4-15.4 1.1-1.8 10.1-2 12.7-2.6 6-31.7 50.6-33.2 90.9-34.5 19.7-21.8 45.2-41.5 80.9-48.3-15.3-19.4-3.4-39.9-2.4-40.4 1.7-.8 21.2 4.3 26.3 23.2 5.2-8.8 18.3-11.4 19.6-10.7 1.1 .6 6.4 15-4.9 25.9 40.3 3.5 72.2 24.7 96 50.7 36.1 1.5 71.8 5.9 77.1 34 2.7 .6 11.6 .8 12.7 2.6 .3 .5 2.1 8.1 2.4 15.4-.5 13.9-6.8 25.4-23.6 23.1-3.2 17.3-2.7 32.9-8.7 47.7 2.4 11.7 4 23.8 4.8 36.4 37 25.4 70.3 42.5 60.3 66.9zM223.5 159.9c.9-44-37.9-42.2-78.6-40.3-21.7 1-38.9 1.9-45.5 13.9-11.4 20.9 5.9 92.9 23.2 101.2 9.8 4.7 73.4 7.9 86.3-7.1 8.2-9.4 15-49.4 14.6-67.7zm52 58.3c-4.3-12.4-6-30.1-15.3-32.7-2-.5-9-.5-11 0-10 2.8-10.8 22.1-17 37.2 15.4 0 19.3 9.7 23.7 9.7 4.3 0 6.3-11.3 19.6-14.2zm135.7-84.7c-6.6-12.1-24.8-12.9-46.5-13.9-40.2-1.9-78.2-3.8-77.3 40.3-.5 18.3 5 58.3 13.2 67.8 13 14.9 76.6 11.8 86.3 7.1 15.8-7.6 36.5-78.9 24.3-101.3z"]
  };
  var faSquareOdnoklassniki = {
    prefix: 'fab',
    iconName: 'square-odnoklassniki',
    icon: [448, 512, ["odnoklassniki-square"], "f264", "M224 137.1c-5.4-.3-10.8 .6-15.9 2.4s-9.7 4.8-13.6 8.5-7 8.2-9.2 13.2-3.2 10.3-3.2 15.7 1.1 10.8 3.2 15.7 5.3 9.5 9.2 13.2 8.6 6.6 13.6 8.5 10.5 2.7 15.9 2.4c5.4 .3 10.8-.6 15.9-2.4s9.7-4.8 13.6-8.5 7-8.2 9.2-13.2 3.2-10.3 3.2-15.7-1.1-10.8-3.2-15.7-5.3-9.5-9.2-13.2-8.6-6.6-13.6-8.5-10.5-2.7-15.9-2.4zM384 32L64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64zM224 258a81 81 0 1 1 0-162.1 81 81 0 1 1 0 162.1zm59.3 6.2c16.8-13.2 29.5-5.5 34.1 3.6 7.8 16-1.1 23.7-21.5 37-17.1 10.9-40.7 15.2-56.2 16.8l13 12.9 47.7 47.7c17.4 17.9-11 45.8-28.6 28.6-12-12.2-29.5-29.7-47.7-47.9l-47.7 47.9c-17.7 17.2-46-11-28.4-28.6 3.7-3.7 7.9-7.9 12.5-12.5 10.4-10.4 22.6-22.7 35.2-35.2l12.9-12.9c-15.4-1.6-39.3-5.7-56.6-16.8-20.3-13.3-29.3-20.9-21.4-37 4.6-9.1 17.3-16.8 34.1-3.6 0 0 22.7 18 59.3 18s59.3-18 59.3-18z"]
  };
  var faOdnoklassnikiSquare = faSquareOdnoklassniki;
  var faMarkdown = {
    prefix: 'fab',
    iconName: 'markdown',
    icon: [640, 512, [], "f60f", "M593.8 59.1l-547.6 0C20.7 59.1 0 79.8 0 105.2L0 406.7c0 25.5 20.7 46.2 46.2 46.2l547.7 0c25.5 0 46.2-20.7 46.1-46.1l0-301.6c0-25.4-20.7-46.1-46.2-46.1zM338.5 360.6l-61.5 0 0-120-61.5 76.9-61.5-76.9 0 120-61.7 0 0-209.2 61.5 0 61.5 76.9 61.5-76.9 61.5 0 0 209.2 .2 0zm135.3 3.1l-92.3-107.7 61.5 0 0-104.6 61.5 0 0 104.6 61.5 0-92.2 107.7z"]
  };
  var faTypo3 = {
    prefix: 'fab',
    iconName: 'typo3',
    icon: [448, 512, [], "f42b", "M178.7 78.4c0-24.7 5.4-32.4 13.9-39.4-69.5 8.5-149.3 34-176.3 66.4-5.4 7.7-9.3 20.8-9.3 37.1 0 103.5 106.8 337.5 184.1 337.5 36.3 0 97.3-59.5 146.7-139-7 2.3-11.6 2.3-18.5 2.3-57.2 0-140.6-198.5-140.6-264.9zM301.5 32c-30.1 0-41.7 5.4-41.7 36.3 0 66.4 53.8 198.5 101.7 198.5 26.3 0 78.8-99.7 78.8-182.3 0-40.9-67-52.5-138.8-52.5z"]
  };
  var faJoomla = {
    prefix: 'fab',
    iconName: 'joomla',
    icon: [448, 512, [], "f1aa", "M.6 92.1c0-33.3 26.8-60.1 59.8-60.1 30 0 54.5 21.9 59.2 50.2 32.6-7.6 67.1 .6 96.5 30l-44.3 44.3c-20.5-20.5-42.6-16.3-55.4-3.5-14.3 14.3-14.3 37.9 0 52.2l99.5 99.5-44 44.3c-87.7-87.2-49.7-49.7-99.8-99.7-26.8-26.5-35-64.8-24.8-98.9-26.9-5.8-46.7-29.7-46.7-58.3zM130.1 208.5l44.3 44.3c10-10 89.7-89.7 99.7-99.8 14.3-14.3 37.6-14.3 51.9 0 12.8 12.8 17 35-3.5 55.4l44 44.3c31.2-31.2 38.5-67.6 28.9-101.2 29.2-4.1 51.9-29.2 51.9-59.5 0-33.2-26.8-60.1-59.8-60.1-30.3 0-55.4 22.5-59.5 51.6-33.8-9.9-71.7-1.5-98.3 25.1-18.3 19.1-71.1 71.5-99.6 99.9zM396.4 360.7c8.2-32.7-.9-68.5-26.3-93.9-11.8-12.2 5 4.7-99.5-99.7l-44.3 44.3 99.7 99.7c14.3 14.3 14.3 37.6 0 51.9-12.8 12.8-35 17-55.4-3.5l-44 44.3c27.6 30.2 68 38.8 102.7 28 5.5 27.4 29.7 48.1 58.9 48.1 33 0 59.8-26.8 59.8-60.1 0-30.2-22.5-55-51.6-59.1zm-84.3-53.1l-44-44.3c-87 86.4-50.4 50.4-99.7 99.8-14.3 14.3-37.6 14.3-51.9 0-13.1-13.4-16.9-35.3 3.2-55.4l-44-44.3c-30.2 30.2-38 65.2-29.5 98.3-26.7 6-46.2 29.9-46.2 58.2 0 33.3 26.8 60.1 59.8 60.1 28.6 0 52.5-19.8 58.6-46.7 32.7 8.2 68.5-.6 94.2-26 32.1-32 12.2-12.4 99.5-99.7z"]
  };
  var faWeixin = {
    prefix: 'fab',
    iconName: 'weixin',
    icon: [576, 512, [], "f1d7", "M385.2 167.6c6.4 0 12.6 .3 18.8 1.1-16.6-78.4-100.7-136.7-196.3-136.7-107.2 0-194.7 72.8-194.7 165.4 0 53.4 29.3 97.5 77.9 131.6l-19.3 58.6 68-34.1c24.4 4.8 43.8 9.7 68.2 9.7 6.2 0 12.1-.3 18.3-.8-4-12.9-6.2-26.6-6.2-40.8-.1-84.9 72.9-154 165.3-154zM280.7 114.7c14.5 0 24.2 9.7 24.2 24.4 0 14.5-9.7 24.2-24.2 24.2-14.8 0-29.3-9.7-29.3-24.2 .1-14.7 14.6-24.4 29.3-24.4zM144.3 163.3c-14.5 0-29.3-9.7-29.3-24.2 0-14.8 14.8-24.4 29.3-24.4 14.8 0 24.4 9.7 24.4 24.4 0 14.6-9.6 24.2-24.4 24.2zM563 319.4c0-77.9-77.9-141.3-165.4-141.3-92.7 0-165.4 63.4-165.4 141.3S305 460.7 397.6 460.7c19.3 0 38.9-5.1 58.6-9.9l53.4 29.3-14.8-48.6C534 402.1 563 363.2 563 319.4zM343.9 294.9c-9.7 0-19.3-9.7-19.3-19.6 0-9.7 9.7-19.3 19.3-19.3 14.8 0 24.4 9.7 24.4 19.3 0 10-9.7 19.6-24.4 19.6zm107.1 0c-9.7 0-19.3-9.7-19.3-19.6 0-9.7 9.7-19.3 19.3-19.3 14.5 0 24.4 9.7 24.4 19.3 .1 10-9.9 19.6-24.4 19.6z"]
  };
  var faGrunt = {
    prefix: 'fab',
    iconName: 'grunt',
    icon: [384, 512, [], "f3ad", "M61.6 189.3c-1.1 10 5.2 19.1 5.2 19.1 .7-7.5 2.2-12.8 4-16.6 .4 10.3 3.2 23.5 12.8 34.1 6.9 7.6 35.6 23.3 54.9 6.1 1 2.4 2.1 5.3 3 8.5 2.9 10.3-2.7 25.3-2.7 25.3s15.1-17.1 13.9-32.5c10.8-.5 21.4-8.4 21.1-19.5 0 0-18.9 10.4-35.5-8.8-9.7-11.2-40.9-42-83.1-31.8 4.3 1 8.9 2.4 13.5 4.1l-.1 0c-4.2 2-6.5 7.1-7 12zm28.3-1.8c19.5 11 37.4 25.7 44.9 37-5.7 3.3-21.7 10.4-38-1.7-10.3-7.6-9.8-26.2-6.9-35.3zM232 233.3c-1.2 15.5 13.9 32.5 13.9 32.5s-5.6-15-2.7-25.3c.9-3.2 2-6 3-8.5 19.3 17.3 48 1.5 54.8-6.1 9.6-10.6 12.3-23.8 12.8-34.1 1.8 3.8 3.4 9.1 4 16.6 0 0 6.4-9.1 5.2-19.1-.6-5-2.9-10-7-11.8l-.1 0c4.6-1.8 9.2-3.2 13.5-4.1-42.3-10.2-73.4 20.6-83.1 31.8-16.7 19.2-35.5 8.8-35.5 8.8-.2 10.9 10.4 18.9 21.2 19.3zm62.7-45.8c3 9.1 3.4 27.7-7 35.4-16.3 12.1-32.2 5-37.9 1.6 7.5-11.4 25.4-26 44.9-37zm-134.4 231l-29.4 0c-5.5 0-8.2 1.6-9.5 2.9-1.9 2-2.2 4.7-.9 8.1 3.5 9.1 11.4 16.5 13.7 18.6 3.1 2.7 7.5 4.3 11.8 4.3 4.4 0 8.3-1.7 11-4.6 7.5-8.2 11.9-17.1 13-19.8 .6-1.5 1.3-4.5-.9-6.8-1.8-1.8-4.7-2.7-8.8-2.7zM349.5 317.3c-2.4 17.9-13 33.8-24.6 43.7-3.1-22.7-3.7-55.5-3.7-62.4 0-14.7 9.5-24.5 12.2-26.1 2.5-1.5 5.4-3 8.3-4.6 18-9.6 40.4-21.6 40.4-43.7 0-16.2-9.3-23.2-15.4-27.8-.8-.6-1.5-1.1-2.2-1.7-2.1-1.7-3.7-3-4.3-4.4-4.4-9.8-3.6-34.2-1.7-37.6 .6-.6 16.7-20.9 11.8-39.2-2-7.4-6.9-13.3-14.1-17-5.3-2.7-11.9-4.2-19.5-4.5-.1-2-.5-3.9-.9-5.9-.6-2.6-1.1-5.3-.9-8.1 .4-4.7 .8-9 2.2-11.3 8.4-13.3 28.8-17.6 29-17.6l12.3-2.4-8.1-9.5c-.1-.2-17.3-17.5-46.3-17.5-7.9 0-16 1.3-24.1 3.9-24.2 7.8-42.9 30.5-49.4 39.3-3.1-1-6.3-1.9-9.6-2.7-4.2-15.8 9-38.5 9-38.5s-13.6-3-33.7 15.2c-2.6-6.5-8.1-20.5-1.8-37.2-29.5 10.4-36.9 26.3-39.1 40.7-7.6-5.4-6.7-23.1-7.2-27.6-7.5 .9-29.2 21.9-28.2 48.3-2 .5-3.9 1.1-5.9 1.7-6.5-8.8-25.1-31.5-49.4-39.3-7.9-2.2-16-3.5-23.9-3.5-29 0-46.1 17.3-46.3 17.5l-8.1 9.4 12.3 2.4c.2 0 20.6 4.3 29 17.6 1.4 2.2 1.8 6.6 2.2 11.3 .2 2.8-.4 5.5-.9 8.1-.4 1.9-.8 3.9-.9 5.9-7.7 .3-14.2 1.8-19.5 4.5-7.2 3.7-12.1 9.6-14.1 17-5 18.2 11.2 38.5 11.8 39.2 1.9 3.4 2.7 27.8-1.7 37.6-.6 1.4-2.2 2.7-4.3 4.4-.7 .5-1.4 1.1-2.2 1.7-6.1 4.6-15.4 11.7-15.4 27.8 0 22.1 22.4 34.1 40.4 43.7 3 1.6 5.8 3.1 8.3 4.6 2.7 1.6 12.2 11.4 12.2 26.1 0 6.9-.6 39.7-3.7 62.4-11.6-9.9-22.2-25.9-24.6-43.8 0 0-29.2 22.6-20.6 70.8 5.2 29.5 23.2 46.1 47 54.7 8.8 19.1 29.4 45.7 67.3 49.6 14.4 11.8 34.4 19.5 63.6 19.5l.2 0c29.1 0 49.1-7.7 63.6-19.5 37.9-3.9 58.5-30.5 67.3-49.6 23.8-8.7 41.7-25.2 47-54.7 8.2-48.4-21.1-70.9-21.1-70.9zM306 37.7c5.6-1.8 11.6-2.7 17.7-2.7 11 0 19.9 3 24.7 5-3.1 1.4-6.4 3.2-9.7 5.3-2.4-.4-5.6-.8-9.2-.8-10.5 0-20.5 3.1-28.7 8.9-12.3 8.7-18 16.9-20.7 22.4-2.2-1.3-4.5-2.5-7.1-3.7-1.6-.8-3.1-1.5-4.7-2.2 6.1-9.1 19.9-26.5 37.7-32.2zm21 18.2c-.8 1-1.6 2.1-2.3 3.2-3.3 5.2-3.9 11.6-4.4 17.8-.5 6.4-1.1 12.5-4.4 17-4.2 .8-8.1 1.7-11.5 2.7-2.3-3.1-5.6-7-10.5-11.2 1.4-4.8 5.5-16.1 13.5-22.5 5.6-4.3 12.2-6.7 19.6-7zM45.9 45.3c-3.3-2.2-6.6-4-9.7-5.3 4.8-2 13.7-5 24.7-5 6.1 0 12 .9 17.7 2.7 17.8 5.8 31.6 23.2 37.7 32.1-1.6 .7-3.2 1.4-4.8 2.2-2.5 1.2-4.9 2.5-7.1 3.7-2.6-5.4-8.3-13.7-20.7-22.4-8.3-5.8-18.2-8.9-28.8-8.9-3.4 .1-6.6 .5-9 .9zM90.6 85.4c-4.9 4.2-8.3 8-10.5 11.2-3.4-.9-7.3-1.9-11.5-2.7-3.3-4.4-3.8-10.5-4.3-16.9-.5-6.2-1.1-12.6-4.4-17.8-.7-1.1-1.5-2.2-2.3-3.2 7.4 .3 14 2.6 19.5 7 8 6.3 12.1 17.6 13.5 22.4zM58.4 259.9c-2.7-1.6-5.6-3.1-8.4-4.6-14.9-8-30.2-16.3-30.2-30.5 0-11.1 4.3-14.6 8.9-18.2l.5-.4c.7-.6 1.4-1.2 2.2-1.8-.9 7.2-1.9 13.3-2.7 14.9 0 0 12.1-15 15.7-44.3 1.4-11.5-1.1-34.3-5.1-43 .2 4.9 0 9.8-.3 14.4-.4-.8-.8-1.6-1.3-2.2-3.2-4-11.8-17.5-9.4-26.6 .9-3.5 3.1-6 6.7-7.8 3.8-1.9 8.8-2.9 15.1-2.9 12.3 0 25.9 3.7 32.9 6 25.1 8 55.4 30.9 64.1 37.7 .2 .2 .4 .3 .4 .3l5.6 3.9-3.5-5.8c-.2-.3-19.1-31.4-53.2-46.5 2-2.9 7.4-8.1 21.6-15.1 21.4-10.5 46.5-15.8 74.3-15.8 27.9 0 52.9 5.3 74.3 15.8 14.2 6.9 19.6 12.2 21.6 15.1-34 15.1-52.9 46.2-53.1 46.5l-3.5 5.8 5.6-3.9s.2-.1 .4-.3c8.7-6.8 39-29.8 64.1-37.7 7-2.2 20.6-6 32.9-6 6.3 0 11.3 1 15.1 2.9 3.5 1.8 5.7 4.4 6.7 7.8 2.5 9.1-6.1 22.6-9.4 26.6-.5 .6-.9 1.3-1.3 2.2-.3-4.6-.5-9.5-.3-14.4-4 8.8-6.5 31.5-5.1 43 3.6 29.3 15.7 44.3 15.7 44.3-.8-1.6-1.8-7.7-2.7-14.9 .7 .6 1.5 1.2 2.2 1.8l.5 .4c4.6 3.7 8.9 7.1 8.9 18.2 0 14.2-15.4 22.5-30.2 30.5-2.9 1.5-5.7 3.1-8.4 4.6-8.7 5-18 16.7-19.1 34.2-.9 14.6 .9 49.9 3.4 75.9-12.4 4.8-26.7 6.4-39.7 6.8-2-4.1-3.9-8.5-5.5-13.1-.7-2-19.6-51.1-26.4-62.2 5.5 39 17.5 73.7 23.5 89.6-3.5-.5-7.3-.7-11.7-.7l-117 0c-4.4 0-8.3 .3-11.7 .7 6-15.9 18.1-50.6 23.5-89.6-6.8 11.2-25.7 60.3-26.4 62.2-1.6 4.6-3.5 9-5.5 13.1-13-.4-27.2-2-39.7-6.8 2.5-26 4.3-61.2 3.4-75.9-.9-17.4-10.3-29.2-19-34.2zM35.1 404.6c-12.1-20-8.7-54.1-3.7-59.1 10.9 34.4 47.2 44.3 74.4 45.4-2.7 4.2-5.2 7.6-7 10l-1.4 1.4c-7.2 7.8-8.6 18.5-4.1 31.8-22.7-.1-46.3-9.8-58.2-29.5zm45.7 43.5c6 1.1 12.2 1.9 18.6 2.4 3.5 8 7.4 15.9 12.3 23.1-14.4-5.9-24.4-16-30.9-25.5zm111.5 50.1c-60.6-.1-78.3-45.8-84.9-64.7-3.7-10.5-3.4-18.2 .9-23.1 2.9-3.3 9.5-7.2 24.6-7.2l118.8 0c15.1 0 21.8 3.9 24.6 7.2 4.2 4.8 4.5 12.6 .9 23.1-6.6 18.8-24.3 64.6-84.9 64.7zm80.6-24.6c4.9-7.2 8.8-15.1 12.3-23.1 6.4-.5 12.6-1.3 18.6-2.4-6.5 9.5-16.5 19.6-30.9 25.5zm76.6-69c-12 19.7-35.6 29.3-58.1 29.7 4.5-13.3 3.1-24.1-4.1-31.8-.4-.5-.9-1-1.4-1.5-1.8-2.4-4.3-5.8-7-10 27.2-1.2 63.5-11 74.4-45.4 5 5 8.4 39.1-3.8 59zM192.2 187.7l.2 0c12.7-.1 27.2-17.8 27.2-17.8-9.9 6-18.8 8.1-27.3 8.3-8.5-.2-17.4-2.3-27.3-8.3 0 0 14.5 17.6 27.2 17.8zm61.7 230.7l-29.4 0c-4.2 0-7.2 .9-8.9 2.7-2.2 2.3-1.5 5.2-.9 6.7 1 2.6 5.5 11.3 13 19.3 2.7 2.9 6.6 4.5 11 4.5s8.7-1.6 11.8-4.2c2.3-2 10.2-9.2 13.7-18.1 1.3-3.3 1-6-.9-7.9-1.3-1.3-4-2.9-9.4-3z"]
  };
  var faRockrms = {
    prefix: 'fab',
    iconName: 'rockrms',
    icon: [512, 512, [], "f3e9", "M256 8a248 248 0 1 0 0 496 248 248 0 1 0 0-496zM413.4 427.5l-90 0-112-131.3c-17.9-20.4-3.9-56.1 26.6-56.1l75.3 0-84.6-99.3-84.3 98.9-90 0 147.1-172.5c14.4-18.4 41.3-17.3 54.5 0L413.7 252.3c19 22.8 2 57.2-27.6 56.1-.6 0-74.2 .2-74.2 .2L413.4 427.5z"]
  };
  var faUnsplash = {
    prefix: 'fab',
    iconName: 'unsplash',
    icon: [448, 512, [], "e07c", "M448 230.2l0 249.8-448 0 0-249.8 141.1 0 0 124.9 165.7 0 0-124.9 141.1 0zM306.9 32l-165.7 0 0 124.9 165.7 0 0-124.9z"]
  };
  var faSquareInstagram = {
    prefix: 'fab',
    iconName: 'square-instagram',
    icon: [448, 512, ["instagram-square"], "e055", "M194.4 211.7a53.3 53.3 0 1 0 59.2 88.6 53.3 53.3 0 1 0 -59.2-88.6zm142.3-68.4c-5.2-5.2-11.5-9.3-18.4-12-18.1-7.1-57.6-6.8-83.1-6.5-4.1 0-7.9 .1-11.2 .1s-7.2 0-11.4-.1c-25.5-.3-64.8-.7-82.9 6.5-6.9 2.7-13.1 6.8-18.4 12s-9.3 11.5-12 18.4c-7.1 18.1-6.7 57.7-6.5 83.2 0 4.1 .1 7.9 .1 11.1s0 7-.1 11.1c-.2 25.5-.6 65.1 6.5 83.2 2.7 6.9 6.8 13.1 12 18.4s11.5 9.3 18.4 12c18.1 7.1 57.6 6.8 83.1 6.5 4.1 0 7.9-.1 11.2-.1s7.2 0 11.4 .1c25.5 .3 64.8 .7 82.9-6.5 6.9-2.7 13.1-6.8 18.4-12s9.3-11.5 12-18.4c7.2-18 6.8-57.4 6.5-83 0-4.2-.1-8.1-.1-11.4s0-7.1 .1-11.4c.3-25.5 .7-64.9-6.5-83-2.7-6.9-6.8-13.1-12-18.4l0 .2zm-67.1 44.5c18.1 12.1 30.6 30.9 34.9 52.2s-.2 43.5-12.3 61.6c-6 9-13.7 16.6-22.6 22.6s-19 10.1-29.6 12.2c-21.3 4.2-43.5-.2-61.6-12.3s-30.6-30.9-34.9-52.2 .2-43.5 12.2-61.6 30.9-30.6 52.2-34.9 43.5 .2 61.6 12.2l.1 0zm29.2-1.3c-3.1-2.1-5.6-5.1-7.1-8.6s-1.8-7.3-1.1-11.1 2.6-7.1 5.2-9.8 6.1-4.5 9.8-5.2 7.6-.4 11.1 1.1 6.5 3.9 8.6 7 3.2 6.8 3.2 10.6c0 2.5-.5 5-1.4 7.3s-2.4 4.4-4.1 6.2-3.9 3.2-6.2 4.2-4.8 1.5-7.3 1.5c-3.8 0-7.5-1.1-10.6-3.2l-.1 0zM448 96c0-35.3-28.7-64-64-64L64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320zM357 389c-18.7 18.7-41.4 24.6-67 25.9-26.4 1.5-105.6 1.5-132 0-25.6-1.3-48.3-7.2-67-25.9s-24.6-41.4-25.8-67c-1.5-26.4-1.5-105.6 0-132 1.3-25.6 7.1-48.3 25.8-67s41.5-24.6 67-25.8c26.4-1.5 105.6-1.5 132 0 25.6 1.3 48.3 7.1 67 25.8s24.6 41.4 25.8 67c1.5 26.3 1.5 105.4 0 131.9-1.3 25.6-7.1 48.3-25.8 67l0 .1z"]
  };
  var faInstagramSquare = faSquareInstagram;
  var faFirstOrderAlt = {
    prefix: 'fab',
    iconName: 'first-order-alt',
    icon: [512, 512, [], "f50a", "M256 8a248 248 0 1 0 0 496 248 248 0 1 0 0-496zm0 7.8a240.2 240.2 0 1 1 0 480.4 240.2 240.2 0 1 1 0-480.4zm0 20.5a219.7 219.7 0 1 0 0 439.4 219.7 219.7 0 1 0 0-439.4zm0 8.2a211.5 211.5 0 1 1 0 423 211.5 211.5 0 1 1 0-423zm186.2 260c-4.4 17.1-11.2 33.5-20.1 48.7l-74.1-35.9 61.5 54.8c-10.6 14.1-23.2 26.6-37.2 37.3l-54.8-61.6 35.9 74.3c-15.2 9-31.6 15.8-48.6 20.2l-27.3-78.5 4.8 82.9c-8.6 1.2-17.4 1.8-26.3 1.8s-17.7-.6-26.3-1.8l4.8-82.5-27.2 78c-17.1-4.5-33.4-11.3-48.7-20.2l35.9-74.3-54.9 61.6c-14-10.7-26.6-23.2-37.2-37.3l61.6-54.9-74.3 35.9C80.7 338 74 321.7 69.5 304.6l77.8-27.1-82.2 4.8c-1.2-8.6-1.8-17.3-1.8-26.2 0-9 .6-17.8 1.8-26.5l82.4 4.8-77.9-27.2c4.5-17.1 11.3-33.5 20.2-48.7l74.2 35.9-61.5-54.9c10.7-14 23.2-26.6 37.3-37.2l54.8 61.5-35.8-74.2c15.2-8.9 31.6-15.7 48.6-20.1l26.9 77.2-4.7-81.6c8.6-1.2 17.4-1.8 26.3-1.8s17.7 .6 26.3 1.8l-4.7 82.2 27-77.8c17.3 4.5 33.6 11.4 48.6 20.2l-35.8 74.1 54.7-61.5c14.1 10.7 26.6 23.2 37.2 37.2l-61.4 54.8 74.1-35.9c8.9 15.2 15.7 31.6 20.2 48.6l-77.8 27.1 82.2-4.7c1.2 8.7 1.8 17.5 1.8 26.5 0 8.9-.6 17.6-1.8 26.2l-82.1-4.7 77.7 27.1z"]
  };
  var faFulcrum = {
    prefix: 'fab',
    iconName: 'fulcrum',
    icon: [256, 512, [], "f50b", "M63.8 164.1L28.4 207.7-7 164.1 28.4 120.6 63.8 164.1zM112.2 0l-20.5 198.2-51 57.8 51 57.8 20.5 198.2 0-211.1-41.1-44.9 41.1-44.9 0-211.1zm79.7 164.1l35.4 43.6 35.4-43.6-35.4-43.5-35.4 43.5zm-48.5 47l41.1 44.9-41.1 44.9 0 211.1 20.6-198.2 51-57.8-51-57.8-20.6-198.2 0 211.1z"]
  };
  var faBraveReverse = {
    prefix: 'fab',
    iconName: 'brave-reverse',
    icon: [448, 512, [], "e63d", "M298.5 0c3 0 5.8 1.3 7.8 3.6l38.1 44c.5-.1 1-.2 1.5-.3 9.2-1.6 18.6-2.2 27.7-1.2 11.6 1.4 21.5 5.4 28.9 12.9 7.7 7.8 15.4 15.8 22.6 23.6 2.5 2.7 4.9 5.2 6.9 7.4 .7 .8 1.4 1.5 1.9 2 3.4 3.7 4.2 8.1 2.7 11.9l-9.8 24.6 13.1 38.1c.7 2 .8 4.1 .2 6.2-.1 .4-.1 .4-.5 2.1l-1.5 5.8c-1.6 6.3-3.5 13.3-5.4 20.9-5.6 21.6-11.2 43.2-16.4 63.4-12.9 49.9-21.4 82.7-23.4 90.9-11.1 44.5-19.9 60-48.3 80.3-24.9 17.8-76.8 53.6-86.8 60-1 .6-2 1.3-3.4 2.3-.5 .4-3.2 2.2-3.9 2.7-4.9 3.3-8.3 5.5-12.1 7.3-4.7 2.2-9.3 3.5-13.9 3.5s-9.1-1.2-13.9-3.5c-3.7-1.8-7.2-3.9-12.1-7.3-.8-.5-3.4-2.4-3.9-2.7-1.4-1-2.5-1.7-3.4-2.3-10-6.4-61.9-42.1-86.8-60-28.4-20.4-37.2-35.8-48.3-80.3-2-8.2-10.5-41-23.3-90.5-5.3-20.6-10.9-42.2-16.5-63.8-2-7.6-3.8-14.6-5.4-20.9l-1.5-5.8-.5-2.1c-.5-2-.4-4.2 .2-6.2l13.1-38.1-9.9-24.5c-1.5-3.8-.7-8.2 2-11.2 1.2-1.3 1.8-2 2.6-2.8 2-2.2 4.4-4.7 6.9-7.4 7.3-7.7 15-15.7 22.7-23.5 7.4-7.5 17.3-11.6 28.9-12.9 9.1-1.1 18.5-.5 27.7 1.2 .5 .1 1 .2 1.5 .3l38.1-44c2-2.4 4.8-3.7 7.8-3.7l148 0zm-4.7 21.1l-138.6 0-39.1 45.1c-2.6 3-6.7 4.3-10.6 3.2-.2-.1-.7-.2-1.5-.4-1.3-.3-2.9-.6-4.5-.9-7.4-1.3-14.9-1.8-21.7-1-7.3 .9-13 3.2-16.6 6.9-7.6 7.7-15.2 15.6-22.3 23.3-1.7 1.8-3.3 3.5-4.8 5.1l8.8 22c1 2.4 1 5 .2 7.5L29.7 170.6c.4 1.4 .5 1.9 1.2 4.8 1.6 6.3 3.5 13.3 5.4 20.9 5.6 21.6 11.2 43.2 16.4 63.4 12.9 50 21.4 82.8 23.4 91 10.1 40.1 16.4 51.3 40.2 68.3 24.6 17.6 76.3 53.2 85.9 59.3 1.2 .8 2.5 1.6 4 2.7 .6 .4 3.2 2.2 3.9 2.7 4 2.8 6.7 4.4 9.2 5.6 2.2 1 3.9 1.5 5.1 1.5s2.9-.5 5.1-1.5c2.5-1.2 5.2-2.8 9.2-5.6 .7-.5 3.3-2.3 3.9-2.7 1.6-1.1 2.8-1.9 4-2.7 9.6-6.1 61.3-41.7 85.9-59.3 23.8-17.1 30.2-28.2 40.1-68.3 2.1-8.3 10.5-41.1 23.3-90.7 5.3-20.6 10.9-42.2 16.5-63.8 2-7.6 3.8-14.6 5.4-20.9 .7-2.9 .9-3.4 1.2-4.8l-13.3-38.8c-.8-2.4-.8-5.1 .2-7.5l8.8-22c-1.5-1.6-3.1-3.3-4.8-5.1-7.2-7.6-14.7-15.5-22.3-23.3-3.7-3.7-9.3-6-16.6-6.9-6.8-.8-14.4-.3-21.7 1-1.7 .3-3.2 .6-4.5 .9-.8 .2-1.3 .3-1.5 .4-3.8 1.1-7.9-.2-10.6-3.2L293.8 21.1zM224.5 316c2.8 0 20.9 6.5 35.4 14.1s25 13 28.3 15.2 1.3 6.2-1.7 8.4-44.1 34.6-48.1 38.2-9.8 9.5-13.8 9.5-9.8-5.9-13.8-9.5-45.1-36-48.1-38.2-5.1-6.2-1.7-8.4 13.9-7.5 28.3-15.2 32.5-14.1 35.4-14.1l-.2 0zm.1-230.7c.7 0 8.8 .2 20.5 4.2 12.3 4.2 25.7 9.4 31.9 9.4s51.9-8.9 51.9-8.9 54.2 66.7 54.2 81-6.8 18-13.7 25.4-36.8 39.8-40.7 43.9-11.9 10.5-7.1 21.8 11.7 25.8 3.9 40.4-21 24.4-29.4 22.8-28.4-12.2-35.7-17.1-30.5-24.3-30.5-31.8 24-20.8 28.4-23.9 24.7-14.8 25.1-19.4 .3-6-5.7-17.4-16.7-26.7-14.9-36.8 19.1-15.4 31.5-20.2 36.2-13.7 39.2-15.1 2.2-2.7-6.8-3.6-34.6-4.3-46.1-1.1-31.2 8.2-32.8 10.9-3 2.7-1.4 11.8 10.1 52.8 10.9 60.6 2.4 12.9-5.8 14.8-22.1 5.2-26.8 5.2-18.6-3.3-26.8-5.2-6.6-7-5.8-14.8 9.3-51.5 10.9-60.6 .2-9.2-1.4-11.8-21.3-7.6-32.8-10.9-37.1 .2-46.1 1.1-9.8 2.2-6.8 3.6 26.8 10.4 39.2 15.1 29.7 10 31.5 20.2-9 25.4-14.9 36.8-6.1 12.8-5.7 17.4 20.6 16.4 25.1 19.4 28.4 16.4 28.4 23.9-23.2 27-30.5 31.8-27.2 15.4-35.7 17.1-21.7-8.2-29.4-22.8-.8-29.1 3.9-40.4-3.3-17.7-7.1-21.8-33.8-36.5-40.7-43.9-13.7-11.2-13.7-25.4 54.2-81 54.2-81 45.8 8.9 51.9 8.9 19.5-5.2 31.9-9.4 20.6-4.2 20.6-4.2l-.3 0z"]
  };
  var faAvianex = {
    prefix: 'fab',
    iconName: 'avianex',
    icon: [512, 512, [], "f374", "M453.2 32l-312 0C102.3 32 65 63.2 57.9 101.7L1.3 410.3C-5.8 448.8 20 480 59 480l312 0c38.9 0 76.2-31.2 83.3-69.7L511 101.8C518 63.2 492.2 32 453.2 32zM395 379.3l-32 13.5-115.4-110c-14.7 10-29.2 19.5-41.7 27.1l22.1 64.2-17.9 12.7-40.6-61-52.4-48.1 15.7-15.4 58 31.1c9.3-10.5 20.8-22.6 32.8-34.9l-20.5-29.6-68.8-99.8 18.8-28.9 8.9-4.8 103.1 112.4 4.9 4.5c19.4-18.8 33.8-32.4 33.8-32.4 7.7-6.5 21.5-2.9 30.7 7.9 9 10.5 10.6 24.7 2.7 31.3-1.8 1.3-15.5 11.4-35.3 25.6l4.5 7.3 94.9 119.4-6.3 7.9z"]
  };
  var faNs8 = {
    prefix: 'fab',
    iconName: 'ns8',
    icon: [640, 512, [], "f3d5", "M104.3 269.2l26.1 0 0-26.2-26.1 0 0 26.2zM156.8 243l-.1-26.2 0-.9c-.2-10.4-4.4-20.3-11.9-27.6s-17.5-11.3-27.9-11.1-20.3 4.4-27.6 11.8-11.3 17.5-11.2 27.9l0 .2 26.4 0 0-.2c.1-3.4 1.5-6.6 3.9-9s5.7-3.7 9.1-3.7 6.7 1.3 9.1 3.7 3.8 5.6 3.9 9l0 26.2 26.3 0zm52.4 25.8c0 12-2.4 23.8-6.9 34.9s-11.3 21.1-19.7 29.6-18.5 15.2-29.6 19.7-22.9 6.9-34.9 6.9l-.6 0c-24.2 0-47.3-9.6-64.4-26.7S26.3 293 26.3 268.8l-26.3 0 0 .2c0 15.4 3.1 30.7 9 44.9s14.6 27.2 25.5 38.1 23.9 19.5 38.1 25.4 29.5 8.9 44.9 8.9l.8 0c15.4 0 30.7-3 44.9-9s27.2-14.6 38.1-25.5 19.5-23.8 25.4-38.1 8.9-29.5 8.9-44.9l0-26-26.3 0 0 26zm-157.2 0c.1 17.3 7 33.9 19.2 46.1s28.8 19.1 46.1 19.1 33.9-6.9 46.1-19.1 19.2-28.8 19.2-46.1l-26.3 0c-.2 10.2-4.4 20-11.7 27.2s-17.1 11.2-27.4 11.2-20.1-4-27.4-11.2-11.5-16.9-11.7-27.2l0-26-26.3 0 0-26.6c.3-17.3 7.4-33.8 19.7-45.8s29-18.8 46.3-18.6 33.8 7.2 45.9 19.5 18.9 28.9 18.9 46.2l0 25.3 26.3 0 0-25.3c0-24.3-9.7-47.7-26.9-64.9s-40.5-26.9-64.9-26.9-47.7 9.7-64.9 26.9-26.9 40.5-26.9 64.9l0 25.4 26.3 0 0 26zm418.4-71.2c13.7 0 24.6 6.6 30.1 18.3l.7 1.5 23.2-11.5-.6-1.4c-8-19.3-28.5-31.3-53.4-31.3-23.1 0-43.6 11.4-51 28.4-.1 26.9-.2 23.9 0 24.8 4.7 11 14.6 19.4 28.7 24.2 6.5 2 13.1 3.3 19.8 4 5.5 .7 10.6 1.4 15.8 3.1 6.4 2.1 10.5 5.3 12.8 9.8l0 9.9c-3.7 7.5-13.8 12.3-25.8 12.3-14.3 0-26-6.9-31.9-19l-.7-1.5-23 11.5 .6 1.4c7.9 19.4 29.6 32 55.3 32 23.6 0 44.6-11.4 52.3-28.4l.2-25.9-.2-.7c-4.9-11-15.2-19.6-28.9-24.2-7.7-2.7-14.3-3.6-20.7-4.4-5-.5-10-1.5-14.8-2.9-6.3-1.9-10.4-5.1-12.6-9.6l0-8.4c3.4-7.4 12.9-12.1 24.2-12.1l0 0zM287.6 311.3l26.1 0 0-68.4-26.1 0 0 68.4zM639.8 258c-2.9-6.3-8.3-12-15.4-16.7 5.6-3.8 10.1-9.1 13-15.3l.2-25.3-.2-.7c-7.4-16-26.7-26.7-48.2-26.7S548.5 184 541.1 200l-.2 25.3 .2 .7c2.9 6.1 7.4 11.4 13 15.3-7.2 4.7-12.5 10.5-15.4 16.7l-.2 28.9 .2 .7c7.6 16 27.9 26.7 50.6 26.7s43.1-10.7 50.6-26.7l.2-28.9-.2-.7zm-73.2-50.8c3.6-6.3 12.6-10.5 22.6-10.5s19 4.2 22.6 10.5l0 13.7c-3.5 6.2-12.6 10.3-22.6 10.3s-19.1-4.2-22.6-10.3l0-13.7zm47.3 72.2c-3.8 6.6-13.3 10.9-24.7 10.9-11.1 0-21-4.4-24.7-10.9l0-16.2c3.7-6.3 13.5-10.5 24.7-10.5 11.3 0 20.9 4.1 24.7 10.5l0 16.2zM376.4 266l-59.8-89.7-29 0 0 40.6 26.5 0 0 .4 62.5 94.1 25.7 0 0-135.1-25.9 0 0 89.7z"]
  };
  var faSquarePinterest = {
    prefix: 'fab',
    iconName: 'square-pinterest',
    icon: [448, 512, ["pinterest-square"], "f0d3", "M384 32L64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l72.6 0-2.2-.8c-5.4-48.1-3.1-57.5 15.7-134.7 3.9-16 8.5-35 13.9-57.9 0 0-7.3-14.8-7.3-36.5 0-70.7 75.5-78 75.5-25 0 13.5-5.4 31.1-11.2 49.8-3.3 10.6-6.6 21.5-9.1 32-5.7 24.5 12.3 44.4 36.4 44.4 43.7 0 77.2-46 77.2-112.4 0-58.8-42.3-99.9-102.6-99.9-69.9 0-110.9 52.4-110.9 106.6 0 21.1 8.2 43.7 18.3 56 2 2.4 2.3 4.5 1.7 7-1.1 4.7-3.1 12.9-4.7 19.2-1 4-1.8 7.3-2.1 8.6-1.1 4.5-3.5 5.5-8.2 3.3-30.6-14.3-49.8-59.1-49.8-95.1 0-77.5 56.2-148.6 162.2-148.6 85.2 0 151.4 60.7 151.4 141.8 0 84.6-53.3 152.7-127.4 152.7-24.9 0-48.3-12.9-56.3-28.2 0 0-12.3 46.9-15.3 58.4-5 19.3-17.6 42.9-27.4 59.3L384 480c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64z"]
  };
  var faPinterestSquare = faSquarePinterest;
  var faBluetoothB = {
    prefix: 'fab',
    iconName: 'bluetooth-b',
    icon: [256, 512, [], "f294", "M164.9 260L257.5 156.7 111.6 0 111.6 206.3 25.4 120.2-6 151.6 102.1 260-6 368.4 25.4 399.8 111.6 313.7 114.3 512 262.8 363.4 164.9 260zm40.9-103l-50 50-.3-100.3 50.3 50.3zm-50 156l50 50-50.3 50.3 .3-100.3z"]
  };
  var faGripfire = {
    prefix: 'fab',
    iconName: 'gripfire',
    icon: [320, 512, [], "f3ac", "M80.5 301.4c0-73.8 105.1-122.5 105.1-203 0-47.1-34-88-39.1-90.4 .4 3.3 .6 6.7 .6 10 0 92.1-147.1 153.9-147.1 268.6 0 49.8 32.2 79.2 66.5 108.3 65.1 46.7 78.1 71.4 78.1 86.6 0 10.1-4.8 17-4.8 22.3 13.1-16.7 17.4-31.9 17.5-46.4 0-29.6-21.7-56.3-44.2-86.5-16-22.3-32.6-42.6-32.6-69.5zm205.3-39c-12.1-66.8-78-124.4-94.7-130.9l4 7.2c2.4 5.1 3.4 10.9 3.4 17.1 0 44.7-54.2 111.2-56.6 116.7-2.2 5.1-3.2 10.5-3.2 15.8 0 20.1 15.2 42.1 17.9 42.1 2.4 0 56.6-55.4 58.1-87.7 6.4 11.7 9.1 22.6 9.1 33.4 0 41.2-41.8 96.9-41.8 96.9 0 11.6 31.9 53.2 35.5 53.2 1 0 2.2-1.4 3.2-2.4 37.9-39.3 67.3-85 67.3-136.8 0-8-.7-16.2-2.2-24.6z"]
  };
  var faSquareGooglePlus = {
    prefix: 'fab',
    iconName: 'square-google-plus',
    icon: [448, 512, ["google-plus-square"], "f0d4", "M448 96c0-35.3-28.7-64-64-64L64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320zM64 256c0-55.3 44.7-100 100-100 27 0 49.5 9.8 67 26.2l-27.1 26.1c-7.4-7.1-20.3-15.4-39.8-15.4-34.1 0-61.9 28.2-61.9 63.2 0 34.9 27.8 63.2 61.9 63.2 39.6 0 54.4-28.5 56.8-43.1l-56.9 0 0-34.4 94.4 0c1 5 1.6 10.1 1.6 16.6 0 57.1-38.3 97.6-96 97.6-55.3 0-100-44.7-100-100zm291 18.2l0 29-29.2 0 0-29-29 0 0-29.2 29 0 0-29 29.2 0 0 29 29 0 0 29.2-29 0z"]
  };
  var faGooglePlusSquare = faSquareGooglePlus;
  var faAppStore = {
    prefix: 'fab',
    iconName: 'app-store',
    icon: [512, 512, [], "f36f", "M255.9 120.9l9.1-15.7c5.6-9.8 18.1-13.1 27.9-7.5s13.1 18.1 7.5 27.9l-87.5 151.5 63.3 0c20.5 0 32 24.1 23.1 40.8l-185.5 0c-11.3 0-20.4-9.1-20.4-20.4s9.1-20.4 20.4-20.4l52 0 66.6-115.4-20.8-36.1c-5.6-9.8-2.3-22.2 7.5-27.9 9.8-5.6 22.2-2.3 27.9 7.5l8.9 15.7zm-78.7 218l-19.6 34c-5.6 9.8-18.1 13.1-27.9 7.5s-13.1-18.1-7.5-27.9l14.6-25.2c16.4-5.1 29.8-1.2 40.4 11.6zm168.9-61.7l53.1 0c11.3 0 20.4 9.1 20.4 20.4S410.5 318 399.2 318l-29.5 0 19.9 34.5c5.6 9.8 2.3 22.2-7.5 27.9-9.8 5.6-22.2 2.3-27.9-7.5-33.5-58.1-58.7-101.6-75.4-130.6-17.1-29.5-4.9-59.1 7.2-69.1 13.4 23 33.4 57.7 60.1 104zM256 8a248 248 0 1 0 0 496 248 248 0 1 0 0-496zM40 256a216 216 0 1 1 432 0 216 216 0 1 1 -432 0z"]
  };
  var faWix = {
    prefix: 'fab',
    iconName: 'wix',
    icon: [640, 512, [], "f5cf", "M393.4 131.7c0 13 2.1 32.7-28.7 43.8-9.5 3.4-16 9.7-16 9.7 0-31 4.7-42.2 17.4-48.9 9.8-5.1 27.2-4.6 27.2-4.6zM277.6 167.2l-34.2 132.7-28.5-108.6c-7.7-32-20.8-48.5-48.4-48.5-27.4 0-40.7 16.2-48.4 48.5L89.5 299.9 55.3 167.2C49.7 140.5 23.9 129 0 132L65.6 379.9s21.6 1.6 32.5-4c14.2-7.2 21-12.8 29.6-46.6 7.7-30.1 29.1-118.4 31.1-124.7 4.8-14.9 11.1-13.8 15.4 0 2 6.3 23.5 94.6 31.1 124.7 8.6 33.7 15.4 39.3 29.6 46.6 10.8 5.5 32.5 4 32.5 4L332.9 132c-24.4-3.1-49.8 8.9-55.3 35.3zm115.8 5.2s-4.1 6.3-13.5 11.6c-6 3.4-11.8 5.6-18 8.6-15.1 7.3-13.2 13.9-13.2 35.2l0 152.1s16.6 2.1 27.4-3.4c13.9-7.1 17.1-14 17.3-44.8l0-150.3 0 0 0-9zm163.4 84.1L640 132.8s-35.1-6-52.5 9.8c-13.3 12.1-24.4 29.6-54.2 72.5-.5 .7-6.3 10.5-13.1 0-29.3-42.2-40.8-60.3-54.2-72.5-17.4-15.8-52.5-9.8-52.5-9.8l83.2 123.7-83 123.4s36.6 4.6 54-11.2c11.5-10.5 17.6-20.4 52.5-70.7 6.8-10.5 12.6-.8 13.1 0 29.4 42.4 39.2 58.1 53.1 70.7 17.4 15.8 53.3 11.2 53.3 11.2l-83-123.4z"]
  };
  var faIntercom = {
    prefix: 'fab',
    iconName: 'intercom',
    icon: [448, 512, [], "f7af", "M392 32L56 32C25.1 32 0 57.1 0 88L0 424c0 30.9 25.1 56 56 56l336 0c30.9 0 56-25.1 56-56l0-336c0-30.9-25.1-56-56-56zM283.7 114.1c0-19.8 29.9-19.8 29.9 0l0 199.5c0 19.8-29.9 19.8-29.9 0l0-199.5zm-74.6-7.5c0-19.8 29.9-19.8 29.9 0l0 216.5c0 19.8-29.9 19.8-29.9 0l0-216.5zm-74.7 7.5c0-19.8 29.9-19.8 29.9 0l0 199.5c0 19.8-29.9 19.8-29.9 0l0-199.5zM59.7 144c0-19.8 29.9-19.8 29.9 0l0 134.3c0 19.8-29.9 19.8-29.9 0l0-134.3zM383.1 371.8c-72.8 63-241.7 65.4-318.1 0-15-12.8 4.4-35.5 19.4-22.7 65.9 55.3 216.1 53.9 279.3 0 14.9-12.9 34.3 9.8 19.4 22.7zm5.2-93.5c0 19.8-29.9 19.8-29.9 0l0-134.3c0-19.8 29.9-19.8 29.9 0l0 134.3z"]
  };
  var faReacteurope = {
    prefix: 'fab',
    iconName: 'reacteurope',
    icon: [576, 512, [], "f75d", "M250.7 211.7l5.8-4.1 5.8 4.1-2.1-6.8 5.7-4.3-7.1-.1-2.3-6.8-2.3 6.8-7.2 .1 5.7 4.3-2 6.8zm63.7 0l5.8-4.1 5.8 4.1-2.1-6.8 5.7-4.3-7.2-.1-2.3-6.8-2.3 6.8-7.2 .1 5.7 4.3-1.9 6.8zm-91.3 50.5l-3.4 0c-4.8 0-3.8 4-3.8 12.1 0 4.7-2.3 6.1-5.8 6.1s-5.8-1.4-5.8-6.1l0-36.6c0-4.7 2.3-6.1 5.8-6.1s5.8 1.4 5.8 6.1c0 7.2-.7 10.5 3.8 10.5l3.4 0c4.7-.1 3.8-3.9 3.8-12.3 0-9.9-6.7-14.1-16.8-14.1l-.2 0c-10.1 0-16.8 4.2-16.8 14.1l0 40.1c0 10.4 6.7 14.1 16.8 14.1l.2 0c10.1 0 16.8-3.8 16.8-14.1 0-9.9 1.1-13.8-3.8-13.8zm-80.7 17.4l-14.7 0 0-19.3 11.4 0c2.5 0 3.8-1.3 3.8-3.8l0-2.1c0-2.5-1.3-3.8-3.8-3.8l-11.4 0 0-18.3 14.4 0c2.5 0 3.8-1.3 3.8-3.8l0-2.1c0-2.5-1.3-3.8-3.8-3.8l-21.7 0c-2.4-.1-3.7 1.3-3.7 3.8l0 59.1c0 2.5 1.3 3.8 3.8 3.8l21.9 0c2.5 0 3.8-1.3 3.8-3.8l0-2.1c0-2.5-1.3-3.8-3.8-3.8zm-42-18.5c4.6-2 7.3-6 7.3-12.4l0-11.9c0-10.1-6.7-14.1-16.8-14.1l-13.4 0c-2.5 0-3.8 1.3-3.8 3.8l0 59.1c0 2.5 1.3 3.8 3.8 3.8l3.4 0c2.5 0 3.8-1.3 3.8-3.8l0-22.9 5.6 0 7.4 23.5c.2 1 .8 1.8 1.6 2.4s1.8 .9 2.7 .8l3.3 0c2.8 0 4-1.8 3.2-4.4l-8.1-23.9zm-3.8-14c0 4.8-2.5 6.1-6.1 6.1l-5.8 0 0-20.9 5.8 0c3.6 0 6.1 1.3 6.1 6.1l0 8.7zM176.1 226c-.1-.5-.2-1-.4-1.4s-.6-.8-1-1.1-.8-.6-1.3-.7-1-.2-1.5-.1l-6.9 0c-.5 0-1 0-1.4 .2s-.9 .4-1.3 .7-.7 .7-.9 1.1-.4 .9-.4 1.4l-11 59.2c-.5 2.7 .9 4.1 3.4 4.1l3 0c.5 .1 1 0 1.5-.2s.9-.4 1.3-.7 .7-.7 .9-1.2 .4-.9 .4-1.4l1.8-11.3 12.2 0 1.8 11.3c0 .5 .2 1 .4 1.4s.5 .9 .9 1.2 .8 .6 1.3 .7 1 .2 1.5 .2l3.5 0c2.6 0 3.9-1.4 3.4-4.1L176.1 226zm-12.3 39.3l4.7-29.7 4.7 29.7-9.4 0zm89.3 20.2l0-53.2 7.5 0c2.5 0 3.8-1.3 3.8-3.8l0-2.1c0-2.5-1.3-3.8-3.8-3.8l-25.8 0c-2.5 0-3.8 1.3-3.8 3.8l0 2.1c0 2.5 1.3 3.8 3.8 3.8l7.3 0 0 53.2c0 2.5 1.3 3.8 3.8 3.8l3.4 0c2.5 0 3.8-1.3 3.8-3.8l0 0zm248-.8l-19.4 0 0-26.7 16.1 0c.3 0 .5 0 .8-.1s.5-.2 .7-.4 .3-.4 .4-.7 .1-.5 .1-.8l0-.8c0-.3 0-.5-.1-.8s-.2-.5-.4-.7-.4-.3-.7-.4-.5-.1-.8-.1l-16.1 0 0-25.8 19.1 0c.3 0 .5 0 .8-.1s.5-.2 .7-.4 .3-.4 .4-.7 .1-.5 .1-.8l0-.8c0-.3 0-.5-.1-.8s-.2-.5-.4-.7-.4-.3-.7-.4-.5-.1-.8-.1l-22.2 0c-.3-.1-.5-.1-.8 0s-.5 .2-.7 .4-.3 .4-.4 .7-.1 .5-.1 .8l0 63c0 .3 0 .5 .1 .8s.2 .5 .4 .6 .4 .3 .7 .4 .5 .1 .8 .1l22.5 0c.3 0 .5 0 .8-.1s.5-.2 .7-.4 .3-.4 .4-.6 .1-.5 .1-.8l0-.8c0-.3 0-.5-.1-.8s-.2-.5-.4-.7-.4-.3-.7-.4-.5-.1-.8-.1l0 0zM408 221.8l-.8 0c-10.1 0-15.3 4.7-15.3 14.1l0 40.1c0 9.3 5.2 14.1 15.3 14.1l.8 0c10.1 0 15.3-4.8 15.3-14.1l0-40.1c0-9.4-5.2-14.1-15.3-14.1l0 0zm10.2 52.4c-.1 8-3 11.1-10.5 11.1s-10.5-3.1-10.5-11.1l0-36.6c0-7.9 3-11.1 10.5-11.1s10.5 3.2 10.5 11.1l0 36.6zm-46.5-14.5c6.1-1.6 9.2-6.1 9.2-13.3l0-9.7c0-9.4-5.2-14.1-15.3-14.1l-13.7 0c-.3 0-.5 0-.8 .1s-.5 .2-.7 .4-.3 .4-.4 .6-.1 .5-.1 .8l0 63c0 .3 0 .5 .1 .8s.2 .5 .4 .6 .4 .3 .7 .4 .5 .1 .8 .1l1.2 0c.3 0 .5 0 .8-.1s.5-.2 .6-.4 .3-.4 .4-.6 .1-.5 .1-.8l0-26.9 11.6 0 10.4 27.2c.2 .5 .5 .9 .9 1.1s.9 .4 1.4 .4l1.5 0c1.4 0 2-1 1.5-2.3l-10.6-27.3zm-6.4-3.9l-10.2 0 0-28.5 10.2 0c7.5 0 10.5 3.1 10.5 11.1l0 6.4c0 7.8-3 11-10.5 11l0 0zm85.9-33.1l-13.7 0c-.3-.1-.5-.1-.8 0s-.5 .2-.7 .4-.3 .4-.4 .7-.1 .5-.1 .8l0 63c0 .3 0 .5 .1 .8s.2 .5 .4 .6 .4 .3 .7 .4 .5 .1 .8 .1l1.2 0c.3 0 .5 0 .8-.1s.5-.2 .6-.4 .3-.4 .4-.6 .1-.5 .1-.8l0-26.1 10.6 0c10.1 0 15.3-4.8 15.3-14.1l0-10.5c0-9.4-5.2-14.1-15.3-14.1zm10.2 22.8c0 7.9-3 11.1-10.5 11.1l-10.2 0 0-29.2 10.2 0c7.5-.1 10.5 3.1 10.5 11l0 7.1zM259.6 308l-2.3-6.8-2.3 6.8-7.1 .1 5.7 4.3-2.1 6.8 5.8-4.1 5.8 4.1-2.1-6.8 5.7-4.3-7.1-.1zM487.2 171.9c-11.7-4.4-23.5-8.1-35.6-11.3 19.6-78 11.6-134.7-22.3-153.9-34.5-19.4-85.9 4.3-138.2 55.2 3.4 3.3 6.8 6.7 10.2 10.2 82.5-80 119.6-53.5 120.9-52.8 22.4 12.7 36 55.8 15.5 137.8-27.8-6.4-56.1-10.7-84.6-13-71.9-100.5-140.6-142.1-182.2-142.1-30.8 0-43.8 21-47.6 27.7-18.1 32-13.3 84.2 .1 133.8-70.5 20.3-120.7 54.1-120.3 95 .5 59.6 103.2 87.8 122.1 92.8-20.5 81.9-10.1 135.6 22.3 153.9 28 15.8 75.1 6 138.2-55.2-3.4-3.3-6.8-6.7-10.2-10.2-82.5 80-119.7 53.5-120.9 52.8-22.3-12.6-36-55.6-15.5-137.9 12.4 2.9 41.8 9.5 84.6 13 71.9 100.4 140.6 142 182.1 142 30.8 0 43.8-21 47.6-27.7 18-31.9 13.3-84.1-.1-133.8 152.3-43.8 156.2-130.2 33.9-176.3l0 0zM136 36.8c2.9-5.1 11.9-20.3 34.9-20.3 36.8 0 98.8 39.6 163.3 126.2-31.3-1.8-62.7-1.5-93.9 .9 13-18.3 27.1-35.8 42.2-52.4-3.4-3.5-6.8-6.9-10.2-10.2-18.3 20.2-35.3 41.7-50.7 64.2-28.5 2.7-56.7 7.6-84.4 14.6-.2-1.4-24.3-82.2-1.2-123l0 0zM440.8 475.1c-2.9 5.1-11.8 20.3-34.9 20.3-36.7 0-98.7-39.4-163.3-126.2 31.3 1.8 62.7 1.5 93.9-.9-13 18.3-27.1 35.8-42.2 52.4 3.4 3.5 6.8 6.9 10.2 10.2 18.4-20.2 35.3-41.7 50.7-64.2 47.3-4.7 80.3-13.5 84.4-14.6 22.7 84.4 4.5 117 1.2 123zm9.1-138.6c-3.6-11.9-7.7-24.1-12.4-36.4-2.1 0-4.2-.5-6.1-1.5s-3.5-2.4-4.6-4.2l-.1 .1c-1.6 1.5-3.4 2.7-5.4 3.6 5.7 14.3 10.6 28.4 14.7 42.2-23.7 6-47.7 10.3-72 13 3.5-5.3 17.2-26.2 32.2-54.2-2.1-.8-4.2-1.9-6-3.2-1.1 1.2-3.6 4.2-10.9 4.2-6.2 11.2-17.4 30.9-33.9 55.2-37.4 3.3-75 3.6-112.4 1-7.9-11.2-21.5-31.1-36.8-57.8-1-.4-2-.9-3-1.5-1.9 1.6-3.9 3.2-12.6 3.2 6.3 11.2 17.5 30.7 33.8 54.6-24.3-2.3-48.4-6.2-72.2-11.7 3.9-14 8.6-28.3 14.1-42.9-3.2 0-5.4 .2-8.4-1-2.2 .8-4.6 1.1-6.9 1-4.9 13.4-9.1 26.5-12.7 39.4-159.9-42.6-140.3-123.6-1.5-164 3.6 11.9 7.7 24.1 12.4 36.4 10.4 0 12.9 3.4 14.4 5.3 .7-.8 1.4-1.6 2.3-2.2-5.8-14.7-10.9-29.2-15.2-43.3 7-1.8 32.4-8.4 72-13-15.9 24.3-26.7 43.9-32.8 55.3 3.1 1.8 5.3 4.6 6.4 8 2.5-3.7 6.1-6.6 10.2-8.4 6.5-11.7 17.9-31.9 34.8-56.9 37.4-3.3 75-3.6 112.4-1 31.5 44.6 28.9 48.1 42.5 64.5 2.6-3.5 6.3-6 10.4-7.4-6.4-11.4-17.6-31-34.3-55.5 40.4 4.1 65 10 72.2 11.7-4 14.4-8.9 29.2-14.6 44.2 2.5 1 4.8 2.4 6.8 4.3l.1 .1c1-1.5 2.3-2.8 3.8-3.8s3.3-1.6 5.1-1.8c4.9-13.4 9.2-26.6 12.8-39.5 11.7 3.1 23.2 6.8 34.5 11 106.1 39.9 74 87.9 72.6 90.4-19.8 35.1-80.1 55.2-105.7 62.5zm-114.4-114l-1.2 0c-.3 0-.5 0-.8 .1s-.5 .2-.6 .4-.3 .4-.4 .6-.1 .5-.1 .8l0 49.8c0 7.9-2.6 11.1-10.1 11.1s-10.1-3.1-10.1-11.1l0-49.8c0-.3 0-.5-.1-.8s-.2-.5-.4-.7-.4-.3-.7-.4-.5-.1-.8-.1l-1.2 0c-.3 0-.5 0-.8 .1s-.5 .2-.7 .4-.3 .4-.4 .6-.1 .5-.1 .8l0 51.5c0 9.6 5 14.1 15.1 14.1l.4 0c10.1 0 15.1-4.6 15.1-14.1l0-51.5c0-.3-.1-.5-.2-.8s-.3-.5-.5-.6-.4-.3-.7-.4-.5-.1-.8-.1zM321.8 308l-2.3-6.8-2.3 6.8-7.1 .1 5.7 4.3-2.1 6.8 5.8-4.1 5.8 4.1-2.1-6.8 5.7-4.3-7.1-.1zm-31.1 7.4l-2.3-6.8-2.3 6.8-7.1 .1 5.7 4.3-2.1 6.8 5.8-4.1 5.8 4.1-2.1-6.8 5.7-4.3-7.1-.1zm5.1-30.8l-19.4 0 0-26.7 16.1 0c.3 0 .5 0 .8-.1s.5-.2 .7-.4 .3-.4 .4-.7 .1-.5 .1-.8l0-.8c0-.3 0-.5-.1-.8s-.2-.5-.4-.7-.4-.3-.7-.4-.5-.1-.8-.1l-16.1 0 0-25.8 19.1 0c.3 0 .5 0 .8-.1s.5-.2 .7-.4 .3-.4 .4-.7 .1-.5 .1-.8l0-.8c0-.3 0-.5-.1-.8s-.2-.5-.4-.7-.4-.3-.7-.4-.5-.1-.8-.1l-22.2 0c-.3 0-.5 0-.8 .1s-.5 .2-.7 .4-.3 .4-.4 .6-.1 .5-.1 .8l0 63c0 .3 0 .5 .1 .8s.2 .5 .4 .6 .4 .3 .7 .4 .5 .1 .8 .1l22.5 0c.3 0 .5 0 .8-.1s.5-.2 .7-.4 .3-.4 .4-.7 .1-.5 .1-.8l0-.8c0-.3 0-.6-.1-.8s-.2-.5-.4-.7-.4-.4-.7-.4-.5-.1-.8-.1l0 0zm-7.4-99.4l-2.3 6.8-7.1 .1 5.7 4.3-2.1 6.8 5.8-4.1 5.8 4.1-2.1-6.8 5.7-4.3-7.1-.1-2.3-6.8z"]
  };
  var faWaze = {
    prefix: 'fab',
    iconName: 'waze',
    icon: [512, 512, [], "f83f", "M502.6 201.7c14.5 85.9-30.9 167.9-113.2 208.1 13 34.1-12.4 70.2-48.3 70.2-13.2 0-26-5.1-35.6-14.2s-15.3-21.6-16-34.8c-6.4 .2-64.2 0-76.3-.6-.3 6.8-1.9 13.5-4.7 19.6s-6.9 11.7-11.9 16.3-10.8 8.2-17.2 10.5-13.2 3.4-19.9 3.1c-33.9-1.4-58-34.8-47-67.9-37.2-13.1-72.5-34.9-99.6-70.8-13-17.3-.5-41.8 20.8-41.8 46.3 0 32.2-54.2 43.2-110.3 18.4-93.9 116.8-157.1 211.7-157.1 102.5 0 197.2 70.7 214.1 169.7zM373.9 388.3c42-19.2 81.3-56.7 96.3-102.1 40.5-123.1-64.2-228-181.7-228-83.4 0-170.3 55.4-186.1 136-9.5 48.9 5 131.4-68.7 131.4 24.9 33.1 58.3 52.6 93.7 64 24.7-21.8 63.9-15.5 79.8 14.3 14.2 1 79.2 1.2 87.9 .8 3.5-6.9 8.5-12.9 14.7-17.5s13.2-7.9 20.8-9.5 15.4-1.4 22.9 .4 14.5 5.3 20.5 10.2zM205.5 187.1c0-34.7 50.8-34.7 50.8 0s-50.8 34.7-50.8 0zm116.6 0c0-34.7 50.9-34.7 50.9 0s-50.9 34.8-50.9 0zM199.5 257.8c-3.4-16.9 22.2-22.2 25.6-5.2l.1 .3c4.1 21.4 29.8 44 64.1 43.1 35.7-.9 59.3-22.2 64.1-42.8 4.5-16.1 28.6-10.4 25.5 6-5.2 22.2-31.2 62-91.5 62.9-42.6 0-80.9-27.8-87.9-64.2l0 0z"]
  };
  var faCreativeCommonsRemix = {
    prefix: 'fab',
    iconName: 'creative-commons-remix',
    icon: [512, 512, [], "f4ee", "M255.6 8C397.4 8 504 118.1 504 256 504 403.1 385.5 504 255.6 504 121.6 504 8 394.5 8 256 8 123.1 112.7 8 255.6 8zm.8 44.7c-118.2 0-203.7 97.9-203.7 203.3 0 109.8 91.2 202.8 203.7 202.8 103.2 0 202.8-81.1 202.8-202.8 .1-113.8-90.2-203.3-202.8-203.3zM418.1 260.4l4.9 2.2 0 70c-7.2 3.6-63.4 27.5-67.3 28.8-6.5-1.8-113.7-46.8-137.3-56.2l-64.2 26.6-63.3-27.5 0-63.8 59.3-24.8c-.7-.7-.4 5-.4-70.4l67.3-29.7 151.9 62.9 0 61.6 49.1 20.3zm-70.4 81.5l0-43.8-.4 0 0-1.8-113.8-46.5 0 45.2 113.8 46.9 0-.4 .4 .4zm7.5-57.6l39.9-16.4-36.8-15.5-39 16.4 35.9 15.5zm52.3 38.1l0-43-44.3 18.6 0 43.4 44.3-19z"]
  };
  var faBandcamp = {
    prefix: 'fab',
    iconName: 'bandcamp',
    icon: [512, 512, [], "f2d5", "M256 8a248 248 0 1 0 0 496 248 248 0 1 0 0-496zm48.2 326.1l-181 0 84.7-156.1 181 0-84.7 156.1z"]
  };
  var faSquareWebAwesomeStroke = {
    prefix: 'fab',
    iconName: 'square-web-awesome-stroke',
    icon: [448, 512, [], "e684", "M64 64C46.3 64 32 78.3 32 96l0 320c0 17.7 14.3 32 32 32l320 0c17.7 0 32-14.3 32-32l0-320c0-17.7-14.3-32-32-32L64 64zM0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zm235 81.6l53 46.4 52.2-10.4c-2.6-3.9-4.2-8.5-4.2-13.6 0-13.3 10.7-24 24-24s24 10.7 24 24c0 13-10.3 23.6-23.2 24L304.5 349.1c-5.2 11.5-16.6 18.9-29.2 18.9l-102.6 0c-12.6 0-24-7.4-29.2-18.9L87.2 224c-12.9-.4-23.2-11-23.2-24 0-13.3 10.7-24 24-24s24 10.7 24 24c0 5-1.5 9.7-4.2 13.6L160 224 213.1 177.6c-8.9-4.1-15-13.1-15-23.6 0-14.4 11.6-26 26-26s26 11.6 26 26c0 10.5-6.2 19.5-15.1 23.6z"]
  };
  var faVimeoV = {
    prefix: 'fab',
    iconName: 'vimeo-v',
    icon: [448, 512, [], "f27d", "M447.8 153.6c-2 43.6-32.4 103.3-91.4 179.1-60.9 79.2-112.4 118.8-154.6 118.8-26.1 0-48.2-24.1-66.3-72.3-35.2-129.2-50.2-204.9-79.3-204.9-3.4 0-15.1 7.1-35.2 21.1L0 168.2c51.6-45.3 100.9-95.7 131.8-98.5 34.9-3.4 56.3 20.5 64.4 71.5 28.7 181.5 41.4 208.9 93.6 126.7 18.7-29.6 28.8-52.1 30.2-67.6 4.8-45.9-35.8-42.8-63.3-31 22-72.1 64.1-107.1 126.2-105.1 45.8 1.2 67.5 31.1 64.9 89.4z"]
  };
  var faStrava = {
    prefix: 'fab',
    iconName: 'strava',
    icon: [384, 512, [], "f428", "M158.4 0L7 292 96.2 292 158.4 175.9 220.1 292 308.6 292 158.4 0zM308.6 292l-43.9 88.2-44.6-88.2-67.6 0 112.2 220 111.5-220-67.6 0z"]
  };
  var faUniregistry = {
    prefix: 'fab',
    iconName: 'uniregistry',
    icon: [384, 512, [], "f404", "M192 480c39.5 0 76.2-11.8 106.8-32.2l-213.5 0C115.8 468.2 152.5 480 192 480zM102.9 286.9l0-12.4-102.9 0 0 12.4c0 2.5 0 5 .1 7.4l103.1 0c-.2-2.4-.3-4.9-.3-7.4zm20.5 57l-114.9 0c2.6 8.5 5.8 16.8 9.6 24.8l138.3 0c-12.9-5.7-24.1-14.2-33-24.8zm-17.7-34.7l-104.4 0c.9 7.6 2.2 15 3.9 22.3l109.7 0c-4-6.9-7.2-14.4-9.2-22.3zm-2.8-69.3l-102.9 0 0 17.3 102.9 0 0-17.3zm0-173.2l-102.9 0 0 4.9 102.9 0 0-4.9zm0-34.7l-102.9 0 0 2.5 102.9 0 0-2.5zm0 69.3l-102.9 0 0 7.4 102.9 0 0-7.4zm0 104l-102.9 0 0 14.8 102.9 0 0-14.8zm0-69.3l-102.9 0 0 9.9 102.9 0 0-9.9zm0 34.6l-102.9 0 0 12.4 102.9 0 0-12.4zM269.1 331.5l109.7 0c1.8-7.3 3.1-14.7 3.9-22.3l-104.4 0c-2.1 7.9-5.2 15.4-9.2 22.3zm12-185.7l102.9 0 0-9.8-102.9 0 0 9.8zm0 37.2l102.9 0 0-12.4-102.9 0 0 12.4zm0-74.3l102.9 0 0-7.4-102.9 0 0 7.4zm0-76.7l0 2.5 102.9 0 0-2.5-102.9 0zM78.1 442.9l227.7 0c11.8-8.7 22.7-18.6 32.2-29.7l-293.1 0c9.6 11 21.4 21 33.2 29.7zm203-371.3l102.9 0 0-4.9-102.9 0 0 4.9zm0 148.5l102.9 0 0-14.8-102.9 0 0 14.8zM38.8 405.7l305.3 0c6.7-8.5 12.6-17.6 17.8-27.2L23 378.5c5.2 9.6 9.2 18.7 15.8 27.2zm188.8-37.1l139.4 0c3.7-8 5.8-16.2 8.5-24.8l-115 0c-8.8 10.7-20.1 19.2-32.9 24.8zm53.5-81.7c0 2.5-.1 5-.4 7.4l103.1 0c.1-2.5 .2-4.9 .2-7.4l0-12.4-102.9 0 0 12.4zm0-29.7l102.9 0 0-17.3-102.9 0 0 17.3z"]
  };
  var faCcDinersClub = {
    prefix: 'fab',
    iconName: 'cc-diners-club',
    icon: [576, 512, [], "f24c", "M239.7 79.9a175.8 175.8 0 1 0 0 351.6 175.8 175.8 0 1 0 0-351.6zM199.8 359.5c-41.7-15.9-71.4-56.4-71.4-103.8s29.7-87.9 71.4-104.1l0 207.9zm79.8 .3l0-208.2c41.7 16.2 71.4 56.7 71.4 104.1s-29.7 87.9-71.4 104.1zM528 32L48 32C21.5 32 0 53.5 0 80L0 432c0 26.5 21.5 48 48 48l480 0c26.5 0 48-21.5 48-48l0-352c0-26.5-21.5-48-48-48zM329.7 448l-90.3 0C133.2 448 45.6 362.5 45.6 257.8 45.6 143.2 133.2 64 239.4 64l90.3 0c105 0 200.7 79.2 200.7 193.8 0 104.7-95.7 190.2-200.7 190.2z"]
  };
  var faPinterest = {
    prefix: 'fab',
    iconName: 'pinterest',
    icon: [512, 512, [], "f0d2", "M504 256c0 137-111 248-248 248-25.6 0-50.2-3.9-73.4-11.1 10.1-16.5 25.2-43.5 30.8-65 3-11.6 15.4-59 15.4-59 8.1 15.4 31.7 28.5 56.8 28.5 74.8 0 128.7-68.8 128.7-154.3 0-81.9-66.9-143.2-152.9-143.2-107 0-163.9 71.8-163.9 150.1 0 36.4 19.4 81.7 50.3 96.1 4.7 2.2 7.2 1.2 8.3-3.3 .8-3.4 5-20.3 6.9-28.1 .6-2.5 .3-4.7-1.7-7.1-10.1-12.5-18.3-35.3-18.3-56.6 0-54.7 41.4-107.6 112-107.6 60.9 0 103.6 41.5 103.6 100.9 0 67.1-33.9 113.6-78 113.6-24.3 0-42.6-20.1-36.7-44.8 7-29.5 20.5-61.3 20.5-82.6 0-19-10.2-34.9-31.4-34.9-24.9 0-44.9 25.7-44.9 60.2 0 22 7.4 36.8 7.4 36.8s-24.5 103.8-29 123.2C161.5 437.2 163.5 467.4 165.6 487 73.4 450.9 8 361.1 8 256 8 119 119 8 256 8S504 119 504 256z"]
  };
  var faAlgolia = {
    prefix: 'fab',
    iconName: 'algolia',
    icon: [512, 512, [], "f36c", "M256 0c-139.9 0-254 112.7-256 252.1-2 141.5 112.9 258.7 254.5 259.5 43.7 .3 85.9-10.4 123.3-30.7 3.6-2 4.2-7 1.1-9.7l-24-21.2c-4.9-4.3-11.8-5.5-17.8-3-26.1 11.1-54.5 16.8-83.7 16.4-114.4-1.5-206.9-96.6-205.1-211 1.8-112.9 94.3-204.2 207.7-204.2l207.7 0 0 369-117.8-104.7c-3.8-3.4-9.7-2.7-12.7 1.3-18.9 25-49.7 40.6-83.9 38.2-47.5-3.3-85.9-41.5-89.5-88.9-4.2-56.6 40.6-103.9 96.3-103.9 50.4 0 91.9 38.8 96.2 88 .4 4.4 2.4 8.5 5.7 11.4l30.7 27.2c3.5 3.1 9 1.2 9.9-3.4 2.2-11.8 3-24.2 2.1-36.8-4.9-72-63.3-130-135.4-134.4-82.7-5.1-151.8 59.5-154 140.6-2.1 78.9 62.6 147 141.6 148.7 33 .7 63.6-9.6 88.3-27.6L495 509.4c6.6 5.8 17 1.2 17-7.7l0-492c0-5.4-4.4-9.7-9.7-9.7L256 0z"]
  };
  var faStackpath = {
    prefix: 'fab',
    iconName: 'stackpath',
    icon: [448, 512, [], "f842", "M244.6 232.4c0 8.5-4.3 20.5-21.3 20.5l-19.6 0 0-41.5 19.6 0c17.1 0 21.3 12.4 21.3 21zM448 32l0 448-448 0 0-448 448 0zM151.3 287.8c0-21.2-12.1-34.5-46.7-44.8-20.6-7.4-26-10.9-26-18.6s7-14.6 20.4-14.6c14.1 0 20.8 8.4 20.8 18.4l30.7 0 .2-.6c.5-19.6-15.1-41.6-51.1-41.6-23.4 0-52.6 10.8-52.6 38.3 0 19.4 9.2 31.3 50.7 44.4 17.3 6.2 21.9 10.4 21.9 19.5 0 15.2-19.1 14.2-19.5 14.2-20.4 0-25.7-9.1-25.7-21.9l-30.8 0-.2 .6c-.7 31.3 28.4 45.2 56.6 45.2 30 0 51.1-13.6 51.1-38.3zm125.4-55.6c0-25.3-18.4-45.5-53.4-45.5l-51.8 0 0 138.2 32.2 0 0-47.4 19.6 0c30.3 0 53.4-16 53.4-45.4zM297.9 325l49.1-138.2-31.1 0-47.9 138.2 29.9 0zM404.5 186.8l-31.1 0-47.9 138.2 29.9 0 49.1-138.2z"]
  };
  var faOctopusDeploy = {
    prefix: 'fab',
    iconName: 'octopus-deploy',
    icon: [512, 512, [], "e082", "M455.7 349.2c-45.9-39.1-36.7-77.9-16.1-128.1 35.7-87-23.5-186.9-109.6-212.8-92.9-27.9-195.7 16-230.3 108.8-8.7 23.5-12.5 48.5-11 73.5 1.7 29.5 14.7 53 24.1 80.3 17.2 50.2-28.1 92.7-66.7 117.6-46.8 30.2-36.3 39.9-8.4 41.9 23.4 1.7 44.5-4.5 65.3-15 9.2-4.6 40.7-18.9 45.1-28.6-12.2 26.6-37 72.7-21.5 102.1 19.1 36.2 67.1-31.8 76.7-45.8 8.6-12.6 43-81.3 63.6-46.9 18.9 31.4 8.6 76.4 35.7 104.6 32.9 34.2 51.2-18.3 51.4-44.2 .2-16.4-6.1-95.9 29.9-59.9 21.4 21.4 52.9 71.2 88.6 67 38.7-4.5-22.1-68-28.3-78.7 5.4 4.3 53.7 34.1 53.8 9.5 .1-18.8-30.1-34.7-42.5-45.3z"]
  };
  var faYammer = {
    prefix: 'fab',
    iconName: 'yammer',
    icon: [512, 512, [], "f840", "M500.7 159.5c-.4-1.8-1.2-3.4-2.3-4.8s-2.5-2.6-4.1-3.5c-3.1-1.6-6.7-2-10.1-1.1l-26.4 6.6 0-.2-22.3 5.8-1.2 .3-.6-2.2c-15.5-58.3-45-111.9-86.1-156.2-2.6-2.7-6.1-4.2-9.8-4.3s-7.3 1.3-10 3.8l-102.9 102.7-199.9 0c-6.6 0-12.9 2.6-17.6 7.3S0 124.8 0 131.4l0 249C0 387 2.6 393.3 7.3 398s11 7.3 17.6 7.3L225 405.3 328.1 508c2.6 2.6 6 4 9.7 4s7.1-1.4 9.7-4c.1-.1 .2-.3 .4-.4 29.3-31.5 52.8-67.8 69.6-107.4 6.9-16.5 12.7-33.5 17.3-50.8l0 0 20.4 5.3 0-.1 28.3 7.3c.9 .2 1.7 .4 2.6 .5 1.4 .2 2.8 .2 4.1-.1 2.5-.5 4.8-1.7 6.7-3.4s3.2-4 3.8-6.5c15.2-63.4 15.2-129.6 .1-193l0 0zM337.1 24.7l0 0 0 0 0 0zM226.9 189.8l-52.6 91.3c-1 1.7-1.5 3.7-1.5 5.7l0 46.2c0 5.8-2.3 11.4-6.5 15.6s-9.7 6.4-15.6 6.4l-3.4 0c-5.8 0-11.4-2.3-15.6-6.4s-6.5-9.7-6.5-15.6l0-45.7c0-1.9-.5-3.8-1.4-5.5L72.3 189.6c-1.9-3.4-2.8-7.1-2.8-11s1.1-7.6 3-10.9 4.7-6.1 8.1-8 7.1-2.9 11-2.9l3.3 0c4 0 8 1.1 11.5 3.2s6.3 5.1 8.1 8.7l36.4 70.3 37.5-70.5c1.8-3.5 4.6-6.4 7.9-8.4s7.2-3.2 11.1-3.2 7.8 .9 11.2 2.8 6.3 4.7 8.2 8.1c2 3.3 3 7.1 3 11s-1 7.7-3 11l0 0zM337.1 24.7c35.9 40.6 61.9 89 75.8 141.3l.6 2-114.1 29.6 0-66.1c0-6.6-2.7-12.9-7.3-17.6s-11-7.3-17.6-7.3l-19.4 0 82.1-81.8zM397.6 392l0 0 0 0c-14.7 34.8-35.1 67-60.2 95.2l-82.2-81.9 19.2 0c6.6 0 12.9-2.6 17.6-7.3s7.3-11 7.3-17.6l0-66.2 114.6 29.9c-4.4 16.3-9.8 32.3-16.3 47.9l0 0zm84-52.4l0 0-50.6-13.1-131.7-34.3 0-72.5 119.7-31 4.5-1.2c29.9-7.7 49.2-12.8 58.1-15.1 12 55.1 12 112.1 0 167.2z"]
  };
  var faModx = {
    prefix: 'fab',
    iconName: 'modx',
    icon: [448, 512, [], "f285", "M356 241.8l36.7 23.7 0 214.5-133-83.8 96.3-154.4zM440 75l-213.7 0-23 37.8 153.5 96.5 83.2-134.3zM351 217.8l-295.8-185.8 0 214.5 46 29 249.8-57.7zM97 294.2L8 437 221.7 437 346.7 236.5 97 294.2z"]
  };
  var faSquareThreads = {
    prefix: 'fab',
    iconName: 'square-threads',
    icon: [448, 512, [], "e619", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zM294.2 244.3c19.5 9.3 33.7 23.5 41.2 40.9 10.4 24.3 11.4 63.9-20.2 95.4-24.2 24.1-53.5 35-95.1 35.3l-.2 0c-46.8-.3-82.8-16.1-106.9-46.8-21.5-27.3-32.6-65.4-33-113.1l0-.2c.4-47.7 11.5-85.7 33-113.1 24.2-30.7 60.2-46.5 106.9-46.8l.2 0c46.9 .3 83.3 16 108.2 46.6 12.3 15.1 21.3 33.3 27 54.4l-26.9 7.2c-4.7-17.2-11.9-31.9-21.4-43.6-19.4-23.9-48.7-36.1-87-36.4-38 .3-66.8 12.5-85.5 36.2-17.5 22.3-26.6 54.4-26.9 95.5 .3 41.1 9.4 73.3 26.9 95.5 18.7 23.8 47.4 36 85.5 36.2 34.3-.3 56.9-8.4 75.8-27.3 21.5-21.5 21.1-47.9 14.2-64-4-9.4-11.4-17.3-21.3-23.3-2.4 18-7.9 32.2-16.5 43.2-11.4 14.5-27.7 22.4-48.4 23.5-15.7 .9-30.8-2.9-42.6-10.7-13.9-9.2-22-23.2-22.9-39.5-1.7-32.2 23.8-55.3 63.5-57.6 14.1-.8 27.3-.2 39.5 1.9-1.6-9.9-4.9-17.7-9.8-23.4-6.7-7.8-17.1-11.8-30.8-11.9l-.4 0c-11 0-26 3.1-35.6 17.6l-23-15.8c12.8-19.4 33.6-30.1 58.5-30.1l.6 0c41.8 .3 66.6 26.3 69.1 71.8 1.4 .6 2.8 1.2 4.2 1.9l.1 .5zm-71.8 67.5c17-.9 36.4-7.6 39.7-48.8-8.8-1.9-18.6-2.9-29-2.9-3.2 0-6.4 .1-9.6 .3-28.6 1.6-38.1 15.5-37.4 27.9 .9 16.7 19 24.5 36.4 23.6l-.1-.1z"]
  };
  var faOldRepublic = {
    prefix: 'fab',
    iconName: 'old-republic',
    icon: [512, 512, [], "f510", "M243.8 10.2c7.5-.3 15-.3 22.5-.1 3.6 .1 7.2 .4 10.8 .7 4.9 .3 9.8 1 14.7 1.6 2.9 .4 5.8 1 8.7 1.5 7.9 1.3 15.7 3.3 23.4 5.4 12.2 3.5 24.2 7.9 35.8 13.2 26.6 12.2 50.9 29.2 71.6 49.9 20 20.1 36.7 43.5 48.9 69.2 1.1 2.6 2.4 5.1 3.5 7.7 2.8 6.4 5.4 13 7.6 19.6 4.1 12.3 7.3 25 9.4 37.8 .6 3.1 1 6.3 1.4 9.5 .5 3.8 .9 7.7 1.2 11.6 .8 8.3 .8 16.7 .8 25.1-.1 5-.3 9.9-.7 14.9-.2 3.4-.5 6.8-1 10.1-.4 2.7-.6 5.5-1.1 8.2-.9 5.1-1.7 10.3-2.9 15.4-4.1 18.5-10.3 36.6-18.5 53.6-15.8 32.8-38.8 62.2-67.1 85.1-17.3 14.1-36.4 25.9-56.9 34.9-6.2 2.7-12.5 5.3-18.9 7.4-3.5 1.2-7 2.4-10.6 3.4-6.6 1.9-13.3 3.6-20 5-4.7 .9-9.3 1.7-14 2.5-5.3 .7-10.5 1.4-15.8 1.7-6.7 .7-13.4 .8-20.1 .8-6.8 0-13.6-.1-20.4-.8-3.3-.2-6.6-.5-9.8-1-2.7-.4-5.5-.6-8.2-1.1-4.1-.7-8.2-1.4-12.4-2.2-4.2-.9-8.5-1.9-12.7-3-8.6-2.2-17.1-5-25.4-8.1-10.5-4.1-20.8-8.7-30.6-14.2-2.1-1.2-4.3-2.3-6.4-3.6-11.2-6.6-21.9-14.1-31.9-22.3-34.7-28.4-61.4-66.4-76.4-108.7-3.1-8.7-5.7-17.6-7.8-26.7-1.5-6.2-2.5-12.4-3.6-18.7-.4-2.3-.6-4.7-1-7.1-.6-4-.8-8-1.2-11.9-.8-9.5-.7-19-.5-28.5 .1-3.5 .3-7 .7-10.5 .3-3.2 .5-6.4 .9-9.5 .4-2.8 .7-5.6 1.2-8.4 .7-3.9 1.3-7.9 2.1-11.8 3.4-16.5 8.5-32.7 15.3-48.2 1.2-2.9 2.6-5.7 3.9-8.6 8.1-16.7 17.9-32.6 29.5-47.1 20-25.4 45.1-46.7 73.3-62.5 7.5-4.2 15.2-8 23.1-11.4 15.8-6.9 32.4-12 49.3-15.4 3.5-.7 7-1.2 10.6-1.8 2.6-.5 5.3-.7 7.9-1.1 3.5-.5 7.1-.7 10.6-1 2.5-.2 4.9-.4 7.4-.5zm8.6 24.4c-9.2 .1-18.4 1-27.6 2.2-7.3 1.1-14.5 2.6-21.7 4.3-13.9 3.5-27.5 8.3-40.5 14.4-10.5 5-20.6 10.7-30.2 17.2-4.2 2.9-8.4 5.8-12.3 9-5.1 4-10 8.2-14.7 12.6-2.5 2.2-4.8 4.7-7.2 7.1-28.2 28.8-48.4 65.4-57.5 104.7-2 8.4-3.5 17-4.4 25.6-1.1 8.9-1.4 17.9-1.4 26.8 .1 7.1 .4 14.3 1.2 21.4 .6 7.1 1.9 14.2 3.2 21.2 1.1 4.6 2 9.3 3.3 13.9 6.3 23.4 16.5 45.7 30.1 65.8 8.6 13 18.8 24.9 30 35.8 16.3 15.8 35 29 55.3 39.2 7.3 3.5 14.7 6.9 22.3 9.6 5 1.8 10.1 3.6 15.2 5 11.3 3.2 22.8 5.6 34.4 7.1 2.9 .3 5.8 .6 8.7 .9 13.8 1.1 27.7 1 41.5-.4 4.4-.6 8.9-1 13.3-1.8 3.6-.7 7.3-1.2 10.9-2.1 4.1-1 8.3-1.9 12.4-3.1 26.5-7.3 51.6-19.7 73.6-36.2 15.8-11.8 30-25.8 42.1-41.3 3.3-4 6.2-8.3 9.1-12.6 3.4-5.1 6.6-10.2 9.6-15.5 2.4-4.4 4.7-8.9 7-13.4 5.7-12.1 10.3-24.6 13.8-37.5 2.6-10 4.7-20.2 5.9-30.4 1.8-13.5 1.9-27.1 1.3-40.7-.3-3.9-.7-7.8-1-11.7-2.2-19.1-6.8-37.9-13.8-55.8-6-15.1-13.5-29.6-22.6-43.1-12.7-18.8-28.2-35.7-46-49.8-25-20-54.5-34.5-85.6-42.1-7.8-1.9-15.7-3.3-23.6-4.4-3.9-.6-7.8-.8-11.8-1.2-7.4-.6-14.8-.7-22.2-.6zM147.3 83.5c13.3-8.9 28.1-15.4 43.3-20.2-3.2 1.8-6.4 3.4-9.5 5.3-11.2 6.7-21.5 14.9-30.4 24.5-6.8 7.4-12.8 15.7-17 24.9-3.3 6.9-5.6 14.2-6.9 21.7-.9 4.8-1.3 9.8-1.2 14.8 .1 13.7 4.4 27.1 11.3 38.8 5.9 10.2 13.6 19.3 22.4 27.3 4.9 4.4 10.2 8.1 15 12.6 2.3 2.2 4.5 4.4 6.4 6.9 2.6 3.3 4.9 7 6 11.1 .9 3 .7 6.2 .7 9.3 0 4.1 0 8.2 0 12.3 .1 3.5 0 7.1 .1 10.6 .1 2.4 0 4.8 .1 7.1 .2 5.8 .1 11.5 .1 17.3 .1 2.9 0 5.8 .1 8.7 0 1.6 .1 3.3 0 4.9-.9 .1-1.8 .2-2.7 .2-11 0-21.9-2.6-32-6.9-6-2.7-11.8-5.9-17.1-9.8-5.8-4.2-11.1-9-15.8-14.3-6.5-7.2-12-15.4-16.6-23.9-1.1-2-2.2-4-3.2-6.1-1.2-2.6-2.6-5.1-3.7-7.8-4-9.7-6.6-19.9-8.1-30.3-.5-4.4-1.1-8.9-1.2-13.3-.7-15.7 .8-31.6 4.7-46.8 2.1-8.2 4.8-16.2 8.3-23.8 6.3-14.2 15.3-27.2 26.3-38.2 6.3-6.2 13.1-11.8 20.5-16.7zM322.7 63.4c2.7 .7 5.4 1.7 8.1 2.7 6.4 2.3 12.7 4.8 18.7 8 13.1 6.4 25.3 14.8 35.8 25 10.2 10 18.7 21.6 25.1 34.3 1.3 2.7 2.6 5.5 3.8 8.3 6.3 15.1 10 31.3 11.2 47.6 .4 4.5 .4 9.1 .5 13.6 .1 11.6-1.5 23.3-4.3 34.5-2 7.3-4.3 14.5-7.9 21.2-3.2 6.6-6.7 13.2-10.8 19.2-6.9 10.5-15.6 19.9-25.8 27.2-10.5 7.6-22.6 13-35.4 15.4-3.5 .7-7.1 1.1-10.7 1.2-1.8 .1-3.7 .2-5.6-.1-.3-2.1 0-4.3 0-6.5 0-3.7 .1-7.4 .1-11.2 .2-7 0-14.1 .2-21.1 0-2.4 0-4.8 0-7.1 .2-5.1 0-10.1 .1-15.2 .1-3-.2-6 .5-9 .7-2.5 1.8-4.9 3.1-7.1 4.5-7.3 11.1-13 17.7-18.3 5.4-4.2 10.5-8.8 15-13.8 7.7-8.4 14.2-17.9 18.8-28.3 2.5-5.9 4.5-12.1 5.5-18.5 .9-4.4 1.1-8.8 1-13.3 0-7.8-1.4-15.6-3.6-23.2-1.8-5.7-4.3-11.2-7.1-16.4-3.9-6.9-8.6-13.3-14-19.2-9.9-10.8-21.8-19.9-34.6-27.1-1.8-1-3.8-1.8-5.6-3zM221.9 121.9c1-1.2 2-2.3 3.1-3.4-.6 .9-1.3 1.8-2 2.7-3.1 3.9-5.5 8.3-7 13.1-.9 3.3-1.7 6.6-1.7 10-.1 2.5-.1 5.1 .3 7.6 1.1 7.6 4.3 14.9 8.8 21.1 2 2.7 4.2 5.3 6.9 7.3 1.6 1.3 3.5 2.1 5.3 3 3.1 1.7 6.3 3.2 9.1 5.5 2.7 2.1 4.6 5.3 4.4 8.8 0 73.7 0 147.3 0 221 0 1.4-.1 2.7 0 4 .1 1.5 .8 2.8 1.5 4.1 .9 1.7 1.8 3.3 3.2 4.6 .9 .8 2 1.4 3.2 1.2 1.5-.2 2.7-1.4 3.4-2.6 1-1.5 1.7-3.2 2.3-4.9 .8-2.1 .4-4.4 .5-6.6 .1-4 0-8.1 .1-12.1 0-5.9 0-11.8 .1-17.7 .1-3.6 0-7.2 .1-10.9 .2-4 0-8.1 .1-12.1 0-6 0-12 .1-18 .1-3.6 0-7.2 .1-10.9 .1-3.9 0-7.9 .1-11.8 0-6 0-12 .1-18 .2-3.9 0-7.9 .2-11.8 .3 1.4 .1 2.9 .2 4.4 .2 3.6 .4 7.2 .8 10.8 .3 3.4 .4 6.9 .9 10.3 .4 3.1 .5 6.2 1 9.3 .6 4.1 .9 8.2 1.5 12.3 1.5 9 2.8 18.1 5.1 27 1.1 4.8 2.4 9.6 4 14.3 2.5 7.9 5.7 15.7 10.3 22.6 1.7 2.6 3.9 5 6.1 7.2 .3 .2 .6 .5 .9 .7 .6 .3 1.3-.1 1.7-.6 .7-.9 1.2-1.9 1.7-2.9 4.1-7.8 8.2-15.6 12.3-23.3 .7-1.3 1.4-2.6 2.6-3.6 1.8-1.6 3.8-2.7 6-3.6 2.9-1.2 5.9-2.2 9-2.4 6.6-.6 13.1 .7 19.6 1.8 3.7 .6 7.4 1.2 11.1 1.4 3.7 .1 7.5 .1 11.2-.3 8.6-.9 17-3 24.9-6.2 5.3-2.2 10.5-4.8 15.3-7.9 11.5-7.2 21.5-16.6 30-27 1.2-1.4 2.2-2.9 3.5-4.3-1.2 3.2-2.7 6.4-4.2 9.5-1.3 2.9-2.8 5.6-4.3 8.4-5.2 9.6-11 18.9-17.8 27.5-4 5.2-8.5 10.1-13.3 14.6-6.6 6.1-14.1 11.4-22.4 14.8-8.2 3.4-17.3 4.6-26.1 3.3-3.6-.6-7-1.7-10.4-2.9-2.8-1-5.4-2.4-8-3.7-3.4-1.7-6.6-3.8-9.7-6.1 2.7 3.1 5.7 5.9 8.7 8.6 4.3 3.8 8.7 7.3 13.6 10.2 4 2.5 8.3 4.4 12.8 5.5 1.5 .4 3 .5 4.5 .6-1.3 1.1-2.6 2-4 3-9.6 6.5-20 11.9-30.7 16.4-20.9 8.7-43.2 14-65.7 15.3-4.7 .2-9.3 .4-14 .4-5-.1-10-.1-14.9-.7-11.2-.8-22.3-2.7-33.2-5.4-10.4-2.7-20.6-6.1-30.3-10.6-8.7-3.9-17.1-8.4-25-13.8-1.8-1.3-3.7-2.5-5.4-4.1 6.6-1.2 13-3.4 19-6.5 5.7-2.9 11-6.7 15.6-11.1 2.2-2.2 4.3-4.6 6.2-7.1-3.4 2.1-6.9 4.2-10.6 5.8-4.4 2.2-9.1 3.8-13.8 5-5.7 1.5-11.7 1.7-17.6 1.1-8.1-1-15.9-4.3-22.5-9-4.3-2.9-8.2-6.4-12-10.1-9.9-10.2-18.2-21.8-25.7-33.9-3.9-6.3-7.5-12.7-11.1-19.2-1-2-2.1-4.1-3.2-6.1 2.8 2.9 5.6 6 8.4 8.9 19.2 19.2 37.6 32.3 53.7 35.5 3.1 .7 6.3 .5 9.5 .8 2.8 .3 5.6 .2 8.3 .3 5 .1 10.1 0 15.2-.2 3.6-.2 7.3-.7 10.9-1.1 2.1-.2 4.1-.7 6.1-1.2 3.9-1 8.1-1 11.8 .6 4.8 1.8 8.4 5.6 11.4 9.7 2.2 3 4.1 6.2 5.7 9.6 1.2 2.4 2.5 4.8 3.6 7.3 1 2.2 2.2 4.4 3.4 6.5 .7 1 1.4 2.2 2.6 2.6 1.1-.8 1.7-1.9 2.3-3 2.1-4.2 3.4-8.6 4.9-13 2-6.6 3.8-13.3 5.2-20 2.2-9.3 3.2-18.7 4.5-28.1 .6-4 .8-8 1.3-12 .9-10.6 1.9-21.3 2.2-31.9 .1-1.9 .2-3.7 .3-5.6 0-4.3 .2-8.7 .2-13 0-2.4 0-4.8 0-7.1 0-5.1-.2-10.1-.2-15.2-.2-6.6-.7-13.2-1.3-19.8-.7-5.9-1.5-11.8-3.1-17.5-2-7.7-5.6-15-9.8-21.8-3.2-5.1-6.8-9.9-11.1-14-3.9-3.9-8.6-7.1-13.9-8.4-1.5-.4-3.1-.4-4.6-.6 .1-3 .7-5.9 1.3-8.8 1.6-7.7 3.8-15.3 6.8-22.6 1.5-4 3.4-7.9 5.4-11.7 3.4-6.6 7.6-12.8 12.5-18.5zm31.3 1.7c.4-.1 .7-.1 1.1-.2 .2 1.8 .1 3.6 .1 5.4l0 38.1c0 1.7 .1 3.5-.2 5.2-.4 0-.7 0-1.1 0-.9-3.8-1.7-7.6-2.6-11.3-.4-1.5-.6-3.1-1.1-4.6-1.7-.2-3.4-.2-5.2-.2-5.1 0-10.1 0-15.2 0-1.7 0-3.3 .1-5 0 0-.4-.3-.9 .2-1.2 1.3-.7 2.7-.9 4.1-1.4 3.4-1.1 6.9-2.2 10.3-3.3 1.4-.5 2.9-.7 4.2-1.5 0-.6 0-1.1 0-1.7-1.2-.6-2.5-.9-3.8-1.3-3.1-1-6.3-2-9.4-3-1.8-.6-3.7-1-5.4-1.8 0-.4-.1-.7-.1-1.1 5.1-.2 10.2 .1 15.3-.1 3.4-.1 6.7 .1 10.1-.1 .1-.4 .3-.8 .4-1.2 1.1-4.9 2.3-9.8 3.4-14.7zm6-.2c.4 0 .7 .1 1.1 .2 1 3.8 1.7 7.8 2.7 11.6 .4 1.4 .6 2.9 1 4.3 2.5 .2 5.1 0 7.6 0 5.2 .1 10.3 .1 15.5 .1 .8 0 1.5 0 2.3 .1 0 .4-.1 .7-.1 1.1-1.8 .8-3.8 1.2-5.7 1.9-3.7 1.2-7.5 2.4-11.2 3.6-.6 .2-1.1 .4-1.7 .6-.2 .6-.2 1.1-.1 1.7 .9 .5 1.8 .8 2.8 1.1 4.9 1.5 9.7 3.1 14.6 4.6 .4 .1 .8 .3 1.1 .5 .4 .3 .2 .8 .2 1.2-1.7 .1-3.3 0-5 0-5.2 0-10.3 0-15.5 0-1.6 0-3.2 0-4.8 .2-.5 1.7-.7 3.4-1.2 5.1-.9 3.6-1.5 7.2-2.5 10.8-.4 0-.7 0-1.1 .1-.3-1.7-.2-3.5-.2-5.2l0-38.1c0-1.8-.1-3.6 .1-5.4zm-186 45c1.1-2.2 2.1-4.4 3.4-6.5-1.8 7.6-2.9 15.3-3.6 23-.8 7.7-.8 15.5-.5 23.2 1.1 19.9 5.5 39.8 14.2 57.9 3 6 6.4 11.8 10.5 17.1 6.1 7.5 12.5 14.8 19.8 21.1 4.8 4.1 10 7.8 15.5 10.8 3.3 1.7 6.5 3.4 9.9 4.7 5 2 10.2 3.6 15.4 4.9 3.8 1 7.8 1.4 11.5 2.7 5 1.6 9.5 4.6 13 8.4 4.9 5.2 8.1 11.9 10.2 18.7 1 2.9 1.6 5.9 2.2 8.9 .2 .8 .2 1.5 .2 2.3-6.5 2.8-13.3 5.1-20.3 6.2-4.1 .8-8.3 1-12.5 1.1-10.2 .2-20.5-1.8-30.1-5.1-3.7-1.4-7.5-2.9-11-4.7-8.1-3.8-15.6-8.7-22.5-14.5-2.9-2.6-5.8-5.1-8.4-8-9.2-9.8-16.3-21.4-21.8-33.7-2.4-5.5-4.6-11.2-6.4-17-1.2-3.9-2.4-7.9-3.3-11.9-.7-2.9-1.2-5.9-1.9-8.9-.5-2.1-.7-4.3-1-6.5-.8-5.4-1.3-10.9-1.3-16.4 .1-6.2 .2-12.4 1.1-18.5 .4-2.9 .7-5.7 1.2-8.6 1-5.7 2.1-11.4 3.7-16.9 3.1-11.6 7.5-23 12.7-33.8zm363.7-6.4c1.1 1.7 1.9 3.5 2.8 5.3 2.1 4.5 4.2 8.9 6 13.5 7.6 18.8 12.3 38.8 13 59 0 1.8 .1 3.5 .1 5.3 .1 9.6-1.3 19.1-3.2 28.5-.7 3.6-1.5 7.2-2.6 10.7-4 14.7-10 29-18.4 41.8-8.2 12.6-19 23.5-31.8 31.4-5.7 3.6-11.8 6.6-18 9.2-5.8 2.2-11.7 4-17.8 5.1-6.4 1-12.9 1.5-19.4 1.2-7.9-.5-15.8-2.1-23.2-4.8-1.9-.8-3.9-1.5-5.8-2.3-.2-1.5 .2-3 .5-4.5 1.2-5.7 3-11.4 5.7-16.6 2.4-4.5 5.5-8.7 9.5-11.9 2.4-2.1 5.2-3.6 8.2-4.8 3.6-1.5 7.5-2 11.2-2.8 7.2-1.7 14.4-3.9 21.2-7 10.3-4.7 19.7-11.4 27.6-19.5 1.6-1.6 3.2-3.2 4.7-4.9 3.4-3.8 6.7-7.6 9.8-11.5 7.5-10.1 12.8-21.6 16.7-33.5 1.6-5.3 3.2-10.6 4.2-16.1 .6-2.9 1-5.8 1.5-8.7 .9-6.1 1.6-12.2 1.7-18.4 .1-6.6 .1-13.3-.5-19.9-.7-8-1.9-16-3.7-23.8z"]
  };
  var faSuse = {
    prefix: 'fab',
    iconName: 'suse',
    icon: [640, 512, [], "f7d6", "M604.5 210a10.4 10.4 0 1 1 -11.4-17.4 10.4 10.4 0 1 1 11.4 17.4zM621 187.2a38.5 38.5 0 1 1 -75 17.6 38.5 38.5 0 1 1 75-17.6zM433.7 336.7c3.2 4.6 5.8 9 7.3 13.4 1 3.1 2.4 7.3 5.5 8.9 .2 .1 .3 .2 .5 .2 5.7 2.1 20.3 1.7 20.3 1.7l26.8 0c2.3 0 22.4 0 21.9-2.3-2.4-10.8-14.9-12.7-24.4-18.3-8.7-5.2-17-11.1-20.8-21.3-2-5.2-.8-17.4 2.6-21.8 2.5-3.2 6.1-5.3 10-6.2 4.3-.9 8.8-.1 13.1 .3 5.3 .5 10.6 1.5 15.9 2.2 10.3 1.3 20.6 1.9 31 1.6 17.1-.5 34.2-3.2 50.4-8.7 11.3-3.8 22.4-8.9 32-16.1 10.9-8.1 8.1-7.4-3-6.2-13.3 1.4-26.6 1.6-39.9 .8-12.4-.7-24.7-2.2-35.9-7.9-8.8-4.6-16.4-9.1-23.4-16.2-1-1.1-1.7-4.2 .2-6.2 1.9-1.9 5.8-.8 7 .2 12.2 10.2 30.5 18.6 49.3 19.5 10.2 .5 20.1 .7 30.4 .3 5.1-.2 12.8-.2 17.9-.3 2.6 0 9.8 .7 11.2-2.1 .4-.8 .4-1.8 .3-2.7-1.5-40.9-4.5-86.9-47.3-106.5-31.9-14.6-79.7-37.2-99.9-46.6-4.7-2.2-10.2 1.3-10.2 6.5 0 13.6 .7 33.3 .7 51.1-9.7-9.9-26-16.1-38.4-21.8-14.1-6.5-28.7-12-43.5-16.6-29.8-9.2-60.7-14.9-91.7-18-35.2-3.5-71-1.8-105.7 5.3-56.9 12.2-113.1 39.7-155.7 79.8-26.1 24.6-46.6 59.7-48 95.2-2 50.3 12.1 77.3 38 105.2 41.3 44.4 130.2 50.6 166.2-2 16.2-23.7 19.7-55.8 8-82-11.8-26.2-38.8-45.1-67.4-46-22.2-.7-45.9 10.6-54.5 31.1-6.5 15.7-2.8 35.1 9 47.3 4.6 4.8 10.9 8.7 17.7 7.1 4-.9 7.4-3.9 8-8 .9-6-4.4-9.9-7.6-14.5-5.8-8.3-4.7-20.9 2.7-27.9 6.2-6 15.3-7.8 23.9-7.7 8 0 16.2 1.4 23.1 5.5 9.7 5.7 16.2 16.2 18.4 27.2 6.7 33-20.2 59.9-56.6 62-18.6 1.1-37.6-3.8-52.1-15.5-36.9-29.8-45.9-90.3-3.8-122.7 40-30.7 90.4-22.8 120.2-6.8 23.8 12.8 41.5 33.6 55 56.7 6.7 11.6 12.5 23.7 17.8 36.1 5.1 11.8 9.9 23.8 20.2 32.5 6.8 5.8 15.2 5.6 24.1 5.6l50.8 0c6.9 0 5.2-4.6 2.2-7.7-6.7-6.9-16.4-8.4-25.4-10.9-20.5-5.6-18.4-32.8-12.7-32.8 18.3 0 18.9 .6 34.9 .3 23.2-.3 30.2-1.7 48.3 5 9.7 3.6 19 13.1 25.1 21.7z"]
  };
  var faAppStoreIos = {
    prefix: 'fab',
    iconName: 'app-store-ios',
    icon: [448, 512, [], "f370", "M400 32L48 32C21.5 32 0 53.5 0 80L0 432c0 26.5 21.5 48 48 48l352 0c26.5 0 48-21.5 48-48l0-352c0-26.5-21.5-48-48-48zM127 384.5c-5.5 9.6-17.8 12.8-27.3 7.3-9.6-5.5-12.8-17.8-7.3-27.3l14.3-24.7c16.1-4.9 29.3-1.1 39.6 11.4L127 384.5zm138.9-53.9L84 330.6c-11 0-20-9-20-20s9-20 20-20l51 0 65.4-113.2-20.5-35.4c-5.5-9.6-2.2-21.8 7.3-27.3 9.6-5.5 21.8-2.2 27.3 7.3l8.9 15.4 8.9-15.4c5.5-9.6 17.8-12.8 27.3-7.3 9.6 5.5 12.8 17.8 7.3 27.3l-85.8 148.6 62.1 0c20.2 0 31.5 23.7 22.7 40zm98.1 0l-29 0 19.6 33.9c5.5 9.6 2.2 21.8-7.3 27.3-9.6 5.5-21.8 2.2-27.3-7.3-32.9-56.9-57.5-99.7-74-128.1-16.7-29-4.8-58 7.1-67.8 13.1 22.7 32.7 56.7 58.9 102l52 0c11 0 20 9 20 20 0 11.1-9 20-20 20z"]
  };
  var faSquareDribbble = {
    prefix: 'fab',
    iconName: 'square-dribbble',
    icon: [448, 512, ["dribbble-square"], "f397", "M165.9 132.5c-38.3 18-66.8 53.3-75.7 95.7 6.1 .1 62.4 .3 126.4-16.7-22.7-40.2-47.1-74.1-50.7-79zm26.1-9.1c3.8 5.1 28.6 38.9 51 80 48.6-18.3 69.1-45.9 71.6-49.4-33.6-29.8-79.3-41.1-122.6-30.6zM277.4 382c-2-12-10-53.8-29.2-103.6-55.1 18.8-93.8 56.4-108.1 85.6 40.5 31.6 93.3 36.7 137.3 18zM227.8 232.6C159.6 253 93.4 252.2 87.4 252l0 4.2c0 35.1 13.3 67.1 35.1 91.4 22.2-37.9 67.1-77.9 116.5-91.8-3.4-7.8-7.2-15.5-11.1-23.2l-.1 0zm72.5 136.9c30.7-20.7 52.5-53.6 58.6-91.6-4.6-1.5-42.3-12.7-85.1-5.8 17.9 49.1 25.1 89.1 26.5 97.4zm-34.8-119c45.5-5.7 90.7 3.4 95.2 4.4-.3-32.3-11.8-61.9-30.9-85.1-2.9 3.9-25.8 33.2-76.3 53.9 4.8 9.8 8.3 17.8 12 26.8zM384 32L64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64zM224 96a160 160 0 1 1 0 320 160 160 0 1 1 0-320z"]
  };
  var faDribbbleSquare = faSquareDribbble;
  var faUikit = {
    prefix: 'fab',
    iconName: 'uikit',
    icon: [448, 512, [], "f403", "M443.9 128l0 256-225.9 128-218-128 0-214.3 87.6 45.1 0 117 133.5 75.5 135.8-75.5 0-151-101.1-57.6 87.6-53.1 100.5 57.9zM308.6 49.1l-84.8-49.1-88.6 54.8 86 47.3 87.4-53z"]
  };
  var faSuperpowers = {
    prefix: 'fab',
    iconName: 'superpowers',
    icon: [448, 512, [], "f2dd", "M448 32c-83.3 11-166.8 22-250 33-92 12.5-163.3 86.7-169 180-3.3 55.5 18 109.5 57.8 148.2L0 480c83.3-11 166.5-22 249.8-33 91.8-12.5 163.3-86.8 168.7-179.8 3.5-55.5-18-109.5-57.7-148.2L448 32zM368.3 264.3c-4.2 79.5-74 139.2-152.8 134.5-79.5-4.7-140.7-71-136.3-151 4.5-79.2 74.3-139.3 153-134.5 79.3 4.7 140.5 71 136.1 151z"]
  };
  var faYoutube = {
    prefix: 'fab',
    iconName: 'youtube',
    icon: [576, 512, [61802], "f167", "M549.7 124.1C543.5 100.4 524.9 81.8 501.4 75.5 458.9 64 288.1 64 288.1 64S117.3 64 74.7 75.5C51.2 81.8 32.7 100.4 26.4 124.1 15 167 15 256.4 15 256.4s0 89.4 11.4 132.3c6.3 23.6 24.8 41.5 48.3 47.8 42.6 11.5 213.4 11.5 213.4 11.5s170.8 0 213.4-11.5c23.5-6.3 42-24.2 48.3-47.8 11.4-42.9 11.4-132.3 11.4-132.3s0-89.4-11.4-132.3zM232.2 337.6l0-162.4 142.7 81.2-142.7 81.2z"]
  };
  var faEmber = {
    prefix: 'fab',
    iconName: 'ember',
    icon: [640, 512, [], "f423", "M639.9 254.6c-1.1-10.7-10.7-6.8-10.7-6.8s-15.6 12.1-29.3 10.7c-13.7-1.3-9.4-32-9.4-32s3-28.1-5.1-30.4c-8.1-2.4-18 7.3-18 7.3s-12.4 13.7-18.3 31.2l-1.6 .5s1.9-30.6-.3-37.6c-1.6-3.5-16.4-3.2-18.8 3s-14.2 49.2-15 67.2c0 0-23.1 19.6-43.3 22.8s-25-9.4-25-9.4 54.8-15.3 52.9-59.1-44.2-27.6-49-24c-4.6 3.5-29.4 18.4-36.6 59.7-.2 1.4-.7 7.5-.7 7.5s-21.2 14.2-33 18c0 0 33-55.6-7.3-80.9-11.4-6.8-21.3-.5-27.2 5.3 13.6-17.3 46.4-64.2 36.9-105.2-5.8-24.4-18-27.1-29.2-23.1-17 6.7-23.5 16.7-23.5 16.7s-22 32-27.1 79.5-12.6 105.1-12.6 105.1-10.5 10.2-20.2 10.7-5.4-28.7-5.4-28.7 7.5-44.6 7-52.1-1.1-11.6-9.9-14.2c-8.9-2.7-18.5 8.6-18.5 8.6s-25.5 38.7-27.7 44.6l-1.3 2.4-1.3-1.6s18-52.7 .8-53.5-28.5 18.8-28.5 18.8-19.6 32.8-20.4 36.5l-1.3-1.6s8.1-38.2 6.4-47.6c-1.6-9.4-10.5-7.5-10.5-7.5s-11.3-1.3-14.2 5.9-13.7 55.3-15 70.7c0 0-28.2 20.2-46.8 20.4-18.5 .3-16.7-11.8-16.7-11.8s68-23.3 49.4-69.2c-8.3-11.8-18-15.5-31.7-15.3-13.7 .3-30.3 8.6-41.3 33.3-5.3 11.8-6.8 23-7.8 31.5 0 0-12.3 2.4-18.8-2.9s-10 0-10 0-11.2 14-.1 18.3 28.1 6.1 28.1 6.1c1.6 7.5 6.2 19.5 19.6 29.7 20.2 15.3 58.8-1.3 58.8-1.3l15.9-8.8s.5 14.6 12.1 16.7 16.4 1 36.5-47.9c11.8-25 12.6-23.6 12.6-23.6l1.3-.3s-9.1 46.8-5.6 59.7C187.7 319.4 203 318 203 318s8.3 2.4 15-21.2 19.6-49.9 19.6-49.9l1.6 0s-5.6 48.1 3 63.7 30.9 5.3 30.9 5.3 15.6-7.8 18-10.2c0 0 18.5 15.8 44.6 12.9 58.3-11.5 79.1-25.9 79.1-25.9s10 24.4 41.1 26.7c35.5 2.7 54.8-18.6 54.8-18.6s-.3 13.5 12.1 18.6 20.7-22.8 20.7-22.8l20.7-57.2 1.9 0s1.1 37.3 21.5 43.2 47-13.7 47-13.7 6.4-3.5 5.3-14.3zm-578 5.3c.8-32 21.8-45.9 29-39 7.3 7 4.6 22-9.1 31.4-13.7 9.5-19.9 7.6-19.9 7.6zM334.7 136.1s19.1-49.7 23.6-25.5-40 96.2-40 96.2c.5-16.2 16.4-70.7 16.4-70.7zm22.8 138.4c-12.6 33-43.3 19.6-43.3 19.6s-3.5-11.8 6.4-44.9 33.3-20.2 33.3-20.2 16.2 12.4 3.6 45.5zm84.6-14.6s-3-10.5 8.1-30.6c11-20.2 19.6-9.1 19.6-9.1s9.4 10.2-1.3 25.5-26.4 14.2-26.4 14.2z"]
  };
  var faBootstrap = {
    prefix: 'fab',
    iconName: 'bootstrap',
    icon: [576, 512, [], "f836", "M333.5 201.4c0-22.1-15.6-34.3-43-34.3l-50.4 0 0 71.2 42.5 0c32.8-.1 50.9-13.3 50.9-36.9zM517 188.6c-9.5-30.9-10.9-68.8-9.8-98.1 1.1-30.5-22.7-58.5-54.7-58.5L123.7 32c-32.1 0-55.8 28.1-54.7 58.5 1 29.3-.3 67.2-9.8 98.1-9.6 31-25.7 50.6-52.2 53.1l0 28.5c26.4 2.5 42.6 22.1 52.2 53.1 9.5 30.9 10.9 68.8 9.8 98.1-1.1 30.5 22.7 58.5 54.7 58.5l328.7 0c32.1 0 55.8-28.1 54.7-58.5-1-29.3 .3-67.2 9.8-98.1 9.6-31 25.7-50.6 52.1-53.1l0-28.5c-26.3-2.5-42.5-22.1-52-53.1zM300.2 375.1l-97.9 0 0-238.3 97.4 0c43.3 0 71.7 23.4 71.7 59.4 0 25.3-19.1 47.9-43.5 51.8l0 1.3c33.2 3.6 55.5 26.6 55.5 58.3 0 42.1-31.3 67.5-83.2 67.5zm-10-108.7l-50.1 0 0 78.4 52.3 0c34.2 0 52.3-13.7 52.3-39.5 0-25.7-18.6-38.9-54.5-38.9z"]
  };
  var faItunes = {
    prefix: 'fab',
    iconName: 'itunes',
    icon: [448, 512, [], "f3b4", "M223.6 80.3a171.3 171.3 0 1 0 .2 342.5 171.3 171.3 0 1 0 -.2-342.5zm79.4 240c-3.2 13.6-13.5 21.2-27.3 23.8-12.1 2.2-22.2 2.8-31.9-5-11.8-10-12-26.4-1.4-36.8 8.4-8 20.3-9.6 38-12.8 3-.5 5.6-1.2 7.7-3.7 3.2-3.6 2.2-2 2.2-80.8 0-5.6-2.7-7.1-8.4-6.1-4 .7-91.9 17.1-91.9 17.1-5 1.1-6.7 2.6-6.7 8.3 0 116.1 .5 110.8-1.2 118.5-2.1 9-7.6 15.8-14.9 19.6-8.3 4.6-23.4 6.6-31.4 5.2-21.4-4-28.9-28.7-14.4-42.9 8.4-8 20.3-9.6 38-12.8 3-.5 5.6-1.2 7.7-3.7 5-5.7 .9-127 2.6-133.7 .4-2.6 1.5-4.8 3.5-6.4 2.1-1.7 5.8-2.7 6.7-2.7 101-19 113.3-21.4 115.1-21.4 5.7-.4 9 3 9 8.7-.1 170.6 .4 161.4-1 167.6zM345.2 32L102.8 32C45.9 32 0 77.9 0 134.8L0 377.2C0 434.1 45.9 480 102.8 480l242.4 0c57 0 102.8-45.9 102.8-102.8l0-242.4C448 77.9 402.1 32 345.2 32zM223.6 59a192.5 192.5 0 1 1 0 385 192.5 192.5 0 1 1 0-385z"]
  };
  var faSquareXing = {
    prefix: 'fab',
    iconName: 'square-xing',
    icon: [448, 512, ["xing-square"], "f169", "M448 96c0-35.3-28.7-64-64-64L64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320zM93.8 320.2c-5.5 0-8.7-5.3-6-10.3l49.3-86.7c.1 0 .1-.1 0-.2l-31.4-54c-3-5.6 .2-10.1 6-10.1l46.6 0c5.2 0 9.5 2.9 12.9 8.7l31.9 55.3c-1.3 2.3-18 31.7-50.1 88.2-3.5 6.2-7.7 9.1-12.6 9.1l-46.6 0zm163.5-33.4l0 .2 65.5 119c2.8 5.1 .1 10.1-6 10.1l-46.6 0c-5.5 0-9.7-2.9-12.9-8.7l-66-120.3c1.8-3.2 22.9-40.4 63.3-111.6 11.7-20.7 25.1-44.3 40.1-70.8 3.3-5.8 7.4-8.7 12.5-8.7l46.9 0c5.7-.1 8.8 4.7 6 10L257.3 286.8z"]
  };
  var faXingSquare = faSquareXing;
  var faCss3Alt = {
    prefix: 'fab',
    iconName: 'css3-alt',
    icon: [384, 512, [], "f38b", "M0 32L34.9 427.8 192 480 349.1 427.8 384 32 0 32zm313.1 80l-4.8 47.3-115.3 49.3-.3 .1 111.5 0-12.8 146.6-98.2 28.7-98.8-29.2-6.4-73.9 48.9 0 3.2 38.3 52.6 13.3 54.7-15.4 3.7-61.6-166.3-.5 0-.1-.2 .1-3.6-46.3 112.1-46.7 6.5-2.7-122.9 0-5.8-47.3 242.2 0z"]
  };
  var faSquarespace = {
    prefix: 'fab',
    iconName: 'squarespace',
    icon: [512, 512, [], "f5be", "M186.1 343.3c-9.7 9.7-9.7 25.3 0 34.9s25.3 9.6 34.9 0L378.3 221.1c19.3-19.3 50.6-19.3 69.9 0s19.3 50.6 0 69.9L294 445.1c19.3 19.3 50.5 19.3 69.8 0l0 0 119.3-119.2c38.6-38.6 38.6-101.1 0-139.7-38.6-38.6-101.2-38.6-139.7 0L186.1 343.3zM430.7 238.5c-9.7-9.7-25.3-9.7-34.9 0L238.5 395.7c-19.3 19.3-50.5 19.3-69.8 0l0 0c-9.6-9.6-25.3-9.7-34.9 0l0 0c-9.7 9.6-9.7 25.3 0 34.9l0 0c38.6 38.6 101.1 38.6 139.7 0L430.7 273.5c9.6-9.7 9.6-25.3 0-34.9zm-262 87.3L325.9 168.7c9.6-9.6 9.6-25.3 0-34.9-9.6-9.6-25.3-9.6-34.9 0L133.7 290.9c-19.3 19.3-50.6 19.3-69.9 0l0 0c-19.3-19.3-19.3-50.5 0-69.8l0 0 154.2-154.2c-19.3-19.3-50.5-19.3-69.8 0l0 0-119.2 119.3c-38.6 38.6-38.6 101.1 0 139.7 38.6 38.6 101.1 38.6 139.7 0zM81.3 273.5c9.6 9.6 25.3 9.6 34.9 0L273.5 116.3c19.3-19.3 50.6-19.3 69.8 0l0 0c9.7 9.6 25.3 9.6 34.9 0s9.6-25.3 0-34.9c-38.6-38.6-101.1-38.6-139.7 0L81.3 238.5c-9.6 9.6-9.6 25.3 0 34.9l0 0z"]
  };
  var faTrello = {
    prefix: 'fab',
    iconName: 'trello',
    icon: [448, 512, [], "f181", "M392.3 32L56.1 32c-31 0-56.1 25.1-56.1 56-.1 0 0-4 0 336 0 30.9 25.1 56 56 56l336.2 0c30.8-.2 55.7-25.2 55.7-56l0-336c.1-30.8-24.8-55.8-55.6-56zM197 371.3c-.2 14.7-12.1 26.6-26.9 26.6l-82.7 0c-14.8 .1-26.9-11.8-27-26.6l0-254.2c0-14.8 12-26.9 26.9-26.9l82.9 0c14.8 0 26.9 12 26.9 26.9l0 254.2-.1 0zm193.1-112c0 14.8-12 26.9-26.9 26.9l-81 0c-14.8 0-26.9-12-26.9-26.9l0-142.1c0-14.8 12-26.9 26.8-26.9l81.1 0c14.8 0 26.9 12 26.9 26.9l0 142.1z"]
  };
  var faViadeo = {
    prefix: 'fab',
    iconName: 'viadeo',
    icon: [448, 512, [], "f2a9", "M276.4 150.5l0 .7c-17.9-52.6-42.6-103.4-70.8-151.2 43.3 29.2 67 100 70.8 150.5zm32.7 121.7c7.6 18.2 11 37.5 11 57 0 77.7-57.8 141-137.8 139.4l3.8-.3c74.2-46.7 109.3-118.6 109.3-205.1 0-38.1-6.5-75.9-18.9-112 1 11.7 1 23.7 1 35.4 0 91.8-18.1 241.6-116.6 280-65.7-11.4-111.3-68.6-111.3-137.4 0-75.6 57.4-142.3 135.4-142.3 16.8 0 33.7 3.1 49.1 9.6 1.7-15.1 6.5-29.9 13.4-43.3-19.9-7.2-41.2-10.7-62.5-10.7-161.5 0-238.7 195.9-129.9 313.7 67.9 74.6 192 73.9 259.8 0 56.6-61.3 60.9-142.4 36.4-201-12.7 8-27.1 13.9-42.2 17zM418.3 11.7c-31 66.5-81.3 47.2-115.8 80.1-12.4 12-20.6 34-20.6 50.5 0 14.1 4.5 27.1 12 38.8 47.4-11 98.3-46 118.2-90.7-.7 5.5-4.8 14.4-7.2 19.2-20.3 35.7-64.6 65.6-99.7 84.9 14.8 14.4 33.7 25.8 55 25.8 79 0 110.1-134.6 58.1-208.6z"]
  };
  var faSearchengin = {
    prefix: 'fab',
    iconName: 'searchengin',
    icon: [448, 512, [], "f3eb", "M214.6 130.3l-67.2 28.2 0-115.3-54.7 190.3 54.7-24.2 0 130.3 67.2-209.3zM131.4 33.6l-1.3 4.7-15.2 52.9C74.6 106.7 46 145.8 46 191.5 46 243.8 80.3 287.4 129.4 297l0 53.6C51.5 340.1-6 272.4-6 191.6-6 111.1 53.8 44.4 131.4 33.6zM442.8 480.8c-11.2 11.2-23.1 12.3-28.6 10.5-5.4-1.8-27.1-19.9-60.4-44.4-33.3-24.6-33.6-35.7-43-56.7-9.4-20.9-30.4-42.6-57.5-52.4l-9.7-14.7c-24.7 16.9-53 26.9-81.3 28.7l2.1-6.6 15.9-49.5c46.5-11.9 80.9-54 80.9-104.2 0-54.5-38.4-102.1-96-107.1l0-52.1c83.2 5.1 148.8 74.5 148.8 159.3 0 33.6-11.2 64.7-29 90.4l14.6 9.6c9.8 27.1 31.5 48 52.4 57.4s32.2 9.7 56.8 43c24.6 33.2 42.7 54.9 44.5 60.3s.7 17.3-10.5 28.5zm-9.9-17.9c0-4.4-3.6-8-8-8s-8 3.6-8 8 3.6 8 8 8 8-3.6 8-8z"]
  };
  var faPaypal = {
    prefix: 'fab',
    iconName: 'paypal',
    icon: [384, 512, [], "f1ed", "M111.9 295.9c-3.5 19.2-17.4 108.7-21.5 134-.3 1.8-1 2.5-3 2.5l-74.6 0c-7.6 0-13.1-6.6-12.1-13.9L59.3 46.6c1.5-9.6 10.1-16.9 20-16.9 152.3 0 165.1-3.7 204 11.4 60.1 23.3 65.6 79.5 44 140.3-21.5 62.6-72.5 89.5-140.1 90.3-43.4 .7-69.5-7-75.3 24.2zM357.6 152c-1.8-1.3-2.5-1.8-3 1.3-2 11.4-5.1 22.5-8.8 33.6-39.9 113.8-150.5 103.9-204.5 103.9-6.1 0-10.1 3.3-10.9 9.4-22.6 140.4-27.1 169.7-27.1 169.7-1 7.1 3.5 12.9 10.6 12.9l63.5 0c8.6 0 15.7-6.3 17.4-14.9 .7-5.4-1.1 6.1 14.4-91.3 4.6-22 14.3-19.7 29.3-19.7 71 0 126.4-28.8 142.9-112.3 6.5-34.8 4.6-71.4-23.8-92.6z"]
  };
  var faSquareBluesky = {
    prefix: 'fab',
    iconName: 'square-bluesky',
    icon: [448, 512, [], "e6a3", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zM224 247.4c14.5-30 54-85.8 90.7-113.3 26.5-19.9 69.3-35.2 69.3 13.7 0 9.8-5.6 82.1-8.9 93.8-11.4 40.8-53 51.2-90 44.9 64.7 11 81.2 47.5 45.6 84-67.5 69.3-97-17.4-104.6-39.6l-.3-.9c-.9-2.6-1.4-4.1-1.8-4.1s-.9 1.5-1.8 4.1c-.1 .3-.2 .6-.3 .9-7.6 22.2-37.1 108.8-104.6 39.6-35.5-36.5-19.1-73 45.6-84-37 6.3-78.6-4.1-90-44.9-3.3-11.7-8.9-84-8.9-93.8 0-48.9 42.9-33.5 69.3-13.7 36.7 27.5 76.2 83.4 90.7 113.3z"]
  };
  var faDAndDBeyond = {
    prefix: 'fab',
    iconName: 'd-and-d-beyond',
    icon: [640, 512, [], "f6ca", "M313.8 241.5c13.8 0 21-10.1 24.8-17.9-1-1.1-5-4.2-7.4-6.6-2.4 4.3-8.2 10.7-13.9 10.7-10.2 0-15.4-14.7-3.2-26.6-.5-.2-4.3-1.8-8 2.4 0-3 1-5.1 2.1-6.6-3.5 1.3-9.8 5.6-11.4 7.9 .2-5.8 1.6-7.5 .6-9l-.2-.2s-8.5 5.6-9.3 14.7c0 0 1.1-1.6 2.1-1.9 .6-.3 1.3 0 .6 1.9-.2 .6-5.8 15.7 5.1 26-.6-1.6-1.9-7.6 2.4-1.9-.3 .1 5.8 7.1 15.7 7.1zm52.4-21.1c0-4-4.9-4.4-5.6-4.5 2 3.9 .9 7.5 .2 9 2.5-.4 5.4-1.6 5.4-4.5zm10.3 5.2c0-6.4-6.2-11.4-13.5-10.7 8 1.3 5.6 13.8-5 11.4 3.7-2.6 3.2-9.9-1.3-12.5 1.4 4.2-3 8.2-7.4 4.6-2.4-1.9-8-6.6-10.6-8.6-2.4-2.1-5.5-1-6.6-1.8-1.3-1.1-.5-3.8-2.2-5-1.6-.8-3-.3-4.8-1-1.6-.6-2.7-1.9-2.6-3.5-2.5 4.4 3.4 6.3 4.5 8.5 1 1.9-.8 4.8 4 8.5 14.8 11.6 9.1 8 10.4 18.1 .6 4.3 4.2 6.7 6.4 7.4-2.1-1.9-2.9-6.4 0-9.3 0 13.9 19.2 13.3 23.1 6.4-2.4 1.1-7-.2-9-1.9 7.7 1 14.2-4.1 14.6-10.6zm-39.4-18.4c2 .8 1.6 .7 6.4 4.5 10.2-24.5 21.7-15.7 22-15.5 2.2-1.9 9.8-3.8 13.8-2.7-2.4-2.7-7.5-6.2-13.3-6.2-4.7 0-7.4 2.2-8 1.3-.8-1.4 3.2-3.4 3.2-3.4-5.4 .2-9.6 6.7-11.2 5.9-1.1-.5 1.4-3.7 1.4-3.7-5.1 2.9-9.3 9.1-10.2 13 4.6-5.8 13.8-9.8 19.7-9-10.5 .5-19.5 9.7-23.8 15.8zm242.5 51.9c-20.7 0-40 1.3-50.3 2.1l7.4 8.2 0 77.2-7.4 8.2c10.4 .8 30.9 2.1 51.6 2.1 42.1 0 59.1-20.7 59.1-48.9 0-29.3-23.2-48.9-60.4-48.9zm-15.1 75.6l0-53.3c30.1-3.3 46.8 3.8 46.8 26.3 0 25.6-21.4 30.2-46.8 27zM301.6 181c-1-3.4-.2-6.9 1.1-9.4 1 3 2.6 6.4 7.5 9-.5-2.4-.2-5.6 .5-8-1.4-5.4 2.1-9.9 6.4-9.9 6.9 0 8.5 8.8 4.7 14.4 2.1 3.2 5.5 5.6 7.7 7.8 3.2-3.7 5.5-9.5 5.5-13.8 0-8.2-5.5-15.9-16.7-16.5-20-.9-20.2 16.6-20 18.9 .5 5.2 3.4 7.8 3.3 7.5zm-.4 6c-.5 1.8-7 3.7-10.2 6.9 4.8-1 7-.2 7.8 1.8 .5 1.4-.2 3.4-.5 5.6 1.6-1.8 7-5.5 11-6.2-1-.3-3.4-.8-4.3-.8 2.9-3.4 9.3-4.5 12.8-3.7-2.2-.2-6.7 1.1-8.5 2.6 1.6 .3 3 .6 4.3 1.1-2.1 .8-4.8 3.4-5.8 6.1 7-5 13.1 5.2 7 8.2 .8 .2 2.7 0 3.5-.5-.3 1.1-1.9 3-3 3.4 2.9 0 7-1.9 8.2-4.6 0 0-1.8 .6-2.6-.2s.3-4.3 .3-4.3c-2.3 2.9-3.4-1.3-1.3-4.2-1-.3-3.5-.6-4.6-.5 3.2-1.1 10.4-1.8 11.2-.3 .6 1.1-1 3.4-1 3.4 4-.5 8.3 1.1 6.7 5.1 2.9-1.4 5.5-5.9 4.8-10.4-.3 1-1.6 2.4-2.9 2.7 .2-1.4-1-2.2-1.9-2.6 1.7-9.6-14.6-14.2-14.1-23.9-1 1.3-1.8 5-.8 7.1 2.7 3.2 8.7 6.7 10.1 12.2-2.6-6.4-15.1-11.4-14.6-20.2-1.6 1.6-2.6 7.8-1.3 11 2.4 1.4 4.5 3.8 4.8 6.1-2.2-5.1-11.4-6.1-13.9-12.2-.6 2.2-.3 5 1 6.7 0 0-2.2-.8-7-.6 1.7 .6 5.1 3.5 4.8 5.2zm25.9 7.4c-2.7 0-3.5-2.1-4.2-4.3 3.3 1.3 4.2 4.3 4.2 4.3zm38.9 3.7l-1-.6c-1.1-1-2.9-1.4-4.7-1.4-2.9 0-5.8 1.3-7.5 3.4-.8 .8-1.4 1.8-2.1 2.6l0 15.7c3.5 2.6 7.1-2.9 3-7.2 1.5 .3 4.6 2.7 5.1 3.2 0 0 2.6-.5 5-.5 2.1 0 3.9 .3 5.6 1.1l0-18.4c-1.1 .5-2.2 1-2.7 1.4l-.7 .7zM79.9 305.9c17.2-4.6 16.2-18 16.2-19.9 0-20.6-24.1-25-37-25l-56.1 0 8.3 8.6 0 29.5-11.3 0 11.4 14.6 0 32.3-8.4 8.6c61.7 0 73.8 1.5 86.4-5.9 6.7-4 9.9-9.8 9.9-17.6 0-5.1 2.6-18.8-19.4-25.2zM38.6 278.4c20 0 29.6-.8 29.6 9.1l0 3c0 12.1-19 8.8-29.6 8.8l0-20.9zm0 59.2l0-22.6c12.2 0 32.7-2.3 32.7 8.8l0 4.5 .2 0c0 11.2-12.5 9.3-32.9 9.3zm101.2-19.3l23.1 .2 0-.2 14.1-21.2-37.2 0 0-14.9 52.4 0-14.1-21 0-.2-73.5 .2 7.4 8.2 0 77.1-7.4 8.2 81.2 0 14.1-21.2-60.1 .2 0-15.4zm214.7-60.1c-73.9 0-77.5 99.3-.3 99.3 77.9 0 74.1-99.3 .3-99.3zm-.3 77.5c-37.4 0-36.9-55.3 .2-55.3 36.8 .1 38.8 55.3-.2 55.3zm-91.3-8.3l44.1-66.2-41.7 0 6.1 7.2-20.5 37.2-.3 0-21-37.2 6.4-7.2-44.9 0 44.1 65.8 .2 19.4-7.7 8.2 42.6 0-7.2-8.2-.2-19zM234.5 176.1c1.6 1.3 2.9 2.4 2.9 6.6l0 38.8c0 4.2-.8 5.3-2.7 6.4-.1 .1-7.5 4.5-7.9 4.6l35.1 0c10 0 17.4-1.5 26-8.6-.6-5 .2-9.5 .8-12 0-.2-1.8 1.4-2.7 3.5 0-5.7 1.6-15.4 9.6-20.5-.1 0-3.7-.8-9 1.1 2-3.1 10-7.9 10.4-7.9-8.2-26-38-22.9-32.2-22.9-30.9 0-32.6 .3-39.9-4 .1 .8 .5 8.2 9.6 14.9zm21.5 5.5c4.6 0 23.1-3.3 23.1 17.3 0 20.7-18.4 17.3-23.1 17.3l0-34.6zm228.9 79.6l7 8.3 0 42.5-.3 0c-5.4-14.4-42.3-41.5-45.2-50.9l-31.6 0 7.4 8.5 0 76.9-7.2 8.3 39 0-7.4-8.2 0-47.4 .3 0c3.7 10.6 44.5 42.9 48.5 55.6l21.3 0 0-85.2 7.4-8.3-39.2-.1zM378.2 165.1c-32.2 0-32.8 .2-39.9-4 .1 .7 .5 8.3 9.6 14.9 3.1 2 2.9 4.3 2.9 9.5 1.8-1.1 3.8-2.2 6.1-3-1.1 1.1-2.7 2.7-3.5 4.5 1-1.1 7.5-5.1 14.6-3.5-1.6 .3-4 1.1-6.1 2.9 .1 0 2.1-1.1 7.5-.3l0-4.3c4.7 0 23.1-3.4 23.1 17.3 0 20.5-18.5 17.3-19.7 17.3 5.7 4.4 5.8 12 2.2 16.3l.3 0c33.4 0 36.7-27.3 36.7-34 0-3.8-1.1-32-33.8-33.6z"]
  };
  var faMicrosoft = {
    prefix: 'fab',
    iconName: 'microsoft',
    icon: [448, 512, [], "f3ca", "M0 32l214.6 0 0 214.6-214.6 0 0-214.6zm233.4 0l214.6 0 0 214.6-214.6 0 0-214.6zM0 265.4l214.6 0 0 214.6-214.6 0 0-214.6zm233.4 0l214.6 0 0 214.6-214.6 0 0-214.6z"]
  };
  var faFly = {
    prefix: 'fab',
    iconName: 'fly',
    icon: [320, 512, [], "f417", "M165.9 427.8c12.9 11.7 33.7 33.3 33.2 50.7 0 .8-.1 1.6-.1 2.5-1.8 19.8-18.8 31.1-39.1 31-25-.1-39.9-16.8-38.7-35.8 1-16.2 20.5-36.7 32.4-47.6 2.3-2.1 2.7-2.7 5.6-3.6 3.4 0 3.9 .3 6.7 2.8zM300 67.3c-16.3-25.7-38.6-40.6-63.3-52.1-25.5-10.7-54.6-15.4-76.6-15.2-44.1 0-71.2 13.2-81.1 17.3-53.6 27.9-84.4 69.9-82.9 141.3 7.1 82.2 97 176 155.8 233.8 1.7 1.6 4.5 4.5 6.2 5.1l3.3 .1c2.1-.7 1.8-.5 3.5-2.1 52.3-49.2 140.7-145.8 155.9-215.7 7-39.2 3.1-72.5-20.8-112.5zM154.9 351.9c-28-51.1-65.2-130.7-69.3-189-3.4-47.5 11.4-131.2 69.3-136.7l0 325.7zM296.8 180c-16.4 56.8-77.3 128-118.9 170.3 27.8-51.9 65.2-133.3 67.2-191.9 1.6-45.9-9.8-105.8-48-131.4 88.8 18.3 115.5 98.1 99.7 153z"]
  };
  var faCcStripe = {
    prefix: 'fab',
    iconName: 'cc-stripe',
    icon: [576, 512, [], "f1f5", "M492.4 220.8c-8.9 0-18.7 6.7-18.7 22.7l36.7 0c0-16-9.3-22.7-18-22.7zM375 223.4c-8.2 0-13.3 2.9-17 7l.2 52.8c3.5 3.7 8.5 6.7 16.8 6.7 13.1 0 21.9-14.3 21.9-33.4 0-18.6-9-33.2-21.9-33.1zM528 32L48 32C21.5 32 0 53.5 0 80L0 432c0 26.5 21.5 48 48 48l480 0c26.5 0 48-21.5 48-48l0-352c0-26.5-21.5-48-48-48zM122.2 281.1c0 25.6-20.3 40.1-49.9 40.3-12.2 0-25.6-2.4-38.8-8.1l0-33.9c12 6.4 27.1 11.3 38.9 11.3 7.9 0 13.6-2.1 13.6-8.7 0-17-54-10.6-54-49.9 0-25.2 19.2-40.2 48-40.2 11.8 0 23.5 1.8 35.3 6.5l0 33.4c-10.8-5.8-24.5-9.1-35.3-9.1-7.5 0-12.1 2.2-12.1 7.7 0 16 54.3 8.4 54.3 50.7zM191 224.5l-27 0 0 50.5c0 20.9 22.5 14.4 27 12.6l0 28.9c-4.7 2.6-13.3 4.7-24.9 4.7-21.1 0-36.9-15.5-36.9-36.5l.2-113.9 34.7-7.4 0 30.8 26.9 0 0 30.3zm74 2.4c-4.5-1.5-18.7-3.6-27.1 7.4l0 84.4-35.5 0 0-124.5 30.7 0 2.2 10.5c8.3-15.3 24.9-12.2 29.6-10.5l.1 0 0 32.7zm44.1 91.8l-35.7 0 0-124.5 35.7 0 0 124.5zm0-142.9l-35.7 7.6 0-28.9 35.7-7.6 0 28.9zm74.1 145.5c-12.4 0-20-5.3-25.1-9l-.1 40.2-35.5 7.5 0-165.8 31.3 0 1.8 8.8c4.9-4.5 13.9-11.1 27.8-11.1 24.9 0 48.4 22.5 48.4 63.8 0 45.1-23.2 65.5-48.6 65.6zm160.4-51.5l-69.5 0c1.6 16.6 13.8 21.5 27.6 21.5 14.1 0 25.2-3 34.9-7.9l0 28.6c-9.7 5.3-22.4 9.2-39.4 9.2-34.6 0-58.8-21.7-58.8-64.5 0-36.2 20.5-64.9 54.3-64.9 33.7 0 51.3 28.7 51.3 65.1 0 3.5-.3 10.9-.4 12.9z"]
  };
  var faWordpressSimple = {
    prefix: 'fab',
    iconName: 'wordpress-simple',
    icon: [512, 512, [], "f411", "M256 8a248 248 0 1 0 0 496 248 248 0 1 0 0-496zM33 256c0-32.3 6.9-63 19.3-90.7L158.7 456.7C84.3 420.5 33 344.2 33 256zM256 479c-21.9 0-43-3.2-63-9.1l66.9-194.4 68.5 187.8c.5 1.1 1 2.1 1.6 3.1-23.1 8.1-48 12.6-74 12.6zm30.7-327.5c13.4-.7 25.5-2.1 25.5-2.1 12-1.4 10.6-19.1-1.4-18.4 0 0-36.1 2.8-59.4 2.8-21.9 0-58.7-2.8-58.7-2.8-12-.7-13.4 17.7-1.4 18.4 0 0 11.4 1.4 23.4 2.1l34.7 95.2-48.8 146.3-81.2-241.5c13.4-.7 25.5-2.1 25.5-2.1 12-1.4 10.6-19.1-1.4-18.4 0 0-36.1 2.8-59.4 2.8-4.2 0-9.1-.1-14.4-.3 39.9-60.5 108.4-100.5 186.3-100.5 58 0 110.9 22.2 150.6 58.5-1-.1-1.9-.2-2.9-.2-21.9 0-37.4 19.1-37.4 39.6 0 18.4 10.6 33.9 21.9 52.3 8.5 14.8 18.4 33.9 18.4 61.5 0 19.1-7.3 41.2-17 72.1l-22.2 74.3-80.7-239.6zm81.4 297.2l68.1-196.9c12.7-31.8 17-57.2 17-79.9 0-8.2-.5-15.8-1.5-22.9 17.4 31.8 27.3 68.2 27.3 107 0 82.3-44.6 154.1-110.9 192.7z"]
  };
  var faSellsy = {
    prefix: 'fab',
    iconName: 'sellsy',
    icon: [640, 512, [], "f213", "M540 237.3c3.1-12.3 4.3-24.8 4.3-37.4 0-92.5-75.4-167.9-167.9-167.9-77.2 0-144.6 53-163 127.8-15.3-13.2-34.9-20.5-55.2-20.5-46.3 0-84 37.7-84 84 0 7.4 .9 15 3.1 22.4-42.9 20.2-70.8 63.7-70.8 111.2 0 68 55.5 123.2 123.2 123.2l381.2 0c67.7 0 123.2-55.2 123.2-123.2 0-56.4-38.9-106-94.1-119.5zM200.2 401.6c0 8.3-7 15.3-15.3 15.3l-30.9 0c-8.3 0-15.3-7-15.3-15.3l0-110.9c0-8.3 7-15.3 15.3-15.3l30.9 0c8.3 0 15.3 7 15.3 15.3l0 110.9zm89.5 0c0 8.3-7 15.3-15.3 15.3l-30.9 0c-8.3 0-15.3-7-15.3-15.3l0-131.5c0-8.3 7-15.3 15.3-15.3l30.9 0c8.3 0 15.3 7 15.3 15.3l0 131.5zm89.5 0c0 8.3-7 15.3-15.3 15.3l-31 0c-8.3 0-15.3-7-15.3-15.3l0-162.7c0-8.3 7-15.3 15.3-15.3l31 0c8.3 0 15.3 7 15.3 15.3l0 162.7zm87 0c0 8.3-7 15.3-15.3 15.3l-28.5 0c-8.3 0-15.3-7-15.3-15.3l0-224.6c0-8.6 7-15.6 15.3-15.6l28.5 0c8.3 0 15.3 7 15.3 15.6l0 224.6z"]
  };
  var faDashcube = {
    prefix: 'fab',
    iconName: 'dashcube',
    icon: [448, 512, [], "f210", "M326.9 104l-216.2 0c-51.1 0-91.2 43.3-91.2 93.5l0 229.5c0 50.5 40.1 85 91.2 85l227.2 0c51.1 0 91.2-34.5 91.2-85l0-427-102.2 104zM154.2 416.5c-17.7 0-32.4-15.1-32.4-32.8l0-142.9c0-17.7 14.7-32.5 32.4-32.5l140.7 0c17.7 0 32 14.8 32 32.5l0 123.5 51.1 52.3-223.8 0 0-.1z"]
  };
  var faGitter = {
    prefix: 'fab',
    iconName: 'gitter',
    icon: [384, 512, [], "f426", "M66.4 322.5l-50.4 0 0-322.5 50.4 0 0 322.5zM166.9 76.1l-50.4 0 0 435.9 50.4 0 0-435.9zm100.6 0l-50.4 0 0 435.9 50.4 0 0-435.9zM368 76l-50.4 0 0 247 50.4 0 0-247z"]
  };
  var faWolfPackBattalion = {
    prefix: 'fab',
    iconName: 'wolf-pack-battalion',
    icon: [448, 512, [], "f514", "M236.2 471.5l10.6 15.8 5.3-12.3 5.3 7 0 29.9c21.1-7.9 21.1-66.9 25.5-97.2 4.6-31.9-.9-92.8 81.4-149.1-8.9-23.6-12-49.4-2.6-80 27.9 3.4 53.9 10.6 63.3 54.1l-30.3 8.4c11.1 23 17 46.8 13.2 72.1l-27.3-7-6.2 33.4-18.5-7-8.8 33.4-19.4-7 26.4 21.1 8.8-28.2 24.6 5.2 7-35.6 26.4 14.5c.2-20 7-58.1-8.8-84.5l26.4 5.3c4-22.1-2.4-39.2-7.9-56.7l22.4 9.7c-.4-25.1-29.9-56.8-61.6-58.5-20.2-1.1-56.7-25.2-54.1-51.9 2-19.9 17.4-42.6 43.1-49.7-44 36.5-9.7 67.3 5.3 73.5 4.4-11.4 17.5-69.1 0-130.2-40.4 22.9-89.7 65.1-93.2 147.8l-58 38.7-3.5 93.2 107.3-59.8 7 7-17.6 3.5-44 38.7-15.8-5.3-28.1 49.3-3.5 119.6 21.1 15.8-32.5 15.8-32.6-15.8 21.1-15.8-3.5-119.6-28.2-49.3-15.8 5.3-44-38.7-17.6-3.5 7-7 107.3 59.8-3.5-93.3-58.1-38.7c-3.5-82.8-52.7-125-93.2-147.9-17.5 61.1-4.4 118.8 0 130.2 15-6.2 49.3-37 5.3-73.5 25.7 7.1 41.1 29.8 43.1 49.7 2.6 26.7-33.9 50.8-54.1 51.9-31.7 1.7-61.2 33.4-61.6 58.5l22.4-9.7C13.4 224.7 7 241.8 11 263.9l26.4-5.3c-15.8 26.4-9.1 64.4-8.8 84.4l26.4-14.5 7 35.6 24.6-5.3 8.8 28.2 26.4-21.1-19.4 7-8.8-33.4-18.5 7-6.2-33.4-27.3 7C38 294.8 43.8 271 55 248l-30.3-8.4c9.4-43.5 35.5-50.8 63.3-54.1 9.4 30.6 6.2 56.5-2.6 80.1 82.3 56.3 76.8 117.2 81.4 149.1 4.4 30.3 4.4 89.3 25.5 97.2l0-29.8 5.3-7 5.3 12.3 10.6-15.8 11.4 21.1 11.4-21.1 0 0zm79.2-95L299.5 366c7.5-4.4 13.8-8.4 19.4-12.3-.6 7.2-.3 13.8-3.5 22.8l0 0zm28.2-49.3c-.4 10.9-.9 21.7-1.8 31.7-7.8-1.9-15.6-3.8-21.1-7 8.2-7.9 15.6-16.3 22.9-24.7l0 0zm24.6 5.3c0-13.4-2.1-24.2-5.3-33.4-5.5 9.5-11.7 18.6-18.5 27.3l23.8 6.2zm3.5-80.9c19.4 12.8 27.8 33.7 29.9 56.3-12.3-4.5-24.6-9.3-37-10.6 5.1-12 6.6-28.1 7-45.7l0 0zm-1.8-45.7c.8 14.3 1.8 28.8 1.8 42.2 19.2-8.1 29.8-9.7 44-14.1-10.6-19-27.2-25.5-45.8-28.2l0 0zM134.2 376.5L150 366c-7.5-4.4-13.8-8.4-19.4-12.3 .6 7.3 .3 13.9 3.5 22.9l0 0zM106 327.3c.4 10.9 .9 21.7 1.8 31.7 7.8-1.9 15.6-3.8 21.1-7-8.2-7.9-15.6-16.3-22.9-24.7zm-24.6 5.3c0-13.4 2-24.2 5.3-33.4 5.5 9.5 11.7 18.6 18.5 27.3l-23.8 6.2zm-3.5-80.9c-19.4 12.8-27.8 33.7-29.9 56.3 12.3-4.5 24.6-9.3 37-10.6-5-12-6.6-28.1-7-45.7l-.1 0zm1.8-45.7c-.8 14.3-1.8 28.8-1.8 42.2-19.2-8.1-29.8-9.7-44-14.1 10.6-19 27.2-25.5 45.8-28.1z"]
  };
  var faLastfm = {
    prefix: 'fab',
    iconName: 'lastfm',
    icon: [512, 512, [], "f202", "M225.8 367.1l-18.8-51s-30.5 34-76.2 34c-40.5 0-69.2-35.2-69.2-91.5 0-72.1 36.4-97.9 72.1-97.9 66.5 0 74.8 53.3 100.9 134.9 18.8 56.9 54 102.6 155.4 102.6 72.7 0 122-22.3 122-80.9 0-72.9-62.7-80.6-115-92.1-25.8-5.9-33.4-16.4-33.4-34 0-19.9 15.8-31.7 41.6-31.7 28.2 0 43.4 10.6 45.7 35.8l58.6-7c-4.7-52.8-41.1-74.5-100.9-74.5-52.8 0-104.4 19.9-104.4 83.9 0 39.9 19.4 65.1 68 76.8 44.9 10.6 79.8 13.8 79.8 45.7 0 21.7-21.1 30.5-61 30.5-59.2 0-83.9-31.1-97.9-73.9-32-96.8-43.6-163-161.3-163-86.1 0-131.8 54.5-131.8 147.2 0 89.1 45.7 137.2 127.9 137.2 66.2 0 97.9-31.1 97.9-31.1z"]
  };
  var faShopware = {
    prefix: 'fab',
    iconName: 'shopware',
    icon: [512, 512, [], "f5b5", "M403.5 455.4c-42.6 31.7-94.4 48.7-147.5 48.6-137.2 0-248-111-248-248 0-137.2 111-248 248-248 61.2-.1 120.2 22.6 165.7 63.5 .6 .5 .9 1.2 1.1 1.9s.1 1.5-.3 2.2-.8 1.3-1.5 1.6-1.4 .5-2.2 .4c-18.8-2.5-37.7-3.7-56.7-3.7-129.4 0-222.4 53.5-222.4 155.4 0 109 92.1 145.9 176.8 178.7 33.6 13 65.4 25.4 87 41.6 .4 .3 .8 .8 1.1 1.3s.4 1 .4 1.6-.1 1.1-.4 1.6-.6 .9-1.1 1.3l-.1 0zM503 233.1c-.1-.9-.5-1.8-1.3-2.4-51.8-43-93.6-60.5-144.5-60.5-84.1 0-80.3 52.2-80.3 53.6 0 42.6 52.1 62 112.3 84.5 31.1 11.6 63.2 23.6 92.7 39.9 .4 .2 .9 .4 1.4 .4s1 0 1.5-.2 .9-.4 1.3-.8 .6-.8 .8-1.2c14.1-36 19.5-74.8 16-113.3z"]
  };
  var faBlogger = {
    prefix: 'fab',
    iconName: 'blogger',
    icon: [448, 512, [], "f37c", "M162.4 196c4.8-4.9 6.2-5.1 36.4-5.1 27.2 0 28.1 .1 32.1 2.1 5.8 2.9 8.3 7 8.3 13.6 0 5.9-2.4 10-7.6 13.4-2.8 1.8-4.5 1.9-31.1 2.1-16.4 .1-29.5-.2-31.5-.8-10.3-2.9-14.1-17.7-6.6-25.3zm61.4 94.5c-53.9 0-55.8 .2-60.2 4.1-3.5 3.1-5.7 9.4-5.1 13.9 .7 4.7 4.8 10.1 9.2 12 2.2 1 14.1 1.7 56.3 1.2l47.9-.6 9.2-1.5c9-5.1 10.5-17.4 3.1-24.4-5.3-4.7-5-4.7-60.4-4.7zM447.2 420.6c-3.5 28.4-23 50.4-51.1 57.5-7.2 1.8-9.7 1.9-172.9 1.8-157.8 0-165.9-.1-172-1.8-8.4-2.2-15.6-5.5-22.3-10-5.6-3.8-13.9-11.8-17-16.4-3.8-5.6-8.2-15.3-10-22S0 420.3 0 256.3c0-163.1 0-166.6 1.8-173.7 6.3-24.7 25.9-43.6 51.2-49.2 7.3-1.6 332.1-1.9 340-.3 21.2 4.3 37.9 17.1 47.6 36.4 7.7 15.3 7-1.5 7.3 180.6 .2 115.8 0 164.5-.7 170.5zM361.8 235.4c-1.1-5-4.2-9.6-7.7-11.5-1.1-.6-8-1.3-15.5-1.7-12.4-.6-13.8-.8-17.8-3.1-6.2-3.6-7.9-7.6-8-18.3 0-20.4-8.5-39.4-25.3-56.5-12-12.2-25.3-20.5-40.6-25.1-3.6-1.1-11.8-1.5-39.2-1.8-42.9-.5-52.5 .4-67.1 6.2-27 10.7-46.3 33.4-53.4 62.4-1.3 5.4-1.6 14.2-1.9 64.3-.4 62.8 0 72.1 4 84.5 9.7 30.7 37.1 53.4 64.6 58.4 9.2 1.7 122.2 2.1 133.7 .5 20.1-2.7 35.9-10.8 50.7-25.9 10.7-10.9 17.4-22.8 21.8-38.5 3.2-10.9 2.9-88.4 1.7-93.9z"]
  };
  var faEdge = {
    prefix: 'fab',
    iconName: 'edge',
    icon: [512, 512, [], "f282", "M120.1 37.4c41-25.2 87.6-38.2 134.9-37.4 168 0 257 123.8 257 219.5-.1 32.7-13 63.9-35.9 87.2-22.9 23.2-54 36.5-86.7 37-75.2 0-91.5-23.1-91.5-32 0-3.8 1.2-6.2 4.8-9.4l1-1.2 .4-1.6c10.5-11.5 15.9-26.2 15.9-41.6 0-78.7-82.2-142.7-184-142.7-37.5-.3-74.5 8.9-107.5 26.9 27-57.5 82.7-97.6 91.3-103.8 .8-.6 .3-.8 .3-.8zm15.6 318.1c-1.4 30 4.6 60 16.4 87.2 13.6 26.4 32.7 51 56.5 69.3-59.5-11.5-111.5-43.9-149.4-89.3-38.1-46.4-59.2-104.3-59.2-164.8 0-51.2 62.4-94.4 136-94.4 36.6-.6 72.4 10.9 101.8 32.7l-3.6 1.2c-51.5 17.6-98.5 90.7-98.5 158.1zM469.8 400l-.7 .1c-11.8 18.8-25.9 35.1-42.2 49.5-30.8 28-68.1 45.5-108.8 49.9-18.6 .3-36.8-3.2-53.8-11.4-25.6-10.3-47.1-30-61.6-53-14.4-23.9-21.1-51.7-19-79.6-.6-20.1 5.4-40.3 15-58.2 13.9 33.1 37.5 61.3 67.6 80.8s65.5 29.5 101.4 28.6c31 .3 62.1-6.7 90.2-20.5l1.9-.9c3.9-2.3 7.7-3.9 11.6 0 4.5 4.9 1.8 9.2-1.2 14-.2 .2-.3 .5-.4 .7z"]
  };
  var faIoxhost = {
    prefix: 'fab',
    iconName: 'ioxhost',
    icon: [640, 512, [], "f208", "M616 160l-67.3 0C511.2 70.7 422.9 8 320 8 183 8 72 119 72 256 72 272.4 73.6 288.5 76.7 304L24 304c-13.3 0-24 10.8-24 24 0 13.3 10.7 24 24 24l67.3 0c37.5 89.3 125.8 152 228.7 152 137 0 248-111 248-248 0-16.4-1.6-32.5-4.7-48l52.7 0c13.3 0 24-10.8 24-24 0-13.3-10.7-24-24-24zm-96 96c0 110.5-89.5 200-200 200-75.7 0-141.6-42-175.5-104L424 352c13.3 0 24-10.8 24-24 0-13.3-10.7-24-24-24l-298.2 0c-3.8-15.4-5.8-31.4-5.8-48 0-110.5 89.5-200 200-200 75.7 0 141.6 42 175.5 104L216 160c-13.3 0-24 10.8-24 24 0 13.3 10.7 24 24 24l298.2 0c3.8 15.4 5.8 31.4 5.8 48zM216 232l208 0c13.3 0 24 10.7 24 24 0 13.2-10.7 24-24 24l-208 0c-13.3 0-24-10.7-24-24 0-13.2 10.7-24 24-24z"]
  };
  var faSchlix = {
    prefix: 'fab',
    iconName: 'schlix',
    icon: [448, 512, [], "f3ea", "M350.5 157.7l-54.2-46.1 73.4-39 78.3 44.2-97.5 40.9zM192 122.1l45.7-28.2 34.7 34.6-55.4 29-25-35.4zm-65.1 6.6l31.9-22.1 17.2 28.4-36.7 22.5-12.4-28.8zm-23.3 88.2l-8.8-34.8 29.6-18.3 13.1 35.3-33.9 17.8zM82.4 133.2l23.9-18.1 8.9 24-26.7 18.3-6.1-24.2zM59 206.5l-3.6-28.4 22.3-15.5 6.1 28.7-24.8 15.2zM28.4 223.1l20.8-12.8 3.3 33.4-22.9 12-1.2-32.6zM1.4 268L20.6 257.8 21 296 0 304.8 1.4 268zm59.1 59.3l-28.3 8.3-1.6-46.8 25.1-10.7 4.8 49.2zM99 263.2l-31.1 13-5.2-40.8 27.4-14.4 8.9 42.2zM123.2 377l-41.6 5.9-8.1-63.5 35.2-10.8 14.5 68.4zm28.5-139.9l21.2 57.1-46.2 13.6-13.7-54.1 38.7-16.6zm85.7 230.5l-70.9-3.3-24.3-95.8 55.2-8.6 40 107.7zM152.5 187.9l42.2-22.4 28 45.9-50.8 21.3-19.4-44.8zm41 94.9l61.3-18.7 52.8 86.6-79.8 11.3-34.3-79.2zm51.4-85.6l67.3-28.8 65.5 65.4-88.6 26.2-44.2-62.8z"]
  };
  var faDAndD = {
    prefix: 'fab',
    iconName: 'd-and-d',
    icon: [576, 512, [], "f38d", "M82.9 98.9c-.6-17.2 2-33.8 12.7-48.2 .3 7.4 1.2 14.5 4.2 21.6 5.9-27.5 19.7-49.3 42.3-65.5-1.9 5.9-3.5 11.8-3 17.7 8.7-7.4 18.8-17.8 44.4-22.7 14.7-2.8 29.7-2 42.1 1 38.5 9.3 61 34.3 69.7 72.3 5.3 23.1 .7 45-8.3 66.4-5.2 12.4-12 24.4-20.7 35.1-2-1.9-3.9-3.8-5.8-5.6-42.8-40.8-26.8-25.2-37.4-37.4-1.1-1.2-1-2.2-.1-3.6 8.3-13.5 11.8-28.2 10-44-1.1-9.8-4.3-18.9-11.3-26.2-14.5-15.3-39.2-15-53.5 .6-11.4 12.5-14.1 27.4-10.9 43.6 .2 1.3 .4 2.7 0 3.9-3.4 13.7-4.6 27.6-2.5 41.6 .1 .5 .1 1.1 .1 1.6 0 .3-.1 .5-.2 1.1-21.8-11-36-28.3-43.2-52.2-8.3 17.8-11.1 35.5-6.6 54.1-15.6-15.2-21.3-34.3-22-55.2zM552.5 222.1c-11.6-11.6-25-20.4-40.1-26.6-12.8-5.2-26-7.9-39.9-7.1-10 .6-19.6 3.1-29 6.4-2.5 .9-5.1 1.6-7.7 2.2-4.9 1.2-7.3-3.1-4.7-6.8 3.2-4.6 3.4-4.2 15-12 .6-.4 1.2-.8 2.2-1.5l-2.5 0c-.6 0-1.2 .2-1.9 .3-19.3 3.3-30.7 15.5-48.9 29.6-10.4 8.1-13.8 3.8-12-.5 1.4-3.5 3.3-6.7 5.1-10 1-1.8 2.3-3.4 3.5-5.1-.2-.2-.5-.3-.7-.5-27 18.3-46.7 42.4-57.7 73.3 .3 .3 .7 .6 1 .9 .3-.6 .5-1.2 .9-1.7 10.4-12.1 22.8-21.8 36.6-29.8 18.2-10.6 37.5-18.3 58.7-20.2 4.3-.4 8.7-.1 13.1-.1-1.8 .7-3.5 .9-5.3 1.1-18.5 2.4-35.5 9-51.5 18.5-30.2 17.9-54.5 42.2-75.1 70.4-.3 .4-.4 .9-.7 1.3 14.5 5.3 24 17.3 36.1 25.6 .2-.1 .3-.2 .4-.4l1.2-2.7c12.2-26.9 27-52.3 46.7-74.5 16.7-18.8 38-25.3 62.5-20 5.9 1.3 11.4 4.4 17.2 6.8 2.3-1.4 5.1-3.2 8-4.7 8.4-4.3 17.4-7 26.7-9 14.7-3.1 29.5-4.9 44.5-1.3l0-.5c-.5-.4-1.2-.8-1.7-1.4zM317.1 397.6c-39.4-33-22.8-19.5-42.7-35.6-.8 .9 0-.2-1.9 3-11.2 19.1-25.5 35.3-44 47.6-10.3 6.8-21.5 11.8-34.1 11.8-21.6 0-38.2-9.5-49.4-27.8-12-19.5-13.3-40.7-8.2-62.6 7.8-33.8 30.1-55.2 38.6-64.3-18.7-6.2-33 1.7-46.4 13.9 .8-13.9 4.3-26.2 11.8-37.3-24.3 10.6-45.9 25-64.8 43.9-.3-5.8 5.4-43.7 5.6-44.7 .3-2.7-.6-5.3-3-7.4-24.2 24.7-44.5 51.8-56.1 84.6 7.4-5.9 14.9-11.4 23.6-16.2-8.3 22.3-19.6 52.8-7.8 101.1 4.6 19 11.9 36.8 24.1 52.3 2.9 3.7 6.3 6.9 9.5 10.3 .2-.2 .4-.3 .6-.5-1.4-7-2.2-14.1-1.5-21.9 2.2 3.2 3.9 6 5.9 8.6 12.6 16 28.7 27.4 47.2 35.6 25 11.3 51.1 13.3 77.9 8.6 54.9-9.7 90.7-48.6 116-98.8 1-1.8 .6-2.9-.9-4.2zm172-46.4c-9.5-3.1-22.2-4.2-28.7-2.9 9.9 4 14.1 6.6 18.8 12 12.6 14.4 10.4 34.7-5.4 45.6-11.7 8.1-24.9 10.5-38.9 9.1-1.2-.1-2.3-.4-3-.6 2.8-3.7 6-7 8.1-10.8 9.4-16.8 5.4-42.1-8.7-56.1-2.1-2.1-4.6-3.9-7-5.9-.3 1.3-.1 2.1 .1 2.8 4.2 16.6-8.1 32.4-24.8 31.8-7.6-.3-13.9-3.8-19.6-8.5-19.5-16.1-39.1-32.1-58.5-48.3-5.9-4.9-12.5-8.1-20.1-8.7-4.6-.4-9.3-.6-13.9-.9-5.9-.4-8.8-2.8-10.4-8.4-.9-3.4-1.5-6.8-2.2-10.2-1.5-8.1-6.2-13-14.3-14.2-4.4-.7-8.9-1-13.3-1.5-13-1.4-19.8-7.4-22.6-20.3-5 11-1.6 22.4 7.3 29.9 4.5 3.8 9.3 7.3 13.8 11.2 4.6 3.8 7.4 8.7 7.9 14.8 .4 4.7 .8 9.5 1.8 14.1 2.2 10.6 8.9 18.4 17 25.1 16.5 13.7 33 27.3 49.5 41.1 17.9 15 13.9 32.8 13 56-.9 22.9 12.2 42.9 33.5 51.2 1 .4 2 .6 3.6 1.1-15.7-18.2-10.1-44.1 .7-52.3 .3 2.2 .4 4.3 .9 6.4 9.4 44.1 45.4 64.2 85 56.9 16-2.9 30.6-8.9 42.9-19.8 2-1.8 3.7-4.1 5.9-6.5-19.3 4.6-35.8 .1-50.9-10.6 .7-.3 1.3-.3 1.9-.3 21.3 1.8 40.6-3.4 57-17.4 19.5-16.6 26.6-42.9 17.4-66-8.3-20.1-23.6-32.3-43.8-38.9zM99.8 179.3c-5.3-9.2-13.2-15.6-22.1-21.3 13.7-.5 26.6 .2 39.6 3.7-7-12.2-8.5-24.7-5-38.7 5.3 11.9 13.7 20.1 23.6 26.8 19.7 13.2 35.7 19.6 46.7 30.2 3.4 3.3 6.3 7.1 9.6 10.9-.8-2.1-1.4-4.1-2.2-6-5-10.6-13-18.6-22.6-25-1.8-1.2-2.8-2.5-3.4-4.5-3.3-12.5-3-25.1-.7-37.6 1-5.5 2.8-10.9 4.5-16.3 .8-2.4 2.3-4.6 4-6.6 .6 6.9 0 25.5 19.6 46 10.8 11.3 22.4 21.9 33.9 32.7 9 8.5 18.3 16.7 25.5 26.8 1.1 1.6 2.2 3.3 3.8 4.7-5-13-14.2-24.1-24.2-33.8-9.6-9.3-19.4-18.4-29.2-27.4-3.3-3-4.6-6.7-5.1-10.9-1.2-10.4 0-20.6 4.3-30.2 .5-1 1.1-2 1.9-3.3 .5 4.2 .6 7.9 1.4 11.6 4.8 23.1 20.4 36.3 49.3 63.5 10 9.4 19.3 19.2 25.6 31.6 4.8 9.3 7.3 19 5.7 29.6-.1 .6 .5 1.7 1.1 2 6.2 2.6 10 6.9 9.7 14.3 7.7-2.6 12.5-8 16.4-14.5 4.2 20.2-9.1 50.3-27.2 58.7 .4-4.5 5-23.4-16.5-27.7-6.8-1.3-12.8-1.3-22.9-2.1 4.7-9 10.4-20.6 .5-22.4-24.9-4.6-52.8 1.9-57.8 4.6 8.2 .4 16.3 1 23.5 3.3-2 6.5-4 12.7-5.8 18.9-1.9 6.5 2.1 14.6 9.3 9.6 1.2-.9 2.3-1.9 3.3-2.7-3.1 17.9-2.9 15.9-2.8 18.3 .3 10.2 9.5 7.8 15.7 7.3-2.5 11.8-29.5 27.3-45.4 25.8 7-4.7 12.7-10.3 15.9-17.9-6.5 .8-12.9 1.6-19.2 2.4l-.3-.9c4.7-3.4 8-7.8 10.2-13.1 8.7-21.1-3.6-38-25-39.9-9.1-.8-17.8 .8-25.9 5.5 6.2-15.6 17.2-26.6 32.6-34.5-15.2-4.3-8.9-2.7-24.6-6.3 14.6-9.3 30.2-13.2 46.5-14.6-5.2-3.2-48.1-3.6-70.2 20.9 7.9 1.4 15.5 2.8 23.2 4.2-23.8 7-44 19.7-62.4 35.6 1.1-4.8 2.7-9.5 3.3-14.3 .6-4.5 .8-9.2 .1-13.6-1.5-9.4-8.9-15.1-19.7-16.3-7.9-.9-15.6 .1-23.3 1.3-.9 .1-1.7 .3-2.9 0 15.8-14.8 36-21.7 53.1-33.5 6-4.5 6.8-8.2 3-14.9zm128.4 26.8c3.3 16 12.6 25.5 23.8 24.3-4.6-11.3-12.1-19.5-23.8-24.3z"]
  };
  var faVuejs = {
    prefix: 'fab',
    iconName: 'vuejs',
    icon: [448, 512, [], "f41f", "M356.9 64.3l-76.9 0-56 88.6-48-88.6-176 0 224 383.7 224-383.7-91.1 0zM55.7 96.3l53.8 0 114.5 198.2 114.4-198.2 53.8 0-168.2 288.2-168.3-288.2z"]
  };
  var faMeta = {
    prefix: 'fab',
    iconName: 'meta',
    icon: [640, 512, [], "e49b", "M640 317.9c0 91.3-39.4 148.5-110.3 148.5-62.6 0-95.8-34.6-156.9-136.6l-31.4-52.6c-8.3-12.5-14.5-24.2-21.2-35-20.1 33.8-47.1 83-47.1 83-67 116.6-104.6 141.2-156.9 141.2-72.8 0-116.2-57.3-116.2-145.9 0-143 79.8-278.1 183.9-278.1 50.2 0 93.8 24.7 144.8 89.5 37.1-50.1 78.1-89.5 130.6-89.5 99.1 0 180.7 125.7 180.7 275.5zM287.4 192.2c-42.9-62.1-70.9-80.5-104.4-80.5-61.9 0-113.8 106.1-113.8 210 0 48.5 18.5 75.7 49.6 75.7 30.2 0 49-19 103.2-103.8 0 0 24.7-39.1 65.4-101.4zM531.2 397.4c32.2 0 46.9-27.5 46.9-74.9 0-124.2-54.3-225.4-123.2-225.4-33.2 0-61.1 25.9-94.9 78 9.4 13.8 19.1 29 29.3 45.4l37.5 62.4c58.7 94.1 73.5 114.5 104.4 114.5z"]
  };
  var faCreativeCommonsShare = {
    prefix: 'fab',
    iconName: 'creative-commons-share',
    icon: [512, 512, [], "f4f2", "M255.6 8C397.4 8 504 118.1 504 256 504 403.1 385.5 504 255.6 504 121.6 504 8 394.5 8 256 8 123.1 112.7 8 255.6 8zm.8 44.7c-118.2 0-203.7 97.9-203.7 203.3 0 109.8 91.2 202.8 203.7 202.8 103.2 0 202.8-81.1 202.8-202.8 .1-113.8-90.2-203.3-202.8-203.3zm101 132.4c7.8 0 13.7 6.1 13.7 13.7l0 182.5c0 7.7-6.1 13.7-13.7 13.7l-135.1 0c-7.7 0-13.7-6-13.7-13.7l0-54-54 0c-7.8 0-13.7-6-13.7-13.7l0-182.5c0-8.2 6.6-12.7 12.4-13.7l136.4 0c7.7 0 13.7 6 13.7 13.7l0 54 54 0zM167.9 300.3l40.7 0 0-101.4c0-7.4 5.8-12.6 12-13.7l55.8 0 0-40.3-108.5 0 0 155.4zm176.2-88.1l-108.5 0 0 155.4 108.5 0 0-155.4z"]
  };
  var faStudiovinari = {
    prefix: 'fab',
    iconName: 'studiovinari',
    icon: [512, 512, [], "f3f8", "M480.7 187.7l4.2 28 0 28-25.1 44.1-39.8 78.4-56.1 67.5-79.1 37.8-17.7 24.5-7.7 12-9.6 4s17.3-63.6 19.4-63.6 20.3 .7 20.3 .7l66.7-38.6-92.5 26.1-55.9 36.8-22.8 28-6.6 1.4 20.8-73.6 6.9-5.5 20.7 12.9 88.3-45.2 56.8-51.5 14.8-68.4-125.4 23.3 15.2-18.2-173.4-53.3 81.9-10.5-166-122.9 114.9 18.1-101.3-108 252.9 126.6-31.5-38 124.4 74.4-143.3-99 18.7 38.4-49.6-18.1-45.5-84.3 194.6 122-42.9-55.8 108 96.4 12-8.9-21-16.4 4.2-37.8 37.8-10.4 29.2 24.7 11.5 4.2-7 6.2 8.5 12-13.1 7.4-10.3 20.2 10.5 23.9z"]
  };
  var faBitbucket = {
    prefix: 'fab',
    iconName: 'bitbucket',
    icon: [512, 512, [61810], "f171", "M22.2 32c-2.1 0-4.2 .4-6.1 1.1s-3.7 1.9-5.2 3.4-2.7 3.2-3.5 5.1-1.3 4-1.3 6.1c0 .9 .1 1.9 .2 2.8L74.1 462.7c.8 5.1 3.4 9.7 7.3 13s8.8 5.2 14 5.2l325.7 0c3.8 .1 7.5-1.3 10.5-3.7s4.9-5.9 5.5-9.7L505 50.7c.7-4.2-.3-8.4-2.8-11.9s-6.2-5.7-10.4-6.4c-.9-.1-1.9-.2-2.8-.2L22.2 32zM308.1 329.8l-104 0-28.1-147 157.3 0-25.2 147z"]
  };
  var faVk = {
    prefix: 'fab',
    iconName: 'vk',
    icon: [448, 512, [], "f189", "M31.5 63.5C0 95 0 145.7 0 247L0 265C0 366.3 0 417 31.5 448.5S113.7 480 215 480l17.9 0c101.4 0 152.1 0 183.5-31.5S448 366.3 448 265l0-17.9c0-101.4 0-152.1-31.5-183.5S334.3 32 233 32L215 32C113.7 32 63 32 31.5 63.5zM75.6 168.3l51.1 0c1.7 85.5 39.4 121.7 69.3 129.2l0-129.2 48.2 0 0 73.7c29.5-3.2 60.5-36.8 70.9-73.7l48.2 0c-3.9 19.2-11.8 37.3-23.1 53.3s-25.7 29.5-42.5 39.6c18.7 9.3 35.2 22.4 48.4 38.5s22.9 34.9 28.3 55l-53 0c-4.9-17.5-14.8-33.1-28.6-45s-30.7-19.4-48.7-21.6l0 66.6-5.8 0c-102.1 0-160.3-70-162.8-186.5z"]
  };
  var faGithub = {
    prefix: 'fab',
    iconName: 'github',
    icon: [512, 512, [], "f09b", "M173.9 397.4c0 2-2.3 3.6-5.2 3.6-3.3 .3-5.6-1.3-5.6-3.6 0-2 2.3-3.6 5.2-3.6 3-.3 5.6 1.3 5.6 3.6zm-31.1-4.5c-.7 2 1.3 4.3 4.3 4.9 2.6 1 5.6 0 6.2-2s-1.3-4.3-4.3-5.2c-2.6-.7-5.5 .3-6.2 2.3zm44.2-1.7c-2.9 .7-4.9 2.6-4.6 4.9 .3 2 2.9 3.3 5.9 2.6 2.9-.7 4.9-2.6 4.6-4.6-.3-1.9-3-3.2-5.9-2.9zM252.8 8c-138.7 0-244.8 105.3-244.8 244 0 110.9 69.8 205.8 169.5 239.2 12.8 2.3 17.3-5.6 17.3-12.1 0-6.2-.3-40.4-.3-61.4 0 0-70 15-84.7-29.8 0 0-11.4-29.1-27.8-36.6 0 0-22.9-15.7 1.6-15.4 0 0 24.9 2 38.6 25.8 21.9 38.6 58.6 27.5 72.9 20.9 2.3-16 8.8-27.1 16-33.7-55.9-6.2-112.3-14.3-112.3-110.5 0-27.5 7.6-41.3 23.6-58.9-2.6-6.5-11.1-33.3 2.6-67.9 20.9-6.5 69 27 69 27 20-5.6 41.5-8.5 62.8-8.5s42.8 2.9 62.8 8.5c0 0 48.1-33.6 69-27 13.7 34.7 5.2 61.4 2.6 67.9 16 17.7 25.8 31.5 25.8 58.9 0 96.5-58.9 104.2-114.8 110.5 9.2 7.9 17 22.9 17 46.4 0 33.7-.3 75.4-.3 83.6 0 6.5 4.6 14.4 17.3 12.1 100-33.2 167.8-128.1 167.8-239 0-138.7-112.5-244-251.2-244zM105.2 352.9c-1.3 1-1 3.3 .7 5.2 1.6 1.6 3.9 2.3 5.2 1 1.3-1 1-3.3-.7-5.2-1.6-1.6-3.9-2.3-5.2-1zm-10.8-8.1c-.7 1.3 .3 2.9 2.3 3.9 1.6 1 3.6 .7 4.3-.7 .7-1.3-.3-2.9-2.3-3.9-2-.6-3.6-.3-4.3 .7zm32.4 35.6c-1.6 1.3-1 4.3 1.3 6.2 2.3 2.3 5.2 2.6 6.5 1 1.3-1.3 .7-4.3-1.3-6.2-2.2-2.3-5.2-2.6-6.5-1zm-11.4-14.7c-1.6 1-1.6 3.6 0 5.9s4.3 3.3 5.6 2.3c1.6-1.3 1.6-3.9 0-6.2-1.4-2.3-4-3.3-5.6-2z"]
  };
  var faCodiepie = {
    prefix: 'fab',
    iconName: 'codiepie',
    icon: [512, 512, [], "f284", "M442.5 202.9c30.7 0 33.5 53.1-.3 53.1l-10.8 0 0 44.3-26.6 0 0-97.4 37.7 0zM492 352.6C449.9 444.5 370.4 504 268 504 131 504 20 393 20 256S131 8 268 8c97.4 0 172.8 53.7 218.2 138.4L300.2 255.2 492 352.6zm-38.5 12.5l-60.3-30.7c-27.1 44.3-70.4 71.4-122.4 71.4-82.5 0-149.2-66.7-149.2-148.9 0-82.5 66.7-149.2 149.2-149.2 48.4 0 88.9 23.5 116.9 63.4l59.5-34.6C406.5 73.9 342.5 36.5 268 36.5 146.8 36.5 48.5 134.8 48.5 256S146.8 475.5 268 475.5c78.6 0 146.5-42.1 185.5-110.4z"]
  };
  var faPiedPiper = {
    prefix: 'fab',
    iconName: 'pied-piper',
    icon: [448, 512, [], "f2ae", "M440.2 23.2c-26.7 6.8-68.1 28.5-114.6 67.5-30.9-17.5-65.8-26.7-101.4-26.7-114.9 0-208 93.1-208 208s93.1 208 208 208 208-93.1 208-208c.1-54.1-21-106.1-58.7-144.8-6.6 8.5-12.3 17.7-17 27.4 28.9 32.3 44.8 74.1 44.9 117.4 0 97.7-79.4 177.1-177.1 177.1-30.8 0-61-8.1-87.6-23.4 82.9-107.3 150.8-37.8 184.3-226.6 5.8-32.6 28-94.3 126.2-160.2 8.1-5.4 2.4-18.1-7-15.7zM109.3 406.4C89.8 389.8 74.2 369.2 63.5 346s-16.3-48.5-16.3-74c0-97.7 79.4-177.1 177.1-177.1 26.6 0 52.8 6.1 76.6 17.8-66 62.1-126.9 152.9-191.6 293.8z"]
  };
  var faRaspberryPi = {
    prefix: 'fab',
    iconName: 'raspberry-pi',
    icon: [448, 512, [], "f7bb", "M392.5 232.5l-3.7-6.5c.1-46.4-21.4-65.3-46.5-79.7 7.6-2 15.4-3.6 17.6-13.2 13.1-3.3 15.8-9.4 17.1-15.8 3.4-2.3 14.8-8.7 13.6-19.7 6.4-4.4 10-10.1 8.1-18.1 6.9-7.5 8.7-13.7 5.8-19.4 8.3-10.3 4.6-15.6 1.1-20.9 6.2-11.2 .7-23.2-16.6-21.2-6.9-10.1-21.9-7.8-24.2-7.8-2.6-3.2-6-6-16.5-4.7-6.8-6.1-14.4-5-22.3-2.1-9.3-7.3-15.5-1.4-22.6 .8-11.3-3.6-13.9 1.3-19.4 3.4-12.3-2.6-16.1 3-22 8.9l-6.9-.1c-18.6 10.8-27.8 32.8-31.1 44.1-3.3-11.3-12.5-33.3-31.1-44.1l-6.9 .1c-5.9-5.9-9.7-11.5-22-8.9-5.6-2-8.1-7-19.4-3.4-4.6-1.4-8.9-4.4-13.9-4.3-2.6 .1-5.5 1-8.7 3.5-7.9-3-15.5-4-22.3 2.1-10.5-1.3-14 1.4-16.5 4.7-2.3 0-17.3-2.3-24.2 7.8-17.3-2-22.7 10-16.5 21.2-3.5 5.4-7.2 10.7 1.1 20.9-2.9 5.7-1.1 11.9 5.8 19.4-1.8 8 1.8 13.7 8.1 18.1-1.2 11 10.2 17.4 13.6 19.7 1.3 6.4 4 12.4 17.1 15.8 2.2 9.5 10 11.2 17.6 13.2-25.1 14.4-46.6 33.3-46.5 79.7l-3.7 6.5c-28.8 17.2-54.7 72.7-14.2 117.7 2.6 14.1 7.1 24.2 11 35.4 5.9 45.2 44.5 66.3 54.6 68.8 14.9 11.2 30.8 21.8 52.2 29.2 20.3 20.6 42.3 28.4 64.3 28.4l1 0c22.1 0 44-7.8 64.2-28.4 21.5-7.4 37.3-18 52.2-29.2 10.2-2.5 48.7-23.6 54.6-68.8 3.9-11.2 8.4-21.3 11-35.4 40.6-45.1 14.7-100.5-14-117.7zm-22.2-8c-1.5 18.7-98.9-65.1-82.1-67.9 45.7-7.5 83.6 19.2 82.1 67.9zm-43 93.1c-24.5 15.8-59.8 5.6-78.8-22.8s-14.6-64.2 9.9-80 59.8-5.6 78.8 22.8 14.6 64.2-9.9 80zM259.4 29.3c.8 4.2 1.8 6.8 2.9 7.6 5.4-5.8 9.8-11.7 16.8-17.3 0 3.3-1.7 6.8 2.5 9.4 3.7-5 8.8-9.5 15.5-13.3-3.2 5.6-.6 7.3 1.2 9.6 5.1-4.4 10-8.8 19.4-12.3-2.6 3.1-6.2 6.2-2.4 9.8 5.3-3.3 10.6-6.6 23.1-8.9-2.8 3.1-8.7 6.3-5.1 9.4 6.6-2.5 14-4.4 22.1-5.4-3.9 3.2-7.1 6.3-3.9 8.8 7.1-2.2 16.9-5.1 26.4-2.6l-6 6.1c-.7 .8 14.1 .6 23.9 .8-3.6 5-7.2 9.7-9.3 18.2 1 1 5.8 .4 10.4 0-4.7 9.9-12.8 12.3-14.7 16.6 2.9 2.2 6.8 1.6 11.2 .1-3.4 6.9-10.4 11.7-16 17.3 1.4 1 3.9 1.6 9.7 .9-5.2 5.5-11.4 10.5-18.8 15 1.3 1.5 5.8 1.5 10 1.6-6.7 6.5-15.3 9.9-23.4 14.2 4 2.7 6.9 2.1 10 2.1-5.7 4.7-15.4 7.1-24.4 10 1.7 2.7 3.4 3.4 7.1 4.1-9.5 5.3-23.2 2.9-27 5.6 .9 2.7 3.6 4.4 6.7 5.8-15.4 .9-57.3-.6-65.4-32.3 15.7-17.3 44.4-37.5 93.7-62.6-38.4 12.8-73 30-102 53.5-34.3-15.9-10.8-55.9 5.8-71.8zM225 143.9c24.2-.3 54.1 17.8 54 34.7-.1 15-21 27.1-53.8 26.9-32.1-.4-53.7-15.2-53.6-29.8 0-11.9 26.2-32.5 53.4-31.8zM102 131.1c3.7-.7 5.4-1.5 7.1-4.1-9-2.8-18.7-5.3-24.4-10 3.1 0 6 .7 10-2.1-8.1-4.3-16.7-7.7-23.4-14.2 4.2-.1 8.7 0 10-1.6-7.4-4.5-13.6-9.5-18.8-15 5.8 .7 8.3 .1 9.7-.9-5.6-5.6-12.7-10.4-16-17.3 4.3 1.5 8.3 2 11.2-.1-1.9-4.2-10-6.7-14.7-16.6 4.6 .4 9.4 1 10.4 0-2.1-8.5-5.8-13.3-9.3-18.2 9.8-.1 24.6 0 23.9-.8l-6-6.1c9.5-2.5 19.3 .4 26.4 2.6 3.2-2.5-.1-5.6-3.9-8.8 8.1 1.1 15.4 2.9 22.1 5.4 3.5-3.1-2.3-6.3-5.1-9.4 12.5 2.3 17.8 5.6 23.1 8.9 3.8-3.6 .2-6.7-2.4-9.8 9.4 3.4 14.3 7.9 19.4 12.3 1.7-2.3 4.4-4 1.2-9.6 6.7 3.8 11.8 8.3 15.5 13.3 4.1-2.6 2.5-6.2 2.5-9.4 7 5.6 11.4 11.5 16.8 17.3 1.1-.8 2-3.4 2.9-7.6 16.6 15.9 40.1 55.9 6 71.8-29-23.5-63.6-40.7-102-53.5 49.3 25 78 45.3 93.7 62.6-8 31.8-50 33.2-65.4 32.3 3.1-1.4 5.8-3.2 6.7-5.8-4-2.8-17.6-.4-27.2-5.6zm60.1 24.1c16.8 2.8-80.6 86.5-82.1 67.9-1.5-48.7 36.5-75.5 82.1-67.9zM58.7 342c-23.7-18.8-31.3-73.7 12.6-98.3 26.5-7 9 107.8-12.6 98.3zm91 98.2c-13.3 7.9-45.8 4.7-68.8-27.9-15.5-27.4-13.5-55.2-2.6-63.4 16.3-9.8 41.5 3.4 60.9 25.6 16.9 20 24.6 55.3 10.5 65.7zM123.3 320.5c-24.5-15.8-28.9-51.6-9.9-80s54.3-38.6 78.8-22.8 28.9 51.6 9.9 80c-19.1 28.4-54.4 38.6-78.8 22.8zM225.5 496c-29.4 1.2-58.2-23.7-57.8-32.3-.4-12.7 35.8-22.6 59.3-22 23.7-1 55.6 7.5 55.7 18.9 .5 11-28.8 35.9-57.2 35.4zm58.9-124.9c.2 29.7-26.2 53.8-58.8 54s-59.2-23.8-59.4-53.4l0-.6c-.2-29.7 26.2-53.8 58.8-54s59.2 23.8 59.4 53.4l0 .6zm82.2 42.7c-25.3 34.6-59.6 35.9-72.3 26.3-13.3-12.4-3.2-50.9 15.1-72 20.9-23.3 43.3-38.5 58.9-26.6 10.5 10.3 16.7 49.1-1.7 72.3zm22.9-73.2c-21.5 9.4-39-105.3-12.6-98.3 43.9 24.7 36.3 79.6 12.6 98.3z"]
  };
  var faCss3 = {
    prefix: 'fab',
    iconName: 'css3',
    icon: [512, 512, [], "f13c", "M480 32l-64 368-223.3 80-192.7-80 19.6-94.8 82 0-8 40.6 116.4 44.4 134.1-44.4 18.8-97.1-333.4 0 16-82 333.7 0 10.5-52.7-333.4 0 16.3-82 407.4 0z"]
  };
  var faHubspot = {
    prefix: 'fab',
    iconName: 'hubspot',
    icon: [448, 512, [], "f3b2", "M235.8 211.6c-25.1 23.7-40.8 57.3-40.8 94.6 0 29.3 9.7 56.3 26 78L171.5 434c-4.4-1.6-9.1-2.5-14-2.5-10.8 0-20.9 4.2-28.5 11.8s-11.8 17.8-11.8 28.6 4.2 20.9 11.8 28.5 17.8 11.6 28.5 11.6c10.8 0 20.9-3.9 28.6-11.6 7.6-7.6 11.8-17.8 11.8-28.5 0-4.2-.6-8.2-1.9-12.1l50-50.2c22 16.9 49.4 26.9 79.3 26.9 71.9 0 130-58.3 130-130.2 0-65.2-47.7-119.2-110.2-128.7l0-61.6c17.5-7.4 28.2-23.8 28.2-42.9 0-26.1-20.9-47.9-47-47.9S279.6 47 279.6 73.1c0 19.1 10.7 35.5 28.2 42.9l0 61.2c-15.2 2.1-29.6 6.7-42.7 13.6-27.6-20.9-117.5-85.7-168.9-124.8 1.2-4.4 2-9 2-13.8 0-28.8-23.5-52.2-52.4-52.2-28.8 0-52.2 23.4-52.2 52.2 0 28.9 23.4 52.3 52.2 52.3 9.8 0 18.9-2.9 26.8-7.6L235.8 211.6zm89.5 25.6a69 69 0 1 1 0 138 69 69 0 1 1 0-138z"]
  };
  var faCmplid = {
    prefix: 'fab',
    iconName: 'cmplid',
    icon: [640, 512, [], "e360", "M226.1 388.2c0-.7-.2-1.5-.6-2.1s-1-1.1-1.7-1.4c-.5-.2-1.1-.4-1.6-.4l-149.6 0c-3.1 0-6.2-.8-8.9-2.2s-5.1-3.5-6.9-6.1-2.9-5.5-3.3-8.6 0-6.2 1.1-9.1L81.6 255.7c2-7.2 6.2-13.5 12-18.2s12.9-7.4 20.4-7.8l148.6 0c1.5-.1 2.9-.6 4-1.6s2-2.2 2.4-3.6l10.8-41.1c.4-1 .3-2-.1-2.9s-1.2-1.6-2.1-2c-.4-.2-.9-.3-1.4-.3-.1 0-.1 0-.2 0l-148.5 0c-22.2 1.2-43.4 9.2-60.8 23s-30 32.7-36.2 54.1L3.5 358.8c-3.2 8.7-4.2 18-3 27.1s4.6 17.9 9.9 25.5 12.3 13.8 20.5 18 17.3 6.5 26.5 6.6c1 0 1.9 0 2.9-.1l148.6 0c1.5-.1 2.9-.7 4-1.6s2-2.2 2.4-3.6l10.7-41.1c.2-.5 .3-.9 .3-1.4zm80.5-307c.2-.4 .3-.9 .3-1.4 0-.5-.1-1-.3-1.5s-.5-.9-.8-1.2-.8-.6-1.2-.8-1-.3-1.5-.3l-41.2 0c-1.5 .1-2.9 .6-4 1.6s-2 2.2-2.4 3.6l-21.3 80.9 51.1 0 21.4-80.9zm-126.3 287l51.1 0 32-122.6-51.1 0-32 122.6zM511.9 79.7c0-1-.5-1.9-1.2-2.6s-1.7-1.1-2.6-1.1c-.1 0-.1 0-.2 0l-41 0c-1.5 .1-2.9 .6-4.1 1.5s-2 2.2-2.5 3.6L368.9 430.6c-.2 .4-.3 .9-.3 1.3 0 1 .4 2 1.1 2.7s1.7 1.1 2.7 1.1l41.2 0c1.5-.1 2.9-.6 4-1.6s2-2.2 2.4-3.6L511.5 81.2c.2-.5 .3-1 .3-1.5zM324.6 384.5l-41 0c-1.5 .1-2.9 .7-4 1.6s-2 2.2-2.4 3.6l-10.7 41.1c-.2 .4-.3 .9-.3 1.4 0 .5 .1 1 .3 1.5s.5 .9 .8 1.2 .8 .6 1.2 .8 1 .3 1.5 .3c.1 0 .2 0 .3 0l40.9 0c1.5-.1 2.9-.6 4-1.6s2-2.2 2.4-3.6l10.8-41.1c.2-.6 .3-1.2 .3-1.8s-.3-1.2-.6-1.7-.8-.9-1.3-1.2-1.2-.4-1.8-.4c-.1 0-.2 0-.3 0l0 0zM636 76.1l-41 0c-1.5 .1-2.9 .6-4 1.5s-2 2.2-2.4 3.6L497.1 430.6c-.2 .4-.2 .9-.2 1.3 0 1 .4 2 1.1 2.7s1.7 1.1 2.7 1.1l41.1 0c1.5-.1 2.9-.6 4-1.6s2-2.2 2.4-3.6L639.7 81.2c.2-.5 .3-1 .3-1.5-.1-1-.5-1.9-1.2-2.5s-1.6-1-2.6-1c-.1 0-.1 0-.2 0l0-.1zM371.6 225.2l10.8-41.1c.2-.4 .2-.9 .2-1.4 0-1-.4-2-1.1-2.7s-1.7-1.1-2.7-1.1l-41.3 0c-1.5 .1-2.9 .7-4 1.6s-2 2.2-2.4 3.6l-10.8 41.1c-.2 .5-.3 1-.3 1.5l0 .2c.1 1 .5 1.8 1.2 2.5s1.6 1 2.6 1c.1 0 .2 0 .3 0l41.1 0c1.5-.1 2.9-.6 4-1.6s2-2.2 2.4-3.6z"]
  };
  var faDyalog = {
    prefix: 'fab',
    iconName: 'dyalog',
    icon: [448, 512, [], "f399", "M16 32l0 119.2 64 0 0-55.2 107.2 0C300.6 96 368 176.2 368 255.9 368 332 309.4 416 187.2 416l-171.2 0 0 64 171.2 0C347.9 480 432 367.3 432 255.9 432 197.2 409.9 142.5 369.7 101.6 324.9 56 261.7 32 187.2 32L16 32z"]
  };
  var faElementor = {
    prefix: 'fab',
    iconName: 'elementor',
    icon: [512, 512, [], "f430", "M.5 256c0 141 113.6 255 254.6 255 142 0 256-114 256-255 0-140-114-253.9-256-253.9-141 0-254.6 113.9-254.6 253.9zM192.1 150l0 213-43 0 0-213 43 0zm42 0l128 0 0 43-128 0 0-43zm128 85l0 43-128 0 0-43 128 0zm-128 85l128 0 0 43-128 0 0-43z"]
  };
  var faFirstOrder = {
    prefix: 'fab',
    iconName: 'first-order',
    icon: [448, 512, [], "f2b0", "M13.3 229.2c.1-.1 .2-.3 .3-.4 0 .1 0 .3-.1 .4l-.2 0zM224.4 96.6c-7.1 0-14.6 .6-21.4 1.7l3.7 67.4-22-64c-14.3 3.7-27.7 9.4-40 16.6l29.4 61.4-45.1-50.9c-11.4 8.9-21.7 19.1-30.6 30.9l50.6 45.4-61.1-29.7c-7.1 12.3-12.9 25.7-16.6 40l64.3 22.6-68-4c-.9 7.1-1.4 14.6-1.4 22s.6 14.6 1.4 21.7l67.7-4-64 22.6c3.7 14.3 9.4 27.7 16.6 40.3L149 306.9 98.1 352c8.9 11.7 19.1 22.3 30.9 30.9l44.9-50.9-29.5 61.4c12.3 7.4 25.7 13.1 40 16.9l22.3-64.6-4 68c7.1 1.1 14.6 1.7 21.7 1.7 7.4 0 14.6-.6 21.7-1.7l-4-68.6 22.6 65.1c14.3-4 27.7-9.4 40-16.9l-29.4-61.3 44.9 50.9c11.7-8.9 22-19.1 30.6-30.9l-50.6-45.1 61.1 29.4c7.1-12.3 12.9-25.7 16.6-40.3l-64-22.3 67.4 4c1.1-7.1 1.4-14.3 1.4-21.7s-.3-14.9-1.4-22l-67.7 4 64-22.3c-3.7-14.3-9.1-28-16.6-40.3l-60.9 29.7 50.6-45.4c-8.9-11.7-19.1-22-30.6-30.9l-45.1 50.9 29.4-61.1c-12.3-7.4-25.7-13.1-40-16.9l-22.3 64.3 4-67.7c-7.1-1.2-14.3-1.7-21.7-1.7zM443.8 128L443.8 384 224.4 512 5 384 5 128 224.4 0 443.8 128zm-17.1 10.3l-202.3-117.4-202.3 117.4 0 235.1 202.3 117.7 202.3-117.7 0-235.1zM224.4 37.1l187.7 109.4 0 218.9-187.7 109.5-187.7-109.5 0-218.8 187.7-109.5zm0 50.9c-92.3 0-166.9 75.1-166.9 168 0 92.6 74.6 167.7 166.9 167.7 92 0 166.9-75.1 166.9-167.7 0-92.9-74.9-168-166.9-168z"]
  };
  var faDribbble = {
    prefix: 'fab',
    iconName: 'dribbble',
    icon: [512, 512, [], "f17d", "M256 8a248 248 0 1 0 0 496 248 248 0 1 0 0-496zM420 122.4c29.5 36 47.4 82 47.8 132-7-1.5-77-15.7-147.5-6.8-5.8-14-11.2-26.4-18.6-41.6 78.3-32 113.8-77.5 118.3-83.5zM396.4 97.9c-3.8 5.4-35.7 48.3-111 76.5-34.7-63.8-73.2-116.2-79-124 67.2-16.2 138 1.3 190.1 47.5zM165.9 64.6c5.6 7.7 43.4 60.1 78.5 122.5-99.1 26.3-186.4 25.9-195.8 25.8 13.7-65.7 58-120.4 117.3-148.3zM44.2 256.3c0-2.2 0-4.3 .1-6.5 9.3 .2 111.9 1.5 217.7-30.1 6.1 11.9 11.9 23.9 17.2 35.9-76.6 21.6-146.2 83.5-180.5 142.3-33.8-37.6-54.5-87.2-54.5-141.6zM126 423.4c22.1-45.2 82.2-103.6 167.6-132.8 29.7 77.3 42 142.1 45.2 160.6-68.1 29-150 21.1-212.8-27.9zm248.4 8.5c-2.2-12.9-13.4-74.9-41.2-151 66.4-10.6 124.7 6.8 131.9 9.1-9.4 58.9-43.3 109.8-90.8 142z"]
  };
  var faLinkedin = {
    prefix: 'fab',
    iconName: 'linkedin',
    icon: [448, 512, [], "f08c", "M416 32L31.9 32C14.3 32 0 46.5 0 64.3L0 447.7C0 465.5 14.3 480 31.9 480L416 480c17.6 0 32-14.5 32-32.3l0-383.4C448 46.5 433.6 32 416 32zM135.4 416l-66.4 0 0-213.8 66.5 0 0 213.8-.1 0zM102.2 96a38.5 38.5 0 1 1 0 77 38.5 38.5 0 1 1 0-77zM384.3 416l-66.4 0 0-104c0-24.8-.5-56.7-34.5-56.7-34.6 0-39.9 27-39.9 54.9l0 105.8-66.4 0 0-213.8 63.7 0 0 29.2 .9 0c8.9-16.8 30.6-34.5 62.9-34.5 67.2 0 79.7 44.3 79.7 101.9l0 117.2z"]
  };
  var faCcPaypal = {
    prefix: 'fab',
    iconName: 'cc-paypal',
    icon: [576, 512, [], "f1f4", "M186.3 258.2c0 12.2-9.7 21.5-22 21.5-9.2 0-16-5.2-16-15 0-12.2 9.5-22 21.7-22 9.3 0 16.3 5.7 16.3 15.5zM80.5 209.7l-4.7 0c-1.5 0-3 1-3.2 2.7l-4.3 26.7 8.2-.3c11 0 19.5-1.5 21.5-14.2 2.3-13.4-6.2-14.9-17.5-14.9zm284 0l-4.5 0c-1.8 0-3 1-3.2 2.7l-4.2 26.7 8-.3c13 0 22-3 22-18-.1-10.6-9.6-11.1-18.1-11.1zM576 80l0 352c0 26.5-21.5 48-48 48L48 480c-26.5 0-48-21.5-48-48L0 80C0 53.5 21.5 32 48 32l480 0c26.5 0 48 21.5 48 48zM128.3 215.4c0-21-16.2-28-34.7-28l-40 0c-2.5 0-5 2-5.2 4.7L32 294.2c-.3 2 1.2 4 3.2 4l19 0c2.7 0 5.2-2.9 5.5-5.7l4.5-26.6c1-7.2 13.2-4.7 18-4.7 28.6 0 46.1-17 46.1-45.8zm84.2 8.8l-19 0c-3.8 0-4 5.5-4.2 8.2-5.8-8.5-14.2-10-23.7-10-24.5 0-43.2 21.5-43.2 45.2 0 19.5 12.2 32.2 31.7 32.2 9 0 20.2-4.9 26.5-11.9-.5 1.5-1 4.7-1 6.2 0 2.3 1 4 3.2 4l17.2 0c2.7 0 5-2.9 5.5-5.7l10.2-64.3c.3-1.9-1.2-3.9-3.2-3.9zM253 322.1l63.7-92.6c.5-.5 .5-1 .5-1.7 0-1.7-1.5-3.5-3.2-3.5l-19.2 0c-1.7 0-3.5 1-4.5 2.5l-26.5 39-11-37.5c-.8-2.2-3-4-5.5-4l-18.7 0c-1.7 0-3.2 1.8-3.2 3.5 0 1.2 19.5 56.8 21.2 62.1-2.7 3.8-20.5 28.6-20.5 31.6 0 1.8 1.5 3.2 3.2 3.2l19.2 0c1.8-.1 3.5-1.1 4.5-2.6zM412.3 215.4c0-21-16.2-28-34.7-28l-39.7 0c-2.7 0-5.2 2-5.5 4.7l-16.2 102c-.2 2 1.3 4 3.2 4l20.5 0c2 0 3.5-1.5 4-3.2l4.5-29c1-7.2 13.2-4.7 18-4.7 28.4 0 45.9-17 45.9-45.8zm84.2 8.8l-19 0c-3.8 0-4 5.5-4.3 8.2-5.5-8.5-14-10-23.7-10-24.5 0-43.2 21.5-43.2 45.2 0 19.5 12.2 32.2 31.7 32.2 9.3 0 20.5-4.9 26.5-11.9-.3 1.5-1 4.7-1 6.2 0 2.3 1 4 3.2 4l17.3 0c2.7 0 5-2.9 5.5-5.7l10.2-64.3c.3-1.9-1.2-3.9-3.2-3.9zM544 190.9c0-2-1.5-3.5-3.2-3.5l-18.5 0c-1.5 0-3 1.2-3.2 2.7l-16.2 104-.3 .5c0 1.8 1.5 3.5 3.5 3.5l16.5 0c2.5 0 5-2.9 5.2-5.7l16.2-101.2 0-.3zm-90 51.8c-12.2 0-21.7 9.7-21.7 22 0 9.7 7 15 16.2 15 12 0 21.7-9.2 21.7-21.5 .1-9.8-6.9-15.5-16.2-15.5z"]
  };
  var faDhl = {
    prefix: 'fab',
    iconName: 'dhl',
    icon: [640, 512, [], "f790", "M238 301.2l58.7 0 22.3-30.2-58.7 0-22.3 30.2zM0 282.9l0 6.4 81.8 0 4.7-6.4-86.5 0zM172.9 271c-8.7 0-6-3.6-4.6-5.5 2.8-3.8 7.6-10.4 10.4-14.1s2.8-5.9-2.8-5.9l-51 0-41.1 55.8 100.1 0c33.1 0 51.5-22.5 57.2-30.3l-68.2 0zm317.5-6.9l39.3-53.4-62.2 0-39.3 53.4 62.2 0zM95.3 271l-95.3 0 0 6.4 90.6 0 4.7-6.4zm111-26.6c-2.8 3.8-7.5 10.4-10.3 14.2-1.4 2-4.1 5.5 4.6 5.5l45.6 0s7.3-10 13.5-18.4c8.4-11.4 .7-35-29.2-35l-117.9 0-20.4 27.8 111.4 0c5.6 0 5.5 2.2 2.7 5.9zM0 301.2l73.1 0 4.7-6.4-77.8 0 0 6.4zm323 0l58.7 0 22.3-30.2-58.7 0c-.1 0-22.3 30.2-22.3 30.2zm222 .1l95 0 0-6.4-90.3 0-4.7 6.4zM567.3 271l-4.7 6.4 77.4 0 0-6.4-72.7 0zm-13.5 18.3l86.2 0 0-6.4-81.5 0-4.7 6.4zM389.6 210.7l-22.5 30.6-26.2 0 22.5-30.6-58.7 0-39.3 53.4 143.6 0 39.3-53.4-58.7 0zM423.1 271s-4.3 5.9-6.4 8.7c-7.4 10-.9 21.6 23.2 21.6l94.3 0 22.3-30.3-133.4 0z"]
  };
  var faTex = {
    prefix: 'fab',
    iconName: 'tex',
    icon: [640, 512, [], "e7ff", "M620.8 95.4c-30.8 .4-42.1 16.6-47.7 24.5l-.1 .1-55.7 80.5 82.8 121.1c7.5 10.6 11.3 12.5 35.4 12.5l0 9.1c-9.1-.7-28-.7-37.7-.7-12.4 0-30.8 0-42.9 .7l0-9.1c13.2-.8 16.6-7.3 16.6-10.2 0-1.1 0-2.3-3-6.4l-65.5-96.3-60.2 87.9c-1.9 2.7-3.8 5.4-3.8 10.2 0 6.1 3.4 13.6 15 14.7l0 9.1c-9.4-.7-27.1-.7-37.2-.7l-2.8 0-11.7 82.6-195.9 0 0-9.1c26.7 0 30.9 0 30.9-16.9l0-203.2c0-16.9-4.3-16.9-30.9-16.9l0-10.3 19.8 0c-4.8-61.1-10.8-71.7-68-71.8l-20.7 0c-6.8 1.5-6.8 6.1-6.8 14.4l0 205c0 13.6 1.1 17.8 32.4 17.8l10.5 0 0 9.1-.4 0c-17.9-.3-36.7-.7-54.9-.7s-36.9 .3-54.8 .7l-.6 0 0-9.1 10.7 0c31.7 0 32.8-4.1 32.8-17.8l0-205c0-8.7 0-13.2-7.2-14.3l-20.8 0c-58.4 0-63.7 10.9-68.6 73.3l-6.8 0 6.3-83.3 217.5 0 6.1 81.8 164.1 0 9 83.3-6.8 0c-5.3-49.8-12.1-73-70.3-73l-51.5 0c-15 0-15.8 1.9-15.8 14.6l0 93.3 35.5 0c35.5 0 38.9-12.8 38.9-44l6 0 0 97.9-6 0c0-31.8-3.4-44.8-38.9-44.8l-35.5 0 0 105.2c0 13 .7 14.8 15.8 14.8l52.2 0c61.1 0 69.9-25.8 77.4-73.6-7.7 0-16.3 .2-22.2 .7l0-9.1c7.2 0 31.7-.4 47.8-23.8l65.5-95.7-72.7-106.7c-8.3-11.7-15.1-12.5-35.8-12.5l0-9.1c9.1 .7 27.9 .7 37.7 .7 12.4 0 30.8 0 42.9-.7l0 9.1c-12.5 .4-16.6 6.8-16.6 10.2 0 1.1 .4 2.3 3 6.4l55.7 81.6 49.7-72.1c2.7-3.7 4.5-6.8 4.5-11.3 0-6.1-3-13.6-15-14.8l0-9.1c9.4 .7 24.8 .7 37.2 .7 9 0 23.3 0 32-.7l0 9.1z"]
  };
  var faShopify = {
    prefix: 'fab',
    iconName: 'shopify',
    icon: [448, 512, [], "e057", "M388.5 104.1c-.2-1.1-.7-2.1-1.5-2.8s-1.8-1.2-2.9-1.2c-2 0-37.2-.8-37.2-.8s-21.6-20.8-29.6-28.8l0 432.7 125.7-31.2s-54-365.5-54.4-367.9zM288.9 70.5c-1.9-6.1-4.3-11.9-7.2-17.6-10.4-20-26-30.9-44.4-30.9-1.3 0-2.7 .1-4 .4-.4-.8-1.2-1.2-1.6-2-8-8.8-18.4-12.8-30.8-12.4-24 .8-48 18-67.2 48.8-13.6 21.6-24 48.8-26.8 70.1-27.6 8.4-46.8 14.4-47.2 14.8-14 4.4-14.4 4.8-16 18-1.2 10-38 291.8-38 291.8l302.6 52.5 0-438.3c-1.5 .1-2.9 .2-4.4 .4 0 0-5.6 1.6-14.8 4.4zM233.6 87.7c-16 4.8-33.6 10.4-50.8 15.6 4.8-18.8 14.4-37.6 25.6-50 4.4-4.4 10.4-9.6 17.2-12.8 6.8 14.4 8.4 34 8 47.2zM200.8 24.4c5-.2 10 1.1 14.4 3.6-6.4 3.2-12.8 8.4-18.8 14.4-15.2 16.4-26.8 42-31.6 66.5-14.4 4.4-28.8 8.8-42 12.8 8.8-38.4 41.2-96.4 78-97.2zM154.4 244.6c1.6 25.6 69.2 31.2 73.2 91.7 2.8 47.6-25.2 80.1-65.6 82.5-48.8 3.2-75.6-25.6-75.6-25.6l10.4-44s26.8 20.4 48.4 18.8c14-.8 19.2-12.4 18.8-20.4-2-33.6-57.2-31.6-60.8-86.9-3.2-46.4 27.2-93.3 94.5-97.7 26-1.6 39.2 4.8 39.2 4.8l-15.2 57.6s-17.2-8-37.6-6.4c-29.6 2-30 20.8-29.6 25.6zM249.6 82.9c0-12-1.6-29.2-7.2-43.6 18.4 3.6 27.2 24 31.2 36.4-7.2 2-15.2 4.4-24 7.2z"]
  };
  var faSquareReddit = {
    prefix: 'fab',
    iconName: 'square-reddit',
    icon: [448, 512, ["reddit-square"], "f1a2", "M64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96C0 60.7 28.7 32 64 32zM305.9 166.4c20.6 0 37.3-16.7 37.3-37.3s-16.7-37.3-37.3-37.3c-18 0-33.1 12.8-36.6 29.8-30.2 3.2-53.8 28.8-53.8 59.9l0 .2c-32.8 1.4-62.8 10.7-86.6 25.5-8.8-6.8-19.9-10.9-32-10.9-28.9 0-52.3 23.4-52.3 52.3 0 21 12.3 39 30.1 47.4 1.7 60.7 67.9 109.6 149.3 109.6s147.6-48.9 149.3-109.7c17.7-8.4 29.9-26.4 29.9-47.3 0-28.9-23.4-52.3-52.3-52.3-12 0-23 4-31.9 10.8-24-14.9-54.3-24.2-87.5-25.4l0-.1c0-22.2 16.5-40.7 37.9-43.7 3.9 16.5 18.7 28.7 36.3 28.7l.2-.2zM155 248.1c14.6 0 25.8 15.4 25 34.4s-11.8 25.9-26.5 25.9-27.5-7.7-26.6-26.7 13.5-33.5 28.1-33.5l0-.1zm166.4 33.5c.9 19-12 26.7-26.6 26.7s-25.6-6.9-26.5-25.9 10.3-34.4 25-34.4 27.3 14.6 28.1 33.5l0 .1zm-42.1 49.6c-9 21.5-30.3 36.7-55.1 36.7s-46.1-15.1-55.1-36.7c-1.1-2.6 .7-5.4 3.4-5.7 16.1-1.6 33.5-2.5 51.7-2.5s35.6 .9 51.7 2.5c2.7 .3 4.5 3.1 3.4 5.7z"]
  };
  var faRedditSquare = faSquareReddit;
  var faCreativeCommonsNc = {
    prefix: 'fab',
    iconName: 'creative-commons-nc',
    icon: [512, 512, [], "f4e8", "M255.6 8C395.4 8 504 115.9 504 256 504 403.2 385.5 504 255.6 504 121.1 504 8 393.2 8 256 8 123.1 112.7 8 255.6 8zM63.8 189.1c-7.4 20.4-11.1 42.7-11.1 66.9 0 110.9 92.1 202.4 203.7 202.4 122.4 0 177.2-101.8 178.5-104.1l-93.4-41.6c-7.7 37.1-41.2 53-68.2 55.4l0 38.1-28.8 0 0-38.2c-27.5-.3-52.6-10.2-75.3-29.7l34.1-34.5c31.7 29.4 86.4 31.8 86.4-2.2 0-6.2-2.2-11.2-6.6-15.1-14.2-6-1.8-.1-219.3-97.4zM256.4 52.3C218 52.3 144 61 85.9 145.3l94.8 42.5c10-31.3 40.4-42.9 63.8-44.3l0-38.1 28.8 0 0 38.1c22.7 1.2 43.4 8.9 62 23L303 199.7c-42.7-29.9-83.5-8-70 11.1 53.4 24.1 43.8 19.8 93 41.6l127.1 56.7c4.1-17.4 6.2-35.1 6.2-53.1 0-57-19.8-105-59.3-143.9-39.3-39.9-87.2-59.8-143.6-59.8z"]
  };
  var faGalacticRepublic = {
    prefix: 'fab',
    iconName: 'galactic-republic',
    icon: [512, 512, [], "f50c", "M256 8a248 248 0 1 1 0 496 248 248 0 1 1 0-496zm0 16.5a231.5 231.5 0 1 0 0 462.9 231.5 231.5 0 1 0 0-462.9zm27.6 21.8l0 24.6c30.3 4.5 59 16.3 83.6 34.5l17.4-17.4c-28.7-22.1-63.3-36.9-101-41.8zm-55.4 .1c-37.6 4.9-72.2 19.8-100.9 41.9l17.3 17.4 .1 0c24.1-17.8 52.6-30.1 83.5-34.7l0-24.5zm12.2 50.2l0 82.9c-10 2-19.4 5.9-27.7 11.4l-58.6-58.6-21.9 21.9 58.7 58.7c-5.5 8.2-9.4 17.6-11.5 27.6l-82.9 0 0 31 82.9 0c2 10 6 19.3 11.5 27.5l-58.7 58.7 21.9 21.9 58.6-58.6c8.4 5.6 17.8 9.5 27.7 11.5l0 82.9 31 0 0-82.9c10-2 19.4-6.1 27.6-11.5l58.7 58.7 21.9-21.9-58.7-58.7c5.5-8.2 9.5-17.5 11.5-27.5l82.9 0 0-31-82.9 0c-2-10-6-19.4-11.5-27.6l58.7-58.7-21.9-21.9-58.7 58.7c-8.2-5.5-17.6-9.5-27.6-11.5l0-82.9-31 0zm183.2 30.7l-17.4 17.4c18.3 24.6 30.2 53.4 34.7 83.7l24.6 0c-5-37.7-19.8-72.3-41.9-101zm-335.6 .1c-22.1 28.7-36.9 63.3-41.8 100.9l24.6 0c4.6-31 16.8-59.4 34.6-83.5L88.2 127.4zM46.3 283.7c4.9 37.6 19.7 72.2 41.8 100.9l17.4-17.4C87.7 343.1 75.6 314.6 71 283.7l-24.6 0 0 0zm394.7 0c-4.6 31-16.8 59.5-34.7 83.6l17.4 17.4c22.1-28.7 37-63.3 41.9-101l-24.6 0zM144.7 406.4l-17.4 17.4c28.7 22.1 63.3 37 101 41.9l0-24.6c-31-4.6-59.5-16.8-83.6-34.6zm222.5 0c-24.1 17.8-52.6 30.1-83.6 34.7l0 24.6c37.7-4.9 72.2-19.8 101-41.8l-17.3-17.4-.1 0z"]
  };
  var faFacebook = {
    prefix: 'fab',
    iconName: 'facebook',
    icon: [512, 512, [62000], "f09a", "M512 256C512 114.6 397.4 0 256 0S0 114.6 0 256C0 376 82.7 476.8 194.2 504.5l0-170.3-52.8 0 0-78.2 52.8 0 0-33.7c0-87.1 39.4-127.5 125-127.5 16.2 0 44.2 3.2 55.7 6.4l0 70.8c-6-.6-16.5-1-29.6-1-42 0-58.2 15.9-58.2 57.2l0 27.8 83.6 0-14.4 78.2-69.3 0 0 175.9C413.8 494.8 512 386.9 512 256z"]
  };
  var faGitlab = {
    prefix: 'fab',
    iconName: 'gitlab',
    icon: [512, 512, [], "f296", "M504 204.6l-.7-1.8-69.7-181.8c-1.4-3.6-3.9-6.6-7.2-8.6-2.4-1.6-5.1-2.5-8-2.8s-5.7 .1-8.4 1.1-5.1 2.7-7.1 4.8c-1.9 2.1-3.3 4.7-4.1 7.4l-47 144-190.5 0-47.1-144c-.8-2.8-2.2-5.3-4.1-7.4-2-2.1-4.4-3.7-7.1-4.8-2.6-1-5.5-1.4-8.4-1.1s-5.6 1.2-8 2.8c-3.2 2-5.8 5.1-7.2 8.6L9.8 202.8 9 204.6c-10 26.2-11.3 55-3.5 82 7.7 26.9 24 50.7 46.4 67.6l.3 .2 .6 .4 106 79.5c38.5 29.1 66.7 50.3 84.6 63.9 3.7 1.9 8.3 4.3 13 4.3s9.3-2.4 13-4.3c17.9-13.5 46.1-34.9 84.6-63.9l106.7-79.9 .3-.3c22.4-16.9 38.7-40.6 45.6-67.5 8.6-27 7.4-55.8-2.6-82z"]
  };
  var faQq = {
    prefix: 'fab',
    iconName: 'qq',
    icon: [448, 512, [], "f1d6", "M434.1 420.4c-11.5 1.4-44.9-52.7-44.9-52.7 0 31.3-16.1 72.2-51 101.8 16.8 5.2 54.8 19.2 45.8 34.4-7.3 12.3-125.5 7.9-159.6 4-34.1 3.8-152.3 8.3-159.6-4-9-15.2 28.9-29.2 45.8-34.4-34.9-29.5-51.1-70.4-51.1-101.8 0 0-33.3 54.1-44.9 52.7-5.4-.6-12.4-29.6 9.3-99.7 10.3-33 22-60.5 40.1-105.8-3.1-116.9 45.2-215 160.3-215 113.7 0 163.2 96.1 160.3 215 18.1 45.2 29.9 72.9 40.1 105.8 21.8 70.1 14.7 99.1 9.3 99.7z"]
  };
  var faStripe = {
    prefix: 'fab',
    iconName: 'stripe',
    icon: [640, 512, [], "f429", "M165 144.7l-43.3 9.2-.2 142.4c0 26.3 19.8 43.3 46.1 43.3 14.6 0 25.3-2.7 31.2-5.9l0-33.8c-5.7 2.3-33.7 10.5-33.7-15.7l0-63.2 33.7 0 0-37.8-33.7 0-.1-38.5zm89.1 51.6l-2.7-13.1-38.4 0 0 153.2 44.3 0 0-103.1c10.5-13.8 28.2-11.1 33.9-9.3l0-40.8c-6-2.1-26.7-6-37.1 13.1zM346.4 124l-44.6 9.5 0 36.2 44.6-9.5 0-36.2zM44.9 228.3c0-6.9 5.8-9.6 15.1-9.7 13.5 0 30.7 4.1 44.2 11.4l0-41.8c-14.7-5.8-29.4-8.1-44.1-8.1-36 0-60 18.8-60 50.2 0 49.2 67.5 41.2 67.5 62.4 0 8.2-7.1 10.9-17 10.9-14.7 0-33.7-6.1-48.6-14.2l0 40c16.5 7.1 33.2 10.1 48.5 10.1 36.9 0 62.3-15.8 62.3-47.8 0-52.9-67.9-43.4-67.9-63.4zM640 261.6c0-45.5-22-81.4-64.2-81.4s-67.9 35.9-67.9 81.1c0 53.5 30.3 78.2 73.5 78.2 21.2 0 37.1-4.8 49.2-11.5l0-33.4c-12.1 6.1-26 9.8-43.6 9.8-17.3 0-32.5-6.1-34.5-26.9l86.9 0c.2-2.3 .6-11.6 .6-15.9zm-87.9-16.8c0-20 12.3-28.4 23.4-28.4 10.9 0 22.5 8.4 22.5 28.4l-45.9 0zM439.2 180.2c-17.4 0-28.6 8.2-34.8 13.9l-2.3-11-39.1 0 0 204.8 44.4-9.4 .1-50.2c6.4 4.7 15.9 11.2 31.4 11.2 31.8 0 60.8-23.2 60.8-79.6 .1-51.6-29.3-79.7-60.5-79.7zM428.6 302.7c-10.4 0-16.6-3.8-20.9-8.4l-.3-66c4.6-5.1 11-8.8 21.2-8.8 16.2 0 27.4 18.2 27.4 41.4 .1 23.9-10.9 41.8-27.4 41.8zM301.9 336.4l44.6 0 0-153.2-44.6 0 0 153.2z"]
  };
  var faDailymotion = {
    prefix: 'fab',
    iconName: 'dailymotion',
    icon: [448, 512, [], "e052", "M298.9 267c-7.4-4.2-15.8-6.3-24.4-6.2-13.2 0-24.4 4.4-33.4 13.3s-13.6 20-13.6 33.4c0 14.1 4.4 25.6 13.3 34.6s20 13.4 33.4 13.4c13.7 0 25-4.6 34.1-13.8S322 321.1 322 307.5c0-8.2-2.1-16.3-6.1-23.5-4-7.1-9.8-13-17-17zM0 32l0 448 448 0 0-448-448 0zM374.7 405.3l-53.1 0 0-23.9-.7 0c-10.5 17.5-29.1 26.2-55.8 26.2-18.4 0-34.7-4.4-48.9-13.1-14.1-8.6-25.5-21-32.9-35.8-7.7-15.1-11.6-32.1-11.6-50.9 0-18.4 3.9-35.1 11.8-50.2 7.5-14.7 18.9-27.1 32.9-35.8 14.1-8.7 30-13.1 47.7-13.1 10.2-.1 20.2 1.6 29.7 5.2 8.9 3.5 17.2 9.1 25 17l0-77.9 55.8-12.1 0 264.4z"]
  };
  var faSteam = {
    prefix: 'fab',
    iconName: 'steam',
    icon: [512, 512, [], "f1b6", "M504 256c0 137-111.2 248-248.4 248-113.8 0-209.6-76.3-239-180.4l95.2 39.3c6.4 32.1 34.9 56.4 68.9 56.4 39.2 0 71.9-32.4 70.2-73.5l84.5-60.2c52.1 1.3 95.8-40.9 95.8-93.5 0-51.6-42-93.5-93.7-93.5s-93.7 42-93.7 93.5l0 1.2-59.2 85.7c-15.5-.9-30.7 3.4-43.5 12.1L8 236.1C18.2 108.4 125.1 8 255.6 8 392.8 8 504 119 504 256zM163.7 384.3l-30.5-12.6c5.6 11.6 15.3 20.8 27.2 25.8 26.9 11.2 57.8-1.6 69-28.4 5.4-13 5.5-27.3 .1-40.3S214 305.6 201 300.2c-12.9-5.4-26.7-5.2-38.9-.6l31.5 13c19.8 8.2 29.2 30.9 20.9 50.7-8.3 19.9-31 29.2-50.8 21zM337.5 129.8a62.3 62.3 0 1 1 0 124.6 62.3 62.3 0 1 1 0-124.6zm.1 109a46.8 46.8 0 1 0 0-93.6 46.8 46.8 0 1 0 0 93.6z"]
  };
  var faSnapchat = {
    prefix: 'fab',
    iconName: 'snapchat',
    icon: [512, 512, [62124, "snapchat-ghost"], "f2ab", "M497.1 366.6c-3.4-9.2-9.8-14.1-17.1-18.2-1.4-.8-2.6-1.5-3.7-1.9-2.2-1.1-4.4-2.2-6.6-3.4-22.8-12.1-40.6-27.3-53-45.4-3.5-5.1-6.6-10.5-9.1-16.1-1.1-3-1-4.7-.2-6.3 .8-1.2 1.7-2.2 2.9-3 3.9-2.6 8-5.2 10.7-7 4.9-3.2 8.8-5.7 11.2-7.4 9.4-6.5 15.9-13.5 20-21.3 2.9-5.4 4.5-11.3 4.9-17.4s-.6-12.2-2.8-17.8c-6.2-16.3-21.6-26.4-40.3-26.4-3.9 0-7.9 .4-11.7 1.2-1 .2-2.1 .5-3.1 .7 .2-11.2-.1-22.9-1.1-34.5-3.5-40.8-17.8-62.1-32.7-79.2-9.5-10.7-20.7-19.7-33.2-26.7-22.6-12.9-48.2-19.4-76.1-19.4s-53.4 6.5-76 19.4c-12.5 7-23.7 16.1-33.3 26.8-14.9 17-29.2 38.4-32.7 79.2-1 11.6-1.2 23.4-1.1 34.5-1-.3-2-.5-3.1-.7-3.9-.8-7.8-1.2-11.7-1.2-18.7 0-34.1 10.1-40.3 26.4-2.2 5.7-3.2 11.8-2.8 17.8s2 12 4.9 17.4c4.1 7.8 10.7 14.7 20 21.3 2.5 1.7 6.4 4.2 11.2 7.4 2.6 1.7 6.5 4.2 10.3 6.7 1.3 .9 2.4 2 3.3 3.3 .8 1.6 .8 3.4-.4 6.6-2.5 5.5-5.5 10.8-8.9 15.8-12.1 17.7-29.4 32.6-51.4 44.6-11.7 6.2-23.9 10.3-29 24.3-3.9 10.5-1.3 22.5 8.5 32.6 3.6 3.8 7.8 6.9 12.4 9.4 9.6 5.3 19.8 9.3 30.3 12.1 2.2 .6 4.3 1.5 6.1 2.7 3.6 3.1 3.1 7.9 7.8 14.8 2.4 3.6 5.4 6.7 9 9.1 10 6.9 21.3 7.4 33.2 7.8 10.8 .4 23 .9 36.9 5.5 5.8 1.9 11.8 5.6 18.7 9.9 16.7 10.3 39.6 24.3 77.8 24.3s61.3-14.1 78.1-24.4c6.9-4.2 12.9-7.9 18.5-9.8 13.9-4.6 26.2-5.1 36.9-5.5 11.9-.5 23.2-.9 33.2-7.8 4.2-2.9 7.7-6.7 10.2-11.2 3.4-5.8 3.4-9.9 6.6-12.8 1.8-1.2 3.7-2.1 5.8-2.6 10.7-2.8 21-6.9 30.8-12.2 4.9-2.6 9.3-6.1 13-10.2l.1-.2c9.2-9.9 11.5-21.5 7.8-31.8zm-34 18.3c-20.7 11.5-34.5 10.2-45.3 17.1-9.1 5.9-3.7 18.5-10.3 23.1-8.1 5.6-32.2-.4-63.2 9.9-25.6 8.5-42 32.8-88 32.8s-62-24.3-88.1-32.9c-31-10.3-55.1-4.2-63.2-9.9-6.6-4.6-1.2-17.2-10.3-23.1-10.7-6.9-24.5-5.7-45.3-17.1-13.2-7.3-5.7-11.8-1.3-13.9 75.1-36.4 87.1-92.6 87.7-96.7 .6-5 1.4-9-4.2-14.1-5.4-5-29.2-19.7-35.8-24.3-10.9-7.6-15.7-15.3-12.2-24.6 2.5-6.5 8.5-8.9 14.9-8.9 2 0 4 .2 6 .7 12 2.6 23.7 8.6 30.4 10.2 .8 .2 1.6 .3 2.5 .3 3.6 0 4.9-1.8 4.6-5.9-.8-13.1-2.6-38.7-.6-62.6 2.8-32.9 13.4-49.2 26-63.6 6.1-6.9 34.5-37 88.9-37S339 74.2 345 81.1c12.6 14.4 23.2 30.7 26 63.6 2.1 23.9 .3 49.5-.6 62.6-.3 4.3 1 5.9 4.6 5.9 .8 0 1.7-.1 2.5-.3 6.7-1.6 18.4-7.6 30.4-10.2 2-.4 4-.7 6-.7 6.4 0 12.4 2.5 14.9 8.9 3.5 9.4-1.2 17-12.2 24.6-6.6 4.6-30.4 19.3-35.8 24.3-5.6 5.1-4.8 9.1-4.2 14.2 .5 4.2 12.5 60.4 87.7 96.7 4.4 2.2 11.9 6.7-1.3 14.1z"]
  };
  var faSnapchatGhost = faSnapchat;
  var faGalacticSenate = {
    prefix: 'fab',
    iconName: 'galactic-senate',
    icon: [512, 512, [], "f50d", "M249.9 33.5l0 26.1c-13.6 20.6-23.9 108.6-24.5 215.3 11.7-15.6 19.1-33.3 19.1-48.2l0-16.9c0-5.3 .8-10.5 2.2-15.6 .6-2.1 1.4-4.1 2.6-5.8s3.4-3.8 6.7-3.8 5.4 2.1 6.7 3.8c1.2 1.8 2 3.7 2.6 5.8 1.4 5.1 2.2 10.3 2.2 15.6l0 16.9c0 14.9 7.4 32.6 19.1 48.2-.6-106.8-10.9-194.7-24.5-215.3l0-26.1-12.3 0zM223.5 181.3c-9.5 2.1-18.7 5.2-27.5 9.1 8.9 16.1 9.8 32.6 1.7 37.3-8 4.6-21.8-4.2-31.4-19.8-11.6 8.8-21.9 19.3-30.6 31.1 14.7 9.6 22.9 22.9 18.3 30.7-4.5 7.7-20 7.1-35.5-1-5.8 13.2-9.7 27.5-11.6 42.4 9.7 .2 18.7 2.4 26.2 6 17.8-.3 32.8-2 40.5-4.2 5.6-26.4 23-48.2 46.3-59.5 .7-25.6 1.9-49.7 3.5-72.1zm65 0c1.6 22.4 2.7 46.5 3.5 72.1 23.3 11.3 40.8 33.2 46.3 59.5 7.7 2.3 22.7 3.9 40.5 4.2 7.5-3.7 16.5-5.8 26.2-6-1.9-14.9-5.9-29.2-11.7-42.4-15.4 8.1-30.9 8.7-35.5 1-4.6-7.7 3.6-21.1 18.3-30.7-8.7-11.8-19-22.3-30.6-31.1-9.5 15.6-23.4 24.4-31.4 19.8-8.1-4.6-7.2-21.2 1.7-37.3-8.8-3.9-18-7-27.4-9.1zM256 189.9c-3.2 0-5.9 8.8-6.1 19.9l0 0 0 16.9c0 41.4-49 95-93.5 95-52 0-122.8-1.4-156.4 29.2l0 2.5c9.4 17.1 20.6 33.2 33.2 48 12.5-21.1 51.6-41 108-41.4 45.7 1 79 20.3 90.8 40.9 0 0 0 0 0 .1 7.7 2.1 15.8 3.2 24 3.2 8.2 0 16.4-1.1 24-3.2 0 0 0 0 0-.1 11.7-20.5 45.1-39.8 90.8-40.9 56.4 .4 95.5 20.3 108 41.4 12.6-14.8 23.8-30.9 33.2-48l0-2.5c-33.6-30.6-104.4-29.2-156.4-29.2-44.5 0-93.5-53.6-93.5-95l0-16.9-.1 0c-.2-11.1-2.9-19.9-6.1-19.9zm0 177.9a40.6 40.6 0 1 1 0-81.3 40.6 40.6 0 1 1 0 81.3zm0-73.6a33 33 0 1 0 0 65.9 33 33 0 1 0 0-65.9zm0 59.8a26.8 26.8 0 1 1 0-53.6 26.8 26.8 0 1 1 0 53.6zm-114.8 13c-10.2 .1-21.6 .4-30.5 1.7 .4 4.4 1.5 18.6 7.1 29.8 9.1-2.6 18.4-3.9 27.6-3.9 41.3 .9 71.5 34.4 78.3 74.5l.1 4.7c10.4 1.9 21.2 2.9 32.2 2.9 11 0 21.8-1 32.2-2.9l.1-4.7c6.8-40.1 37-73.5 78.3-74.5 9.3 0 18.5 1.3 27.6 3.9 5.6-11.1 6.7-25.3 7.1-29.8-8.9-1.3-20.3-1.6-30.5-1.7-18.8 .4-35.2 4.2-48.6 9.7-12.5 16-29.2 30-49.6 33.1-.1 0-.2 0-.3 0 0 0-.1 0-.2 .1-5.2 1.1-10.6 1.6-16.2 1.6-5.5 0-10.9-.5-16.2-1.6-.1 0-.1 0-.2-.1-.1 0-.2 0-.3 0-20.4-3-37-17-49.6-33.1-13.4-5.5-29.9-9.2-48.6-9.7z"]
  };
  var faPhoenixFramework = {
    prefix: 'fab',
    iconName: 'phoenix-framework',
    icon: [640, 512, [], "f3dc", "M212.9 344.3c3.8-.1 22.8-1.4 25.6-2.2-2.4-2.6-43.6-1-68-49.6-4.3-8.6-7.5-17.6-6.4-27.6 2.9-25.5 32.9-30 52-18.5 36 21.6 63.3 91.3 113.7 97.5 37 4.5 84.6-17 108.2-45.4-.6-.1-.8-.2-1-.1-.4 .1-.8 .2-1.1 .3-33.3 12.1-94.3 9.7-134.7-14.8-37.6-22.8-53.1-58.7-51.8-74.6 1.8-21.3 22.9-23.2 35.9-19.6 14.4 3.9 24.4 17.6 38.9 27.4 15.6 10.4 32.9 13.7 51.3 10.3 14.9-2.7 34.4-12.3 36.5-14.5-1.1-.1-1.8-.1-2.5-.2-6.2-.6-12.4-.8-18.5-1.7-111.2-16.5-128.9-163.6-252.5-173.1-44.3-3.4-99.4 8.1-136.3 35-.8 .6-1.5 1.2-2.2 1.8 .1 .2 .1 .3 .2 .5 .8 0 1.6-.1 2.4-.2 6.3-1 12.5-.8 18.7 .3 23.8 4.3 47.7 23.1 55.9 76.5 5.3 34.3-.7 50.8 8 86.1 19 77.1 91 107.6 127.7 106.4zM75.3 64.9c-.9-1-.9-1.2-1.3-2 12.1-2.6 24.2-4.1 36.6-4.8-1.1 14.7-22.2 21.3-35.3 6.8zM272.2 415.4c-42.8 1.2-92-26.7-123.5-61.4-4.6-5-16.8-20.2-18.6-23.4l.4-.4c6.6 4.1 25.7 18.6 54.8 27 24.2 7 48.1 6.3 71.6-3.3 22.7-9.3 41-.5 43.1 2.9-18.5 3.8-20.1 4.4-24 7.9-5.1 4.4-4.6 11.7 7 17.2 26.2 12.4 63-2.8 97.2 25.4 2.4 2 8.1 7.8 10.1 10.7-.1 .2-.3 .3-.4 .5-4.8-1.5-16.4-7.5-40.2-9.3-24.7-2-46.3 5.3-77.5 6.2zM447 163.4c16.4-5.2 41.3-13.4 66.5-3.3 16.1 6.5 26.2 18.7 32.1 34.6 3.5 9.4 5.1 19.7 5.1 28.7-.2 0-.4 0-.6 .1-.2-.4-.4-.9-.5-1.3-5-22-29.9-43.8-67.6-29.9-50.2 18.6-130.4 9.7-176.9-48-.7-.9-2.4-1.7-1.3-3.2 .1-.2 2.1 .6 3 1.3 18.1 13.4 38.3 21.9 60.3 26.2 30.5 6.1 54.6 2.9 79.9-5.2zM549.7 280.9c-32.4 .2-33.8 50.1-103.6 64.4-18.2 3.7-38.7 4.6-44.9 4.2l0-.4c2.8-1.5 14.7-2.6 29.7-16.6 7.9-7.3 15.3-15.1 22.8-22.9 19.5-20.2 41.4-42.2 81.9-39 23.1 1.8 29.3 8.2 36.1 12.7 .3 .2 .4 .5 .7 .9-.5 0-.7 .1-.9 0-7-2.7-14.3-3.3-21.8-3.3zm-12.3-24.1c-.1 .2-.1 .4-.2 .6-28.9-4.4-48-7.9-68.5 4-17 9.9-31.4 20.5-62 24.4-27.1 3.4-45.1 2.4-66.1-8-.3-.2-.6-.4-1-.6 0-.2 .1-.3 .1-.5 24.9 3.8 36.4 5.1 55.5-5.8 22.3-12.9 40.1-26.6 71.3-31 29.6-4.1 51.3 2.5 70.9 16.9zM268.6 97.3c-.6-.6-1.1-1.2-2.1-2.3 7.6 0 29.7-1.2 53.4 8.4 19.7 8 32.2 21 50.2 32.9 11.1 7.3 23.4 9.3 36.4 8.1 4.3-.4 8.5-1.2 12.8-1.7 .4-.1 .9 0 1.5 .3-.6 .4-1.2 .9-1.8 1.2-8.1 4-16.7 6.3-25.6 7.1-26.1 2.6-50.3-3.7-73.4-15.4-19.3-9.9-36.4-22.9-51.4-38.6zM640 335.7c-3.5 3.1-22.7 11.6-42.7 5.3-12.3-3.9-19.5-14.9-31.6-24.1-10-7.6-20.9-7.9-28.1-8.4 .6-.8 .9-1.2 1.2-1.4 14.8-9.2 30.5-12.2 47.3-6.5 12.5 4.2 19.2 13.5 30.4 24.2 10.8 10.4 21 9.9 23.1 10.5 .1-.1 .2 0 .4 .4zm-212.5 137c2.2 1.2 1.6 1.5 1.5 2-18.5-1.4-33.9-7.6-46.8-22.2-21.8-24.7-41.7-27.9-48.6-29.7 .5-.2 .8-.4 1.1-.4 13.1 .1 26.1 .7 38.9 3.9 25.3 6.4 35 25.4 41.6 35.3 3.2 4.8 7.3 8.3 12.3 11.1z"]
  };
  var faGit = {
    prefix: 'fab',
    iconName: 'git',
    icon: [512, 512, [], "f1d3", "M216.3 158.4l-79.3 0c-40-10.5-130.5-7.8-130.5 74.8 0 30.1 15 51.2 35 61-25.1 23-37 33.8-37 49.2 0 11 4.5 21.1 17.9 26.8-14.3 13.4-22.4 23.1-22.4 41.4 0 32.1 28 50.8 101.6 50.8 70.8 0 111.8-26.4 111.8-73.2 0-58.7-45.2-56.5-151.6-63l13.4-21.6c27.3 7.6 118.7 10 118.7-67.9 0-18.7-7.7-31.7-15-41.1l37.4-2.8 0-34.5zM152.9 400.3c0 32.1-104.9 32.1-104.9 2.4 0-8.1 5.3-15 10.6-21.5 77.7 5.3 94.3 3.4 94.3 19.1zM102.1 265.7c-52.8 0-50.5-71.2 1.2-71.2 49.5 0 50.8 71.2-1.2 71.2zM235.4 366.2l0-32.1c26.7-3.7 27.2-2 27.2-11l0-119.5c0-8.5-2.1-7.4-27.2-16.3l4.5-32.9 84.2 0 0 168.7c0 6.5 .4 7.3 6.5 8.1l20.7 2.8 0 32.1-115.9 0zm52.5-244.3c-23.2 0-36.6-13.4-36.6-36.6s13.4-35.8 36.6-35.8c23.6 0 37 12.6 37 35.8s-13.4 36.6-37 36.6zM512 350.5c-17.5 8.5-43.1 16.3-66.3 16.3-48.4 0-66.7-19.5-66.7-65.5l0-106.5c0-5.4 1-4.1-31.7-4.1l0-36.2c35.8-4.1 50-22 54.5-66.3l38.6 0c0 65.8-1.3 61.8 3.3 61.8l57.3 0 0 40.6-60.6 0 0 97.1c0 6.9-4.9 51.4 60.6 26.8l11 35.8z"]
  };
  var faOptinMonster = {
    prefix: 'fab',
    iconName: 'optin-monster',
    icon: [576, 512, [], "f23c", "M572.8 421.4c5.6-9.5 4.7-15.2-5.4-11.6-3-4.9-7-9.5-11.1-13.8 2.9-9.7-.7-14.2-10.8-9.2-4.6-3.2-10.3-6.5-15.9-9.2 0-15.1-11.6-11.6-17.6-5.7-10.4-1.5-18.7-.3-26.8 5.7 .3-6.5 .3-13 .3-19.7 12.6 0 40.2-11 45.9-36.2 1.4-6.8 1.6-13.8-.3-21.9-3-13.5-14.3-21.3-25.1-25.7-.8-5.9-7.6-14.3-14.9-15.9s-12.4 4.9-14.1 10.3c-8.5 0-19.2 2.8-21.1 8.4-5.4-.5-11.1-1.4-16.8-1.9 2.7-1.9 5.4-3.5 8.4-4.6 5.4-9.2 14.6-11.4 25.7-11.6l0-2.8c19.5-.5 43-5.9 53.8-18.1 12.7-13.8 14.6-37.3 12.4-55.1-2.4-17.3-9.7-37.6-24.6-48.1-8.4-5.9-21.6-.8-22.7 9.5-2.2 19.6 1.2 30-38.6 25.1-10.3-23.8-24.6-44.6-42.7-60-69.6-59.7-167.7-53.8-244.2-37.6 19.7 4.6 41.1 8.6 59.7 16.5-26.2 2.4-52.7 11.3-76.2 23.2-32.8 17-44 29.9-56.7 42.4 14.9-2.2 28.9-5.1 43.8-3.8-9.7 5.4-18.4 12.2-26.5 20-25.8 .9-23.8-5.3-26.2-25.9-1.1-10.5-14.3-15.4-22.7-9.7-28.1 19.9-33.5 79.9-12.2 103.5 10.8 12.2 35.1 17.3 54.9 17.8-.3 1.1-.3 1.9-.3 2.7 10.8 .5 19.5 2.7 24.6 11.6 3 1.1 5.7 2.7 8.1 4.6-5.4 .5-11.1 1.4-16.5 1.9-3.3-6.6-13.7-8.1-21.1-8.1-1.6-5.7-6.5-12.2-14.1-10.3-6.8 1.9-14.1 10-14.9 15.9-22.5 9.5-30.1 26.8-25.1 47.6 5.3 24.8 33 36.2 45.9 36.2l0 19.7c-6.6-5-14.3-7.5-26.8-5.7-5.5-5.5-17.3-10.1-17.3 5.7-5.9 2.7-11.4 5.9-15.9 9.2-9.8-4.9-13.6-1.7-11.1 9.2-4.1 4.3-7.8 8.6-11.1 13.8-10.2-3.7-11 2.2-5.4 11.6-1.1 3.5-1.6 7-1.9 10.8-.5 31.6 44.6 64 73.5 65.1 17.3 .5 34.6-8.4 43-23.5 113.2 4.9 226.7 4.1 340.2 0 8.1 15.1 25.4 24.3 42.7 23.5 29.2-1.1 74.3-33.5 73.5-65.1 .2-3.7-.7-7.2-1.7-10.7zM499 167.4c1.1-3 2.4-8.4 2.4-14.6 0-5.9 6.8-8.1 14.1-.8 11.1 11.6 14.9 40.5 13.8 51.1-4.1-13.6-13-29-30.3-35.7zm-4.6 6.7c19.5 6.2 28.6 27.6 29.7 48.9-1.1 2.7-3 5.4-4.9 7.6-5.7 5.9-15.4 10-26.2 12.2 4.3-21.3 .3-47.3-12.7-63 4.9-.8 10.9-2.4 14.1-5.7zm-24.1 6.8c13.8 11.9 20 39.2 14.1 63.5-4.1 .5-8.1 .8-11.6 .8-1.9-21.9-6.8-44-14.3-64.6 3.7 .3 8.1 .3 11.8 .3zM47.7 203c-1.1-10.5 2.4-39.5 13.8-51.1 7-7.3 14.1-5.1 14.1 .8 0 6.2 1.4 11.6 2.4 14.6-17.3 6.8-26.2 22.2-30.3 35.7zm9.7 27.6c-1.9-2.2-3.5-4.9-4.9-7.6 1.4-21.3 10.3-42.7 29.7-48.9 3.2 3.2 9.2 4.9 14.1 5.7-13 15.7-17 41.6-12.7 63-10.8-2.2-20.5-6-26.2-12.2zm47.9 14.6c-4.1 0-8.1-.3-12.7-.8-4.6-18.6-1.9-38.9 5.4-53l0 .3 12.2-5.1c4.9-1.9 9.7-3.8 14.9-4.9-10.7 19.7-17.4 41.3-19.8 63.5zm184-10.5a76.1 76.1 0 1 1 0-152.2 76.1 76.1 0 1 1 0 152.2zm115.6 22.1c-.3 17.8-7 48.9-23 57-13.2 6.6-6.5-7.5-16.5-58.1 13.3 .3 26.6 .3 39.5 1.1zm-54-1.6c.8 4.9 3.8 40.3-1.6 41.9-11.6 3.5-40 4.3-51.1-1.1-4.1-3-4.6-35.9-4.3-41.1l0 .3c18.9-.3 38.1-.3 57 0zM278.5 309c-13 3.5-41.6 4.1-54.6-1.6-6.5-2.7-3.8-42.4-1.9-51.6 19.2-.5 38.4-.5 57.8-.8l0 .3c1.1 8.3 3.3 51.2-1.3 53.7zM172 257.9c12.2-.8 24.6-1.4 36.8-1.6-2.4 15.4-3 43.5-4.9 52.2-1.1 6.8-4.3 6.8-9.7 4.3-21.9-9.8-27.6-35.2-22.2-54.9zm-35.4 31.3c7.8-1.1 15.7-1.9 23.5-2.7 1.6 6.2 3.8 11.9 7 17.6 10 17 44 35.7 45.1 7 6.2 14.9 40.8 12.2 54.9 10.8 15.7-1.4 23.8-1.4 26.8-14.3 12.4 4.3 30.8 4.1 44 3 11.3-.8 20.8-.5 24.6-8.9 1.1 5.1 1.9 11.6 4.6 16.8 10.8 21.3 37.3 1.4 46.8-31.6 8.6 .8 17.6 1.9 26.5 2.7-.4 1.3-3.8 7.3 7.3 11.6-47.6 47-95.7 87.8-163.2 107-63.2-20.8-112.1-59.5-155.9-106.5 9.6-3.4 10.4-8.8 8-12.5zM115 461.7c-3.8 17.8-21.9 29.7-39.7 28.9-19.2-.8-46.5-17-59.2-36.5-2.7-31.1 43.8-61.3 66.2-54.6 14.9 4.3 27.8 30.8 33.5 54 0 3-.3 5.7-.8 8.2zm-8.7-66c-.5-13.5-.5-27-.3-40.5l.3 0c2.7-1.6 5.7-3.8 7.8-6.5 6.5-1.6 13-5.1 15.1-9.2 3.3-7.1-7-7.5-5.4-12.4 2.7-1.1 5.7-2.2 7.8-3.5 29.2 29.2 58.6 56.5 97.3 77-36.8 11.3-72.4 27.6-105.9 47-1.2-18.6-7.7-35.9-16.7-51.9zm337.6 64.6c-103 3.5-206.2 4.1-309.4 0 0 .3 0 .3-.3 .3l0-.3 .3 0c35.1-21.6 72.2-39.2 112.4-50.8 11.6 5.1 23 9.5 34.9 13.2 2.2 .8 2.2 .8 4.3 0 14.3-4.1 28.4-9.2 42.2-15.4 41.5 11.7 78.8 31.7 115.6 53zm10.5-12.4c-35.9-19.5-73-35.9-111.9-47.6 38.1-20 71.9-47.3 103.5-76.7 2.2 1.4 4.6 2.4 7.6 3.2 0 .8 .3 1.9 .5 2.4-4.6 2.7-7.8 6.2-5.9 10.3 2.2 3.8 8.6 7.6 15.1 8.9 2.4 2.7 5.1 5.1 8.1 6.8 0 13.8-.3 27.6-.8 41.3l.3-.3c-9.3 15.9-15.5 37-16.5 51.7zm105.9 6.2c-12.7 19.5-40 35.7-59.2 36.5-19.3 .9-40.5-13.2-40.5-37 5.7-23.2 18.9-49.7 33.5-54 22.7-6.9 69.2 23.4 66.2 54.5zM373.1 75.2c-3.8-72.1-100.8-79.7-126-23.5 44.6-24.3 90.3-15.7 126 23.5zM75 407.1c-15.7 1.6-49.5 25.4-49.5 43.2 0 11.6 15.7 19.5 32.2 14.9 12.2-3.2 31.1-17.6 35.9-27.3 6-11.6-3.7-32.7-18.6-30.8zM290.9 230.9c28.6 0 51.9-21.6 51.9-48.4 0-36.1-40.5-58.1-72.2-44.3 9.5 3 16.5 11.6 16.5 21.6 0 23.3-33.3 32-46.5 11.3-7.3 34.1 19.4 59.8 50.3 59.8zM68.2 474.1c.5 6.5 12.2 12.7 21.6 9.5 6.8-2.7 14.6-10.5 17.3-16.2 3-7-1.1-20-9.7-18.4-8.9 1.6-29.7 16.7-29.2 25.1zm433.2-67c-14.9-1.9-24.6 19.2-18.9 30.8 4.9 9.7 24.1 24.1 36.2 27.3 16.5 4.6 32.2-3.2 32.2-14.9 0-17.8-33.8-41.6-49.5-43.2zM479 449c-8.4-1.6-12.4 11.3-9.5 18.4 2.4 5.7 10.3 13.5 17.3 16.2 9.2 3.2 21.1-3 21.3-9.5 .9-8.4-20.2-23.5-29.1-25.1z"]
  };
  var faJenkins = {
    prefix: 'fab',
    iconName: 'jenkins',
    icon: [448, 512, [], "f3b6", "M455.4 425c-1.4-11.2-19-23.1-28.2-31.9-5.1-5-29-23.1-30.4-29.9-1.4-6.6 9.7-21.5 13.3-28.9 5.1-10.7 8.8-23.7 11.3-32.6 18.8-66.1 20.7-156.9-6.2-211.2-10.2-20.6-38.6-49-56.4-62.5-42-31.7-119.6-35.3-170.1-16.6-14.1 5.2-27.8 9.8-40.1 17.1-33.1 19.4-68.3 32.5-78.1 71.6-24.2 10.8-31.5 41.8-30.3 77.8 .2 7 4.1 15.8 2.7 22.4-.7 3.3-5.2 7.6-6.1 9.8-11.6 27.7-2.3 64 11.1 83.7 8.1 11.9 21.5 22.4 39.2 25.2 .7 10.6 3.3 19.7 8.2 30.4 3.1 6.8 14.7 19 10.4 27.7-2.2 4.4-21 13.8-27.3 17.6-21.1 12.5-36.4 20.3-55.9 34.3-12.6 9-32.3 10.2-29.2 31.1 2.1 14.1 10.1 31.6 14.7 45.8 .7 2 1.4 4.1 2.1 6l422 0c4.9-15.3 9.7-30.9 14.6-47.2 3.4-11.4 10.2-27.8 8.7-39.7zM174.2 33.7c1.8-.5 3.4 .7 4.9 2.4-.2 5.2-5.4 5.1-8.9 6.8-5.4 6.7-13.4 9.8-20 17.2-6.8 7.5-14.4 27.7-23.4 30-4.5 1.1-9.7-.8-13.6-.5-10.4 .7-17.7 6-28.3 7.5 13.6-29.9 56.1-54 89.3-63.4zM69.4 127.3c13.5-14.9 32.1-24.1 54.8-25.9 11.7 29.7-8.4 65-.9 97.6 2.3 9.9 10.2 25.4-2.4 25.7 .3-28.3-34.8-46.3-61.3-29.6-1.8-21.5-4.9-51.7 9.8-67.8zm36.7 200.2c-1-4.1-2.7-12.9-2.3-15.1 1.6-8.7 17.1-12.5 11-24.7-11.3-.1-13.8 10.2-24.1 11.3-26.7 2.6-45.6-35.4-44.4-58.4 1-19.5 17.6-38.2 40.1-35.8 16 1.8 21.4 19.2 24.5 34.7 9.2 .5 22.5-.4 26.9-7.6-.6-17.5-8.8-31.6-8.2-47.7 1-30.3 17.5-57.6 4.8-87.4 13.6-30.9 53.5-55.3 83.1-70 36.6-18.3 94.9-3.7 129.3 15.8 19.7 11.1 34.4 32.7 48.3 50.7-19.5-5.8-36.1 4.2-33.1 20.3 16.3-14.9 44.2-.2 52.5 16.4 7.9 15.8 7.8 39.3 9 62.8 2.9 57-10.4 115.9-39.1 157.1-7.7 11-14.1 23-24.9 30.6-26 18.2-65.4 34.7-99.2 23.4-44.7-15-65-44.8-89.5-78.8 .7 18.7 13.8 34.1 26.8 48.4 11.3 12.5 25 26.6 39.7 32.4-12.3-2.9-31.1-3.8-36.2 7.2-28.6-1.9-55.1-4.8-68.7-24.2-10.6-15.4-21.4-41.4-26.3-61.4zm222 124.1c4.1-3 11.1-2.9 17.4-3.6-5.4-2.7-13-3.7-19.3-2.2-.1-4.2-2-6.8-3.2-10.2 10.6-3.8 35.5-28.5 49.6-20.3 6.7 3.9 9.5 26.2 10.1 37 .4 9-.8 18-4.5 22.8-18.8-.6-35.8-2.8-50.7-7 .9-6.1-1-12.1 .6-16.5zm-17.2-20c-16.8 .8-26-1.2-38.3-10.8 .2-.8 1.4-.5 1.5-1.4 18 8 40.8-3.3 59-4.9-7.9 5.1-14.6 11.6-22.2 17.1zm-12.1 33.2c-1.6-9.4-3.5-12-2.8-20.2 25-16.6 29.7 28.6 2.8 20.2zM194.3 438.6c-11.6-.7-48.1-14-38.5-23.7 9.4 6.5 27.5 4.9 41.3 7.3 .8 4.4-2.8 10.2-2.8 16.4zM26 497.1c-4.3-12.7-9.2-25.1-14.8-36.9 30.8-23.8 65.3-48.9 102.2-63.5 2.8-1.1 23.2 25.4 26.2 27.6 16.5 11.7 37 21 56.2 30.2 1.2 8.8 3.9 20.2 8.7 35.5 .7 2.3 1.4 4.7 2.2 7.2l-180.7 0 0-.1zm240.6 5.7l-.8 0c.3-.2 .5-.4 .8-.5l0 .5zm7.5-5.7c2.1-1.4 4.3-2.8 6.4-4.3 1.1 1.4 2.2 2.8 3.2 4.3l-9.6 0zm15.1-24.7c-10.8 7.3-20.6 18.3-33.3 25.2-6 3.3-27 11.7-33.4 10.2-3.6-.8-3.9-5.3-5.4-9.5-3.1-9-10.1-23.4-10.8-37-.8-17.2-2.5-46 16-42.4 14.9 2.9 32.3 9.7 43.9 16.1 7.1 3.9 11.1 8.6 21.9 9.5-.1 1.4-.1 2.8-.2 4.3-5.9 3.9-15.3 3.8-21.8 7.1 9.5 .4 17 2.7 23.5 5.9-.1 3.4-.3 7-.4 10.6zm53.4 24.7l-14 0c-.1-3.2-2.8-5.8-6.1-5.8s-5.9 2.6-6.1 5.8l-17.4 0c-2.8-4.4-5.7-8.6-8.9-12.5 2.1-2.2 4-4.7 6-6.9 9 3.7 14.8-4.9 21.7-4.2 7.9 .8 14.2 11.7 25.4 11l-.6 12.6zm8.7 0c.2-4 .4-7.8 .6-11.5 15.6-7.3 29 1.3 35.7 11.5l-36.3 0zm83.4-37c-2.3 11.2-5.8 24-9.9 37.1-.2-.1-.4-.1-.6-.1l-27.9 0c.6-1.1 1.2-2.2 1.9-3.3-2.6-6.1-9-8.7-10.9-15.5 12.1-22.7 6.5-93.4-24.2-78.5 4.3-6.3 15.6-11.5 20.8-19.3 13 10.4 20.8 20.3 33.2 31.4 6.8 6 20 13.3 21.4 23.1 .8 5.5-2.6 18.9-3.8 25.1zM190.5 130.5c5.4-14.9 27.2-34.7 45-32 7.7 1.2 18 8.2 12.2 17.7-30.2-7-45.2 12.6-54.4 33.1-8.1-2-4.9-13.1-2.8-18.8zm184.1 63.1c8.2-3.6 22.4-.7 29.6-5.3-4.2-11.5-10.3-21.4-9.3-37.7 .5 0 1 0 1.4 .1 6.8 14.2 12.7 29.2 21.4 41.7-5.7 13.5-43.6 25.4-43.1 1.2zm-96.8 2.7c-6.8-10.9-19-32.5-14.5-45.3 6.5 11.9 8.6 24.4 17.8 33.3 4.1 4 12.2 9 8.2 20.2-.9 2.7-7.8 8.6-11.7 9.7-14.4 4.3-47.9 .9-36.6-17.1 11.9 .7 27.9 7.8 36.8-.8zm27.3 70c3.8 6.6 1.4 18.7 12.1 20.6 20.2 3.4 43.6-12.3 58.1-17.8 9-15.2-.8-20.7-8.9-30.5-16.6-20-38.8-44.8-38-74.7 6.7-4.9 7.3 7.4 8.2 9.7 8.7 20.3 30.4 46.2 46.3 63.5 3.9 4.3 10.3 8.4 11 11.2 2.1 8.2-5.4 18-4.5 23.5-21.7 13.9-45.8 29.1-81.4 25.6-7.4-6.7-10.3-21.4-2.9-31.1zm-201.3-9.2c-6.8-3.9-8.4-21-16.4-21.4-11.4-.7-9.3 22.2-9.3 35.5-7.8-7.1-9.2-29.1-3.5-40.3-6.6-3.2-9.5 3.6-13.1 5.9 4.7-34.1 49.8-15.8 42.3 20.3zm299.6 28.8c-10.1 19.2-24.4 40.4-54 41-.6-6.2-1.1-15.6 0-19.4 22.7-2.2 36.6-13.7 54-21.6zM261.5 298.3c18.9 9.9 53.6 11 79.3 10.2 1.4 5.6 1.3 12.6 1.4 19.4-33 1.8-72-6.4-80.7-29.6zM353.7 345c-1.7 4.3-5.3 9.3-9.8 11.1-12.1 4.9-45.6 8.7-62.4-.3-10.7-5.7-17.5-18.5-23.4-26-2.8-3.6-16.9-12.9-.2-12.9 13.1 32.7 58 29 95.8 28.1z"]
  };
  var faSlideshare = {
    prefix: 'fab',
    iconName: 'slideshare',
    icon: [512, 512, [], "f1e7", "M187.9 153.7c-34 0-61.7 25.7-61.7 57.7 0 31.7 27.7 57.7 61.7 57.7s61.7-26 61.7-57.7c0-32-27.7-57.7-61.7-57.7zm143.4 0c-34 0-61.7 25.7-61.7 57.7 0 31.7 27.7 57.7 61.7 57.7 34.3 0 61.7-26 61.7-57.7 .1-32-27.4-57.7-61.7-57.7zm156.6 90l-6 4.3 0-198.3c0-27.4-20.6-49.7-46-49.7L76.8 0c-25.4 0-46 22.3-46 49.7l0 198.3c-2-1.4-4.3-2.9-6.3-4.3-15.1-10.6-25.1 4-16 17.7 18.3 22.6 53.1 50.3 106.3 72-56.3 191.7 137.4 222.3 134.3 124.1 0-.7 .3-56.6 .3-96.6 5.1 1.1 9.4 2.3 13.7 3.1 0 39.7 .3 92.8 .3 93.5-3.1 98.3 190.6 67.7 134.3-124 53.1-21.7 88-49.4 106.3-72 9.1-13.8-.9-28.3-16.1-17.8zm-30.5 19.2c-68.9 37.4-128.3 31.1-160.6 29.7-23.7-.9-32.6 9.1-33.7 24.9-10.3-7.7-18.6-15.5-20.3-17.1-5.1-5.4-13.7-8-27.1-7.7-31.7 1.1-89.7 7.4-157.4-28l0-192.4c0-34.9 8.9-45.7 40.6-45.7l317.7 0c30.3 0 40.9 12.9 40.9 45.7l0 190.6-.1 0z"]
  };
  var faUber = {
    prefix: 'fab',
    iconName: 'uber',
    icon: [448, 512, [], "f402", "M414.1 32L33.9 32C15.2 32 0 47.2 0 65.9L0 446c0 18.8 15.2 34 33.9 34L414 480c18.7 0 33.9-15.2 33.9-33.9l0-380.2C448 47.2 432.8 32 414.1 32zM237.6 391.1C163 398.6 96.4 344.2 88.9 269.6l94.4 0 0 20.4c0 3.7 3 6.8 6.8 6.8l67.9 0c3.7 0 6.8-3 6.8-6.8l0-67.9c0-3.7-3-6.8-6.8-6.8l-67.9 0c-3.7 0-6.8 3-6.8 6.8l0 20.4-94.4 0c7-69.4 65.4-122.2 135.1-122.2s128.1 52.8 135.1 122.2c7.5 74.5-46.9 141.1-121.5 148.6z"]
  };
  var faDigitalOcean = {
    prefix: 'fab',
    iconName: 'digital-ocean',
    icon: [512, 512, [], "f391", "M87 481.8l73.7 0 0-73.6-73.7 0 0 73.6zM25.4 346.6l0 61.6 61.6 0 0-61.6-61.6 0zM491.6 176.9C468.6 102.7 409.2 43.6 335 20.3 164.9-32.8 8 93.7 8 255.9l95.8 0c0-101.8 101-180.5 208.1-141.7 39.7 14.3 71.5 46.1 85.8 85.7 39.1 107-39.7 207.8-141.4 208l0 .3-.3 0 0 95.8c162.6 0 288.8-156.8 235.6-327.1zm-235.3 231l0-95.3-95.6 0 0 95.6 95.3 0 0-.3 .3 0z"]
  };
  var faSoundcloud = {
    prefix: 'fab',
    iconName: 'soundcloud',
    icon: [640, 512, [], "f1be", "M640.2 298.6c-1.3 23.1-11.5 44.8-28.4 60.5s-39.2 24.4-62.3 24.1l-218 0c-4.8 0-9.4-2-12.8-5.4s-5.3-8-5.3-12.8l0-234.8c-.2-4 .9-8 3.1-11.4s5.3-6.1 9-7.7c0 0 20.1-13.9 62.3-13.9 25.8 0 51.1 6.9 73.3 20.1 17.3 10.2 32.3 23.8 44.1 40.1s20 34.8 24.2 54.4c7.5-2.1 15.3-3.2 23.1-3.2 11.7-.1 23.3 2.2 34.2 6.7s20.5 11.3 28.7 19.7 14.6 18.3 18.9 29.3 6.3 22.6 5.9 34.3zm-354-153.5c.1-1 0-2-.3-2.9s-.8-1.8-1.5-2.6-1.5-1.3-2.4-1.7c-1.8-.8-4-.8-5.8 0-.9 .4-1.7 1-2.4 1.7s-1.2 1.6-1.5 2.6-.4 1.9-.3 2.9c-6 78.9-10.6 152.9 0 231.6 .2 1.7 1 3.3 2.3 4.5 2.6 2.4 6.8 2.4 9.4 0 1.3-1.2 2.1-2.8 2.3-4.5 11.3-79.4 6.6-152 0-231.6l.2 0zm-44 27.3c-.2-1.8-1.1-3.5-2.4-4.7s-3.1-1.9-5-1.9-3.6 .7-5 1.9-2.2 2.9-2.4 4.7c-7.9 67.9-7.9 136.5 0 204.4 .3 1.8 1.2 3.4 2.5 4.5s3.1 1.8 4.8 1.8 3.5-.6 4.8-1.8 2.2-2.8 2.5-4.5c8.8-67.8 8.8-136.5 .1-204.4l.1 0zm-44.3-6.9c-.2-1.8-1-3.4-2.3-4.6s-3-1.8-4.8-1.8-3.5 .7-4.8 1.8-2.1 2.8-2.3 4.6c-6.7 72-10.2 139.3 0 211.1 0 1.9 .7 3.7 2.1 5s3.1 2.1 5 2.1 3.7-.7 5-2.1 2.1-3.1 2.1-5c10.5-72.8 7.3-138.2 .1-211.1l-.1 0zm-44 20.6c0-1.9-.8-3.8-2.1-5.2s-3.2-2.1-5.2-2.1-3.8 .8-5.2 2.1-2.1 3.2-2.1 5.2c-8.1 63.3-8.1 127.5 0 190.8 .2 1.8 1 3.4 2.4 4.6s3.1 1.9 4.8 1.9 3.5-.7 4.8-1.9 2.2-2.8 2.4-4.6c8.8-63.3 8.9-127.5 .3-190.8l-.1 0zm-44.5 47.6c0-1.9-.8-3.8-2.1-5.1s-3.2-2.1-5.1-2.1-3.8 .8-5.1 2.1-2.1 3.2-2.1 5.1c-10.5 49.2-5.5 93.9 .4 143.6 .3 1.6 1.1 3.1 2.3 4.2s2.8 1.7 4.5 1.7 3.2-.6 4.5-1.7 2.1-2.5 2.3-4.2c6.6-50.4 11.6-94.1 .4-143.6zm-44.1-7.5c-.2-1.8-1.1-3.5-2.4-4.8s-3.2-1.9-5-1.9-3.6 .7-5 1.9-2.2 2.9-2.4 4.8c-9.3 50.2-6.2 94.4 .3 144.5 .7 7.6 13.6 7.5 14.4 0 7.2-50.9 10.5-93.8 .3-144.5l-.2 0zM20.7 250.8c-.2-1.8-1.1-3.5-2.4-4.8s-3.2-1.9-5-1.9-3.6 .7-5 1.9-2.3 2.9-2.4 4.8c-8.5 33.7-5.9 61.6 .6 95.4 .2 1.7 1 3.3 2.3 4.4s2.9 1.8 4.7 1.8 3.4-.6 4.7-1.8 2.1-2.7 2.3-4.4c7.5-34.5 11.2-61.8 .4-95.4l-.2 0z"]
  };
  var faSquareFigma = {
    prefix: 'fab',
    iconName: 'square-figma',
    icon: [448, 512, [], "e7e4", "M384 32c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96C0 60.7 28.7 32 64 32l320 0zM173.7 96c-33 0-59.8 26.8-59.8 59.8 0 21 10.8 39.4 27.2 50.1-16.4 10.7-27.2 29.1-27.2 50.1s10.8 39.5 27.2 50.1c-16.4 10.7-27.2 29.1-27.2 50.1 0 33.1 27.1 59.8 60.1 59.8 33.2 0 60.6-26.9 60.6-60.3l0-55.7c10.6 9.8 24.8 15.8 40.4 15.8l1.1 0c33 0 59.8-26.8 59.8-59.8 0-21-10.8-39.5-27.2-50.1 16.4-10.7 27.2-29.1 27.2-50.1 0-33-26.8-59.8-59.8-59.8L173.7 96zm41.6 219.8l0 39.9c0 22.6-18.6 41-41.3 41-22.4 0-40.7-18.2-40.7-40.5 0-22.3 18.1-40.4 40.3-40.4l41.7 0zm0-100.3l0 80.9-41.7 0c-22.3-.1-40.3-18.2-40.3-40.5 0-22.3 18.1-40.5 40.5-40.5l41.6 0zm60.8 0c22.3 0 40.5 18.1 40.5 40.5s-18.1 40.5-40.5 40.5l-1.1 0c-22.3 0-40.4-18.1-40.4-40.5s18.1-40.5 40.4-40.5l1.1 0zm-60.8-19.3l-41.6 0c-22.3 0-40.5-18.1-40.5-40.4s18.1-40.5 40.5-40.5l41.6 0 0 80.9zm60.8-80.9c22.3 0 40.5 18.1 40.5 40.5s-18.1 40.4-40.5 40.4l-41.5 0 0-80.9 41.5 0z"]
  };
  var faCreativeCommonsSa = {
    prefix: 'fab',
    iconName: 'creative-commons-sa',
    icon: [512, 512, [], "f4ef", "M255.6 8C397.4 8 504 118.1 504 256 504 403.1 385.5 504 255.6 504 121.6 504 8 394.5 8 256 8 123.1 112.7 8 255.6 8zm.8 44.7c-118.2 0-203.7 97.9-203.7 203.3 0 109.8 91.2 202.8 203.7 202.8 103.2 0 202.8-81.1 202.8-202.8 .1-113.8-90.2-203.3-202.8-203.3zM145.7 221c13-83.9 80.5-95.7 108.9-95.7 99.8 0 127.5 82.5 127.5 134.2 0 63.6-41 132.9-128.9 132.9-38.9 0-99.1-20-109.4-97l62.5 0c1.5 30.1 19.6 45.2 54.5 45.2 23.3 0 58-18.2 58-82.8 0-82.5-49.1-80.6-56.7-80.6-33.1 0-51.7 14.6-55.8 43.8l18.2 0-49.2 49.2-49-49.2 19.4 0z"]
  };
  var faChrome = {
    prefix: 'fab',
    iconName: 'chrome',
    icon: [512, 512, [], "f268", "M0 256c0-46.6 12.5-90.4 34.3-128.9L144.1 318.3c21.9 39.2 63.8 65.7 111.9 65.7 14.3 0 27.1-2.3 40.8-6.6L220.5 509.6C95.9 492.3 0 385.3 0 256zm365.1 65.6c12.3-19.2 18.9-42.5 18.9-65.6 0-38.2-16.8-72.5-43.3-96l152.7 0c12 29.6 18.6 62.1 18.6 96 0 141.4-114.6 255.1-256 256L365.1 321.6zM477.8 128L256 128c-62.9 0-113.7 44.1-125.5 102.7L54.2 98.5C101 38.5 174 0 256 0 350.8 0 433.5 51.5 477.8 128zM344 256a88 88 0 1 1 -176 0 88 88 0 1 1 176 0z"]
  };
  var faTradeFederation = {
    prefix: 'fab',
    iconName: 'trade-federation',
    icon: [512, 512, [], "f513", "M256 8.8a247.2 247.2 0 1 0 0 494.4 247.2 247.2 0 1 0 0-494.4zm0 11.6a235.6 235.6 0 1 1 0 471.2 235.6 235.6 0 1 1 0-471.2zM411.1 163.1l0-46.8-193.8 0 0 81.7-155.1 0 36.7 46 117.7 0 0 196.8 48.8 0 0-195.8 83.3 0 0-47-83.3 0 0-34.8 145.7 0 0-.1zm-73.3 45.1l0 23.9-82.9 0 0 197.4-26.8 0 0-197.4-123.8 0-20.1-23.9 143.9 0 0-80.6 171.8 0 0 24.4-145 0 0 56.2 82.9 0zm-161.3-69l-12.4-20.7 2.1 23.8-23.5 5.4 23.3 5.4-2.1 24 12.3-20.5 22.2 9.5-15.7-18.1 15.8-18.1-22 9.3zm-29.6-19.7l9.3-11.5-12.7 5.9-8-12.4 1.7 13.9-14.3 3.8 13.7 2.7-.8 14.7 6.8-12.2 13.8 5.3-9.5-10.2zM312.3 264.7l-13.1 5.6-7.3-12.2 1.3 14.2-13.9 3.2 13.9 3.2-1.2 14.2 7.3-12.2 13.1 5.5-9.4-10.7 9.3-10.8zm106.9-77.2l-20.9 9.1-12-19.6 2.2 22.7-22.3 5.4 22.2 4.9-1.8 22.9 11.5-19.6 21.2 8.8-15.1-17 15-17.6zM256 29.9a226.1 226.1 0 1 0 0 452.2 226.1 226.1 0 1 0 0-452.2zM350.6 196l0 51-83.3 0 0 195.7-52.7 0 0-196.8-116.7 0-40-49.9 157.4 0 0-81.6 197.8 0 0 50.7-145.7 0 0 30.9 83.2 0zM256 43.2c60.3 0 114.8 25 153.6 65.2l-199.1 0 0 81.6-157.4 0C81.1 104.8 161.4 43.2 256 43.2zm0 427.1c-117.9 0-213.6-95.6-213.6-213.5 0-21.2 3.1-41.8 8.9-61.1l43.8 56.3 114.7 0 0 196.8 64.6 0 0-195.8 83.3 0 0-62.7-83.2 0 0-19.2 145.6 0 0-50.8c30.8 37 49.3 84.6 49.3 136.5 .1 117.9-95.5 213.5-213.4 213.5zM186.8 275l-11-21.4 1.7 24.5-23.7 3.9 23.8 5.9-3.7 23.8 13-20.9 21.5 10.8-15.8-18.8 16.9-17.1-22.7 9.3z"]
  };
  var faVaadin = {
    prefix: 'fab',
    iconName: 'vaadin',
    icon: [448, 512, [], "f408", "M224.5 140.7C226 123.1 229.4 88 274.3 88l98.6 0c20.7 0 32.1-7.8 32.1-21.6l0-12.3c0-12.2 9.3-22.1 21.5-22.1S448 41.9 448 54.1l0 36.5c0 42.9-21.5 62-66.8 62l-100.5 0c-30.1 0-33 14.7-33 27.1 0 1.3-.1 2.5-.2 3.7-.7 12.3-10.9 22.2-23.4 22.2s-22.7-9.8-23.4-22.2c-.1-1.2-.2-2.4-.2-3.7 0-12.3-3-27.1-33-27.1l-100.7 0C21.5 152.6 0 133.5 0 90.6L0 54.1C0 41.9 9.4 32 21.6 32s21.5 9.9 21.5 22.1l0 12.3C43.1 80.2 54.5 88 75.2 88l98.6 0c44.8 0 48.3 35.1 49.8 52.7l.9 0zM224 456c11.5 0 21.4-7 25.7-16.3 1.1-1.8 97.1-169.6 98.2-171.4 11.9-19.6-3.2-44.3-27.2-44.3-13.9 0-23.3 6.4-29.8 20.3L224 362 157.1 244.3c-6.4-13.9-15.9-20.3-29.8-20.3-24 0-39.1 24.6-27.2 44.3 1.1 1.9 97.1 169.6 98.2 171.4 4.3 9.3 14.2 16.3 25.7 16.3z"]
  };
  var faDeviantart = {
    prefix: 'fab',
    iconName: 'deviantart',
    icon: [320, 512, [], "f1bd", "M320 93.2l-98.2 179.1 7.4 9.5 90.8 0 0 127.7-160.9 0-13.5 9.2-43.7 84c-.3 0-8.6 8.6-9.2 9.2l-92.7 0 0-93.2 93.2-179.4-7.4-9.2-85.8 0 0-127.6 156 0 13.5-9.2 43.7-84c.3 0 8.6-8.6 9.2-9.2l97.6 0 0 93.1z"]
  };
  var faMedium = {
    prefix: 'fab',
    iconName: 'medium',
    icon: [448, 512, [62407, "medium-m"], "f23a", "M369.4 32c43.4 0 78.6 35.2 78.6 78.6l0 83.8c-1.9-.1-3.8-.2-5.7-.2l-.4 0c-10 0-22.3 2.4-31.1 6.8-10 4.6-18.7 11.5-26 20.6-11.8 14.6-18.9 34.3-20.6 56.4-.1 .7-.1 1.3-.2 2s-.1 1.2-.1 1.9c-.1 1.2-.1 2.4-.1 3.6 0 1.9-.1 3.8 0 5.8 1.2 50.1 28.2 90.2 76.3 90.2 2.7 0 5.3-.1 7.9-.4l0 20.4c0 43.4-35.2 78.6-78.6 78.6L78.6 480C35.2 480 0 444.8 0 401.4L0 110.6C0 67.2 35.2 32 78.6 32l290.8 0zM82.3 138.9l.3 .1c13.2 3 19.8 7.4 19.8 23.4l0 187.2c0 16-6.7 20.4-19.9 23.4l-.3 .1 0 2.8 52.8 0 0-2.8-.3-.1c-13.2-3-19.9-7.4-19.9-23.4l0-176.3 86.1 202.5 4.9 0 88.6-208.2 0 186.6c-1.1 12.6-7.8 16.5-19.7 19.2l-.3 .1 0 2.7 91.9 0 0-2.7-.3-.1c-11.9-2.7-18.7-6.6-19.9-19.2l-.1-191.8 .1 0c0-16 6.7-20.4 19.9-23.4l.3-.1 0-2.7-72.2 0-67 157.4-67-157.4-77.8 0 0 2.7zM448 340.3c-25.1-7.4-43-35.1-41.2-67.8l0 0 41.1 0 0 67.8zm-6.4-135.6c2.3 0 4.4 .3 6.4 .9l0 57.4-40.2 0c1.5-33.6 13.6-57.9 33.8-58.3z"]
  };
  var faMediumM = faMedium;
  var faOpencart = {
    prefix: 'fab',
    iconName: 'opencart',
    icon: [640, 512, [], "f23d", "M331.8 440.4a45.8 45.8 0 1 1 91.5 .3 45.8 45.8 0 1 1 -91.5-.3zM169.4 394.9a45.7 45.7 0 1 0 .3 91.3 45.7 45.7 0 1 0 -.3-91.3zm291.7-270c-302.2 0-379.2-12.8-461.1-99.2 34.4 51.7 53.3 148.9 373.1 144.2 333.3-5 130 86.1 70.8 188.9 186.7-166.7 319.4-233.9 17.2-233.9z"]
  };
  var faYCombinator = {
    prefix: 'fab',
    iconName: 'y-combinator',
    icon: [448, 512, [], "f23b", "M448 32l0 448-448 0 0-448 448 0zM236 287.5l77.5-145.5-32.7 0-45.8 91c-4.7 9.3-9 18.3-12.8 26.8l-12.2-26.8-45.2-91-35 0 76.7 143.8 0 94.5 29.5 0 0-92.8z"]
  };
  var faLine = {
    prefix: 'fab',
    iconName: 'line',
    icon: [512, 512, [], "f3c0", "M311 196.8l0 81.3c0 2.1-1.6 3.7-3.7 3.7l-13 0c-1.3 0-2.4-.7-3-1.5L254 230 254 278.2c0 2.1-1.6 3.7-3.7 3.7l-13 0c-2.1 0-3.7-1.6-3.7-3.7l0-81.3c0-2.1 1.6-3.7 3.7-3.7l12.9 0c1.1 0 2.4 .6 3 1.6l37.3 50.3 0-48.2c0-2.1 1.6-3.7 3.7-3.7l13 0c2.1-.1 3.8 1.6 3.8 3.5l0 .1zm-93.7-3.7l-13 0c-2.1 0-3.7 1.6-3.7 3.7l0 81.3c0 2.1 1.6 3.7 3.7 3.7l13 0c2.1 0 3.7-1.6 3.7-3.7l0-81.3c0-1.9-1.6-3.7-3.7-3.7zm-31.4 68.1l-35.6 0 0-64.4c0-2.1-1.6-3.7-3.7-3.7l-13 0c-2.1 0-3.7 1.6-3.7 3.7l0 81.3c0 1 .3 1.8 1 2.5 .7 .6 1.5 1 2.5 1l52.2 0c2.1 0 3.7-1.6 3.7-3.7l0-13c0-1.9-1.6-3.7-3.5-3.7l.1 0zm193.7-68.1l-52.3 0c-1.9 0-3.7 1.6-3.7 3.7l0 81.3c0 1.9 1.6 3.7 3.7 3.7l52.2 0c2.1 0 3.7-1.6 3.7-3.7l0-13.1c0-2.1-1.6-3.7-3.7-3.7l-35.5 0 0-13.6 35.5 0c2.1 0 3.7-1.6 3.7-3.7l0-13.1c0-2.1-1.6-3.7-3.7-3.7l-35.5 0 0-13.7 35.5 0c2.1 0 3.7-1.6 3.7-3.7l0-13c-.1-1.9-1.7-3.7-3.7-3.7l.1 0zM512 93.4l0 326c-.1 51.2-42.1 92.7-93.4 92.6l-326 0C41.4 511.9-.1 469.8 0 418.6l0-326C.1 41.4 42.2-.1 93.4 0l326 0c51.2 .1 92.7 42.1 92.6 93.4zM441.6 233.5c0-83.4-83.7-151.3-186.4-151.3S68.8 150.1 68.8 233.5c0 74.7 66.3 137.4 155.9 149.3 21.8 4.7 19.3 12.7 14.4 42.1-.8 4.7-3.8 18.4 16.1 10.1s107.3-63.2 146.5-108.2c27-29.7 39.9-59.8 39.9-93.1l0-.2z"]
  };
  var faAmilia = {
    prefix: 'fab',
    iconName: 'amilia',
    icon: [448, 512, [], "f36d", "M240.2 32c-61.9 0-131.5 16.9-184.2 55.4-5.1 3.1-9.1 9.2-7.2 19.4 1.1 5.1 5.1 27.4 10.2 39.6 4.1 10.2 14.2 10.2 20.3 6.1 32.5-22.3 96.5-47.7 152.3-47.7 57.9 0 58.9 28.4 58.9 73.1l0 38.5C203.1 227.7 78.3 251 46.8 264.2 11.3 280.5 16.4 357.7 16.4 376S31.6 480 141.3 480c47.8 0 113.7-20.7 153.3-42.1l0 25.4c0 3 2.1 8.2 6.1 9.1 3.1 1 50.7 2 59.9 2s62.5 .3 66.5-.7c4.1-1 5.1-6.1 5.1-9.1l0-296.6c-.1-80.3-57.9-136-192-136zm50.2 348c-21.4 13.2-48.7 24.4-79.1 24.4-52.8 0-58.9-33.5-59-44.7 0-12.2-3-42.7 18.3-52.9 24.3-13.2 75.1-29.4 119.8-33.5l0 106.7z"]
  };
  var faAsymmetrik = {
    prefix: 'fab',
    iconName: 'asymmetrik',
    icon: [576, 512, [], "f372", "M517.5 309.2c38.8-40 58.1-80 58.5-116.1 .8-65.5-59.4-118.2-169.4-135-128.7-19.7-288.5 15.5-406.6 82.4 52-26.5 110.6-48.2 170.7-58.2 74.5-20.5 153-25.4 221.3-14.8 152.5 23.8 196.8 127.5 98.8 231.7-10.2 10.8-22 21.1-35 30.6L304.9 103.4 114.7 388.9c-65.6-29.4-76.5-90.2-19.1-151.2 20.8-22.2 48.3-41.9 79.5-58.1 20-12.2 39.7-22.6 62-30.7-65.1 20.3-122.7 52.9-161.6 92.9-27.7 28.6-41.4 57.1-41.7 82.9-.5 35.1 23.4 65.1 68.4 83l-34.5 51.7 101.6 0 22-34.4c22.2 1 45.3 0 68.6-2.7l-22.8 37.1 135.5 0-32.6-53.1c18.6-5.3 36.9-11.5 54.5-18.7l45.9 71.8 101.6 0-73.4-110.4c18.5-12.1 35-25.5 48.9-39.8zM329.9 389.7l-25-40.6-32.7 53.3c-23.4 3.5-46.7 5.1-69.2 4.4l101.9-159.3 78.7 123c-17.2 7.4-35.3 13.9-53.7 19.2z"]
  };
  var faPhabricator = {
    prefix: 'fab',
    iconName: 'phabricator',
    icon: [512, 512, [], "f3db", "M331.1 262.1l-.1-13s21.7-19.8 21.1-21.2l-9.5-20c-.6-1.4-29.5-.5-29.5-.5l-9.4-9.3s.2-28.5-1.2-29.1l-20.1-9.2c-1.4-.6-20.7 21-20.7 21l-13.1-.2s-20.5-21.4-21.9-20.8l-20 8.3c-1.4 .5 .2 28.9 .2 28.9l-9.1 9.1s-29.2-.9-29.7 .4L160 226.3c-.6 1.4 21 21 21 21l.1 12.9S159.4 280 160 281.4l9.5 20c.6 1.4 29.5 .5 29.5 .5l9.4 9.3s-.2 31.8 1.2 32.3l20.1 8.3c1.4 .6 20.7-23.5 20.7-23.5l13.1 .2s20.5 23.8 21.8 23.3l20-7.5c1.4-.6-.2-32.1-.2-32.1l9.1-9.1s29.2 .9 29.7-.5l8.1-19.8c.7-1.1-20.9-20.7-20.9-20.7zm-44.9-8.7c.7 17.1-12.8 31.6-30.1 32.4s-32.1-12.5-32.8-29.6 12.8-31.6 30.1-32.3c17.3-.8 32.1 12.5 32.8 29.5zm201.2-37.9l-97-97-.1 .1c-75.1-73.3-195.4-72.8-269.8 1.6-50.9 51-27.8 27.9-95.7 95.3-22.3 22.3-22.3 58.7 0 81 69.9 69.4 46.4 46 97.4 97l.1-.1c75.1 73.3 195.4 72.9 269.8-1.6 51-50.9 27.9-27.9 95.3-95.3 22.3-22.3 22.3-58.7 0-81zM363.5 148.2a152.3 152.3 0 1 1 -215 215.6 152.3 152.3 0 1 1 215-215.6z"]
  };
  var faBots = {
    prefix: 'fab',
    iconName: 'bots',
    icon: [640, 512, [], "e340", "M86.3 197.8c-8-.1-15.9 1.7-23.1 5.1s-13.5 8.6-18.4 14.9l0-61.9c0-2.2-.9-4.3-2.4-5.8s-3.6-2.4-5.8-2.4l-28.4 0c-2.2 0-4.3 .9-5.8 2.4S0 153.8 0 156L0 333.6c0 1.1 .2 2.1 .6 3.1s1 1.9 1.8 2.7 1.7 1.4 2.7 1.8 2.1 .6 3.1 .6l28.4 0c1.1 0 2.1-.2 3.1-.6s1.9-1 2.7-1.8 1.4-1.7 1.8-2.7 .6-2.1 .6-3.1l0-8.1c11.6 13.4 25.9 19.8 41.6 19.8 34.6 0 61.9-26.2 61.9-73.8 0-45.9-27-73.6-61.9-73.6zM71.5 305.7c-9.6 0-21.2-4.9-26.7-12.5l0-43c5.5-7.6 17.2-12.8 26.7-12.8 17.7 0 31.1 13.1 31.1 34 0 21.2-13.4 34.3-31.1 34.3zm156.4-59a17.4 17.4 0 1 0 0 34.8 17.4 17.4 0 1 0 0-34.8zm46.1-90l0-44.7c2.8-1.2 5.2-3.3 6.6-6s1.9-5.8 1.3-8.9-2.2-5.7-4.6-7.7-5.4-3-8.4-3-6.1 1.1-8.4 3-4 4.7-4.6 7.7-.1 6.1 1.3 8.9 3.8 4.8 6.6 6l0 44.7c-28 1.3-54.4 13.6-73.6 34.1s-29.5 47.7-28.8 75.8 12.3 54.7 32.4 74.3 47 30.6 75.1 30.6 55-11 75.1-30.6 31.7-46.3 32.4-74.3-9.7-55.3-28.8-75.8-45.5-32.8-73.6-34.1zm86 107.4c0 30.5-40.8 55.3-91.1 55.3s-91.1-24.7-91.1-55.3 40.8-55.3 91.1-55.3 91.1 24.7 91.1 55.3l0 0zm-50.2 17.4c3.4 0 6.8-1 9.7-2.9s5.1-4.6 6.4-7.8 1.7-6.7 1-10.1-2.3-6.5-4.8-8.9-5.5-4.1-8.9-4.8-6.9-.3-10.1 1-5.9 3.5-7.8 6.4-2.9 6.2-2.9 9.7c0 4.6 1.8 9 5.1 12.3s7.7 5.1 12.3 5.1l0 0zm270.9-31c-14.8-2.6-22.4-3.8-22.4-9.9 0-5.5 7.3-9.9 17.7-9.9 12.2 .1 24.2 3.6 34.5 10.1 1.8 1.2 4 1.6 6.2 1.1s4-1.7 5.1-3.6c.1-.1 .1-.2 .2-.3l8.6-14.9c1.1-1.9 1.4-4.1 .8-6.1s-1.9-3.9-3.7-5c-15.7-9.4-33.7-14.3-52-14.1-39 0-60.2 21.5-60.2 46.2 0 36.3 33.7 41.9 57.6 45.6 13.4 2.3 24.1 4.4 24.1 11 0 6.4-5.5 10.8-18.9 10.8-13.6 0-31-6.2-42.6-13.6-.9-.6-1.9-1-3-1.2s-2.1-.2-3.2 .1-2.1 .7-2.9 1.3-1.6 1.4-2.2 2.3c0 .1-.1 .1-.1 .2l-10.2 16.9c-1.1 1.8-1.4 4-1 6s1.7 3.9 3.5 5c15.2 10.3 37.7 16.7 59.4 16.7 40.4 0 64-19.8 64-46.5 0-38.1-35.5-43.9-59.3-48.3zm-95.9 60.8c-.5-2-1.8-3.7-3.6-4.8s-3.9-1.5-5.9-1.1c-1.4 .3-2.8 .4-4.2 .4-7.8 0-12.5-6.1-12.5-14.2l0-51.2 20.3 0c2.2 0 4.2-.9 5.8-2.4s2.4-3.6 2.4-5.8l0-22.7c0-2.2-.9-4.2-2.4-5.8s-3.6-2.4-5.8-2.4l-20.3 0 0-30.2c0-2.2-.9-4.2-2.4-5.8s-3.6-2.4-5.8-2.4l-28.2 0c-2.2 0-4.2 .9-5.8 2.4s-2.4 3.6-2.4 5.8l0 30.2-15.1 0c-1.1 0-2.1 .2-3.1 .6s-1.9 1-2.6 1.8-1.4 1.7-1.8 2.6-.6 2-.6 3.1l0 22.7c0 1.1 .2 2.1 .6 3.1s1 1.9 1.8 2.6 1.7 1.4 2.6 1.8 2 .6 3.1 .6l15.1 0 0 63.7c0 27 15.4 41.3 43.9 41.3 12.2 0 21.4-2.2 27.6-5.4 1.6-.8 2.9-2.2 3.7-3.9s.9-3.6 .5-5.4l-5-19.3z"]
  };
  var faVine = {
    prefix: 'fab',
    iconName: 'vine',
    icon: [384, 512, [], "f1ca", "M384 254.7l0 52.1c-18.4 4.2-36.9 6.1-52.1 6.1-36.9 77.4-103 143.8-125.1 156.2-14 7.9-27.1 8.4-42.7-.8-27.1-16.3-129.9-100.6-164.1-365.6l74.5 0c18.7 159.1 64.5 240.7 114.8 301.8 27.9-27.9 54.8-65.1 75.6-106.9-49.8-25.3-80.1-80.9-80.1-145.6 0-65.6 37.7-115.1 102.2-115.1 114.9 0 106.2 127.9 81.6 181.5 0 0-46.4 9.2-63.5-20.5 3.4-11.3 8.2-30.8 8.2-48.5 0-31.3-11.3-46.6-28.4-46.6-18.2 0-30.8 17.1-30.8 50 .1 79.2 59.4 118.7 129.9 101.9z"]
  };
  var faMedrt = {
    prefix: 'fab',
    iconName: 'medrt',
    icon: [576, 512, [], "f3c8", "M129.7 256c0 121.8 83.9 222.8 193.5 241.1-18.7 4.5-38.2 6.9-58.2 6.9-137.6 0-249-111-249-248S127.4 8 264.9 8c20.1 0 39.6 2.4 58.2 6.9-109.6 18.3-193.4 119.3-193.4 241.1zM427.1 356.3c-77.7 55.4-179.6 47.5-240.4-14.6 5.5 14.1 12.7 27.7 21.7 40.5 61.6 88.2 182.4 109.3 269.7 47s108.1-184.3 46.5-272.6c-9-12.9-19.3-24.3-30.5-34.2 37.4 78.8 10.7 178.5-67 233.9zm-218.8-244c-1.4 1-2.7 2.1-4 3.1 64.3-17.8 135.9 4 178.9 60.5 35.7 47 42.9 106.6 24.4 158 56.7-56.2 67.6-142.1 22.3-201.8-50-65.5-149.1-74.4-221.6-19.8zM312 224c-4.4 0-8-3.6-8-8l0-40c0-4.4-3.6-8-8-8l-48 0c-4.4 0-8 3.6-8 8l0 40c0 4.4-3.6 8-8 8l-40 0c-4.4 0-8 3.6-8 8l0 48c0 4.4 3.6 8 8 8l40 0c4.4 0 8 3.6 8 8l0 40c0 4.4 3.6 8 8 8l48 0c4.4 0 8-3.6 8-8l0-40c0-4.4 3.6-8 8-8l40 0c4.4 0 8-3.6 8-8l0-48c0-4.4-3.6-8-8-8l-40 0z"]
  };
  var faOsi = {
    prefix: 'fab',
    iconName: 'osi',
    icon: [512, 512, [], "f41a", "M8 266.4c2.3-135.8 97.4-232.4 213.8-248.1 138.8-18.6 255.6 75.8 278 201.1 21.3 118.8-44 230-151.6 274-9.3 3.8-14.4 1.7-18-7.7-17.8-46.3-35.6-92.6-53.4-139-3.1-8.1-1-13.2 7-16.8 24.2-11 39.3-29.4 43.3-55.8 1.5-9.7 1-19.6-1.5-29.1s-6.9-18.4-12.9-26.1-13.6-14.1-22.2-18.8-18.1-7.5-27.9-8.3c-39-3.4-71.8 23.7-77.5 59.7-5.2 33 11.1 63.7 41.9 77.7 9.6 4.4 11.5 8.6 7.8 18.4-17.9 46.6-35.8 93.2-53.7 139.9-2.6 6.9-8.3 9.3-15.5 6.5-52.6-20.3-101.4-61-130.8-119-24.9-49.2-25.2-87.7-26.8-108.7zm20.9-1.9c.4 6.6 .6 14.3 1.3 22.1 6.3 71.9 49.6 143.5 131 183.1 3.2 1.5 4.4 .8 5.6-2.3 14.9-39.1 29.9-78.2 45-117.3 1.3-3.3 .6-4.8-2.4-6.7-31.6-19.9-47.3-48.5-45.6-86 1-21.6 9.3-40.5 23.8-56.3 30-32.7 77-39.8 115.5-17.6 15.6 9 28.2 22.3 36.2 38.4s11.2 34.2 9 52c-3.6 30.6-19.3 53.9-45.7 69.8-2.7 1.6-3.5 2.9-2.3 6 15.2 39.2 30.3 78.4 45.2 117.7 1.2 3.1 2.4 3.8 5.6 2.3 35.5-16.6 65.2-40.3 88.1-72 34.8-48.2 49.1-101.9 42.3-161-13.7-117.5-119.4-214.8-255.5-198-106.1 13-195.3 102.5-197.1 225.8z"]
  };
  var faGg = {
    prefix: 'fab',
    iconName: 'gg',
    icon: [512, 512, [], "f260", "M179.2 230.4l102.4 102.4-102.4 102.4-179.2-179.2 179.2-179.2 44.8 44.8-25.6 25.6-19.2-19.2-128 128 128 128 51.5-51.5-77.1-76.5 25.6-25.6zM332.8 76.8l-102.4 102.4 102.4 102.4 25.6-25.6-77.1-76.5 51.5-51.5 128 128-128 128-19.2-19.2-25.6 25.6 44.8 44.8 179.2-179.2-179.2-179.2z"]
  };
  var faBuysellads = {
    prefix: 'fab',
    iconName: 'buysellads',
    icon: [448, 512, [], "f20d", "M224 150.7l42.9 160.7-85.8 0 42.9-160.7zM448 80l0 352c0 26.5-21.5 48-48 48L48 480c-26.5 0-48-21.5-48-48L0 80C0 53.5 21.5 32 48 32l352 0c26.5 0 48 21.5 48 48zM382.7 405.3l-94.5-298.7-128.4 0-94.5 298.7 90.7 0 111.7-91.6 24.2 91.6 90.8 0z"]
  };
  var faGooglePlus = {
    prefix: 'fab',
    iconName: 'google-plus',
    icon: [512, 512, [], "f2b3", "M256 8a248 248 0 1 0 0 496 248 248 0 1 0 0-496zM185.3 380c-32.9 0-64.4-13.1-87.7-36.3s-36.3-54.8-36.3-87.7 13.1-64.4 36.3-87.7 54.8-36.3 87.7-36.3c31.3 0 60.1 11 83 32.3l-33.6 32.6c-13.2-12.9-31.3-19.1-49.4-19.1-42.9 0-77.2 35.5-77.2 78.1S142.3 334 185.3 334c32.6 0 64.9-19.1 70.1-53.3l-70.1 0 0-42.6 116.9 0c1.3 6.8 1.9 13.8 1.9 20.7 0 70.8-47.5 121.2-118.8 121.2zM415.5 273.8l0 35.5-35.5 0 0-35.5-35.5 0 0-35.5 35.5 0 0-35.5 35.5 0 0 35.5 35.2 0 0 35.5-35.2 0z"]
  };
  var faScreenpal = {
    prefix: 'fab',
    iconName: 'screenpal',
    icon: [512, 512, [], "e570", "M278.6 22.5a22.5 22.5 0 1 1 -45 0 22.5 22.5 0 1 1 45 0zM198.7 259a57.4 57.4 0 1 1 114.8 0 57.4 57.4 0 1 1 -114.8 0zm138.6 91c22.3-19.9 36.5-47.3 39.9-77l119.5 0c-3.5 61.4-30.4 119.2-75.2 161.4-44.7 42.2-103.9 65.8-165.4 65.8S135.4 476.6 90.7 434.4C45.9 392.2 19.1 334.4 15.5 273l119.7 0c3.4 29.7 17.6 57.1 39.9 77s51.2 30.9 81.1 30.9c29 0 58.7-11 81.1-30.9zM28.3 141.7a22.5 22.5 0 1 1 45-1.4 22.5 22.5 0 1 1 -45 1.4zm455.6-.7a22.4 22.4 0 1 1 -44.9 0 22.4 22.4 0 1 1 44.9 0zM318 95.3c-17.3 13.8-39.2 22.8-61.9 22.8s-44.6-9-61.9-22.8c-17.3-14.7-28.8-35.1-32.4-57.5 15.1-6.4 30.8-11.3 46.9-14.5 0 12.6 5 24.6 13.9 33.5s20.9 13.9 33.5 13.9 24.6-5 33.5-13.9 13.9-20.9 13.9-33.5c16.1 3.2 31.8 8.1 46.9 14.5-3.6 22.4-15.1 42.8-32.4 57.5zM82.9 231c-21.4 7.6-44.7 7.4-65.9-.6 2-16.3 5.6-32.3 10.8-47.9 5.4 3.1 11.3 5.1 17.5 6 6.2 .8 12.4 .4 18.5-1.2 6-1.7 11.6-4.4 16.6-8.2s9.1-8.5 12.2-13.9 5.1-11.4 6-17.5c.8-6.2 .4-12.5-1.2-18.5s-4.4-11.6-8.2-16.6c-3.8-4.9-8.5-9.1-13.9-12.2 10.8-12.3 22.9-23.5 36-33.3 17.6 14.3 29.5 34.5 33.6 56.8s.1 45.4-11.2 65c-11.4 19.6-29.4 34.5-50.7 42.1zm346.4 .1c-21.3-7.6-39.3-22.6-50.7-42.2-11.3-19.6-15.2-42.7-11.1-65 4.1-22.2 16-42.4 33.5-56.7 13.1 9.8 25.2 21 36 33.3-10.7 6.4-18.4 16.7-21.5 28.8-3.2 12-2.3 24.8 4.8 35.6 6.2 10.8 16.4 18.7 28.4 22s24.9 1.7 35.7-4.3c5.3 15.5 8.9 31.6 10.9 47.8-22.1 8.1-44.6 8.3-66 .7z"]
  };
  var faBitcoin = {
    prefix: 'fab',
    iconName: 'bitcoin',
    icon: [512, 512, [], "f379", "M8 256a248 248 0 1 1 496 0 248 248 0 1 1 -496 0zm354.3-35.3c4.9-33-20.2-50.7-54.6-62.6l11.1-44.7-27.2-6.8-10.9 43.5c-7.2-1.8-14.5-3.5-21.8-5.1l10.9-43.8-27.2-6.8-11.2 44.7c-5.9-1.3-11.7-2.7-17.4-4.1l0-.1-37.5-9.4-7.2 29.1s20.2 4.6 19.8 4.9c11 2.8 13 10 12.7 15.8l-12.7 50.9c.8 .2 1.7 .5 2.8 .9-.9-.2-1.9-.5-2.9-.7l-17.8 71.3c-1.3 3.3-4.8 8.4-12.5 6.5 .3 .4-19.8-4.9-19.8-4.9l-13.5 31.1 35.4 8.8c6.6 1.7 13 3.4 19.4 5l-11.3 45.2 27.2 6.8 11.2-44.7c7.2 2 14.4 3.8 21.7 5.6l-11.1 44.5 27.2 6.8 11.3-45.1c46.4 8.8 81.3 5.2 96-36.7 11.8-33.8-.6-53.3-25-66 17.8-4.1 31.2-15.8 34.7-39.9zm-62.2 87.2c-8.4 33.8-65.3 15.5-83.8 10.9l14.9-59.9c18.4 4.6 77.6 13.7 68.8 49zm8.4-87.7c-7.7 30.7-55 15.1-70.4 11.3l13.5-54.3c15.4 3.8 64.8 11 56.8 43z"]
  };
  var faSwift = {
    prefix: 'fab',
    iconName: 'swift',
    icon: [448, 512, [], "f8e1", "M448 156.1c0-4.5-.1-9-.2-13.5-.1-9.9-1-19.7-2.6-29.4-1.7-9.7-4.8-19.2-9.2-28-9-17.7-23.4-32.1-41.2-41.1-8.8-4.5-18.3-7.6-28-9.2-9.7-1.6-19.6-2.5-29.4-2.6-4.5-.1-9-.2-13.5-.2L124.1 32c-4.5 0-9 .1-13.5 .2-2.4 .1-4.9 .2-7.4 .3-7.4 .3-14.8 1.1-22.1 2.3-7.3 1.3-14.4 3.3-21.2 6.1-2.3 1-4.6 2-6.8 3.1-6.6 3.4-12.8 7.5-18.4 12.3-1.9 1.6-3.7 3.3-5.4 5-7 7-12.9 15-17.4 23.8-4.4 8.8-7.6 18.3-9.2 28-1.6 9.7-2.4 19.6-2.5 29.4-.1 4.5-.2 9-.2 13.5L0 355.9c0 4.5 .1 9 .2 13.5 .1 9.9 1 19.7 2.6 29.4 1.7 9.7 4.8 19.2 9.2 28 9 17.7 23.4 32.1 41.1 41.1 8.8 4.4 18.3 7.5 28 9.2 9.7 1.6 19.6 2.5 29.4 2.6 4.5 .1 9 .2 13.5 .2l199.8 0c4.5 0 9-.1 13.5-.2 9.9-.1 19.7-1 29.4-2.6 9.7-1.7 19.2-4.8 28-9.2 17.7-9 32.1-23.4 41.1-41.2 4.4-8.8 7.6-18.3 9.2-28 1.6-9.7 2.5-19.6 2.6-29.4 .1-4.5 .2-9 .2-13.5l0-183.8c0-5.4 0-10.7 0-16zm-69.9 241c-20-38.9-57.2-29.3-76.3-19.5-1.7 1-3.5 2-5.2 3l-.4 .2c-39.5 21-92.5 22.5-145.8-.4-43.4-18.8-80.1-50.3-105.3-90.4 12.3 9.1 25.4 16.9 39.2 23.4 56.4 26.4 113 24.5 153 0-57-43.8-104.6-101-141.1-147.2-7-8.1-13.2-16.8-18.8-25.9 43.7 40 112.7 90.2 137.5 104.1-52.6-55.5-98.9-123.9-96.7-121.7 82.8 83.4 159.2 130.6 159.2 130.6 2.9 1.6 5 2.8 6.7 4 1.6-4.1 3-8.2 4.2-12.5 13.2-48.3-1.7-103.6-35.3-149.2 76.8 46.1 122.2 133.7 103.6 207.8-.4 1.7-1 3.4-1.4 5.1 38.5 47.4 28 98.2 23.1 88.6l0 0z"]
  };
  var faFilesPinwheel = {
    prefix: 'fab',
    iconName: 'files-pinwheel',
    icon: [512, 512, [], "e69f", "M253.5 246.4L137.2 130.2c-.6-.6-1-1.3-1.4-2s-.5-1.6-.5-2.4 .2-1.6 .5-2.4 .8-1.4 1.4-2L253.6 5.1c.9-.9 2-1.5 3.2-1.7s2.5-.1 3.6 .3 2.1 1.3 2.8 2.3 1.1 2.2 1.1 3.5l0 232.5c0 1.3-.3 2.5-1 3.6s-1.7 1.9-2.9 2.4-2.5 .6-3.7 .3-2.4-.9-3.2-1.9zm40.3-4.4l0-134.4c0-.8 .1-1.6 .5-2.4s.8-1.5 1.3-2.1 1.3-1.1 2-1.4 1.6-.5 2.4-.5l134.4 0c1.2 0 2.5 .4 3.5 1.1s1.8 1.7 2.3 2.8 .6 2.4 .3 3.6-.9 2.3-1.7 3.2L304.3 246.4c-.9 .8-2 1.4-3.2 1.6s-2.4 .1-3.5-.4-2.1-1.3-2.8-2.3-1.1-2.2-1.1-3.4l.1 .1zm30.6 35c-1.2 0-2.5-.3-3.5-1s-1.9-1.6-2.4-2.8-.6-2.4-.4-3.6 .8-2.3 1.7-3.2L404 182.2c.6-.6 1.3-1 2-1.4s1.6-.5 2.4-.5 1.6 .2 2.4 .5 1.4 .8 2 1.4l84.4 84.2c.9 .9 1.5 2 1.7 3.2s.1 2.5-.3 3.6-1.3 2.1-2.3 2.8-2.2 1.1-3.5 1.1l-168.5 0 .1-.1zm90.7 131l-95.3-95.2c-.9-.9-1.5-2-1.7-3.2s-.1-2.5 .4-3.7 1.3-2.1 2.4-2.8 2.3-1 3.5-1l95.2 0c1.7 0 3.2 .7 4.4 1.8s1.8 2.8 1.8 4.4l0 95.3c0 1.2-.4 2.5-1.1 3.5s-1.7 1.8-2.8 2.3-2.4 .6-3.6 .3-2.3-.9-3.2-1.7zM16.8 302.1l216.9 0c1.2 0 2.5 .4 3.5 1.1s1.8 1.7 2.3 2.8 .6 2.4 .3 3.6-.8 2.3-1.7 3.2L129.7 421.2c-.6 .6-1.3 1-2 1.4s-1.6 .5-2.4 .5-1.6-.2-2.4-.5-1.4-.8-2-1.4L12.3 312.8c-.9-.9-1.5-2-1.7-3.2s-.1-2.5 .4-3.6 1.3-2.1 2.3-2.8 2.3-1 3.5-1l0-.1zM264.3 465.3c0 .8-.2 1.6-.5 2.4s-.8 1.5-1.4 2-1.3 1-2 1.4-1.6 .5-2.4 .5l-128 0c-1.2 0-2.5-.4-3.5-1.1s-1.8-1.7-2.3-2.8-.6-2.4-.3-3.6 .8-2.3 1.7-3.2l128-128c.9-.9 2-1.5 3.2-1.7s2.5-.1 3.6 .3 2.1 1.3 2.8 2.3 1.1 2.2 1.1 3.5l0 128zm40-132.5l82.8 82.7c.6 .6 1 1.3 1.4 2s.5 1.6 .5 2.4-.2 1.6-.5 2.4-.8 1.4-1.4 2L304.3 507c-.9 .9-2 1.5-3.2 1.7s-2.5 .1-3.6-.3-2.1-1.3-2.8-2.3-1.1-2.2-1.1-3.5l0-165.4c0-1.2 .4-2.5 1.1-3.5s1.7-1.8 2.8-2.3 2.4-.6 3.6-.3 2.3 .8 3.2 1.7zM79 122.4c0-1.2 .3-2.5 1-3.5s1.7-1.8 2.8-2.3 2.4-.6 3.6-.4 2.3 .8 3.2 1.7L238.1 266.4c.9 .9 1.5 2 1.7 3.2s.1 2.5-.3 3.6-1.3 2.1-2.3 2.8-2.2 1.1-3.5 1.1l-148.4 0c-1.7 0-3.2-.7-4.4-1.8s-1.8-2.8-1.8-4.4l0-148.4-.1-.1z"]
  };
  var faLaravel = {
    prefix: 'fab',
    iconName: 'laravel',
    icon: [512, 512, [], "f3bd", "M504.6 115.8c-.1-.2-.2-.5-.3-.7-.1-.4-.3-.8-.5-1.2-.2-.2-.3-.5-.5-.7-.2-.3-.5-.6-.7-.9-.2-.2-.5-.4-.8-.6-.3-.2-.6-.5-.9-.7L404.6 55.5c-1.2-.7-2.6-1.1-4-1.1s-2.8 .4-4 1.1L300.3 111c-.3 .2-.6 .4-.9 .7-.3 .2-.5 .4-.8 .6-.3 .3-.5 .6-.7 .9-.2 .2-.4 .4-.5 .7-.2 .4-.4 .8-.5 1.2-.1 .2-.2 .4-.3 .7-.2 .7-.3 1.4-.3 2.1l0 105.2-80.2 46.2 0-205.9c0-.7-.1-1.4-.3-2.1-.1-.2-.2-.4-.3-.7-.1-.4-.3-.8-.5-1.2-.1-.3-.4-.5-.5-.7-.2-.3-.5-.6-.7-.9-.2-.2-.5-.4-.8-.6-.3-.2-.6-.5-.9-.7L115.8 1.1c-1.2-.7-2.6-1.1-4-1.1s-2.8 .4-4 1.1L11.5 56.5c-.3 .2-.6 .4-.9 .7-.3 .2-.5 .4-.8 .6-.3 .3-.5 .6-.7 .9-.2 .3-.4 .5-.6 .7-.2 .4-.4 .8-.5 1.2-.1 .2-.2 .4-.3 .7-.2 .7-.3 1.4-.3 2.1l0 329.7c0 1.4 .4 2.8 1.1 4s1.7 2.2 2.9 2.9L204 510.9c.4 .2 .9 .4 1.3 .5 .2 .1 .4 .2 .6 .3 1.3 .4 2.8 .4 4.1 0 .2-.1 .4-.2 .6-.2 .5-.2 1-.3 1.4-.6L404.6 400.1c1.2-.7 2.2-1.7 2.9-2.9s1.1-2.6 1.1-4l0-105.3 92.2-53.1c1.2-.7 2.2-1.7 2.9-3s1.1-2.6 1.1-4l0-109.8c0-.7-.1-1.4-.2-2.1zM111.8 17.3l80.2 46.1-80.2 46.2-80.2-46.2 80.2-46.2zm88.2 60l0 201.3c-33.2 19.1-59.9 34.5-80.2 46.2l0-201.3C153 104.4 179.7 89 200 77.3zm0 412.8L23.5 388.5 23.5 77.3c20.3 11.7 47.1 27.1 80.2 46.2l0 215.2c0 .3 .1 .6 .1 .9 0 .4 .1 .8 .2 1.2 .1 .3 .2 .6 .4 .9 .1 .3 .3 .7 .4 1 .2 .3 .4 .5 .6 .8 .2 .3 .4 .6 .7 .8 .2 .2 .5 .4 .8 .6 .3 .2 .6 .5 .9 .7l92.2 52.2 .1 92.4zm8-106.2L128 338.6c54.7-31.5 113.5-65.3 176.3-101.5l80.1 46.1C355 300 296.2 333.5 208 383.9zm184.5 4.6l-176.5 101.6 0-92.3C317.4 340 376.2 306.4 392.5 297l0 91.4zm0-119.1c-20.3-11.6-47.1-27-80.2-46.1l0-91.4c20.3 11.7 47.1 27.1 80.2 46.2l0 91.3zm8-105.3l-80.2-46.2 80.2-46.2 80.2 46.1-80.2 46.2zm8 105.3l0-91.3c33.2-19.1 60-34.5 80.3-46.2l0 91.4-80.3 46.2z"]
  };
  var faWpforms = {
    prefix: 'fab',
    iconName: 'wpforms',
    icon: [448, 512, [], "f298", "M448 75.2l0 361.7c0 24.3-19 43.2-43.2 43.2l-361.6 0C19.3 480 0 461.4 0 436.8L0 75.2C0 51.1 18.8 32 43.2 32l361.7 0c24 0 43.1 18.8 43.1 43.2zM410.7 436.8l0-361.6c0-3-2.6-5.8-5.8-5.8l-9.3 0-110.3 74.6-61.3-49.9-61.2 49.9-110.3-74.7-9.3 0c-3.2 0-5.8 2.8-5.8 5.8l0 361.7c0 3 2.6 5.8 5.8 5.8l361.7 0c3.2 .1 5.8-2.7 5.8-5.8zM150.2 186l0 37-73.5 0 0-37 73.5 0zm0 74.4l0 37.3-73.5 0 0-37.3 73.5 0zm11.1-147.3l54-43.7-118.5 0 64.5 43.7zm210 72.9l0 37-196 0 0-37 196 0zm0 74.4l0 37.3-196 0 0-37.3 196 0zM286.7 113.1l64.5-43.7-118.4 0 53.9 43.7zM371.3 335l0 37.3-99.4 0 0-37.3 99.4 0z"]
  };
  var faSpeakerDeck = {
    prefix: 'fab',
    iconName: 'speaker-deck',
    icon: [512, 512, [], "f83c", "M213.9 296L100 296c-26.5 0-52-10.5-70.7-29.3S0 222.5 0 196 10.5 144 29.3 125.3 73.5 96 100 96l132.8 0c10.6 0 20.8 4.2 28.3 11.7s11.7 17.7 11.7 28.3-4.2 20.8-11.7 28.3-17.7 11.7-28.3 11.7L98 176c-26.5 0-26.4 40 0 40l113.8 0c26.5 0 52 10.5 70.7 29.3s29.3 44.2 29.3 70.7-10.5 52-29.3 70.7-44.2 29.3-70.7 29.3L40 416c-10.6 0-20.8-4.2-28.3-11.7S0 386.6 0 376 4.2 355.2 11.7 347.7 29.4 336 40 336l173.9 0c26.5 0 26.5-40 0-40zM298 416c13.5-9.2 25-21 33.8-34.7s14.7-29.2 17.3-45.3l64.6 0c2.6 0 5.2-.6 7.6-1.6s4.6-2.5 6.4-4.4 3.3-4.1 4.2-6.5 1.5-5 1.4-7.6l0-120c0-2.6-.5-5.2-1.4-7.6s-2.4-4.6-4.2-6.5-4-3.3-6.4-4.4-5-1.6-7.6-1.6l-117.2 0c9.7-11.1 15-25.3 15-40s-5.3-28.9-15-40l136.9 0c43.4 0 78.6 35.8 78.6 80l0 160c0 44.2-35.2 80-78.6 80L298 416z"]
  };
  var faFlickr = {
    prefix: 'fab',
    iconName: 'flickr',
    icon: [448, 512, [], "f16e", "M400 32L48 32C21.5 32 0 53.5 0 80L0 432c0 26.5 21.5 48 48 48l352 0c26.5 0 48-21.5 48-48l0-352c0-26.5-21.5-48-48-48zM144.5 192a63.5 63.5 0 1 1 0 127 63.5 63.5 0 1 1 0-127zm159 0a63.5 63.5 0 1 1 0 127 63.5 63.5 0 1 1 0-127z"]
  };
  var faCcVisa = {
    prefix: 'fab',
    iconName: 'cc-visa',
    icon: [576, 512, [], "f1f0", "M470.1 231.3s7.6 37.2 9.3 45l-33.4 0c3.3-8.9 16-43.5 16-43.5-.2 .3 3.3-9.1 5.3-14.9l2.8 13.4zM576 80l0 352c0 26.5-21.5 48-48 48L48 480c-26.5 0-48-21.5-48-48L0 80C0 53.5 21.5 32 48 32l480 0c26.5 0 48 21.5 48 48zM152.5 331.2l63.2-155.2-42.5 0-39.3 106-4.3-21.5-14-71.4c-2.3-9.9-9.4-12.7-18.2-13.1l-64.7 0-.7 3.1c15.8 4 29.9 9.8 42.2 17.1l35.8 135 42.5 0zm94.4 .2l25.2-155.4-40.2 0-25.1 155.4 40.1 0zm139.9-50.8c.2-17.7-10.6-31.2-33.7-42.3-14.1-7.1-22.7-11.9-22.7-19.2 .2-6.6 7.3-13.4 23.1-13.4 13.1-.3 22.7 2.8 29.9 5.9l3.6 1.7 5.5-33.6c-7.9-3.1-20.5-6.6-36-6.6-39.7 0-67.6 21.2-67.8 51.4-.3 22.3 20 34.7 35.2 42.2 15.5 7.6 20.8 12.6 20.8 19.3-.2 10.4-12.6 15.2-24.1 15.2-16 0-24.6-2.5-37.7-8.3l-5.3-2.5-5.6 34.9c9.4 4.3 26.8 8.1 44.8 8.3 42.2 .1 69.7-20.8 70-53zM528 331.4l-32.4-155.4-31.1 0c-9.6 0-16.9 2.8-21 12.9l-59.7 142.5 42.2 0s6.9-19.2 8.4-23.3l51.6 0c1.2 5.5 4.8 23.3 4.8 23.3l37.2 0z"]
  };
  var faUpwork = {
    prefix: 'fab',
    iconName: 'upwork',
    icon: [640, 512, [], "e641", "M493.9 295.6c-50.3 0-83.5-38.9-92.8-53.9 11.9-95.3 46.8-125.4 92.8-125.4 45.5 0 80.9 36.4 80.9 89.7s-35.4 89.7-80.9 89.7l0-.1zm0-237.8c-81.9 0-127.8 53.4-141 108.4-14.9-28-25.9-65.5-34.5-100.3l-113.2 0 0 141c0 51.1-23.3 89-68.8 89s-71.6-37.8-71.6-89l.5-141-65.3 0 0 141c0 41.1 13.3 78.4 37.6 105.1 25 27.5 59.2 41.8 98.8 41.8 78.8 0 133.8-60.4 133.8-146.9l0-94.8c8.2 31.2 27.8 91.1 65.3 143.6l-35 199.4 66.4 0 23.1-141.3c7.6 6.3 15.7 12 24.2 17 22.2 14 47.7 21.9 73.9 22.8 0 0 4 .2 6.1 .2 81.2 0 145.9-62.9 145.9-147.8S575.3 57.9 494.1 57.9l-.2-.1z"]
  };
  var faKakaoTalk = {
    prefix: 'fab',
    iconName: 'kakao-talk',
    icon: [576, 512, [], "e7d7", "M288 2.5c159.1 0 288 101.7 288 227.1 0 125.4-128.9 227.1-288 227.1-17.5 0-34.6-1.2-51.2-3.6-16.6 11.7-112.6 79.1-121.7 80.4 0 0-3.7 1.4-6.9-.4s-2.6-6.7-2.6-6.7C106.6 519.8 130.6 437.2 135 421.9 53.9 381.8 0 310.6 0 229.5 0 104.1 128.9 2.5 288 2.5zM86.2 161.7c-9 0-16.3 7.3-16.3 16.3s7.3 16.3 16.3 16.3l25.9 0 0 98.7c0 8.8 7.5 15.9 16.6 15.9s16.6-7.1 16.6-15.9l0-98.7 25.9 0c9 0 16.3-7.3 16.3-16.3s-7.3-16.3-16.3-16.3l-85.1 0zm140.8 0c-10.8 .2-19.3 8.4-22.1 16.4L165.2 282.7c-5 15.7-.6 21.5 3.9 23.6 3.2 1.5 6.9 2.3 10.6 2.3 6.9 0 12.2-2.8 13.8-7.3l8.2-21.6 50.7 0 8.2 21.5c1.6 4.5 6.9 7.3 13.8 7.3 3.7 0 7.3-.8 10.6-2.3 4.6-2.1 9-7.9 3.9-23.6L249.2 178.1c-2.8-8-11.3-16.2-22.2-16.4zm180.9 0c-9.2 0-16.6 7.5-16.6 16.6l0 113.7c0 9.2 7.5 16.6 16.6 16.6s16.6-7.5 16.6-16.6l0-36.2 5.8-5.8 38.9 51.6c3.2 4.2 8 6.6 13.3 6.6 3.6 0 7.1-1.1 10-3.3 3.5-2.7 5.8-6.6 6.4-11s-.5-8.8-3.2-12.3l-40.9-54.2 37.9-37.8c2.6-2.6 3.9-6.2 3.7-10.1-.2-3.9-2-7.6-4.9-10.5-3.1-3.1-7.3-4.9-11.4-4.9-3.6 0-6.8 1.3-9.2 3.7l-46.3 46.4 0-35.7c0-9.2-7.5-16.6-16.6-16.6zm-91.3 0c-9.3 0-16.9 7.5-16.9 16.6l0 112.8c0 8.4 7.1 15.2 15.9 15.3l53.3 0c8.8 0 15.9-6.9 15.9-15.3s-7.2-15.2-15.9-15.2l-35.3 0 0-97.6c0-9.2-7.6-16.6-17-16.6zm-73 88.6l-33.2 0 16.6-47.1 16.6 47.1z"]
  };
  var faFlutter = {
    prefix: 'fab',
    iconName: 'flutter',
    icon: [448, 512, [], "e694", "M429.5 236.3L291.7 374.1 429.5 512 272 512c-36.1-36.1-82.1-82.1-137.9-137.9l137.9-137.8 157.5 0zM272 0L16 256 94.8 334.8 429.5 0 272 0z"]
  };
  var faBuffer = {
    prefix: 'fab',
    iconName: 'buffer',
    icon: [448, 512, [], "f837", "M428.2 380.7L231.7 478.5c-2.3 1-4.8 1.5-7.3 1.5s-5-.5-7.3-1.5L20.5 380.7c-4-2-4-5.3 0-7.3L67.6 350c2.3-1 4.8-1.5 7.3-1.5s5 .5 7.3 1.5l134.8 67c2.3 1 4.8 1.5 7.3 1.5s5-.5 7.3-1.5l134.8-67c2.3-1 4.8-1.5 7.3-1.5s5 .5 7.3 1.5l47.1 23.4c4 2 4 5.2 0 7.2zm0-136.5l-47.1-23.4c-2.3-1-4.8-1.5-7.3-1.5s-5 .5-7.3 1.5L231.7 287.8c-2.3 1-4.8 1.5-7.3 1.5s-5-.5-7.3-1.5L82.3 220.7c-2.3-1-4.8-1.5-7.3-1.5s-5 .5-7.3 1.5L20.5 244.1c-4 2-4 5.3 0 7.3l196.5 97.8c2.3 1 4.8 1.5 7.3 1.5s5-.5 7.3-1.5l196.5-97.8c4-2 4-5.3 0-7.3zM20.5 130.4L217 220.7c4.7 1.9 10 1.9 14.7 0l196.5-90.3c4-1.9 4-4.9 0-6.7L231.7 33.4c-4.7-1.9-10-1.9-14.7 0L20.5 123.7c-4 1.8-4 4.9 0 6.7z"]
  };
  var faGratipay = {
    prefix: 'fab',
    iconName: 'gratipay',
    icon: [512, 512, [], "f184", "M256 0a256 256 0 1 0 0 512 256 256 0 1 0 0-512zM374.3 233.7L257.7 391.3 141.3 233.7c-9-12.3-19.7-52 14-74.3 29-18.7 56.4-4.3 70.7 12.3 16.4 18.5 48.1 17.4 63.7 0 14.3-16.6 41.7-31 70.3-12.3 34 22.3 23.3 61.9 14.2 74.3z"]
  };
  var faGooglePay = {
    prefix: 'fab',
    iconName: 'google-pay',
    icon: [640, 512, [], "e079", "M105.7 215l0 41.2 57.1 0c-1.2 6.6-3.6 12.9-7.2 18.5s-8.4 10.4-13.9 14.1c-9.5 6.6-21.7 10.3-36 10.3-27.6 0-50.9-18.9-59.3-44.2-4.4-13.3-4.4-27.7 0-41 8.4-25.5 31.7-44.4 59.3-44.4 7.5-.1 14.9 1.2 21.9 4s13.3 6.9 18.6 12.1L176.5 155c-19.1-18.1-44.4-28.1-70.7-27.8-19.7 .1-38.9 5.7-55.6 16.1s-30.1 25.3-38.8 43C3.9 201.2 0 217.7 0 234.4s3.9 33.2 11.3 48.1l0 .2c8.7 17.7 22.1 32.5 38.8 43s35.9 16 55.6 16c28.5 0 52.5-9.5 70-25.9 20-18.6 31.4-46.2 31.4-78.9 0-7.3-.6-14.6-1.8-21.8l-99.7 0zm389.4-4c-10.1-9.4-23.9-14.1-41.4-14.1-22.5 0-39.3 8.3-50.5 24.9L424.1 235c7.6-11.3 18.1-17 31.3-17 8.4 0 16.5 3.2 22.7 8.8 3 2.6 5.5 5.9 7.1 9.6s2.5 7.6 2.5 11.7l0 5.5c-9.1-5.1-20.6-7.8-34.6-7.8-16.4 0-29.6 3.9-39.5 11.8s-14.8 18.3-14.8 31.6c-.2 5.9 1 11.8 3.4 17.2s6 10.2 10.5 14.1c9.2 8.3 21 12.5 34.8 12.5 16.3 0 29.2-7.3 39-21.9l1 0 0 17.7 22.6 0 0-78.7c.1-16.6-4.9-29.7-15-39zm-19.2 89.3c-3.5 3.5-7.6 6.3-12.2 8.2s-9.5 2.9-14.4 2.9c-6.7 .1-13.1-2.1-18.3-6.2-2.4-1.8-4.4-4.2-5.7-6.9s-2-5.7-2-8.7c0-7 3.2-12.8 9.5-17.4s14.5-7 24.1-7c13.2-.2 23.5 2.8 30.8 8.8 0 10.1-4 18.9-11.7 26.4zm-93.7-142c-5.3-5.3-11.6-9.5-18.6-12.3s-14.4-4.2-21.9-4l-62.7 0 0 186.7 23.6 0 0-75.6 39 0c16 0 29.5-5.4 40.5-15.9 .9-.9 1.8-1.8 2.6-2.7 9.6-10.5 14.8-24.4 14.3-38.6s-6.6-27.7-16.9-37.6l0 0zm-16.6 62.2c-3 3.2-6.6 5.7-10.6 7.4s-8.4 2.5-12.7 2.3l-39.6 0 0-65.2 39.6 0c8.5 0 16.6 3.3 22.6 9.2 6.1 6.1 9.6 14.3 9.8 23s-3.1 17-9 23.3l0 0zM614.3 201l-36.5 91.7-.5 0-37.4-91.7-25.7 0 51.8 119.6-29.4 64.3 24.3 0 79-183.9-25.7 0z"]
  };
  var faApple = {
    prefix: 'fab',
    iconName: 'apple',
    icon: [384, 512, [], "f179", "M319.1 268.7c-.2-36.7 16.4-64.4 50-84.8-18.8-26.9-47.2-41.7-84.7-44.6-35.5-2.8-74.3 20.7-88.5 20.7-15 0-49.4-19.7-76.4-19.7-55.8 .9-115.1 44.5-115.1 133.2 0 26.2 4.8 53.3 14.4 81.2 12.8 36.7 59 126.7 107.2 125.2 25.2-.6 43-17.9 75.8-17.9 31.8 0 48.3 17.9 76.4 17.9 48.6-.7 90.4-82.5 102.6-119.3-65.2-30.7-61.7-90-61.7-91.9zM262.5 104.5c27.3-32.4 24.8-61.9 24-72.5-24.1 1.4-52 16.4-67.9 34.9-17.5 19.8-27.8 44.3-25.6 71.9 26.1 2 49.9-11.4 69.5-34.3z"]
  };
  var faTumblr = {
    prefix: 'fab',
    iconName: 'tumblr',
    icon: [320, 512, [], "f173", "M309.9 480.3c-13.6 14.5-50 31.7-97.4 31.7-120.8 0-147-88.8-147-140.6l0-144-47.5 0c-5.5 0-10-4.5-10-10l0-68c0-7.2 4.5-13.6 11.3-16 62-21.8 81.5-76 84.3-117.1 .8-11 6.5-16.3 16.1-16.3l70.9 0c5.5 0 10 4.5 10 10l0 115.2 83 0c5.5 0 10 4.4 10 9.9l0 81.7c0 5.5-4.5 10-10 10l-83.4 0 0 133.2c0 34.2 23.7 53.6 68 35.8 4.8-1.9 9-3.2 12.7-2.2 3.5 .9 5.8 3.4 7.4 7.9l22 64.3c1.8 5 3.3 10.6-.4 14.5z"]
  };
  var faPhoenixSquadron = {
    prefix: 'fab',
    iconName: 'phoenix-squadron',
    icon: [512, 512, [], "f511", "M96 63.4c46.5-36.1 105.6-56.1 164.5-54.6 29.6-.4 59.1 5.4 86.9 15.3-24.1-4.6-49-6.3-73.4-2.5-42.9 5.3-83 27.2-111.8 59.2 5.7-1 10.8-3.7 16-5.9 18.1-7.9 37.5-13.3 57.2-14.8 19.7-2.1 39.6-.4 59.3 1.9-14.4 2.8-29.1 4.6-43 9.6-34.4 11.1-65.3 33.2-86.3 62.6-13.8 19.7-23.6 42.9-24.7 67.1-.4 16.5 5.2 34.8 19.8 44 11.2 6.8 24.6 9.2 37.5 6.7 15.4-2.5 30.1-8.6 43.6-16.3 11.5-6.8 22.7-14.6 32-24.3 3.8-3.2 2.5-8.4 2.6-12.8-2.1-.3-4.4-1.1-6.3 .3-11.4 6.3-23.4 11.4-35.8 15.4-20 6.2-42.2 8.5-62.1 .8 12.8 1.7 26.1 .3 37.7-5.4 20.2-9.7 36.8-25.2 54.4-38.8 27.7-21.3 57.5-39.9 88.9-55.3 25.7-12 52.9-22.8 81.6-24.1-15.6 13.7-32.1 26.5-46.8 41.4-14.5 14-27.5 29.5-40.1 45.2-3.5 4.6-9 6.9-13.6 10.2-22.4 15-40.3 35.8-51.9 60.1-9.3 19.7-14.5 41.9-11.8 63.6 1.9 13.7 8.7 27.6 20.9 34.9 12.9 8 29 8.1 43.5 5.1 32.8-7.4 61.4-28.9 81-55.8 20.4-27.5 30.5-62.2 29.2-96.3-.5-7.5-1.6-15-1.7-22.5 8 19.5 14.8 39.7 16.6 60.8 2 14.3 .7 28.8-1.6 42.9-1.9 11-5.7 21.5-7.8 32.4 20.4-22.9 34-50.9 39.3-81.1 5.6-35.5 .7-71.9-14.2-104.6 20.8 32 32.3 69.6 35.7 107.5 .5 12.7 .5 25.5 0 38.2-2.8 34.3-12.9 67.6-29.6 97.8-26.1 47.3-68 85.6-117.2 108-78.3 36.2-174.7 31.3-248-14.7-39-23.8-70.6-58-91.4-98.7-14.7-28.9-23.3-60.5-25.4-92.9l0-31.3C3.9 172 40.9 105.8 96 63.4zm222 80.3c5.5-.9 10.8-2.4 16-4.5 5-1.8 9.2-5.9 10.3-11.2-9 5-18 9.9-26.3 15.7z"]
  };
  var faCentercode = {
    prefix: 'fab',
    iconName: 'centercode',
    icon: [512, 512, [], "f380", "M201.8 254.8a64.1 64.1 0 1 1 127.4 13.8 64.1 64.1 0 1 1 -127.4-13.8zm41.6 248.9C96.7 496-8.2 365.5 10.1 224.3 21.3 137.7 75.9 67.4 149.2 32.3 310.2-44.8 498.9 69.7 503.9 248.9 508 395.9 385.5 511.1 243.4 503.7zm179.9-180c27.9-118-160.5-205.9-237.2-234.2-57.5 56.3-69.1 188.6-33.8 344.4 68.8 15.8 169.1-26.4 271-110.2z"]
  };
  var faDebian = {
    prefix: 'fab',
    iconName: 'debian',
    icon: [448, 512, [], "e60b", "M380.4 245.6c3-7.6 5.5-14 5.2-24.4l-4.3 9c4.4-13.2 4-27.1 3.6-40.4-.2-6-.3-11.8 0-17.4l-1.8-.5c-1.5-45.2-40.6-93.1-75.3-109.4-30-13.8-76.1-16.2-97.3-5.8 1.3-1.1 4.2-2 6.8-2.7l.3-.1c3.3-1 6-1.7 4-2.9-19.2 1.9-24.9 5.5-31.1 9.4l-.1 0c-4.6 2.9-9.5 6-20.3 8.7-3.5 3.4 1.7 2 5.8 .9s7.2-1.9-.1 2.4c-3.5 1-6.6 1.3-9.6 1.6l-.1 0c-8.3 .8-15.8 1.6-30.7 17 .8 1.3 3.4-.2 5.3-1.3l.1-.1c2.3-1.4 3.4-2-1.7 4.4-19.1-2.4-60.3 43.7-69.1 59l4.6 .8c-3.2 8-6.8 14.8-10 20.8-4.3 8.1-7.9 14.9-8.7 21.3-.3 5.1-1 11-1.7 17.3-.1 1-.2 2-.3 3l-.1 .6c-3 27.3-6.7 60.8 3.9 73l-1.3 13c.6 1.2 1.1 2.3 1.6 3.5 .2 .4 .4 .8 .5 1.1 1 2.1 2 4.2 3.3 6.2l-3 .2c7 22.1 10.8 22.5 15.1 22.9 4.4 .4 9.3 .9 18.7 24.2-2.7-.9-5.5-1.9-9.4-7.2-.5 4.1 5.8 16.3 13.1 25.8l-3.1 3.6c2.1 3.7 4.8 6.2 7.6 8.8 1 .9 2.1 1.9 3.1 2.9-11.9-6.5 3.2 13.7 11.9 25.2 .8 1.1 1.5 2 2.2 2.9 1.4 1.9 2.5 3.4 2.9 4.1l2.4-4.2c-.3 6.1 4.3 13.9 13.1 24.7l7.3-.3c3 6 14 16.7 20.7 17.2l-4.4 5.8c8.1 2.6 10.3 4.3 12.7 6.2 2.6 2.1 5.4 4.3 16.1 8.1l-4.2-7.4c3.5 3 6.2 5.9 8.8 8.7l.1 .1c5.2 5.6 9.9 10.6 19.7 15.3 10.7 3.7 16.6 4.7 22.7 5.8 .3 0 .6 .1 .9 .1 5.4 .8 11.2 1.8 20.8 4.5-1.1-.1-2.2-.1-3.3-.1-2.3-.1-4.7-.1-7-.1-14.4-.2-29.2-.4-42.7-5.2-96.6-25.7-184.9-139-178.4-255.6-.6-9.9-.3-20.9 0-30.7 .4-13.5 .7-24.8-1.6-28.3l1-3.1c5.3-17.4 11.7-38.2 23.8-62.8l-.1-.2 0-.1c.4 .4 3.4 3.4 8.8-5.8 .8-1.8 1.6-3.7 2.4-5.6 .5-1.1 .9-2.2 1.4-3.2 2.5-6.1 5.1-12.3 8.4-17.9l2.6-.6c1.7-10.1 17-23.8 29.8-35.2l1.1-1c5.7-5.1 10.7-9.7 13.6-13.1l.7 4.4c17-15.9 44.6-27.5 65.6-36.4l.5-.2c4.8-2 9.3-3.9 13.3-5.7-3.4 3.8 2.2 2.7 10 1 4.8-1 10.4-2.1 15.3-2.4l-3.9 2.1c-2.7 1.4-5.4 2.8-8 4.6 8.1-2 11.7-1.4 15.7-.8l.3 0c3.5 .6 7.3 1.2 14.6 .2-5.6 .8-12.3 3-11.2 3.8 7.9 .9 12.8-.1 17.2-1l.2 0c5.5-1.1 10.3-2 19.3 .9l-1-4.8c7.3 2.6 12.7 4.3 17.5 5.8l.5 .1c10 3 17.6 5.3 34.2 14.1 3.2 .2 5.3-.5 7.4-1.2l.1 0c3.6-1.1 7-2.1 15.2 1.2 .3 .5 .5 1 .7 1.4 .1 .2 .2 .5 .3 .7l0 .1c1 2.6 1.8 4.6 14.6 12.1 1.7-.7-2.7-4.7-6.4-8.2l-.1-.1c-.2-.1-.3-.3-.5-.4 32.2 17.3 67.3 54.1 78 93.5-6-11.1-5.2-5.5-4.3 .5 .6 4 1.2 8.1-.2 7.5 4.5 12.1 8.1 24.5 10.4 37.4l-.8-2.9-.1-.3c-3.3-11.9-9.6-34.3-19.9-49.3-.4 4.3-2.8 3.9-5.2 3.5l-.1 0c-3.3-.6-6.2-1.1-1.9 12.6 2.6 3.8 3.1 2.4 3.5 1.1 .5-1.5 .9-2.7 4.7 5.2 .1 4.1 1 8.2 2.1 12.7l.1 .6c.1 .3 .1 .5 .2 .8l.1 .6c.6 2.6 1.3 5.4 1.8 8.4-1.1-.2-2.3-2.2-3.4-4.2-1.4-2.4-2.8-4.7-3.7-3.2 2.4 11.5 6.5 17.4 8 18.3-.3 .6-.6 .7-1.1 .7-.8 0-1.8 .1-1.9 5.3 .7 13.7 3.3 12.5 5.3 11.6 .6-.3 1.2-.6 1.7-.4-.6 2.5-1.6 5.1-2.7 7.9-2.8 7.1-6 15.4-3.4 26.1-.8-3-2-6-3.1-8.9l-.1-.4c-.2-.5-.4-1-.6-1.5-.3-.8-.6-1.6-.9-2.3-.6 4.4-.3 7.7-.1 10.6l0 .7c.4 5.3 .7 10-3 19.9 4.3-14.2 3.8-26.9-.2-20.8 1 10.9-3.7 20.4-8 28.9l-.1 .2c-3.6 7.1-6.8 13.5-5.9 19.3l-5.2-7.1c-7.5 10.9-7 13.3-6.5 15.5l0 .1c.5 1.9 1 3.8-3.4 10.8 1.7-2.9 1.3-3.6 1-4.2-.4-.8-.7-1.5 1.7-5.1-1.6 .1-5.5 3.9-10.1 8.5-3.9 3.9-8.5 8.4-12.8 11.8-37.5 30.1-82.3 34-125.6 17.8 .2-1-.2-2.1-3.1-4.1-36.8-28.2-58.5-52.1-50.9-107.5 2.1-1.6 3.6-5.8 5.3-10.8l.2-.4 .1-.3 0-.1c2.9-8.4 6.5-18.8 14.3-23.8 7.8-17.3 31.3-33.3 56.4-33.7 25.6-1.4 47.2 13.7 58.1 27.9-19.8-18.4-52.1-24-79.7-10.4-28.2 12.7-45 43.8-42.5 74.7 .3-.4 .6-.6 .9-.8l.2-.2c.6-.5 1.1-.9 1.4-3.3-.9 60.2 64.8 104.3 112.1 82l.6 1.3c12.7-3.5 15.9-6.5 20.3-10.7l.1-.1c2.2-2.1 4.7-4.5 8.9-7.3-.3 .7-1.3 1.7-2.4 2.7-2.2 2.1-4.6 4.5-1.6 4.6 5-1.3 18.5-13.4 28.5-22.3 .6-.5 1.2-1 1.7-1.5 1.5-1.3 2.8-2.5 4-3.6l.3-.3c1.9-4.2 1.6-5.6 1.3-7l0-.1c-.4-1.6-.8-3.3 2.4-9.6l7.3-3.7c.8-2.1 1.5-4.1 2.2-6 .2-.6 .5-1.2 .7-1.8l-.4-.2-.1-.1zM248 334.1c-6-3-13.7-8.9-14.8-11.4l-.4 .3c-.3 .6-.5 1.3-.2 2.2-12.2-5.7-23.4-14.3-32.6-24.9 4.9 7.1 10.1 14.1 17 19.5-6.9-2.3-15.1-11.8-21.6-19.3l-.1-.1c-4.3-5-7.9-9.1-9.7-9.5 19.8 35.5 80.5 62.3 112.3 49-14.7 .5-33.4 .3-49.9-5.8zm79.3-119.7l-.1-.2c-.5-1.5-1.1-3.1-1.7-3.4 1.4-5.8 5.4-10.7 4.4 4.6-1 3.8-1.8 1.5-2.6-1zm-4.2 22.2c-1.3 7.9-5 15.5-10.1 22.5 .2-2-1.2-2.4-2.6-2.8-2.9-.8-5.9-1.6 5.6-16.1-.5 1.9-2.1 4.6-3.7 7.3l-.3 .4c-3.6 5.9-6.7 11 4 4.3l1-1.8c2.6-4.5 5-8.8 6-13.8l.1 0zm-55.6 33.9c7.1 .6 14.1 .6 21-1.1-2.5 2.4-5.2 4.8-8.3 7.2-11.1-1.7-21.2-6-12.7-6.1zm-92.6 11.6c3.6 7.1 6.4 11.5 9 15.7l.1 .2c2.3 3.7 4.4 7.1 6.8 11.7-5.1-4.2-8.7-9.5-12.5-15l-.3-.5c-1.4-2.1-2.8-4.2-4.4-6.2l1.2-5.9 .1 0zm7.5-9.6c1.6 3.3 3.2 6.4 5.7 9.1l2.6 7.7-1.3-2.1c-3.2-5.3-6.3-10.6-8-16.7l1 2zm238.9-41.6c-2.3 17.4-7.7 34.6-16 50.3 7.6-14.9 12.5-30.9 14.8-47.2l1.2-3.1zM35.8 110.6c.4 .8 1.4 .5 2.3 .3 1.9-.5 3.6-.9-.1 7.6-.5 .3-1 .7-1.5 1-1.4 .9-2.8 1.9-3.9 3 1.9-3.8 3.5-7.4 3.2-11.9zM25.5 152.3c-.7 3.7-1.5 7.9-3.4 13.9 .2-1.9 0-3.5-.2-4.9l0-.1c-.4-3.4-.7-6.3 4.3-12.8-.3 1.2-.5 2.5-.7 3.8l0 .1z"]
  };
  var faMastodon = {
    prefix: 'fab',
    iconName: 'mastodon',
    icon: [448, 512, [], "f4f6", "M433 179.1c0-97.2-63.7-125.7-63.7-125.7-62.5-28.7-228.6-28.4-290.5 0 0 0-63.7 28.5-63.7 125.7 0 115.7-6.6 259.4 105.6 289.1 40.5 10.7 75.3 13 103.3 11.4 50.8-2.8 79.3-18.1 79.3-18.1l-1.7-36.9s-36.3 11.4-77.1 10.1c-40.4-1.4-83-4.4-89.6-54-.6-4.6-.9-9.3-.9-13.9 85.6 20.9 158.7 9.1 178.7 6.7 56.1-6.7 105-41.3 111.2-72.9 9.8-49.8 9-121.5 9-121.5zM357.9 304.3l-46.6 0 0-114.2c0-49.7-64-51.6-64 6.9l0 62.5-46.3 0 0-62.5c0-58.5-64-56.6-64-6.9l0 114.2-46.7 0c0-122.1-5.2-147.9 18.4-175 25.9-28.9 79.8-30.8 103.8 6.1l11.6 19.5 11.6-19.5c24.1-37.1 78.1-34.8 103.8-6.1 23.7 27.3 18.4 53 18.4 175l0 0z"]
  };
  var faSketch = {
    prefix: 'fab',
    iconName: 'sketch',
    icon: [512, 512, [], "f7c6", "M27.8 162.2l-18.5 24.9 90.5 0 6.9-130.7-78.9 105.8zM396.6 45.7L268 32 403.7 179.2 396.6 45.7zM112.5 218.3l-11.2-22-91.1 0 224.9 261.7-122.6-239.7zm2-31.2l284 0C340.6 124.3 293.3 72.9 256.6 33L114.5 187.1zm297.3 9.1l-133.9 261.8 224.8-261.7-90.9 0 0-.1zM415.7 69l-9.4-12.6 .9 17.3 6.1 113.4 90.3 0-87.9-118.1zM113.8 93.5L109.2 179.1 245 32 116.4 45.7 113.8 93.5zM401.5 196.2l-290 0c18.2 35.6 66.6 130.2 145.1 283.8L401.5 196.2z"]
  };
  var faWebAwesome = {
    prefix: 'fab',
    iconName: 'web-awesome',
    icon: [640, 512, [], "e682", "M372.2 52c0 20.9-12.4 39-30.2 47.2L448 192 552.4 171.1c-5.3-7.7-8.4-17.1-8.4-27.1 0-26.5 21.5-48 48-48s48 21.5 48 48c0 26-20.6 47.1-46.4 48L481 442.3c-10.3 23-33.2 37.7-58.4 37.7l-205.2 0c-25.2 0-48-14.8-58.4-37.7L46.4 192C20.6 191.1 0 170 0 144 0 117.5 21.5 96 48 96s48 21.5 48 48c0 10.1-3.1 19.4-8.4 27.1L192 192 298.1 99.1c-17.7-8.3-30-26.3-30-47.1 0-28.7 23.3-52 52-52s52 23.3 52 52l.1 0z"]
  };
  var faSass = {
    prefix: 'fab',
    iconName: 'sass',
    icon: [640, 512, [], "f41e", "M301.8 378.9l0 0zm249.1-87c-20.1 0-40 4.6-58 13.5-5.9-11.9-12-22.3-13-30.1-1.2-9.1-2.5-14.5-1.1-25.3s7.7-26.1 7.6-27.2-1.4-6.6-14.3-6.7-24 2.5-25.3 5.9c-2.3 6.2-4.1 12.6-5.3 19.1-2.3 11.7-25.8 53.5-39.1 75.3-4.4-8.5-8.1-16-8.9-22-1.2-9.1-2.5-14.5-1.1-25.3s7.7-26.1 7.6-27.2-1.4-6.6-14.3-6.7-24 2.5-25.3 5.9-2.7 11.4-5.3 19.1-33.9 77.3-42.1 95.4c-4.2 9.2-7.8 16.6-10.4 21.6-.4 .8-.7 1.3-.9 1.7 .3-.5 .5-1 .5-.8-2.2 4.3-3.5 6.7-3.5 6.7l0 .1c-1.7 3.2-3.6 6.1-4.5 6.1-.6 0-1.9-8.4 .3-19.9 4.7-24.2 15.8-61.8 15.7-63.1-.1-.7 2.1-7.2-7.3-10.7-9.1-3.3-12.4 2.2-13.2 2.2s-1.4 2-1.4 2 10.1-42.4-19.4-42.4c-18.4 0-44 20.2-56.6 38.5-7.9 4.3-25 13.6-43 23.5-6.9 3.8-14 7.7-20.7 11.4-.5-.5-.9-1-1.4-1.5-35.8-38.2-101.9-65.2-99.1-116.5 1-18.7 7.5-67.8 127.1-127.4 98-48.8 176.3-35.4 189.8-5.6 19.4 42.5-41.9 121.6-143.7 133-38.8 4.3-59.2-10.7-64.3-16.3-5.3-5.9-6.1-6.2-8.1-5.1-3.3 1.8-1.2 7 0 10.1 3 7.9 15.5 21.9 36.8 28.9 18.7 6.1 64.2 9.5 119.2-11.8 61.8-23.8 109.9-90.1 95.8-145.6-14.4-56.4-107.9-74.9-196.3-43.5-52.7 18.7-109.7 48.1-150.7 86.4-48.7 45.6-56.5 85.3-53.3 101.9 11.4 58.9 92.6 97.3 125.1 125.7-1.6 .9-3.1 1.7-4.5 2.5-16.3 8.1-78.2 40.5-93.7 74.7-17.5 38.8 2.9 66.6 16.3 70.4 41.8 11.6 84.6-9.3 107.6-43.6s20.2-79.1 9.6-99.5c-.1-.3-.3-.5-.4-.8 4.2-2.5 8.5-5 12.8-7.5 8.3-4.9 16.4-9.4 23.5-13.3-4 10.8-6.9 23.8-8.4 42.6-1.8 22 7.3 50.5 19.1 61.7 5.2 4.9 11.5 5 15.4 5 13.8 0 20-11.4 26.9-25 8.5-16.6 16-35.9 16-35.9s-9.4 52.2 16.3 52.2c9.4 0 18.8-12.1 23-18.3l0 .1s.2-.4 .7-1.2c1-1.5 1.5-2.4 1.5-2.4l0-.3c3.8-6.5 12.1-21.4 24.6-46 16.2-31.8 31.7-71.5 31.7-71.5 1.5 8.7 3.6 17.3 6.2 25.8 2.8 9.5 8.7 19.9 13.4 30-3.8 5.2-6.1 8.2-6.1 8.2 0 .1 0 .1 .1 .2-3 4-6.4 8.3-9.9 12.5-12.8 15.2-28 32.6-30 37.6-2.4 5.9-1.8 10.3 2.8 13.7 3.4 2.6 9.4 3 15.7 2.5 11.5-.8 19.6-3.6 23.5-5.4 7.2-2.6 14-6.1 20.2-10.6 12.5-9.2 20.1-22.4 19.4-39.8-.4-9.6-3.5-19.2-7.3-28.2 1.1-1.6 2.3-3.3 3.4-5 19.8-28.9 35.1-60.6 35.1-60.6 1.5 8.7 3.6 17.3 6.2 25.8 2.4 8.1 7.1 17 11.4 25.7-18.6 15.1-30.1 32.6-34.1 44.1-7.4 21.3-1.6 30.9 9.3 33.1 4.9 1 11.9-1.3 17.1-3.5 7.7-2.6 15-6.3 21.6-11.1 12.5-9.2 24.6-22.1 23.8-39.6-.3-7.9-2.5-15.8-5.4-23.4 15.7-6.6 36.1-10.2 62.1-7.2 55.7 6.5 66.6 41.3 64.5 55.8s-13.8 22.6-17.7 25-5.1 3.3-4.8 5.1c.5 2.6 2.3 2.5 5.6 1.9 4.6-.8 29.2-11.8 30.3-38.7 1.6-34-31.1-71.4-89-71.1l0 0zM121.8 436.6c-18.4 20.1-44.2 27.7-55.3 21.3-11.9-6.9-7.2-36.5 15.5-57.9 13.8-13 31.6-25 43.4-32.4 2.7-1.6 6.6-4 11.4-6.9 .8-.5 1.2-.7 1.2-.7 .9-.6 1.9-1.1 2.9-1.7 8.3 30.4 .3 57.2-19.1 78.3l0 0zm134.4-91.4c-6.4 15.7-19.9 55.7-28.1 53.6-7-1.8-11.3-32.3-1.4-62.3 5-15.1 15.6-33.1 21.9-40.1 10.1-11.3 21.2-14.9 23.8-10.4 3.5 5.9-12.2 49.4-16.2 59.2zm111 53c-2.7 1.4-5.2 2.3-6.4 1.6-.9-.5 1.1-2.4 1.1-2.4s13.9-14.9 19.4-21.7c3.2-4 6.9-8.7 10.9-13.9 0 .5 .1 1 .1 1.6-.1 17.9-17.3 30-25.1 34.8l0 0zm85.6-19.5c-2-1.4-1.7-6.1 5-20.7 2.6-5.7 8.6-15.3 19-24.5 1.2 3.5 1.8 7.1 1.9 10.8-.1 22.5-16.2 30.9-25.9 34.4l0 0z"]
  };
  var faSquareWhatsapp = {
    prefix: 'fab',
    iconName: 'square-whatsapp',
    icon: [448, 512, ["whatsapp-square"], "f40c", "M92.1 254.6c0 24.9 7 49.2 20.2 70.1l3.1 5-13.3 48.6 49.9-13.1 4.8 2.9c20.2 12 43.4 18.4 67.1 18.4l.1 0c72.6 0 133.3-59.1 133.3-131.8 0-35.2-15.2-68.3-40.1-93.2-25-25-58-38.7-93.2-38.7-72.7 0-131.8 59.1-131.9 131.8zM274.8 330c-12.6 1.9-22.4 .9-47.5-9.9-36.8-15.9-61.8-51.5-66.9-58.7-.4-.6-.7-.9-.8-1.1-2-2.6-16.2-21.5-16.2-41 0-18.4 9-27.9 13.2-32.3 .3-.3 .5-.5 .7-.8 3.6-4 7.9-5 10.6-5 2.6 0 5.3 0 7.6 .1l.8 0c2.3 0 5.2 0 8.1 6.8 1.2 2.9 3 7.3 4.9 11.8 3.3 8 6.7 16.3 7.3 17.6 1 2 1.7 4.3 .3 6.9-3.4 6.8-6.9 10.4-9.3 13-3.1 3.2-4.5 4.7-2.3 8.6 15.3 26.3 30.6 35.4 53.9 47.1 4 2 6.3 1.7 8.6-1 2.3-2.6 9.9-11.6 12.5-15.5 2.6-4 5.3-3.3 8.9-2s23.1 10.9 27.1 12.9c.8 .4 1.5 .7 2.1 1 2.8 1.4 4.7 2.3 5.5 3.6 .9 1.9 .9 9.9-2.4 19.1-3.3 9.3-19.1 17.7-26.7 18.8zM448 96c0-35.3-28.7-64-64-64L64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320zM148.1 393.9L64 416 86.5 333.8c-13.9-24-21.2-51.3-21.2-79.3 .1-87.4 71.2-158.5 158.6-158.5 42.4 0 82.2 16.5 112.2 46.5 29.9 30 47.9 69.8 47.9 112.2 0 87.4-72.7 158.5-160.1 158.5-26.6 0-52.7-6.7-75.8-19.3z"]
  };
  var faWhatsappSquare = faSquareWhatsapp;
  var faSkype = {
    prefix: 'fab',
    iconName: 'skype',
    icon: [448, 512, [], "f17e", "M424.7 299.8c2.9-14 4.7-28.9 4.7-43.8 0-113.5-91.9-205.3-205.3-205.3-14.9 0-29.7 1.7-43.8 4.7-19-14.7-42.6-23.4-68.3-23.4-61.8 0-112 50.2-112 112 0 25.7 8.7 49.3 23.3 68.2-2.9 14-4.7 28.9-4.7 43.8 0 113.5 91.9 205.3 205.3 205.3 14.9 0 29.7-1.7 43.8-4.7 19 14.6 42.6 23.3 68.2 23.3 61.8 0 112-50.2 112-112 .1-25.6-8.6-49.2-23.2-68.1zM230.1 391.3c-65.6 0-120.5-29.2-120.5-65 0-16 9-30.6 29.5-30.6 31.2 0 34.1 44.9 88.1 44.9 25.7 0 42.3-11.4 42.3-26.3 0-18.7-16-21.6-42-28-62.5-15.4-117.8-22-117.8-87.2 0-59.2 58.6-81.1 109.1-81.1 55.1 0 110.8 21.9 110.8 55.4 0 16.9-11.4 31.8-30.3 31.8-28.3 0-29.2-33.5-75-33.5-25.7 0-42 7-42 22.5 0 19.8 20.8 21.8 69.1 33 41.4 9.3 90.7 26.8 90.7 77.6 0 59.1-57.1 86.5-112 86.5z"]
  };
  var faAngular = {
    prefix: 'fab',
    iconName: 'angular',
    icon: [448, 512, [], "f420", "M185.7 268.1l76.2 0-38.1-91.6-38.1 91.6zM223.8 32L16 106.4 47.8 382.1 223.8 480 399.8 382.1 431.6 106.4 223.8 32zM354 373.8l-48.6 0-26.2-65.4-110.6 0-26.2 65.4-48.7 0 130.1-292.3 130.2 292.3z"]
  };
  var faOpensuse = {
    prefix: 'fab',
    iconName: 'opensuse',
    icon: [640, 512, [], "e62b", "M471.1 102.7s-.3 18.3-.3 20.3c-9.1-3-74.4-24.1-135.7-26.3-51.9-1.8-122.8-4.3-223 57.3-19.4 12.4-73.9 46.1-99.6 109.7-5.5 13.3-12.6 43.3-5.5 71.4 3.3 12.8 8.9 24.9 16.5 35.7 17.4 25 46.6 41.6 78.1 44.4 44.4 3.9 78.1-16 90-53.3 8.2-25.8 0-63.6-31.5-82.9-25.6-15.7-53.3-12.1-69.2-1.6-13.9 9.2-21.8 23.5-21.6 39.2 .3 27.8 24.3 42.6 41.5 42.6 5.4 0 10.7-.9 15.8-2.7 6.5-1.8 13.3-6.5 13.3-14.9 0-12.1-11.6-14.8-16.8-13.9-2.9 .5-4.5 2-11.8 2.4-2-.2-12-3.1-12-14l0-.1c.2-12.3 13.2-18 25.5-16.9 32.3 2.8 47.7 40.7 28.5 65.7-18.3 23.7-76.6 23.2-99.7-20.4-26-49.2 12.7-111.2 87-98.4 33.2 5.7 83.6 35.5 102.4 104.3l45.9 0c-5.7-17.6-8.9-68.3 42.7-68.3 56.7 0 63.9 39.9 79.8 68.3l48.6 0c-12.8-18.3-21.7-38.7-18.9-55.8 5.6-33.8 39.7-18.4 82.4-17.4 66.5 .4 102.1-27 103.1-28 3.7-3.1 6.5-15.8 7-17.7 1.3-5.1-3.2-2.4-3.2-2.4-8.7 5.2-30.5 15.2-50.9 15.6-25.3 .5-76.2-25.4-81.6-28.2-.3-.4 .1 1.2-11-25.5 88.4 58.3 118.3 40.5 145.2 21.7 .8-.6 4.3-2.9 3.6-5.7-13.8-48.1-22.4-62.7-34.5-69.6-37-21.6-125-34.7-129.2-35.3 .1-.1-.9-.3-.9 .7zm60.4 72.8a37.6 37.6 0 1 1 75.2 2.6 37.6 37.6 0 1 1 -75.2-2.6zm38.6-25.3c-3.6-.3-7.1 .1-10.5 1.2s-6.5 2.9-9.2 5.3-4.8 5.3-6.3 8.5-2.4 6.7-2.5 10.3 .5 7.1 1.8 10.4 3.3 6.3 5.8 8.9 5.5 4.5 8.8 5.9 6.9 2 10.4 1.9c3.6 .3 7.1-.1 10.5-1.2s6.5-2.9 9.2-5.3 4.8-5.3 6.3-8.5 2.4-6.7 2.5-10.3-.5-7.1-1.8-10.4-3.3-6.3-5.8-8.9-5.5-4.5-8.8-5.9-6.9-2-10.4-1.9zm4.3 28.8c-15.4 0-15.4-15.6 0-15.6s15.4 15.6 0 15.6z"]
  };
  var faDropbox = {
    prefix: 'fab',
    iconName: 'dropbox',
    icon: [576, 512, [], "f16b", "M288.4 116.3l-132 84.3 132 84.3-132 84.3-132.4-85.1 132.3-84.3-132.3-83.5 132.3-84.3 132.1 84.3zM155.6 395.7l132-84.3 132 84.3-132 84.3-132-84.3zM288.4 284.1l132-84.3-132-83.6 131.3-84.2 132.3 84.3-132.3 84.3 132.3 84.2-132.3 84.3-131.3-85z"]
  };
  var faDeezer = {
    prefix: 'fab',
    iconName: 'deezer',
    icon: [512, 512, [], "e077", "M14.8 101.1C6.6 101.1 0 127.6 0 160.3s6.6 59.2 14.8 59.2 14.8-26.5 14.8-59.2-6.6-59.2-14.8-59.2zM448.7 40.9c-7.7 0-14.5 17.1-19.4 44.1-7.7-46.7-20.2-77-34.2-77-16.8 0-31.1 42.9-38 105.4-6.6-45.4-16.8-74.2-28.3-74.2-16.1 0-29.6 56.9-34.7 136.2-9.4-40.8-23.2-66.3-38.3-66.3s-28.8 25.5-38.3 66.3c-5.1-79.3-18.6-136.2-34.7-136.2-11.5 0-21.7 28.8-28.3 74.2-6.6-62.5-21.2-105.4-37.8-105.4-14 0-26.5 30.4-34.2 77-4.8-27-11.7-44.1-19.4-44.1-14.3 0-26 59.2-26 132.1S49 305.2 63.3 305.2c5.9 0 11.5-9.9 15.8-26.8 6.9 61.7 21.2 104.1 38 104.1 13 0 24.5-25.5 32.1-65.6 5.4 76.3 18.6 130.4 34.2 130.4 9.7 0 18.6-21.4 25.3-56.4 7.9 72.2 26.3 122.7 47.7 122.7s39.5-50.5 47.7-122.7c6.6 35 15.6 56.4 25.3 56.4 15.6 0 28.8-54.1 34.2-130.4 7.7 40.1 19.4 65.6 32.1 65.6 16.6 0 30.9-42.3 38-104.1 4.3 16.8 9.7 26.8 15.8 26.8 14.3 0 26-59.2 26-132.1S463 40.9 448.7 40.9zm48.5 60.2c-8.2 0-14.8 26.5-14.8 59.2s6.6 59.2 14.8 59.2 14.8-26.5 14.8-59.2-6.6-59.2-14.8-59.2z"]
  };
  var faCreativeCommonsSampling = {
    prefix: 'fab',
    iconName: 'creative-commons-sampling',
    icon: [512, 512, [], "f4f0", "M255.6 8C397.4 8 504 118.1 504 256 504 403.1 385.5 504 255.6 504 121.6 504 8 394.5 8 256 8 123.1 112.7 8 255.6 8zm.8 44.7c-118.2 0-203.7 97.9-203.7 203.3 0 109.8 91.2 202.8 203.7 202.8 103.2 0 202.8-81.1 202.8-202.8 .1-113.8-90.2-203.3-202.8-203.3zm3.6 53.2c2.8-.3 11.5 1 11.5 11.5l6.6 107.2 4.9-59.3c0-6 4.7-10.6 10.6-10.6s10.6 4.7 10.6 10.6c0 2.5-.5-5.7 5.7 81.5l5.8-64.2c.3-2.9 2.9-9.3 10.2-9.3 3.8 0 9.9 2.3 10.6 8.9l11.5 96.5 5.3-12.8c1.8-4.4 5.2-6.6 10.2-6.6l58 0 0 21.3-50.9 0-18.2 44.3c-3.9 9.9-19.5 9.1-20.8-3.1l-4-31.9-7.5 92.6c-.3 3-3 9.3-10.2 9.3-3 0-9.8-2.1-10.6-9.3 0-1.9 .6 5.8-6.2-77.9l-5.3 72.2c-1.1 4.8-4.8 9.3-10.6 9.3-2.9 0-9.8-2-10.6-9.3 0-1.9 .5 6.7-5.8-87.7L255 383.9c0 6.3-3.6 12.4-10.6 12.4-5.2 0-10.6-4.1-10.6-12L228 296.6c-5.8 92.5-5.3 84-5.3 85.9-1.1 4.8-4.8 9.3-10.6 9.3-3 0-9.8-2.1-10.6-9.3 0-.7-.4-1.1-.4-2.6l-6.2-88.6-4.9 56.7c-.7 6.5-6.7 9.3-10.6 9.3-5.8 0-9.6-4.1-10.6-8.9L157.7 272c-2 4-3.5 8.4-11.1 8.4l-51.4 0 0-21.3 44.8 0 13.7-27.9c4.4-9.9 18.2-7.2 19.9 2.7l3.1 20.4 8.4-97.9c0-6 4.8-10.6 10.6-10.6 .5 0 10.6-.2 10.6 12.4l4.9 69.1 6.6-92.6c0-10.1 9.5-10.6 10.2-10.6 .6 0 10.6 .7 10.6 10.6l5.3 80.6 6.2-97.9c.1-1.1-.6-10.3 9.9-11.5z"]
  };
  var faJediOrder = {
    prefix: 'fab',
    iconName: 'jedi-order',
    icon: [448, 512, [], "f50e", "M398.9 373.6c95.9-122.1 17.2-233.1 17.2-233.1 45.4 85.8-41.4 170.5-41.4 170.5 105-171.5-60.5-271.5-60.5-271.5 96.9 72.7-10.1 190.7-10.1 190.7 85.8 158.4-68.6 230.1-68.6 230.1s-.4-16.9-2.2-85.7c4.3 4.5 34.5 36.2 34.5 36.2l-24.2-47.4 62.6-9.1-62.6-9.1 20.2-55.5-31.4 45.9c-2.2-87.7-7.8-305.1-7.9-306.9 0 1-5.6 219-7.9 306.9l-31.4-45.9 20.2 55.5-62.6 9.1 62.6 9.1-24.2 47.4 34.5-36.2c-1.8 68.8-2.2 85.7-2.2 85.7S59.1 388.6 144.9 230.2c0 0-107-118.1-10.1-190.7 0 0-165.5 99.9-60.5 271.5 0 0-86.8-84.8-41.4-170.5 0 0-78.7 111 17.2 233.1 0 0-26.2-16.1-49.4-77.7 0 0 16.9 183.3 222 185.7l4.1 0c205-2.4 222-185.7 222-185.7-23.6 61.5-49.9 77.7-49.9 77.7z"]
  };
  var faRProject = {
    prefix: 'fab',
    iconName: 'r-project',
    icon: [576, 512, [], "f4f7", "M578.5 226.6C578.5 119.1 448.4 32 288 32S-2.5 119.1-2.5 226.6c0 95.8 103.3 175.4 239.4 191.5l0 61.9 99.1 0 0-61.5c24.3-2.7 47.6-7.4 69.4-13.9l40.1 75.4 112 0-67.4-113.7c54.5-35.4 88.4-84.9 88.4-139.7zM111.7 241.1c0-73.5 98.9-133 220.8-133s211.9 40.7 211.9 133c0 50.1-26.5 85-70.3 106.4-2.4-1.6-4.7-2.9-6.4-3.7-10.2-5.2-27.8-10.5-27.8-10.5s86.6-6.4 86.6-92.7-90.6-87.9-90.6-87.9l-199 0 0 208.3c-74.1-21.5-125.2-67.1-125.2-119.9zm225.1 38.3l0-55.6c57.8 0 87.8-6.8 87.8 27.3 0 36.5-38.2 28.3-87.8 28.3zm-.9 72.5l26.6 0c10.8 0 18.9 11.7 24 19.2-16.1 1.9-33 2.8-50.6 2.9l0-22.1z"]
  };
  var faInstalod = {
    prefix: 'fab',
    iconName: 'instalod',
    icon: [512, 512, [], "e081", "M153.6 480l233.7 0 115.4-204.2-298.3 57.4-50.8 146.8zM505 240.1L387.4 32 155.9 32 360.5 267.9 505 240.1zM124.6 48.8L7.5 256 123.5 461.2 225.9 165.6 124.6 48.8z"]
  };
  var faCanadianMapleLeaf = {
    prefix: 'fab',
    iconName: 'canadian-maple-leaf',
    icon: [512, 512, [], "f785", "M383.8 351.7c2.5-2.5 105.2-92.4 105.2-92.4l-17.5-7.5c-10-4.9-7.4-11.5-5-17.4 2.4-7.6 20.1-67.3 20.1-67.3s-47.7 10-57.7 12.5c-7.5 2.4-10-2.5-12.5-7.5s-15-32.4-15-32.4-52.6 59.9-55.1 62.3c-10 7.5-20.1 0-17.6-10 0-10 27.6-129.6 27.6-129.6s-30.1 17.4-40.1 22.4c-7.5 5-12.6 5-17.6-5-5.1-7.5-42.7-79.8-42.7-79.8s-37.5 72.3-42.5 79.8c-5 10-10 10-17.6 5-10-5-40.1-22.4-40.1-22.4S183.3 182 183.3 192c2.5 10-7.5 17.5-17.6 10-2.5-2.5-55.1-62.3-55.1-62.3s-12.5 27.3-15 32.3-5 9.9-12.5 7.5C73 177 25.4 167 25.4 167S43 226.7 45.5 234.3c2.4 6 5 12.5-5 17.4L23 259.3s102.6 89.9 105.2 92.4c5.1 5 10 7.5 5.1 22.5-5.1 15-10.1 35.1-10.1 35.1s95.2-20.1 105.3-22.6c8.7-.9 18.3 2.5 18.3 12.5S241 512 241 512l30 0s-5.8-102.7-5.8-112.8 9.5-13.4 18.4-12.5c10 2.5 105.2 22.6 105.2 22.6s-5-20.1-10-35.1 0-17.5 5-22.5z"]
  };
  var faEthereum = {
    prefix: 'fab',
    iconName: 'ethereum',
    icon: [320, 512, [], "f42e", "M311.9 260.8L160 353.6 8 260.8 160 0 311.9 260.8zM160 383.4L8 290.6 160 512 312 290.6 160 383.4z"]
  };
  var faHouzz = {
    prefix: 'fab',
    iconName: 'houzz',
    icon: [448, 512, [], "f27c", "M276 330.7l-104.6 0 0 149.3-154.3 0 0-448 109.5 0 0 104.5 305.1 85.6 0 257.9-155.7 0 0-149.3z"]
  };
  var faViber = {
    prefix: 'fab',
    iconName: 'viber',
    icon: [512, 512, [], "f409", "M444.3 49.9c-12.7-11.7-64.1-49-178.7-49.5 0 0-135.1-8.1-200.9 52.3-36.6 36.6-49.5 90.3-50.9 156.8s-3.1 191.1 117 224.9l.1 0-.1 51.6s-.8 20.9 13 25.1c16.6 5.2 26.4-10.7 42.3-27.8 8.7-9.4 20.7-23.2 29.8-33.7 82.2 6.9 145.3-8.9 152.5-11.2 16.6-5.4 110.5-17.4 125.7-142 15.8-128.6-7.6-209.8-49.8-246.5zM458.2 287c-12.9 104-89 110.6-103 115.1-6 1.9-61.5 15.7-131.2 11.2 0 0-52 62.7-68.2 79-5.3 5.3-11.1 4.8-11-5.7 0-6.9 .4-85.7 .4-85.7l0 0C43.4 372.7 49.4 266.6 50.5 211.1s11.6-101 42.6-131.6c55.7-50.5 170.4-43 170.4-43 96.9 .4 143.3 29.6 154.1 39.4 35.7 30.6 53.9 103.8 40.6 211.1zm-139-80.8c.4 8.6-12.5 9.2-12.9 .6-1.1-22-11.4-32.7-32.6-33.9-8.6-.5-7.8-13.4 .7-12.9 27.9 1.5 43.4 17.5 44.8 46.2zm20.3 11.3c1-42.4-25.5-75.6-75.8-79.3-8.5-.6-7.6-13.5 .9-12.9 58 4.2 88.9 44.1 87.8 92.5-.1 8.6-13.1 8.2-12.9-.3zm47 13.4c.1 8.6-12.9 8.7-12.9 .1-.6-81.5-54.9-125.9-120.8-126.4-8.5-.1-8.5-12.9 0-12.9 73.7 .5 133 51.4 133.7 139.2zM375.2 329l0 .2c-10.8 19-31 40-51.8 33.3l-.2-.3c-21.1-5.9-70.8-31.5-102.2-56.5-16.2-12.8-31-27.9-42.4-42.4-10.3-12.9-20.7-28.2-30.8-46.6-21.3-38.5-26-55.7-26-55.7-6.7-20.8 14.2-41 33.3-51.8l.2 0c9.2-4.8 18-3.2 23.9 3.9 0 0 12.4 14.8 17.7 22.1 5 6.8 11.7 17.7 15.2 23.8 6.1 10.9 2.3 22-3.7 26.6l-12 9.6c-6.1 4.9-5.3 14-5.3 14s17.8 67.3 84.3 84.3c0 0 9.1 .8 14-5.3l9.6-12c4.6-6 15.7-9.8 26.6-3.7 14.7 8.3 33.4 21.2 45.8 32.9 7 5.7 8.6 14.4 3.8 23.6z"]
  };
  var faKickstarter = {
    prefix: 'fab',
    iconName: 'kickstarter',
    icon: [448, 512, ["square-kickstarter"], "f3bb", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zM320.8 233l-23.3 23.1 23.3 22.9c24.1 23.9 24.1 63 0 86.9s-63.4 23.9-87.6 0l-8.5-8.4c-11.3 16-29.7 26.5-50.9 26.5-34.1 0-61.9-27.5-61.9-61.4l0-133.2c0-33.8 27.7-61.4 61.9-61.4 21.1 0 39.6 10.5 50.9 26.5l8.5-8.4c24.1-23.9 63.4-23.9 87.6 0s24.1 63 0 86.9z"]
  };
  var faSquareKickstarter = faKickstarter;
  var faSpotify = {
    prefix: 'fab',
    iconName: 'spotify',
    icon: [512, 512, [], "f1bc", "M256 8a248 248 0 1 0 0 496 248 248 0 1 0 0-496zM356.7 372.9c-4.2 0-6.8-1.3-10.7-3.6-62.4-37.6-135-39.2-206.7-24.5-3.9 1-9 2.6-11.9 2.6-9.7 0-15.8-7.7-15.8-15.8 0-10.3 6.1-15.2 13.6-16.8 81.9-18.1 165.6-16.5 237 26.2 6.1 3.9 9.7 7.4 9.7 16.5s-7.1 15.4-15.2 15.4zm26.9-65.6c-5.2 0-8.7-2.3-12.3-4.2-62.5-37-155.7-51.9-238.6-29.4-4.8 1.3-7.4 2.6-11.9 2.6-10.7 0-19.4-8.7-19.4-19.4s5.2-17.8 15.5-20.7c27.8-7.8 56.2-13.6 97.8-13.6 64.9 0 127.6 16.1 177 45.5 8.1 4.8 11.3 11 11.3 19.7-.1 10.8-8.5 19.5-19.4 19.5zm31-76.2c-5.2 0-8.4-1.3-12.9-3.9-71.2-42.5-198.5-52.7-280.9-29.7-3.6 1-8.1 2.6-12.9 2.6-13.2 0-23.3-10.3-23.3-23.6 0-13.6 8.4-21.3 17.4-23.9 35.2-10.3 74.6-15.2 117.5-15.2 73 0 149.5 15.2 205.4 47.8 7.8 4.5 12.9 10.7 12.9 22.6 0 13.6-11 23.3-23.2 23.3z"]
  };
  var faLeanpub = {
    prefix: 'fab',
    iconName: 'leanpub',
    icon: [576, 512, [], "f212", "M386.6 111.5l15.1 249-11-.3c-36.2-.8-71.6 8.8-102.7 28-31-19.2-66.4-28-102.7-28-45.6 0-82.1 10.7-123.5 27.7L93.2 129.6c28.5-11.8 61.5-18.1 92.2-18.1 41.2 0 73.8 13.2 102.7 42.5 27.7-28.3 59-41.7 98.5-42.5zM569.2 448c-25.5 0-47.5-5.2-70.5-15.6-34.3-15.6-70-25-107.9-25-39 0-74.9 12.9-102.7 40.6-27.7-27.7-63.7-40.6-102.7-40.6-37.9 0-73.6 9.3-107.9 25-22.2 9.9-44.7 15.6-69.2 15.6L7 448 49.6 98.9c39.3-22.2 87-34.9 132.3-34.9 37.1 0 75.2 7.7 106.2 29.1 31-21.4 69.2-29.1 106.2-29.1 45.3 0 93 12.6 132.3 34.9L569.2 448zm-43.4-44.7L491.8 123c-30.7-14-67.2-21.4-101-21.4-38.4 0-74.4 12.1-102.7 38.7-28.3-26.6-64.2-38.7-102.7-38.7-33.8 0-70.3 7.4-101 21.4l-34 280.2c47.2-19.5 82.9-33.5 135-33.5 37.6 0 70.8 9.6 102.7 29.6 31.8-20 65.1-29.6 102.7-29.6 52.2 0 87.8 14 135 33.5z"]
  };
  var faJava = {
    prefix: 'fab',
    iconName: 'java',
    icon: [384, 512, [], "f4e4", "M277.8 312.9c9.8-6.7 23.4-12.5 23.4-12.5s-38.7 7-77.2 10.2c-47.1 3.9-97.7 4.7-123.1 1.3-60.1-8 33-30.1 33-30.1s-36.1-2.4-80.6 19c-52.5 25.4 130 37 224.5 12.1zm-85.4-32.1c-19-42.7-83.1-80.2 0-145.8 103.7-81.8 50.5-135 50.5-135 21.5 84.5-75.6 110.1-110.7 162.6-23.9 35.9 11.7 74.4 60.2 118.2zM307 104.6c.1 0-175.2 43.8-91.5 140.2 24.7 28.4-6.5 54-6.5 54s62.7-32.4 33.9-72.9C216 188.1 195.4 169.3 307 104.6zm-6.1 270.5c-.5 1-1.2 1.8-2 2.6 128.3-33.7 81.1-118.9 19.8-97.3-3.3 1.2-6.2 3.4-8.2 6.3 3.6-1.3 7.3-2.3 11-3 31-6.5 75.5 41.5-20.6 91.4zM348 437.4s14.5 11.9-15.9 21.2c-57.9 17.5-240.8 22.8-291.6 .7-18.3-7.9 16-19 26.8-21.3 11.2-2.4 17.7-2 17.7-2-20.3-14.3-131.3 28.1-56.4 40.2 204.2 33.2 372.4-14.9 319.4-38.8zM124.5 396c-78.7 22 47.9 67.4 148.1 24.5-9.8-3.8-19.2-8.4-28.2-13.8-44.7 8.5-65.4 9.1-106 4.5-33.5-3.8-13.9-15.2-13.9-15.2zm179.8 97.2c-78.7 14.8-175.8 13.1-233.3 3.6 0-.1 11.8 9.7 72.4 13.6 92.2 5.9 233.8-3.3 237.1-46.9 0 0-6.4 16.5-76.2 29.7zM260.7 353c-59.2 11.4-93.5 11.1-136.8 6.6-33.5-3.5-11.6-19.7-11.6-19.7-86.8 28.8 48.2 61.4 169.5 25.9-7.8-2.8-15-7.1-21.1-12.8z"]
  };
  var faNfcSymbol = {
    prefix: 'fab',
    iconName: 'nfc-symbol',
    icon: [512, 512, [], "e531", "M360.9 32.4c7.7-1.3 15.7 .5 21.2 5 84.1 58.7 129.9 136.3 129.9 217.7 0 83.1-45.8 160.8-129.9 219.5-4.8 4-11.7 5.9-18.6 5.3-7-.6-13.5-3.6-18.4-8.5L161.7 288.7c-5.6-5.5-8.7-13-9.6-20.9 0-7.8 4-15.3 9.5-20.9 5.6-5.5 13.1-8.7 20.9-8.7 7.9 0 15.4 3.1 20.9 8.6L368.5 411.2c54.6-44.7 84.3-99.2 84.3-156.1 0-61.6-36.9-122.2-103.9-169.3-6.4-4.5-10.8-11.4-12.1-19.1-1.4-7.7 .4-15.7 5-22.1 4.5-6.4 11.4-10.8 19.1-12.1zm-206 447.2c-7.7 1.3-15.6-.5-22.1-5-83.1-58.7-129-136.4-129-219.5 0-81.4 45.8-159 129-217.7 5.7-4 12.6-5.9 19.6-5.3 6.9 .6 13.4 3.6 18.3 8.5L354.1 223.3c5.6 5.5 8.7 13 8.7 20.9 .1 6.9-3 15.3-8.6 20.9-5.5 5.5-13 8.7-20.9 8.7-7.8 0-16.2-3.1-20.9-8.6L147.3 100.7c-54.6 45.2-84.3 99.2-84.3 154.4 0 63.4 36.9 124 103.1 171.1 7.3 4.6 11.6 11.4 13 19.2 1.3 7.7-.5 15.7-5 22.1s-11.4 10.7-19.2 12.1z"]
  };
  var faWodu = {
    prefix: 'fab',
    iconName: 'wodu',
    icon: [640, 512, [], "e088", "M178.4 339.7l-37.3 0-28.9-116.2-.5 0-28.5 116.2-38 0-45.2-170.8 37.5 0 27 116.2 .5 0 29.7-116.2 35.2 0 29.2 117.7 .5 0 28-117.7 36.8 0-45.9 170.8zm93-127c39 0 64.1 25.8 64.1 65.3 0 39.2-25.1 65-64.1 65-38.7 0-63.9-25.8-63.9-65 0-39.5 25.1-65.3 63.9-65.3zm0 104.8c23.2 0 30.1-19.9 30.1-39.5 0-19.9-6.9-39.7-30.1-39.7-27.7 0-29.9 19.9-29.9 39.7 0 19.6 6.9 39.5 29.9 39.5zm163.7 6.5l-.5 0c-7.9 13.4-21.8 19.1-37.5 19.1-37.3 0-55.5-32-55.5-66.2 0-33.2 18.4-64.1 54.8-64.1 14.6 0 28.9 6.2 36.8 18.4l.2 0 0-62.2 34 0 0 170.8-32.3 0 0-15.8zm-29.7-85.6c-22.2 0-29.9 19.1-29.9 39.5 0 19.4 8.8 39.7 29.9 39.7 22.5 0 29.2-19.6 29.2-39.9 0-20.1-7.2-39.2-29.2-39.2zM593 339.7l-32.3 0 0-17.2-.7 0c-8.6 13.9-23.4 20.6-37.8 20.6-36.1 0-45.2-20.3-45.2-50.9l0-76.1 34 0 0 69.8c0 20.3 6 30.4 21.8 30.4 18.4 0 26.3-10.3 26.3-35.4l0-64.8 34 0 0 123.6zm9.5-36.8l37.5 0 0 36.8-37.5 0 0-36.8z"]
  };
  var faSquareSteam = {
    prefix: 'fab',
    iconName: 'square-steam',
    icon: [448, 512, ["steam-square"], "f1b7", "M165.6 309.1c18.6 7.7 27.3 28.9 19.6 47.4s-29 27.2-47.6 19.4l-28.5-11.8c5 10.6 13.8 19.4 25.4 24.2 25.2 10.5 54.1-1.4 64.6-26.5 5.1-12.1 5.1-25.5 .1-37.7-5.1-12.1-14.5-21.6-26.7-26.7-12.1-5-25-4.8-36.4-.5l29.5 12.2zM448 96c0-35.3-28.7-64-64-64L64 32C28.7 32 0 60.7 0 96l0 144.7 116.6 48.1c12-8.2 26.2-12.1 40.7-11.3l55.4-80.2 0-1.1c0-48.2 39.3-87.5 87.6-87.5s87.6 39.3 87.6 87.5c0 49.2-40.9 88.7-89.6 87.5l-79 56.3c1.6 38.5-29.1 68.8-65.7 68.8-31.8 0-58.5-22.7-64.5-52.7L0 319.2 0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320zM241.9 196.2a58.4 58.4 0 1 0 116.8 0 58.4 58.4 0 1 0 -116.8 0zm102.4-.1a43.9 43.9 0 1 1 -87.8 0 43.9 43.9 0 1 1 87.8 0z"]
  };
  var faSteamSquare = faSquareSteam;
  var faCreativeCommonsNcEu = {
    prefix: 'fab',
    iconName: 'creative-commons-nc-eu',
    icon: [512, 512, [], "f4e9", "M255.7 8C111.6 8 8 124.8 8 256 8 392.3 119.7 504 255.7 504 385.9 504 504 403.1 504 256 504 117 396.4 8 255.7 8zm.6 450.7c-112 0-203.6-92.5-203.6-202.7 0-23.2 3.7-45.2 10.9-66l65.7 29.1-4.7 0 0 29.5 23.3 0c0 6.2-.4 3.2-.4 19.5l-22.8 0 0 29.5 27 0c11.4 67 67.2 101.3 124.6 101.3 26.6 0 50.6-7.9 64.8-15.8l-10-46.1c-8.7 4.6-28.2 10.8-47.3 10.8-28.2 0-58.1-10.9-67.3-50.2l90.3 0 128.3 56.8c-1.5 2.1-56.2 104.3-178.8 104.3zM239.6 268.1l-.5-.4 .9 .4-.4 0zm77.2-19.5l3.7 0 0-29.5-70.3 0-28.6-12.6c2.5-5.5 5.4-10.5 8.8-14.3 12.9-15.8 31.1-22.4 51.1-22.4 18.3 0 35.3 5.4 46.1 10l11.6-47.3c-15-6.6-37-12.4-62.3-12.4-39 0-72.2 15.8-95.9 42.3-5.3 6.1-9.8 12.9-13.9 20.1L85.5 146.4c64.6-96.8 157.7-93.6 170.7-93.6 113 0 203 90.2 203 203.4 0 18.7-2.1 36.3-6.3 52.9L316.8 248.6z"]
  };
  var faNpm = {
    prefix: 'fab',
    iconName: 'npm',
    icon: [576, 512, [], "f3d4", "M288 288l-32 0 0-64 32 0 0 64zM576 160l0 192-288 0 0 32-128 0 0-32-160 0 0-192 576 0zM160 192l-128 0 0 128 64 0 0-96 32 0 0 96 32 0 0-128zm160 0l-128 0 0 160 64 0 0-32 64 0 0-128zm224 0l-192 0 0 128 64 0 0-96 32 0 0 96 32 0 0-96 32 0 0 96 32 0 0-128z"]
  };
  var faCloudscale = {
    prefix: 'fab',
    iconName: 'cloudscale',
    icon: [448, 512, [], "f383", "M318.1 154l-9.4 7.6c-22.5-19.3-51.5-33.6-83.3-33.6-71.6 0-129.4 60.8-129.4 132.3 0 6.6 .4 13.1 1.4 19.4-2-56 41.8-97.4 92.6-97.4 24.2 0 46.2 9.4 62.6 24.7l-25.2 20.4c-8.3-.9-16.8 1.8-23.1 8.1-11.1 11-11.1 28.9 0 40 11.1 11 28.9 11 40 0 6.3-6.3 9-14.9 8.1-23.1l75.2-88.8c6.3-6.5-3.3-15.9-9.5-9.6zM213.7 246.5a14 14 0 1 1 20.6 19 14 14 0 1 1 -20.6-19zM224 32a224 224 0 1 0 0 448 224 224 0 1 0 0-448zm0 64a160 160 0 1 1 0 320 160 160 0 1 1 0-320z"]
  };
  var faThemeco = {
    prefix: 'fab',
    iconName: 'themeco',
    icon: [448, 512, [], "f5c6", "M202.9 8.4c9.9-5.7 26-5.8 36-.2L430 115.9c10 5.6 18 19.4 18 30.9L448 364c0 11.4-8.1 25.3-18 31L238.8 503.7c-9.9 5.7-26 5.6-35.8-.2L17.9 395.1C8 389.3 0 375.4 0 364L0 146.7c0-11.4 8-25.4 17.9-31.1L202.9 8.4zM125.5 208.3c-15.9 0-31.9 .1-47.8 .1l0 101.4 19.1 0 0-29.8 28.7 0c49.7 0 49.6-71.7 0-71.7zM265.6 308.6l-30.7-34.6c37-7.5 34.8-65.2-10.9-65.5-16.1 0-32.2-.1-48.3-.1l0 101.6 19.1 0 0-33.9 18.4 0 29.6 33.9 22.8 0 0-1.3zm-41.6-82.3c23.3 0 23.3 32.5 0 32.5l-29.1 0 0-32.5 29.1 0zm-95.6-1.6c21.2 0 21.1 38.9 0 38.9l-32.3 0 0-38.8 32.3 0zm192.6-18.2c-68.5 0-71 105.8 0 105.8 69.5 0 69.4-105.8 0-105.8zm0 17.4c44.1 0 44.8 70.9 0 70.9s-44.4-70.9 0-70.9z"]
  };
  var faGooglePlay = {
    prefix: 'fab',
    iconName: 'google-play',
    icon: [448, 512, [], "f3ab", "M293.6 234.3L72.9 13 353.7 174.2 293.6 234.3zM15.3 0C2.3 6.8-6.4 19.2-6.4 35.3l0 441.3c0 16.1 8.7 28.5 21.7 35.3L271.9 255.9 15.3 0zM440.5 225.6l-58.9-34.1-65.7 64.5 65.7 64.5 60.1-34.1c18-14.3 18-46.5-1.2-60.8zM72.9 499L353.7 337.8 293.6 277.7 72.9 499z"]
  };
  var faKorvue = {
    prefix: 'fab',
    iconName: 'korvue',
    icon: [448, 512, [], "f42f", "M387.6 34l-327 0C27.9 34 1.1 60.8 1.1 93.5l0 327.1c0 32.6 26.8 59.4 59.5 59.4l327.1 0c33 0 59.5-26.8 59.5-59.5l0-327C447.1 60.8 420.3 34 387.6 34zM88.2 120.8l96 0 0 116 61.8-116 110.9 0-81.2 132-187.5 0 0-132zM250 392.9l-65.7-113.6 0 113.6-96 0 0-130.8 191.5 0 88.6 130.8-118.4 0z"]
  };
  var faW3c = {
    prefix: 'fab',
    iconName: 'w3c',
    icon: [640, 512, [], "e7de", "M105.2 305.3l30.9-104.7c7.9-26.7 8.6-40.6 .2-68.8l-10.1-33.9 44.1 0 61 207.4 45.7-155.5c13.3-45.3 21.1-51.9 59.4-51.9l132.8 0c-24.2 42.9-49.3 85.2-73.9 127.9 2.6 .8 5.2 1.8 7.7 2.8 17.3 7.1 32.2 19.4 42 35.5 11.2 18.5 16.8 40.2 16.8 65.2 0 30.8-8.2 56.8-24.6 77.8-14.5 18.6-35 29.5-58.2 31.2 0 .3-5.2 .4-5.8 .4-39.7-.1-70.8-32.1-83.1-68.7l42.9 0c3.5 5.3 6.8 10.7 11.2 15.5 8.1 7.3 18.5 10.9 29.3 11.1 13.1 0 23.3-9.1 29.9-19.8 8.1-13.2 12.2-29 12.2-47.5 0-13.1-1.8-24.3-5.3-33.6-.9-2.3-1.9-4.5-3-6.6-1.4-2.6-2.9-5.1-4.7-7.4-10.1-13.2-29.3-19.7-47.5-19.8l-28.2 0 70.3-122-35.6 0c-43.1 0-35.9-5.4-50.4 43.3l-75.7 255.3-4.2 0-63.1-211.1-63.1 211.1-4.2 0-101-340.7 44.2 0 61 207.4zM467 335.7c.3 .6 11.3 20.3 18.3 30.3 7.1 10.1 19.8 20.9 24.8 24.6s19.1 12.5 34.3 13.9c15.2 1.5 23.3 .2 38.7-6.6 15.4-6.8 27.9-20.4 34.9-28.1 6.9-7.6 17.9-27.3 18.2-27.7l3.3 16.8c1.7 9-1 23.7-4.1 30-4.3 8.6-7.6 13.5-14 20.3-6.1 6.5-16.7 13.5-21.3 16.4-4.6 2.9-23.1 15.1-50.1 10.3s-44.7-25.9-53.9-38.2c-9.8-13.2-16.7-28.3-19-33.2-3.8-8.4-9.9-28.2-10.1-28.8zm169.7-218c3.3 20.3-.1 28.7-9.1 46l-12.7 24.2c-.3-.6-10-20.7-25.9-31.9-13.6-9.6-22.5-11.7-36.3-8.8-17.8 3.7-38 25-46.8 51.2-10.5 31.4-10.7 46.6-11 60.6-.6 22.4 2.9 35.6 2.9 35.6s-15.4-28.5-15.2-70.1c.1-29.7 4.8-56.7 18.5-83.3 12.1-23.4 30.1-37.4 46.1-39.1 16.5-1.7 29.6 6.3 39.7 14.9 10.6 9 21.3 28.8 21.3 28.8l24.9-49.8 3.6 21.8z"]
  };
  var faGrav = {
    prefix: 'fab',
    iconName: 'grav',
    icon: [512, 512, [], "f2d6", "M302.6 210.6c4.5 4.5 4.5 12.3 0 16.8l-10 10c-4.5 4.9-12.3 4.9-17.1 0l-10.8-10.8c-4.5-4.9-4.5-12.3 0-17.1l10-10c4.5-4.5 12.3-4.5 17.1 0l10.8 11.1zm-31.2-20.3a7.7 7.7 0 1 0 -10.6-11 7.7 7.7 0 1 0 10.6 11zm-26.8 5.5a7.5 7.5 0 1 0 10.7 10.5 7.5 7.5 0 1 0 -10.7-10.5zM319.4 182c-20.5-14.9-34.9-44.6-12.3-70.3 22.3-25.7 42-17.8 61.7 .8 12.3 11.7 30.2 25.7 17.8 49.8-12.9 24.3-46.6 34.3-67.2 19.7zm49.2-45.9c-9.2-10.3-24.1 7.1-16 16.6 7.6 9.3 33.1 2.5 16-16.6zM0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0zm443.7 44c2.6-16.6-20.9-17.1-26-26.5-14-24.9-28.6-38-56.3-31.4 12-8.3 24.3-6.3 24.3-6.3 .3-6.6 0-13.4-9.7-25.7 4-12.9 .3-23.1 .3-23.1 16-8.9 27.7-25.2 30-44.6 3.7-32-19.4-61.1-51.4-64.8-22.8-2.6-45.1 7.9-56.1 26.5-23.9 41.4 1.4 73.2 23.1 84-14.9-1.4-35.4-12.3-41.4-35.4-6.8-26.5 2.9-51.4 9.2-63.4 0 0-4.5-6-8.3-9.2 0 0-14.2 0-25.4 5.5 12.3-15.7 26-14.9 26-14.9 0-6.6-.6-15.4-3.7-22.3-5.6-11.4-24.6-13.3-32.7 2.9 .1-.2 .3-.4 .4-.5-5.2 12.3-1.1 57.7 17.4 90-2.6 1.4-9.4 6.3-13.4 10.3-22.3 10-58 62.2-58 62.2-29.1 11.1-79.7 52.5-72.9 82.3 .3 3.1 1.4 5.7 3.1 7.7-2.9 2.3-5.7 5.2-8.6 8.6-12.3 14.2-5.5 36.3 18.3 25.2 16.3-7.4 30.6-20.9 37.5-31.4 0 0-5.7-5.2-16.8-4.5 28.6-6.8 35.4-9.7 47.7-9.4 8.3 4 8.3-35.4 8.3-35.4 0-15.2-2.3-32-11.5-42.8 12.9 12.6 30 33.8 28.9 62.6-.8 18.9-15.7 23.7-15.7 23.7-9.4 17.1-44.6 68-31.4 109.4 0 0-10-15.4-10.5-22.8-18 20-48 54-25.4 66.6 27.5 15.2 112.3-91.5 130.3-146.9 35.7-21.5 57.2-48.8 66-67.1 22.7 44.9 98.4 97.5 104.4 60.9z"]
  };
  var faAws = {
    prefix: 'fab',
    iconName: 'aws',
    icon: [640, 512, [], "f375", "M180.4 203c-.7 22.6 10.6 32.7 10.9 39-.1 1.3-.6 2.5-1.3 3.6s-1.7 2-2.8 2.6l-12.8 9c-1.7 1.2-3.6 1.8-5.6 1.9-.4 0-8.2 1.8-20.5-25.6-7.5 9.4-17 16.9-27.9 22s-22.7 7.7-34.7 7.5c-16.3 .9-60.4-9.2-58.1-56.2-1.6-38.3 34.1-62.1 70.9-60 7.1 0 21.6 .4 47 6.3l0-15.6c2.7-26.5-14.7-47-44.8-43.9-2.4 0-19.4-.5-45.8 10.1-7.4 3.4-8.3 2.8-10.8 2.8-7.4 0-4.4-21.5-2.9-24.2 5.2-6.4 35.9-18.4 65.9-18.2 20.1-1.8 40.1 4.4 55.7 17.3 6.3 7.1 11.2 15.4 14.2 24.4s4.2 18.5 3.5 28l0 69.3zM94 235.4c32.4-.5 46.2-20 49.3-30.5 2.5-10.1 2.1-16.4 2.1-27.4-9.7-2.3-23.6-4.9-39.6-4.9-15.2-1.1-42.8 5.6-41.7 32.3-1.2 16.8 11.1 31.4 30 30.5zm170.9 23.1c-7.9 .7-11.5-4.9-12.7-10.4L202.4 83.4c-1-2.8-1.6-5.6-1.9-8.6-.2-1.2 .1-2.4 .8-3.4s1.8-1.6 3-1.8c.2 0-2.1 0 22.2 0 8.8-.9 11.6 6 12.6 10.4L274.9 220.8 308.1 80c.5-3.2 2.9-11.1 12.8-10.2l17.2 0c2.2-.2 11.1-.5 12.7 10.4L384.1 222.7 421 80.1c.5-2.2 2.7-11.4 12.7-10.4l19.7 0c.9-.1 6.2-.8 5.3 8.6-.4 1.8 3.4-10.7-52.8 169.9-1.1 5.5-4.8 11.1-12.7 10.4l-18.7 0c-10.9 1.2-12.5-9.7-12.7-10.7l-33.2-137.1-32.8 137c-.2 1.1-1.7 11.9-12.7 10.7l-18.3 0 0 0zm273.5 5.6c-5.9 0-33.9-.3-57.4-12.3-2.3-1-4.3-2.6-5.7-4.8s-2.1-4.6-2.1-7.1l0-10.7c0-8.5 6.2-6.9 8.8-5.9 10 4.1 16.5 7.1 28.8 9.6 36.7 7.5 52.8-2.3 56.7-4.5 13.2-7.8 14.2-25.7 5.3-34.9-10.5-8.8-15.5-9.1-53.1-21-4.6-1.3-43.7-13.6-43.8-52.4-.6-28.2 25-56.2 69.5-56 12.7 0 46.4 4.1 55.6 15.6 1.4 2.1 2 4.6 1.9 7l0 10.1c0 4.4-1.6 6.7-4.9 6.7-7.7-.9-21.4-11.2-49.2-10.8-6.9-.4-39.9 .9-38.4 25-.4 19 26.6 26.1 29.7 26.9 36.5 11 48.6 12.8 63.1 29.6 17.1 22.2 7.9 48.3 4.3 55.4-19.1 37.5-68.4 34.4-69.3 34.4zm40.2 104.9c-70 51.7-171.7 79.2-258.5 79.2-117.1 .8-230.3-42.3-317.3-120.7-6.5-5.9-.8-14 7.2-9.5 96.5 55.2 205.7 84.2 316.9 84.1 83-.4 165.1-17.3 241.6-49.5 11.8-5 21.8 7.8 10.1 16.4zm29.2-33.3c-9-11.5-59.3-5.4-81.8-2.7-6.8 .8-7.9-5.1-1.8-9.5 40.1-28.2 105.9-20.1 113.4-10.6 7.5 9.5-2.1 75.4-39.6 106.9-5.8 4.9-11.3 2.3-8.7-4.1 8.4-21.3 27.4-68.5 18.4-80z"]
  };
  var faGlideG = {
    prefix: 'fab',
    iconName: 'glide-g',
    icon: [448, 512, [], "f2a6", "M407.1 211.2c-3.5-1.4-11.6-3.8-15.4-3.8-37.1 0-62.2 16.8-93.5 34.5l-.9-.9c7-47.3 23.5-91.9 23.5-140.4 0-71.5-38.2-100.6-108.4-100.6-115.1 0-173.4 113.7-173.4 198.4 0 87.9 51.3 136.6 138.6 136.6 12 0 11-1 11 3.8-16.9 128.9-90.8 133.1-90.8 94.6 0-39.2 45-58.6 45.5-61-.3-12.2-47-27.6-58.9-27.6-33.9 .1-52.4 51.2-52.4 79.3 0 51.9 32.8 87.9 85.5 87.9 77.4 0 134-77.8 151.4-145.4 15.1-60.5 11.2-63.3 19.7-67.6 32.2-16.2 57.5-27 93.8-27 17.8 0 30.5 3.7 58.9 8.4 2.9 0 6.7-2.9 6.7-5.8 0-8-33.4-60.5-40.9-63.4zM231.8 126.8c-9.3 44.7-18.6 89.6-27.8 134.3-2.3 10.2-13.3 7.8-22 7.8-38.3 0-49-41.8-49-73.1 0-47 18-109.3 61.8-133.4 7-4.1 14.8-6.7 22.6-6.7 18.6 0 20 13.3 20 28.7-.1 14.3-2.7 28.5-5.6 42.4z"]
  };
  var faJsfiddle = {
    prefix: 'fab',
    iconName: 'jsfiddle',
    icon: [576, 512, [], "f1cc", "M511.1 237.5c-4.7-2.6-5.7-5.7-6.4-10.8-2.4-16.5-3.5-33.6-9.1-49.1-35.9-100-154-143.4-246.8-91.6-27.4 15.2-49 36.4-65.5 63.9-3.2-1.5-5.5-2.7-7.8-3.7-30.1-12.4-59-10.1-85.3 9.2-25.5 18.7-36.4 44.5-32.7 76.4 .4 3-2 7.6-4.5 9.5-39.7 30-56 78.1-41.9 124.6 13.8 45.6 57.5 79.8 105.6 81.4 30.3 1 60.6 .5 91 .5 84 0 168.1 .5 252.1-.5 52.7-.6 96.1-36.9 108.2-87.3 11.5-48.1-11.1-97.3-56.8-122.6zm21.1 156.9c-18.2 22.4-42.3 35.3-71.3 35.7-56.9 .8-113.8 .2-170.7 .2 0 .7-163 .2-163.7 .2-43.9-.3-76.7-19.8-95.2-60-18.9-41.2-4-90.8 34.2-116.1 9.2-6.1 12.5-11.6 10.1-23.1-5.5-26.4 4.5-48 26.4-63 23-15.7 47.4-16.1 72-3.1 10.3 5.4 14.6 11.6 22.2-2.5 14.2-26.4 34.6-46.7 60.7-61.3 97.5-54.4 228.4 7.6 230.2 132.7 .1 8.2 2.4 12.4 9.8 15.9 57.6 26.8 74.5 96.1 35.1 144.5zm-87.8-80.5c-5.8 31.2-34.6 55.1-66.7 55.1-17 0-32.1-6.5-44.1-17.7-27.7-25.7-71.1-75-95.9-93.4-20.1-14.9-42-12.3-60.3 3.8-50 44.1 15.9 121.8 67.1 77.2 4.5-4 7.8-9.5 12.7-12.8 8.2-5.5 20.8-.9 13.2 10.6-17.4 26.3-49.3 38.2-78.9 29.3-28.9-8.7-48.8-36-48.6-70.2 1.2-22.5 12.4-43.1 35.4-56 22.6-12.6 46.4-13.1 67 2.5 50.8 38.5 75.6 81.7 107.3 101.2 24.6 15.1 54.3 7.4 68.8-17.5 28.8-49.2-34.6-105-78.9-63.5-4 3.7-6.9 8.9-11.4 11.7-11 6.8-17.3-4.1-12.8-10.4 20.7-28.6 50.5-40.4 83.3-28.2 31.4 11.7 49.1 44.4 42.8 78.2z"]
  };
  var faKeybase = {
    prefix: 'fab',
    iconName: 'keybase',
    icon: [448, 512, [], "f4f5", "M286.2 419a18 18 0 1 0 0 36 18 18 0 1 0 0-36zM398.1 271.4c-9.5-14.6-39.4-52.4-87.3-73.7-6.1-2.7-12.2-5.1-18.4-7.3 4.1-9.9 6-20.6 5.8-31.4s-2.7-21.3-7.2-31.1-10.9-18.5-18.9-25.7-17.4-12.6-27.6-16c-12.4-4.1-23.3-6-32.4-5.8-.6-2-1.9-11 9.4-35l-22.9-13.5-5.5 7.6c-8.7 12.1-16.9 23.6-24.3 34.9-2.7-.6-5.5-1.1-8.3-1.2-41.5-2.4-39-2.3-41.1-2.3-50.6 0-50.8 52.1-50.8 45.9l-2.4 36.7c-1.6 27 19.8 50.2 47.6 51.8l8.9 .5C106 215.5 90.4 227.5 76.6 241.4 14 304.7 14 374 14 429.8l0 33.6 23.3-29.8c3.1 13.1 8 25.8 14.6 37.6 5.8 10.1 14.9 9.4 19.6 7.3 4.2-1.9 10-6.9 3.8-20.1-8-16.8-13.3-34.7-15.8-53.1l46.8-59.8-24.7 74.1c58.2-42.4 157.4-61.8 236.2-38.6 34.2 10.1 67.4 .7 84.7-23.8 .7-1 1.2-2.2 1.8-3.2 1.8 9.4 2.7 18.9 2.8 28.4 0 23.3-3.7 52.9-14.9 81.6-2.5 6.5 1.8 14.5 8.6 15.7 7.4 1.6 15.3-3.1 18.4-11.1 9.6-25.5 14.6-54.6 14.6-86.2 0-38.6-13-77.5-35.9-110.9zM142.4 128.6l-15.7-.9-1.4 21.8 13.1 .8c-.6 6.5-.5 13.1 .3 19.6l-22.4-1.3c-1.6-.1-3.2-.5-4.7-1.1s-2.8-1.6-3.9-2.8-1.9-2.6-2.5-4.1-.8-3.1-.7-4.7L107 119c1-12.2 13.9-11.3 13.3-11.3l29.1 1.7c-2.8 6.2-5.1 12.6-7 19.2zM290.8 300.8c-2.1 1.6-4.8 2.4-7.5 2.2s-5.1-1.5-6.9-3.5l-9.7-11.5-34.4 27c-1.6 1.3-3.7 1.9-5.8 1.7s-4-1.2-5.3-2.8l-15.8-18.6c-1.2-1.6-1.7-3.5-1.5-5.4s1.3-3.7 2.8-4.9l34.6-27.2-14.1-16.7-17.1 13.5c-1.6 1.2-3.5 1.8-5.5 1.6s-3.8-1.1-5.1-2.6c0 0-3.7-4.4-3.8-4.5-1.2-1.6-1.7-3.5-1.5-5.5s1.3-3.7 2.8-4.9L214 225.2s-18.5-22-18.6-22.1c-.8-1-1.3-2.1-1.7-3.3s-.4-2.5-.3-3.7 .6-2.4 1.2-3.5 1.5-2 2.5-2.8c2.1-1.7 4.8-2.4 7.4-2.2s5.1 1.5 6.9 3.6l81.1 96.3c.8 1 1.3 2.1 1.7 3.3s.4 2.5 .3 3.7-.6 2.5-1.2 3.5-1.5 2.1-2.5 2.8zM187.4 419a18 18 0 1 0 0 36 18 18 0 1 0 0-36z"]
  };
  var faLumonDrop = {
    prefix: 'fab',
    iconName: 'lumon-drop',
    icon: [576, 512, [], "e7e3", "M480 32c53 0 96 43 96 96l0 224c0 53-43 96-96 96L96 448c-53 0-96-43-96-96L0 128C0 75 43 32 96 32l384 0zM302.4 114.7c-9.8-16.4-20.5-16.4-29.6 0l-68.9 114c-10.7 15.6-16.4 32.8-16.4 52.5 0 50.9 44.3 94.3 100.1 94.3 55 0 100.9-43.5 100.9-94.3 0-19.7-6.6-37.8-17.2-52.5l-68.9-114z"]
  };
  var faWeebly = {
    prefix: 'fab',
    iconName: 'weebly',
    icon: [512, 512, [], "f5cc", "M425.1 65.8c-39.9 0-73.3 25.7-83.7 64.3-18.2-58.1-65.5-64.3-85-64.3-19.8 0-66.8 6.3-85.3 64.3-10.4-38.6-43.4-64.3-83.7-64.3-49 0-87.5 33.9-87.5 77.2 0 29 4.2 33.3 77.2 233.5 22.4 60.6 67.8 69.4 92.7 69.4 39.2 0 70-19.5 85.9-54 15.9 34.8 46.7 54.3 85.9 54.3 25 0 70.4-9.1 92.7-69.7 76.6-208.6 77.5-205.6 77.5-227.2 .6-48.3-36-83.5-86.9-83.5zm26.3 114.8L385.9 357.1c-7.9 21.5-21.2 37.2-46.2 37.2-23.4 0-37.4-12.4-44-33.9l-39.3-117.4-1 0-39.3 117.4c-7 21.5-20.9 33.6-44 33.6-25 0-38.3-15.7-46.2-37.2L60.9 181.6c-5.4-14.8-7.9-23.9-7.9-34.5 0-16.3 15.8-29.4 38.3-29.4 18.7 0 32 11.8 36.1 29.1l44 139.8 1 0 44.7-136.8c6-19.7 16.5-32.1 39-32.1s32.9 12.1 39 32.1l44.7 136.8 1 0 44-139.8c4.1-17.2 17.4-29.1 36.1-29.1 22.2 0 38.3 13.3 38.3 35.7-.3 7.9-4.1 16-7.6 27.2z"]
  };
  var faDocker = {
    prefix: 'fab',
    iconName: 'docker',
    icon: [640, 512, [], "f395", "M349.9 236.3l-66.1 0 0-59.4 66.1 0 0 59.4zm0-204.3l-66.1 0 0 60.7 66.1 0 0-60.7zm78.2 144.8l-66.1 0 0 59.4 66.1 0 0-59.4zM271.8 104.7l-66.1 0 0 60.1 66.1 0 0-60.1zm78.1 0l-66.1 0 0 60.1 66.1 0 0-60.1zm276.8 100c-14.4-9.7-47.6-13.2-73.1-8.4-3.3-24-16.7-44.9-41.1-63.7l-14-9.3-9.3 14c-18.4 27.8-23.4 73.6-3.7 103.8-8.7 4.7-25.8 11.1-48.4 10.7l-434.7 0c-8.7 50.8 5.8 116.8 44 162.1 37.1 43.9 92.7 66.2 165.4 66.2 157.4 0 273.9-72.5 328.4-204.2 21.4 .4 67.6 .1 91.3-45.2 1.5-2.5 6.6-13.2 8.5-17.1l-13.3-8.9zM115.6 176.8l-66 0 0 59.4 66.1 0 0-59.4-.1 0zm78.1 0l-66.1 0 0 59.4 66.1 0 0-59.4zm78.1 0l-66.1 0 0 59.4 66.1 0 0-59.4zm-78.1-72.1l-66.1 0 0 60.1 66.1 0 0-60.1z"]
  };
  var faMagento = {
    prefix: 'fab',
    iconName: 'magento',
    icon: [448, 512, [], "f3c4", "M445.9 127.9l0 256.1-63.4 36.5 0-255.8-158.5-91.6-158.6 91.6 .4 255.9-63.3-36.6 0-255.9 221.9-128.1 221.5 127.9zM255.8 420.5l-31.6 18.4-31.8-18.2 0-256-63.3 36.6 .1 255.9 94.9 54.9 95.1-54.9 0-256-63.4-36.6 0 255.9z"]
  };
  var faGitAlt = {
    prefix: 'fab',
    iconName: 'git-alt',
    icon: [448, 512, [], "f841", "M439.6 236.1L244 40.5C238.6 35 231.2 32 223.6 32s-15 3-20.4 8.4l-40.7 40.6 51.5 51.5c27.1-9.1 52.7 16.8 43.4 43.7l49.7 49.7c34.2-11.8 61.2 31 35.5 56.7-26.5 26.5-70.2-2.9-56-37.3l-46.3-46.3 0 121.9c25.3 12.5 22.3 41.8 9.1 55-6.4 6.4-15.2 10.1-24.3 10.1s-17.8-3.6-24.3-10.1c-17.6-17.6-11.1-46.9 11.2-56l0-123c-20.8-8.5-24.6-30.7-18.6-45L142.6 101 8.5 235.1C3 240.6 0 247.9 0 255.5s3 15 8.5 20.4L204.1 471.6c5.4 5.4 12.7 8.4 20.4 8.4s15-3 20.4-8.4L439.6 276.9c5.4-5.4 8.4-12.8 8.4-20.4s-3-15-8.4-20.4z"]
  };
  var faFirefoxBrowser = {
    prefix: 'fab',
    iconName: 'firefox-browser',
    icon: [512, 512, [], "e007", "M130.2 127.5l0 0zm351.4 45.4c-10.6-25.5-32.1-53-48.9-61.7 13.7 26.9 21.7 53.9 24.7 74 0 .1 0 .3 .1 .4-27.6-68.8-74.4-96.5-112.6-156.8-15-23.7-10.9-25.2-13.1-24.7l-.1 .1c-46.7 26-75.3 78.4-82.6 122.7-16.6 .9-32.9 5-47.9 12.1-1.4 .6-2.5 1.7-3.1 3s-.9 2.8-.6 4.3c.2 .8 .6 1.6 1.1 2.3s1.2 1.3 1.9 1.7 1.6 .7 2.4 .8 1.7 0 2.5-.3l.5-.2c15.5-7.3 32.4-11.2 49.5-11.3 62.8-.6 97.2 44 107.6 62.3-13-9.2-36.4-18.2-58.8-14.3 87.7 43.9 64.2 194.5-57.4 189.2-59.5-2.6-97.1-51-100.5-90.8 0 0 11.2-41.9 80.6-41.9 7.5 0 28.9-20.9 29.3-27-.1-2-42.5-18.9-59.1-35.2-8.8-8.7-13.1-12.9-16.8-16.1-2-1.7-4.1-3.3-6.3-4.8-5.6-19.5-5.8-40-.7-59.6-25.1 11.4-44.6 29.4-58.7 45.4l-.1 0c-9.7-12.2-9-52.6-8.4-61.1-.1-.5-7.2 3.7-8.2 4.3-8.6 6.1-16.5 12.9-23.8 20.4-16.3 16.6-44.1 50.2-55.5 101.2-4.5 20.4-6.8 44.4-6.8 52.3 0 134.7 109.2 243.9 243.9 243.9 120.6 0 223-87.2 240.4-202.6 11.6-76.7-14.7-131.1-14.7-132z"]
  };
  var faCloudsmith = {
    prefix: 'fab',
    iconName: 'cloudsmith',
    icon: [512, 512, [], "f384", "M512 227.6L512 284.5 284.4 512 227.6 512 0 284.4 0 227.6 227.6 0 284.5 0 512 227.6zm-256 162c17.8 .5 35.6-2.6 52.2-9.1s31.8-16.2 44.6-28.7 23-27.3 29.9-43.8 10.5-34.1 10.5-52-3.6-35.5-10.5-52-17.1-31.3-29.9-43.8-28-22.2-44.6-28.7-34.4-9.6-52.2-9.1c-17.8-.5-35.6 2.6-52.2 9.1s-31.8 16.3-44.6 28.7-23 27.3-29.9 43.8-10.5 34.1-10.5 52 3.6 35.5 10.5 52 17.1 31.3 29.9 43.8 28 22.2 44.6 28.7 34.4 9.6 52.2 9.1z"]
  };
  var faWizardsOfTheCoast = {
    prefix: 'fab',
    iconName: 'wizards-of-the-coast',
    icon: [640, 512, [], "f730", "M219.2 345.7c-1.9 1.4-11.1 8.4-.3 23.6 4.6 6.4 14.1 12.8 21.7 6.6 6.5-4.9 7.4-12.9 .3-23-5.5-7.8-14.3-12.9-21.7-7.1zm336.8 75.9c-.3 1.7-.6 1.7 .8 0 2.1-4.2 4.2-10.2 5-19.9 3.1-38.5-40.3-71.5-101.3-78-54.7-6-124.4 9.2-188.8 60.5l-.3 1.6c2.6 5 5 10.7 3.4 21.2l.8 .3c63.9-58.4 131.2-77.2 184.4-73.8 58.4 3.7 100 34 100 68.1 0 10-2.6 15.7-3.9 20.2zM392.3 240.4c.8 7.1 4.2 10.2 9.2 10.5 5.5 .3 9.4-2.6 10.5-6.6 .8-3.4 2.1-29.8 2.1-29.8S402.8 221 399.1 225c-3.7 3.7-7.3 8.4-6.8 15.5zm-50-151.1c-204.5 0-329.2 137.5-341.5 151.9-1 .5-1.3 .8 .8 1.3 60.5 16.5 155.8 81.2 196.1 202.2l1 .3c55.2-69.9 140.9-128.1 237-128.1 80.9 0 130.2 42.2 130.2 80.4 0 18.3-6.6 33.5-22.3 46.3 0 1-.2 .8 .8 .8 14.7-10.7 27.5-28.8 27.5-48.2 0-22.8-12.1-38.2-12.1-38.2 7.1 7.1 10.7 16.2 10.7 16.2 5.8-40.9 27-62.3 27-62.3-2.4-9.7-6.8-17.8-6.8-17.8 7.6 8.1 14.4 27.5 14.4 41.4 0 10.5-3.4 22.8-12.6 31.9l.3 .5c8.1-5 16.5-16.8 16.5-38 0-15.7-4.7-25.9-4.7-25.9 5.8-5.2 11.3-9.2 16-11.8 .8 3.4 2.1 9.7 2.4 14.9 0 1 .8 1.8 1 0 .8-5.8-.3-16.2-.3-16.5 6-3.1 9.7-4.5 9.7-4.5-15.7-110.3-144-196.9-291.2-196.9zM243 378.9c-11.1 9-24.2 4.1-30.6-4.2-7.4-9.6-6.8-24.1 4.2-32.5 14.8-11.4 27.1-.5 31.2 5.5 .3 .4 12.1 16.6-4.7 31.2zm2.1-136.4l9.4-17.8 11.8 71-12.6 6-24.6-28.8 14.1-26.7 3.7 4.4-1.8-8.1zm18.6 117.6l-.3-.3c2-4.1-2.5-6.6-17.5-31.7-1.3-2.4-3.1-2.9-4.4-2.6l-.3-.5c7.9-5.8 15.4-10.2 25.4-15.7l.5 .3c1.3 1.8 2.1 2.9 3.4 4.7l-.3 .5c-1-.3-2.4-.8-5.2 .3-2.1 .8-7.9 3.7-12.3 7.6l0 1.3c1.6 2.4 3.9 6.6 5.8 9.7l.3 0c10-6.3 7.6-4.5 11.5-7.9l.3 0c.5 1.8 .5 1.8 1.8 5.5l-.3 .3c-3.1 .6-4.7 .3-11.5 5.5l0 .3c9.5 17 11 16.8 12.6 16l.3 .3c-2.3 1.6-6.3 4.2-9.7 6.6zM319 327.6c-3.1 1.6-6 2.9-10 5l-.3-.3c1.3-2.6 1.2-2.7-11.8-32.5l-.3-.3c-.2 0-8.9 3.7-10 7.3l-.5 0-1-5.8 .3-.5c7.3-4.6 25.5-11.6 27.8-12.6l.5 .3 3.1 5-.3 .5c-3.5-1.8-7.4 .8-12.3 2.6l0 .3c12.3 32 12.7 30.6 14.7 30.6l0 .2zm44.8-16.5c-4.2 1-5.2 1.3-9.7 2.9l-.3-.3 .5-4.5c-1-3.4-3.1-11.5-3.7-13.6l-.3-.3c-3.4 .8-8.9 2.6-12.8 3.9l-.3 .3c.8 2.6 3.1 9.9 4.2 13.9 .8 2.4 1.8 2.9 2.9 3.1l0 .5c-3.7 1-7.1 2.6-10.2 3.9l-.3-.3c1-1.3 1-2.9 .3-5-1-3.1-8.1-23.8-9.2-27.2-.5-1.8-1.6-3.1-2.6-3.1l0-.5c3.1-1 6-2.1 10.7-3.4l.3 .3-.3 4.7c1.3 3.9 2.4 7.6 3.1 9.7l.3 0c3.9-1.3 9.4-2.9 12.8-3.9l.3-.3-2.6-9.4c-.5-1.8-1-3.4-2.6-3.9l0-.3c4.4-1 7.3-1.8 10.7-2.4l.3 .3c-1 1.3-1 2.9-.5 4.4 1.6 6.3 4.7 20.4 6.3 26.5 .5 2.6 1.8 3.4 2.6 3.9zm32.2-6.8l-.3 .3c-4.7 .5-14.1 2.4-22.5 4.2l-.3-.3 .8-4.2c-1.6-7.9-3.4-18.6-5-26.2-.3-1.8-.8-2.9-2.6-3.7l.8-.5c9.2-1.6 20.2-2.4 24.9-2.6l.3 .3c.5 2.4 .8 3.1 1.6 5.5l-.3 .3c-1.1-1.1-3.3-3.2-16.2-.8l-.3 .3c.3 1.6 1 6.6 1.6 9.9l.3 .3c9.5-1.7 4.8-.1 10.7-2.4l.3 0c0 1.6-.3 1.8-.3 5.2l-.3 0c-4.8-1-2.2-.9-10.2 0l-.3 .3c.3 2.1 1.6 9.4 2.1 12.6l.3 .3c1.2 .4 14.2-.6 16.2-4.7l.3 0c-.5 2.4-1 4.2-1.6 6zm10.7-44.5c-4.5 2.4-8.1 2.9-11 2.9-.2 0-11.4 1.1-17.5-10-6.7-10.8-1-25.2 5.5-31.7 8.8-8.1 23.4-10.1 28.5-17 8-10.3-13-22.3-29.6-5.8l-2.6-2.9 5.2-16.2c25.6-1.6 45.2-3 50 16.2 .8 3.1 0 9.4-.3 12.1 0 2.6-1.8 18.8-2.1 23-.5 4.2-.8 18.3-.8 20.7 .3 2.4 .5 4.2 1.6 5.5 1.6 1.8 5.8 1.8 5.8 1.8l-.8 4.7c-11.8-1.1-10.3-.6-20.4-1-3.2-5.1-2.2-3.3-4.2-7.9 0 0-4.2 3.9-7.3 5.5zM443.9 281c-6.4-10.6-19.8-7.2-21.7 5.5-2.6 17.1 14.3 19.8 20.7 10.2l.3 .3c-.5 1.8-1.8 6-1.8 6.3l-.5 .5c-10.3 6.9-28.5-2.5-25.7-18.6 1.9-10.9 14.4-18.9 28.8-9.9l.3 .5c0 1.1-.3 3.4-.3 5.3zm5.8-87.7l0-6.6c.7 0 19.6 3.3 27.8 7.3l-1.6 17.5s10.2-9.4 15.4-10.7c5.2-1.6 14.9 7.3 14.9 7.3l-11.3 11.3c-12.1-6.4-19.6-.1-20.7 .8-5.3 38.7-8.6 42.2 4.4 46.1l-.5 4.7c-17.6-4.3-18.5-4.5-36.9-7.3l.8-4.7c7.3 0 7.5-5.3 7.6-6.8 0 0 5-53.2 5-55.3 0-2.9-5-3.7-5-3.7zm11 114.4c-8.1-2.1-14.1-11-10.7-20.7 3.1-9.4 12.3-12.3 18.9-10.2 9.2 2.6 12.8 11.8 10.7 19.4-2.6 8.9-9.4 13.9-18.9 11.5zm42.2 9.7c-2.4-.5-7.1-2.4-8.6-2.9l0-.3 1.6-1.8c.6-8.2 .6-7.3 .3-7.6-4.8-1.8-6.7-2.4-7.1-2.4-1.3 1.8-2.9 4.5-3.7 5.5l-.8 3.4 0 .3c-1.3-.3-3.9-1.3-6-1.6l0-.3 2.6-1.8c3.4-4.7 10-14.1 13.9-20.2l0-2.1 .5-.3c2.1 .8 5.5 2.1 7.6 2.9 .5 .5 .2-1.9-1 25.1-.2 1.8 0 2.6 .8 3.9zm-4.7-89.8c11.3-18.3 30.8-16.2 34-3.4l7.6-26.2c2.3-6.2-2.8-9.9-4.5-11.3l1.8-3.7c12.2 10.4 16.4 14 22.5 20.4-25.9 73.1-30.8 80.8-24.6 84.3l-1.8 4.4c-6.4-3.3-8.9-4.4-17.8-8.6l2.1-6.8c-.3-.3-3.9 3.9-9.7 3.7-19.1-1.3-22.9-31.7-9.7-52.9zm29.3 79.3c0-5.7-6.3-7.9-7.9-5.2-1.3 2.1 1 5 2.9 8.4 1.6 2.6 2.6 6.3 1 9.4-2.6 6.3-12.4 5.3-15.4-.8 0-.7-.3 .1 1.8-4.7l.8-.3c-.6 5.7 6.1 9.6 8.4 5 1-2.1-.5-5.5-2.1-8.4-1.6-2.6-3.7-6.3-1.8-9.7 2.7-5.1 11.3-4.5 14.7 2.4l0 .5-2.4 3.4zm21.2 13.4c-2-3.3-.9-2.1-4.5-4.7l-.3 0c-2.4 4.2-5.8 10.5-8.6 16.2-1.3 2.4-1 3.4-.8 3.9l-.3 .3-5.8-4.4 .3-.3 2.1-1.3c3.1-5.8 6.6-12.1 9.2-17l0-.3c-2.6-2-1.2-1.5-6-1.8l0-.3 3.1-3.4 .3 0c3.7 2.4 10 6.8 12.3 8.9l.3 .3-1.3 3.9zM575.8 276l-2.9-2.9c.8-2.4 1.8-5 2.1-7.6 .7-9.7-11.5-11.8-11.5-5 0 5 7.9 19.4 7.9 27.8 0 10.2-5.8 15.7-13.9 16.5-8.4 .8-20.2-10.5-20.2-10.5l5-14.4 2.9 2.1c-3 17.8 17.7 20.4 13.3 5.2-1.1-4-18.7-34.2 2.1-38.2 13.6-2.4 23 16.5 23 16.5L575.8 276zm35.6-10.2c-11-30.4-60.5-127.5-192-129.6-53.4-1-94.3 15.4-132.8 38l85.6-9.2-91.4 20.7 25.1 19.6-3.9-16.5c7.5-1.7 39.1-8.5 66.8-8.9l-22.3 80.4c13.6-.7 19-9 19.6-22.8l5-1 .3 26.7c-22.5 3.2-37.3 6.7-49.5 9.9l13.1-43.2-61.5-36.7 2.4 8.1 10.2 5c6.3 18.6 19.4 56.6 20.4 58.7 2 4.3 3.2 5.8 12 4.5l1.1 5c-16.1 4.9-23.7 7.6-39 14.4l-2.4-4.7c4.4-2.9 8.7-3.9 5.5-12.8-23.7-62.5-21.5-58.1-22.8-59.4l2.4-4.4 33.5 67.3c-3.8-11.9 1.7 1.7-33-78.8l-41.9 88.5 4.7-13.9-35.9-42.2 27.8 93.5-11.8 8.4c-111.9-101.7-105.8-98.4-113.7-98.7-5.5-.3-13.6 5.5-13.6 5.5l-5-6c30.6-23.5 31.6-24.3 58.4-42.7l4.2 7.1s-5.8 4.2-7.9 7.1c-5.9 9.3 1.7 13.3 61.8 75.7l-18.8-58.9 39.8-10.2 25.7 30.6 4.4-12.3-5-24.6 13.1-3.4 .5 3.1 3.7-10.5-94.3 29.3 11.3-5-13.6-42.4 17.3-9.2 30.1 36.1 28.5-13.1c-1.4-7.5-2.5-14.5-4.7-19.6l17.3 13.9 4.7-2.1-59.2-42.7 23.1 11.5c19-6.1 25.2-7.5 32.2-9.7l2.6 11c-12.6 12.6 1.4 16.8 6.5 19.4l-13.6-61 12 28.3c4.2-1.3 7.3-2.1 7.3-2.1l2.6 8.6s-3.1 1-6.3 2.1l8.9 21 33.8-65.7-20.7 61c42.4-24.1 81.4-36.7 132-35.9 67 1 167.3 40.8 199.8 139.8 .8 2.1 0 2.6-.8 .3zm-408-113.4s1.8-.5 4.2-1.3l9.4 7.6c-.4 0-3.4-.3-11.3 2.4l-2.4-8.6zm143.8 38.5c-1.6-.6-26.5-4.8-33.3 20.7l21.7 17 11.5-37.7zM318.4 67.1c-58.4 0-106.1 12-115 14.4l0 .8c8.4 2.1 14.4 4.2 21.2 11.8l1.6 .3c6.6-1.8 49-13.9 110.2-13.9 180.2 0 301.7 116.8 301.7 223.4l0 10c0 1.3 .8 2.6 1.1 .5 .5-2.1 .8-8.6 .8-19.6 .3-83.8-96.6-227.6-321.6-227.6zM529.5 236.8c1.3-5.8 0-12.3-7.3-13.1-9.6-1.1-16.1 23.8-17 33.5-.8 5.5-1.3 14.9 6 14.9 4.7 0 9.7-.9 18.3-35.4zM468 279.7c-2.6-.8-9.4-.8-12.6 10.5-1.8 6.8 .5 13.4 6 14.7 3.7 1.1 8.9 .5 11.8-10.7 2.6-9.9-1.8-13.6-5.2-14.4zm23 21c1.8 .5 3.1 1 5.8 1.8 0-1.8 .5-8.4 .8-12.1-1 1.3-5.5 8.1-6.6 10l0 .3z"]
  };
  var faCreativeCommonsNd = {
    prefix: 'fab',
    iconName: 'creative-commons-nd',
    icon: [512, 512, [], "f4eb", "M255.6 8C397.4 8 504 118.1 504 256 504 403.1 385.5 504 255.6 504 121.6 504 8 394.5 8 256 8 123.1 112.7 8 255.6 8zm.8 44.7c-118.2 0-203.7 97.9-203.7 203.3 0 109.8 91.2 202.8 203.7 202.8 103.2 0 202.8-81.1 202.8-202.8 .1-113.8-90.2-203.3-202.8-203.3zm94 144.3l0 42.5-180.3 0 0-42.5 180.3 0zm0 79.8l0 42.5-180.3 0 0-42.5 180.3 0z"]
  };
  var faUsps = {
    prefix: 'fab',
    iconName: 'usps',
    icon: [512, 512, [], "f7e1", "M428.3 241.7c25.8-41.3 15.2-48.8-11.7-48.8l-27 0c-.1 0-1.5-1.4-10.9 8-11.2 5.6-37.9 6.3-37.9 8.7 0 4.5 70.3-3.1 88.1 0 9.5 1.5-1.5 20.4-4.4 32-.5 4.5 2.4 2.3 3.8 .1zM316.2 264.3c64-21.3 97.3-23.9 102-26.2 4.4-2.9-4.4-6.6-26.2-5.8-51.7 2.2-137.6 37.1-172.6 53.9l-30.7-93.3 196.6 0c-2.7-28.2-152.9-22.6-337.9-22.6L-5 415.8c196.4-97.3 258.9-130.3 321.2-151.5zM62.7 96c253.3 53.7 330 65.7 332.1 85.2 36.4 0 45.9 0 52.4 6.6 21.1 19.7-14.6 67.7-14.6 67.7-4.4 2.9-406.4 160.2-406.4 160.2L449.3 415.7 517 96 62.7 96z"]
  };
  var faSquareLetterboxd = {
    prefix: 'fab',
    iconName: 'square-letterboxd',
    icon: [448, 512, [], "e62e", "M384 32c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96C0 60.7 28.7 32 64 32l320 0zM105.1 187C66.4 187 35 218.3 35 257s31.4 70 70.1 70c24.8 0 46.5-12.8 59-32.2l.5-.7-.4-.6c-6.5-10.6-10.2-23.1-10.2-36.5 0-13.6 3.9-26.3 10.6-37.1-12.4-19.8-34.4-32.9-59.5-32.9zM224 187c-24.8 0-46.5 12.8-59 32.2l-.5 .7 .4 .6c6.5 10.6 10.2 23.1 10.2 36.5 0 13.6-3.9 26.3-10.6 37.1 12.4 19.7 34.4 32.9 59.5 32.9 24.8 0 46.5-12.8 59-32.2l.5-.7-.4-.6c-6.5-10.6-10.2-23.1-10.2-36.5 0-13.6 3.9-26.3 10.6-37.1-12.4-19.7-34.4-32.9-59.5-32.9zm118.9 0c-24.8 0-46.5 12.8-59 32.2l-.5 .7 .4 .6c6.5 10.6 10.2 23.1 10.2 36.5 0 13.6-3.9 26.3-10.6 37.1 12.4 19.8 34.4 32.9 59.5 32.9 38.7 0 70.1-31.3 70.1-70s-31.4-70-70.1-70z"]
  };
  var faMandalorian = {
    prefix: 'fab',
    iconName: 'mandalorian',
    icon: [384, 512, [], "f50f", "M200.6 511.9c-1-3.3-1.7-15.8-1.4-24.6 .6-15.9 1-24.7 1.4-28.8 .6-6.2 2.9-20.7 3.3-21.4 .6-1 .4-27.9-.2-33.1-.3-2.6-.6-11.9-.7-20.7-.1-16.5-.5-20.1-2.7-24.8-1.1-2.3-1.2-3.8-1-11.4 .2-4.2 .1-8.5-.3-12.7-2-13-3.5-27.7-3.2-33.9s.4-7.1 2.1-9.7c3.1-4.7 6.5-14 8.6-23.3 2.3-9.9 3.9-17.2 4.6-20.7 1.1-5.1 2.6-10.1 4.4-15.1 2.3-6.2 2.5-15.4 .4-15.4-.3 0-1.4 1.2-2.4 2.7s-4.8 4.8-8.3 7.4c-8.4 6.1-11.7 9.4-12.7 12.6s-1 7.2-.2 7.8c.3 .2 1.3 2.4 2.1 4.9 1.6 5 1.9 10.3 .7 15.4-.4 1.8-1 5.5-1.5 8.2s-1 6.5-1.3 8.2c-.2 1.5-.7 3-1.5 4.3-1 1-1.1 .9-2.1-.5-.7-1.5-1.2-3.1-1.4-4.7-.2-1.7-1.6-7.1-3.1-11.9-3.3-10.9-3.5-16.2-1-21 .8-1.4 1.4-3 1.7-4.6 0-2.4-2.2-5.3-7.4-9.9-7-6.2-8.6-7.9-10.2-11.3-1.7-3.6-3.1-4.1-4.5-1.5-1.8 3-2.6 9.1-3 22l-.3 12.2 2 2.2c3.2 3.7 12.1 16.5 13.8 19.8 3.4 6.7 4.3 11.7 4.4 23.6s1 22.8 2 24.7c.4 .7 .5 1.4 .3 1.5s.4 2.1 1.3 4.3c1 2.9 1.7 5.9 2.1 9 .4 3.5 .9 7 1.7 10.4 2.2 9.6 2.8 14.1 2.4 20.1-.2 3.3-.5 11.1-.7 17.3-1.3 41.8-1.8 58-2 61.2-.1 2-.4 11.5-.6 21.1-.4 16.3-1.3 27.4-2.4 28.6-.6 .7-8.1-4.9-12.5-9.5-3.8-3.9-4-4.8-2.8-9.9 .7-3 2.3-18.3 3.3-32.6 .4-4.8 .8-10.5 1-12.7 .8-9.4 1.7-20.3 2.6-34.8 .6-8.5 1.3-16.4 1.7-17.7s.9-9.9 1.1-19.1l.4-16.8-2.3-4.3c-1.7-3.3-4.9-6.9-13.2-15.3-6-6.1-11.8-12.3-12.9-13.8l-2-2.8 .8-10.9c1.1-15.7 1.1-48.6 0-59.1l-.9-8.7-3.3-4.5c-5.9-8.1-5.8-7.7-6.2-33.3-.1-6.1-.4-11.5-.6-12.1-.8-1.9-3-2.7-8.5-3-8.9-.6-11-1.9-23.8-14.6-6.2-6-12.3-12-13.8-13.2-2.8-2.4-2.8-2-.6-9.6l1.4-4.6-1.7-3c-.8-1.4-1.6-2.8-2.6-4.1-1.3-1.5-5.5-10.9-6-13.5-.2-.7-.2-1.4-.1-2.1s.5-1.3 .9-1.8c2.2-2.9 3.4-5.7 4.5-10.7 2.3-11.2 7.7-26.1 10.6-29.2 3.2-3.5 7.7-1 9.4 5 1.3 4.8 1.4 9.8 .1 18.6-.5 3.7-.9 7.4-1 11.1 0 4 .2 4.7 2.3 7.4 3.3 4.4 7.7 7.4 15.2 10.5 1.7 .7 3.3 1.7 4.7 2.8 11.2 10.7 18.6 16.2 22.9 16.9 5.2 .8 8 4.5 10 13.4 1.3 5.7 4 11.1 5.5 11.1 1.2-.2 2.3-.7 3.3-1.4 2-1.2 2.2-1.7 2.2-4.2-.3-6-.9-11.9-2-17.8-.4-1.7-.8-4.1-.9-5.4s-.6-3.8-1-5.7c-2.6-11.2-3.6-15.5-4.1-16-1.6-2-4.1-10.2-4.9-15.9-1.6-11.1-4-14.2-12.9-17.4-4.9-1.8-9.4-4.5-13.3-7.9-1.2-1-4-3.2-6.4-5.1s-4.4-3.5-4.6-3.8c-.8-.7-1.7-1.4-2.7-2-6.2-4.2-8.8-7-11.3-12l-2.4-5c-.1-8.7-.3-17.3-.4-26l6.9-6.6c4-3.8 8.5-7.4 10.6-8.4 3.3-1.7 4.4-1.9 11.4-2 8.5-.2 10.1 0 11.7 1.6s1.4 6.4-.3 8.5c-.6 .7-1.1 1.5-1.3 2.3 0 .6-2.6 4.9-5.4 9-1.1 2.2-1.9 4.5-2.4 6.8 20.4 13.4 21.6 3.8 14.1 29l11.4 2.5c3.1-8.7 6.5-17.3 8.6-26.2 .3-7.6-12-4.2-15.4-8.7-2.3-5.9 3.1-14.2 6.1-19.2 1.6-2.3 6.6-4.7 8.8-4.1 .9 .2 4.2-.4 7.4-1.3 2.5-.8 5-1.3 7.5-1.7 2-.2 4.1-.7 6-1.3 3.7-1.1 4.5-1.2 6.3-.4 1.9 .6 3.8 1.1 5.8 1.4 2.1 .3 4.1 .9 6 1.9 1.6 .9 3.3 1.7 5 2.2 2.5 .7 3 .6 7-1.7L226 5.4 236.7 5c10.4-.4 10.8-.5 15.3-2.7L256.5 0 259 1.4c1.8 1 3.1 2.7 4.9 6 2.4 4.5 2.4 4.6 1.4 7.4-.9 2.4-.9 3.3-.1 6.4 .5 2 1.2 4 2.1 5.9 .6 1.3 1.1 2.6 1.3 4 .3 4.3 0 5.3-2.4 6.9-2.2 1.5-7 7.9-7 9.3-.2 1-.6 2-1.1 3-5 11.5-6.8 13.6-14.3 17-9.2 4.2-12.3 5.2-16.2 5.2-3.1 0-4 .2-4.5 1.3-1.2 1.4-2.5 2.7-4.1 3.7-1.8 1.2-3.3 2.9-4.4 4.8-.5 1.2-1.4 2.2-2.5 2.9-.9 .4-1.8 1-2.5 1.7-2.2 1.9-4.6 3.7-7 5.4-3.3 2.3-6.9 5-7.9 6-.7 .7-1.5 1.3-2.4 1.7-.8 .4-1.6 .9-2.1 1.6-1.3 1.4-1.5 2.1-1.1 4.6 .3 2 .8 4 1.4 5.9 1.3 3.8 1.3 7.9 0 10.6s-.9 6.7 1.4 9.6c2 2.6 2.2 4.6 .7 8.8-.8 2.9-1.1 5.9-1.1 8.9 0 4.9 .2 6.3 1.5 8.4s1.8 2.5 3.2 2.3c2-.2 2.3-1.1 4.7-12.1 2.2-10 3.7-11.9 13.8-17.1 2.9-1.5 7.5-4 10-5.4s6.8-3.7 9.4-4.9c5.9-2.6 11.2-6.6 15.2-11.7 7.1-8.8 10-16.2 12.8-33.3 .4-2.8 1.3-5.4 2.9-7.7 1.4-2.2 2.4-4.7 2.9-7.3 1-5.3 2.9-9.1 5.6-11.5 4.7-4.2 6-1.1 4.6 10.9-.5 3.9-1.1 10.3-1.4 14.4l-.6 7.4c3 2.7 5.9 5.5 8.9 8.2l.1 8.4c.1 4.6 .5 9.5 .9 10.9l.8 2.5-6.4 6.3c-8.5 8.3-12.9 13.9-16.8 21.6-1.8 3.5-3.7 7.1-4.4 8-2.2 3.1-6.5 13-8.8 20.3l-2.3 7.2-7 6.5c-3.8 3.6-8 7.2-9.2 8.2-3 2.3-4.3 5.1-4.3 10-.1 2.5 .4 5 1.6 7.3 .8 1.6 1.5 3.2 2.1 4.8 .3 1 .9 2 1.6 2.9 1.4 1.6 1.9 16.1 .8 23.2-.7 4.5-3.6 12-4.7 12-1.8 0-4.1 9.3-5.1 20.7-.2 2-.6 5.9-1 8.7s-1 10-1.4 16c-.8 12.2-.2 18.8 2 23.2 3.4 6.7 .5 12.7-11 22.8l-4 3.5 .1 5.2c.1 3 .4 6 1.1 8.9 4.6 16 4.7 16.9 4.4 37.1-.5 26.4-.3 40.3 .6 44.2 .5 2.3 .9 4.6 1.1 7 .2 2 .7 5.3 1.1 7.4 .5 2.3 .8 11 .8 22.7l0 19.1-1.8 2.6c-2.7 3.9-15.1 13.5-15.5 12.3l.1 0zm29.5-45.1c-.2-.3-.3-6.9-.3-14.6 0-14.1-.9-27.5-2.3-34.4-.4-2-.8-9.7-.9-17.1-.2-11.9-1.4-24.4-2.6-26.4-.7-1.1-3-17.7-3-21.3 0-4.2 1-6 5.3-9.1s4.9-3.1 5.5-.7c.3 1.1 1.4 5.6 2.6 10 3.9 15.1 4.1 16.3 4 21.7-.1 5.8-.1 6.1-1.7 17.7-1 7.1-1.2 12.4-1 28.4 .2 19.4-.6 35.7-2 41.3-.7 2.8-2.8 5.5-3.4 4.4l-.1 0zm-71-37.6c-.8-3.6-1.3-7.2-1.7-10.8s-1-7.2-1.7-10.8c-.5-2.1-.9-4.3-1-6.5-.3-3.2-.9-7.5-1.3-9.5-1-4.8-3.3-19.4-3.4-21.1 0-.7-.3-4-.7-7.4-.7-6.2-.8-27.7-.2-28.3 1-1 6.6 2.8 11.3 7.4l5.3 5.3-.4 6.5c-.2 3.6-.6 10.2-.8 14.8-.5 13.3-.7 8.7-1.6 28.4-.8 17.4-1.9 31.3-2.6 32-.1 .1-.2 .1-.2 .2s-.2 0-.3 0-.2 0-.3-.1-.1-.1-.2-.2l0 0zM72 162.6c21.1 12.8 17.8 14.2 28.5 17.7 13 4.3 18.9 7.1 23.2 16.9-43.7 36.1-69 57.9-76.7 70.9-31 52-6 101.6 62.8 87.2-14.2 29.2-78 28.6-98.7-4.9-24.7-40-22.1-118.3 61-187.7l0 0zm210.8 179c56.7 6.9 82.3-37.7 46.5-89.2 0 0-26.9-29.3-64.3-68 3-15.5 9.5-32.1 30.6-53.8 89.2 63.5 92 141.6 92.5 149.4 4.3 70.6-78.7 91.2-105.3 61.7l0 0z"]
  };
  var faSlack = {
    prefix: 'fab',
    iconName: 'slack',
    icon: [448, 512, [62447, "slack-hash"], "f198", "M94.1 315.1c0 25.9-21.2 47.1-47.1 47.1S0 341 0 315.1 21.2 268 47.1 268l47.1 0 0 47.1zm23.7 0c0-25.9 21.2-47.1 47.1-47.1S212 289.2 212 315.1l0 117.8c0 25.9-21.2 47.1-47.1 47.1s-47.1-21.2-47.1-47.1l0-117.8zm47.1-189c-25.9 0-47.1-21.2-47.1-47.1S139 32 164.9 32 212 53.2 212 79.1l0 47.1-47.1 0zm0 23.7c25.9 0 47.1 21.2 47.1 47.1S190.8 244 164.9 244L47.1 244C21.2 244 0 222.8 0 196.9s21.2-47.1 47.1-47.1l117.8 0zm189 47.1c0-25.9 21.2-47.1 47.1-47.1S448 171 448 196.9 426.8 244 400.9 244l-47.1 0 0-47.1zm-23.7 0c0 25.9-21.2 47.1-47.1 47.1S236 222.8 236 196.9l0-117.8C236 53.2 257.2 32 283.1 32s47.1 21.2 47.1 47.1l0 117.8zm-47.1 189c25.9 0 47.1 21.2 47.1 47.1S309 480 283.1 480 236 458.8 236 432.9l0-47.1 47.1 0zm0-23.7c-25.9 0-47.1-21.2-47.1-47.1S257.2 268 283.1 268l117.8 0c25.9 0 47.1 21.2 47.1 47.1s-21.2 47.1-47.1 47.1l-117.8 0z"]
  };
  var faSlackHash = faSlack;
  var faAngellist = {
    prefix: 'fab',
    iconName: 'angellist',
    icon: [384, 512, [], "f209", "M315.6 215.4c11.7-32.6 45.4-126.9 45.4-157.1 0-26.6-15.7-48.9-43.7-48.9-44.6 0-84.6 131.7-97.1 163.1-9.7-28.5-55.1-172.5-95.1-172.5-31.1 0-45.7 22.9-45.7 51.7 0 35.3 34.2 126.8 46.6 162-6.3-2.3-13.1-4.3-20-4.3-23.4 0-48.3 29.1-48.3 52.6 0 8.9 4.9 21.4 8 29.7-36.9 10-51.1 34.6-51.1 71.7-.1 72.2 68.3 148.6 164.5 148.6 118 0 191.4-88.6 191.4-202.9 0-43.1-6.9-82-54.9-93.7zM280.2 108c4-12.3 21.1-64.3 37.1-64.3 8.6 0 10.9 8.9 10.9 16 0 19.1-38.6 124.6-47.1 148l-34-6 33.1-93.7zM110.8 48.3c0-11.9 14.5-45.7 46.3 47.1l34.6 100.3c-15.6-1.3-27.7-3-35.4 1.4-10.9-28.8-45.5-119.7-45.5-148.8zM108.5 244c29.3 0 67.1 94.6 67.1 107.4 0 5.1-4.9 11.4-10.6 11.4-20.9 0-76.9-76.9-76.9-97.7 .1-7.7 12.7-21.1 20.4-21.1zM292.8 430.3c-29.1 32-66.3 48.6-109.7 48.6-59.4 0-106.3-32.6-128.9-88.3-17.1-43.4 3.8-68.3 20.6-68.3 11.4 0 54.3 60.3 54.3 73.1 0 4.9-7.7 8.3-11.7 8.3-16.1 0-22.4-15.5-51.1-51.4-29.7 29.7 20.5 86.9 58.3 86.9 26.1 0 43.1-24.2 38-42 3.7 0 8.3 .3 11.7-.6 1.1 27.1 9.1 59.4 41.7 61.7 0-.9 2-7.1 2-7.4 0-17.4-10.6-32.6-10.6-50.3 0-28.3 21.7-55.7 43.7-71.7 8-6 17.7-9.7 27.1-13.1 9.7-3.7 20-8 27.4-15.4-1.1-11.2-5.7-21.1-16.9-21.1-27.7 0-120.6 4-120.6-39.7 0-6.7 .1-13.1 17.4-13.1 32.3 0 114.3 8 138.3 29.1 18.1 16.1 24.3 113.2-31 174.7zm-98.6-126c9.7 3.1 19.7 4 29.7 6-7.4 5.4-14 12-20.3 19.1-2.8-8.5-6.2-16.8-9.4-25.1z"]
  };
  var faAndroid = {
    prefix: 'fab',
    iconName: 'android',
    icon: [576, 512, [], "f17b", "M420.5 253.9a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm-265.1 0a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm273.7-96.5l47.9-83c.8-1.1 1.3-2.4 1.5-3.8s.2-2.7-.1-4.1-.9-2.6-1.7-3.7-1.8-2-3-2.7-2.5-1.1-3.9-1.3-2.7 0-4 .4-2.5 1.1-3.6 1.9-1.9 2-2.5 3.2l-48.5 84.1c-38.8-17.4-80.8-26.4-123.3-26.4s-84.5 9-123.3 26.4L116.2 64.4c-.6-1.2-1.5-2.3-2.5-3.2s-2.3-1.5-3.6-1.9-2.7-.5-4-.4-2.7 .6-3.9 1.3-2.2 1.6-3 2.7-1.4 2.4-1.7 3.7-.3 2.7-.1 4.1 .8 2.6 1.5 3.8l47.9 83C64.5 202.2 8.2 285.5 0 384l576 0c-8.2-98.5-64.5-181.8-146.9-226.6z"]
  };
  var faMeetup = {
    prefix: 'fab',
    iconName: 'meetup',
    icon: [576, 512, [], "f2e0", "M131.1 414.3c1.1 5.7-2.3 11.1-8 12.3-5.4 1.1-10.9-2.3-12-8-1.1-5.4 2.3-11.1 7.7-12.3s11.1 2.3 12.3 8zm143.1 71.4c-6.3 4.6-8 13.4-3.7 20 4.6 6.6 13.4 8.3 20 3.7 6.3-4.6 8-13.4 3.4-20-4.2-6.5-13.1-8.3-19.7-3.7zm-86-462.3a11.8 11.8 0 1 0 -4.9-23 11.8 11.8 0 1 0 4.9 23zM66.5 226.3a22.2 22.2 0 1 0 -24.7 36.9 22.2 22.2 0 1 0 24.7-36.9zm272-170.9a22.1 22.1 0 1 0 -22.4-38 22.1 22.1 0 1 0 22.4 38zm-191.1 58a16.9 16.9 0 1 0 -18.8-28 16.9 16.9 0 1 0 18.8 28zm372.3 156c-7.4 1.7-12.3 9.1-10.6 16.9 1.4 7.4 8.9 12.3 16.3 10.6 7.4-1.4 12.3-8.9 10.6-16.6-1.5-7.4-8.9-12.3-16.3-10.9zm39.7-56.8a10.1 10.1 0 1 0 -19.8 4.3 10.1 10.1 0 1 0 19.8-4.3zm-80.3-73.7a18.8 18.8 0 1 0 20.7 31.3 18.8 18.8 0 1 0 -20.7-31.3zm-6.3 139.4c26.3 43.1 15.1 100-26.3 129.1-17.4 12.3-37.1 17.7-56.9 17.1-12 47.1-69.4 64.6-105.1 32.6-1.1 .9-2.6 1.7-3.7 2.9-39.1 27.1-92.3 17.4-119.4-22.3-9.7-14.3-14.6-30.6-15.1-46.9-65.4-10.9-90-94-41.1-139.7-28.3-46.9 .6-107.4 53.4-114.9 25.1-66.2 107.6-97.6 163.6-54.2 67.4-22.3 136.3 29.4 130.9 101.1 41.1 12.6 52.8 66.9 19.7 95.2zm-70 74.3c-3.1-20.6-40.9-4.6-43.1-27.1-3.1-32 43.7-101.1 40-128-3.4-24-19.4-29.1-33.4-29.4-13.4-.3-16.9 2-21.4 4.6-2.9 1.7-6.6 4.9-11.7-.3-6.3-6-11.1-11.7-19.4-12.9-12.3-2-17.7 2-26.6 9.7-3.4 2.9-12 12.9-20 9.1-3.4-1.7-15.4-7.7-24-11.4-16.3-7.1-40 4.6-48.6 20-12.9 22.9-38 113.1-41.7 125.1-8.6 26.6 10.9 48.6 36.9 47.1 11.1-.6 18.3-4.6 25.4-17.4 4-7.4 41.7-107.7 44.6-112.6 2-3.4 8.9-8 14.6-5.1 5.7 3.1 6.9 9.4 6 15.1-1.1 9.7-28 70.9-28.9 77.7-3.4 22.9 26.9 26.6 38.6 4 3.7-7.1 45.7-92.6 49.4-98.3 4.3-6.3 7.4-8.3 11.7-8 3.1 0 8.3 .9 7.1 10.9-1.4 9.4-35.1 72.3-38.9 87.7-4.6 20.6 6.6 41.4 24.9 50.6 11.4 5.7 62.5 15.7 58.5-11.1zm5.7 92.3a23.3 23.3 0 1 0 26.2 38.4 23.3 23.3 0 1 0 -26.2-38.4z"]
  };
  var faFonticonsFi = {
    prefix: 'fab',
    iconName: 'fonticons-fi',
    icon: [384, 512, [], "f3a2", "M114.4 224l92.4 0-15.2 51.2-76.4 0 0 157.8c0 8-2.8 9.2 4.4 10l59.6 5.6 0 34.4-179.2 0 0-35.2 29.2-2.8c7.2-.8 9.2-3.2 9.2-10.8l0-155.8c0-3.2-4-3.2-8-3.2l-30.4 0 0-51.2 38.4 0 0-28.8c0-68 36.4-96 106-96 46.8 0 88.8 11.2 88.8 72.4L163.6 180c.4-25.6-6-31.6-22.4-31.6-25.2 0-26 13.6-26 37.6l0 32c0 3.2-4.8 6-.8 6zM384 483l-140.8 0 0-34.4 28-3.6c7.2-.8 10.4-2.4 10.4-10l0-148c0-5.6-4-9.2-9.2-10.8l-33.2-8.8 9.2-40.4 110 0 0 208c0 8-3.6 8.8 4 10l21.6 3.6 0 34.4zM354 135.8l12.4 45.6-10 10-42.8-22.8-42.8 22.8-10-10 12.4-45.6-30-36.4 4.8-10 38 0 21.2-38.4 12.8 0 21.2 38.4 38 0 4.8 13.2-30 33.2z"]
  };
  var faPalfed = {
    prefix: 'fab',
    iconName: 'palfed',
    icon: [576, 512, [], "f3d8", "M384.9 193.9c0-47.4-55.2-44.2-95.4-29.8-1.3 39.4-2.5 80.7-3 119.8 .7 2.8 2.6 6.2 15.1 6.2 36.8 0 83.4-42.8 83.3-96.2zM190.4 266.1c.2 0 6.5-2.7 11.2-2.7 26.6 0 20.7 44.1-14.4 44.1-21.5 0-37.1-18.1-37.1-43 0-42 42.9-95.6 100.7-126.5 1-12.4 3-22 10.5-28.2 11.2-9 26.6-3.5 29.5 11.1 72.2-22.2 135.2 1 135.2 72 0 77.9-79.3 152.6-140.1 138.2-.1 39.4 .9 74.4 2.7 100l0 .2c.2 3.4 .6 12.5-5.3 19.1-9.6 10.6-33.4 10-36.4-22.3-4.1-44.4 .2-206.1 1.4-242.5-21.5 15-58.5 50.3-58.5 75.9 .2 2.5 .4 4 .6 4.6zM8 181.1s-.1 37.4 38.4 37.4l30 0 22.4 217.2s0 44.3 44.7 44.3l288.9 0s44.7-.4 44.7-44.3l22.4-217.2 30 0s38.4 1.2 38.4-37.4c0 0 .1-37.4-38.4-37.4l-30.1 0c-7.3-25.6-30.2-74.3-119.4-74.3l-28 0 0-19.1s-2.7-18.4-21.1-18.4l-85.8 0S224 31.9 224 50.3l0 19.1-28.1 0s-105 4.2-120.5 74.3l-29 0S8 142.5 8 181.1z"]
  };
  var faWpbeginner = {
    prefix: 'fab',
    iconName: 'wpbeginner',
    icon: [512, 512, [], "f297", "M463.2 322.4c56.2 64.3 4.2 157.6-91.9 157.6-39.6 0-78.8-17.7-100.1-50-6.9 .4-22.7 .4-29.6 0-21.4 32.4-60.6 50-100.1 50-95.5 0-148.3-93-91.9-157.6-79.1-131.9 31.3-290.4 206.8-290.4 175.6 0 285.9 158.6 206.8 290.4zm-339.6-83l41.5 0 0-58.1-41.5 0 0 58.1zm217.2 86.1l0-23.8c-60.5 20.9-132.4 9.2-187.6-34l.2 24.9c51.1 46.4 131.7 57.9 187.3 32.9zM190 239.4l166.1 0 0-58.1-166.1 0 0 58.1z"]
  };
  var faDiaspora = {
    prefix: 'fab',
    iconName: 'diaspora',
    icon: [448, 512, [], "f791", "M219.7 354.6c-1.4 0-88 119.9-88.7 119.9S44.4 414 44 413.3 130.6 287.5 130.6 285.8c0-2.2-129.6-44-137.6-47.1-1.3-.5 31.4-101.8 31.7-102.1 .6-.7 144.4 47 145.5 47 .4 0 .9-.6 1-1.3 .4-2 1-148.6 1.7-149.6 .8-1.2 104.5-.7 105.1-.3 1.5 1 3.5 156.1 6.1 156.1 1.4 0 138.7-47 139.3-46.3 .8 .9 31.9 102.2 31.5 102.6-.9 .9-140.2 47.1-140.6 48.8-.3 1.4 82.8 122.1 82.5 122.9s-85.5 63.5-86.3 63.5c-1-.2-89-125.5-90.9-125.5l0 0z"]
  };
  var faProductHunt = {
    prefix: 'fab',
    iconName: 'product-hunt',
    icon: [512, 512, [], "f288", "M326.3 218.8c0 20.5-16.7 37.2-37.2 37.2l-70.3 0 0-74.4 70.3 0c20.5 0 37.2 16.7 37.2 37.2zM8 256a248 248 0 1 1 496 0 248 248 0 1 1 -496 0zm367.9-37.2c0-47.9-38.9-86.8-86.8-86.8l-119.9 0 0 248 49.6 0 0-74.4 70.3 0c47.9 0 86.8-38.9 86.8-86.8z"]
  };
  var faSquareUpwork = {
    prefix: 'fab',
    iconName: 'square-upwork',
    icon: [448, 512, [], "e67c", "M56 32l336 0c30.9 0 56 25.1 56 56l0 336c0 30.9-25.1 56-56 56L56 480c-30.9 0-56-25.1-56-56L0 88C0 57.1 25.1 32 56 32zM270.9 274.2c6.6-52.9 25.9-69.5 51.4-69.5 25.3 0 44.9 20.2 44.9 49.7s-19.7 49.7-44.9 49.7c-27.9 0-46.3-21.5-51.4-29.9zm-26.7-41.8c-8.2-15.5-14.3-36.3-19.2-55.6l-62.9 0 0 78.1c0 28.4-12.9 49.4-38.2 49.4S84.1 283.4 84.1 255l.3-78.1-36.2 0 0 78.1c0 22.8 7.4 43.5 20.9 58.2 13.9 15.2 32.8 23.2 54.8 23.2 43.7 0 74.2-33.5 74.2-81.5l0-52.5c4.6 17.3 15.4 50.5 36.2 79.7l-19.3 110.5 36.8 0 12.8-78.4c4.2 3.5 8.7 6.6 13.4 9.4 12.3 7.8 26.4 12.2 40.9 12.6l3.4 0c45.1 0 80.9-34.9 80.9-81.9s-35.9-82.2-80.9-82.2c-45.4 0-70.9 29.7-78.1 60.1l0 .2z"]
  };
  var faCuttlefish = {
    prefix: 'fab',
    iconName: 'cuttlefish',
    icon: [448, 512, [], "f38c", "M348 305.5c-17.5 31.6-57.4 54.5-96 54.5-56.6 0-104-47.4-104-104s47.4-104 104-104c38.6 0 78.5 22.9 96 54.5 13.7-50.9 41.7-93.3 87-117.8-45.3-49.6-110.5-80.7-183-80.7-137 0-248 111-248 248S115 504 252 504c72.5 0 137.7-31.1 183-80.7-45.3-24.5-73.3-66.9-87-117.8z"]
  };
  var faMedapps = {
    prefix: 'fab',
    iconName: 'medapps',
    icon: [320, 512, [], "f3c6", "M118.3 238.4c3.5-12.5 6.9-33.6 13.2-33.6 8.3 1.8 9.6 23.4 18.6 36.6 4.6-23.5 5.3-85.1 14.1-86.7 9-.7 19.7 66.5 22 77.5 9.9 4.1 48.9 6.6 48.9 6.6 1.9 7.3-24 7.6-40 7.8-4.6 14.8-5.4 27.7-11.4 28-4.7 .2-8.2-28.8-17.5-49.6l-9.4 65.5c-4.4 13-15.5-22.5-21.9-39.3-3.3-.1-62.4-1.6-47.6-7.8l31-5zM228 448c21.2 0 21.2-32 0-32L92 416c-21.2 0-21.2 32 0 32l136 0zm-24 64c21.2 0 21.2-32 0-32l-88 0c-21.2 0-21.2 32 0 32l88 0zm34.2-141.5c3.2-18.9 5.2-36.4 11.9-48.8 7.9-14.7 16.1-28.1 24-41 24.6-40.4 45.9-75.2 45.9-125.5 0-85.6-71.8-155.2-160-155.2S0 69.6 0 155.2c0 50.2 21.3 85.1 45.9 125.5 7.9 12.9 16 26.3 24 41 6.7 12.5 8.7 29.8 11.9 48.9 3.5 21 36.1 15.7 32.6-5.1-3.6-21.7-5.6-40.7-15.3-58.6-32.6-60.4-66.1-95.6-66.1-151.7 0-67.9 57-123.2 127-123.2S287 87.3 287 155.2c0 56.1-33.5 91.3-66.1 151.6-9.7 18-11.7 37.4-15.3 58.6-3.4 20.6 29 26.4 32.6 5.1z"]
  };
  var faPix = {
    prefix: 'fab',
    iconName: 'pix',
    icon: [512, 512, [], "e43a", "M242.4 292.5c5.4-5.4 14.7-5.4 20.1 0l77 77c14.2 14.2 33.1 22 53.1 22l15.1 0-97.1 97.1c-30.3 29.5-79.5 29.5-109.8 0l-97.5-97.4 9.3 0c20 0 38.9-7.8 53.1-22l76.7-76.7zm20.1-73.6c-6.4 5.5-14.6 5.6-20.1 0l-76.7-76.7c-14.2-15.1-33.1-22-53.1-22l-9.3 0 97.4-97.4c30.4-30.3 79.6-30.3 109.9 0l97.2 97.1-15.2 0c-20 0-38.9 7.8-53.1 22l-77 77zM112.6 142.7c13.8 0 26.5 5.6 37.1 15.4l76.7 76.7c7.2 6.3 16.6 10.8 26.1 10.8 9.4 0 18.8-4.5 26-10.8l77-77c9.8-9.7 23.3-15.3 37.1-15.3l37.7 0 58.3 58.3c30.3 30.3 30.3 79.5 0 109.8l-58.3 58.3-37.7 0c-13.8 0-27.3-5.6-37.1-15.4l-77-77c-13.9-13.9-38.2-13.9-52.1 .1l-76.7 76.6c-10.6 9.8-23.3 15.4-37.1 15.4l-31.8 0-58-58c-30.3-30.3-30.3-79.5 0-109.8l58-58.1 31.8 0z"]
  };
  var faSquareTumblr = {
    prefix: 'fab',
    iconName: 'square-tumblr',
    icon: [448, 512, ["tumblr-square"], "f174", "M448 96c0-35.3-28.7-64-64-64L64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320zM256.8 416c-75.5 0-91.9-55.5-91.9-87.9l0-90-29.7 0c-3.4 0-6.2-2.8-6.2-6.2l0-42.5c0-4.5 2.8-8.5 7.1-10 38.8-13.7 50.9-47.5 52.7-73.2 .5-6.9 4.1-10.2 10-10.2l44.3 0c3.4 0 6.2 2.8 6.2 6.2l0 72 51.9 0c3.4 0 6.2 2.8 6.2 6.2l0 51.1c0 3.4-2.8 6.2-6.2 6.2l-52.1 0 0 83.3c0 21.4 14.8 33.5 42.5 22.4 3-1.2 5.6-2 8-1.4 2.2 .5 3.6 2.1 4.6 4.9L318 387.1c1 3.2 2 6.7-.3 9.1-8.5 9.1-31.2 19.8-60.9 19.8z"]
  };
  var faTumblrSquare = faSquareTumblr;
  var faReact = {
    prefix: 'fab',
    iconName: 'react',
    icon: [512, 512, [], "f41b", "M418.2 177.2c-5.4-1.8-10.8-3.5-16.2-5.1 .9-3.7 1.7-7.4 2.5-11.1 12.3-59.6 4.2-107.5-23.1-123.3-26.3-15.1-69.2 .6-112.6 38.4-4.3 3.7-8.5 7.6-12.5 11.5-2.7-2.6-5.5-5.2-8.3-7.7-45.5-40.4-91.1-57.4-118.4-41.5-26.2 15.2-34 60.3-23 116.7 1.1 5.6 2.3 11.1 3.7 16.7-6.4 1.8-12.7 3.8-18.6 5.9-53.4 18.5-91.7 47.7-91.7 77.9 0 31.2 40.8 62.5 96.3 81.5 4.5 1.5 9 3 13.6 4.3-1.5 6-2.8 11.9-4 18-10.5 55.5-2.3 99.5 23.9 114.6 27 15.6 72.4-.4 116.6-39.1 3.5-3.1 7-6.3 10.5-9.7 4.4 4.3 9 8.4 13.6 12.4 42.8 36.8 85.1 51.7 111.2 36.6 27-15.6 35.8-62.9 24.4-120.5-.9-4.4-1.9-8.9-3-13.5 3.2-.9 6.3-1.9 9.4-2.9 57.7-19.1 99.5-50 99.5-81.7 0-30.3-39.4-59.7-93.8-78.4zM282.9 92.3c37.2-32.4 71.9-45.1 87.7-36 16.9 9.7 23.4 48.9 12.8 100.4-.7 3.4-1.4 6.7-2.3 10-22.2-5-44.7-8.6-67.3-10.6-13-18.6-27.2-36.4-42.6-53.1 3.9-3.7 7.7-7.2 11.7-10.7zM167.2 307.5c5.1 8.7 10.3 17.4 15.8 25.9-15.6-1.7-31.1-4.2-46.4-7.5 4.4-14.4 9.9-29.3 16.3-44.5 4.6 8.8 9.3 17.5 14.3 26.1zM136.9 187.2c14.4-3.2 29.7-5.8 45.6-7.8-5.3 8.3-10.5 16.8-15.4 25.4-4.9 8.5-9.7 17.2-14.2 26-6.3-14.9-11.6-29.5-16-43.6zm27.4 68.9c6.6-13.8 13.8-27.3 21.4-40.6s15.8-26.2 24.4-38.9c15-1.1 30.3-1.7 45.9-1.7s31 .6 45.9 1.7c8.5 12.6 16.6 25.5 24.3 38.7s14.9 26.7 21.7 40.4c-6.7 13.8-13.9 27.4-21.6 40.8-7.6 13.3-15.7 26.2-24.2 39-14.9 1.1-30.4 1.6-46.1 1.6s-30.9-.5-45.6-1.4c-8.7-12.7-16.9-25.7-24.6-39s-14.8-26.8-21.5-40.6zm180.6 51.2c5.1-8.8 9.9-17.7 14.6-26.7 6.4 14.5 12 29.2 16.9 44.3-15.5 3.5-31.2 6.2-47 8 5.4-8.4 10.5-17 15.5-25.6zm14.4-76.5c-4.7-8.8-9.5-17.6-14.5-26.2-4.9-8.5-10-16.9-15.3-25.2 16.1 2 31.5 4.7 45.9 8-4.6 14.8-10 29.2-16.1 43.4zM256.2 118.3c10.5 11.4 20.4 23.4 29.6 35.8-19.8-.9-39.7-.9-59.5 0 9.8-12.9 19.9-24.9 29.9-35.8zM140.2 57c16.8-9.8 54.1 4.2 93.4 39 2.5 2.2 5 4.6 7.6 7-15.5 16.7-29.8 34.5-42.9 53.1-22.6 2-45 5.5-67.2 10.4-1.3-5.1-2.4-10.3-3.5-15.5-9.4-48.4-3.2-84.9 12.6-94zM115.7 320.6c-4.2-1.2-8.3-2.5-12.4-3.9-21.3-6.7-45.5-17.3-63-31.2-10.1-7-16.9-17.8-18.8-29.9 0-18.3 31.6-41.7 77.2-57.6 5.7-2 11.5-3.8 17.3-5.5 6.8 21.7 15 43 24.5 63.6-9.6 20.9-17.9 42.5-24.8 64.5zm116.6 98c-16.5 15.1-35.6 27.1-56.4 35.3-11.1 5.3-23.9 5.8-35.3 1.3-15.9-9.2-22.5-44.5-13.5-92 1.1-5.6 2.3-11.2 3.7-16.7 22.4 4.8 45 8.1 67.9 9.8 13.2 18.7 27.7 36.6 43.2 53.4-3.2 3.1-6.4 6.1-9.6 8.9zm24.5-24.3c-10.2-11-20.4-23.2-30.3-36.3 9.6 .4 19.5 .6 29.5 .6 10.3 0 20.4-.2 30.4-.7-9.2 12.7-19.1 24.8-29.6 36.4zm130.7 30c-.9 12.2-6.9 23.6-16.5 31.3-15.9 9.2-49.8-2.8-86.4-34.2-4.2-3.6-8.4-7.5-12.7-11.5 15.3-16.9 29.4-34.8 42.2-53.6 22.9-1.9 45.7-5.4 68.2-10.5 1 4.1 1.9 8.2 2.7 12.2 4.9 21.6 5.7 44.1 2.5 66.3zm18.2-107.5c-2.8 .9-5.6 1.8-8.5 2.6-7-21.8-15.6-43.1-25.5-63.8 9.6-20.4 17.7-41.4 24.5-62.9 5.2 1.5 10.2 3.1 15 4.7 46.6 16 79.3 39.8 79.3 58 0 19.6-34.9 44.9-84.8 61.4zM256 301.8a45.8 45.8 0 1 0 0-91.6 45.8 45.8 0 1 0 0 91.6z"]
  };
  var faJxl = {
    prefix: 'fab',
    iconName: 'jxl',
    icon: [448, 512, [], "e67b", "M412.2 32L35.8 32C16 32 0 48 0 67.8L0 444.2C0 464 16 480 35.8 480l376.4 0c19.8 0 35.8-16 35.8-35.8l0-376.4C448 48 432 32 412.2 32zM378.6 333.7c0 40.2-32.6 72.8-72.8 72.8l-235.6 0c0-40.2 32.6-72.8 72.8-72.8l235.6 0zm0-113.9c0 40.2-32.6 72.8-72.8 72.8l-235.6 0c0-40.2 32.6-72.8 72.8-72.8l235.6 0zm0-113.9c0 40.2-32.6 72.8-72.8 72.8l-235.6 0c0-40.2 32.6-72.8 72.8-72.8l235.6 0z"]
  };
  var faSquareLinkedin = {
    prefix: 'fab',
    iconName: 'square-linkedin',
    icon: [448, 512, [], "e7d0", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zm5 170.2l66.5 0 0 213.8-66.5 0 0-213.8zm71.7-67.7a38.5 38.5 0 1 1 -77 0 38.5 38.5 0 1 1 77 0zM317.9 416l0-104c0-24.8-.5-56.7-34.5-56.7-34.6 0-39.9 27-39.9 54.9l0 105.8-66.4 0 0-213.8 63.7 0 0 29.2 .9 0c8.9-16.8 30.6-34.5 62.9-34.5 67.2 0 79.7 44.3 79.7 101.9l0 117.2-66.4 0z"]
  };
  var faCss = {
    prefix: 'fab',
    iconName: 'css',
    icon: [448, 512, [], "e6a2", "M376.3 32L0 32 0 408.3c0 19 7.6 37.2 21 50.7s31.7 21 50.7 21l304.6 0c19 0 37.2-7.6 50.7-21s21-31.7 21-50.7l0-304.6c0-19-7.6-37.2-21-50.7s-31.7-21-50.7-21zM332.4 431.4c-7.7-8.5-11.7-20.7-12-36.6l31.3 0c.2 14.1 5.1 21.1 14.8 21.1c4.9 0 8.4-1.6 10.5-4.7c2-3.1 3-8 3-14.8c0-5.4-1.3-9.9-4-13.4c-3.5-4.2-8.1-7.5-13.2-9.5L351.2 368c-10.3-4.9-17.8-10.8-22.5-17.6c-4.5-6.8-6.7-16.3-6.7-28.4c0-13.6 4-24.6 11.8-33.1c8.1-8.5 19.1-12.7 33.2-12.7c13.6 0 24.1 4.2 31.5 12.5c7.5 8.4 11.5 20.3 11.8 35.9l-30.1 0c.2-5.1-.9-10.2-3-14.8c-1.7-3.4-5-5.1-10-5.1c-8.8 0-13.2 5.2-13.2 15.7c0 5.3 1.1 9.4 3.2 12.6c3.1 3.5 7 6.2 11.4 7.8l11.1 4.9c11.5 5.3 19.7 11.7 24.8 19.4c5.1 7.7 7.6 18 7.6 31c0 15.5-4 27.4-12.3 35.7c-8.2 8.3-19.5 12.5-34.1 12.5s-25.6-4.2-33.4-12.7zm-101 0c-7.7-8.5-11.7-20.7-12-36.6l31.3 0c.2 14.1 5.1 21.1 14.8 21.1c4.9 0 8.4-1.6 10.4-4.7c2-3.1 3-8 3-14.8c0-5.4-1.3-9.9-3.9-13.4c-3.5-4.2-8.1-7.5-13.2-9.5L250.2 368c-10.3-4.9-17.8-10.8-22.5-17.6c-4.5-6.8-6.7-16.3-6.7-28.4c0-13.6 4-24.6 11.8-33.1c8.1-8.5 19.1-12.7 33.2-12.7c13.6 0 24.1 4.2 31.4 12.5c7.6 8.4 11.5 20.3 11.9 35.9l-30.1 0c.2-5.1-.9-10.2-3-14.8c-1.7-3.4-5-5.1-10-5.1c-8.8 0-13.2 5.2-13.2 15.7c0 5.3 1.1 9.4 3.2 12.6c3.1 3.5 7 6.2 11.4 7.8l11.1 4.9c11.5 5.3 19.7 11.7 24.8 19.4c5.1 7.7 7.6 18 7.6 31c0 15.5-4.1 27.4-12.3 35.7s-19.5 12.5-34.1 12.5s-25.6-4.2-33.4-12.7zm-105.6 1.1c-8.4-7.7-12.5-19.2-12.5-34.5l0-75.4c0-15.2 4.4-26.7 13.2-34.6c8.9-7.8 20.7-11.8 35.2-11.8c14.1 0 25.2 4 33.4 12c8.3 8 12.5 20 12.5 35.9l0 6-33.1 0 0-5.8c0-6.1-1.3-10.7-4-13.6c-1.1-1.5-2.6-2.7-4.3-3.5s-3.5-1.2-5.4-1.1c-5.4 0-9.2 1.8-11.4 5.6c-2.3 5.2-3.3 10.8-3 16.4l0 65.5c0 13.7 4.8 20.6 14.4 20.8c4.5 0 7.9-1.6 10.2-4.8c2.5-4.1 3.7-8.8 3.5-13.6l0-4.9 33.1 0 0 5.1c0 10.6-2.1 19.5-6.2 26.6c-4 6.9-9.9 12.5-17.1 16c-7.7 3.7-16.1 5.5-24.6 5.3c-14.2 0-25.5-3.9-33.8-11.6z"]
  };
  var faHashnode = {
    prefix: 'fab',
    iconName: 'hashnode',
    icon: [512, 512, [], "e499", "M35.7 171.1c-46.9 46-46.9 122.9 0 169.8L171.6 476.8c46 46.9 122.9 46.9 169.8 0L477.3 340.9c46.9-46.9 46.9-123.8 0-169.8L341.4 35.2c-46.9-46.9-123.8-46.9-169.8 0L35.7 171.1zM196 196.5a84.5 84.5 0 1 1 120 119 84.5 84.5 0 1 1 -120-119z"]
  };
  var faRedditAlien = {
    prefix: 'fab',
    iconName: 'reddit-alien',
    icon: [512, 512, [], "f281", "M373 138.6c-25.2 0-46.3-17.5-51.9-41-30.6 4.3-54.2 30.7-54.2 62.4l0 .2c47.4 1.8 90.6 15.1 124.9 36.3 12.6-9.7 28.4-15.5 45.5-15.5 41.3 0 74.7 33.4 74.7 74.7 0 29.8-17.4 55.5-42.7 67.5-2.4 86.8-97 156.6-213.2 156.6S45.5 410.1 43 323.4c-25.4-11.9-43-37.7-43-67.7 0-41.3 33.4-74.7 74.7-74.7 17.2 0 33 5.8 45.7 15.6 34-21.1 76.8-34.4 123.7-36.4l0-.3c0-44.3 33.7-80.9 76.8-85.5 4.9-24.2 26.3-42.4 52.1-42.4 29.4 0 53.3 23.9 53.3 53.3s-23.9 53.3-53.3 53.3zM157.5 255.3c-20.9 0-38.9 20.8-40.2 47.9s17.1 38.1 38 38.1 36.6-9.8 37.8-36.9-14.7-49.1-35.7-49.1l.1 0zM395 303.1c-1.2-27.1-19.2-47.9-40.2-47.9s-36.9 22-35.7 49.1 16.9 36.9 37.8 36.9 39.3-11 38-38.1l.1 0zm-60.1 70.8c1.5-3.6-1-7.7-4.9-8.1-23-2.3-47.9-3.6-73.8-3.6s-50.8 1.3-73.8 3.6c-3.9 .4-6.4 4.5-4.9 8.1 12.9 30.8 43.3 52.4 78.7 52.4s65.8-21.6 78.7-52.4z"]
  };
  var faTiktok = {
    prefix: 'fab',
    iconName: 'tiktok',
    icon: [448, 512, [], "e07b", "M448.5 209.9c-44 .1-87-13.6-122.8-39.2l0 178.7c0 33.1-10.1 65.4-29 92.6s-45.6 48-76.6 59.6-64.8 13.5-96.9 5.3-60.9-25.9-82.7-50.8-35.3-56-39-88.9 2.9-66.1 18.6-95.2 40-52.7 69.6-67.7 62.9-20.5 95.7-16l0 89.9c-15-4.7-31.1-4.6-46 .4s-27.9 14.6-37 27.3-14 28.1-13.9 43.9 5.2 31 14.5 43.7 22.4 22.1 37.4 26.9 31.1 4.8 46-.1 28-14.4 37.2-27.1 14.2-28.1 14.2-43.8l0-349.4 88 0c-.1 7.4 .6 14.9 1.9 22.2 3.1 16.3 9.4 31.9 18.7 45.7s21.3 25.6 35.2 34.6c19.9 13.1 43.2 20.1 67 20.1l0 87.4z"]
  };
  var faWordpress = {
    prefix: 'fab',
    iconName: 'wordpress',
    icon: [512, 512, [], "f19a", "M61.7 169.4l101.5 278c-71-34.4-119.9-107.2-119.9-191.4 0-30.9 6.6-60.1 18.4-86.6zm337.9 75.9c0-26.3-9.4-44.5-17.5-58.7-10.8-17.5-20.9-32.4-20.9-49.9 0-19.6 14.8-37.8 35.7-37.8 .9 0 1.8 .1 2.8 .2-37.9-34.7-88.3-55.9-143.7-55.9-74.3 0-139.7 38.1-177.8 95.9 5 .2 9.7 .3 13.7 .3 22.2 0 56.7-2.7 56.7-2.7 11.5-.7 12.8 16.2 1.4 17.5 0 0-11.5 1.3-24.3 2l77.5 230.4 46.6-139.6-33.1-90.8c-11.5-.7-22.3-2-22.3-2-11.5-.7-10.1-18.2 1.3-17.5 0 0 35.1 2.7 56 2.7 22.2 0 56.7-2.7 56.7-2.7 11.5-.7 12.8 16.2 1.4 17.5 0 0-11.5 1.3-24.3 2l76.9 228.7 21.2-70.9c9-29.4 16-50.5 16-68.7zM259.7 274.6L195.9 460.1c19.1 5.6 39.2 8.7 60.1 8.7 24.8 0 48.5-4.3 70.6-12.1-.6-.9-1.1-1.9-1.5-2.9L259.7 274.6zm183-120.7c.9 6.8 1.4 14 1.4 21.9 0 21.6-4 45.8-16.2 76.2l-65 187.9c63.3-36.9 105.8-105.4 105.8-183.9 0-37-9.4-71.8-26-102.1zM8 256a248 248 0 1 1 496 0 248 248 0 1 1 -496 0zm484.6 0a236.6 236.6 0 1 0 -473.2 0 236.6 236.6 0 1 0 473.2 0z"]
  };
  var faIdeal = {
    prefix: 'fab',
    iconName: 'ideal',
    icon: [512, 512, [], "e013", "M93.8 165.5a49.1 49.1 0 1 0 0 98.1 49.1 49.1 0 1 0 0-98.1zM54.3 425.8l78.9 0 0-140.5-78.9 0 0 140.5zM205.8 214.2c0-20-10-22.5-18.7-22.5l-14 0 0 45.8 14 0c9.7 0 18.7-2.8 18.7-23.3zm201.7 46l0-91.3 22.8 0 0 68.6 33.7 0C454.6 113.1 356.8 86.2 267.8 86.2l-94.8 0 0 82.8 14 0c25.6 0 41.5 17.4 41.5 45.3 0 28.8-15.5 46-41.5 46l-14 0 0 165.6 94.8 0c144.6 0 194.9-67.2 196.7-165.6l-57.1 0zm-109.8 0l-56.2 0 0-91.2 54.4 0 0 22.7-31.7 0 0 10.6 30 0 0 22.7-30 0 0 12.5 33.5 0 0 22.7zm74.7 0l-5.2-17.7-29.7 0-5.2 17.7-23.7 0 27.5-91.3 32.3 0 27.5 91.3-23.7 0zM267.8 32L.1 32 .1 480 267.8 480c161.8 0 251-79.7 251-224.5 0-83.5-32.6-223.5-251-223.5zm0 426.9l-246.6 0 0-405.9 246.6 0c142.1 0 229.9 64.6 229.9 202.4 0 134.1-81 203.4-229.9 203.4zm83.9-264.9l-7.5 25.8 16.4 0-7.5-25.8-1.4 0z"]
  };
  var faPiedPiperPp = {
    prefix: 'fab',
    iconName: 'pied-piper-pp',
    icon: [448, 512, [], "f1a7", "M205.3 174.6c0 21.1-14.2 38.1-31.7 38.1-7.1 0-12.8-1.2-17.2-3.7l0-68c4.4-2.7 10.1-4.2 17.2-4.2 17.5 0 31.7 16.9 31.7 37.8zm52.6 67c-7.1 0-12.8 1.5-17.2 4.2l0 68c4.4 2.5 10.1 3.7 17.2 3.7 17.4 0 31.7-16.9 31.7-37.8 0-21.1-14.3-38.1-31.7-38.1zM448 80l0 352c0 26.5-21.5 48-48 48L48 480c-26.5 0-48-21.5-48-48L0 80C0 53.5 21.5 32 48 32l352 0c26.5 0 48 21.5 48 48zM185 255.1c41 0 74.2-35.6 74.2-79.6S226 95.9 185 95.9c-12 0-24.1 3.2-34.6 8.8l-45.7 0 0 206.3 51.8-10.1 0-50.6c8.6 3.1 18.1 4.8 28.5 4.8zm158.4 25.3c0-44-33.2-79.6-73.9-79.6-3.2 0-6.4 .2-9.6 .7-3.7 12.5-10.1 23.8-19.2 33.4-13.8 15-32.2 23.8-51.8 24.8l0 156.3 51.8-10.1 0-50.6c8.6 3.2 18.2 4.7 28.7 4.7 40.8 0 74-35.6 74-79.6z"]
  };
  var faUssunnah = {
    prefix: 'fab',
    iconName: 'ussunnah',
    icon: [512, 512, [], "f407", "M496.9 268.1c0 63.9-25.4 125.2-70.6 170.3S319.9 509 256 509 130.8 483.5 85.7 438.4 15.1 331.9 15.1 268c0-63.9 25.4-125.2 70.6-170.4S192.2 27.1 256.1 27.1 381.3 52.4 426.5 97.6 497 204.1 497 268l-.1 .1zM39.5 268c-.6 28.8 4.5 57.5 15.1 84.3s26.4 51.2 46.6 71.8 44.2 37 70.8 48.1 55.1 16.9 83.9 16.9 57.4-5.8 83.9-16.9 50.6-27.5 70.8-48.1 36-45 46.6-71.8 15.7-55.5 15.1-84.3c.6-28.8-4.5-57.5-15.1-84.3s-26.4-51.2-46.6-71.8-44.2-37-70.8-48.1-55.1-16.9-83.9-16.9-57.4 5.8-83.9 16.9-50.6 27.5-70.8 48.1-36 45-46.6 71.8-15.7 55.5-15.1 84.3zm385.9 63.3c-12.7 0-21.6-1.9-26.7-5.9-5.5-4.3-8.2-12.3-8.2-23.8l0-96.5c0-6.5-5.2-20.2-15.7-41.2 7 0 17-9.1 30-27.2l0 147.8c0 11 2.4 19.4 7 25.3 3.7 4.7 10.1 8.9 19 12.6 1.2 .4 2.6 .9 4.1 1.4 2.9 .9 6.3 2.1 10.3 3.5-1.8 2.7-8.3 4-19.9 4l.1 0zm-219 0c-1.3 2.4-3.6 5.5-6.8 9.4l-18.5 22.5c-1-6.1-4-13-9.3-20.6s-9.7-11.4-13.4-11.4l-89.8 0c3.3-5.3 4.9-8.8 4.9-10.8s-.8-5.3-2.4-9.7c-1.5-4.4-2.4-8.5-2.4-12.4 0-7.4 2.1-13.9 6.3-19.3l20-25.6-7.1-17.7 16.1-19.8 6.7 16.8 8-10.3c-1.8 6.4-2.6 12.3-2.6 17.7 0 4.2 2.8 13.3 8.3 27.3l16.2 40.7 17.7 0c2.8 .4 7.7 5 14.6 13.9 1.8 2.4 4.3 5.8 7.7 10.2 1.4 1.9 2.9 3.9 4.6 6.1 1.3-2.3 2-4.6 2-7.1 0-2-1.3-6.6-4-13.4L178 304.1c-4-10.6-6.1-17.7-6.1-21.3 0-6.3 1.9-12.3 5.8-17.9 .5-.6 1-1.3 1.5-1.9 4.4-5.6 8.8-11.1 13.3-16.5-1.1 4.6-1.7 8.7-1.7 12 0 3.7 1.7 9.9 5.1 18.8l7.9 20.4c1.9 4.7 3 8.2 3.7 10.3l25.9 0-.9-2.6c-1.4-3.9-4-7-7.7-9.3l15.6-20.1 12.3 32 13.4 0-6.1-15.8c-1.5-3.9-4-7-7.7-9.3l15.7-20.1 17.3 45.2 13.4 0-11.4-29.4c-1.5-3.9-4-7-7.7-9.3l15.6-20 22.4 58.7 26.2 0c1.5 0 3-1.1 4.5-3.1s2.2-4.1 2.2-6.3l0-93.5c0-6.5-4.5-20.3-13.7-41.2 5.4 0 14.1-9.1 26.2-27.2l0 163.5c0 7.2 .6 12 1.7 14.6 1.6 3.4 5.3 6.2 11.1 8.2-3.9 5.6-8.7 8.5-14.5 8.5l-154.8 0-.1-.2zm-98-44c-2.7-6.7-4-11.7-4-15-.6 1.2-2.4 3.7-5.4 7.6-1.4 1.9-2.2 3.7-2.2 5.3 0 2.6 .8 5.7 2.2 9.3l5.6 13.9c5 0 9 0 11.9-.1l-8.2-20.9 .1-.1zm13.5-72.4c-3-5.2-7-9.3-11.9-11.9-3.5-1.9-5.3-4.3-5.3-7.4 0-2.4 4.6-8.6 14-18.3 .2 3.8 1.9 7.6 4.9 11.2 3.1 3.6 4.6 7 4.6 10.1 0 2.6-2.1 8-6.2 16.3l-.1 0zm-27.6 0c-3-5.2-7-9.3-11.9-11.9-3.5-1.9-5.3-4.3-5.3-7.4 0-2.4 4.6-8.6 14-18.3 .2 3.8 1.9 7.6 4.9 11.2 3.1 3.6 4.6 7 4.6 10.1 0 2.6-2.1 8-6.2 16.3l-.1 0zm87 27.5c-3-5.2-7-9.3-11.9-11.9-3.5-1.9-5.3-4.3-5.3-7.4 0-2.4 4.6-8.6 14-18.3 .2 3.8 1.9 7.6 4.9 11.2 3.1 3.6 4.6 7 4.6 10.1 0 2.6-2.1 8-6.2 16.3l-.1 0z"]
  };
  var faFortAwesomeAlt = {
    prefix: 'fab',
    iconName: 'fort-awesome-alt',
    icon: [512, 512, [], "f3a3", "M208 237.4l-22.2 0c-2.1 0-3.7 1.6-3.7 3.7l0 51.7c0 2.1 1.6 3.7 3.7 3.7l22.2 0c2.1 0 3.7-1.6 3.7-3.7l0-51.7c0-2.1-1.6-3.7-3.7-3.7zm118.2 0l-22.2 0c-2.1 0-3.7 1.6-3.7 3.7l0 51.7c0 2.1 1.6 3.7 3.7 3.7l22.2 0c2.1 0 3.7-1.6 3.7-3.7l0-51.7c-.1-2.1-1.7-3.7-3.7-3.7zm132-125.1c-2.3-3.2-4.6-6.4-7.1-9.5-9.8-12.5-20.8-24-32.8-34.4-4.5-3.9-9.1-7.6-13.9-11.2-1.6-1.2-3.2-2.3-4.8-3.5-27.6-19.6-59.3-33.7-93.6-40.7-16.2-3.3-32.9-5-50-5s-33.9 1.7-50 5c-34.3 7.1-66 21.2-93.3 40.8-1.6 1.1-3.2 2.3-4.8 3.5-4.8 3.6-9.4 7.3-13.9 11.2-3 2.6-5.9 5.3-8.8 8s-5.7 5.5-8.4 8.4c-5.5 5.7-10.7 11.8-15.6 18-2.4 3.1-4.8 6.3-7.1 9.5-28.9 40.6-45.8 90.1-45.8 143.6 0 2 .1 4 .1 6 .1 .7 .1 1.3 .1 2 .1 1.3 .1 2.7 .2 4 0 .8 .1 1.5 .1 2.3 0 1.3 .1 2.5 .2 3.7 .1 .8 .1 1.6 .2 2.4 .1 1.1 .2 2.3 .3 3.5 0 .8 .1 1.6 .2 2.4 .1 1.2 .3 2.4 .4 3.6 .1 .8 .2 1.5 .3 2.3 .1 1.3 .3 2.6 .5 3.9 .1 .6 .2 1.3 .3 1.9l.9 5.7c.1 .6 .2 1.1 .3 1.7 .3 1.3 .5 2.7 .8 4 .2 .8 .3 1.6 .5 2.4 .2 1 .5 2.1 .7 3.2 .2 .9 .4 1.7 .6 2.6 .2 1 .4 2 .7 3 .2 .9 .5 1.8 .7 2.7 .3 1 .5 1.9 .8 2.9 .3 .9 .5 1.8 .8 2.7 .2 .9 .5 1.9 .8 2.8s.5 1.8 .8 2.7c.3 1 .6 1.9 .9 2.8 .6 1.6 1.1 3.3 1.7 4.9 .4 1 .7 1.9 1 2.8 .3 1 .7 2 1.1 3 .3 .8 .6 1.5 .9 2.3l1.2 3c.3 .7 .6 1.5 .9 2.2 .4 1 .9 2 1.3 3l.9 2.1c.5 1 .9 2 1.4 3 .3 .7 .6 1.3 .9 2 .5 1 1 2.1 1.5 3.1 .2 .6 .5 1.1 .8 1.7 .6 1.1 1.1 2.2 1.7 3.3 .1 .2 .2 .3 .3 .5 2.2 4.1 4.4 8.2 6.8 12.2 .2 .4 .5 .8 .7 1.2 .7 1.1 1.3 2.2 2 3.3 .3 .5 .6 .9 .9 1.4 .6 1.1 1.3 2.1 2 3.2 .3 .5 .6 .9 .9 1.4 .7 1.1 1.4 2.1 2.1 3.2 .2 .4 .5 .8 .8 1.2 .7 1.1 1.5 2.2 2.3 3.3 .2 .2 .3 .5 .5 .7 37.5 51.7 94.4 88.5 160 99.4 .9 .1 1.7 .3 2.6 .4 1 .2 2.1 .4 3.1 .5s1.9 .3 2.8 .4c1 .2 2 .3 3 .4 .9 .1 1.9 .2 2.9 .3s1.9 .2 2.9 .3 2.1 .2 3.1 .3c.9 .1 1.8 .1 2.7 .2 1.1 .1 2.3 .1 3.4 .2 .8 0 1.7 .1 2.5 .1 1.3 0 2.6 .1 3.9 .1 .7 .1 1.4 .1 2.1 .1 2 .1 4 .1 6 .1s4-.1 6-.1c.7 0 1.4-.1 2.1-.1 1.3 0 2.6 0 3.9-.1 .8 0 1.7-.1 2.5-.1 1.1-.1 2.3-.1 3.4-.2 .9 0 1.8-.1 2.7-.2 1-.1 2.1-.2 3.1-.3s1.9-.2 2.9-.3c.9-.1 1.9-.2 2.9-.3s2-.3 3-.4 1.9-.3 2.8-.4c1-.2 2.1-.3 3.1-.5 .9-.1 1.7-.3 2.6-.4 65.6-11 122.5-47.7 160.1-102.4 .2-.2 .3-.5 .5-.7 .8-1.1 1.5-2.2 2.3-3.3 .2-.4 .5-.8 .8-1.2 .7-1.1 1.4-2.1 2.1-3.2 .3-.5 .6-.9 .9-1.4 .6-1.1 1.3-2.1 2-3.2 .3-.5 .6-.9 .9-1.4 .7-1.1 1.3-2.2 2-3.3 .2-.4 .5-.8 .7-1.2 2.4-4 4.6-8.1 6.8-12.2 .1-.2 .2-.3 .3-.5 .6-1.1 1.1-2.2 1.7-3.3 .2-.6 .5-1.1 .8-1.7 .5-1 1-2.1 1.5-3.1 .3-.7 .6-1.3 .9-2 .5-1 1-2 1.4-3l.9-2.1c.5-1 .9-2 1.3-3 .3-.7 .6-1.5 .9-2.2l1.2-3c.3-.8 .6-1.5 .9-2.3 .4-1 .7-2 1.1-3s.7-1.9 1-2.8c.6-1.6 1.2-3.3 1.7-4.9 .3-1 .6-1.9 .9-2.8s.5-1.8 .8-2.7c.2-.9 .5-1.9 .8-2.8s.6-1.8 .8-2.7c.3-1 .5-1.9 .8-2.9 .2-.9 .5-1.8 .7-2.7 .2-1 .5-2 .7-3 .2-.9 .4-1.7 .6-2.6 .2-1 .5-2.1 .7-3.2 .2-.8 .3-1.6 .5-2.4 .3-1.3 .6-2.7 .8-4 .1-.6 .2-1.1 .3-1.7l.9-5.7c.1-.6 .2-1.3 .3-1.9 .1-1.3 .3-2.6 .5-3.9 .1-.8 .2-1.5 .3-2.3 .1-1.2 .3-2.4 .4-3.6 0-.8 .1-1.6 .2-2.4 .1-1.1 .2-2.3 .3-3.5 .1-.8 .1-1.6 .2-2.4 .1 1.7 .1 .5 .2-.7 0-.8 .1-1.5 .1-2.3 .1-1.3 .2-2.7 .2-4 .1-.7 .1-1.3 .1-2 .1-2 .1-4 .1-6 0-53.5-16.9-103-45.8-143.7zM448 371.5c-9.4 15.5-20.6 29.9-33.6 42.9-20.6 20.6-44.5 36.7-71.2 48-13.9 5.8-28.2 10.3-42.9 13.2l0-75.8c0-58.6-88.6-58.6-88.6 0l0 75.8c-14.7-2.9-29-7.3-42.9-13.2-26.7-11.3-50.6-27.4-71.2-48-13-13-24.2-27.4-33.6-42.9l0-71.3c0-2.1 1.6-3.7 3.7-3.7l22.1 0c2.1 0 3.7 1.6 3.7 3.7l0 25.8 29.6 0 0-144c0-2.1 1.6-3.7 3.7-3.7l22.1 0c2.1 0 3.7 1.6 3.7 3.7l0 25.9 29.5 0 0-25.9c0-2.1 1.6-3.7 3.7-3.7l22.2 0c2.1 0 3.7 1.6 3.7 3.7l0 25.9 29.5 0 0-25.9c0-4.8 6.5-3.7 9.5-3.7l0-90.2c-4.4-2-7.4-6.7-7.4-11.5 0-16.8 25.4-16.8 25.4 0 0 4.8-3 9.4-7.4 11.5l0 3.9c6.3-1.4 12.7-2.3 19.2-2.3 9.4 0 18.4 3.5 26.3 3.5 7.2 0 15.2-3.5 19.4-3.5 2.1 0 3.7 1.6 3.7 3.7l0 48.4c0 5.6-18.7 6.5-22.4 6.5-8.6 0-16.6-3.5-25.4-3.5-7 0-14.1 1.2-20.8 2.8l0 30.7c3 0 9.5-1.1 9.5 3.7l0 25.9 29.5 0 0-25.9c0-2.1 1.6-3.7 3.7-3.7l22.2 0c2.1 0 3.7 1.6 3.7 3.7l0 25.9 29.5 0 0-25.9c0-2.1 1.6-3.7 3.7-3.7l22.1 0c2.1 0 3.7 1.6 3.7 3.7l0 144 29.5 0 0-25.8c0-2.1 1.6-3.7 3.7-3.7l22.2 0c2.1 0 3.7 1.6 3.7 3.7l0 71.3z"]
  };
  var faBuromobelexperte = {
    prefix: 'fab',
    iconName: 'buromobelexperte',
    icon: [448, 512, [], "f37f", "M0 32l0 128 128 0 0-128-128 0zM120 152l-112 0 0-112 112 0 0 112zM160 32l0 128 128 0 0-128-128 0zM280 152l-112 0 0-112 112 0 0 112zM320 32l0 128 128 0 0-128-128 0zM440 152l-112 0 0-112 112 0 0 112zM0 192l0 128 128 0 0-128-128 0zM120 312l-112 0 0-112 112 0 0 112zm40-120l0 128 128 0 0-128-128 0zM280 312l-112 0 0-112 112 0 0 112zm40-120l0 128 128 0 0-128-128 0zM440 312l-112 0 0-112 112 0 0 112zM0 352l0 128 128 0 0-128-128 0zM120 472l-112 0 0-112 112 0 0 112zm40-120l0 128 128 0 0-128-128 0zM280 472l-112 0 0-112 112 0 0 112zm40-120l0 128 128 0 0-128-128 0z"]
  };
  var faBilibili = {
    prefix: 'fab',
    iconName: 'bilibili',
    icon: [512, 512, [], "e3d9", "M488.6 104.1c16.7 18.1 24.4 39.7 23.3 65.7l0 202.4c-.4 26.4-9.2 48.1-26.5 65.1-17.2 17-39.1 25.9-65.5 26.7L92 464c-26.4-.8-48.2-9.8-65.3-27.2-17.1-17.4-26-40.3-26.7-68.6L0 169.8c.8-26 9.7-47.6 26.7-65.7 17.1-16.3 38.8-25.3 65.3-26.1l29.4 0-25.4-25.8c-5.7-5.7-8.6-13-8.6-21.8s2.9-16.1 8.6-21.8 13-8.6 21.9-8.6 16.1 2.9 21.9 8.6l73.3 69.4 88 0 74.5-69.4C381.7 2.9 389.2 0 398 0s16.1 2.9 21.9 8.6c5.7 5.7 8.6 13 8.6 21.8s-2.9 16.1-8.6 21.8L394.6 78 423.9 78c26.4 .8 48 9.8 64.7 26.1zm-38.8 69.7c-.4-9.6-3.7-17.4-10.7-23.5-5.2-6.1-14-9.4-22.7-9.8l-320.4 0c-9.6 .4-17.4 3.7-23.6 9.8-6.1 6.1-9.4 13.9-9.8 23.5l0 194.4c0 9.2 3.3 17 9.8 23.5s14.4 9.8 23.6 9.8l320.4 0c9.2 0 17-3.3 23.3-9.8s9.7-14.3 10.1-23.5l0-194.4zM185.5 216.5c6.3 6.3 9.7 14.1 10.1 23.2l0 33.3c-.4 9.2-3.7 16.9-9.8 23.2-6.2 6.3-14 9.5-23.6 9.5s-17.5-3.2-23.6-9.5-9.4-14-9.8-23.2l0-33.3c.4-9.1 3.8-16.9 10.1-23.2s13.2-9.6 23.3-10c9.2 .4 17 3.7 23.3 10zm191.5 0c6.3 6.3 9.7 14.1 10.1 23.2l0 33.3c-.4 9.2-3.7 16.9-9.8 23.2s-14 9.5-23.6 9.5-17.4-3.2-23.6-9.5c-7-6.3-9.4-14-9.7-23.2l0-33.3c.3-9.1 3.7-16.9 10-23.2s14.1-9.6 23.3-10c9.2 .4 17 3.7 23.3 10z"]
  };
  var faNeos = {
    prefix: 'fab',
    iconName: 'neos',
    icon: [448, 512, [], "f612", "M383.8 512l-95.1 0-108.2-154.5 0 91.1-86.4 63.4-97.7 0 0-482.2 40.5-29.8 108 0 123.7 176.1 0-112.7 86.4-63.4 97.7 0 0 461.5-68.9 50.5zM7.2 35.3l0 460.7 72-52.9 0-249.1 215.5 307.6 84.8 0 52.4-38.2-78.3 0-316.1-450.5-30.2 22.3zM89.7 501.9l80-58.8 0-101-79.8-114.4 0 220.9-72.6 53.3 72.3 0 0 0zM49 10.8l310.6 442.6 82.4 0 0-442.6-79.8 0 0 317.6-222.9-317.6-90.3 0zM279.4 191.6l72 102.8 0-278.5-72 53 0 122.7z"]
  };
  var faDev = {
    prefix: 'fab',
    iconName: 'dev',
    icon: [448, 512, [], "f6cc", "M120.1 208.3c-3.9-2.9-7.8-4.3-11.6-4.3l-17.4 0 0 104.5 17.4 0c3.9 0 7.8-1.4 11.6-4.3s5.8-7.3 5.8-13.1l0-69.7c0-5.8-2-10.2-5.8-13.1zM404.1 32L43.9 32C19.7 32 .1 51.6 0 75.8L0 436.2C.1 460.4 19.7 480 43.9 480l360.2 0c24.2 0 43.8-19.6 43.9-43.8l0-360.4C447.9 51.6 428.3 32 404.1 32zM154.2 291.2c0 18.8-11.6 47.3-48.4 47.3l-46.4 0 0-165.5 47.4 0c35.4 0 47.4 28.5 47.4 47.3l0 70.9zm100.7-88.7l-53.3 0 0 38.4 32.6 0 0 29.6-32.6 0 0 38.4 53.3 0 0 29.6-62.2 0c-11.2 .3-20.4-8.5-20.7-19.7l0-125.1c-.3-11.1 8.6-20.4 19.7-20.7l63.2 0 0 29.5zM358.5 317.8c-13.2 30.7-36.8 24.6-47.4 0l-38.5-144.8 32.6 0 29.7 113.7 29.6-113.7 32.6 0-38.5 144.8z"]
  };
  var faHotjar = {
    prefix: 'fab',
    iconName: 'hotjar',
    icon: [512, 512, [], "f3b1", "M361.8 0c0 131.6-80.7 176.8-140.2 209.4-.6 .3-1.1 .6-1.6 .9-53.8 30.2-88.7 49.8-89.6 122l-98.1 0c0-131.5 80.7-176.7 140.2-209.3 54.8-29.8 90.3-50 90.3-123l99 0zM301.3 302.6c54.8-29.8 90.3-50 90.3-123l98 0c0 131.6-80.7 176.7-140.2 209.4-54.8 29.8-90.3 50-90.3 123l-98 0c0-131.6 80.7-176.8 140.2-209.4z"]
  };
  var faDochub = {
    prefix: 'fab',
    iconName: 'dochub',
    icon: [448, 512, [], "f394", "M413.9 160L272 160 272 19.6 413.9 160zM320 192l0 130c0 66.8-36.5 100.1-113.3 100.1l-94.7 0 0-337.3 94.7 0c12 0 23.1 .8 33.1 2.5l0-84C228.9 1.1 217.4 0 205.2 0L16 0 16 512 205.2 512C345.7 512 416 447.4 416 318.1l0-126.1-96 0z"]
  };
  var faVimeo = {
    prefix: 'fab',
    iconName: 'vimeo',
    icon: [448, 512, [], "f40a", "M403.2 32L44.8 32C20.1 32 0 52.1 0 76.8L0 435.2C0 459.9 20.1 480 44.8 480l358.4 0c24.7 0 44.8-20.1 44.8-44.8l0-358.4C448 52.1 427.9 32 403.2 32zM377 180.8c-1.4 31.5-23.4 74.7-66 129.4-44 57.2-81.3 85.8-111.7 85.8-18.9 0-34.8-17.4-47.9-52.3-25.5-93.3-36.4-148-57.4-148-2.4 0-10.9 5.1-25.4 15.2L53.4 191.3c37.3-32.8 72.9-69.2 95.2-71.2 25.2-2.4 40.7 14.8 46.5 51.7 20.7 131.2 29.9 151 67.6 91.6 13.5-21.4 20.8-37.7 21.8-48.9 3.5-33.2-25.9-30.9-45.8-22.4 15.9-52.1 46.3-77.4 91.2-76 33.3 .9 49 22.5 47.1 64.7z"]
  };
  var faMaxcdn = {
    prefix: 'fab',
    iconName: 'maxcdn',
    icon: [512, 512, [], "f136", "M461.1 442.7l-97.4 0 51.9-242.7c2.3-10.2 .9-19.5-4.4-25.7-5-6.1-13.7-9.6-24.2-9.6l-49.3 0-59.5 278-97.4 0 59.5-278-83.4 0-59.5 278-97.4 0 59.5-278-44.6-95.4 372.1 0c39.4 0 75.3 16.3 98.3 44.9 23.3 28.6 31.8 67.4 23.6 105.9L461.1 442.7z"]
  };
  var faSquareFontAwesomeStroke = {
    prefix: 'fab',
    iconName: 'square-font-awesome-stroke',
    icon: [448, 512, ["font-awesome-alt"], "f35c", "M64 64C46.3 64 32 78.3 32 96l0 320c0 17.7 14.3 32 32 32l320 0c17.7 0 32-14.3 32-32l0-320c0-17.7-14.3-32-32-32L64 64zM0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zm154 58c0 9.3-4.8 17.4-12.1 22l188.9 0c7.3 0 13.2 5.9 13.2 13.2 0 1.8-.4 3.7-1.1 5.4L312 264 342.9 333.4c.8 1.7 1.1 3.5 1.1 5.4 0 7.3-5.9 13.2-13.2 13.2l-186.8 0 0 32-32 0 0-209.5c-6.1-4.8-10-12.2-10-20.5 0-14.4 11.6-26 26-26s26 11.6 26 26z"]
  };
  var faFontAwesomeAlt = faSquareFontAwesomeStroke;
  var faSpeakap = {
    prefix: 'fab',
    iconName: 'speakap',
    icon: [448, 512, [], "f3f3", "M64.4 391.8C-15 303.6-7.6 167.4 81.1 87.6s224.8-73 304.2 15.2 72 224.4-16.6 304.1c-18.7 16.9 64 43.1 42 52.3-82.1 34.2-253.9 35-346.2-67.5l0 0zM277.7 180.2l38.5-40.9c-9.6-8.9-32-26.8-76.2-27.6-52.3-.9-95.9 28.3-96.8 80-.2 11.3 .3 36.7 29.4 54.8 34.5 21.4 86.5 21.5 86 52.3-.4 21.3-26.4 25.8-38.6 25.6-3 0-30.2-.5-47.6-24.6l-40 42.6c28.2 27 59 32.6 83.5 33 10.2 .2 96.4 .3 97.8-81 .3-15.8-2.1-39.7-28.9-56.6-34.4-21.6-85-19.4-84.4-49.7 .4-23.3 31-25.4 37.5-25.3 .4 0 26.6 .3 39.6 17.4l0 0z"]
  };
  var faFantasyFlightGames = {
    prefix: 'fab',
    iconName: 'fantasy-flight-games',
    icon: [512, 512, [], "f6dc", "M256 32.9L32.9 256 256 479.1 479.1 256 256 32.9zM88.3 255.8c2-2 11.9-12.3 96.5-97.5 41.4-41.8 86.2-43.8 119.8-18.7 24.6 18.4 62.1 58.9 62.1 59 .7 .7 1.1 2.9 .6 3.4-11.3 11.8-22.7 23.5-33.5 34.7-34.2-32.3-40.5-38.2-48.5-44-17.8-12.7-41.4-10.1-57 5.1-2.2 2.1-1.8 3.4 .1 5.4 2.9 2.9 28.1 28.3 35.1 35.8-11.9 11.6-23.7 23-35.7 34.7-12-12.5-24.5-25.5-36.5-38.1-21.4 21.1-41.7 41.1-61.8 61L88.3 255.8zM323.2 357.4c-35.5 35.4-78.1 38.1-107 20.5-22.1-13.5-39.4-32.1-72.9-66.8 12-12.4 23.8-24.4 35.4-36.3 33 31.9 37.1 36 44.7 42.1 18.5 14.7 42.5 13.7 59.3-1.8 3.7-3.4 3.7-3.6 .1-7.2-10.6-10.7-21.2-21.4-31.8-32.2-1.3-1.3-3-2.5-.8-4.7 10.8-10.7 21.5-21.5 32.2-32.3 .3-.3 .6-.4 1.9-1.1 12.4 12.9 24.9 25.9 37.2 38.8 21-20.7 41.2-40.7 61.3-60.4 13.7 13.4 27.1 26.6 40.9 40-20.2 20.9-81.7 82.7-100.5 101.5zM256 0L0 256 256 512 512 256 256 0zM16 256L256 16 496 256 256 496 16 256z"]
  };
  var faLinux = {
    prefix: 'fab',
    iconName: 'linux',
    icon: [448, 512, [], "f17c", "M220.9 123.3c1 .5 1.8 1.7 3 1.7 1.1 0 2.8-.4 2.9-1.5 .2-1.4-1.9-2.3-3.2-2.9-1.7-.7-3.9-1-5.5-.1-.4 .2-.8 .7-.6 1.1 .3 1.3 2.3 1.1 3.4 1.7zM199 125c1.2 0 2-1.2 3-1.7 1.1-.6 3.1-.4 3.5-1.6 .2-.4-.2-.9-.6-1.1-1.6-.9-3.8-.6-5.5 .1-1.3 .6-3.4 1.5-3.2 2.9 .1 1 1.8 1.5 2.8 1.4zM420 403.8c-3.6-4-5.3-11.6-7.2-19.7-1.8-8.1-3.9-16.8-10.5-22.4-1.3-1.1-2.6-2.1-4-2.9-1.3-.8-2.7-1.5-4.1-2 9.2-27.3 5.6-54.5-3.7-79.1-11.4-30.1-31.3-56.4-46.5-74.4-17.1-21.5-33.7-41.9-33.4-72 .5-45.9 5.1-131.2-75.8-131.3-102.4-.2-76.8 103.4-77.9 135.2-1.7 23.4-6.4 41.8-22.5 64.7-18.9 22.5-45.5 58.8-58.1 96.7-6 17.9-8.8 36.1-6.2 53.3-6.5 5.8-11.4 14.7-16.6 20.2-4.2 4.3-10.3 5.9-17 8.3s-14 6-18.5 14.5c-2.1 3.9-2.8 8.1-2.8 12.4 0 3.9 .6 7.9 1.2 11.8 1.2 8.1 2.5 15.7 .8 20.8-5.2 14.4-5.9 24.4-2.2 31.7 3.8 7.3 11.4 10.5 20.1 12.3 17.3 3.6 40.8 2.7 59.3 12.5 19.8 10.4 39.9 14.1 55.9 10.4 11.6-2.6 21.1-9.6 25.9-20.2 12.5-.1 26.3-5.4 48.3-6.6 14.9-1.2 33.6 5.3 55.1 4.1 .6 2.3 1.4 4.6 2.5 6.7l0 .1c8.3 16.7 23.8 24.3 40.3 23 16.6-1.3 34.1-11 48.3-27.9 13.6-16.4 36-23.2 50.9-32.2 7.4-4.5 13.4-10.1 13.9-18.3 .4-8.2-4.4-17.3-15.5-29.7zM223.8 87.3c9.8-22.2 34.2-21.8 44-.4 6.5 14.2 3.6 30.9-4.3 40.4-1.6-.8-5.9-2.6-12.6-4.9 1.1-1.2 3.1-2.7 3.9-4.6 4.8-11.8-.2-27-9.1-27.3-7.3-.5-13.9 10.8-11.8 23-4.1-2-9.4-3.5-13-4.4-1-6.9-.3-14.6 2.9-21.8zM183.1 75.8c10.1 0 20.8 14.2 19.1 33.5-3.5 1-7.1 2.5-10.2 4.6 1.2-8.9-3.3-20.1-9.6-19.6-8.4 .7-9.8 21.2-1.8 28.1 1 .8 1.9-.2-5.9 5.5-15.6-14.6-10.5-52.1 8.4-52.1zm-13.6 60.7c6.2-4.6 13.6-10 14.1-10.5 4.7-4.4 13.5-14.2 27.9-14.2 7.1 0 15.6 2.3 25.9 8.9 6.3 4.1 11.3 4.4 22.6 9.3 8.4 3.5 13.7 9.7 10.5 18.2-2.6 7.1-11 14.4-22.7 18.1-11.1 3.6-19.8 16-38.2 14.9-3.9-.2-7-1-9.6-2.1-8-3.5-12.2-10.4-20-15-8.6-4.8-13.2-10.4-14.7-15.3-1.4-4.9 0-9 4.2-12.3zm3.3 334c-2.7 35.1-43.9 34.4-75.3 18-29.9-15.8-68.6-6.5-76.5-21.9-2.4-4.7-2.4-12.7 2.6-26.4l0-.2c2.4-7.6 .6-16-.6-23.9-1.2-7.8-1.8-15 .9-20 3.5-6.7 8.5-9.1 14.8-11.3 10.3-3.7 11.8-3.4 19.6-9.9 5.5-5.7 9.5-12.9 14.3-18 5.1-5.5 10-8.1 17.7-6.9 8.1 1.2 15.1 6.8 21.9 16l19.6 35.6c9.5 19.9 43.1 48.4 41 68.9zm-1.4-25.9c-4.1-6.6-9.6-13.6-14.4-19.6 7.1 0 14.2-2.2 16.7-8.9 2.3-6.2 0-14.9-7.4-24.9-13.5-18.2-38.3-32.5-38.3-32.5-13.5-8.4-21.1-18.7-24.6-29.9s-3-23.3-.3-35.2c5.2-22.9 18.6-45.2 27.2-59.2 2.3-1.7 .8 3.2-8.7 20.8-8.5 16.1-24.4 53.3-2.6 82.4 .6-20.7 5.5-41.8 13.8-61.5 12-27.4 37.3-74.9 39.3-112.7 1.1 .8 4.6 3.2 6.2 4.1 4.6 2.7 8.1 6.7 12.6 10.3 12.4 10 28.5 9.2 42.4 1.2 6.2-3.5 11.2-7.5 15.9-9 9.9-3.1 17.8-8.6 22.3-15 7.7 30.4 25.7 74.3 37.2 95.7 6.1 11.4 18.3 35.5 23.6 64.6 3.3-.1 7 .4 10.9 1.4 13.8-35.7-11.7-74.2-23.3-84.9-4.7-4.6-4.9-6.6-2.6-6.5 12.6 11.2 29.2 33.7 35.2 59 2.8 11.6 3.3 23.7 .4 35.7 16.4 6.8 35.9 17.9 30.7 34.8-2.2-.1-3.2 0-4.2 0 3.2-10.1-3.9-17.6-22.8-26.1-19.6-8.6-36-8.6-38.3 12.5-12.1 4.2-18.3 14.7-21.4 27.3-2.8 11.2-3.6 24.7-4.4 39.9-.5 7.7-3.6 18-6.8 29-32.1 22.9-76.7 32.9-114.3 7.2zm257.4-11.5c-.9 16.8-41.2 19.9-63.2 46.5-13.2 15.7-29.4 24.4-43.6 25.5s-26.5-4.8-33.7-19.3c-4.7-11.1-2.4-23.1 1.1-36.3 3.7-14.2 9.2-28.8 9.9-40.6 .8-15.2 1.7-28.5 4.2-38.7 2.6-10.3 6.6-17.2 13.7-21.1 .3-.2 .7-.3 1-.5 .8 13.2 7.3 26.6 18.8 29.5 12.6 3.3 30.7-7.5 38.4-16.3 9-.3 15.7-.9 22.6 5.1 9.9 8.5 7.1 30.3 17.1 41.6 10.6 11.6 14 19.5 13.7 24.6zM173.4 148.7c2 1.9 4.7 4.5 8 7.1 6.6 5.2 15.8 10.6 27.3 10.6 11.6 0 22.5-5.9 31.8-10.8 4.9-2.6 10.9-7 14.8-10.4s5.9-6.3 3.1-6.6-2.6 2.6-6 5.1c-4.4 3.2-9.7 7.4-13.9 9.8-7.4 4.2-19.5 10.2-29.9 10.2s-18.7-4.8-24.9-9.7c-3.1-2.5-5.7-5-7.7-6.9-1.5-1.4-1.9-4.6-4.3-4.9-1.4-.1-1.8 3.7 1.7 6.5z"]
  };
  var faCottonBureau = {
    prefix: 'fab',
    iconName: 'cotton-bureau',
    icon: [512, 512, [], "f89e", "M474.3 330.4C450.6 422.3 380.1 475 272.4 478.8l0-49.2c0-48 26.4-74.4 74.4-74.4 62 0 99.2-37.2 99.2-99.2 0-61.4-36.5-98.3-97.4-99.1-33-69.3-146.5-64.7-177.2 0-60.9 .8-97.4 37.7-97.4 99.1 0 62.1 37.3 99.4 99.4 99.4 48 0 74.6 26.2 74.6 74.4l0 49.2c-134.4-5-211.1-85.1-211.1-223 0-141.8 81.4-223.2 223.2-223.2 114.8 0 189.8 53.2 214.7 148.8l25.3 0C473.9 71.5 388.2 8 259.8 8 105 8 12 101.2 12 255.8 12 411.1 105.2 504.3 259.8 504 388.1 504 473.7 440.2 499.5 330.4l-25.2 0zM357 182.3c41.4 3.4 64.2 29 64.2 73.7 0 48-26.4 74.4-74.4 74.4-28.6 0-49.3-9.6-61.6-27.3 83.1-16.5 75.6-99.7 71.8-120.7zm-81.7 97.4c-2.5-10.3-16.3-87 56.2-97 2.3 10.1 16.5 87.1-56.3 97l0 0zM260 132c28.6 0 49 9.7 61.4 27.6-28.4 5.5-49.4 20.6-61.6 43.4-12.2-22.9-33.2-38-61.6-43.4 12.4-17.7 33.3-27.4 61.6-27.4l.2-.3zm-71.5 50.7c73.2 10.6 58.9 86.8 56.5 97-72.4-9.8-59-87-56.2-97l-.2 0zM173.2 330.4c-48 0-74.4-26.4-74.4-74.4 0-44.4 22.9-70 64.2-73.7-6.8 37.2-1.4 106.5 71.6 120.7-12.1 17.6-32.8 27.3-61.1 27.3l-.3 0zm53.2 12.4c14.3-7.6 26-19.3 33.6-33.5 7.8 14.5 19.3 25.5 33.8 33.5-14.4 7.6-26.1 19.4-33.6 33.8-8-14.5-19.1-26.2-33.6-33.8l-.3 0z"]
  };
  var faGoogleWallet = {
    prefix: 'fab',
    iconName: 'google-wallet',
    icon: [448, 512, [], "f1ee", "M156.8 126.8c37.6 60.6 64.2 113.1 84.3 162.5-8.3 33.8-18.8 66.5-31.3 98.3-13.2-52.3-26.5-101.3-56-148.5 6.5-36.4 2.3-73.6 3-112.3zM109.3 200l-93.2 0c-6.5 0-10.5 7.5-6.5 12.7 42.2 54.3 71.7 117.8 91.7 187.3l103.5 0c-16.2-69.7-38.7-133.7-82.5-193.5-3-4-8-6.5-13-6.5zm47.8-88c68.5 108 130 234.5 138.2 368L409 480c-12-138-68.4-265-143.2-368l-108.7 0zM408.9 43.5c-1.8-6.8-8.2-11.5-15.2-11.5l-88.3 0c-5.3 0-9 5-7.8 10.3 13.2 46.5 22.3 95.5 26.5 146 48.2 86.2 79.7 178.3 90.6 270.8 15.8-60.5 25.3-133.5 25.3-203 0-73.6-12.1-145.1-31.1-212.6z"]
  };
  var faFoursquare = {
    prefix: 'fab',
    iconName: 'foursquare',
    icon: [384, 512, [], "f180", "M331.1 3L57.9 3C20.4 3 8 31.3 8 49.1L8 482.9c0 20.3 12.1 27.7 18.2 30.1 6.2 2.5 22.8 4.6 32.9-7.1 128.9-149.4 131.1-151.9 131.1-151.9 3.1-3.4 3.4-3.1 6.8-3.1l83.4 0c35.1 0 40.6-25.2 44.3-39.7l48.6-243C381.8 25.8 371.1 3 331.1 3zM314.8 76.8l-11.4 59.7c-1.2 6.5-9.5 13.2-16.9 13.2l-106.4 0c-12 0-20.6 8.3-20.6 20.3l0 13c0 12 8.6 20.6 20.6 20.6l90.4 0c8.3 0 16.6 9.2 14.8 18.2-1.8 8.9-10.5 53.8-11.4 58.8-.9 4.9-6.8 13.5-16.9 13.5l-73.5 0c-13.5 0-17.2 1.8-26.5 12.6 0 0-8.9 11.4-89.5 108.3-.9 .9-1.8 .6-1.8-.3l0-338.8c0-7.7 6.8-16.6 16.6-16.6l219 0c8.2 0 15.6 7.7 13.5 17.5z"]
  };
  var faShirtsinbulk = {
    prefix: 'fab',
    iconName: 'shirtsinbulk',
    icon: [448, 512, [], "f214", "M100 410.3l30.6 13.4 4.4-9.9-30.6-13.4-4.4 9.9zm39.4 17.5l30.6 13.4 4.4-9.9-30.6-13.4-4.4 9.9zm172.1-14l4.4 9.9 30.6-13.4-4.4-9.9-30.6 13.4zM179.1 445l30.3 13.7 4.4-9.9-30.3-13.4-4.4 9.6zM60.4 392.8l30.6 13.4 4.4-9.6-30.6-13.7-4.4 9.9zm211.4 38.5l4.4 9.9 30.6-13.4-4.4-9.9-30.6 13.4zm-39.3 17.5l4.4 9.9 30.6-13.7-4.4-9.6-30.6 13.4zm118.4-52.2l4.4 9.6 30.6-13.4-4.4-9.9-30.6 13.7zM170 46.6l-33.5 0 0 10.5 33.5 0 0-10.5zm-47.2 0l-33.6 0 0 10.5 33.5 0 .1-10.5zm-47.3 0l-33.2 0 0 10.5 33.3 0-.1-10.5zm141.5 0l-33.2 0 0 10.5 33.2 0 0-10.5zm94.5 0l-33.5 0 0 10.5 33.5 0 0-10.5zm47.3 0l-33.5 0 0 10.5 33.5 0 0-10.5zm-94.6 0l-33.2 0 0 10.5 33.2 0 0-10.5zm141.5 0l-33.3 0 0 10.5 33.3 0 0-10.5zM52.8 351.1l-10.8 0 0 33.5 10.8 0 0-33.5zm70-215.9l-33.6 0 0 10.5 33.5 0 .1-10.5zm-70 10.6l22.8 0 0-10.5-33.6 0 0 33.5 10.8 0 0-23zM221.7 374.4a91.3 91.3 0 1 0 0-182.6 91.3 91.3 0 1 0 0 182.6zM173.5 263.3c0-25.4 29.5-31.8 49.6-31.8 16.9 0 29.2 5.8 44.3 12l-8.8 16.9-.9 0c-6.4-9.9-24.8-13.1-35.6-13.1-9 0-29.8 1.8-29.8 14.9 0 21.6 78.5-10.2 78.5 37.9 0 25.4-31.5 31.2-51 31.2-18.1 0-32.4-2.9-47.2-12.2l9-18.4 .9 0c6.1 12.2 23.6 14.9 35.9 14.9 8.7 0 32.7-1.2 32.7-14.3 0-26.1-77.6 6.3-77.6-38zM52.8 178.4l-10.8 0 0 33.6 10.8 0 0-33.6zM395.2 384.6l10.8 0 0-33.5-10.8 0 0 33.5zM52.8 307.9l-10.8 0 0 33.5 10.8 0 0-33.5zM0 3.7l0 406 221.7 98.6 226.3-98.6 0-406-448 0zM418.8 390.8l-196.8 85.7-192.8-85.7 0-270.1 389.7 0 0 270.1-.1 0zm0-299.3l-389.6 0 0-58.6 389.7 0 0 58.6-.1 0zM52.8 221.6l-10.8 0 0 33.5 10.8 0 0-33.5zm0 43.2l-10.8 0 0 33.5 10.8 0 0-33.5zM170 135.2l-33.5 0 0 10.5 33.5 0 0-10.5zM395.2 298.3l10.8 0 0-33.5-10.8 0 0 33.5zm0-43.2l10.8 0 0-33.5-10.8 0 0 33.5zM217 135.2l-33.2 0 0 10.5 33.2 0 0-10.5zM395.2 212l10.8 0 0-33.5-10.8 0 0 33.5zm0 129.5l10.8 0 0-33.5-10.8 0 0 33.5zm-131-206.3l-33.2 0 0 10.5 33.2 0 0-10.5zm47.3 0l-33.5 0 0 10.5 33.5 0 0-10.5zm83.7 33.6l10.8 0 0-33.5-33.5 0 0 10.5 22.8 0-.1 23zm-36.4-33.6l-33.5 0 0 10.5 33.5 0 0-10.5z"]
  };
  var faMintbit = {
    prefix: 'fab',
    iconName: 'mintbit',
    icon: [512, 512, [], "e62f", "M73.2 512l0-73.1 292.5 0 0-73.2 73.2 0 0-146.3 73.1 0 0-219.4-219.4 0 0 73.1-146.3 0 0 73.2-73.1 0 0 292.6-73.2 0 0 73.1 73.2 0zm73.1-219.4l73.2 0 0 73.1-73.2 0 0-73.1zm73.2-73.1l73.1 0 0 73.1-73.2 0 0-73.2 .1 .1zm73.1 0l0-73.2 73.2 0 0 73.1-73.2 0 0 .1zM365.7 73.1l73.2 0 0 73.2-73.2 0 0-73.2z"]
  };
  var faStaylinked = {
    prefix: 'fab',
    iconName: 'staylinked',
    icon: [448, 512, [], "f3f5", "M386.7 292.5l2.7 2.7-170-167.3c-3.5-3.5-9.7-3.7-13.8-.5L148.3 171c-4.2 3.2-4.6 8.7-1.1 12.2l68.1 64.3c3.6 3.5 9.9 3.7 14 .5l.1-.1c4.1-3.2 10.4-3 14 .5l84 81.3c3.6 3.5 3.2 9-.9 12.2l-93.2 74c-4.2 3.3-10.5 3.1-14.2-.4L67.2 268c-3.5-3.5-9.7-3.7-13.9-.5L7.5 302.4c-4.2 3.2-4.7 8.7-1.2 12.2L215 510.7s7.4 6.8 17.3-.8L430.3 346c4-3.2 4.4-8.7 .7-12.2l-44.3-41.3zm54.5-83.4L230.7 2.5c-1.5-1.2-8-5.5-16.3 1.1L7.6 165.7c-4.2 3.2-4.8 8.7-1.2 12.2l42.3 41.7 171.7 165.1c3.7 3.5 10.1 3.7 14.3 .4l50.2-38.8-.3-.3 7.7-6c4.2-3.2 4.6-8.7 .9-12.2l-57.1-54.4c-3.6-3.5-10-3.7-14.2-.5l-.1 .1c-4.2 3.2-10.5 3.1-14.2-.4L113 180.8c-3.6-3.5-3.1-8.9 1.1-12.2l92.2-71.5c4.1-3.2 10.3-3 13.9 .5l160.4 159c3.7 3.5 10 3.7 14.1 .5l45.8-35.8c4.1-3.2 4.4-8.7 .7-12.2z"]
  };
  var faWebflow = {
    prefix: 'fab',
    iconName: 'webflow',
    icon: [640, 512, [], "e65c", "M640 64l-204.2 399.2-191.8 0 85.5-165.5-3.8 0C255.1 389.3 149.9 449.5 0 463.2L0 300.1s95.9-5.7 152.3-64.9l-152.3 0 0-171.2 171.1 0 0 140.8 3.8 0 70-140.8 129.4 0 0 139.9 3.8 0 72.6-139.9 189.3 0z"]
  };
  var faRenren = {
    prefix: 'fab',
    iconName: 'renren',
    icon: [512, 512, [], "f18b", "M214 169.1C214 279.5 153 374.5 66.4 416.5 30 373.2 8 317.7 8 256.6 8 133.9 97.1 32.2 214 12.5l0 156.6zM255 504c-42.9 0-83.3-11-118.5-30.4 57.2-36.1 103.4-90.7 118.5-154.6 15.5 63.9 61.7 118.5 118.8 154.7-35.1 19.3-75.5 30.3-118.8 30.3zm190.6-87.5C359 374.5 298 279.6 298 169.1l0-156.6c116.9 19.7 206 121.4 206 244.1 0 61.1-22 116.6-58.4 159.9z"]
  };
  var faRev = {
    prefix: 'fab',
    iconName: 'rev',
    icon: [448, 512, [], "f5b2", "M158.7 274.9a65.6 65.6 0 1 1 131.2 0 65.6 65.6 0 1 1 -131.2 0zm270.7-5.1l-.1 0c-.7-29.3-7.7-58.2-20.5-84.6s-31.2-49.7-53.8-68.4L309.6 143c22 14.2 40.1 33.8 52.7 56.8s19.1 48.8 19.1 75.1c0 86.6-70.5 157.1-157.1 157.1S67.2 361.5 67.2 274.9c0-81.9 63-149.3 143-156.4l0 39.1 108.8-62.8-108.8-62.8 0 38.3c-106.7 7.2-191 96-191 204.6 0 111.6 89.1 202.3 200.1 205l0 .1 210.2 0 0-210.2z"]
  };
  var faKeycdn = {
    prefix: 'fab',
    iconName: 'keycdn',
    icon: [512, 512, [], "f3ba", "M63.8 409.3l60.5-59c32.1 42.8 71.1 66 126.6 67.4 30.5 .7 60.3-7 86.4-22.4 5.1 5.3 18.5 19.5 20.9 22-32.2 20.7-69.6 31.1-108.1 30.2-43.3-1.1-84.6-16.7-117.7-44.4 .3-.6-38.2 37.5-38.6 37.9 9.5 29.8-13.1 62.4-46.3 62.4-26.8-.1-47.5-21.7-47.5-48.5 0-34.3 33.1-56.6 63.8-45.6zM418.7 156.9c19.1 31.3 29.6 67.4 28.7 104-1.1 44.8-19 87.5-48.6 121 .3 .3 23.8 25.2 24.1 25.5 9.6-1.3 19.2 2 25.9 9.1 11.3 12 10.9 30.9-1.1 42.4-12 11.3-30.9 10.9-42.4-1.1-6.7-7-9.4-16.8-7.6-26.3-24.9-26.6-44.4-47.2-44.4-47.2 42.7-34.1 63.3-79.6 64.4-124.2 .7-28.9-7.2-57.2-21.1-82.2l22.1-21zM104 53.1c6.7 7 9.4 16.8 7.6 26.3l45.9 48.1c-4.7 3.8-13.3 10.4-22.8 21.3-25.4 28.5-39.6 64.8-40.7 102.9-.7 28.9 6.1 57.2 20 82.4L92 355.6c-19.3-31.6-28.9-67.7-27.8-104.7 1-44.6 18.3-87.6 47.5-121.1L86.4 103.4c-9.6 1.3-19.2-2-25.9-9.1-11.3-12-10.9-30.9 1.1-42.4 11.9-11.2 30.6-10.9 42.4 1.2zM464.9 8c26 0 47.1 22.4 47.1 48.3S490.9 104 464.9 104c-6.3 .1-14-1.1-15.9-1.8l-62.9 59.7c-32.7-43.6-76.7-65.9-126.9-67.2-30.5-.7-60.3 6.8-86.2 22.4l-21.1-22C184.1 74.3 221.5 64 260 64.9 303.3 66 344.6 81.6 377.7 109.5l41.1-38.6c-1.5-4.7-2.2-9.6-2.2-14.5-.1-26.7 22.3-48.4 48.3-48.4zM256.7 113.4c5.5 0 10.9 .4 16.4 1.1 78.1 9.8 133.4 81.1 123.8 159.1-9.8 78.1-81.1 133.4-159.1 123.8-78.1-9.8-133.4-81.1-123.8-159.2 9.3-72.4 70.1-124.6 142.7-124.8zm-59 119.4c.6 22.7 12.2 41.8 32.4 52.2l-11 51.7 73.7 0-11-51.7c20.1-10.9 32.1-29 32.4-52.2-.4-32.8-25.8-57.5-58.3-58.3-32.1 .8-57.3 24.8-58.2 58.3z"]
  };
  var faHireAHelper = {
    prefix: 'fab',
    iconName: 'hire-a-helper',
    icon: [512, 512, [], "f3b0", "M443.1 0L71.9 0C67.9 37.3 37.4 67.8 0 71.7L0 443.2c37.4 4.9 66 32.4 71.9 68.8l372.2 0c3-36.4 32.5-65.8 67.9-69.8l0-370.5C475.6 65.8 447 36.4 443.1 0zm-37 404.9c-36.3 0-18.8-2-55.1-2-35.8 0-21 2-56.1 2-5.9 0-4.9-8.2 0-9.8 22.8-7.6 22.9-10.2 24.6-12.8 10.4-15.6 5.9-83 5.9-113 0-5.3-6.4-12.8-13.8-12.8l-111.2 0c-7.4 0-13.8 7.5-13.8 12.8 0 30-4.5 97.4 5.9 113 1.7 2.5 1.8 5.2 24.6 12.8 4.9 1.6 6 9.8 0 9.8-35.1 0-20.3-2-56.1-2-36.3 0-18.8 2-55.1 2-7.9 0-5.8-10.8 0-10.8 10.2-3.4 13.5-3.5 21.7-13.8 7.7-12.9 7.9-44.4 7.9-127.8l0-101.2c0-22.2-12.2-28.3-28.6-32.4-8.8-2.2-4-11.8 1-11.8 36.5 0 20.6 2 57.1 2 32.7 0 16.5-2 49.2-2 3.3 0 8.5 8.3 1 10.8-4.9 1.6-27.6 3.7-27.6 39.3 0 45.6-.2 55.8 1 68.8 0 1.3 2.3 12.8 12.8 12.8l109.2 0c10.5 0 12.8-11.5 12.8-12.8 1.2-13 1-23.2 1-68.8 0-35.6-22.7-37.7-27.6-39.3-7.5-2.5-2.3-10.8 1-10.8 32.7 0 16.5 2 49.2 2 36.5 0 20.6-2 57.1-2 4.9 0 9.9 9.6 1 11.8-16.4 4.1-28.6 10.3-28.6 32.4l0 101.2c0 83.4 .1 114.9 7.9 127.8 8.2 10.2 11.4 10.4 21.7 13.8 5.8 0 7.8 10.8 0 10.8z"]
  };
  var faSquareHackerNews = {
    prefix: 'fab',
    iconName: 'square-hacker-news',
    icon: [448, 512, ["hacker-news-square"], "f3af", "M448 96c0-35.3-28.7-64-64-64L64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320zM21 229.2s.1-.1 .1-.2 .1-.2 .2-.2c0 .1 0 .3-.1 .4l-.2 0zM239.2 384l-31.4 0 0-102.7-79.8-153.3 37.3 0c41.5 77.7 48.1 95.8 54.1 112 1.6 4.3 3.1 8.5 5.2 13.6 3.2-7 5.1-11.9 7.1-17.3 5.9-15.3 12.8-33.2 53.5-108.3l34.8 0-80.8 155.1 0 100.9z"]
  };
  var faHackerNewsSquare = faSquareHackerNews;
  var faCreativeCommonsPdAlt = {
    prefix: 'fab',
    iconName: 'creative-commons-pd-alt',
    icon: [512, 512, [], "f4ed", "M255.6 8C112.7 8 8 123.1 8 256 8 394.5 121.6 504 255.6 504 385.5 504 504 403.1 504 256 504 118.1 397.4 8 255.6 8zm.8 450.8c-112.5 0-203.7-93-203.7-202.8 0-105.4 85.5-203.3 203.7-203.3 112.6 0 202.9 89.5 202.8 203.3 0 121.7-99.6 202.8-202.8 202.8zM324.7 186l-53.2 0 0 137.2 53.2 0c21.4 0 70-5.1 70-68.6 0-63.4-48.6-68.6-70-68.6zm.8 108.5l-19.9 0 0-79.7 19.4-.1c3.8 0 35-2.1 35 39.9 0 24.6-10.5 39.9-34.5 39.9zM211.7 186l-68.2 0 0 137.3 34.6 0 0-44.3 27 0c54.1 0 57.1-37.5 57.1-46.5 0-31-16.8-46.5-50.5-46.5zm-4.9 67.3l-29.2 0 0-41.6 28.3 0c30.9 0 28.8 41.6 .9 41.6z"]
  };
  var faOrcid = {
    prefix: 'fab',
    iconName: 'orcid',
    icon: [512, 512, [], "f8d2", "M294.7 188.2l-45.9 0 0 153.8 47.5 0c67.6 0 83.1-51.3 83.1-76.9 0-41.6-26.5-76.9-84.7-76.9zM256 8a248 248 0 1 0 0 496 248 248 0 1 0 0-496zM175.2 368.8l-29.8 0 0-207.5 29.8 0 0 207.5zM160.3 98.5a19.6 19.6 0 1 1 0 39.2 19.6 19.6 0 1 1 0-39.2zM300 369l-81 0 0-207.7 80.6 0c76.7 0 110.4 54.8 110.4 103.9 0 53.3-41.7 103.9-110 103.9z"]
  };
  var faBehance = {
    prefix: 'fab',
    iconName: 'behance',
    icon: [576, 512, [], "f1b4", "M232 237.2c31.8-15.2 48.4-38.2 48.4-74 0-70.6-52.6-87.8-113.3-87.8l-167.1 0 0 354.4 171.8 0c64.4 0 124.9-30.9 124.9-102.9 0-44.5-21.1-77.4-64.7-89.7zM77.9 135.9l73.1 0c28.1 0 53.4 7.9 53.4 40.5 0 30.1-19.7 42.2-47.5 42.2l-79 0 0-82.7zm83.3 233.7l-83.3 0 0-97.6 84.9 0c34.3 0 56 14.3 56 50.6 0 35.8-25.9 47-57.6 47zM519.7 128.9l-143.7 0 0-34.9 143.7 0 0 34.9zM576 305.2c0-75.9-44.4-139.2-124.9-139.2-78.2 0-131.3 58.8-131.3 135.8 0 79.9 50.3 134.7 131.3 134.7 61.3 0 101-27.6 120.1-86.3l-62.2 0c-6.7 21.9-34.3 33.5-55.7 33.5-41.3 0-63-24.2-63-65.3l185.1 0c.3-4.2 .6-8.7 .6-13.2zM390.4 274c2.3-33.7 24.7-54.8 58.5-54.8 35.4 0 53.2 20.8 56.2 54.8l-114.7 0z"]
  };
  var faMonero = {
    prefix: 'fab',
    iconName: 'monero',
    icon: [512, 512, [], "f3d0", "M360 384l108.4 0C425 455.9 346.1 504 256 504S87 455.9 43.6 384l108.4 0 0-127.8 104 104.8 104-105 0 128zM96 336l0-208 159.4 159.4 160.6-159.4 0 208 74.8 0c8.5-25.1 13.2-52 13.2-80 0-137-111-248-248-248S8 119 8 256c0 28 4.6 54.9 13.2 80L96 336z"]
  };
  var faFigma = {
    prefix: 'fab',
    iconName: 'figma',
    icon: [384, 512, [], "f799", "M14 95.8C14 42.9 56.9 0 109.8 0L274.2 0c52.9 0 95.8 42.9 95.8 95.8 0 33.5-17.2 63-43.2 80.1 26 17.1 43.2 46.6 43.2 80.1 0 52.9-42.9 95.8-95.8 95.8l-2.1 0c-24.8 0-47.4-9.4-64.4-24.9l0 88.3c0 53.6-44 96.8-97.4 96.8-52.8 0-96.3-42.8-96.3-95.8 0-33.5 17.2-63 43.2-80.1-26-17.1-43.2-46.6-43.2-80.1s17.2-63 43.2-80.1C31.2 158.8 14 129.3 14 95.8zm162.3 95.8l-66.5 0c-35.6 0-64.4 28.8-64.4 64.4 0 35.4 28.6 64.2 64 64.4l66.9 0 0-128.8zM207.7 256c0 35.6 28.8 64.4 64.4 64.4l2.1 0c35.6 0 64.4-28.8 64.4-64.4s-28.8-64.4-64.4-64.4l-2.1 0c-35.6 0-64.4 28.8-64.4 64.4zm-97.9 95.8l-.4 0c-35.4 .2-64 29-64 64.4s29.2 64.4 64.9 64.4c36.3 0 66-29.4 66-65.5l0-63.4-66.5 0zm0-320.4c-35.6 0-64.4 28.8-64.4 64.4s28.8 64.4 64.4 64.4l66.5 0 0-128.8-66.5 0zm97.9 128.8l66.5 0c35.6 0 64.4-28.8 64.4-64.4s-28.8-64.4-64.4-64.4l-66.5 0 0 128.8z"]
  };
  var faInstagram = {
    prefix: 'fab',
    iconName: 'instagram',
    icon: [448, 512, [], "f16d", "M224.3 141a115 115 0 1 0 -.6 230 115 115 0 1 0 .6-230zm-.6 40.4a74.6 74.6 0 1 1 .6 149.2 74.6 74.6 0 1 1 -.6-149.2zm93.4-45.1a26.8 26.8 0 1 1 53.6 0 26.8 26.8 0 1 1 -53.6 0zm129.7 27.2c-1.7-35.9-9.9-67.7-36.2-93.9-26.2-26.2-58-34.4-93.9-36.2-37-2.1-147.9-2.1-184.9 0-35.8 1.7-67.6 9.9-93.9 36.1s-34.4 58-36.2 93.9c-2.1 37-2.1 147.9 0 184.9 1.7 35.9 9.9 67.7 36.2 93.9s58 34.4 93.9 36.2c37 2.1 147.9 2.1 184.9 0 35.9-1.7 67.7-9.9 93.9-36.2 26.2-26.2 34.4-58 36.2-93.9 2.1-37 2.1-147.8 0-184.8zM399 388c-7.8 19.6-22.9 34.7-42.6 42.6-29.5 11.7-99.5 9-132.1 9s-102.7 2.6-132.1-9c-19.6-7.8-34.7-22.9-42.6-42.6-11.7-29.5-9-99.5-9-132.1s-2.6-102.7 9-132.1c7.8-19.6 22.9-34.7 42.6-42.6 29.5-11.7 99.5-9 132.1-9s102.7-2.6 132.1 9c19.6 7.8 34.7 22.9 42.6 42.6 11.7 29.5 9 99.5 9 132.1s2.7 102.7-9 132.1z"]
  };
  var faPerbyte = {
    prefix: 'fab',
    iconName: 'perbyte',
    icon: [448, 512, [], "e083", "M305.3 284.6l-58.7 0 0 98.7 58.7 0c16.3 0 29-4.6 38.2-13.8s13.8-21.2 13.8-36.1c0-14.6-4.7-26.3-14-35.3s-22-13.5-37.9-13.5zM149.4 128.7l-58.7 0 0 98.7 58.7 0c16.3 0 29-4.6 38.2-13.8s13.8-21.2 13.8-36.1c0-14.6-4.7-26.3-14-35.3s-22-13.5-37.9-13.5zM366.6 32L81.4 32c-21.6 0-42.2 8.6-57.5 23.9S0 91.8 0 113.4L0 398.6c0 21.6 8.6 42.2 23.9 57.5S59.8 480 81.4 480l285.3 0c21.6 0 42.2-8.6 57.5-23.9S448 420.2 448 398.6l0-285.3c0-21.6-8.6-42.2-23.9-57.5S388.2 32 366.6 32zm63.6 366.6c0 16.9-6.7 33-18.7 45s-28.1 18.6-45 18.7l-285.3 0c-16.9 0-33-6.7-45-18.7s-18.6-28.1-18.7-45l0-285.3c0-16.9 6.7-33 18.7-45s28.1-18.6 45-18.7l285.3 0c16.9 0 33 6.7 45 18.7s18.6 28.1 18.7 45l0 285.3zm-125-269.9l-58.7 0 0 98.7 58.7 0c16.3 0 29-4.6 38.2-13.8s13.8-21.2 13.8-36.1c0-14.6-4.7-26.3-14-35.3s-22-13.5-37.9-13.5z"]
  };
  var faSquareVimeo = {
    prefix: 'fab',
    iconName: 'square-vimeo',
    icon: [448, 512, ["vimeo-square"], "f194", "M448 96c0-35.3-28.7-64-64-64L64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320zM318.5 309.5c-43.5 56.5-80.3 84.8-110.4 84.8-18.7 0-34.4-17.2-47.3-51.6-3.8-13.9-7.3-26.9-10.5-39-18.2-68.3-28.6-107.4-46.2-107.4-2.4 0-10.8 5-25.1 15.1L64 192c7-6.1 13.9-12.4 20.6-18.5 29.1-26.3 55.6-50.3 73.5-51.9 24.9-2.4 40.2 14.6 46 51.1 20.5 129.6 29.6 149.2 66.8 90.5 13.4-21.2 20.6-37.2 21.5-48.3 3.4-32.8-25.6-30.6-45.2-22.2 15.7-51.5 45.8-76.5 90.1-75.1 32.9 1 48.4 22.4 46.5 64-1.4 31.1-23.2 73.8-65.3 127.9z"]
  };
  var faVimeoSquare = faSquareVimeo;
  var faPushed = {
    prefix: 'fab',
    iconName: 'pushed',
    icon: [448, 512, [], "f3e1", "M415.1 111.9l-98.5-9 14-33.4c10.4-23.5-10.8-40.4-28.7-37L30.6 76.9c-15.1 2.7-26 18.3-21.4 36.6L114.3 461.8c6.5 21.3 36.7 24.2 47.7 7L197.3 388 432.5 156.7c16.4-16.8 4.3-42.9-17.4-44.8zM305.7 53.6c5.1-.7 7.5 2.5 5.2 7.4l-16.8 39.9-177.4-16.3 189-31zM30.8 107.9c-3.1-5.1 1-10 6.1-9.1l248.7 22.7-96.9 230.7-157.9-244.3zM144.1 456.4c-2.6 4-7.9 3.1-9.4-1.2L51.6 179.7 179.3 377.3c-7 15-35.2 79.1-35.2 79.1zM416.9 141.9l-198.7 195.4 89.7-213.7 106.4 9.7c4 1.1 5.7 5.3 2.6 8.6z"]
  };
  var faMixcloud = {
    prefix: 'fab',
    iconName: 'mixcloud',
    icon: [640, 512, [], "f289", "M213 346.6l-33.2 0 0-151.5 6.2-21.6-10.7 0-38.1 173.1-61 0-38.4-173.1-10.5 0 5.9 21.6 0 151.5-33.2 0 0-181.6 65.7 0 36.6 173.1 8.5 0 36.6-173.1 65.7 0 0 181.6zm331.5-63l-86 62.1 0-38.1 72.9-51.8-72.9-51.8 0-38.1 86 62.3 9.3 0 86.3-62.3 0 38.1-73.1 51.8 73.1 51.8 0 38.1-86.3-62.1-9.3 0zM430.2 272.3l-182 0 0-33.1 182 0 0 33.1z"]
  };
  var faYandexInternational = {
    prefix: 'fab',
    iconName: 'yandex-international',
    icon: [320, 512, [], "f414", "M129.5 512l0-166.1-111-297.9 55.8 0 81.8 229.7 94.1-277.7 51.3 0-120.7 347.8 0 164.2-51.3 0z"]
  };
  var faHive = {
    prefix: 'fab',
    iconName: 'hive',
    icon: [512, 512, [], "e07f", "M260.4 254.9L131.5 33.1c-.2-.3-.5-.6-.8-.8s-.7-.3-1.1-.3-.8 .1-1.1 .3-.6 .5-.8 .8L.3 254.9c-.2 .3-.3 .7-.3 1.1s.1 .8 .3 1.1L129.1 478.9c.2 .3 .5 .6 .8 .8s.7 .3 1.1 .3 .8-.1 1.1-.3 .6-.5 .8-.8L260.4 257.1c.2-.3 .3-.7 .3-1.1s-.1-.8-.3-1.1zm39.1-25.7c.2 .3 .5 .6 .8 .8s.7 .3 1.1 .3l66.5 0c.4 0 .8-.1 1.1-.3s.6-.5 .8-.8 .3-.7 .3-1.1-.1-.8-.3-1.1L259.1 33.1c-.2-.3-.5-.6-.8-.8s-.7-.3-1.1-.3l-66.5 0c-.4 0-.8 .1-1.1 .3s-.6 .5-.8 .8-.3 .7-.3 1.1 .1 .8 .3 1.1L299.4 229.2zm212.3 25.7L384.9 33.1c-.2-.3-.5-.6-.8-.8s-.7-.3-1.1-.3l-66.6 0c-.4 0-.8 .1-1.1 .3s-.6 .5-.8 .8-.3 .7-.3 1.1 .1 .8 .3 1.1L440.7 256 314.5 476.7c-.2 .3-.3 .7-.3 1.1s.1 .8 .3 1.1 .5 .6 .8 .8 .7 .3 1.1 .3l66.6 0c.4 0 .8-.1 1.1-.3s.6-.5 .8-.8L511.7 257.1c.2-.3 .3-.7 .3-1.1s-.1-.8-.3-1.1zM366 284.9l-66.5 0c-.4 0-.8 .1-1.1 .3s-.6 .5-.8 .8L188.8 476.7c-.2 .3-.3 .7-.3 1.1s.1 .8 .3 1.1 .5 .6 .8 .8 .7 .3 1.1 .3l66.5 0c.4 0 .8-.1 1.1-.3s.6-.5 .8-.8L367.9 288.3c.2-.3 .3-.7 .3-1.1s-.1-.8-.3-1.1-.5-.6-.8-.8-.7-.3-1.1-.3z"]
  };
  var faCreativeCommonsZero = {
    prefix: 'fab',
    iconName: 'creative-commons-zero',
    icon: [512, 512, [], "f4f3", "M255.6 8C397.4 8 504 118.1 504 256 504 403.1 385.5 504 255.6 504 121.6 504 8 394.5 8 256 8 123.1 112.7 8 255.6 8zm.8 44.7c-118.2 0-203.7 97.9-203.7 203.3 0 109.8 91.2 202.8 203.7 202.8 103.2 0 202.8-81.1 202.8-202.8 .1-113.8-90.2-203.3-202.8-203.3zm-.4 60.5c-81.9 0-102.5 77.3-102.5 142.8S174.1 398.8 256 398.8 358.5 321.5 358.5 256 337.9 113.2 256 113.2zm0 53.9c3.3 0 6.4 .5 9.2 1.2 5.9 5.1 8.8 12.1 3.1 21.9L213.8 290.4c-1.7-12.7-1.9-25.1-1.9-34.4 0-28.8 2-88.9 44.1-88.9zm40.8 46.2c2.9 15.4 3.3 31.4 3.3 42.7 0 28.9-2 88.9-44.1 88.9-13.5 0-32.6-7.7-20.1-26.4l60.9-105.2z"]
  };
  var faSquareSnapchat = {
    prefix: 'fab',
    iconName: 'square-snapchat',
    icon: [448, 512, ["snapchat-square"], "f2ad", "M384 32L64 32c-17 0-33.3 6.7-45.3 18.7S0 79 0 96L0 416c0 17 6.7 33.3 18.7 45.3S47 480 64 480l320 0c17 0 33.3-6.7 45.3-18.7S448 433 448 416l0-320c0-17-6.7-33.3-18.7-45.3S401 32 384 32zm-3.9 319.3l-.1 .1c-2.5 2.8-5.4 5.1-8.7 6.8-6.5 3.6-13.4 6.3-20.6 8.2-1.4 .4-2.7 1-3.9 1.8-2.2 1.9-2.1 4.6-4.4 8.6-1.7 3-4 5.5-6.8 7.5-6.7 4.6-14.2 4.9-22.2 5.2-7.2 .3-15.4 .6-24.7 3.7-3.8 1.2-7.8 3.7-12.4 6.5-11.3 6.9-26.7 16.4-52.3 16.4s-40.9-9.4-52.1-16.3c-4.7-2.9-8.7-5.4-12.5-6.6-9.3-3.1-17.5-3.4-24.7-3.7-8-.3-15.5-.6-22.2-5.2-2.4-1.6-4.4-3.7-6-6.1-3.2-4.6-2.9-7.8-5.3-9.9-1.3-.8-2.6-1.5-4.1-1.8-7.1-1.9-13.9-4.6-20.3-8.1-3.1-1.6-5.9-3.8-8.3-6.3-6.6-6.8-8.3-14.8-5.7-21.8 3.4-9.3 11.6-12.1 19.4-16.3 14.8-8 26.3-18.1 34.4-29.9 2.3-3.3 4.3-6.9 6-10.6 .8-2.2 .8-3.3 .2-4.4-.6-.9-1.3-1.6-2.2-2.2-2.5-1.7-5.1-3.4-6.9-4.5-3.3-2.1-5.9-3.8-7.5-5-6.3-4.4-10.6-9-13.4-14.2-1.9-3.6-3-7.6-3.3-11.6s.4-8.1 1.9-11.9c4.1-10.9 14.5-17.7 27-17.7 2.6 0 5.3 .3 7.8 .8 .7 .2 1.4 .3 2 .5-.1-7.4 .1-15.4 .7-23.1 2.4-27.3 11.9-41.6 21.9-53 6.4-7.2 13.9-13.2 22.3-17.9 15.1-8.6 32.2-13 50.9-13s35.8 4.4 50.9 13c8.3 4.7 15.9 10.8 22.2 17.9 10 11.4 19.5 25.7 21.9 53 .6 7.7 .9 15.4 .7 23.1 .7-.2 1.4-.3 2.1-.5 2.6-.6 5.2-.8 7.8-.8 12.5 0 22.8 6.8 27 17.7 1.5 3.8 2.1 7.9 1.9 11.9s-1.4 8-3.3 11.6c-2.7 5.2-7.1 9.9-13.4 14.2-1.7 1.2-4.3 2.9-7.5 5-1.8 1.2-4.5 2.9-7.2 4.7-.8 .5-1.4 1.2-1.9 2-.5 1-.5 2.2 .2 4.2 1.7 3.8 3.7 7.4 6.1 10.8 8.3 12.1 20.2 22.3 35.5 30.4 1.5 .8 3 1.5 4.4 2.3 .7 .3 1.6 .8 2.5 1.3 4.9 2.7 9.2 6 11.5 12.2 2.5 6.9 1 14.7-5.2 21.3zm-16.7-18.5c-50.3-24.3-58.3-61.9-58.7-64.7-.4-3.4-.9-6 2.8-9.5 3.6-3.3 19.5-13.2 24-16.3 7.3-5.1 10.5-10.2 8.2-16.5-1.7-4.3-5.7-6-10-6-1.3 0-2.7 .2-4 .4-8 1.7-15.8 5.8-20.4 6.9-.5 .1-1.1 .2-1.7 .2-2.4 0-3.3-1.1-3.1-4 .6-8.8 1.8-25.9 .4-41.9-1.9-22-9-32.9-17.4-42.6-4.1-4.6-23.1-24.7-59.5-24.7s-55.4 20.1-59.5 24.8c-8.4 9.7-15.5 20.6-17.4 42.6-1.4 16-.1 33.1 .4 41.9 .2 2.8-.7 4-3.1 4-.6 0-1.1-.1-1.7-.2-4.5-1.1-12.3-5.1-20.3-6.9-1.3-.3-2.6-.4-4-.4-4.3 0-8.3 1.6-10 6-2.4 6.3 .8 11.4 8.2 16.5 4.4 3.1 20.4 13 24 16.3 3.7 3.4 3.2 6.1 2.8 9.5-.4 2.8-8.4 40.4-58.7 64.7-2.9 1.4-8 4.4 .9 9.3 13.9 7.6 23.1 6.8 30.3 11.4 6.1 3.9 2.5 12.4 6.9 15.4 5.5 3.8 21.6-.3 42.3 6.6 17.4 5.7 28.1 22 59 22s41.8-16.3 58.9-22c20.8-6.9 36.9-2.8 42.3-6.6 4.4-3.1 .8-11.5 6.9-15.4 7.2-4.6 16.4-3.8 30.3-11.5 8.8-4.9 3.8-7.9 .9-9.4z"]
  };
  var faSnapchatSquare = faSquareSnapchat;
  var faThemeisle = {
    prefix: 'fab',
    iconName: 'themeisle',
    icon: [512, 512, [], "f2b2", "M208 88.3c0-10 6.3-21.7 17.7-21.7 11.1 0 17.7 11.7 17.7 21.7 0 10.3-6.6 21.7-17.7 21.7-11.4 0-17.7-11.4-17.7-21.7zm304 160c0 36-11.4 102.3-36.3 129.7-22.9 24.9-87.4 61.1-120.9 70.6l-1.1 .3 0 32.6c0 16.3-12.6 30.6-29.1 30.6-10 0-19.4-5.7-24.6-14.3-5.4 8.6-14.9 14.3-24.9 14.3s-19.4-5.7-24.9-14.3c-5.1 8.6-14.6 14.3-24.6 14.3-10.3 0-19.4-5.7-24.9-14.3-5.1 8.6-14.6 14.3-24.6 14.3-18.9 0-29.4-15.7-29.4-32.9-16.3 12.3-35.7 19.4-56.6 19.4-22 0-43.4-8.3-60.3-22.9 10.3-.3 20.6-2.3 30.3-5.7-20.9-5.7-39.4-18.9-52-36.3 21.4 4.6 46.2 1.7 67.1-11.1-22-22-56.6-58.9-68.6-87.4-5.7-13.4-6.9-31.4-6.9-45.7 0-49.7 20.3-160 86.3-160 10.6 0 18.9 4.9 23.1 14.9 3.7-5.4 7.7-10.5 12-15.4 2-2.6 5.7-5.4 7.1-8.3 8-12.6 11.7-21.1 21.7-34 32.3-41.1 81.7-69.4 134.9-69.4 6 0 12 .3 17.7 1.1 10.9-11.7 26-18.3 41.7-18.3 14.6 0 29.7 6 40 16.3 .9 .9 1.4 2.3 1.4 3.4 0 3.7-10.3 13.4-12.9 16.3 4.3 1.4 15.7 6.9 15.7 12 0 2.9-2.9 5.1-4.6 7.1 31.4 27.7 49.4 67.1 56.3 108 4.3-5.1 10.3-8.6 17.1-8.6 10.6 0 20.9 7.1 28.6 14 20.9 18.6 25.7 53.1 25.7 79.7zM188 89.4c0 18.3 12.6 37.1 32.3 37.1s32.3-18.9 32.3-37.1c0-18-12.6-36.9-32.3-36.9S188 71.4 188 89.4zM237.7 194c0-19.7 3.7-39.1 8.6-58.3-52 79.5-13.5 184.6 68.9 184.6 21.4 0 42.6-7.7 60-20 2-7.4 3.7-14.9 3.7-22.6 0-14.3-6.3-21.4-20.6-21.4-4.6 0-9.1 .9-13.4 1.7-63.3 12.7-107.1 3.7-107.1-64zM196.6 448.9c0-11.1-8.9-20.9-20.3-20.9s-20 9.7-20 20.9l0 32.6c0 11.1 8.6 21.1 20 21.1s20.3-9.7 20.3-21.1l0-32.6zm49.1 0c0-11.1-8.6-20.9-20-20.9s-20.3 9.7-20.3 20.9l0 32.6c0 11.1 8.9 21.1 20.3 21.1s20-10 20-21.1l0-32.6zm49.7 0c0-11.1-8.9-20.9-20.3-20.9s-20.3 9.7-20.3 20.9l0 32.6c0 11.1 8.9 21.1 20.3 21.1s20.3-9.7 20.3-21.1l0-32.6zm49.7 0c0-11.1-8.9-20.9-20.3-20.9s-20.3 9.7-20.3 20.9l0 32.6c0 11.1 8.9 21.1 20.3 21.1s20.3-10 20.3-21.1l0-32.6zM421.7 286c-30.9 59.1-90.3 102.6-158.6 102.6-96.6 0-160.6-84.6-160.6-176.6 0-16.9 2-33.4 6-49.7-20 33.7-29.7 72.6-29.7 111.4 0 60.3 24.9 121.7 71.4 160.9 5.1-9.7 14.9-16.3 26-16.3 10 0 19.4 5.7 24.6 14.3 5.4-8.6 14.6-14.3 24.9-14.3 10 0 19.4 5.7 24.6 14.3 5.4-8.6 14.9-14.3 24.9-14.3s19.4 5.7 24.9 14.3c5.1-8.6 14.6-14.3 24.6-14.3 10.9 0 20.9 6.6 25.7 16 43.4-36.3 68.6-92 71.4-148.3zm10.6-99.7c0-53.7-34.6-105.7-92.6-105.7-30.3 0-58.6 15.1-78.9 36.9-20 66.4-27.4 136.6 41.4 136.6 28.8 0 97.4-28.5 84.3 36.9 28.9-26 45.7-65.7 45.7-104.6z"]
  };
  var faDartLang = {
    prefix: 'fab',
    iconName: 'dart-lang',
    icon: [512, 512, [], "e693", "M378.6 78.9c-2.8-.1-5.6-.2-8.5-.2l-264.1 0 143.2-72c7.4-4.4 18.8-6.7 30.4-6.7 13.5 0 29.4 9.2 37 16.8l62 62 0 .1zM107.3 96.5l262.8 0c16 0 25.4 1.4 35.4 9.3l106.5 106.4 0 208.8-79.3 .7-325.4-325.2zM96.5 373l0-262.2 323.8 323.8 .7 77.4-212.2 0-98.1-98.2C99.4 402.5 96.5 398.5 96.5 373zM78.7 105.3l0 267.7c0 3.3 .1 6.3 .2 9.1l-62-62C6.5 309.3 0 294.3 0 279.6 0 272.8 3.9 262.1 6.7 256l72-150.7z"]
  };
  var faDeploydog = {
    prefix: 'fab',
    iconName: 'deploydog',
    icon: [512, 512, [], "f38e", "M382.2 136l51.7 0 0 239.6-51.7 0 0-20.7c-19.8 24.8-52.8 24.1-73.8 14.7-26.2-11.7-44.3-38.1-44.3-71.8 0-29.8 14.8-57.9 43.3-70.8 20.2-9.1 52.7-10.6 74.8 12.9l0-103.9zM317.5 297.8a33.2 33.2 0 1 0 66.4 1 33.2 33.2 0 1 0 -66.4-1zM188.5 136l51.7 0 0 239.6-51.7 0 0-20.7c-19.8 24.8-52.8 24.1-73.8 14.7-26.2-11.7-44.3-38.1-44.3-71.8 0-29.8 14.8-57.9 43.3-70.8 20.2-9.1 52.7-10.6 74.8 12.9l0-103.9zM123.8 297.8a33.2 33.2 0 1 0 66.4 1 33.2 33.2 0 1 0 -66.4-1zM448 96c17.5 0 32 14.4 32 32l0 256c0 17.5-14.4 32-32 32L64 416c-17.5 0-32-14.4-32-32l0-256c0-17.5 14.4-32 32-32l384 0zm0-32L64 64C28.8 64 0 92.8 0 128L0 384c0 35.2 28.8 64 64 64l384 0c35.2 0 64-28.8 64-64l0-256c0-35.2-28.8-64-64-64z"]
  };
  var faFlipboard = {
    prefix: 'fab',
    iconName: 'flipboard',
    icon: [448, 512, [], "f44d", "M0 32l0 448 448 0 0-448-448 0zM358.4 211.2l-89.6 0 0 89.6-89.6 0 0 89.6-89.6 0 0-268.8 268.8 0 0 89.6z"]
  };
  var faBuyNLarge = {
    prefix: 'fab',
    iconName: 'buy-n-large',
    icon: [576, 512, [], "f8a6", "M288.2 32C133.5 32 8 132.3 8 256S133.5 480 288.2 480 568.4 379.7 568.4 256 442.9 32 288.2 32zM202.8 389.2l-138.5 1.4 77.2-290.7 133.4 0c63.2 0 84.9 28.6 78 72.8-.4 2.3-.9 4.6-1.5 6.9-5.6-1.3-11.4-1.9-17.2-1.9-42.3 0-76.7 33.9-76.7 75.7 0 37.1 27.1 68 62.9 74.5-18.2 37.2-56.2 60.9-117.7 61.5zM358.2 207.1l32 0-22.2 90.3-35.4 0-11.2-35.6-7.8 35.6-37.8 0 26.6-90.3 31.3 0 15 36.8 9.4-36.8zM504.1 389.2l-197.1 0 15.8-61.2c3.8 .6 7.6 .8 11.5 .8 42.3 0 76.7-33.9 76.7-75.6 0-32.6-21-60.5-50.4-71.1l21.3-82.4 92.5 0-53 205.4 103.9 0-21.2 84.1zM211.9 269.4l-24.7 0-13.8 56.5 24.7 0c16.1 0 32.1-3.2 37.9-26.6 5.6-22.3-8-29.8-24.1-29.8zM233.2 170l-21.3 0-11.7 47.7 21.4 0c18 0 35.4-14.6 39.2-30.1 4.6-18.9-9.5-17.6-27.6-17.6z"]
  };
  var faWatchmanMonitoring = {
    prefix: 'fab',
    iconName: 'watchman-monitoring',
    icon: [512, 512, [], "e087", "M256 16a240 240 0 1 0 0 480 240 240 0 1 0 0-480zM121.7 429.1c-51.6-40.2-84.9-102.8-84.9-173.1 0-21.7 3.2-43.3 9.6-64.1l102.9-17.9-.1 11-13.9 2s-.1 12.5-.1 19.5c0 2 .4 4 1.2 5.8s2.1 3.4 3.7 4.6l9.5 7.4-27.7 204.9zM227.4 145.9l8.5-7.6s6.9-5.4-.1-9.3c-7.2-4-39.5-34.5-39.5-34.5-5.3-5.5-8.3-7.3-15.5 0 0 0-32.3 30.5-39.5 34.5-7.1 4-.1 9.3-.1 9.3l8.5 7.6 0 4.4-73.5-19.2c39.6-56.9 105.5-94.3 180-94.3 31.3 0 62.2 6.7 90.6 19.6s53.8 31.8 74.3 55.4l-193.5 37.7 0-3.6zm34.1 329.3l-33.9-250.9 9.5-7.4c1.6-1.2 2.8-2.8 3.7-4.6s1.3-3.8 1.2-5.8c0-7-.1-19.5-.1-19.5l-13.9-2-.1-10.5 241.7 31.4c3.9 16.4 5.8 33.3 5.8 50.1 0 119.1-95.4 216.2-213.8 219.1z"]
  };
  var faHips = {
    prefix: 'fab',
    iconName: 'hips',
    icon: [640, 512, [], "f452", "M251.6 157.6c0-1.9-.9-2.8-2.8-2.8l-40.9 0c-1.6 0-2.7 1.4-2.7 2.8l0 201.8c0 1.4 1.1 2.8 2.7 2.8l40.9 0c1.9 0 2.8-.9 2.8-2.8l0-201.8zM156.5 168c-16.1-11.8-36.3-17.9-60.3-18-18.1-.1-34.6 3.7-49.8 11.4l0-81.2c0-1.8-.9-2.7-2.8-2.7l-40.9 0C.9 77.5 0 78.4 0 80.2L0 359.4c0 1.9 .9 2.8 2.7 2.8l41 0c1.9 0 2.8-.9 2.8-2.8l0-136.1c0-.8-2.8-27 45.8-27 48.5 0 45.8 26.1 45.8 27l0 122.6c0 9 7.3 16.3 16.4 16.3l27.3 0c1.8 0 2.7-.9 2.7-2.8l0-136.1c0-23.4-9.3-41.8-28-55.3zM634.9 278.1c-6.8-15.7-18.4-27-34.9-34.1l-57.6-25.3c-8.6-3.6-9.2-11.2-2.6-16.1 7.4-5.5 44.3-13.9 84 6.8 1.7 1 4-.3 4-2.4l0-44.7c0-1.3-.6-2.1-1.9-2.6-17.7-6.6-36.1-9.9-55.1-9.9-26.5 0-45.3 5.8-58.5 15.4-.5 .4-28.4 20-22.7 53.7 3.4 19.6 15.8 34.2 37.2 43.6L580.4 286c11.6 5.1 15.2 13.3 12.2 21.2-3.7 9.1-13.2 13.6-36.5 13.6-24.3 0-44.7-8.9-58.4-19.1-2.1-1.4-4.4 .2-4.4 2.3l0 34.4c0 10.4 4.9 17.3 14.6 20.7 15.6 5.5 31.6 8.2 48.2 8.2 12.7 0 25.8-1.2 36.3-4.3 .7-.3 36-8.9 45.6-45.8 3.5-13.5 2.4-26.5-3.1-39.1zM376.2 149.8c-31.7 0-104.2 20.1-104.2 103.5l0 183.5c0 .8 .6 2.7 2.7 2.7l40.9 0c1.9 0 2.8-.9 2.8-2.7l0-88.8c16.5 12.7 35.8 19.1 57.7 19.1 60.5 0 108.7-48.5 108.7-108.7 .1-60.3-48.2-108.6-108.6-108.6zm0 46.6a62.2 62.2 0 1 1 0 124.3 62.2 62.2 0 1 1 0-124.3zM228.3 72.5c-15.9 0-28.8 12.9-28.9 28.9 0 15.6 12.7 28.9 28.9 28.9s28.9-13.1 28.9-28.9c0-16.2-13-28.9-28.9-28.9z"]
  };
  var faCloudversify = {
    prefix: 'fab',
    iconName: 'cloudversify',
    icon: [640, 512, [], "f385", "M160.6 304c8.2 68.5 67.4 115.5 146 111.3 51.2 43.3 136.8 45.8 186.4-5.6 69.2 1.1 118.5-44.6 131.5-99.5 14.8-62.5-18.2-132.5-92.1-155.1-33-88.1-131.4-101.5-186.5-85-57.3 17.3-84.3 53.2-99.3 109.7-7.8 2.7-26.5 8.9-45 24.1 11.7 0 15.2 8.9 15.2 19.5l0 20.4c0 10.7-8.7 19.5-19.5 19.5l-20.2 0c-10.7 0-19.5-6-19.5-16.7l0-6.6-46.8 0c-3.8 0-10.8 4.3-10.8 11.9l0 40.4c0 6.4 5.3 11.8 11.7 11.8l48.9 0 0-.1zM388 312c-10.7 46.3 21.7 72.4 55.3 86.8-107.2 33.8-171.6-50.8-135.3-110.8-33.2 21.6-33.7 71.2-29.2 92.9-17.9-12.4-53.8-32.4-57.4-79.8-3-39.9 21.5-75.7 57-93.9 30.6-15.8 103.5-8.5 133.6 40.8-14.1-48-53.8-70.1-101.8-74.8 30.9-30.7 64.4-50.3 114.2-43.7 69.8 9.3 133.2 82.8 67.7 150.5 35-16.3 48.7-54.4 47.5-76.9l10.5 19.6c11.8 22 15.2 47.6 9.4 72-9.2 39-40.6 68.8-79.7 76.5-32.1 6.3-83.1-5.1-91.8-59.2zM140 208l-39.8 0c-8.9 0-16.2-7.3-16.2-16.2l0-39.6c0-8.9 7.3-16.2 16.2-16.2l39.8 0c8.9 0 16.2 7.3 16.2 16.2l0 39.6c0 8.9-7.3 16.2-16.2 16.2zM22.1 168c-5.6 0-10.1-4.5-10.1-10.1l0-27.8c0-5.6 4.5-10.1 10.1-10.1l27.7 0c5.5 0 10.1 4.5 10.1 10.1l0 27.8c0 5.6-4.5 10.1-10.1 10.1l-27.7 0zM180 142.7l0-21.4c0-5.1 4.2-9.3 9.3-9.3l21.4 0c5.1 0 9.3 4.2 9.3 9.3l0 21.4c0 5.1-4.2 9.3-9.3 9.3l-21.4 0c-5.1 0-9.3-4.2-9.3-9.3zM68 235.5l0 25c0 6.3-5.1 11.5-11.4 11.5l-25.2 0c-6.3 0-11.4-5.2-11.4-11.5l0-25c0-6.3 5.1-11.5 11.4-11.5l25.1 0c6.4 0 11.5 5.2 11.5 11.5z"]
  };
  var faGoodreads = {
    prefix: 'fab',
    iconName: 'goodreads',
    icon: [448, 512, [], "f3a8", "M299.9 191.2c5.1 37.3-4.7 79-35.9 100.7-22.3 15.5-52.8 14.1-70.8 5.7-37.1-17.3-49.5-58.6-46.8-97.2 4.3-60.9 40.9-87.9 75.3-87.5 46.9-.2 71.8 31.8 78.2 78.3zM448 88l0 336c0 30.9-25.1 56-56 56L56 480c-30.9 0-56-25.1-56-56L0 88C0 57.1 25.1 32 56 32l336 0c30.9 0 56 25.1 56 56zM330 313.2s-.1-34-.1-217.3l-29 0 0 40.3c-.8 .3-1.2-.5-1.6-1.2-9.6-20.7-35.9-46.3-76-46-51.9 .4-87.2 31.2-100.6 77.8-4.3 14.9-5.8 30.1-5.5 45.6 1.7 77.9 45.1 117.8 112.4 115.2 28.9-1.1 54.5-17 69-45.2 .5-1 1.1-1.9 1.7-2.9 .2 .1 .4 .1 .6 .2 .3 3.8 .2 30.7 .1 34.5-.2 14.8-2 29.5-7.2 43.5-7.8 21-22.3 34.7-44.5 39.5-17.8 3.9-35.6 3.8-53.2-1.2-21.5-6.1-36.5-19-41.1-41.8-.3-1.6-1.3-1.3-2.3-1.3l-26.8 0c.8 10.6 3.2 20.3 8.5 29.2 24.2 40.5 82.7 48.5 128.2 37.4 49.9-12.3 67.3-54.9 67.4-106.3z"]
  };
  var faTidal = {
    prefix: 'fab',
    iconName: 'tidal',
    icon: [640, 512, [], "e7dc", "M107.2 48l-1.3 0c-32.3 33.1-65.4 65.5-98 98.5-2.6 2.8-6.1 5.1-7.9 8.6 35.6 35.4 71 71 106.6 106.4 35.4-35.3 70.7-70.8 106.1-106.1l0-1.3-73.2-73.2C128.8 69.8 117.3 59.6 107.2 48zm213.5 0l-1.3 0c-34.9 36.1-71.5 71-106.3 107.2 35.9 35.1 71 71 106.7 106.3 34.3-34.1 68.4-68.4 102.6-102.4 1.5-1.5 3.3-2.8 4.1-4.8-34.6-33.8-68.4-68.2-102.6-102.1-1.3-1.3-2.3-2.6-3.3-4.1zm213.5 0l-1.3 0c-17.2 18-35.1 35.3-52.6 53-17.9 17.7-35.4 35.7-53.5 53.3 .8 2.3 3 3.6 4.6 5.5L533.3 261.5c36.1-34.9 70.8-71.2 106.7-106.1-.5-2.2-2.6-3.5-4-5L555.8 70.2c-7.1-7.4-14.9-14.2-21.5-22.2zM319.6 261.7c-34.9 35.1-70 70-104.9 104.9-.3 .7-.7 1.7-1 2.3 24 23.7 47.7 47.5 71.5 71.3 11.8 11.3 22.8 23.5 34.9 34.4 8.4-7.4 16.4-16.4 24.7-24.3 25.5-25.3 51-51 76.5-76.3 1.8-2.2 4.3-3.6 5.5-6.3-35.4-34.9-70.5-70.2-105.6-105.4l-1.5-.7z"]
  };
  var faUnity = {
    prefix: 'fab',
    iconName: 'unity',
    icon: [448, 512, [], "e049", "M243.6 91.6l80.1 46.8c2.9 1.6 3 6.2 0 7.8l-95.2 55.6c-2.9 1.7-6.3 1.6-9 0l-95.2-55.6c-2.9-1.6-3-6.3 0-7.8l80.1-46.8 0-91.6-204.4 119.4 0 238.8 78.4-45.8 0-93.6c-.1-3.3 3.8-5.7 6.7-3.9l95.2 55.6c2.9 1.7 4.5 4.7 4.5 7.8l0 111.2c.1 3.3-3.8 5.7-6.7 3.9L98 346.8 19.6 392.6 224 512 428.4 392.6 350 346.8 269.9 393.6c-2.8 1.7-6.8-.5-6.7-3.9l0-111.2c0-3.3 1.8-6.3 4.5-7.8L362.9 215c2.8-1.7 6.8 .5 6.7 3.9l0 93.6 78.4 45.8 0-238.8-204.4-119.4 0 91.6z"]
  };
  var faTencentWeibo = {
    prefix: 'fab',
    iconName: 'tencent-weibo',
    icon: [320, 512, [], "f1d5", "M40.5 495.8c1.4 19.9-27.6 22.2-29.7 2.9-11.6-129.9 31.1-239.5 101.4-313.2-15.6-34 9.2-77.1 50.6-77.1 30.3 0 55.1 24.6 55.1 55.1 0 44-49.5 70.8-86.9 45.1-65.7 71.3-101.4 169.8-90.5 287.2zM160.2 .1c-125.9 0-204.3 134.2-148.3 242.3 8.7 17.4 35.3 4.5 26.3-13.4-46.3-92.6 21-199.2 122-199.2 75.4 0 136.9 61.4 136.9 136.9 0 90.8-86.9 153.9-167.7 133.1-19.1-4.1-25.6 24.4-6.6 29.1 110.7 23.2 204-60 204-162.3 0-91.9-74.6-166.5-166.6-166.5z"]
  };
  var faFreeCodeCamp = {
    prefix: 'fab',
    iconName: 'free-code-camp',
    icon: [576, 512, [], "f2c5", "M97.4 96.2c10.4-10.6 16-17.1 16-21.9 0-2.8-1.9-5.5-3.8-7.4-2.4-1.8-5.4-2.8-8.4-2.8-8.5 0-20.9 8.8-35.8 25.7-41.5 47.3-62.7 93.1-61.8 160.6S21 367.3 57.6 412.2c18.8 23.6 33.2 35.8 43.5 35.8 3.2-.3 6.1-1.6 8.4-3.8 1.9-2.8 3.8-5.6 3.8-8.4 0-5.6-3.9-12.2-13.2-20.6-44.5-42.3-67.3-97-67.5-165-.2-61.4 21.6-112.4 64.8-154zM239.6 420.1c.6 .4 .9 .6 .9 .6l-.9-.6zm93.8 .6l.2-.1c-.2 .1-.3 .2-.2 .1zm3.1-158.2c-16.2-4.2 50.4-82.9-68.1-177.2 0 0 15.5 49.4-62.8 159.6-74.3 104.4 23.5 168.7 34 175.2-6.7-4.3-47.4-35.7 9.6-128.6 11-18.3 25.5-34.9 43.5-72.2 0 0 15.9 22.4 7.6 71.1-12.5 73.6 53.8 52.5 54.8 53.5 22.8 26.8-17.7 73.5-21.6 76.6 5.5-3.7 117.7-78 33-188.1-6 6-13.8 34.2-30 30.1zM511 89.7c-14.9-16.9-27.4-25.7-35.9-25.7-3 .1-5.9 1.1-8.4 2.8-1.9 1.9-3.8 4.7-3.8 7.4 0 4.8 5.6 11.3 16 21.9 43.2 41.6 65 92.6 64.8 154.1-.2 68-23 122.6-67.5 165-9.3 8.4-13.2 14.9-13.2 20.6 0 2.7 1.9 5.6 3.8 8.4 2.3 2.2 5.2 3.6 8.4 3.8 10.3 0 24.7-12.1 43.5-35.8 36.6-44.9 53.1-94.4 54.1-161.9S552.5 137 511 89.7z"]
  };
  var faXTwitter = {
    prefix: 'fab',
    iconName: 'x-twitter',
    icon: [448, 512, [], "e61b", "M357.2 48L427.8 48 273.6 224.2 455 464 313 464 201.7 318.6 74.5 464 3.8 464 168.7 275.5-5.2 48 140.4 48 240.9 180.9 357.2 48zM332.4 421.8l39.1 0-252.4-333.8-42 0 255.3 333.8z"]
  };
  var faStickerMule = {
    prefix: 'fab',
    iconName: 'sticker-mule',
    icon: [576, 512, [], "f3f7", "M561.7 199.6l0 0zm-6.2-77.4c-7.7-22.3-5.1-7.2-13.4-36.9-1.6-6.5-3.6-14.5-6.2-20-4.4-8.7-4.6-7.5-4.6-9.5 0-5.3 30.7-45.3 19-46.9-5.7-.6-12.2 11.6-20.6 17-8.6 4.2-8 5-10.3 5-2.6 0-5.7-3-6.2-5-2-5.7 1.9-25.9-3.6-25.9-3.6 0-12.3 24.8-17 25.8-5.2 1.3-27.9-11.4-75.1 18-25.3 13.2-86.9 65.2-87 65.3-6.7 4.7-20 4.7-35.5 16-44.4 30.1-109.6 9.4-110.7 9-110.6-26.8-128-15.2-159 11.5-20.8 17.9-23.7 36.5-24.2 38.9-4.2 20.4 5.2 48.3 6.7 64.3 1.8 19.3-2.7 17.7 7.7 98.3 .5 1 4.1 0 5.1 1.5 0 8.4-3.8 12.1-4.1 13-1.5 4.5-1.5 10.5 0 16 2.3 8.2 8.2 37.2 8.2 46.9 0 41.8 .4 44 2.6 49.4 3.9 10 12.5 9.1 17 12 3.1 3.5-.5 8.5 1 12.5 .5 2 3.6 4 6.2 5 9.2 3.6 27 .3 29.9-2.5 1.6-1.5 .5-4.5 3.1-5 5.1 0 10.8-.5 14.4-2.5 5.1-2.5 4.1-6 1.5-10.5-.4-.8-7-13.3-9.8-16-2.1-2-5.1-3-7.2-4.5-5.8-4.9-10.3-19.4-10.3-19.5-4.6-19.4-10.3-46.3-4.1-66.8 4.6-17.2 39.5-87.7 39.6-87.8 4.1-6.5 17-11.5 27.3-7 6 1.9 19.3 22 65.4 30.9 47.9 8.7 97.4-2 112.2-2 2.8 2-1.9 13-.5 38.9 0 26.4-.4 13.7-4.1 29.9-2.2 9.7 3.4 23.2-1.5 46.9-1.4 9.8-9.9 32.7-8.2 43.4 .5 1 1 2 1.5 3.5 .5 4.5 1.5 8.5 4.6 10 7.3 3.6 12-3.5 9.8 11.5-.7 3.1-2.6 12 1.5 15 4.4 3.7 30.6 3.4 36.5 .5 2.6-1.5 1.6-4.5 6.4-7.4 1.9-.9 11.3-.4 11.3-6.5 .3-1.8-9.2-19.9-9.3-20-2.6-3.5-9.2-4.5-11.3-8-6.9-10.1-1.7-52.6 .5-59.4 3-11 5.6-22.4 8.7-32.4 11-42.5 10.3-50.6 16.5-68.3 .8-1.8 6.4-23.1 10.3-29.9 9.3-17 21.7-32.4 33.5-47.4 18-22.9 34-46.9 52-69.8 6.1-7 8.2-13.7 18-8 10.8 5.7 21.6 7 31.9 17 14.6 12.8 10.2 18.2 11.8 22.9 1.5 5 7.7 10.5 14.9 9.5 10.4-2 13-2.5 13.4-2.5 2.6-.5 5.7-5 7.2-8 3.1-5.5 7.2-9 7.2-16.5 0-7.7-.4-2.8-20.6-52.9z"]
  };
  var faTwitch = {
    prefix: 'fab',
    iconName: 'twitch',
    icon: [448, 512, [], "f1e8", "M359.4 103.5l-38.6 0 0 109.7 38.6 0 0-109.7zM253.2 103l-38.6 0 0 109.8 38.6 0 0-109.8zM89 0l-96.5 91.4 0 329.2 115.8 0 0 91.4 96.5-91.4 77.3 0 173.8-164.6 0-256-366.9 0zM417.3 237.8l-77.2 73.1-77.2 0-67.6 64 0-64-86.9 0 0-274.3 308.9 0 0 201.2z"]
  };
  var faKickstarterK = {
    prefix: 'fab',
    iconName: 'kickstarter-k',
    icon: [448, 512, [], "f3bc", "M356.7 256.2l40.8-40.5c42.2-41.9 42.2-110.3 0-152.1s-111-41.9-153.2 0L229.3 78.4C209.6 50.3 177.1 32 140.2 32 80.5 32 32 80.2 32 139.5l0 233c0 59.4 48.5 107.5 108.2 107.5 37.1 0 69.3-18.3 89-46.4l14.9 14.7c42.2 41.9 111 41.9 153.2 0s42.2-110.3 0-152.1l-40.8-40 .1 0z"]
  };
  var faCriticalRole = {
    prefix: 'fab',
    iconName: 'critical-role',
    icon: [448, 512, [], "f6c9", "M225.8 0c.3 .2 216.6 124.5 217.1 124.7 3 1.2 3.7 3.5 3.7 6.6-.1 83.4-.1 166.9 0 250.4 .1 1.2-.2 2.4-.8 3.4s-1.5 1.9-2.6 2.4c-21.4 12-207.9 118.3-218.9 124.6l-3 0c-79.3-45.7-218.3-125.4-218.4-125.5-.6-.3-1.1-.7-1.4-1.3s-.5-1.2-.4-1.9c0-.9 0-225.9-.1-253.1-.1-1 .2-2 .7-2.9s1.3-1.6 2.2-2C27.2 112.1 213.2 6 224.1 0l1.8 0zM215.4 20.4l-.2-.2c-64.7 36.9-129.5 73.7-194.2 110.6 0 .1 .1 .2 .1 .4L52 142.9c-7.7 6-8.3 6-10.6 5.1-.1 0-24.2-9.3-26.8-10l0 230.4c.9-1.4 64.1-110.9 64.1-111 1.6-2.8 3-1.9 9.1-1.5 1.4 .1 1.5 .2 .8 1.4-41.2 71.3-36.4 63-67.5 116.9-.8 1.4-.6 1.1 1.2 1.1l186.5 0c1.4 0 1.7-.2 1.7-1.6l0-8.9c0-1.3 2.4-.8-18.4-1-7.5-.1-14.1-3.2-21.4-12.7-7.4-9.7-14.6-19.4-21.8-29.2-2.3-3.1-3.4-2.4-16.8-2.4-1.8 0-1.8 0-1.8 1.8 .3 26.2 .2 25.3 1 32.7 .5 4.4 2.2 4.2 9.7 4.8 3.1 .3 3.9 4.1 .5 4.9-1.6 .4-31.6 .5-33.7-.1-.5-.1-1-.5-1.3-.9s-.5-1-.4-1.6 .3-1.1 .6-1.5 .9-.7 1.4-.8c3.3-.8 6.2 .8 6.7-4.4 1.3-13.7 1.2-9 1.1-79.4 0-10.8-.4-12.6-5.4-13.6-1.2-.2-3.5-.2-4.7-.6-2.9-1-2-4.8 1.8-4.8 33.7 0 46.1-1.1 56.1 4.9 7.7 4.6 12 11.5 12.5 20.4 .9 14.6-6.5 22.3-15 32.6-.2 .1-.3 .3-.4 .5s-.1 .4-.1 .6 0 .4 .1 .6 .2 .4 .4 .5c2.6 3.2 5 6.6 7.7 9.8 27.6 33.2 24.1 30.5 41.3 33.1 .9 .1 1-.4 1-1.2l0-11c0-1 .3-1.4 1.4-1.3 7.8 1.2 15.8 1.1 23.6-.3 1.1-.1 1.5 .2 1.5 1.3 0 .1 .9 26.7 .9 26.8 0 1.5 .7 1.6 1.9 1.6l186.7 0c-27.2-47-54.2-94-81.2-140.8 2.3-.7-.4 0 6.7-1.4 2-.4 2.1-.4 3.1 1.4 7.3 12.6 77.3 134 77.4 134.1l0-230.4c-1.7 .5-103.3 38.7-105.8 39.7-1.1 .4-1.5 .2-1.9-.9-.6-1.9-1.3-3.8-2.1-5.6-.3-.8-.1-1.1 .6-1.4 .1 0 95.5-35.8 103-38.8-65.4-37.6-130.6-75-196-112.6l86.8 150.4-.3 .3c-9.6-.9-10.5-1.6-11.8-3.9-1-1.7-73.5-127.7-82-142.2-9.1 14.7-83.6 146.2-85.4 146.3-2.9 .2-5.9 .1-9.2 .1 28.8-49.8 57.6-99.5 86.2-149l0 0zm51.9 129.9c1.9-.1 3.7-.4 5.5-.8 1.7-.3 2.5 .2 2.6 1.9 0 .1 .1 19.1-.9 20.5s-1.9 1.2-2.6-.2c-5-9.7 6.2-9.7-39.1-12-.7 0-1 .2-1 .9 0 .1 3.7 122 3.7 122.1 0 .9 .5 1.2 1.2 1.5 3 1.2 5.9 2.5 8.7 4 7.3 4.3 11.4 10.8 12.4 19.3 1.4 11.8-2.8 35.8-32.2 37.1-2.8 .1-28.3 1.1-34.1-23.3-4.7-19.3 8.3-32.7 19.9-36.4 .6-.1 1.2-.4 1.5-.9s.5-1.1 .5-1.7c.1-5.6 3-107.1 3.7-121.3 0-1.1-.6-1.2-1.4-1.1-32.3 .5-36.7-.3-40.2 8.5-2.4 6.2-4.1 1.3-4 .2 1.1-6 2.2-12 3.3-18 .4-2.1 1.4-2.6 3.4-1.9 5.6 2.1 6.7 1.7 37.2 1.9 1.7 0 1.8-.1 1.8-1.8 .7-27.5 .6-22.6 1-29.6 .1-.6-.1-1.2-.3-1.7s-.7-.9-1.3-1.1c-5.6-2.9-8.8-7.6-8.9-13.9-.4-14.8 17.7-21.7 27.4-11.5 6.8 7.2 5.8 18.9-2.5 24.2-.8 .4-1.4 1.1-1.8 1.8s-.6 1.6-.4 2.5c0 .6-.1-4.3 1 30 0 .9 .4 1.1 1.2 1.1 .1 0 23-.1 34.5-.4l0-.1zM68.3 141.7c19.8-4.5 32.7-.6 52.5 1.7 2.8 .3 3.7 1.2 3.6 4-.2 5-1.2 22.3-1.2 23.1 0 .5-.2 1-.5 1.4s-.7 .7-1.2 .9c-4.1 1.7-3.6-4.4-4-7.3-3.1-22.4-73.9-32.7-74.6 25.4-.3 23.9 17 53.6 54.1 50.9 27.2-2 19-20.2 24.8-20.5 .4-.1 .9 0 1.3 .1s.8 .4 1.1 .7 .5 .7 .6 1.2 .1 .9 0 1.3c-1.8 10.8-3.4 19-3.4 19.2-1.5 9.2-86.7 22.1-93.4-42.1-2.7-25.8 10.4-53.4 40.3-60.2zm80 87.7l-19.5 0c-.6 0-1.2-.1-1.6-.4s-.8-.8-1-1.4c2.4-3.8 5.9 .9 5.9-6.1-.1-25.8 .2-38 .2-40.1 0-3.4-.5-4.6-3.3-4.9-7-.7-3.1-3.4-1.1-3.4 11.8-.1 22.6-.2 30 .7 8.8 1.1 16.7 12.6 7.9 22.6-2 2.2-4 4.4-6.1 6.7 1 1.2 6.9 8.8 17.3 19.7 2.7 2.8 6.2 3.5 9.9 3.1 .6 0 1.1-.2 1.5-.6s.7-.9 .7-1.5c.3-3.4 .3 4.7 .4-40.6 0-5.6-.3-6.6-3.2-6.8-4-.4-4-2.3-.7-3.4l19.1-.1c.3 0 4.5 .5 1 3.4 0 0-.2 0-.2 0-3.6 .3-3.9 1-4 4.6-.3 43.9 .1 40.2 .4 42.8 .1 .8 .3 2.2 5.1 2.1 2.5 0 3.9 3.4 0 3.4-10.4 .1-20.7 0-31.1 .1-10.7 0-13.5-6.2-24.2-20.8-1.6-2.2-8.3-2.4-8.2-.4 .9 16.5 0 17.8 4 17.7 4.8-.1 4.7 3.6 .8 3.5l.1 0zm275-10.1c-1.2 7.1 .2 10.4-5.3 10.3-61.5-.4-47.8-.2-50.7-.3-1.2-.1-2.4-.4-3.6-.7-2.5-.6 1.5-1.2-.4-5.6-1.4-3.4-2.8-6.8-4.1-10.2-.1-.4-.4-.8-.7-1.1s-.8-.4-1.3-.4c-4.9-.2-9.7-.2-14.6 .1-.3 0-.6 .2-.9 .3s-.5 .4-.7 .7c-1.6 3.6-3.1 7.3-4.5 11-1.3 3.2 7.9 1.3 12.2 2.2 3 .6 4.5 3.7 .7 3.7l-26.4 0c-2.9 0-3.1-3.2-.7-3.2 1.2 .1 2.4-.2 3.5-.9s1.9-1.5 2.4-2.6c1.5-3 2.8-6 4.1-9.1 18.2-42.1 17.1-40.2 18.4-41.6 .2-.2 .4-.4 .7-.6s.6-.2 .8-.2 .6 .1 .8 .2 .5 .3 .7 .6c2.9 3.3 18.4 44.7 23.6 51.9 2 2.7 5.7 2 6.4 2 3.6 .1 4-1.1 4.1-4.3 .1-1.9 .1 1.2 .1-41.2 0-4.5-2.4-3.7-5.6-4.3-.3 0-2.6-.6-.1-3.1 .2-.2-.9-.2 21.7-.2 2.3 0 5.3 2.8-1.2 3.4-.4 0-.7 0-1.1 .2s-.6 .3-.9 .6-.4 .6-.6 .9-.2 .7-.1 1.1c-.1 1.6-.2 38.9 .3 41.2 .2 .7 .6 1.4 1.2 1.8s1.3 .7 2.1 .6c13.3 .4 14.9 .4 16-3.4 1.7-5.8 4.1-2.5 3.7-.2l0 .1zM318.6 283.6c-4.2 0-4.4-3.4-.6-3.4 35.9-.2 28.1 .4 37.2-.6 1.7-.2 2.4 .2 2.3 1.9-.3 3.4-.6 6.8-1 10.2-.2 2.2-3.2 2.6-3.4-.2-.4-5.3-2.2-4.5-15.6-5.1-1.6-.1-1.6 0-1.6 1.5l0 16.1c0 1.7 0 1.6 1.6 1.5 3.1-.2 10.3 .3 15.7-1.5 .5-.2 3.3-1.8 3.1 1.8 0 .2-.8 10.4-1.2 11.4-.5 1.3-1.9 1.5-2.6 .3-1.2-2 0-5.1-3.7-5.3-15.4-.9-12.9-2.5-12.9 6 0 12.3-.8 16.1 3.9 16.2 16.6 .5 14.4 0 16.4-5.7 .8-2.4 3.5-1.8 3.2 .6-.4 3.2-.8 6.4-1.2 9.6 0 .4-.2 2.4-4.7 2.4-37.2-.1-34.5-.2-35.2-.3-2.7-.5-2.2-3 .2-3.4 1.1-.2 4 .5 4.2-2.6 2.4-56.2-.1-51.3-3.9-51.3l0 0zm-.4-109.5c2.5 .6 3.1 1.8 3 4.6-.3 5.3-.3 9-.6 9.7-.7 2.2-3.1 2.1-3.3-.3-.4-4.8-3-7.8-7.6-9.1-26.3-7.7-32.8 15.5-27.2 30.2 5.9 15.4 22 15.9 28.9 13.8 5.9-1.9 5.9-6.5 6.9-7.6 1.2-1.3 2.2-1.8 3.1 1.1 0 .1 .6 11.9-6 12.7-1.6 .2-19.4 3.7-32.7-3.4-21-11.2-16.7-35.5-6.9-45.3 14-14.1 39.9-7.1 42.3-6.5l0 0zM289.8 280.1c3.3 0 3.7 3 .2 3.4-2.6 .3-5-.4-5 5.5 0 2-.2 29 .4 41.4 .1 2.3 1.2 3.5 3.4 3.7 22 1.2 15-1.7 18.8-6.3 1.8-2.2 2.8 .8 2.8 1.1 .3 13.6-4 12.4-5.2 12.4l-38.2-.2c-1.9-.2-2.1-3-.4-3.4 2-.5 4.9 .4 5.1-2.8 1-15.9 .6-44.6 .3-47.8-.3-3.8-2.8-3.3-5.7-3.7-2.5-.4-2-3.2 .3-3.2 1.4 0 18 0 23.1 0zm-31.6-57.8c.1 4.1 2.9 3.5 6 3.6 2.6 .1 2.5 3.4-.1 3.4-6.5 0-13.7 0-21.6-.1-3.8 0-3.4-3.4 0-3.4 4.5 0 3.2 1.6 3.4-45.5 0-5.1-3.3-3.5-4.7-4.2-2.6-1.2-1.4-3.1 .4-3.2 1.3 0 20.2-.4 21.2 .2s1.9 1.6-.4 2.9c-1 .5-3.9-.3-4.2 2.5 0 .2-.8 1.6-.1 43.8l0 0zM221.3 496.6c.5 .3 1 .5 1.6 .5s1.1-.2 1.6-.5c17-9.8 182-103.6 197.4-112.5-.1-.4 11.3-.2-181.5-.3-1.2 0-1.6 .4-1.5 1.6 0 .1 1.3 44.5 1.2 50.4-.1 2.6-.6 5.2-1.4 7.7-.6 1.8 .4-.5-13.5 32.2-.7 1.7-1 2.2-2-.1-4.2-10.3-8.3-20.7-12.6-31-1.5-3.4-2.2-7.1-2-10.8 .2-2.5 .8-16.1 1.5-48 0-1.9 0-2-2-2l-183 0c2.6 1.6 178.3 102.6 196 112.8l.1 0zM130.4 307.9c0 2.4 .4 2.8 2.8 3 11.5 1.2 21 3.7 25.6-7.3 6-14.5 2.7-34.4-12.5-38.8-2-.6-16-2.8-15.9 1.5 0 8 0 11.6 0 41.6zm105.8-15c0 2.1 1.1 38.7 1.1 39.1 .3 9.9-25.6 5.8-25.2-2.6 .1-2 1.4-37.4 1.1-39.4-14.1 7.4-14.4 40.2 6.4 48.8 4 1.7 8.4 1.9 12.5 .6s7.6-4 9.9-7.7c4.9-7.8 6.8-29.5-5.4-39-.1 .1-.2 .1-.4 .1l0 0zm-12.3-198c-9.8 0-9.7 14.8-.1 14.9s10.1-14.9 .1-14.9l0 0zM143.7 198.6c0 1.8 .4 2.4 2.2 2.6 13.6 1.4 12.5-11 12.2-13.4-1.7-11.2-14.4-10.2-14.4-7.8 0 4.5 0 13.7 0 18.6zM356 205l-6.1-15.8c-2.2 5.5-4.2 10.6-6.2 15.8l12.3 0z"]
  };
  var faSteamSymbol = {
    prefix: 'fab',
    iconName: 'steam-symbol',
    icon: [448, 512, [], "f3f6", "M273.5 177.5a61 61 0 1 1 122 0 61 61 0 1 1 -122 0zm174.5 .2c0 63-51 113.8-113.7 113.8L225 371.3c-4 43-40.5 76.8-84.5 76.8-40.5 0-74.7-28.8-83-67L0 358 0 250.7 97.2 290c15.1-9.2 32.2-13.3 52-11.5l71-101.7C220.7 114.5 271.7 64 334.2 64 397 64 448 115 448 177.7zM203 363c0-34.7-27.8-62.5-62.5-62.5-4.5 0-9 .5-13.5 1.5l26 10.5c25.5 10.2 38 39 27.7 64.5-10.2 25.5-39.2 38-64.7 27.5-10.2-4-20.5-8.3-30.7-12.2 10.5 19.7 31.2 33.2 55.2 33.2 34.7 0 62.5-27.8 62.5-62.5zM410.5 177.7a76.4 76.4 0 1 0 -152.8 0 76.4 76.4 0 1 0 152.8 0z"]
  };
  var faMailchimp = {
    prefix: 'fab',
    iconName: 'mailchimp',
    icon: [448, 512, [], "f59e", "M331 243.5c3.1-.4 6.2-.4 9.3 0 1.7-3.8 2-10.4 .5-17.6-2.2-10.7-5.3-17.1-11.5-16.1s-6.5 8.7-4.2 19.4c1.3 6 3.5 11.1 6 14.3l0 0zM277.4 252c4.5 2 7.2 3.3 8.3 2.1 1.9-1.9-3.5-9.4-12.1-13.1-5-2.1-10.4-2.8-15.8-2.2s-10.5 2.7-14.8 5.8c-3 2.2-5.8 5.2-5.4 7.1 .9 3.7 10-2.7 22.6-3.5 7-.4 12.8 1.8 17.3 3.7l0 0zm-9 5.1c-9.1 1.4-15 6.5-13.5 10.1 .9 .3 1.2 .8 5.2-.8 6-2.3 12.4-2.9 18.7-1.9 2.9 .3 4.3 .5 4.9-.5 1.5-2.2-5.7-8-15.4-6.9l0 0zm54.2 17.1c3.4-6.9-10.9-13.9-14.3-7s10.9 13.9 14.3 7l0 0zm15.7-20.5c-7.7-.1-8 15.8-.3 15.9s8-15.8 .3-16l0 0zM119.5 332.7c-1.3 .3-6 1.5-8.5-2.3-5.2-8 11.1-20.4 3-35.8-9.1-17.5-27.8-13.5-35-5.5-8.7 9.6-8.7 23.5-5 24.1 4.3 .6 4.1-6.5 7.4-11.6 .9-1.4 2.1-2.6 3.5-3.6s3-1.6 4.6-2 3.4-.4 5 0 3.3 1 4.7 1.9c11.6 7.6 1.4 17.8 2.3 28.6 1.4 16.7 18.4 16.4 21.6 9 .2-.4 .3-.8 .3-1.2s-.2-.8-.5-1.1c0 .9 .7-1.3-3.4-.4l0 0zm299.7-17.1c-3.3-11.7-2.6-9.2-6.8-20.5 2.4-3.7 15.3-24-3.1-43.3-10.4-10.9-33.9-16.5-41.1-18.5-1.5-11.4 4.6-58.7-21.5-83 20.8-21.6 33.8-45.3 33.7-65.7-.1-39.2-48.2-51-107.4-26.5l-12.5 5.3c-.1 0-22.7-22.3-23.1-22.6-67.5-58.9-278.8 175.9-211.3 232.9l14.8 12.5c-4 10.7-5.4 22.2-4.1 33.5 3.4 33.4 36 60.4 67.5 60.4 57.7 133.1 267.9 133.3 322.3 3 1.7-4.5 9.1-24.6 9.1-42.4s-10.1-25.3-16.5-25.3l0 0zm-316 48.2c-22.8-.6-47.5-21.1-49.9-45.5-6.2-61.3 74.3-75.3 84-12.3 4.5 29.6-4.7 58.5-34.1 57.8l0 0zM84.7 249.6c-15.2 3-28.5 11.5-36.7 23.5-4.9-4.1-14-12-15.6-15-13-24.8 14.2-73 33.3-100.2 47.1-67.2 120.9-118.1 155-108.9 5.5 1.6 23.9 22.9 23.9 22.9s-34.1 18.9-65.8 45.3C136.2 150 104 197.7 84.7 249.6zM323.6 350.7s-35.7 5.3-69.5-7.1c6.2-20.2 27 6.1 96.4-13.8 15.3-4.4 35.4-13 51-25.4 3.4 7.8 5.8 15.9 7.1 24.3 3.7-.7 14.2-.5 11.4 18.1-3.3 19.9-11.7 36-25.9 50.8-8.9 9.6-19.4 17.5-31.2 23.3-6.5 3.4-13.3 6.3-20.3 8.6-53.5 17.5-108.3-1.7-126-43-1.4-3.1-2.6-6.4-3.6-9.7-7.5-27.2-1.1-59.8 18.8-80.4 1.2-1.3 2.5-2.9 2.5-4.8-.2-1.7-.8-3.3-1.9-4.5-7-10.1-31.2-27.4-26.3-60.8 3.5-24 24.5-40.9 44.1-39.9l5 .3c8.5 .5 15.9 1.6 22.9 1.9 11.7 .5 22.2-1.2 34.6-11.6 4.2-3.5 7.6-6.5 13.3-7.5 2.3-.6 4.7-.7 7-.3s4.6 1.2 6.6 2.5c10 6.6 11.4 22.7 11.9 34.5 .3 6.7 1.1 23 1.4 27.6 .6 10.7 3.4 12.2 9.1 14 3.2 1 6.2 1.8 10.5 3.1 13.2 3.7 21 7.5 26 12.3 2.5 2.5 4.2 5.8 4.7 9.3 1.6 11.4-8.8 25.4-36.3 38.2-46.7 21.7-93.7 14.4-100.5 13.7-20.2-2.7-31.6 23.3-19.5 41.1 22.6 33.4 122.4 20 151.4-21.4 .7-1 .1-1.6-.7-1-41.8 28.6-97.1 38.2-128.5 26-4.8-1.8-14.7-6.4-15.9-16.7 43.6 13.5 71 .7 71 .7s2-2.8-.6-2.5zM171.7 157.5c16.7-19.4 37.4-36.2 55.8-45.6 .1-.1 .3-.1 .5-.1s.3 .1 .4 .2 .2 .3 .2 .4 0 .3-.1 .5c-1.5 2.7-4.3 8.3-5.2 12.7 0 .1 0 .3 0 .4s.2 .3 .3 .4 .3 .1 .4 .1 .3 0 .4-.1c11.5-7.8 31.5-16.2 49-17.3 .2 0 .3 0 .5 .1s.2 .2 .3 .4 .1 .3 0 .5-.1 .3-.3 .4c-2.9 2.2-5.5 4.8-7.7 7.7-.1 .1-.1 .2-.1 .4s0 .3 .1 .4 .2 .2 .3 .3 .2 .1 .4 .1c12.3 .1 29.7 4.4 41 10.7 .8 .4 .2 1.9-.6 1.7-69.5-15.9-123.1 18.5-134.5 26.8-.2 .1-.3 .1-.5 .1s-.3-.1-.5-.2-.2-.3-.2-.5 .1-.4 .2-.5l-.1 0z"]
  };
  var faLumon = {
    prefix: 'fab',
    iconName: 'lumon',
    icon: [640, 512, [], "e7e2", "M452.5 223.5c9.8 0 16.5 6.3 16.5 16.6l0 31.8c0 10.3-6.6 16.6-16.6 16.6l-56.2 0c-9.8 0-16.5-6.3-16.5-16.6l0-31.8c0-10.3 6.7-16.6 16.5-16.6l56.3 0zm-25.7 13.1c-1.5-2.6-3.2-2.6-4.6 0l-10.7 17.6c-1.7 2.4-2.6 5.1-2.6 8.2 0 7.9 6.9 14.6 15.6 14.6 8.5 0 15.6-6.7 15.6-14.6 0-3-1-5.8-2.7-8.2l-10.7-17.6zM85.8 223.8c1 0 1.5 .6 1.5 1.5l0 50.3 64.6 0c1 0 1.6 .6 1.6 1.5l0 9.7c0 .9-.6 1.5-1.6 1.5l-78.4 0c-1 0-1.6-.6-1.6-1.5l0-61.4c0-.9 .6-1.5 1.6-1.5l12.3 0zm88.3 0c1 0 1.5 .6 1.5 1.5l0 45c0 4 2 5.2 5.7 5.2l46.9 0c3.8 0 5.7-1.3 5.7-5.2l0-45c0-.9 .5-1.5 1.5-1.5l12.3 0c1 0 1.6 .6 1.6 1.5l0 46c0 10.5-5.3 16.8-17.6 16.8l-54 0c-12.3 0-17.6-6.3-17.6-16.8l0-46c0-.9 .6-1.5 1.6-1.5l12.3 0zm108.2 0c1 0 1.6 .5 2.2 1.4l30.5 46.4 1.4 0 30.5-46.4c.6-.9 1.2-1.4 2.2-1.4l18 0c1 0 1.5 .6 1.5 1.5l0 61.4c0 .9-.5 1.5-1.5 1.5l-12.3 0c-1 0-1.6-.6-1.6-1.5l0-43.8-1.1 0-28.7 43.8c-.6 .9-1.3 1.5-2.4 1.5l-10.7 0c-1 0-1.7-.6-2.3-1.5l-28.7-43.8-1.1 0 0 43.8c0 .9-.5 1.5-1.5 1.5l-12.3 0c-1 0-1.6-.6-1.6-1.5l0-61.4c0-.9 .6-1.5 1.6-1.5l17.9 0zm214.4 0c.9 0 1.3 .4 2.2 1.1l52.7 46.3 1.3 0 0-46c0-.9 .6-1.5 1.6-1.5l12.3 0c1 0 1.6 .6 1.6 1.5l0 61.4c0 .9-.6 1.5-1.6 1.5l-14.4 0c-1 0-1.4-.4-2.3-1.1l-52.6-46.3-1.4 0 0 46c0 .9-.5 1.5-1.5 1.5l-12.3 0c-1 0-1.6-.6-1.6-1.5l0-61.4c0-.9 .6-1.5 1.6-1.5l14.4 0zM320 114.1c87.9 0 167.7 15.7 225.5 41l2.7 1.2C587.1 173.8 640 206.5 640 256s-52.9 82.2-91.8 99.6l-2.7 1.2c-57.8 25.4-137.6 41-225.5 41-76.2 0-155.1-10.5-225.5-41-39.6-17.4-94.5-50.3-94.5-100.8s54.9-83.5 94.5-100.8c70.4-30.5 149.3-41 225.5-41zm-88.9 229c20.3 29 52.8 49.6 88.9 49.6 36.2 0 68.7-20.6 89-49.7l-177.9 .1zm-96.1 0c43.3 29.7 96.7 43.5 148.4 48-24.2-9.1-44.4-26.7-58.6-48.1l-89.9 0zm280.3-.1c-14.2 21.4-34.4 39.1-58.6 48.1 51.8-4.5 105.3-18.3 148.6-48.2l-90 0zm-337.4 .1c44.1 23.1 93.7 35.4 142.7 42.6-33.4-8.6-66.5-21.9-94.4-42.6l-48.3 0zm436.2-.2c-27.9 20.8-61.1 34.2-94.6 42.8 47.3-6.9 89.6-18.5 123.9-33.6l1.7-.8c6.1-2.7 11.9-5.5 17.4-8.4l-48.5 0zM520 173.6c10.7 8.7 19.8 18.1 27 28.2 .4 .6 .5 1.3 .1 2s-1 1-1.7 1l-1.6 0c-.6 0-1.2-.3-1.5-.8-7.9-10.9-18.2-21.1-30.6-30.4l-93.5 0c5.4 8.8 9.9 18.5 13.4 28.6 .2 .6 .1 1.2-.2 1.7s-.9 .8-1.6 .8l-1.4 0c-.8 0-1.5-.5-1.8-1.3-3.8-10.7-8.7-20.8-14.5-29.9l-184.3 .1c-5.8 9.1-10.7 19.1-14.4 29.8-.3 .8-1 1.3-1.8 1.3l-1.4 0c-.6 0-1.2-.3-1.6-.8s-.5-1.1-.2-1.7c3.5-10.2 8-19.7 13.4-28.6l-93.6 0c-12.3 9.3-22.6 19.4-30.4 30.3-.4 .5-.9 .8-1.5 .8l-1.6 0c-.7 0-1.4-.4-1.7-1s-.3-1.4 .1-2c7.6-10.5 16.7-19.9 26.8-28l-51 0c-28.9 16.6-62 43.3-63.5 79.7l44.7 0c.5 0 1 .2 1.3 .6s.6 .8 .6 1.3l0 1.3c0 1.1-.9 1.9-1.9 1.9l-44.7 0C6.8 295 40 321.7 69 338.3l50.9 0c-10.3-8.4-19.1-17.4-26.1-27l-.8-1.1c-.4-.6-.5-1.3-.1-2s1-1 1.7-1l1.6 0 .2 0c.5 .1 1 .3 1.3 .8 7.9 10.9 18.1 21 30.5 30.3l93.6 0c-5.3-8.8-9.8-18.4-13.4-28.5-.2-.6-.1-1.2 .2-1.7s.9-.8 1.6-.8l1.4 0 .2 0c.7 .1 1.4 .6 1.7 1.3 3.8 10.7 8.6 20.7 14.4 29.8l184.5-.1c5.8-9.1 10.6-19.1 14.4-29.7l.1-.1c.3-.7 1-1.1 1.7-1.1l1.4 0c.6 0 1.2 .3 1.6 .8s.5 1.2 .2 1.7c-3.5 10.1-8 19.7-13.3 28.5l93.7 0c12.3-9.3 22.5-19.4 30.3-30.2l.1-.2c.4-.4 .9-.6 1.4-.6l1.6 0c.7 0 1.4 .4 1.7 1s.3 1.4-.1 2c-7.1 10-16.1 19.3-26.7 27.9l51.1 0c28.8-16.6 61.8-43.3 63.4-79.6l-44.7 0c-1 0-1.9-.9-1.9-1.9l0-1.3c0-1.1 .9-1.9 1.9-1.9l44.7 0c-1.6-36.5-34.9-63.3-63.9-79.9l-50.9 0zM220.5 126.2c-49.1 7.1-98.7 19.5-143 42.7l48.4 0c27.9-20.8 61-34.1 94.5-42.7zm62.8-5.4c-51.8 4.5-105.2 18.3-148.6 48.1l90 0c14.2-21.4 34.4-39 58.6-48.1zm36.6-1.6c-36.2 0-68.7 20.6-89 49.7l177.9-.1c-20.3-29.1-52.7-49.6-88.9-49.6zm36.6 1.6c24.2 9.1 44.4 26.6 58.5 48l89.8 0c-43.3-29.7-96.6-43.5-148.3-48zm62.8 5.4c33.4 8.5 66.4 21.9 94.3 42.5l48.3 0c-44.1-23.1-93.6-35.4-142.6-42.5z"]
  };
  var faNutritionix = {
    prefix: 'fab',
    iconName: 'nutritionix',
    icon: [448, 512, [], "f3d6", "M112 8.1S245.4-.1 233 112.5c0 0 19.1-74.9 103-40.6 0 0-17.7 74-88 56 0 0 14.6-54.6 66.1-56.6 0 0-39.9-10.3-82.1 48.8 0 0-19.8-94.5-93.6-99.7 0 0 75.2 19.4 77.6 107.5 0 .1-106.4 7-104-119.8zM424 323.7c0 48.5-9.7 95.3-32 132.3-42.2 30.9-105 48-168 48-62.9 0-125.8-17.1-168-48-22.3-37-32-83.8-32-132.3 0-48.4 17.7-94.7 40-131.7 42.2-30.9 97.1-48.6 160-48.6 63 0 117.8 17.6 160 48.6 22.3 37 40 83.3 40 131.7zM144 428a28 28 0 1 0 -56 0 28 28 0 1 0 56 0zm0-66.2a28 28 0 1 0 -56 0 28 28 0 1 0 56 0zm0-66.2a28 28 0 1 0 -56 0 28 28 0 1 0 56 0zM216 428a28 28 0 1 0 -56 0 28 28 0 1 0 56 0zm0-66.2a28 28 0 1 0 -56 0 28 28 0 1 0 56 0zm0-66.2a28 28 0 1 0 -56 0 28 28 0 1 0 56 0zM288 428a28 28 0 1 0 -56 0 28 28 0 1 0 56 0zm0-66.2a28 28 0 1 0 -56 0 28 28 0 1 0 56 0zm0-66.2a28 28 0 1 0 -56 0 28 28 0 1 0 56 0zM360 428a28 28 0 1 0 -56 0 28 28 0 1 0 56 0zm0-66.2a28 28 0 1 0 -56 0 28 28 0 1 0 56 0zm0-66.2a28 28 0 1 0 -56 0 28 28 0 1 0 56 0zM384 256c-4.8-22.3-7.4-36.9-16-56-38.8-19.9-90.5-32-144-32S118.8 180.1 80 200c-8.8 19.5-11.2 33.9-16 56 42.2-7.9 98.7-14.8 160-14.8s117.8 6.9 160 14.8z"]
  };
  var faCreativeCommonsSamplingPlus = {
    prefix: 'fab',
    iconName: 'creative-commons-sampling-plus',
    icon: [512, 512, [], "f4f1", "M255.6 8C397.4 8 504 118.1 504 256 504 403.1 385.5 504 255.6 504 121.6 504 8 394.5 8 256 8 123.1 112.7 8 255.6 8zm.8 44.7c-118.2 0-203.7 97.9-203.7 203.3 0 109.8 91.2 202.8 203.7 202.8 103.2 0 202.8-81.1 202.8-202.8 .1-113.8-90.2-203.3-202.8-203.3zm107 205.6c-4.7 0-9 2.8-10.7 7.2l-4 9.5-11-92.8c-1.7-13.9-22-13.4-23.1 .4l-4.3 51.4-5.2-68.8c-1.1-14.3-22.1-14.2-23.2 0l-3.5 44.9-5.9-94.3c-.9-14.5-22.3-14.4-23.2 0l-5.1 83.7-4.3-66.3c-.9-14.4-22.2-14.4-23.2 0l-5.3 80.2-4.1-57c-1.1-14.3-22-14.3-23.2-.2l-7.7 89.8-1.8-12.2c-1.7-11.4-17.1-13.6-22-3.3l-13.2 27.7-43.9 0 0 23.2 51.3 0c4.4 0 8.4-2.5 10.4-6.4l10.7 73.1c2 13.5 21.9 13 23.1-.7l3.8-43.6 5.7 78.3c1.1 14.4 22.3 14.2 23.2-.1l4.6-70.4 4.8 73.3c.9 14.4 22.3 14.4 23.2-.1l4.9-80.5 4.5 71.8c.9 14.3 22.1 14.5 23.2 .2l4.6-58.6 4.9 64.4c1.1 14.3 22 14.2 23.1 .1l6.8-83 2.7 22.3c1.4 11.8 17.7 14.1 22.3 3.1l18-43.4 50.5 0 0-23.2-58.4 .3zm-78 5.2l-21.9 0 0 21.9c0 4.1-3.3 7.5-7.5 7.5-4.1 0-7.5-3.3-7.5-7.5l0-21.9-21.9 0c-4.1 0-7.5-3.3-7.5-7.5 0-4.1 3.4-7.5 7.5-7.5l21.9 0 0-21.9c0-4.1 3.4-7.5 7.5-7.5s7.5 3.3 7.5 7.5l0 21.9 21.9 0c4.1 0 7.5 3.3 7.5 7.5 0 4.1-3.4 7.5-7.5 7.5z"]
  };
  var faRedhat = {
    prefix: 'fab',
    iconName: 'redhat',
    icon: [512, 512, [], "f7bc", "M341.5 285.6c33.7 0 82.3-6.9 82.3-47 .2-6.7 .9-1.8-20.9-96.2-4.6-19.1-8.7-27.8-42.3-44.6-26.1-13.3-82.9-35.4-99.7-35.4-15.7 0-20.2 20.2-38.9 20.2-18 0-31.3-15.1-48.1-15.1-16.1 0-26.7 11-34.8 33.6-27.5 77.6-26.3 74.3-26.1 78.3 0 24.8 97.6 106.1 228.5 106.1zM429 254.8c4.7 22 4.7 24.3 4.7 27.2 0 37.7-42.3 58.6-98 58.6-125.7 .1-235.9-73.6-235.9-122.3 0-6.8 1.4-13.5 4.1-19.7-45.2 2.3-103.8 10.3-103.8 62 0 84.7 200.6 189 359.5 189 121.8 0 152.5-55.1 152.5-98.6 0-34.2-29.6-73-82.9-96.2z"]
  };
  var faSquarePiedPiper = {
    prefix: 'fab',
    iconName: 'square-pied-piper',
    icon: [448, 512, ["pied-piper-square"], "e01e", "M32.1 419l-32 60.2 .8-328C.9 85.3 54.1 32 120.1 32l327.2 0C354.3 60.9 257.4 126.2 193.4 200.6 122.8 282 82.7 338 32.1 419zm416-387S305.3 98.8 261.7 199.1c-23.2 53.6-28.9 118.1-71 158.6-28.9 27.8-69.8 38.2-105.3 56.3-23.2 12-66.4 40.5-84.9 66l328.4 0c66 0 119.3-53.3 119.3-119.2-.1 0-.1-328.8-.1-328.8z"]
  };
  var faPiedPiperSquare = faSquarePiedPiper;
  var faWhatsapp = {
    prefix: 'fab',
    iconName: 'whatsapp',
    icon: [448, 512, [], "f232", "M380.9 97.1c-41.9-42-97.7-65.1-157-65.1-122.4 0-222 99.6-222 222 0 39.1 10.2 77.3 29.6 111L0 480 117.7 449.1c32.4 17.7 68.9 27 106.1 27l.1 0c122.3 0 224.1-99.6 224.1-222 0-59.3-25.2-115-67.1-157zm-157 341.6c-33.2 0-65.7-8.9-94-25.7l-6.7-4-69.8 18.3 18.6-68.1-4.4-7c-18.5-29.4-28.2-63.3-28.2-98.2 0-101.7 82.8-184.5 184.6-184.5 49.3 0 95.6 19.2 130.4 54.1s56.2 81.2 56.1 130.5c0 101.8-84.9 184.6-186.6 184.6zM325.1 300.5c-5.5-2.8-32.8-16.2-37.9-18-5.1-1.9-8.8-2.8-12.5 2.8s-14.3 18-17.6 21.8c-3.2 3.7-6.5 4.2-12 1.4-32.6-16.3-54-29.1-75.5-66-5.7-9.8 5.7-9.1 16.3-30.3 1.8-3.7 .9-6.9-.5-9.7s-12.5-30.1-17.1-41.2c-4.5-10.8-9.1-9.3-12.5-9.5-3.2-.2-6.9-.2-10.6-.2s-9.7 1.4-14.8 6.9c-5.1 5.6-19.4 19-19.4 46.3s19.9 53.7 22.6 57.4c2.8 3.7 39.1 59.7 94.8 83.8 35.2 15.2 49 16.5 66.6 13.9 10.7-1.6 32.8-13.4 37.4-26.4s4.6-24.1 3.2-26.4c-1.3-2.5-5-3.9-10.5-6.6z"]
  };
  var faImdb = {
    prefix: 'fab',
    iconName: 'imdb',
    icon: [448, 512, [], "f2d8", "M89.5 323.6l-35.6 0 0-137.4 35.6 0 0 137.4zm66.6-73.1l9.1-64.3 46.3 0 0 137.4-31 0 0-92.7-13.4 92.7-21.3 0-13-90.7-.1 90.7-31.2 0 0-137.4 46.1 0c.5 8.3 2.8 18.1 4.3 29.4l4.2 34.9zm67.6 73.1l0-137.4 26.6 0c17 0 27 .9 33 2.4 6.1 1.7 10.7 4.2 13.9 7.9 3.1 3.3 5.1 6.6 5.8 12 .9 4.4 1.4 13.1 1.4 26.2l0 48.2c0 12.3-.7 20.5-1.9 24.7-1.1 4.1-3.1 7.4-6 9.7-2.8 2.4-6.4 4.1-10.7 5-4.2 .8-10.6 1.3-19.1 1.3l-43 0zm35.5-113.9l0 89.4c5.1 0 8.3-1 9.4-2.3 1.1-2 1.8-7.6 1.8-16.7l0-53.3c0-6.2-.1-10.2-.7-12-.3-1.8-1.2-3-2.6-4.7-1.4 0-4.1-.4-7.9-.4zm57.3 113.9l0-137.4 34.1 0 0 43.9c2.9-2.4 6.1-4.9 9.5-6.6 3.6-1.5 8.8-2.4 12.8-2.4 4.8 0 8.9 .8 12.3 2.2 3.4 1.5 6 3.5 8 6.2 1.7 2.6 2.7 5.3 3.1 7.8 .4 2.6-.2 8-.2 16.2l0 38.6c0 8.2 .2 14.3-.8 18.4-1.1 4-3.8 7.6-7.8 9.6-4.1 3.9-8.9 5.3-14.6 5.3-4 0-9.2-.9-12.7-2.5-3.5-1.8-6.7-4.5-9.6-8l-2.1 8.7-32 0zm45.1-20.7c.7-1.8 1-6 1-12.5l0-35.4c0-5.6-.3-9.5-1.1-11.2-.7-1.9-3.7-2.7-5.8-2.7-2 0-3.4 .8-4.1 2.3-.6 1.5-1 5.4-1 11.6l0 36.4c0 6.1 .4 10 1.2 11.6 .6 1.7 2.1 2.5 4.1 2.5 2.2 0 4.2-.8 5.7-2.6zM418.4 32c15.7 1.2 28.7 15.2 28.7 31.9l0 384.2c0 16.4-11.9 30.4-28.2 31-.3 0-.5 .9-.8 .9L29.9 480c-.3 0-.6-.9-.8-.1-15.7-1.4-27.9-13.8-29-30.2L0 61.8C1.1 45.9 13.8 33.1 30.3 31.1l387.4 0c.2 0 .5 .9 .7 .9zM30.3 41.3C19 42 10 51 9.3 62.4l0 387.3c.4 5.4 2.7 10.5 6.4 14.3 3.8 3.9 8.8 6.3 14.2 6.7l388.2 0c11.5-1 20.6-11.6 20.6-22.6l0-384.2c0-5.7-2.1-11.3-6-15.5s-9.3-6.8-15-7.2l-387.4 0z"]
  };
  var faPython = {
    prefix: 'fab',
    iconName: 'python',
    icon: [448, 512, [], "f3e2", "M439.8 200.5c-7.7-30.9-22.3-54.2-53.4-54.2l-40.1 0 0 47.4c0 36.8-31.2 67.8-66.8 67.8l-106.8 0c-29.2 0-53.4 25-53.4 54.3l0 101.8c0 29 25.2 46 53.4 54.3 33.8 9.9 66.3 11.7 106.8 0 26.9-7.8 53.4-23.5 53.4-54.3l0-40.7-106.7 0 0-13.6 160.2 0c31.1 0 42.6-21.7 53.4-54.2 11.2-33.5 10.7-65.7 0-108.6zM286.2 444.7a20.4 20.4 0 1 1 0-40.7 20.4 20.4 0 1 1 0 40.7zM167.8 248.1l106.8 0c29.7 0 53.4-24.5 53.4-54.3l0-101.9c0-29-24.4-50.7-53.4-55.6-35.8-5.9-74.7-5.6-106.8 .1-45.2 8-53.4 24.7-53.4 55.6l0 40.7 106.9 0 0 13.6-147 0c-31.1 0-58.3 18.7-66.8 54.2-9.8 40.7-10.2 66.1 0 108.6 7.6 31.6 25.7 54.2 56.8 54.2l36.7 0 0-48.8c0-35.3 30.5-66.4 66.8-66.4zM161.2 64.7a20.4 20.4 0 1 1 0 40.8 20.4 20.4 0 1 1 0-40.8z"]
  };
  var faCashApp = {
    prefix: 'fab',
    iconName: 'cash-app',
    icon: [448, 512, [], "e7d4", "M440.3 96.9c-9.4-26.5-30.3-47.4-56.8-57-24.1-7.9-46.3-7.9-91.6-7.9L156 32c-44.8 0-67.2 0-91.3 7.5-26.5 9.6-47.4 30.5-57 57-7.7 24.3-7.7 46.7-7.7 91.7L0 323.8c0 45.2 0 67.4 7.5 91.5 9.6 26.5 30.5 47.4 57 57 24.3 7.7 46.7 7.7 91.6 7.7l135.7 0c45 0 67.4 0 91.6-7.7 26.5-9.6 47.4-30.5 57-57 7.7-24.3 7.7-46.7 7.7-91.5l0-135.5c0-45 0-67.4-7.7-91.5zM323.1 185.4l-25.8 21.1c-2.3 1.9-5.5 1.5-7.3-.9-13.2-16.2-33.7-25.4-56.1-25.4-25 0-40.6 10.9-40.6 26.2-.4 12.8 11.7 19.6 49.1 27.7 47.2 10 68.7 29.7 68.7 62.7 0 41.4-33.7 71.9-86.4 75.3l-5.1 24.5c-.4 2.3-2.6 4.1-5.1 4.1l-40.6 0c-3.4 0-5.8-3.2-5.1-6.4l6.4-27.3c-26-7.5-47.2-22-59.3-39.7-1.5-2.3-1.1-5.3 1.1-7l28.2-22c2.3-1.9 5.8-1.3 7.5 1.1 14.9 20.9 38 33.3 65.7 33.3 25 0 43.8-12.2 43.8-29.7 0-13.4-9.4-19.6-41.2-26.2-54.2-11.7-75.8-31.8-75.8-64.9 0-38.4 32.2-67.2 80.9-71l5.3-25.4c.4-2.3 2.6-4.1 5.1-4.1l39.9 0c3.2 0 5.8 3 5.1 6.2l-6.2 28.4c20.9 6.4 38 17.9 48.7 32.2 1.7 2.1 1.3 5.3-.9 7z"]
  };
  var faPinterestP = {
    prefix: 'fab',
    iconName: 'pinterest-p',
    icon: [384, 512, [], "f231", "M204 6.5c-102.6 0-204 68.4-204 179.1 0 70.4 39.6 110.4 63.6 110.4 9.9 0 15.6-27.6 15.6-35.4 0-9.3-23.7-29.1-23.7-67.8 0-80.4 61.2-137.4 140.4-137.4 68.1 0 118.5 38.7 118.5 109.8 0 53.1-21.3 152.7-90.3 152.7-24.9 0-46.2-18-46.2-43.8 0-37.8 26.4-74.4 26.4-113.4 0-66.2-93.9-54.2-93.9 25.8 0 16.8 2.1 35.4 9.6 50.7-13.8 59.4-42 147.9-42 209.1 0 18.9 2.7 37.5 4.5 56.4 3.4 3.8 1.7 3.4 6.9 1.5 50.4-69 48.6-82.5 71.4-172.8 12.3 23.4 44.1 36 69.3 36 106.2 0 153.9-103.5 153.9-196.8 0-99.3-85.8-164.1-180-164.1z"]
  };
  var faWhmcs = {
    prefix: 'fab',
    iconName: 'whmcs',
    icon: [448, 512, [], "f40d", "M448 161l0-21.3-28.5-8.8-2.2-10.4 20.1-20.7-10.4-19.4-29 7.5-7.2-7.5 7.5-28.2-19.1-11.6-21.3 21-10.7-3.2-7-26.4-22.6 0-6.2 26.4-12.1 3.2-19.7-21-19.4 11 8.1 27.7-8.1 8.4-28.5-7.5-11 19.1 20.7 21-2.9 10.4-28.5 7.8-.3 21.7 28.8 7.5 2.4 12.1-20.1 19.9 10.4 18.5 29.6-7.5 7.2 8.6-8.1 26.9 19.9 11.6 19.4-20.4 11.6 2.9 6.7 28.5 22.6 .3 6.7-28.8 11.6-3.5 20.7 21.6 20.4-12.1-8.8-28 7.8-8.1 28.8 8.8 10.3-20.1-20.9-18.8 2.2-12.1 29.1-7zM328.8 92.6a56.8 56.8 0 1 1 0 113.6 56.8 56.8 0 1 1 0-113.6zm72.3 130l46.9 14.5 0 39.9-55.1 13.4-4.1 22.7 38.9 35.3-19.2 37.9-54-16.7-14.6 15.2 16.7 52.5-38.3 22.7-38.9-40.5-21.7 6.6-12.6 54-42.4-.5-12.6-53.6-21.7-5.6-36.4 38.4-37.4-21.7 15.2-50.5-13.7-16.1-55.5 14.1-19.7-34.8 37.9-37.4-4.8-22.8-54-14.1 .5-40.9 53.5-14.7 5.7-19.7-38.9-39.4 20.7-35.8 53.6 14.1 15.2-15.7-15.2-52 36.4-20.7 36.8 39.4 22.7-6.1 11.6-52 42.4 0 11.6 45.9-22.6-5.9-6.3-1.7-3.3 5.7-11 19.1-3.3 5.6 4.6 4.6 17.2 17.4-.3 1-23.8 6.5-6.2 1.7c0 3.2-.1 9.6-.3 19.3-47.5 10.4-83.3 52.8-83.3 103.5 0 58.3 47.3 105.7 105.7 105.7 50.5 0 92.7-35.4 103.2-82.8 9.9 .1 16.6 .2 20.1 .3l1.6-6.7 5.6-24 1.9-.6 17.1 17.8 4.7 4.9 5.8-3.4 20.4-12.1 5.8-3.5-2-6.5-6.8-21.2z"]
  };
  var faJoget = {
    prefix: 'fab',
    iconName: 'joget',
    icon: [512, 512, [], "f3b7", "M386.1 45C345.6 19.9 300.6 8 256.2 8 173 8 91.8 49.9 44.9 125.9-27 242.5 9.3 395.2 125.9 467.1s269.3 35.6 341.2-80.9C539 269.6 502.7 116.8 386.1 45zm51.8 323.2c-40.4 65.5-110.4 101.5-182 101.5-6.8 0-13.6-.4-20.4-1-9-13.6-19.9-33.3-23.7-42.4-5.7-13.7-27.2-45.6 31.2-67.1 51.7-19.1 176.7-16.5 208.8-17.6-4 9-8.6 17.9-13.9 26.6zM237.1 281.9c-55.5-1.4-81.7-20.8-58.5-48.2s51.1-40.7 68.9-51.2c17.9-10.5 27.3-33.7-23.6-29.7-128.6 8.7-167.3 99.3-178.3 140.2-8.8-49.7-.1-102.7 28.5-149.1 61.9-100.5 193.5-131.7 294-69.8 74.8 46.1 111.2 130.9 99.3 212.7-24.9-.5-179.3-3.6-230.3-4.9zm183.8-54.8c-22.7-6-57 11.3-86.7 27.2-29.7 15.8-31.1 8.2-31.1 8.2s40.2-28.1 50.7-34.5 31.9-14 13.4-24.6c-3.2-1.8-6.7-2.7-10.4-2.7-17.8 0-41.5 18.7-67.5 35.6-31.5 20.5-65.3 31.3-65.3 31.3L393.5 266 440 242.6s3.6-9.5-19.1-15.5z"]
  };
  var faSquareYoutube = {
    prefix: 'fab',
    iconName: 'square-youtube',
    icon: [448, 512, [61798, "youtube-square"], "f431", "M282 256.2l-95.2-54.1 0 108.2 95.2-54.1zM384 32L64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64zm14.4 136.1c7.6 28.6 7.6 88.2 7.6 88.2s0 59.6-7.6 88.1c-4.2 15.8-16.5 27.7-32.2 31.9-28.3 7.7-142.2 7.7-142.2 7.7s-113.9 0-142.2-7.6c-15.7-4.2-28-16.1-32.2-31.9-7.6-28.6-7.6-88.2-7.6-88.2s0-59.7 7.6-88.2c4.2-15.8 16.5-28.2 32.2-32.4 28.3-7.7 142.2-7.7 142.2-7.7s113.9 0 142.2 7.7c15.7 4.2 28 16.6 32.2 32.4z"]
  };
  var faYoutubeSquare = faSquareYoutube;
  var faAtlassian = {
    prefix: 'fab',
    iconName: 'atlassian',
    icon: [512, 512, [], "f77b", "M152.2 236.4c-7.7-8.2-19.7-7.7-24.8 2.8L1.6 490.2c-5 10 2.4 21.7 13.4 21.7l175 0c5.8 .1 11-3.2 13.4-8.4 37.9-77.8 15.1-196.3-51.2-267.1zM244.4 8.1c-122.3 193.4-8.5 348.6 65 495.5 2.5 5.1 7.7 8.4 13.4 8.4L497 512c11.2 0 18.4-11.8 13.4-21.7 0 0-234.5-470.6-240.4-482.3-5.3-10.6-18.8-10.8-25.6 .1z"]
  };
  var faPiedPiperHat = {
    prefix: 'fab',
    iconName: 'pied-piper-hat',
    icon: [640, 512, [], "f4e5", "M640 24.9c-80.8 53.6-89.4 92.5-96.4 104.4-6.7 12.2-11.7 60.3-23.3 83.6-11.7 23.6-54.2 42.2-66.1 50-11.7 7.8-28.3 38.1-41.9 64.2-108.1-4.4-167.4 38.8-259.2 93.6 29.4-9.7 43.3-16.7 43.3-16.7 94.2-36 139.3-68.3 281.1-49.2 1.1 0 1.9 .6 2.8 .8 3.9 2.2 5.3 6.9 3.1 10.8l-53.9 95.8c-2.5 4.7-7.8 7.2-13.1 6.1-126.8-23.8-226.9 17.3-318.9 18.6-73.4 1.1-97.5-33.5-97.5-35.1 0-1.1 .6-1.7 1.7-1.7 0 0 38.3 0 103.1-15.3 73.6-140.3 139.2-189.4 210.6-189.4 0 0 71.7 0 90.6 61.9 22.8-39.7 28.3-49.2 28.3-49.2 5.3-9.4 35-77.2 86.4-141.4 51.5-64 90.4-79.9 119.3-91.8z"]
  };
  var faInternetExplorer = {
    prefix: 'fab',
    iconName: 'internet-explorer',
    icon: [512, 512, [], "f26b", "M483.1 159.7c10.9-24.6 21.4-60.4 21.4-87.9 0-72.7-79.6-98.4-209.7-38.6-107.6-7.2-211.2 73.7-237.1 186.5 30.9-34.9 78.3-82.3 122-101.2-54.3 48.3-100.6 109.4-135.7 173.2-20.7 37.9-44 99.2-44 145 0 98.6 92.9 86.5 180.3 42 31.4 15.4 66.6 15.6 101.7 15.6 97.1 0 184.2-54.3 216.8-146l-120.8 0c-52.5 88.6-196.8 53-196.8-47.4l328.8 0c6.4-43.6-1.7-95.7-26.9-141.2zM64.6 346.9C82.3 398 118.3 442.7 164.8 470.2 76.1 519.1-8.4 499.3 64.6 346.9zM180.5 238c2-55.2 50.3-94.9 104-94.9 53.4 0 102 39.7 104 94.9l-208 0zM365.1 50.4c21.4-10.3 48.6-22 72.6-22 31.4 0 54.3 21.7 54.3 53.7 0 20-7.4 49-14.6 67.9-26.3-42.3-66-81.6-112.3-99.6z"]
  };
  var faAirbnb = {
    prefix: 'fab',
    iconName: 'airbnb',
    icon: [448, 512, [], "f834", "M224.5 373.1c-25.2-31.7-40.1-59.4-45-83.2-22.5-88 112.6-88 90.1 0-5.4 24.2-20.3 52-45 83.2l-.1 0zm138.2 73.2c-42.1 18.3-83.7-10.9-119.3-50.5 103.9-130.1 46.1-200-18.8-200-54.9 0-85.2 46.5-73.3 100.5 6.9 29.2 25.2 62.4 54.4 99.5-32.5 36-60.5 52.7-85.2 54.9-50 7.4-89.1-41.1-71.3-91.1 15.1-39.2 111.7-231.2 115.9-241.6 15.8-30.1 25.6-57.4 59.4-57.4 32.3 0 43.4 25.9 60.4 59.9 36 70.6 89.4 177.5 114.8 239.1 13.2 33.1-1.4 71.3-37 86.6zm47-136.1c-128.9-274.3-136-278.2-185.1-278.2-45.5 0-64.9 31.7-84.7 72.8-106.2 212.3-116.4 242.4-117.3 245-25.2 69.3 26.7 130.2 89.6 130.2 21.7 0 60.6-6.1 112.4-62.4 58.7 63.8 101.3 62.4 112.4 62.4 62.9 .1 114.9-60.9 89.6-130.2 0-3.9-16.8-38.9-16.8-39.6l0 0z"]
  };
  var faJs = {
    prefix: 'fab',
    iconName: 'js',
    icon: [448, 512, [], "f3b8", "M0 32l0 448 448 0 0-448-448 0zM243.8 381.4c0 43.6-25.6 63.5-62.9 63.5-33.7 0-53.2-17.4-63.2-38.5L152 385.7c6.6 11.7 12.6 21.6 27.1 21.6 13.8 0 22.6-5.4 22.6-26.5l0-143.1 42.1 0 0 143.7zm99.6 63.5c-39.1 0-64.4-18.6-76.7-43L301 382.1c9 14.7 20.8 25.6 41.5 25.6 17.4 0 28.6-8.7 28.6-20.8 0-14.4-11.4-19.5-30.7-28l-10.5-4.5c-30.4-12.9-50.5-29.2-50.5-63.5 0-31.6 24.1-55.6 61.6-55.6 26.8 0 46 9.3 59.8 33.7L368 290c-7.2-12.9-15-18-27.1-18-12.3 0-20.1 7.8-20.1 18 0 12.6 7.8 17.7 25.9 25.6l10.5 4.5c35.8 15.3 55.9 31 55.9 66.2 0 37.8-29.8 58.6-69.7 58.6z"]
  };
  var faQuinscape = {
    prefix: 'fab',
    iconName: 'quinscape',
    icon: [512, 512, [], "f459", "M313.7 474.6l-1 0c-41.9 0-82.1-16.7-111.8-46.3s-46.3-69.9-46.3-111.8 16.7-82.1 46.3-111.8 69.9-46.3 111.8-46.3c94.9 0 168.2 83.1 157 176.6 4 5.1 8.2 9.6 11.2 15.3 13.4-30.3 20.3-62.4 20.3-97.7 0-135.1-109.5-244.6-244.6-244.6S12.1 117.5 12.1 252.6 121.6 497.2 256.6 497.2c23.8 .2 47.6-3.2 70.4-10.1-5.2-3.5-8.9-8.1-13.3-12.5zm78.3-169a99.2 99.2 0 1 0 0 198.4 99.2 99.2 0 1 0 0-198.4z"]
  };
  var faAdversal = {
    prefix: 'fab',
    iconName: 'adversal',
    icon: [512, 512, [], "f36a", "M482.1 32L28.7 32C5.8 32 0 37.9 0 60.9L0 451.1C0 474.4 5.8 480 28.7 480l453.4 0c24.4 0 29.9-5.2 29.9-29.7l0-388.1c0-24.6-5.4-30.2-29.9-30.2zM178.4 220.3c-27.5-20.2-72.1-8.7-84.2 23.4-4.3 11.1-9.3 9.5-17.5 8.3-9.7-1.5-17.2-3.2-22.5-5.5-28.8-11.4 8.6-55.3 24.9-64.3 41.1-21.4 83.4-22.2 125.3-4.8 40.9 16.8 34.5 59.2 34.5 128.5 2.7 25.8-4.3 58.3 9.3 88.8 1.9 4.4 .4 7.9-2.7 10.7-8.4 6.7-39.3 2.2-46.6-7.4-1.9-2.2-1.8-3.6-3.9-6.2-3.6-3.9-7.3-2.2-11.9 1-57.4 36.4-140.3 21.4-147-43.3-3.1-29.3 12.4-57.1 39.6-71 38.2-19.5 112.2-11.8 114-30.9 1.1-10.2-1.9-20.1-11.3-27.3zm286.7 222c0 15.1-11.1 9.9-17.8 9.9l-394.9 0c-7.4 0-18.2 4.8-17.8-10.7 .4-13.9 10.5-9.1 17.1-9.1 132.3-.4 264.5-.4 396.8 0 6.8 0 16.6-4.4 16.6 9.9zm3.8-340.5l0 291c0 5.7-.7 13.9-8.1 13.9-12.4-.4-27.5 7.1-36.1-5.6-5.8-8.7-7.8-4-12.4-1.2-53.4 29.7-128.1 7.1-144.4-85.2-6.1-33.4-.7-67.1 15.7-100 11.8-23.9 56.9-76.1 136.1-30.5l0-71c0-26.2-.1-26.2 26-26.2 3.1 0 6.6 .4 9.7 0 10.1-.8 13.6 4.4 13.6 14.3-.1 .2-.1 .3-.1 .5zM417.4 334.1c-19.5 47.6-72.9 43.3-90 5.2-15.1-33.3-15.5-68.2 .4-101.5 16.3-34.1 59.7-35.7 81.5-4.8 20.6 28.8 14.9 84.6 8.1 101.1zM122.6 369.4c-7.5-1.3-33-3.3-33.7-27.8-.4-13.9 7.8-23 19.8-25.8 24.4-5.9 49.3-9.9 73.7-14.7 8.9-2 7.4 4.4 7.8 9.5 1.4 33-26.1 59.2-67.6 58.8z"]
  };
  var faCreativeCommons = {
    prefix: 'fab',
    iconName: 'creative-commons',
    icon: [512, 512, [], "f25e", "M253.8 214.9l-33.2 17.3c-9.4-19.6-25.2-19.9-27.5-19.9-22.1 0-33.2 14.6-33.2 43.8 0 23.6 9.2 43.8 33.2 43.8 14.5 0 24.6-7.1 30.6-21.3l30.6 15.5c-6.2 11.5-25.7 39-65.1 39-22.6 0-74-10.3-74-77 0-58.7 43-77.1 72.6-77.1 30.7 0 52.7 11.9 66 35.9zm143 0l-32.8 17.3c-9.5-19.8-25.7-19.9-27.9-19.9-22.1 0-33.2 14.6-33.2 43.8 0 23.5 9.2 43.8 33.2 43.8 14.4 0 24.6-7.1 30.5-21.3l31 15.5c-2.1 3.8-21.4 39-65.1 39-22.7 0-74-9.9-74-77 0-58.7 43-77.1 72.6-77.1 30.7 0 52.6 11.9 65.6 35.9zM255.6 8C112.7 8 8 123.1 8 256.1 8 394.5 121.6 504.1 255.6 504.1 385.5 504.1 504 403.2 504 256.1 504 118.2 397.4 8 255.6 8zm.9 450.8c-112.5 0-203.7-93-203.7-202.8 0-105.4 85.4-203.3 203.7-203.3 112.5 0 202.8 89.5 202.8 203.3 0 121.7-99.7 202.8-202.8 202.8z"]
  };
  var faNotion = {
    prefix: 'fab',
    iconName: 'notion',
    icon: [512, 512, [], "e7d9", "M94.9 100.2c14.9 12.1 20.5 11.2 48.6 9.3L407.8 93.6c5.6 0 .9-5.6-.9-6.5L362.9 55.4c-8.4-6.5-19.6-14-41.1-12.1L65.9 61.9c-9.3 .9-11.2 5.6-7.5 9.3l36.4 28.9zm15.9 61.6l0 278.1c0 14.9 7.5 20.5 24.3 19.6l290.5-16.8c16.8-.9 18.7-11.2 18.7-23.3l0-276.2c0-12.1-4.7-18.7-15-17.7L125.7 143.1c-11.2 .9-14.9 6.5-14.9 18.7zm286.7 14.9c1.9 8.4 0 16.8-8.4 17.8l-14 2.8 0 205.3c-12.2 6.5-23.4 10.3-32.7 10.3-15 0-18.7-4.7-29.9-18.7l-91.5-143.7 0 139 29 6.5s0 16.8-23.4 16.8l-64.4 3.7c-1.9-3.7 0-13.1 6.5-14.9l16.8-4.7 0-183.8-23.3-1.9c-1.9-8.4 2.8-20.5 15.9-21.5l69.1-4.7 95.3 145.6 0-128.8-24.3-2.8c-1.9-10.3 5.6-17.7 14.9-18.7l64.5-3.8zM44.4 36.7L310.6 17.1c32.7-2.8 41.1-.9 61.6 14l85 59.7c14 10.3 18.7 13.1 18.7 24.3l0 327.6c0 20.5-7.5 32.7-33.6 34.5L133.2 495.8c-19.6 .9-29-1.9-39.2-14.9L31.4 399.7c-11.2-14.9-15.9-26.1-15.9-39.2l0-291.2c0-16.8 7.5-30.8 28.9-32.7z"]
  };
  var faChromecast = {
    prefix: 'fab',
    iconName: 'chromecast',
    icon: [512, 512, [], "f838", "M448 64L64.2 64c-23.6 0-42.7 19.1-42.7 42.7l0 63.9 42.7 0 0-63.9 383.8 0 0 298.6-149.2 0 0 42.7 149.4 0c23.6 0 42.7-19.1 42.7-42.7l0-298.6C490.9 83.1 471.6 64 448 64zM21.5 383.6l0 63.9 63.9 0c0-35.3-28.6-63.9-63.9-63.9zm0-85l0 42.4c58.9 0 106.6 48.1 106.6 107l42.7 0c.1-82.4-66.9-149.3-149.3-149.4zM213.6 448l42.7 0C255.8 318.5 151 213.7 21.5 213.4l0 42.4c106-.2 192 86.2 192.1 192.2z"]
  };
  var faWikipediaW = {
    prefix: 'fab',
    iconName: 'wikipedia-w',
    icon: [640, 512, [], "f266", "M640 51.2l-.3 12.2c-28.1 .8-45 15.8-55.8 40.3-25 57.8-103.3 240-155.3 358.6l-13.6 0-81.9-193.1c-32.5 63.6-68.3 130-99.2 193.1-.3 .3-15 0-15-.3-46.9-109.7-96.1-218.6-143.1-328.6-11.4-26.7-49.4-70-75.6-69.7 0-3.1-.3-10-.3-14.2l161.9 0 0 13.9c-19.2 1.1-52.8 13.3-43.3 34.2 21.9 49.7 103.6 240.3 125.6 288.6 15-29.7 57.8-109.2 75.3-142.8-13.9-28.3-58.6-133.9-72.8-160-9.7-17.8-36.1-19.4-55.8-19.7l0-13.9 142.5 .3 0 13.1c-19.4 .6-38.1 7.8-29.4 26.1 18.9 40 30.6 68.1 48.1 104.7 5.6-10.8 34.7-69.4 48.1-100.8 8.9-20.6-3.9-28.6-38.6-29.4 .3-3.6 0-10.3 .3-13.6 44.4-.3 111.1-.3 123.1-.6l0 13.6C462.4 64 439.1 76 426.8 94.9L367.6 217.7c6.4 16.1 63.3 142.8 69.2 156.7L559.2 91.8c-8.6-23.1-36.4-28.1-47.2-28.3l0-13.9 127.8 1.1 .2 .5z"]
  };
  var faSitrox = {
    prefix: 'fab',
    iconName: 'sitrox',
    icon: [448, 512, [], "e44a", "M212.4 0l0 0 235.6 0 0 128-384 0C64 57.6 141.8 .5 212.4 0zm24.8 192l0 0c69.9 .5 146.7 57.6 146.7 128l-173.2 0 0 0C140.9 319.6 64 262.4 64 192l173.3 0zm-1.7 320c70.7-.5 148.4-57.6 148.4-128l-384 0 0 128 235.6 0 0 0z"]
  };
  var faSquareGitlab = {
    prefix: 'fab',
    iconName: 'square-gitlab',
    icon: [448, 512, ["gitlab-square"], "e5ae", "M0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32C28.7 32 0 60.7 0 96zm337.5 12.5l44.6 116.4 .4 1.2c5.6 16.8 7.2 35.2 2.3 52.5-5 17.2-15.4 32.4-29.8 43.3l-.2 .1-68.4 51.2-54.1 40.9c-.5 .2-1.1 .5-1.7 .8-2 1-4.4 2-6.7 2-3 0-6.8-1.8-8.3-2.8l-54.2-40.9-67.9-50.9-.4-.3-.2-.1c-14.3-10.8-24.8-26-29.7-43.3s-4.2-35.7 2.2-52.5l.5-1.2 44.7-116.4c.9-2.3 2.5-4.3 4.5-5.6 1.6-1 3.4-1.6 5.2-1.8 1.3-.7 2.1-.4 3.4 .1 .6 .2 1.2 .5 2 .7 1 .4 1.6 .9 2.4 1.5 .6 .4 1.2 1 2.1 1.5 1.2 1.4 2.2 3 2.7 4.8l29.2 92.2 122.9 0 30.2-92.2c.5-1.8 1.4-3.4 2.6-4.8s2.8-2.4 4.5-3.1c1.7-.6 3.6-.9 5.4-.7s3.6 .8 5.2 1.8c2 1.3 3.7 3.3 4.6 5.6z"]
  };
  var faGitlabSquare = faSquareGitlab;
  var faShoelace = {
    prefix: 'fab',
    iconName: 'shoelace',
    icon: [512, 512, [], "e60c", "M405.2 331c2.2-1.1 4.4-2.3 6.5-3.7l8.3-4.8c1.5-1.1 4.4-3.4 8.7-6.7l.5-.5c3.4-3.4 7.2-5 11.3-4.9 1.8 0 3.9 .5 6.4 1.5l31-27.5c.9-.7 1.7-1.3 2.6-1.8l.2 0c3.3-1.9 6-1.8 8.2 .4 3.9 2.1 4.2 5.6 .9 10.6L457.2 322c.2 .5 .4 1 .4 1.5 .5 2.2 .3 4.4-.5 6.6-.7 1.5-1.8 2.9-3.1 4.2-1.4 1.4-2.7 2.8-4.2 4.2L431 352.2c-1.7 1.2-3.4 2.3-5.1 3.3-2.1 1.3-4.3 2.5-6.6 3.6-1 .4-1.9 .9-2.9 1.3-5.9 2.5-11.9 4.2-18.2 5-2.9 24.5-11.3 47.1-25.1 67.8-17.5 25.7-41.4 45.4-71.8 58.8-30.2 13.5-63 20.2-98.2 20.2-48.6-.5-88-11.4-118.2-32.8-35.1-25-52.6-57.9-52.6-99.1l0-5.6c1.2-28.1 9.5-54.6 24.8-79.8 15.1-24.9 37.1-41.7 66.1-50.5 14.9-4.4 29.9-6.6 45-6.6 15.5 0 31.6 2.9 48.1 8.6s35.2 15.5 55.9 29.5l54.1 36.3c15.1 9.8 28.8 16.5 41.2 20-2.6-25.1-11.7-46.6-27.3-64.5-15.7-18.1-35.6-31.3-59.9-39.7L257 220c-21.4-7.5-37.3-14.9-47.7-22.2-28.2-19.1-43.8-45.2-47-78.5l-.5-9.8c0-32.1 13-58.9 39-80.5 23-19.3 50.6-29 82.5-29 24 0 45.6 6.9 64.7 20.8 19.2 14 30.1 33.8 32.6 59.4l.5 10c0 18.6-4.8 34.5-14.4 47.7-9.8 13.2-18.5 19.9-26 19.9-1.6-.1-3.1-.3-4.5-.6l-34 32c-5.5 3-9.2 2.5-11.1-1.6-1.9-2.2-1.8-4.9 .5-8.2l.2-.2c.5-.7 1.2-1.5 2-2.4l31.6-30c-.4-1.5-.6-3.1-.6-4.8 0-4.1 1.6-7.6 4.9-10.4 13.8-12.4 20.8-26.7 20.8-42.8 0-16-6.1-29.5-18.2-40.4s-28.7-16.5-49.7-16.8c-26.2 0-47.8 7.9-64.7 23.7S192.6 89.9 192.6 112c0 17.8 6.9 33.9 20.6 48.3 13.6 14.2 34.6 25.4 63 33.5 39.8 11.5 70.2 31 91.3 58.3 18.7 24.2 29.1 51.3 31.3 81.4 2.2-.7 4.3-1.5 6.5-2.6l-.1 .1zM294.4 178.7c0 1.1 .6 1.6 1.8 1.6 .1 0 9.7-8.9 28.8-26.6 0-2.4-5.1 .9-15.3 10-10.2 9.2-15.3 14.2-15.3 14.9l0 .1zm8 6.4c0-1-.5-1.5-1.5-1.5-1.1 0-2.1 .5-2.9 1.6-1.9-.1-3.3 .1-4.2 .7-.4 .2-.5 .5-.5 .7 0 .7 .5 1.3 1.5 1.6l3.3 0c2.9-1.1 4.4-2.2 4.4-3.3l-.1 .2zM325 165.2c0-2.8-1.6-2.8-4.9 0-1.6 1.5-3.6 3.5-6 6.2-.8 .6-2.6 2.2-5.3 4.9-2.8 2.9-4.2 4.7-4.2 5.3l.2 1.3c.7 .2 1.2 .4 1.5 .4 .1 0 3.3-2.9 9.5-8.7s9.3-8.9 9.3-9.3l-.1-.1zm159.7 120l-30.6 27c1.8 1 3.2 2.4 4 4.2l30.2-27c.2-1.2 .1-2.2-.5-2.9-.6-.5-1.6-.9-3.1-1.3zm-1.6-.9l-.7-.7-27 21.9 1.6 2 26-23.1 .1-.1zM366.9 363.9c-8-2.1-15.4-4.6-22.2-7.5-15.3-6.2-34.3-17-57-32.4l-37.4-25.3c-15.8-10.1-30.2-17.6-43.2-22.6-13.1-4.9-26-7.3-38.6-7.3l-5.5 0c-32.2 1.7-57.2 13.8-75 36.2-16.6 20.8-25 45.3-25 73.6 0 31.8 12.8 56.7 38.2 74.7 25.4 18.1 60.2 27.1 104.4 27.1 34.7 0 64-6.2 87.8-18.6 23.7-12.4 42.1-28.8 55.2-49.2 9.8-15.5 15.9-31.8 18.2-48.8l.1 .1z"]
  };
  var faSellcast = {
    prefix: 'fab',
    iconName: 'sellcast',
    icon: [448, 512, [], "f2da", "M353.5 32L94.8 32C42.7 32 .1 74.6 .1 126.6l0 258.7C.1 437.4 42.7 480 94.8 480l258.7 0c52.1 0 94.7-42.6 94.7-94.6l0-258.8c0-52-42.6-94.6-94.7-94.6zm-50 316.4c-27.9 48.2-89.9 64.9-138.2 37.2-22.9 39.8-54.9 8.6-42.3-13.2l15.7-27.2c5.9-10.3 19.2-13.9 29.5-7.9 18.6 10.8-.1-.1 18.5 10.7 27.6 15.9 63.4 6.3 79.4-21.3 15.9-27.6 6.3-63.4-21.3-79.4-17.8-10.2-.6-.4-18.6-10.6-24.6-14.2-3.4-51.9 21.6-37.5 18.6 10.8-.1-.1 18.5 10.7 48.4 28 65.1 90.3 37.2 138.5zm21.8-208.8c-17 29.5-16.3 28.8-19 31.5-6.5 6.5-16.3 8.7-26.5 3.6-18.6-10.8 .1 .1-18.5-10.7-27.6-15.9-63.4-6.3-79.4 21.3s-6.3 63.4 21.3 79.4c0 0 18.5 10.6 18.6 10.6 24.6 14.2 3.4 51.9-21.6 37.5-18.6-10.8 .1 .1-18.5-10.7-48.2-27.8-64.9-90.1-37.1-138.4 27.9-48.2 89.9-64.9 138.2-37.2l4.8-8.4c14.3-24.9 52-3.3 37.7 21.5z"]
  };
  var faMix = {
    prefix: 'fab',
    iconName: 'mix',
    icon: [448, 512, [], "f3cb", "M0 64L0 412.9c0 56.2 88 58.1 88 0l0-238.6c7.9-52.9 88-50.4 88 6.5l0 175.3c0 57.9 96 58 96 0L272 240c5.3-54.7 88-52.5 88 4.3l0 23.8c0 59.9 88 56.6 88 0L448 64 0 64z"]
  };
  var faCcApplePay = {
    prefix: 'fab',
    iconName: 'cc-apple-pay',
    icon: [576, 512, [], "f416", "M302.2 218.4c0 17.2-10.5 27.1-29 27.1l-24.3 0 0-54.2 24.4 0c18.4 0 28.9 9.8 28.9 27.1zM349.7 281c0 8.3 7.2 13.7 18.5 13.7 14.4 0 25.2-9.1 25.2-21.9l0-7.7-23.5 1.5c-13.3 .9-20.2 5.8-20.2 14.4zM576 79l0 352c0 26.5-21.5 48-48 48L48 479c-26.5 0-48-21.5-48-48L0 79C0 52.5 21.5 31 48 31l480 0c26.5 0 48 21.5 48 48zM127.8 197.2c8.4 .7 16.8-4.2 22.1-10.4 5.2-6.4 8.6-15 7.7-23.7-7.4 .3-16.6 4.9-21.9 11.3-4.8 5.5-8.9 14.4-7.9 22.8zm60.6 74.5c-.2-.2-19.6-7.6-19.8-30-.2-18.7 15.3-27.7 16-28.2-8.8-13-22.4-14.4-27.1-14.7-12.2-.7-22.6 6.9-28.4 6.9-5.9 0-14.7-6.6-24.3-6.4-12.5 .2-24.2 7.3-30.5 18.6-13.1 22.6-3.4 56 9.3 74.4 6.2 9.1 13.7 19.1 23.5 18.7 9.3-.4 13-6 24.2-6 11.3 0 14.5 6 24.3 5.9 10.2-.2 16.5-9.1 22.8-18.2 6.9-10.4 9.8-20.4 10-21zm135.4-53.4c0-26.6-18.5-44.8-44.9-44.8l-51.2 0 0 136.4 21.2 0 0-46.6 29.3 0c26.8 0 45.6-18.4 45.6-45zm90 23.7c0-19.7-15.8-32.4-40-32.4-22.5 0-39.1 12.9-39.7 30.5l19.1 0c1.6-8.4 9.4-13.9 20-13.9 13 0 20.2 6 20.2 17.2l0 7.5-26.4 1.6c-24.6 1.5-37.9 11.6-37.9 29.1 0 17.7 13.7 29.4 33.4 29.4 13.3 0 25.6-6.7 31.2-17.4l.4 0 0 16.4 19.6 0 0-68 .1 0zM516 210.9l-21.5 0-24.9 80.6-.4 0-24.9-80.6-22.3 0 35.9 99.3-1.9 6c-3.2 10.2-8.5 14.2-17.9 14.2-1.7 0-4.9-.2-6.2-.3l0 16.4c1.2 .4 6.5 .5 8.1 .5 20.7 0 30.4-7.9 38.9-31.8L516 210.9z"]
  };
  var faBrave = {
    prefix: 'fab',
    iconName: 'brave',
    icon: [448, 512, [], "e63c", "M145.6 0l157 0 44.7 50.8s39.3-10.9 57.8 7.6 33.8 34.9 33.8 34.9l-12 29.5 15.3 43.7s-44.9 170.2-50.1 191c-10.4 40.9-17.4 56.8-46.9 77.5s-82.9 56.8-91.6 62.2c-1.9 1.2-3.9 2.5-5.9 3.9-7.5 5.1-15.8 10.8-23.5 10.8s-16.1-5.7-23.5-10.8c-2-1.4-4-2.8-5.9-3.9-8.7-5.5-62.1-41.5-91.6-62.2s-36.5-36.6-46.9-77.5c-5.3-20.8-50.1-191-50.1-191L21.5 122.8 9.3 93.3s15.3-16.4 33.8-34.9 57.8-7.6 57.8-7.6L145.6 0zm78.5 407.6c3.7 0 8.9-4.7 13-8.4 .6-.5 1.2-1.1 1.7-1.5 4.2-3.7 47.8-37.5 51-39.8s5.4-6.5 1.9-8.7c-2.8-1.7-10-5.5-20.3-10.8-3-1.6-6.3-3.2-9.7-5-15.4-8-34.5-14.7-37.5-14.7s-22.1 6.8-37.5 14.7c-3.5 1.8-6.7 3.5-9.7 5-10.3 5.3-17.6 9.1-20.3 10.8-3.6 2.2-1.4 6.4 1.9 8.7s46.8 36.1 51 39.8c.5 .5 1.1 1 1.7 1.5 4.1 3.7 9.3 8.4 13 8.4l-.2 0zm0-165.7c4.7 0 17.6-3 26.4-5l2-.5c7.8-1.8 7.3-6.3 6.4-13-.1-.8-.2-1.6-.3-2.4-.6-6.1-5.8-33.1-9.1-50.3-1.1-5.8-2-10.5-2.4-12.9-1.5-8.1-.6-9.4 .7-11.3 .2-.3 .5-.7 .7-1.1 1.4-2.3 16-6.2 27.9-9.5 2.5-.7 4.8-1.3 6.9-1.9 10.6-3 32.4-.6 44.2 .6 1.8 .2 3.4 .4 4.7 .5 9.6 .9 10.4 2.3 7.2 3.8-2.3 1.1-16.2 6.3-28.7 10.9-4.7 1.8-9.2 3.5-12.8 4.8-1.5 .5-3 1.1-4.5 1.7-12.5 4.6-27.2 10-28.9 19.4-1.5 8.3 5.2 19.9 11.3 30.3 1.6 2.8 3.2 5.5 4.6 8.1 6.3 11.9 6.5 13.3 6.1 18.1-.4 3.9-14.5 12.7-22.4 17.6-1.8 1.1-3.3 2.1-4.2 2.7-.8 .5-2.1 1.4-3.8 2.4-8.6 5.2-26.3 16-26.3 22.5 0 7.8 24.6 28.1 32.4 33.2s28.9 16.1 37.9 17.8 23-8.5 31.2-23.8c7.7-14.4 1.7-28.5-3.2-40l-.9-2.2c-4.5-10.6 1.9-17 6.2-21.3 .5-.5 1-1 1.4-1.4l43-45.7c1.3-1.3 2.5-2.6 3.7-3.8 5.8-5.7 10.8-10.5 10.8-22.8 0-14.9-57.5-84.5-57.5-84.5s-48.5 9.3-55.1 9.3c-5.2 0-15.3-3.5-25.8-7.1-2.7-.9-5.4-1.9-8-2.7-13-4.3-21.8-4.4-21.8-4.4s-8.7 0-21.8 4.4c-2.7 .9-5.4 1.8-8 2.7-10.5 3.6-20.6 7.1-25.8 7.1-6.5 0-55.1-9.3-55.1-9.3s-57.5 69.6-57.5 84.5c0 12.3 4.9 17.1 10.8 22.8 1.2 1.2 2.5 2.4 3.7 3.8l43.1 45.8c.4 .5 .9 .9 1.4 1.4 4.3 4.3 10.6 10.7 6.2 21.3l-.9 2.2c-4.9 11.5-11 25.6-3.2 40 8.2 15.3 22.2 25.5 31.2 23.8s30.1-12.7 37.9-17.8 32.4-25.4 32.4-33.2c0-6.5-17.7-17.3-26.3-22.5-1.7-1-3.1-1.9-3.8-2.4-.9-.6-2.4-1.5-4.2-2.7-7.9-4.9-22-13.7-22.4-17.6-.4-4.8-.3-6.2 6.1-18.1 1.3-2.5 2.9-5.3 4.6-8.1 6-10.4 12.8-22 11.3-30.3-1.7-9.4-16.4-14.8-28.9-19.4-1.6-.6-3.1-1.1-4.5-1.7-3.6-1.4-8.1-3.1-12.8-4.8l-.1 0c-12.5-4.7-26.4-9.9-28.7-10.9-3.2-1.5-2.3-2.8 7.2-3.8 1.3-.1 2.9-.3 4.7-.5 11.8-1.3 33.6-3.6 44.2-.6 2.1 .6 4.4 1.2 6.9 1.9 11.9 3.2 26.5 7.2 27.9 9.5 .2 .4 .5 .7 .7 1.1 1.3 1.9 2.2 3.2 .7 11.3-.4 2.4-1.3 7.1-2.4 12.9-3.3 17.2-8.5 44.2-9.1 50.3-.1 .8-.2 1.7-.3 2.4-.8 6.7-1.4 11.2 6.4 13l2 .5c8.8 2 21.8 5 26.4 5l0-.1z"]
  };
  var faEtsy = {
    prefix: 'fab',
    iconName: 'etsy',
    icon: [384, 512, [], "f2d7", "M384 348c-1.8 10.7-13.8 110-15.5 132-117.9-4.3-219.9-4.7-368.5 0l0-25.5c45.5-8.9 60.6-8 61-35.2 1.8-72.3 3.5-244.1 0-322-1-28.5-12.1-26.8-61-36L0 35.8c73.9 2.4 255.9 8.6 363-3.8-3.5 38.2-7.8 126.5-7.8 126.5l-23.2 0C320.9 115.7 313.2 68 277.3 68l-137 0c-10.2 0-10.7 3.5-10.7 9.8l0 163.8c58 .5 88.5-2.5 88.5-2.5 29.8-1 27.6-8.5 40.7-65.3l25.8 0c-4.4 101.4-3.9 61.8-1.8 160.3L257 334c-9.2-40.1-9.1-61-39.5-61.5 0 0-21.5-2-88-2l0 139c0 26 14.3 38.3 44.3 38.3l89.3 0c63.6 0 66.6-25 98.7-99.8l22.2 0z"]
  };
  var faBtc = {
    prefix: 'fab',
    iconName: 'btc',
    icon: [384, 512, [], "f15a", "M310.4 242.6c27.7-14.2 45.4-39.4 41.3-81.3-5.4-57.4-52.5-76.6-114.8-81.9l0-79.4-48.5 0 0 77.2c-12.6 0-25.5 .3-38.4 .6l0-77.8-48.5 0 0 79.4c-17.8 .5-38.6 .3-97.4 0l0 51.7c38.3-.7 58.4-3.1 63 21.4l0 217.4c-2.9 19.5-18.5 16.7-53.3 16.1L4 443.7c88.5 0 97.4 .3 97.4 .3l0 68 48.5 0 0-67.1c13.2 .3 26.2 .3 38.4 .3l0 66.7 48.5 0 0-68c81.3-4.4 135.6-24.9 142.9-101.5 5.7-61.4-23.3-88.9-69.3-99.9zM150.8 134.6c27.4 0 113.1-8.5 113.1 48.5 0 54.5-85.7 48.2-113.1 48.2l0-96.7zm0 251.8l0-106.5c32.8 0 133.1-9.1 133.1 53.3 0 60.2-100.4 53.3-133.1 53.3z"]
  };
  var faAdn = {
    prefix: 'fab',
    iconName: 'adn',
    icon: [512, 512, [], "f170", "M256 167.5l64.9 98.8-129.8 0 64.9-98.8zM8 256a248 248 0 1 1 496 0 248 248 0 1 1 -496 0zm396.2 82.7l-148.2-223.2-148.2 223.2 30.4 0 33.6-51.7 168.6 0 33.6 51.7 30.2 0z"]
  };
  var faSquareXTwitter = {
    prefix: 'fab',
    iconName: 'square-x-twitter',
    icon: [448, 512, [], "e61a", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zm297.1 84l-103.8 118.6 122.1 161.4-95.6 0-74.8-97.9-85.7 97.9-47.5 0 111-126.9-117.1-153.1 98 0 67.7 89.5 78.2-89.5 47.5 0zM323.3 367.6l-169.9-224.7-28.3 0 171.8 224.7 26.4 0z"]
  };
  var faSquareFontAwesome = {
    prefix: 'fab',
    iconName: 'square-font-awesome',
    icon: [448, 512, [], "e5ad", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zm90 122c0 9.3-4.8 17.4-12.1 22l188.9 0c7.3 0 13.2 5.9 13.2 13.2 0 1.8-.4 3.7-1.1 5.4L312 264 342.9 333.4c.7 1.7 1.1 3.5 1.1 5.4 0 7.3-5.9 13.2-13.2 13.2l-186.8 0 0 32-32 0 0-209.5c-6.1-4.8-10-12.2-10-20.5 0-14.4 11.6-26 26-26s26 11.6 26 26z"]
  };
  var faForumbee = {
    prefix: 'fab',
    iconName: 'forumbee',
    icon: [448, 512, [], "f211", "M5.8 309.7C2 292.7 0 275.5 0 258.3 0 135 99.8 35 223.1 35 239.7 35 256.4 37 272.4 40.5 149 87.5 51.9 186 5.8 309.7zM398.7 120.5c-13.7-17.5-29.7-32.7-47.8-45.3-149.6 44.3-266.3 162.1-309.7 312 12.5 18.1 28 35.6 45.2 49 43.1-151.3 161.2-271.7 312.3-315.7zm15.8 252.7c15.2-25.1 25.4-53.7 29.5-82.8-79.4 42.9-145 110.6-187.6 190.3 30-4.4 58.9-15.3 84.6-31.3 35 13.1 70.9 24.3 107 33.6-9.3-36.5-20.4-74.5-33.5-109.8zm29.7-145.5c-2.6-19.5-7.9-38.7-15.8-56.8-137.9 45.8-246.4 156.6-291.3 295.1 18.1 7.6 37 12.5 56.6 15.2 46.3-114.1 136.8-206.8 250.5-253.5z"]
  };
  var fa42Group = {
    prefix: 'fab',
    iconName: '42-group',
    icon: [640, 512, ["innosoft"], "e080", "M320 96l0 320c21 0 41.8-4.1 61.2-12.2s37-19.8 51.9-34.7 26.6-32.5 34.7-51.9 12.2-40.2 12.2-61.2-4.1-41.8-12.2-61.2-19.8-37.1-34.7-51.9-32.5-26.6-51.9-34.7-40.2-12.2-61.2-12.2zM0 256L160 416 320 256 160 96 0 256zm480 0c0 21 4.1 41.8 12.2 61.2s19.8 37 34.7 51.9 32.5 26.6 51.9 34.7 40.2 12.2 61.2 12.2l0-320c-42.4 0-83.1 16.9-113.1 46.9S480 213.6 480 256z"]
  };
  var faInnosoft = fa42Group;
  var faStumbleuponCircle = {
    prefix: 'fab',
    iconName: 'stumbleupon-circle',
    icon: [512, 512, [], "f1a3", "M264 8a248 248 0 1 0 0 496 248 248 0 1 0 0-496zm0 177.5c-9.8 0-17.8 8-17.8 17.8l0 106.9c0 40.9-33.9 73.9-74.9 73.9-41.4 0-74.9-33.5-74.9-74.9l0-46.5 57.3 0 0 45.8c0 10 8 17.8 17.8 17.8s17.8-7.9 17.8-17.8l0-108.4c0-40 34.2-72.1 74.7-72.1 40.7 0 74.7 32.3 74.7 72.6l0 23.7-34.1 10.1-22.9-10.7 0-20.6c.1-9.6-7.9-17.6-17.7-17.6zM431.6 309.1c0 41.4-33.5 74.9-74.9 74.9-41.2 0-74.9-33.2-74.9-74.2l0-46.8 22.9 10.7 34.1-10.1 0 47.1c0 9.8 8 17.6 17.8 17.6s17.8-7.9 17.8-17.6l0-48 57.3 0c-.1 45.9-.1 46.4-.1 46.4z"]
  };
  var faSymfony = {
    prefix: 'fab',
    iconName: 'symfony',
    icon: [512, 512, [], "f83d", "M256 8a248 248 0 1 0 0 496 248 248 0 1 0 0-496zM389.7 151.5c-11.5 .4-19.4-6.4-19.8-16.9-.3-9.2 6.7-13.4 6.5-18.9-.2-6.5-10.2-6.8-12.9-6.7-39.8 1.3-48.6 57-58.9 113.8 21.4 3.2 36.6-.7 45.1-6.2 12-7.7-3.3-15.7-1.4-24.6 4-18.2 32.6-19 32 5.3-.4 17.9-25.9 41.8-77.6 35.7-10.8 59.5-18.4 115-58.2 161.7-29 34.5-58.4 39.8-71.6 40.3-24.6 .9-41-12.3-41.6-29.8-.6-17 14.4-26.3 24.3-26.6 21.9-.8 30.1 25.7 14.9 34-12.1 9.7 .1 12.6 2.1 12.6 10.4-.4 17.3-5.5 22.2-9 24-20 33.2-54.9 45.4-118.3 8.2-49.7 17-78 18.2-82-16.9-12.7-27.1-28.6-49.8-34.7-15.6-4.2-25.1-.6-31.8 7.8-7.9 10-5.3 23 2.4 30.7l12.6 14c15.5 17.9 24 31.9 20.8 50.6-5.1 29.9-40.7 52.9-82.9 39.9-36-11.1-42.7-36.6-38.4-50.6 7.5-24.2 42.4-11.7 34.6 13.6-2.8 8.6-4.9 8.7-6.3 13.1-4.6 14.8 41.8 28.4 51-1.4 4.5-14.5-5.3-21.7-22.2-39.9-28.5-31.7-16-65.5 2.9-79.7 52.8-39.4 100.5 17.5 110.6 25.8 37.2-109 100.5-105.5 102.4-105.5 25.2-.8 44.2 10.6 44.8 28.6 .2 7.7-4.2 22.6-19.5 23.1z"]
  };
  var faSalesforce = {
    prefix: 'fab',
    iconName: 'salesforce',
    icon: [640, 512, [], "f83b", "M249.4 245.6l-26.4 0c.7-5.2 3.3-14.1 13.6-14.1 6.8 0 12 3.8 12.7 14.1zM386 231.8c-.5 0-14.1-1.8-14.1 20s13.6 20 14.1 20c13 0 14.1-13.5 14.1-20 0-21.8-13.7-20-14.1-20zM142.8 255.5c-1.1 .9-2 2-2.5 3.2s-.8 2.7-.7 4c0 4.8 2.1 6.1 3.3 7 4.7 3.7 15.1 2.1 20.9 1l0-16.9c-5.3-1.1-16.7-2-20.9 1.6zM640.5 232c0 87.6-80 154.4-165.4 136.4-18.4 33-70.7 70.8-132.2 41.6-41.2 96-177.9 92.2-213.8-5.2-119.7 23.9-178.8-138.4-75.3-199.3-34.8-79.4 22.6-173.6 114.3-173.6 19.1 0 37.9 4.4 55 12.9s32 20.7 43.6 35.8c20.7-21.4 49.4-34.8 81.1-34.8 42.3 0 79 23.5 98.8 58.6 92.8-40.7 193.8 28.2 193.8 127.5zM120.9 263.8c0-11.8-11.7-15.2-17.9-17.2-5.3-2.1-13.4-3.5-13.4-8.9 0-9.5 17-6.7 25.2-2.1 0 0 1.2 .7 1.6-.5 .2-.7 2.4-6.6 2.6-7.3 .1-.3 .1-.6-.1-.8s-.4-.5-.6-.6c-12.3-7.6-40.7-8.5-40.7 12.7 0 12.5 11.5 15.4 17.9 17.2 4.7 1.6 13.2 3 13.2 8.7 0 4-3.5 7.1-9.2 7.1-6.9 0-13.5-2.2-19-6.3-.5-.2-1.4-.7-1.6 .7l-2.4 7.5c-.5 .9 .2 1.2 .2 1.4 1.8 1.4 10.3 6.6 22.8 6.6 13.2 0 21.4-7.1 21.4-18.1l0 0zm32-42.6c-10.1 0-18.7 3.2-21.4 5.2-.1 .1-.2 .2-.3 .3s-.1 .2-.1 .4 0 .3 0 .4 .1 .3 .2 .4l2.6 7.1c.1 .2 .2 .5 .5 .6s.5 .2 .7 .1c.6 0 6.8-4 16.9-4 4 0 7.1 .7 9.2 2.4 3.6 2.8 3.1 8.3 3.1 10.6-4.8-.3-19.1-3.4-29.4 3.8-2.3 1.6-4.3 3.8-5.5 6.3s-1.9 5.4-1.8 8.2c0 5.9 1.5 10.4 6.6 14.4 12.2 8.2 36.3 2 38.1 1.4 1.6-.3 3.5-.7 3.5-1.9l0-33.9c0-4.6 .3-21.6-22.8-21.6l0 .1zm46.6-21c0-.2 0-.3-.1-.5s-.1-.3-.3-.4-.2-.2-.4-.3-.3-.1-.5-.1l-9.8 0c-.2 0-.3 0-.5 .1s-.3 .1-.4 .3-.2 .2-.3 .4-.1 .3-.1 .5l0 79c0 .2 0 .3 .1 .5s.1 .3 .3 .4 .2 .2 .4 .3 .3 .1 .5 .1l9.9 0c.2 0 .3 0 .5-.1s.3-.1 .4-.3 .2-.2 .3-.4 .1-.3 .1-.5l-.1-79zm55.7 28.9c-2.1-2.3-6.8-7.5-17.6-7.5-3.5 0-14.2 .2-20.7 8.9-6.4 7.6-6.6 18.1-6.6 21.4 0 3.1 .2 14.3 7.1 21.2 2.6 2.9 9.1 8.2 22.8 8.2 10.8 0 16.5-2.3 18.6-3.8 .5-.2 .7-.7 .2-1.9l-2.3-6.8c-.1-.3-.3-.5-.6-.6s-.5-.2-.8-.1c-2.6 .9-6.3 2.8-15.3 2.8-17.4 0-16.8-14.7-16.9-16.7l37.2 0c.3 0 .5-.1 .7-.3s.4-.4 .4-.7c-.3 0 2.1-14.7-6.1-24.2l0 0zm36.7 52.7c13.2 0 21.4-7.1 21.4-18.1 0-11.8-11.7-15.2-17.9-17.2-4.1-1.7-13.4-3.4-13.4-8.9 0-3.8 3.3-6.4 8.5-6.4 5.8 .1 11.5 1.6 16.7 4.2 0 0 1.2 .7 1.6-.5 .2-.7 2.4-6.6 2.6-7.3 .1-.3 .1-.6-.1-.8s-.4-.5-.6-.6c-7.9-4.9-16.7-4.9-20.2-4.9-12 0-20.5 7.3-20.5 17.6 0 12.5 11.5 15.4 17.9 17.2 6.1 2 13.2 3.3 13.2 8.7 0 4-3.5 7.1-9.2 7.1-6.9 0-13.5-2.2-19-6.4-.1-.1-.3-.2-.5-.2s-.4 0-.5 .1-.3 .2-.4 .3-.2 .3-.2 .5l-2.3 7.5c-.5 .9 .2 1.2 .2 1.4 1.7 1.4 10.3 6.6 22.8 6.6l0 0zM357.6 224c0-.7-.2-1.2-1.2-1.2l-11.8 0c0-.1 .9-8.9 4.5-12.5 4.2-4.2 11.8-1.6 12-1.6 1.2 .5 1.4 0 1.6-.5l2.8-7.8c.7-.9 0-1.2-.2-1.4-5.1-2-17.4-2.9-24.5 4.2-5.5 5.5-7 13.9-8 19.5l-8.5 0c-.3 0-.6 .2-.8 .4s-.3 .5-.4 .8l-1.4 7.8c0 .7 .2 1.2 1.2 1.2l8.2 0c-8.5 47.9-8.7 50.2-10.3 55.5-1.1 3.6-3.3 6.9-5.9 7.8-.1 0-3.9 1.7-9.6-.2 0 0-.9-.5-1.4 .7-.2 .7-2.6 6.8-2.8 7.5s0 1.4 .5 1.4c5.1 2 13 1.8 17.9 0 6.3-2.3 9.7-7.9 11.5-12.9 2.8-7.7 2.8-9.8 11.8-59.7l12.2 0c.3 0 .6-.2 .8-.4s.3-.5 .4-.8l1.4-7.8zM411 240c-.6-1.7-5.1-18.1-25.2-18.1-15.2 0-23 10-25.2 18.1-1 3-3.2 14 0 23.5 .1 .3 4.4 18.1 25.2 18.1 15 0 22.9-9.6 25.2-18.1 3.2-9.6 1-20.5 0-23.5zm45.4-16.7c-5-1.7-16.6-1.9-22.1 5.4l0-4.5c0-.2 0-.3-.1-.5s-.1-.3-.3-.4-.2-.2-.4-.3-.3-.1-.5-.1l-9.4 0c-.2 0-.3 0-.5 .1s-.3 .1-.4 .3-.2 .2-.3 .4-.1 .3-.1 .5l0 55.3c0 .2 0 .3 .1 .5s.1 .3 .3 .4 .2 .2 .4 .3 .3 .1 .5 .1l9.6 0c.2 0 .3 0 .5-.1s.3-.1 .4-.3 .2-.2 .3-.4 .1-.3 .1-.5l0-27.8c0-2.9 .1-11.4 4.5-15.1 4.9-4.9 12-3.4 13.4-3.1 .3 0 .6-.1 .8-.3s.4-.4 .6-.7c1.2-2.6 2.2-5.3 3.1-8 .1-.3 .1-.5 0-.8s-.3-.5-.5-.6l0 0zm46.8 54.1l-2.1-7.3c-.5-1.2-1.4-.7-1.4-.7-4.2 1.8-10.1 1.9-11.3 1.9-4.6 0-17.2-1.1-17.2-19.8 0-6.2 1.8-19.8 16.5-19.8 3.9-.1 7.8 .5 11.5 1.6 0 0 .9 .5 1.2-.7 .9-2.6 1.6-4.5 2.6-7.5 .2-.9-.5-1.2-.7-1.2-11.6-3.9-22.3-2.5-27.8 0-1.6 .7-16.2 6.5-16.2 27.5 0 2.9-.6 30.1 28.9 30.1 5.3 0 10.6-1 15.5-2.8 .2-.2 .4-.4 .5-.6s.1-.5 0-.8l0 0zm53.9-39.5c-.8-3-5.4-16.2-22.3-16.2-16 0-23.5 10.1-25.6 18.6-1.2 3.8-1.7 7.8-1.7 11.8 0 25.9 18.8 29.4 29.9 29.4 10.8 0 16.5-2.3 18.6-3.8 .5-.2 .7-.7 .2-1.9l-2.4-6.8c-.1-.3-.3-.5-.6-.6s-.6-.2-.8-.1c-2.6 .9-6.3 2.8-15.3 2.8-17.4 0-16.9-14.7-16.9-16.7l37.2 0c.3 0 .5-.1 .7-.3s.4-.4 .4-.7c-.2 0 .9-7.1-1.4-15.5l0 0zm-23.3-6.4c-10.3 0-13 9-13.6 14.1l26.4 0c-.9-11.9-7.6-14.1-12.7-14.1l0 0z"]
  };
  var faSourcetree = {
    prefix: 'fab',
    iconName: 'sourcetree',
    icon: [448, 512, [], "f7d3", "M427.4 203c0-112.1-90.9-203-203-203-112.1-.2-203 90.6-203.2 202.6-.1 43 13.5 84.8 38.7 119.6s60.9 60.6 101.8 73.8l0 101.7c0 3.8 1.5 7.4 4.2 10.1s6.3 4.2 10.1 4.2l96.4 0c3.8 0 7.4-1.5 10.1-4.2s4.2-6.3 4.2-10.1l0-101.6c40.8-13.2 76.5-39 101.7-73.7s38.9-76.5 39-119.4zm-271.6 0c0-90.8 137.3-90.8 137.3 0-.1 89.9-137.3 91-137.3 0z"]
  };
  var faLinkedinIn = {
    prefix: 'fab',
    iconName: 'linkedin-in',
    icon: [448, 512, [], "f0e1", "M100.3 448l-92.9 0 0-299.1 92.9 0 0 299.1zM53.8 108.1C24.1 108.1 0 83.5 0 53.8 0 39.5 5.7 25.9 15.8 15.8s23.8-15.8 38-15.8 27.9 5.7 38 15.8 15.8 23.8 15.8 38c0 29.7-24.1 54.3-53.8 54.3zM447.9 448l-92.7 0 0-145.6c0-34.7-.7-79.2-48.3-79.2-48.3 0-55.7 37.7-55.7 76.7l0 148.1-92.8 0 0-299.1 89.1 0 0 40.8 1.3 0c12.4-23.5 42.7-48.3 87.9-48.3 94 0 111.3 61.9 111.3 142.3l0 164.3-.1 0z"]
  };
  var faHtml5 = {
    prefix: 'fab',
    iconName: 'html5',
    icon: [384, 512, [], "f13b", "M0 32L34.9 427.8 191.5 480 349.1 427.8 384 32 0 32zM308.2 159.9l-183.8 0 4.1 49.4 175.6 0-13.6 148.4-97.9 27 0 .3-1.1 0-98.7-27.3-6-75.8 47.7 0 3.5 38.1 53.5 14.5 53.7-14.5 6-62.2-166.9 0-12.8-145.6 241.1 0-4.4 47.7z"]
  };
  var faRust = {
    prefix: 'fab',
    iconName: 'rust',
    icon: [512, 512, [], "e07a", "M508.5 249.8l-21.8-13.5c-.2-2-.3-3.9-.5-5.9l18.7-17.5c.9-.9 1.6-1.9 2-3.1s.5-2.5 .2-3.7-.8-2.4-1.6-3.3-1.8-1.7-3-2.1l-24-9c-.5-1.9-1.1-3.8-1.7-5.6l15-20.8c.7-1 1.2-2.2 1.3-3.4s0-2.5-.5-3.7-1.2-2.2-2.2-2.9-2.1-1.3-3.4-1.5l-25.4-4.2c-.9-1.7-1.8-3.4-2.7-5.2l10.7-23.4c.5-1.1 .7-2.4 .6-3.6s-.5-2.4-1.2-3.5-1.6-1.9-2.8-2.5-2.4-.8-3.6-.8l-25.8 .9c-1.2-1.5-2.4-2.9-3.6-4.4L439 81.8c.3-1.2 .3-2.5-.1-3.7s-1-2.3-1.9-3.2-2-1.5-3.2-1.9-2.5-.4-3.7-.1L405 78.9c-1.4-1.2-2.9-2.4-4.4-3.6l.9-25.8c.1-1.3-.2-2.5-.8-3.6s-1.4-2.1-2.5-2.8-2.2-1.1-3.5-1.2-2.5 .1-3.7 .6L367.7 53.2c-1.7-.9-3.4-1.8-5.1-2.7l-4.2-25.4c-.2-1.2-.7-2.4-1.5-3.4s-1.8-1.7-2.9-2.2-2.4-.7-3.7-.5-2.4 .6-3.4 1.3L326 35.3c-1.9-.6-3.8-1.1-5.6-1.7l-9-24c-.4-1.2-1.2-2.2-2.1-3s-2.1-1.4-3.3-1.6-2.5-.2-3.7 .2-2.3 1.1-3.1 2L281.6 25.9c-2-.2-3.9-.4-5.9-.5L262.3 3.5c-.7-1.1-1.6-1.9-2.7-2.6s-2.3-.9-3.6-.9-2.5 .3-3.6 .9-2 1.5-2.7 2.6L236.2 25.3c-2 .2-3.9 .3-5.9 .6L212.9 7.1c-.9-.9-1.9-1.6-3.1-2s-2.5-.5-3.7-.2-2.4 .8-3.3 1.6-1.7 1.8-2.1 3l-9 24c-1.9 .6-3.8 1.1-5.7 1.7l-20.8-15c-1-.7-2.2-1.2-3.4-1.3s-2.5 0-3.7 .5-2.2 1.2-2.9 2.2-1.3 2.1-1.5 3.4l-4.2 25.4c-1.7 .9-3.4 1.8-5.2 2.7L120.9 42.6c-1.1-.5-2.4-.7-3.7-.6s-2.5 .5-3.5 1.2-1.9 1.7-2.5 2.8-.8 2.4-.8 3.6l.9 25.8c-1.5 1.2-3 2.4-4.4 3.6L81.8 73c-1.2-.3-2.5-.3-3.7 .1s-2.3 1-3.2 1.9-1.5 2-1.9 3.2-.4 2.5-.1 3.7L78.9 107c-1.2 1.4-2.4 2.9-3.6 4.4l-25.8-.9c-1.3 0-2.5 .2-3.6 .8s-2.1 1.4-2.8 2.4-1.1 2.2-1.2 3.5 .1 2.5 .6 3.6l10.7 23.4c-.9 1.7-1.8 3.4-2.7 5.2l-25.4 4.1c-1.2 .2-2.4 .7-3.4 1.5s-1.7 1.8-2.2 2.9-.7 2.4-.5 3.7 .6 2.4 1.3 3.4l15 20.8c-.6 1.9-1.1 3.8-1.7 5.7l-24 9c-1.2 .4-2.2 1.2-3 2.1s-1.4 2.1-1.6 3.3-.2 2.5 .2 3.7 1.1 2.3 2 3.1l18.7 17.5c-.2 2-.4 3.9-.6 5.9L3.5 249.8c-1.1 .7-1.9 1.6-2.6 2.7s-.9 2.3-.9 3.6 .3 2.5 .9 3.6 1.5 2 2.6 2.7l21.8 13.5c.2 2 .3 3.9 .6 5.9L7.1 299.1c-.9 .9-1.6 1.9-2 3.1s-.5 2.5-.2 3.7 .8 2.4 1.6 3.3 1.8 1.7 3 2.1l24 9c.6 1.9 1.1 3.8 1.7 5.6l-15 20.8c-.7 1-1.2 2.2-1.3 3.4s0 2.5 .5 3.7 1.2 2.2 2.2 2.9 2.1 1.3 3.4 1.5l25.4 4.2c.9 1.7 1.8 3.4 2.7 5.1L42.6 391.1c-.5 1.1-.7 2.4-.6 3.6s.5 2.5 1.2 3.5c.7 1.1 1.6 1.9 2.7 2.5s2.4 .8 3.6 .8l25.8-.9c1.2 1.5 2.4 2.9 3.6 4.4L73 430.2c-.3 1.2-.3 2.5 .1 3.7s1 2.3 1.9 3.2 2 1.5 3.2 1.9 2.5 .4 3.7 .1l25.2-5.9c1.5 1.2 2.9 2.4 4.4 3.6l-.9 25.8c0 1.3 .2 2.5 .8 3.6s1.4 2.1 2.5 2.8 2.2 1.1 3.5 1.2 2.5-.1 3.6-.6l23.4-10.7c1.7 .9 3.4 1.8 5.1 2.7l4.2 25.4c.2 1.2 .7 2.4 1.5 3.4s1.8 1.8 2.9 2.2 2.4 .7 3.7 .5 2.4-.6 3.4-1.3l20.8-15c1.9 .6 3.8 1.1 5.6 1.7l9 24c.4 1.2 1.2 2.2 2.1 3s2.1 1.4 3.3 1.6 2.5 .2 3.7-.2 2.3-1.1 3.1-2l17.5-18.7c2 .2 3.9 .4 5.9 .6l13.5 21.8c.7 1.1 1.6 1.9 2.7 2.6s2.3 .9 3.6 .9 2.5-.3 3.6-.9 2-1.5 2.7-2.6l13.5-21.8c2-.2 3.9-.3 5.9-.6l17.5 18.7c.9 .9 1.9 1.6 3.1 2s2.5 .5 3.7 .2 2.4-.8 3.3-1.6 1.7-1.8 2.1-3l9-24c1.9-.6 3.8-1.1 5.6-1.7l20.8 15c1 .7 2.2 1.2 3.4 1.3s2.5 0 3.7-.5 2.2-1.2 2.9-2.2 1.3-2.1 1.5-3.4l4.2-25.4c1.7-.9 3.4-1.8 5.1-2.7l23.4 10.7c1.1 .5 2.4 .7 3.6 .6s2.4-.5 3.5-1.2 1.9-1.6 2.5-2.8 .8-2.4 .8-3.6l-.9-25.8c1.5-1.2 2.9-2.4 4.4-3.6l25.2 5.9c1.2 .3 2.5 .3 3.7-.1s2.3-1 3.2-1.9 1.5-2 1.9-3.2 .4-2.5 .1-3.7L433.1 405c1.2-1.4 2.4-2.9 3.6-4.4l25.8 .9c1.3 .1 2.5-.2 3.6-.8s2.1-1.4 2.8-2.5c.7-1 1.1-2.2 1.2-3.5s-.1-2.5-.6-3.6l-10.7-23.4c.9-1.7 1.8-3.4 2.7-5.1l25.4-4.2c1.2-.2 2.4-.7 3.4-1.5s1.8-1.8 2.2-2.9 .7-2.4 .5-3.7-.6-2.4-1.3-3.4l-15-20.8c.6-1.9 1.1-3.8 1.7-5.6l24-9c1.2-.4 2.2-1.2 3-2.1s1.4-2.1 1.6-3.3 .2-2.5-.2-3.7-1.1-2.3-2-3.1l-18.7-17.5c.2-1.9 .4-3.9 .6-5.9l21.8-13.5c1.1-.7 1.9-1.6 2.6-2.7s.9-2.3 .9-3.6-.3-2.5-.9-3.6-1.5-2-2.6-2.7l0 0zm-151 129.1c-3.6-.8-7.4-.1-10.5 1.9s-5.3 5.2-6 8.8l-7.6 35.7c-24.6 11.1-51.3 16.8-78.3 16.7s-53.6-6.1-78.1-17.4l-7.6-35.7c-.4-1.8-1.1-3.5-2.1-5s-2.4-2.8-3.9-3.8-3.2-1.7-5-2-3.6-.3-5.4 .1l-31.5 6.8c-5.8-6-11.3-12.5-16.3-19.2l153.2 0c1.7 0 2.9-.3 2.9-1.9l0-54.2c0-1.6-1.2-1.9-2.9-1.9l-44.8 0 0-34.4 48.5 0c4.4 0 23.7 1.3 29.8 25.9 1.9 7.5 6.2 32.1 9.1 40 2.9 8.8 14.6 26.5 27.1 26.5l79 0c-5.3 7.1-11.1 13.8-17.3 20.1l-32.1-6.9zm25.8 34.5c0 3-.9 6-2.6 8.5s-4 4.5-6.8 5.6-5.8 1.5-8.8 .9-5.7-2-7.8-4.2-3.6-4.8-4.2-7.8-.3-6 .8-8.8 3.1-5.2 5.6-6.9 5.4-2.6 8.5-2.6l.4 0c4 .1 7.7 1.8 10.5 4.6s4.3 6.7 4.3 10.6l.1 0zm-225.6-.7c0 3-.9 6-2.6 8.5s-4.1 4.5-6.8 5.6-5.8 1.5-8.8 .9-5.7-2-7.8-4.2-3.6-4.8-4.2-7.8-.3-6 .9-8.8 3.1-5.2 5.6-6.8 5.4-2.6 8.5-2.6l.5 0c4 .1 7.7 1.8 10.5 4.6s4.3 6.7 4.3 10.6l.1 0zM69.6 234.2l32.8-14.6c1.7-.7 3.2-1.8 4.4-3.1s2.2-2.9 2.9-4.6 1-3.5 .9-5.3-.5-3.6-1.2-5.3l-6.8-15.2 26.6 0 0 119.7-53.6 0c-6.6-23.2-8.7-47.6-6.1-71.6zM58.3 198.1c0-2 .4-4 1.2-5.8s1.9-3.5 3.3-4.9 3.1-2.5 4.9-3.3 3.8-1.2 5.8-1.2l.5 0c3 .1 5.9 1 8.3 2.8s4.3 4.1 5.4 6.9 1.3 5.8 .7 8.8-2.1 5.6-4.3 7.7-4.9 3.5-7.8 4.1-6 .2-8.7-.9-5.1-3.1-6.8-5.6-2.5-5.4-2.5-8.4l0 0zm155.2 24.5l0-35.3 63.3 0c3.3 0 23.1 3.8 23.1 18.6 0 12.3-15.2 16.7-27.7 16.7l-58.7 0zM399 306.7c-9.8 1.1-20.6-4.1-22-10.1-5.8-32.5-15.4-39.4-30.6-51.4 18.9-12 38.5-29.6 38.5-53.3 0-25.5-17.5-41.6-29.4-49.5-16.8-11-35.3-13.2-40.3-13.2l-198.9 0c27.5-30.7 64.4-51.5 104.9-59.2l23.5 24.6c1.3 1.3 2.8 2.4 4.4 3.1s3.5 1.1 5.3 1.2 3.6-.3 5.3-.9 3.2-1.7 4.6-2.9l26.3-25c26.8 5 52.1 15.8 74.3 31.6s40.6 36.2 54.1 59.9l-18 40.6c-1.5 3.4-1.5 7.2-.2 10.6s3.9 6.2 7.3 7.7l34.6 15.3c1.1 10.8 1.2 21.7 .4 32.5l-19.3 0c-1.9 0-2.7 1.3-2.7 3.1l0 8.8c0 20.8-11.7 25.3-22 26.5zM240 60.2c0-4 1.6-7.9 4.5-10.7s6.7-4.5 10.7-4.5l.4 0c3 .1 5.9 1 8.4 2.8s4.3 4.1 5.4 6.9 1.3 5.8 .7 8.8-2.1 5.6-4.3 7.7-4.9 3.5-7.8 4-6 .2-8.7-.9-5.1-3.1-6.8-5.6-2.5-5.4-2.5-8.4zM436.8 214c-2 0-4-.4-5.8-1.2s-3.5-1.9-4.9-3.3-2.5-3.1-3.3-4.9-1.2-3.8-1.2-5.8 .4-4 1.2-5.8 1.9-3.5 3.3-4.9 3.1-2.5 4.9-3.3 3.8-1.2 5.8-1.2l.4 0c4 .1 7.9 1.7 10.7 4.6s4.4 6.8 4.3 10.8-1.7 7.9-4.6 10.7-6.8 4.4-10.8 4.3z"]
  };
  var faHornbill = {
    prefix: 'fab',
    iconName: 'hornbill',
    icon: [512, 512, [], "f592", "M76.8 370.3c1 7.8-.4 15.8-4.1 22.8s-9.6 12.6-16.7 16.1-15.1 4.7-22.9 3.3-15-5.1-20.6-10.7-9.2-12.9-10.5-20.7 0-15.8 3.6-22.9 9.3-12.8 16.3-16.5 15-5 22.9-3.9c-78.3-111.3 52-190.5 52-190.5-5.9 43-8.2 91.2-8.2 91.2-67.3 41.5 .9 64.1 39.8 72.9 9.9 27 27.8 50.2 51.4 66.7s51.6 25.3 80.3 25.3c1.9 0 3.8-.2 5.7-.3l.1 18.9c-99.2 1.4-158.7-29.1-188.9-51.6zm108-327.7c.9-7.2-.2-14.6-3.4-21.2-3-6.2-7.6-11.5-13.4-15.3s-12.5-5.9-19.4-6.2-13.8 1.4-19.8 4.7-11.1 8.3-14.5 14.3-5.2 12.8-5 19.7 2.2 13.7 5.9 19.5 8.9 10.6 15.1 13.6 13.1 4.4 20 3.9c-22.6 29.9-53.8 89.6-52.4 190l21.8-.2c0-.9-.1-1.8-.1-2.7 0-28 8.4-55.3 24.1-78.5s37.9-41.2 63.8-51.6c8-37.7 30.7-114.3 73.8-44.3 0 0 48.1 2.4 91.2 8.2 0 0-77.8-128-187.6-54.1l0 0zM489 176.8c6.3-3 11.7-7.7 15.5-13.6s5.9-12.7 6.1-19.8-1.6-14-5.2-20-8.7-11-14.9-14.3-13.2-4.8-20.2-4.4-13.8 2.8-19.5 6.9-10.2 9.6-13 16.1-3.7 13.6-2.7 20.5c-31.7-21.9-89.8-49.1-183.4-47.7l.1 22.5c2.7-.2 5.4-.4 8.1-.4 28.1 0 55.6 8.5 78.9 24.3s41.2 38.3 51.6 64.5c39.1 9 105.1 31.6 38.5 72.5 0 0-2.3 48.1-8.2 91.2 0 0 133.4-81.2 49-194.6 6.6 .6 13.3-.6 19.3-3.5l0 0zM374.4 436.2c21.4-32.5 46.4-89.7 45.1-179.7l-19.5 .1c.1 2.1 .3 4.1 .3 6.2 0 28.6-8.8 56.5-25.1 80s-39.5 41.4-66.3 51.4c-8.9 39-31.4 106.7-72.8 39.5 0 0-48.1-2.3-91.2-8.2 0 0 79.9 131.3 191.9 51 .3 4.9 1.5 9.6 3.6 14 2.9 6.1 7.5 11.4 13.1 15.1s12.2 6 19 6.4 13.6-1.1 19.6-4.2 11.1-7.8 14.7-13.6 5.6-12.4 5.7-19.2-1.5-13.5-4.8-19.4-8.2-10.9-14.1-14.3-12.6-5.2-19.4-5.1l0-.1z"]
  };
  var faPhp = {
    prefix: 'fab',
    iconName: 'php',
    icon: [640, 512, [], "f457", "M320 104.5c171.4 0 303.2 72.2 303.2 151.5S491.3 407.5 320 407.5C148.6 407.5 16.8 335.3 16.8 256S148.7 104.5 320 104.5zm0-16.8C143.3 87.7 0 163 0 256S143.3 424.3 320 424.3 640 349 640 256 496.7 87.7 320 87.7zM218.2 242.5c-7.9 40.5-35.8 36.3-70.1 36.3l13.7-70.6c38 0 63.8-4.1 56.4 34.3zM97.4 350.3l36.7 0 8.7-44.8c41.1 0 66.6 3 90.2-19.1 26.1-24 32.9-66.7 14.3-88.1-9.7-11.2-25.3-16.7-46.5-16.7l-70.7 0-32.7 168.7zM283.1 136.7l36.5 0-8.7 44.8c31.5 0 60.7-2.3 74.8 10.7 14.8 13.6 7.7 31-8.3 113.1l-37 0c15.4-79.4 18.3-86 12.7-92-5.4-5.8-17.7-4.6-47.4-4.6l-18.8 96.6-36.5 0 32.7-168.6zM505 242.5c-8 41.1-36.7 36.3-70.1 36.3l13.7-70.6c38.2 0 63.8-4.1 56.4 34.3zM384.2 350.3l36.8 0 8.7-44.8c43.2 0 67.1 2.5 90.2-19.1 26.1-24 32.9-66.7 14.3-88.1-9.7-11.2-25.3-16.7-46.5-16.7l-70.7 0-32.8 168.7z"]
  };
  var faDisqus = {
    prefix: 'fab',
    iconName: 'disqus',
    icon: [576, 512, [], "e7d5", "M290.2 512c-62.6 0-119.9-22.9-164.2-60.8L17 466.1 59.1 362.2c-14.7-32.4-22.9-68.3-22.9-106.2 0-141.4 113.7-256 254-256 140.3 0 254 114.6 254 256 0 141.4-113.7 256-254 256zM428.9 255.3l0-.7C428.9 180.7 376.8 128 287 128l-97 0 0 256 95.6 0c90.5 0 143.4-54.9 143.4-128.7zM288 321.1l-28.4 0 0-130.2 28.4 0c41.7 0 69.3 23.8 69.3 64.7l0 .7c0 41.3-27.7 64.7-69.3 64.7z"]
  };
  var fa500px = {
    prefix: 'fab',
    iconName: '500px',
    icon: [384, 512, [], "f26e", "M71.8 344.3c-6.5-14.2-6.9-18.3 7.4-23.1 25.6-8 8 9.2 43.2 49.2l.3 0 0-93.9c1.2-50.2 44-92.2 97.7-92.2 53.9 0 97.7 43.5 97.7 96.8 0 63.4-60.8 113.2-128.5 93.3-10.5-4.2-2.1-31.7 8.5-28.6 53 0 89.4-10.1 89.4-64.4 0-61-77.1-89.6-116.9-44.6-23.5 26.4-17.6 42.1-17.6 157.6 50.7 31 118.3 22 160.4-20.1 24.8-24.8 38.5-58 38.5-93 0-35.2-13.8-68.2-38.8-93.3-24.8-24.8-57.8-38.5-93.3-38.5S151 163.3 126.3 188c-.3 .3-16 16.5-21.2 23.9l-.5 .6c-3.3 4.7-6.3 9.1-20.1 6.1-6.9-1.7-14.3-5.8-14.3-11.8L70.2 20c0-5 3.9-10.5 10.5-10.5L322 9.5c8.3 0 8.3 11.6 8.3 15.1 0 3.9 0 15.1-8.3 15.1l-223.2 0 0 132.9 .3 0c104.2-109.8 282.8-36 282.8 108.9 0 178.1-244.8 220.3-310.1 62.8zM135.1 83.5c-.5 4.2 4.6 24.5 14.6 20.6 124.8-47.5 202.8 40.4 209.4 40.4 4.8 0 22.8-15.3 14.3-22.8-93.2-89-234.5-57-238.3-38.2zM361.5 414.7c-110 109.9-299 60.8-332-104.2 0-12.2-30.4-7.4-28.9 3.3 24 173.4 246 256.9 381.6 121.3 6.9-7.8-12.6-28.4-20.7-20.4zM182.1 306.6c0 4 4.3 7.3 5.5 8.5 3 3 6.1 4.4 8.5 4.4 3.8 0 2.6 .2 22.3-19.5 19.6 19.3 19.1 19.5 22.3 19.5 5.4 0 18.5-10.4 10.7-18.2l-17.3-17.3 18.2-18.2c6.3-6.8-10.1-21.8-16.2-15.7L218.2 268c-18.6-18.8-18.4-19.5-21.5-19.5-5 0-18 11.7-12.4 17.3L202.5 284c-18.1 17.9-20.4 19.2-20.4 22.6z"]
  };
  var faAffiliatetheme = {
    prefix: 'fab',
    iconName: 'affiliatetheme',
    icon: [512, 512, [], "f36b", "M159.7 237.4C108.4 308.3 43.1 348.2 14 326.6-15.2 304.9 2.8 230 54.2 159.1 105.5 88.2 170.8 48.3 199.9 69.9s11.1 96.6-40.2 167.5zm351.2-57.3c-73.8 123.4-191.9 187.7-264.5 143.6-25-15.2-41.3-41.2-49-73.8-33.6 64.8-92.8 113.8-164.1 133.2 49.8 59.3 124.1 96.9 207 96.9 150 0 271.6-123.1 271.6-274.9 .1-8.5-.3-16.8-1-25z"]
  };
  var faRedRiver = {
    prefix: 'fab',
    iconName: 'red-river',
    icon: [448, 512, [], "f3e3", "M353.2 32L94.8 32C42.4 32 0 74.4 0 126.8L0 385.2C0 437.6 42.4 480 94.8 480l258.4 0c52.4 0 94.8-42.4 94.8-94.8l0-258.4C448 74.4 405.6 32 353.2 32zM144.9 200.9l0 56.3c0 27-21.9 48.9-48.9 48.9l0-154.2c0-13.2 10.7-23.9 23.9-23.9l154.2 0c0 27-21.9 48.9-48.9 48.9l-56.3 0c-12.3-.6-24.6 11.6-24 24zm176.3 72l-56.3 0c-12.3-.6-24.6 11.6-24 24l0 56.3c0 27-21.9 48.9-48.9 48.9l0-154.2c0-13.2 10.7-23.9 23.9-23.9l154.2 0c0 27-21.9 48.9-48.9 48.9z"]
  };
  var faTwitter = {
    prefix: 'fab',
    iconName: 'twitter',
    icon: [512, 512, [], "f099", "M459.4 151.7c.3 4.5 .3 9.1 .3 13.6 0 138.7-105.6 298.6-298.6 298.6-59.5 0-114.7-17.2-161.1-47.1 8.4 1 16.6 1.3 25.3 1.3 49.1 0 94.2-16.6 130.3-44.8-46.1-1-84.8-31.2-98.1-72.8 6.5 1 13 1.6 19.8 1.6 9.4 0 18.8-1.3 27.6-3.6-48.1-9.7-84.1-52-84.1-103l0-1.3c14 7.8 30.2 12.7 47.4 13.3-28.3-18.8-46.8-51-46.8-87.4 0-19.5 5.2-37.4 14.3-53 51.7 63.7 129.3 105.3 216.4 109.8-1.6-7.8-2.6-15.9-2.6-24 0-57.8 46.8-104.9 104.9-104.9 30.2 0 57.5 12.7 76.7 33.1 23.7-4.5 46.5-13.3 66.6-25.3-7.8 24.4-24.4 44.8-46.1 57.8 21.1-2.3 41.6-8.1 60.4-16.2-14.3 20.8-32.2 39.3-52.6 54.3z"]
  };
  var faFortAwesome = {
    prefix: 'fab',
    iconName: 'fort-awesome',
    icon: [512, 512, [], "f286", "M489.5 287.9l-27.4 0c-2.6 0-4.6 2-4.6 4.6l0 32-36.6 0 0-178.3c0-2.6-2-4.6-4.6-4.6l-27.4 0c-2.6 0-4.6 2-4.6 4.6l0 32-36.6 0 0-32c0-2.6-2-4.6-4.6-4.6l-27.4 0c-2.6 0-4.6 2-4.6 4.6l0 32-36.6 0 0-32c0-6-8-4.6-11.7-4.6l0-38c8.3-2 17.1-3.4 25.7-3.4 10.9 0 20.9 4.3 31.4 4.3 4.6 0 27.7-1.1 27.7-8l0-60c0-2.6-2-4.6-4.6-4.6-5.1 0-15.1 4.3-24 4.3-9.7 0-20.9-4.3-32.6-4.3-8 0-16 1.1-23.7 2.9l0-4.9c5.4-2.6 9.1-8.3 9.1-14.3 0-20.7-31.4-20.8-31.4 0 0 6 3.7 11.7 9.1 14.3l0 111.7c-3.7 0-11.7-1.4-11.7 4.6l0 32-36.6 0 0-32c0-2.6-2-4.6-4.6-4.6l-27.4 0c-2.6 0-4.6 2-4.6 4.6l0 32-36.3 0 0-32c0-2.6-2-4.6-4.6-4.6l-27.4 0c-2.6 0-4.6 2-4.6 4.6l0 178.3-36.6 0 0-32c0-2.6-2-4.6-4.6-4.6l-27.4 0c-2.6 0-4.6 2-4.6 4.6l0 219.5 182.9 0 0-96c0-72.6 109.7-72.6 109.7 0l0 96 182.9 0 0-219.5c.1-2.6-1.9-4.6-4.5-4.6zm-288.1-4.5c0 2.6-2 4.6-4.6 4.6l-27.4 0c-2.6 0-4.6-2-4.6-4.6l0-64c0-2.6 2-4.6 4.6-4.6l27.4 0c2.6 0 4.6 2 4.6 4.6l0 64zm146.4 0c0 2.6-2 4.6-4.6 4.6l-27.4 0c-2.6 0-4.6-2-4.6-4.6l0-64c0-2.6 2-4.6 4.6-4.6l27.4 0c2.6 0 4.6 2 4.6 4.6l0 64z"]
  };
  var faMixer = {
    prefix: 'fab',
    iconName: 'mixer',
    icon: [448, 512, [], "e056", "M82.6 76.1c-3.8-5.1-8.7-9.4-14.2-12.5s-11.7-5.1-18.1-5.7-12.8 .1-18.8 2.2-11.6 5.3-16.3 9.6c-17.6 16.2-19 43.5-4.8 62.8l91.8 123-92.3 124.1c-14.2 19.3-13.1 46.6 4.7 62.8 4.7 4.3 10.3 7.6 16.3 9.6s12.5 2.8 18.8 2.2 12.5-2.5 18.1-5.7 10.4-7.4 14.2-12.5L210.9 262.7c1.5-2.1 2.3-4.6 2.3-7.1s-.8-5-2.3-7.1L82.6 76.1zM438.2 379.6l-92.3-124.1 91.8-123c14.2-19.2 12.8-46.6-4.7-62.8-4.7-4.3-10.3-7.6-16.3-9.6s-12.5-2.8-18.8-2.2-12.5 2.5-18.1 5.7-10.4 7.4-14.2 12.5l-128 172.1c-1.5 2.1-2.3 4.6-2.3 7.1s.8 5 2.3 7.1L366 435.9c3.8 5.1 8.7 9.4 14.2 12.5s11.7 5.1 18.1 5.7 12.8-.1 18.8-2.2 11.6-5.3 16.3-9.6c17.8-16.2 19-43.5 4.7-62.8z"]
  };
  var faLyft = {
    prefix: 'fab',
    iconName: 'lyft',
    icon: [512, 512, [], "f3c3", "M0 81.1l77.8 0 0 208.7c0 33.1 15 52.8 27.2 61-12.7 11.1-51.2 20.9-80.2-2.8-17-14-24.8-37.3-24.8-59L0 81.1zM485.9 254.6l0-22 23.8 0 0-76.8-26.1 0c-10.1-46.3-51.2-80.7-100.3-80.7-56.6 0-102.7 46-102.7 102.7l0 179.2c16 2.3 35.4-.3 51.7-14 17.1-14 24.8-37.2 24.8-59l0-6.7 38.8 0 0-76.8-38.8 0 0-23.3c0-34.6 52.2-34.6 52.2 0l0 77.1c0 56.6 46 102.7 102.7 102.7l0-76.5c-14.5 0-26.1-11.7-26.1-25.9zm-294.3-99l0 113c0 15.4-23.8 15.4-23.8 0l0-113-76.8 0 0 132.7c0 23.8 8 54 45 63.9 37 9.8 58.2-10.6 58.2-10.6-2.1 13.4-14.5 23.3-34.9 25.3-15.5 1.6-35.2-3.6-45-7.8l0 70.3c25.1 7.5 51.5 9.8 77.6 4.7 47.1-9.1 76.8-48.4 76.8-100.8l0-178.2-77.1 0 0 .5z"]
  };
  var faApplePay = {
    prefix: 'fab',
    iconName: 'apple-pay',
    icon: [640, 512, [], "f415", "M116.9 158.5c-7.5 8.9-19.5 15.9-31.5 14.9-1.5-12 4.4-24.8 11.3-32.6 7.5-9.1 20.6-15.6 31.3-16.1 1.2 12.4-3.7 24.7-11.1 33.8zm10.9 17.2c-17.4-1-32.3 9.9-40.5 9.9-8.4 0-21-9.4-34.8-9.1-17.9 .3-34.5 10.4-43.6 26.5-18.8 32.3-4.9 80 13.3 106.3 8.9 13 19.5 27.3 33.5 26.8 13.3-.5 18.5-8.6 34.5-8.6 16.1 0 20.8 8.6 34.8 8.4 14.5-.3 23.6-13 32.5-26 10.1-14.8 14.3-29.1 14.5-29.9-.3-.3-28-10.9-28.3-42.9-.3-26.8 21.9-39.5 22.9-40.3-12.5-18.6-32-20.6-38.8-21.1zm100.4-36.2l0 194.9 30.3 0 0-66.6 41.9 0c38.3 0 65.1-26.3 65.1-64.3s-26.4-64-64.1-64l-73.2 0zM258.5 165l34.9 0c26.3 0 41.3 14 41.3 38.6s-15 38.8-41.4 38.8l-34.8 0 0-77.4zM420.7 335.9c19 0 36.6-9.6 44.6-24.9l.6 0 0 23.4 28 0 0-97c0-28.1-22.5-46.3-57.1-46.3-32.1 0-55.9 18.4-56.8 43.6l27.3 0c2.3-12 13.4-19.9 28.6-19.9 18.5 0 28.9 8.6 28.9 24.5l0 10.8-37.8 2.3c-35.1 2.1-54.1 16.5-54.1 41.5 .1 25.2 19.7 42 47.8 42zm8.2-23.1c-16.1 0-26.4-7.8-26.4-19.6 0-12.3 9.9-19.4 28.8-20.5l33.6-2.1 0 11c0 18.2-15.5 31.2-36 31.2zm102.5 74.6c29.5 0 43.4-11.3 55.5-45.4l53.1-149-30.8 0-35.6 115.1-.6 0-35.6-115.1-31.6 0 51.2 141.9-2.8 8.6c-4.6 14.6-12.1 20.3-25.5 20.3-2.4 0-7-.3-8.9-.5l0 23.4c1.8 .4 9.3 .7 11.6 .7z"]
  };
  var faArtstation = {
    prefix: 'fab',
    iconName: 'artstation',
    icon: [512, 512, [], "f77a", "M2.1 377.4l43 74.3c4.3 8.5 10.8 15.7 18.9 20.7s17.4 7.6 27 7.6l285.4 0-59.2-102.6-315.1 0zM501.9 350L335.7 59.3c-4.4-8.2-10.9-15.1-18.9-20S299.7 32 290.4 32l-88.4 0 257.3 447.6 40.7-70.5c1.9-3.2 21-29.7 2-59.1zM275.2 304.5l-115.5-200-115.5 200 231 0z"]
  };
  var faNodeJs = {
    prefix: 'fab',
    iconName: 'node-js',
    icon: [448, 512, [], "f3d3", "M224.5 508c-6.7 0-13.5-1.8-19.4-5.2l-61.7-36.5c-9.2-5.2-4.7-7-1.7-8 12.3-4.3 14.8-5.2 27.9-12.7 1.4-.8 3.2-.5 4.6 .4l47.4 28.1c1.7 1 4.1 1 5.7 0L412 367.5c1.7-1 2.8-3 2.8-5l0-213.2c0-2.1-1.1-4-2.9-5.1L227.3 37.7c-1.7-1-4-1-5.7 0L37.1 144.3c-1.8 1-2.9 3-2.9 5.1l0 213.1c0 2 1.1 4 2.9 4.9l50.6 29.2c27.5 13.7 44.3-2.4 44.3-18.7l0-210.4c0-3 2.4-5.3 5.4-5.3l23.4 0c2.9 0 5.4 2.3 5.4 5.3l0 210.5c0 36.6-20 57.6-54.7 57.6-10.7 0-19.1 0-42.5-11.6L20.6 396.1c-12-6.9-19.4-19.8-19.4-33.7l0-213.1c0-13.8 7.4-26.8 19.4-33.7L205.1 9c11.7-6.6 27.2-6.6 38.8 0L428.6 115.7c12 6.9 19.4 19.8 19.4 33.7l0 213.1c0 13.8-7.4 26.7-19.4 33.7L243.9 502.8c-5.9 3.4-12.6 5.2-19.4 5.2zM373.6 297.9c0-39.9-27-50.5-83.7-58-57.4-7.6-63.2-11.5-63.2-24.9 0-11.1 4.9-25.9 47.4-25.9 37.9 0 51.9 8.2 57.7 33.8 .5 2.4 2.7 4.2 5.2 4.2l24 0c1.5 0 2.9-.6 3.9-1.7s1.5-2.6 1.4-4.1c-3.7-44.1-33-64.6-92.2-64.6-52.7 0-84.1 22.2-84.1 59.5 0 40.4 31.3 51.6 81.8 56.6 60.5 5.9 65.2 14.8 65.2 26.7 0 20.6-16.6 29.4-55.5 29.4-48.9 0-59.6-12.3-63.2-36.6-.4-2.6-2.6-4.5-5.3-4.5l-23.9 0c-3 0-5.3 2.4-5.3 5.3 0 31.1 16.9 68.2 97.8 68.2 58.4-.1 92-23.2 92-63.4z"]
  };
  var faUncharted = {
    prefix: 'fab',
    iconName: 'uncharted',
    icon: [448, 512, [], "e084", "M171.8 232.8c1.1 0 2.1-.3 3-.9s1.6-1.4 2-2.4c2.2-9.8 7.4-18.6 14.9-25.3 1.2-.8 1.7-2.5 1.7-4.1-.1-.7-.3-1.3-.6-1.9s-.9-1.1-1.4-1.4L74.5 128.5 149.1 85c1.5-.8 2.7-2 3.6-3.5s1.4-3.1 1.4-4.8c0-1.7-.4-3.4-1.3-4.9s-2.2-2.7-3.7-3.4L126.7 55.6c-1.5-.8-3.1-1.2-4.8-1.2s-3.3 .4-4.8 1.2L17 113.6c-1.5 .8-2.7 2-3.6 3.5s-1.4 3.1-1.4 4.8L12 237c0 1.7 .4 3.4 1.3 4.9s2.2 2.7 3.7 3.4l22.4 12.8c1.5 .9 3.2 1.3 5 1.2 2.4 .1 4.8-.8 6.6-2.5 1.8-1.9 2.8-4.4 2.9-7l0-85.3 115.9 67.9c.6 .3 1.4 .4 2.1 .4zM323.4 377.7c-1.7 .1-3.4 .5-5 1.2l-74.5 43.1 0-134.2c0-2.9-2.9-5.8-6.2-4.6-9.4 2.8-19.5 3-29 .4-.7-.2-1.5-.2-2.2-.1s-1.4 .4-2 .9-1.1 1-1.4 1.7-.5 1.4-.5 2.1l0 133.3-74.5-43.1c-1.5-.9-3.2-1.3-5-1.2-2.5 0-4.9 1-6.7 2.8s-2.8 4.2-2.8 6.7l0 26.1c0 1.7 .4 3.4 1.3 4.9s2.2 2.7 3.7 3.4l100.2 57.6c1.5 .9 3.2 1.3 5 1.2 1.7 0 3.4-.4 5-1.2l100.2-57.6c1.5-.8 2.7-2 3.6-3.5s1.4-3.1 1.4-4.8l0-26.1c-.8-4.6-5.4-9.1-10.4-9.1zM286.1 78a23 23 0 1 0 0-46 23 23 0 1 0 0 46zm63.6-10.1a23 23 0 1 0 0 46 23 23 0 1 0 0-46zm63.2 83.7a23 23 0 1 0 0-46 23 23 0 1 0 0 46zm-63.2-9.2a23 23 0 1 0 0 46 23 23 0 1 0 0-46zm-63.6 83.2c4.5 0 9-1.3 12.8-3.9s6.7-6.1 8.5-10.3 2.2-8.8 1.3-13.3-3.1-8.6-6.3-11.8-7.3-5.4-11.8-6.3-9.1-.4-13.3 1.3-7.8 4.7-10.3 8.5-3.9 8.2-3.9 12.8c0 3 .6 6 1.8 8.8s2.9 5.3 5 7.5 4.7 3.8 7.5 5 5.8 1.8 8.8 1.8l0 0zM224 262c4.5 0 9-1.4 12.8-3.9s6.7-6.1 8.5-10.3 2.2-8.8 1.3-13.3-3.1-8.6-6.3-11.8-7.3-5.4-11.8-6.3-9.1-.4-13.3 1.3-7.8 4.7-10.3 8.5-3.9 8.2-3.9 12.8c0 3 .6 6 1.7 8.8s2.8 5.3 5 7.5 4.7 3.8 7.5 5 5.8 1.8 8.8 1.8l0 0zm188.9-82.4c-4.6 0-9 1.3-12.8 3.9s-6.7 6.1-8.5 10.3-2.2 8.8-1.3 13.3 3.1 8.6 6.3 11.8 7.3 5.4 11.8 6.3 9.1 .4 13.3-1.3 7.8-4.7 10.3-8.5 3.9-8.2 3.9-12.8c0-6.1-2.4-11.9-6.7-16.3s-10.2-6.7-16.3-6.7l0 0zm0 72.3c-4.6 0-9 1.3-12.8 3.9s-6.7 6.1-8.5 10.3-2.2 8.8-1.3 13.3 3.1 8.6 6.3 11.8 7.3 5.4 11.8 6.3 9.1 .4 13.3-1.3 7.8-4.7 10.3-8.5 3.9-8.2 3.9-12.8c0-6.1-2.4-11.9-6.7-16.3s-10.2-6.7-16.3-6.7l0 0z"]
  };
  var faPlaystation = {
    prefix: 'fab',
    iconName: 'playstation',
    icon: [576, 512, [], "f3df", "M571 372.3c-11.3 14.2-38.8 24.3-38.8 24.3l-205.1 73.6 0-54.3 150.9-53.8c17.1-6.1 19.8-14.8 5.8-19.4-13.9-4.6-39.1-3.3-56.2 2.9l-100.5 35.5 0-56.4c23.2-7.8 47.1-13.6 75.7-16.8 40.9-4.5 90.9 .6 130.2 15.5 44.2 14 49.2 34.7 38 48.9zM346.6 279.8l0-139c0-16.3-3-31.3-18.3-35.6-11.7-3.8-19 7.1-19 23.4l0 347.9-93.8-29.8 0-414.7c39.9 7.4 98 24.9 129.2 35.4 79.5 27.3 106.4 61.3 106.4 137.8 0 74.5-46 102.8-104.5 74.6zM43.3 410.2c-45.4-12.8-53-39.5-32.3-54.8 19.1-14.2 51.7-24.9 51.7-24.9l134.5-47.8 0 54.5-96.8 34.6c-17.1 6.1-19.7 14.8-5.8 19.4s39.1 3.3 56.2-2.9l46.4-16.9 0 48.8c-51.6 9.3-101.4 7.3-153.9-10z"]
  };
  var faMicroblog = {
    prefix: 'fab',
    iconName: 'microblog',
    icon: [448, 512, [], "e01a", "M399.8 362.2c29.5-34.7 47.1-78.3 47.1-125.8 0-113-99.6-204.4-222.5-204.4S2 123.5 2 236.4 101.6 440.9 224.5 440.9c27 0 53.9-4.5 79.4-13.4 1.4-.5 3-.5 4.5-.1s2.7 1.4 3.6 2.6c18.6 25.1 47.6 42.7 79.9 49.9 1.1 .2 2.3 0 3.3-.6s1.7-1.6 1.9-2.8c.1-.6 .1-1.3 0-1.9s-.4-1.2-.8-1.7c-12.3-16-18.7-35.8-18-56s8.4-39.5 21.7-54.7l-.2 .1zM330 212.4l-57.3 43.5 20.8 68.9c.4 1.3 .4 2.7-.1 4s-1.2 2.4-2.3 3.2-2.4 1.2-3.8 1.2-2.7-.4-3.8-1.2l-59.1-41-59.1 41.1c-1.1 .8-2.4 1.2-3.8 1.2s-2.7-.4-3.8-1.2-1.9-1.9-2.3-3.2-.5-2.7-.1-4l20.8-68.9-57.3-43.5c-1.1-.8-1.9-1.9-2.3-3.2s-.4-2.7 0-4 1.2-2.4 2.3-3.2 2.4-1.3 3.7-1.3l71.9-1.5 23.7-67.9c.4-1.3 1.3-2.4 2.4-3.2s2.4-1.2 3.8-1.2 2.7 .4 3.8 1.2 1.9 1.9 2.4 3.2l23.7 67.9 71.9 1.5c1.4 0 2.7 .4 3.8 1.2s1.9 1.9 2.3 3.2 .4 2.7 0 4-1.2 2.4-2.3 3.3l0 0z"]
  };
  var faGitkraken = {
    prefix: 'fab',
    iconName: 'gitkraken',
    icon: [576, 512, [], "f3a6", "M557.7 118.1c-2.3-6.1-9.3-9.2-15.3-6.6-5.7 2.4-8.5 8.9-6.3 14.6 10.9 29 16.9 60.5 16.9 93.3 0 134.6-100.3 245.7-230.2 262.7l0-123.7c7.9-1.5 15.5-3.6 23-6.2l0 104c106.7-25.9 185.9-122.1 185.9-236.8 0-91.8-50.8-171.8-125.8-213.3-5.7-3.2-13-.9-15.9 5-2.7 5.5-.6 12.2 4.7 15.1 67.9 37.6 113.9 110 113.9 193.2 0 93.3-57.9 173.1-139.8 205.4l0-92.2c14.2-4.5 24.9-17.7 24.9-33.5 0-13.1-6.8-24.4-17.3-30.5 8.3-79.5 44.5-58.6 44.5-83.9l0-14.7c0-38-87.9-161.8-129-164.7-2.5-.2-5-.2-7.6 0-41.2 3-129.1 126.7-129.1 164.7l0 14.8c0 25.3 36.3 4.3 44.5 83.9-10.6 6.1-17.3 17.4-17.3 30.5 0 15.8 10.6 29 24.8 33.5l0 92.2c-81.9-32.2-139.8-112-139.8-205.4 0-83.1 46-155.5 113.9-193.2 5.4-3 7.4-9.6 4.7-15.1-2.9-5.9-10.1-8.2-15.9-5-75 41.5-125.8 121.5-125.8 213.3 0 114.7 79.2 210.8 185.9 236.8l0-104c7.6 2.5 15.1 4.6 23 6.2l0 123.7c-129.8-17-230.2-128.1-230.2-262.7 0-32.8 6-64.3 16.9-93.3 2.2-5.8-.6-12.2-6.3-14.6-6-2.6-13 .4-15.3 6.6-11.8 31.5-18.3 65.6-18.3 101.3 0 155.1 122.6 281.6 276.3 287.8l0-145.9c6.8 .4 15 .5 23.4 0l0 145.8c153.7-6.1 276.3-132.6 276.3-287.7 0-35.7-6.5-69.8-18.3-101.4zM357.9 322.9a23.7 23.7 0 1 1 0-47.4 23.7 23.7 0 1 1 0 47.4zM218.1 275.4a23.7 23.7 0 1 1 0 47.4 23.7 23.7 0 1 1 0-47.4z"]
  };
  var faTelegram = {
    prefix: 'fab',
    iconName: 'telegram',
    icon: [512, 512, [62462, "telegram-plane"], "f2c6", "M256 8a248 248 0 1 0 0 496 248 248 0 1 0 0-496zM371 176.7c-3.7 39.2-19.9 134.4-28.1 178.3-3.5 18.6-10.3 24.8-16.9 25.4-14.4 1.3-25.3-9.5-39.3-18.7-21.8-14.3-34.2-23.2-55.3-37.2-24.5-16.1-8.6-25 5.3-39.5 3.7-3.8 67.1-61.5 68.3-66.7 .2-.7 .3-3.1-1.2-4.4s-3.6-.8-5.1-.5c-2.2 .5-37.1 23.5-104.6 69.1-9.9 6.8-18.9 10.1-26.9 9.9-8.9-.2-25.9-5-38.6-9.1-15.5-5-27.9-7.7-26.8-16.3 .6-4.5 6.7-9 18.4-13.7 72.3-31.5 120.5-52.3 144.6-62.3 68.9-28.6 83.2-33.6 92.5-33.8 2.1 0 6.6 .5 9.6 2.9 2 1.7 3.2 4.1 3.5 6.7 .5 3.2 .6 6.5 .4 9.8z"]
  };
  var faTelegramPlane = faTelegram;
  var faItunesNote = {
    prefix: 'fab',
    iconName: 'itunes-note',
    icon: [384, 512, [], "f3b5", "M381.9 388.2c-6.4 27.4-27.2 42.8-55.1 48-24.5 4.5-44.9 5.6-64.5-10.2-23.9-20.1-24.2-53.4-2.7-74.4 17-16.2 40.9-19.5 76.8-25.8 6-1.1 11.2-2.5 15.6-7.4 6.4-7.2 4.4-4.1 4.4-163.2 0-11.2-5.5-14.3-17-12.3-8.2 1.4-185.7 34.6-185.7 34.6-10.2 2.2-13.4 5.2-13.4 16.7 0 234.7 1.1 223.9-2.5 239.5-4.2 18.2-15.4 31.9-30.2 39.5-16.8 9.3-47.2 13.4-63.4 10.4-43.2-8.1-58.4-58-29.1-86.6 17-16.2 40.9-19.5 76.8-25.8 6-1.1 11.2-2.5 15.6-7.4 10.1-11.5 1.8-256.6 5.2-270.2 .8-5.2 3-9.6 7.1-12.9 4.2-3.5 11.8-5.5 13.4-5.5 204-38.2 228.9-43.1 232.4-43.1 11.5-.8 18.1 6 18.1 17.6 .2 344.5 1.1 326-1.8 338.5z"]
  };
  var faLess = {
    prefix: 'fab',
    iconName: 'less',
    icon: [640, 512, [], "f41d", "M613.2 219c0-20.5 3.2-32.6 3.2-54.6 0-34.2-12.6-45.2-40.5-45.2l-20.5 0 0 24.2 6.3 0c14.2 0 17.3 4.7 17.3 22.1 0 16.3-1.6 32.6-1.6 51.5 0 24.2 7.9 33.6 23.6 37.3l0 1.6c-15.8 3.7-23.6 13.1-23.6 37.3 0 18.9 1.6 34.2 1.6 51.5 0 17.9-3.7 22.6-17.3 22.6l0 .5-6.3 0 0 25.2 20.5 0c27.8 0 40.5-11 40.5-45.2 0-22.6-3.2-34.2-3.2-54.6 0-11 6.8-22.6 27.3-23.6l0-27.3c-20.5-.7-27.3-12.3-27.3-23.3zM507.6 251c-15.8-6.3-30.5-10-30.5-20.5 0-7.9 6.3-12.6 17.9-12.6s22.1 4.7 33.6 13.1l21-27.8c-13.1-10-31-20.5-55.2-20.5-35.7 0-59.9 20.5-59.9 49.4 0 25.7 22.6 38.9 41.5 46.2 16.3 6.3 32.1 11.6 32.1 22.1 0 7.9-6.3 13.1-20.5 13.1-13.1 0-26.3-5.3-40.5-16.3l-21 30.5c15.8 13.1 39.9 22.1 59.9 22.1 42 0 64.6-22.1 64.6-51s-22.5-41-43-47.8zM148.7 310.4c-3.7 0-8.4-3.2-8.4-13.1l0-178.2-74.6 0c-28.4 0-41 11-41 45.2 0 22.6 3.2 35.2 3.2 54.6 0 11-6.8 22.6-27.3 23.6l0 27.3c20.5 .5 27.3 12.1 27.3 23.1 0 19.4-3.2 31-3.2 53.6 0 34.2 12.6 45.2 40.5 45.2l20.5 0 0-24.2-6.3 0c-13.1 0-17.3-5.3-17.3-22.6s1.6-32.1 1.6-51.5c0-24.2-7.9-33.6-23.6-37.3l0-1.6c15.8-3.7 23.6-13.1 23.6-37.3 0-18.9-1.6-34.2-1.6-51.5s3.7-22.1 17.3-22.1l14.1 0 0 150.8c0 32.1 11 53.1 43.1 53.1 10 0 17.9-1.6 23.6-3.7l-5.3-34.2c-3.1 .8-4.6 .8-6.2 .8zM380.4 251c-16.3-6.3-31-10-31-20.5 0-7.9 6.3-12.6 17.9-12.6s22.1 4.7 33.6 13.1l21-27.8c-13.1-10-31-20.5-55.2-20.5-35.7 0-59.9 20.5-59.9 49.4 0 25.7 22.6 38.9 41.5 46.2 16.3 6.3 32.1 11.6 32.1 22.1 0 7.9-6.3 13.1-20.5 13.1-13.1 0-26.3-5.3-40.5-16.3l-20.5 30.5c15.8 13.1 39.9 22.1 59.9 22.1 42 0 64.6-22.1 64.6-51 .1-28.9-22.5-41-43-47.8zm-155-68.8c-38.4 0-75.1 32.1-74.1 82.5 0 52 34.2 82.5 79.3 82.5 18.9 0 39.9-6.8 56.2-17.9L271 301.5c-11.6 6.8-22.6 10-34.2 10-21 0-37.3-10-41.5-34.2l95.2 0c.5-3.7 1.6-11 1.6-19.4 .6-42.6-22.6-75.7-66.7-75.7zm-30 66.2c3.2-21 15.8-31 30.5-31 18.9 0 26.3 13.1 26.3 31l-56.8 0z"]
  };
  var faFirefox = {
    prefix: 'fab',
    iconName: 'firefox',
    icon: [512, 512, [], "f269", "M503.5 241.5c-.1-1.6-.2-3.1-.2-4.7l0-.1-.4-4.7 0-.1c-1.3-13.9-3.7-27.7-7.3-41.2 0-.1 0-.1-.1-.2l-1.1-4c-.1-.2-.1-.5-.2-.6-.4-1.2-.7-2.5-1.1-3.7-.1-.2-.1-.6-.2-.8-.4-1.2-.7-2.4-1.1-3.5-.1-.4-.2-.6-.4-1-.4-1.2-.7-2.3-1.2-3.5l-.4-1.1c-.4-1.1-.8-2.3-1.2-3.4-.1-.3-.2-.7-.4-1-.5-1.1-.8-2.3-1.3-3.4-.1-.2-.2-.6-.4-.8-.5-1.2-1-2.3-1.4-3.5 0-.1-.1-.2-.1-.4-1.6-3.8-3.2-7.7-5-11.4l-.4-.7c-.5-1-.8-1.8-1.3-2.6-.2-.5-.5-1.1-.7-1.6-.4-.8-.8-1.6-1.2-2.4-.4-.6-.6-1.2-1-1.8s-.8-1.4-1.2-2.3c-.4-.6-.7-1.3-1.1-1.9s-.8-1.4-1.2-2.2c-.4-.7-.8-1.4-1.2-2-.4-.7-.8-1.3-1.2-2s-.8-1.3-1.2-2-.8-1.3-1.2-1.9-.8-1.4-1.3-2.2c-.4-.6-.8-1.2-1.2-1.8l-1.4-2.1c-.4-.6-.8-1.2-1.2-1.8-.5-.7-1.1-1.6-1.6-2.3-.4-.5-.7-1.1-1.1-1.6l-1.8-2.5c-.4-.5-.6-.8-1-1.3-1-1.3-1.8-2.5-2.8-3.7-7.2-9.4-15-18.3-23.5-26.6-5.7-6-11.8-11.5-18.3-16.7-4-3.5-8.2-6.7-12.5-9.8-7.7-5.8-16-10.8-24.6-15.1-2.4-1.3-4.8-2.5-7.2-3.7-17.7-8.6-36.3-15.2-55.4-19.6-1.9-.4-3.8-.8-5.6-1.2l-.1 0c-1-.1-1.8-.4-2.8-.5-12.5-2.4-25.2-3.7-38-4l-10.6 0c-15.3 .2-30.5 1.9-45.5 5-33.6 7.1-63.2 21.2-82.9 39-1.1 1-1.9 1.7-2.4 2.2l-.5 .5 .1 0c0 0 .1 0 .1 0s0-.1 0-.1l-.1 .1c.1-.1 .1-.1 .2-.1 14.6-8.8 34.9-16 49.4-19.6l5.9-1.4c.4-.1 .8-.1 1.2-.2 1.7-.4 3.4-.7 5.2-1.1 .2 0 .6-.1 .8-.1 64.2-11.7 132.6 7.5 180.2 53 10.3 9.8 19.3 20.8 26.9 32.8 30.4 49.2 27.5 111.1 3.8 147.6-34.4 53-111.4 71.3-159 24.8-16-15.5-25.2-36.7-25.6-59-.2-10.7 2-21.2 6.2-31 1.7-3.8 13.1-25.7 18.2-24.6-13.1-2.8-37.5 2.6-54.7 28.2-15.4 22.9-14.5 58.2-5 83.3-6-12.4-10.1-25.6-12.1-39.2-12.2-82.6 43.3-153 94.3-170.5-27.5-24-96.5-22.3-147.7 15.4-29.9 22-51.2 53.2-62.5 90.4 1.7-20.9 9.6-52.1 25.8-83.9-17.2 8.9-39 37-49.8 62.9-15.6 37.4-21 82.2-16.1 124.8 .4 3.2 .7 6.4 1.1 9.6 19.9 117.1 122 206.4 244.8 206.4 137.1 0 248.3-111.2 248.3-248.4-.1-4.5-.2-9.1-.5-13.5z"]
  };
  var faKaggle = {
    prefix: 'fab',
    iconName: 'kaggle',
    icon: [320, 512, [], "f5fa", "M304.2 501.5L158.4 320.3 298.2 185c2.6-2.7 1.7-10.5-5.3-10.5l-69.2 0c-3.5 0-7 1.8-10.5 5.3l-132.3 133.7 0-306c0-5-2.5-7.5-7.5-7.5L21.5 0C16.5 0 14 2.5 14 7.5l0 497c0 5 2.5 7.5 7.5 7.5l51.9 0c5 0 7.5-2.5 7.5-7.5l0-109 30.8-29.3 110.5 140.6c3 3.5 6.5 5.3 10.5 5.3l66.9 0c3.5 0 5.5-1 6-3l-1.4-7.6z"]
  };
  var faFacebookMessenger = {
    prefix: 'fab',
    iconName: 'facebook-messenger',
    icon: [512, 512, [], "f39f", "M256.6 8c-140 0-248.6 102.3-248.6 240.6 0 72.3 29.7 134.8 78.1 177.9 8.3 7.5 6.6 11.9 8 58.2 .1 3.2 1 6.4 2.6 9.2s3.9 5.2 6.7 6.9 5.9 2.8 9.1 3 6.5-.3 9.5-1.6C174.9 479 175.6 477.2 184.6 479.6 337.8 521.8 504 423.7 504 248.6 504 110.3 396.6 8 256.6 8zM405.8 193.1l-73 115.6c-2.8 4.3-6.4 8.1-10.6 11s-9.1 4.8-14.1 5.8-10.3 .8-15.3-.4-9.7-3.4-13.8-6.4l-58.1-43.5c-2.6-1.9-5.8-3-9-3s-6.4 1.1-9 3l-78.4 59.4c-10.5 7.9-24.2-4.6-17.1-15.7l73-115.6c2.8-4.3 6.4-8.1 10.6-11s9.1-4.8 14.1-5.8 10.3-.8 15.3 .4 9.7 3.4 13.9 6.4l58.1 43.5c2.6 1.9 5.8 3 9 3s6.4-1.1 9-3l78.4-59.4c10.4-8 24.1 4.5 17.1 15.6z"]
  };
  var faAudible = {
    prefix: 'fab',
    iconName: 'audible',
    icon: [640, 512, [], "f373", "M640 199.9l0 54-320 200-320-199.9 0-54 320 200 320-200.1zm-194.5 72l47.1-29.4c-37.2-55.8-100.7-92.6-172.7-92.6s-135.5 36.7-172.6 92.4l.3 0c2.5-2.3 5.1-4.5 7.7-6.7 89.7-74.4 219.4-58.1 290.2 36.3zM225.4 290.7c16.9-11.9 36.5-18.7 57.4-18.7 34.4 0 65.2 18.4 86.4 47.6l45.4-28.4c-20.9-29.9-55.6-49.5-94.8-49.5-38.9 0-73.4 19.4-94.4 49zM103.6 161.1C235.4 56.8 421.8 84.7 521.1 223.2l.7 1 48.8-30.4c-53.5-81.7-145.8-135.7-250.7-135.7-103.5 0-196.6 53.5-250.5 135.6 9.9-10.5 22.7-23.5 34.2-32.6z"]
  };
  var faPatreon = {
    prefix: 'fab',
    iconName: 'patreon',
    icon: [512, 512, [], "f3d9", "M490 153.8c-.1-65.4-51-119-110.7-138.3-74.2-24-172-20.5-242.9 12.9-85.8 40.5-112.8 129.3-113.8 217.8-.8 72.8 6.4 264.4 114.6 265.8 80.3 1 92.3-102.5 129.5-152.3 26.4-35.5 60.5-45.5 102.4-55.9 72-17.8 121.1-74.7 121-150l-.1 0z"]
  };
  var faVnv = {
    prefix: 'fab',
    iconName: 'vnv',
    icon: [640, 512, [], "f40b", "M104.9 352c-34.1 0-46.4-30.4-46.4-30.4L2.6 210.1S-7.8 192 13 192l32.8 0c10.4 0 13.2 8.7 18.8 18.1l36.7 74.5s5.2 13.1 21.1 13.1 21.1-13.1 21.1-13.1l36.7-74.5c5.6-9.5 8.4-18.1 18.8-18.1l32.8 0c20.8 0 10.4 18.1 10.4 18.1L186.4 321.6S174.2 352 140 352l-35.1 0zm395 0c-34.1 0-46.4-30.4-46.4-30.4L397.6 210.1S387.2 192 408 192l32.8 0c10.4 0 13.2 8.7 18.8 18.1l36.7 74.5s5.2 13.1 21.1 13.1 21.1-13.1 21.1-13.1l36.8-74.5c5.6-9.5 8.4-18.1 18.8-18.1l32.9 0c20.8 0 10.4 18.1 10.4 18.1L581.5 321.6S569.3 352 535.1 352l-35.2 0zM337.6 192c34.1 0 46.4 30.4 46.4 30.4l55.9 111.5S450.3 352 429.5 352l-32.8 0c-10.4 0-13.2-8.7-18.8-18.1l-36.7-74.5s-5.2-13.1-21.1-13.1-21.1 13.1-21.1 13.1l-36.7 74.5c-5.6 9.4-8.4 18.1-18.8 18.1l-32.9 0c-20.8 0-10.4-18.1-10.4-18.1l55.9-111.5S268.3 192 302.5 192l35.1 0z"]
  };
  var faPagelines = {
    prefix: 'fab',
    iconName: 'pagelines',
    icon: [384, 512, [], "f18c", "M384.1 312.7c-55.1 136.7-187.1 54-187.1 54-40.5 81.8-107.4 134.4-184.6 134.7-16.1 0-16.6-24.4 0-24.4 64.4-.3 120.5-42.7 157.2-110.1-41.1 15.9-118.6 27.9-161.6-82.2 109-44.9 159.1 11.2 178.3 45.5 9.9-24.4 17-50.9 21.6-79.7 0 0-139.7 21.9-149.5-98.1 119.1-47.9 152.6 76.7 152.6 76.7 1.6-16.7 3.3-52.6 3.3-53.4 0 0-106.3-73.7-38.1-165.2 124.6 43 61.4 162.4 61.4 162.4 .5 1.6 .5 23.8 0 33.4 0 0 45.2-89 136.4-57.5-4.2 134-141.9 106.4-141.9 106.4-4.4 27.4-11.2 53.4-20 77.5 0 0 83-91.8 172-20z"]
  };
  var faAmazon = {
    prefix: 'fab',
    iconName: 'amazon',
    icon: [448, 512, [], "f270", "M257.7 162.7c-48.7 1.8-169.5 15.5-169.5 117.5 0 109.5 138.3 114 183.5 43.2 6.5 10.2 35.4 37.5 45.3 46.8l56.8-56s-32.3-25.3-32.3-52.8l0-147.1C341.5 89 317 32 229.2 32 141.2 32 94.5 87 94.5 136.3l73.5 6.8c16.3-49.5 54.2-49.5 54.2-49.5 40.7-.1 35.5 29.8 35.5 69.1zm0 86.8c0 80-84.2 68-84.2 17.2 0-47.2 50.5-56.7 84.2-57.8l0 40.6zM393.7 413c-7.7 10-70 67-174.5 67S34.7 408.5 10.2 379c-6.8-7.7 1-11.3 5.5-8.3 73.3 44.5 187.8 117.8 372.5 30.3 7.5-3.7 13.3 2 5.5 12zm39.8 2.2c-6.5 15.8-16 26.8-21.2 31-5.5 4.5-9.5 2.7-6.5-3.8s19.3-46.5 12.7-55c-6.5-8.3-37-4.3-48-3.2-10.8 1-13 2-14-.3-2.3-5.7 21.7-15.5 37.5-17.5 15.7-1.8 41-.8 46 5.7 3.7 5.1 0 27.1-6.5 43.1z"]
  };
  var faEnvira = {
    prefix: 'fab',
    iconName: 'envira',
    icon: [448, 512, [], "f299", "M0 32c477.6 0 366.6 317.3 367.1 366.3l80.9 81.7-26 0-70.4-71.2C312.6 413 227.2 443.3 137.2 371.8 47 300.3 52 214.7 0 32zM79.7 78c-49.7-23.5-5.2 9.2-5.2 9.2 45.2 31.2 66 73.7 90.2 119.9 31.5 60.2 79 139.7 144.2 167.7 65 28 34.2 12.5 6-8.5-28.2-21.2-68.2-87-91-130.2-31.7-60-61-118.6-144.2-158.1z"]
  };
  var faLinode = {
    prefix: 'fab',
    iconName: 'linode',
    icon: [448, 512, [], "f2b8", "M366.3 186.9l-59.5 36.9-.8 36.9-29.3-19.3-39.4 24.3c2.2 55.2 2.5 59.3 2.5 59.5l-97.2 65.4-15.1-104.7 108.1-62-40.2-26-75.4 38.5-21-143.3 129-49.4-91.3-43.6-125.7 39.4 27.7 134.9 41.9 32.7-31.8 15.1 20.9 101.4 29.3 27.7-20.9 12.6 16.8 78.8 66.2 69.6c-10.8-74.8-11.7-78.6-11.7-78.8l77.9-55.3C244 365.4 242.3 367 242.3 367l.8 24.3 33.5 28.5-.8-77.1 46.9-33.5 26.8-18.4-2.5 36 25.1 17.6 6.7-74.6 58.7-43.6-71.2-39.4z"]
  };
  var faAccusoft = {
    prefix: 'fab',
    iconName: 'accusoft',
    icon: [640, 512, [], "f369", "M322.1 252l0-1-51.2-65.8s-12 1.6-25 15.1c-9 9.3-242.1 239.1-243.4 240.9-7 10 1.6 6.8 15.7 1.7 .8 0 114.5-36.6 114.5-36.6 .5-.6-.1-.1 .6-.6-.4-5.1-.8-26.2-1-27.7-.6-5.2 2.2-6.9 7-8.9l92.6-33.8c.6-.8 88.5-81.7 90.2-83.3zM482.2 372.1c13.3 16.1 20.7 13.3 30.8 9.3 3.2-1.2 115.4-47.6 117.8-48.9 8-4.3-1.7-16.7-7.2-23.4-2.1-2.5-205.1-245.6-207.2-248.3-9.7-12.2-14.3-12.9-38.4-12.8-10.2 0-106.8 .5-116.5 .6-19.2 .1-32.9-.3-19.2 16.9 7.7 9.5 234.2 299.7 239.9 306.6zm152.7 1.6c-2.3-.3-24.6-4.7-38-7.2 0 0-115 50.4-117.5 51.6-16 7.3-26.9-3.2-36.7-14.6l-57.1-74c-5.4-.9-60.4-9.6-65.3-9.3-3.1 .2-9.6 .8-14.4 2.9-4.9 2.1-145.2 52.8-150.2 54.7-5.1 2-11.4 3.6-11.1 7.6 .2 2.5 2 2.6 4.6 3.5 2.7 .8 300.9 67.6 308 69.1 15.6 3.3 38.5 10.5 53.6 1.7 2.1-1.2 123.8-76.4 125.8-77.8 5.4-4 4.3-6.8-1.7-8.2z"]
  };
  var faErlang = {
    prefix: 'fab',
    iconName: 'erlang',
    icon: [640, 512, [], "f39d", "M87.2 53.5l-87.2 0 0 405 100.4 0c-49.7-52.6-78.8-125.3-78.7-212.1-.1-76.7 24-142.7 65.5-192.9zm238.2 9.7c-45.9 .1-85.1 33.5-89.2 83.2l169.9 0c-1.1-49.7-34.5-83.1-80.7-83.2zm230.7-9.6l.3 0-.1-.1-.2 .1zm.3 0c31.4 42.7 48.7 97.5 46.2 162.7 .5 6 .5 11.7 0 24.1l-372.4 0c-.2 109.7 38.9 194.9 138.6 195.3 68.5-.3 118-51 151.9-106.1l96.4 48.2c-17.4 30.9-36.5 57.8-57.9 80.8l80.8 0 0-405-83.6 0z"]
  };
  var faCcDiscover = {
    prefix: 'fab',
    iconName: 'cc-discover',
    icon: [576, 512, [], "f1f2", "M520.4 196.1c0-7.9-5.5-12.1-15.6-12.1l-4.9 0 0 24.9 4.7 0c10.3 0 15.8-4.4 15.8-12.8zM528 32L48 32C21.5 32 0 53.5 0 80L0 432c0 26.5 21.5 48 48 48l480 0c26.5 0 48-21.5 48-48l0-352c0-26.5-21.5-48-48-48zM483.9 170.9c22.6 0 52.9-4.1 52.9 24.4 0 12.6-6.6 20.7-18.7 23.2l25.8 34.4-19.6 0-22.2-32.8-2.2 0 0 32.8-16 0 0-82zM428 171l45.3 0 0 14-29.3 0 0 18.2 28.3 0 0 13.8-28.3 0 0 22.2 29.3 0 0 13.8-45.3 0 0-82zm-68.7 0l21.9 55.2 22.2-55.2 17.5 0-35.5 84.2-8.6 0-35-84.2 17.5 0zm-55.9 86.2a44.6 44.6 0 1 1 0-89.2 44.6 44.6 0 1 1 0 89.2zm-49.3-83.1l0 19c-20.1-20.1-46.8-4.7-46.8 19 0 25 27.5 38.5 46.8 19.2l0 19c-29.7 14.3-63.3-5.7-63.3-38.2 0-31.2 33.1-53 63.3-38zm-97.2 66.3c11.4 0 22.4-15.3-3.3-24.4-15-5.5-20.2-11.4-20.2-22.7 0-23.2 30.6-31.4 49.7-14.3l-8.4 10.8c-10.4-11.6-24.9-6.2-24.9 2.5 0 4.4 2.7 6.9 12.3 10.3 18.2 6.6 23.6 12.5 23.6 25.6 0 29.5-38.8 37.4-56.6 11.3l10.3-9.9c3.7 7.1 9.9 10.8 17.5 10.8zM55.4 253l-23.4 0 0-82 23.4 0c26.1 0 44.1 17 44.1 41.1 0 18.5-13.2 40.9-44.1 40.9zm67.5 0l-16 0 0-82 16 0 0 82zM544 433c0 8.2-6.8 15-15 15l-401 0c189.6-35.6 382.7-139.2 416-160l0 145zM74.1 191.6c-5.2-4.9-11.6-6.6-21.9-6.6l-4.2 0 0 54.2 4.2 0c10.3 0 17-2 21.9-6.4 5.7-5.2 8.9-12.8 8.9-20.7s-3.2-15.5-8.9-20.5z"]
  };
  var faSafari = {
    prefix: 'fab',
    iconName: 'safari',
    icon: [512, 512, [], "f267", "M274.7 274.7L237.3 237.3 166 346 274.7 274.7zM256 8a248 248 0 1 0 0 496 248 248 0 1 0 0-496zM411.8 182.8l14.8-6.1c1-.4 2-.6 3.1-.6s2.1 .2 3.1 .6 1.8 1 2.6 1.7 1.3 1.6 1.7 2.6 .6 2 .6 3.1-.2 2.1-.6 3.1-1 1.9-1.7 2.6-1.6 1.3-2.6 1.7L418 197.6c-2 .8-4.2 .8-6.1 0s-3.5-2.4-4.3-4.3-.8-4.2 0-6.1 2.4-3.5 4.3-4.3zM314.4 94l6.1-14.8c.8-2 2.4-3.5 4.3-4.3s4.2-.8 6.1 0 3.5 2.4 4.3 4.3 .8 4.2 0 6.1l-6.1 14.8c-.8 2-2.4 3.5-4.3 4.3s-4.2 .8-6.1 0c-1-.4-1.9-1-2.6-1.7s-1.3-1.6-1.7-2.6-.6-2-.6-3.1 .2-2.1 .6-3.1zM256 60c2.1 0 4.2 .8 5.7 2.3S264 65.9 264 68l0 16c0 2.1-.8 4.2-2.3 5.7s-3.5 2.3-5.7 2.3-4.2-.8-5.7-2.3-2.3-3.5-2.3-5.7l0-16c0-2.1 .8-4.2 2.3-5.7S253.9 60 256 60zM181 74.9c1-.4 2-.6 3.1-.6s2.1 .2 3.1 .6 1.9 1 2.6 1.7 1.3 1.6 1.7 2.6L197.6 94c.4 1 .7 2 .7 3.1s-.2 2.1-.6 3.1-1 1.9-1.7 2.6-1.6 1.4-2.6 1.8-2 .6-3.1 .6-2.1-.2-3.1-.6-1.9-1-2.6-1.8-1.3-1.7-1.7-2.7l-6.1-14.8c-.8-2-.8-4.2 0-6.1s2.4-3.5 4.3-4.3zm-63.6 42.5c1.5-1.5 3.5-2.3 5.7-2.3s4.2 .8 5.7 2.3L140 128.7c1.5 1.5 2.3 3.5 2.3 5.6s-.8 4.1-2.3 5.6c-1.5 1.5-3.5 2.3-5.7 2.3s-4.2-.8-5.7-2.3l-11.3-11.3c-1.5-1.5-2.3-3.5-2.3-5.6s.8-4.1 2.3-5.6l0 0zM60 256c0-2.1 .8-4.2 2.3-5.7S65.9 248 68 248l16 0c2.1 0 4.2 .8 5.7 2.3s2.3 3.5 2.3 5.7-.8 4.2-2.3 5.7-3.5 2.3-5.7 2.3l-16 0c-2.1 0-4.2-.8-5.7-2.3S60 258.1 60 256zm40.2 73.2l-14.8 6.1c-1 .4-2 .6-3.1 .6s-2.1-.2-3.1-.6-1.9-1-2.6-1.7-1.3-1.6-1.7-2.6-.6-2-.6-3.1 .2-2.1 .6-3.1 1-1.9 1.7-2.6 1.6-1.3 2.6-1.7L94 314.4c2-.8 4.2-.8 6.1 0s3.5 2.4 4.3 4.3 .8 4.2 0 6.1-2.4 3.5-4.3 4.3zm4.3-136c-.4 1-1 1.9-1.7 2.6s-1.6 1.3-2.6 1.7-2 .6-3.1 .6-2.1-.2-3.1-.6l-14.8-6.1c-2-.8-3.5-2.4-4.3-4.3s-.8-4.2 0-6.1 2.4-3.5 4.3-4.3 4.2-.8 6.1 0l14.8 6.1c2 .8 3.5 2.4 4.3 4.3s.8 4.2 0 6.1l0 0zM197.6 418l-6.1 14.8c-.4 1-1 1.9-1.7 2.6s-1.6 1.3-2.6 1.7-2 .6-3.1 .6-2.1-.2-3.1-.6-1.9-1-2.6-1.7-1.3-1.6-1.7-2.6-.6-2-.6-3.1 .2-2.1 .6-3.1l6.1-14.8c.4-1 1-1.9 1.7-2.7s1.6-1.4 2.6-1.8 2-.6 3.1-.6 2.1 .2 3.1 .6 1.9 1 2.6 1.8 1.3 1.7 1.7 2.6 .6 2 .6 3.1-.2 2.1-.7 3.1zM264 444c0 2.1-.8 4.2-2.3 5.7s-3.5 2.3-5.7 2.3-4.2-.8-5.7-2.3-2.3-3.5-2.3-5.7l0-16c0-2.1 .8-4.2 2.3-5.7s3.5-2.3 5.7-2.3 4.2 .8 5.7 2.3 2.3 3.5 2.3 5.7l0 16zm67-6.9c-1 .4-2 .6-3.1 .6s-2.1-.2-3.1-.6-1.9-1-2.6-1.7-1.3-1.6-1.7-2.6L314.4 418c-.8-2-.8-4.2 0-6.1s2.4-3.5 4.3-4.3 4.2-.8 6.1 0 3.5 2.4 4.3 4.3l6.1 14.8c.8 2 .8 4.2 0 6.1s-2.4 3.5-4.3 4.3zm63.6-42.5c-1.5 1.5-3.5 2.3-5.7 2.3s-4.2-.8-5.7-2.3L372 383.3c-1.5-1.5-2.3-3.5-2.3-5.6s.8-4.1 2.3-5.6 3.5-2.3 5.7-2.3 4.2 .8 5.7 2.3l11.3 11.3c1.5 1.5 2.3 3.5 2.3 5.6s-.8 4.1-2.3 5.6l0 0zM286.2 286.2L110.3 401.7 225.8 225.8 401.7 110.3 286.2 286.2zM437.1 331c-.8 2-2.4 3.5-4.3 4.3s-4.2 .8-6.1 0l-14.8-6.1c-2-.8-3.5-2.4-4.3-4.3s-.8-4.2 0-6.1c.4-1 1-1.9 1.7-2.6s1.6-1.3 2.6-1.7 2-.6 3.1-.6 2.1 .2 3.1 .6l14.8 6.1c2 .8 3.5 2.4 4.3 4.3s.8 4.2 0 6.1zm6.9-67l-16 0c-2.1 0-4.2-.8-5.7-2.3s-2.3-3.5-2.3-5.7 .8-4.2 2.3-5.7 3.5-2.3 5.7-2.3l16 0c2.1 0 4.2 .8 5.7 2.3s2.3 3.5 2.3 5.7-.8 4.2-2.3 5.7-3.5 2.3-5.7 2.3z"]
  };
  var faSpaceAwesome = {
    prefix: 'fab',
    iconName: 'space-awesome',
    icon: [512, 512, [], "e5ac", "M96 256l32 0 0 256-128 0 0-160 32 0 0-32 32 0 0-32 32 0 0-32zm416 96l0 160-128 0 0-256 32 0 0 32 32 0 0 32 32 0 0 32 32 0zM320 64l32 0 0 384-32 0 0-32-128 0 0 32-32 0 0-384 32 0 0-32 32 0 0-32 64 0 0 32 32 0 0 32zm-32 64l-64 0 0 64 64 0 0-64z"]
  };
  var faNode = {
    prefix: 'fab',
    iconName: 'node',
    icon: [640, 512, [], "f419", "M316.3 452c-2.1 0-4.2-.6-6.1-1.6L291 439c-2.9-1.6-1.5-2.2-.5-2.5 3.8-1.3 4.6-1.6 8.7-4 .4-.2 1-.1 1.4 .1l14.8 8.8c.5 .3 1.3 .3 1.8 0L375 408c.5-.3 .9-.9 .9-1.6l0-66.7c0-.7-.3-1.3-.9-1.6l-57.8-33.3c-.5-.3-1.2-.3-1.8 0l-57.8 33.3c-.6 .3-.9 1-.9 1.6l0 66.7c0 .6 .4 1.2 .9 1.5l15.8 9.1c8.6 4.3 13.9-.8 13.9-5.8l0-65.9c0-.9 .7-1.7 1.7-1.7l7.3 0c.9 0 1.7 .7 1.7 1.7l0 65.9c0 11.5-6.2 18-17.1 18-3.3 0-6 0-13.3-3.6l-15.2-8.7c-3.7-2.2-6.1-6.2-6.1-10.5l0-66.7c0-4.3 2.3-8.4 6.1-10.5l57.8-33.4c3.7-2.1 8.5-2.1 12.1 0l57.8 33.4c3.7 2.2 6.1 6.2 6.1 10.5l0 66.7c0 4.3-2.3 8.4-6.1 10.5l-57.8 33.4c-1.7 1.1-3.8 1.7-6 1.7zM363 386.2c0-12.5-8.4-15.8-26.2-18.2-18-2.4-19.8-3.6-19.8-7.8 0-3.5 1.5-8.1 14.8-8.1 11.9 0 16.3 2.6 18.1 10.6 .2 .8 .8 1.3 1.6 1.3l7.5 0c.5 0 .9-.2 1.2-.5 .3-.4 .5-.8 .4-1.3-1.2-13.8-10.3-20.2-28.8-20.2-16.5 0-26.3 7-26.3 18.6 0 12.7 9.8 16.1 25.6 17.7 18.9 1.9 20.4 4.6 20.4 8.3 0 6.5-5.2 9.2-17.4 9.2-15.3 0-18.7-3.8-19.8-11.4-.1-.8-.8-1.4-1.7-1.4l-7.5 0c-.9 0-1.7 .7-1.7 1.7 0 9.7 5.3 21.3 30.6 21.3 18.5 0 29-7.2 29-19.8zm54.5-50.1c0 6.1-5 11.1-11.1 11.1s-11.1-5-11.1-11.1c0-6.3 5.2-11.1 11.1-11.1 6-.1 11.1 4.8 11.1 11.1zm-1.8 0c0-5.2-4.2-9.3-9.4-9.3-5.1 0-9.3 4.1-9.3 9.3s4.2 9.4 9.3 9.4c5.2-.1 9.4-4.3 9.4-9.4zm-4.5 6.2l-2.6 0c-.1-.6-.5-3.8-.5-3.9-.2-.7-.4-1.1-1.3-1.1l-2.2 0 0 5-2.4 0 0-12.5 4.3 0c1.5 0 4.4 0 4.4 3.3 0 2.3-1.5 2.8-2.4 3.1 1.7 .1 1.8 1.2 2.1 2.8 .1 1 .3 2.7 .6 3.3zm-2.8-8.8c0-1.7-1.2-1.7-1.8-1.7l-2 0 0 3.5 1.9 0c1.6 0 1.9-1.1 1.9-1.8zM137.3 191c0-2.7-1.4-5.1-3.7-6.4L72.3 149.3c-1-.6-2.2-.9-3.4-1l-.6 0c-1.2 0-2.3 .4-3.4 1L3.7 184.6C1.4 185.9 0 188.4 0 191l.1 95c0 1.3 .7 2.5 1.8 3.2s2.5 .7 3.7 0L42 268.3c2.3-1.4 3.7-3.8 3.7-6.4l0-44.4c0-2.6 1.4-5.1 3.7-6.4l15.5-8.9c1.2-.7 2.4-1 3.7-1s2.6 .3 3.7 1l15.5 8.9c2.3 1.3 3.7 3.8 3.7 6.4l0 44.4c0 2.6 1.4 5.1 3.7 6.4l36.4 20.9c1.1 .7 2.6 .7 3.7 0 1.1-.6 1.8-1.9 1.8-3.2l.2-95zM472.5 87.3l0 176.4c0 2.6-1.4 5.1-3.7 6.4l-61.3 35.4c-2.3 1.3-5.1 1.3-7.4 0l-61.3-35.4c-2.3-1.3-3.7-3.8-3.7-6.4l0-70.8c0-2.6 1.4-5.1 3.7-6.4l61.3-35.4c2.3-1.3 5.1-1.3 7.4 0l15.3 8.8c1.7 1 3.9-.3 3.9-2.2l0-94c0-2.8 3-4.6 5.5-3.2l36.5 20.4c2.3 1.2 3.8 3.7 3.8 6.4zm-46 128.9c0-.7-.4-1.3-.9-1.6l-21-12.2c-.6-.3-1.3-.3-1.9 0l-21 12.2c-.6 .3-.9 .9-.9 1.6l0 24.3c0 .7 .4 1.3 .9 1.6l21 12.1c.6 .3 1.3 .3 1.8 0l21-12.1c.6-.3 .9-.9 .9-1.6l0-24.3 .1 0zm209.8-.7c2.3-1.3 3.7-3.8 3.7-6.4l0-17.1c0-2.6-1.4-5.1-3.7-6.4l-60.9-35.4c-2.3-1.3-5.1-1.3-7.4 0l-61.3 35.4c-2.3 1.3-3.7 3.8-3.7 6.4l0 70.8c0 2.7 1.4 5.1 3.7 6.4l60.9 34.7c2.2 1.3 5 1.3 7.3 0l36.8-20.5c2.5-1.4 2.5-5 0-6.4L550 241.6c-1.2-.7-1.9-1.9-1.9-3.2l0-22.2c0-1.3 .7-2.5 1.9-3.2l19.2-11.1c1.1-.7 2.6-.7 3.7 0L592.1 213c1.1 .7 1.9 1.9 1.9 3.2l0 17.4c0 2.8 3.1 4.6 5.6 3.2l36.7-21.3zM559 219c-.4 .3-.7 .7-.7 1.2l0 13.6c0 .5 .3 1 .7 1.2l11.8 6.8c.4 .3 1 .3 1.4 0L584 235c.4-.3 .7-.7 .7-1.2l0-13.6c0-.5-.3-1-.7-1.2l-11.8-6.8c-.4-.3-1-.3-1.4 0L559 219zM304.8 262.5l0-70.4c0-2.6-1.6-5.1-3.9-6.4l-61.1-35.2c-2.1-1.2-5-1.4-7.4 0l-61.1 35.2c-2.3 1.3-3.9 3.7-3.9 6.4l0 70.4c0 2.8 1.9 5.2 4 6.4l61.2 35.2c2.4 1.4 5.2 1.3 7.4 0l61-35.2c1.8-1 3.1-2.7 3.6-4.7 .1-.5 .2-1.1 .2-1.7zM230.5 137.6l-.8 .5 1.1 0-.3-.5zm76.2 130.2l-.4-.7 0 .9 .4-.2z"]
  };
  var faCodepen = {
    prefix: 'fab',
    iconName: 'codepen',
    icon: [512, 512, [], "f1cb", "M502.3 159.7l-234-156c-8-4.9-16.5-5-24.6 0l-234 156c-6 4-9.7 11.1-9.7 18.3L0 334c0 7.1 3.7 14.3 9.7 18.3l234 156c8 4.9 16.5 5 24.6 0l234-156c6-4 9.7-11.1 9.7-18.3l0-156c0-7.1-3.7-14.3-9.7-18.3zM278 63.1l172.3 114.9-76.9 51.4-95.4-63.7 0-102.6zm-44 0L234 165.7 138.6 229.4 61.7 178 234 63.1zM44 219.1L99.1 256 44 292.8 44 219.1zM234 448.8L61.7 334 138.6 282.6 234 346.3 234 448.8zM256 308l-77.7-52 77.7-52 77.7 52-77.7 52zm22 140.9l0-102.6 95.4-63.7 76.9 51.4-172.3 114.9zm190-156l-55.1-36.9 55.1-36.9 0 73.7z"]
  };
  var faRavelry = {
    prefix: 'fab',
    iconName: 'ravelry',
    icon: [512, 512, [], "f2d9", "M498.6 234.2c-1.2-10.3-1.7-20.8-3.7-31-2.5-12.4-5.7-24.6-9.6-36.6-6.8-20.9-17.2-40.3-30.9-57.5-5.9-7.6-12.1-14.8-18.8-21.7-14.1-14-30-26.1-47.1-36.1-17.8-10.6-36.8-18.9-56.7-24.7-11-3.1-22.3-5.4-33.5-7.6-6.8-1.3-13.7-1.7-20.6-2.5-.3 0-.6-.4-.9-.6-10.8 0-21.5 0-32.3 0-2.4 .4-4.8 .9-7.2 1.2-11.6 1.2-23.1 3.6-34.3 7.1-13.8 4.1-27.1 9.6-39.8 16.4-13.3 7-26.1 15.1-38.1 24.2-6.2 4.6-12.3 9.4-18 14.5-10.2 9.2-20.4 18.4-29.9 28.3-12.8 13.3-24.1 28.1-33.6 44-8.6 14-15.5 29-20.5 44.6-7.2 22.7-10.3 46.6-9.2 70.3 .6 13.5 2 26.9 4.4 40.2 3.4 18.4 9 36.3 16.7 53.3 13.6 29.2 32.1 51.5 50.4 67.9 12.8 11.6 26.8 21.9 41.8 30.6 17.7 10.4 36.4 18.9 55.9 25.3 13.3 4.3 26.9 7.6 40.6 9.8 6.1 1 12.3 1.3 18.4 1.9 .4 .1 .8 .3 1.2 .6l32.3 0c2.5-.4 5-.9 7.5-1.1 16.3-1.3 32.1-5.3 47.5-10.7 17.2-5.9 33.7-13.9 49-23.8 9.7-6.4 19.4-13.1 28.7-20.1 5.8-4.3 11-9.5 16.3-14.5 4-3.7 7.8-7.6 11.5-11.5 12-12.7 22.6-26.6 31.4-41.6 9.5-16 17.4-32.9 22.3-50.9 2.9-10.4 4.9-21 7-31.7 1-5.3 1.3-10.7 1.9-16.1 0-.3 .4-.6 .6-.9l0-37.1c-.2-.6-.4-1.2-.6-1.8zm-161.1-1.2s-16.6-3-28.5-3c-27.2 0-33.6 14.9-33.6 37l0 93.7-73.5 0 0-190.7 73.5 0 0 31.9c8.9-26.8 26.8-36.2 62-36.2l0 67.3z"]
  };
  var faAlipay = {
    prefix: 'fab',
    iconName: 'alipay',
    icon: [448, 512, [], "f642", "M377.7 32L70.3 32C31.4 32 0 63.4 0 102.3L0 409.7C0 448.6 31.4 480 70.3 480l307.5 0c38.5 0 69.8-31.1 70.3-69.6-46-25.6-110.6-60.3-171.6-88.4-32.1 44-84.1 81-148.6 81-70.6 0-93.7-45.3-97-76.4-4-39 14.9-81.5 99.5-81.5 35.4 0 79.4 10.2 127.1 25 16.5-30.1 26.5-60.3 26.5-60.3l-178.2 0 0-16.7 92.1 0 0-31.2-109.4 0 0-19 109.4 0 0-50.4 50.9 0 0 50.4 109.4 0 0 19-109.4 0 0 31.2 88.8 0s-15.2 46.6-38.3 90.9c48.9 16.7 100 36 148.6 52.7l0-234.4c.2-38.7-31.2-70.3-69.9-70.3zM47.3 323c1 20.2 10.2 53.7 69.9 53.7 52.1 0 92.6-39.7 117.9-72.9-44.6-18.7-84.5-31.4-109.4-31.4-67.4 0-79.4 33.1-78.4 50.6z"]
  };
  var faCcAmex = {
    prefix: 'fab',
    iconName: 'cc-amex',
    icon: [576, 512, [], "f1f3", "M0 432c0 26.5 21.5 48 48 48l480 0c26.5 0 48-21.5 48-48l0-1.1-61.7 0-31.9-35.1-31.9 35.1-203.7 0 0-163.8-65.8 0 81.7-184.7 78.6 0 28.1 63.2 0-63.2 97.2 0 16.9 47.6 17-47.6 75.5 0 0-2.4c0-26.5-21.5-48-48-48L48 32C21.5 32 0 53.5 0 80L0 432zm440.4-21.7l42.2-46.3 42 46.3 51.4 0-68-72.1 68-72.1-50.6 0-42 46.7-41.5-46.7-51.4 0 67.5 72.5-67.4 71.6 0-33.1-83 0 0-22.2 80.9 0 0-32.3-80.9 0 0-22.4 83 0 0-33.1-122 0 0 143.2 171.8 0zm96.3-72l39.3 41.9 0-83.3-39.3 41.4zm-36.3-92l36.9-100.6 0 100.6 38.7 0 0-143.3-60.2 0-32.2 89.3-31.9-89.3-61.2 0 0 143.1-63.2-143.1-51.2 0-62.4 143.3 43 0 11.9-28.7 65.9 0 12 28.7 82.7 0 0-100.3 36.8 100.3 34.4 0zM282 185.4l19.5-46.9 19.4 46.9-38.9 0z"]
  };
  var faPiedPiperAlt = {
    prefix: 'fab',
    iconName: 'pied-piper-alt',
    icon: [576, 512, [], "f1a8", "M244 246c-3.2-2-6.3-2.9-10.1-2.9-6.6 0-12.6 3.2-19.3 3.7l1.7 4.9 27.7-5.7zM379.9 443.9c-19 0-64.1 9.5-79.9 19.8l6.9 45.1c35.7 6.1 70.1 3.6 106-9.8-4.8-10-23.5-55.1-33-55.1zM340.8 177c6.6 2.8 11.5 9.2 22.7 22.1 2-1.4 7.5-5.2 7.5-8.6 0-4.9-11.8-13.2-13.2-23 11.2-5.7 25.2-6 37.6-8.9 68.1-16.4 116.3-52.9 146.8-116.7 6.1-12.6 11.8-25.8 12.4-39.9l-2 2.6c-28.4 50-33 63.2-81.3 100-31.9 24.4-69.2 40.2-106.6 54.6l-6.3-.3 0-21.8c-19.6 1.6-19.7-14.6-31.6-23-18.7 20.6-31.6 40.8-58.9 51.1-12.7 4.8-19.6 10-25.9 21.8 34.9-16.4 91.2-13.5 98.8-10zM555.5 0l-.6 1.1-.3 .9 .6-.6 .3-1.4zM496.3 382.1c-33.9-56.9-75.3-118.4-150-115.5l-.3-6c-1.1-13.5 32.8 3.2 35.1-31l-14.4 7.2c-19.8-45.7-8.6-54.3-65.5-54.3-14.7 0-26.7 1.7-41.4 4.6 2.9 18.6 2.2 36.7-10.9 50.3l19.5 5.5c-1.7 3.2-2.9 6.3-2.9 9.8 0 21 42.8 2.9 42.8 33.6 0 18.4-36.8 60.1-54.9 60.1-8 0-53.7-50-53.4-60.1l.3-4.6 52.3-11.5c13-2.6 12.3-22.7-2.9-22.7-3.7 0-43.1 9.2-49.4 10.6-2-5.2-7.5-14.1-13.8-14.1-3.2 0-6.3 3.2-9.5 4-9.2 2.6-31 2.9-21.5 20.1L15.9 298.5c-5.5 1.1-8.9 6.3-8.9 11.8 0 6 5.5 10.9 11.5 10.9 8 0 131.3-28.4 147.4-32.2 2.6 3.2 4.6 6.3 7.8 8.6 20.1 14.4 59.8 85.9 76.4 85.9 24.1 0 58-22.4 71.3-41.9 3.2-4.3 6.9-7.5 12.4-6.9 .6 13.8-31.6 34.2-33 43.7-1.4 10.2-1 35.2-.3 41.1 26.7 8.1 52-3.6 77.9-2.9 4.3-21 10.6-41.9 9.8-63.5l-.3-9.5c-1.4-34.2-10.9-38.5-34.8-58.6-1.1-1.1-2.6-2.6-3.7-4 2.2-1.4 1.1-1 4.6-1.7 88.5 0 56.3 183.6 111.5 229.9 33.1-15 72.5-27.9 103.5-47.2-29-25.6-52.6-45.7-72.7-79.9zM300.1 428.2l0 27.2 11.8-3.4-2.9-23.8-8.9 0zM231.4 277.8l24.1 61.2 21-13.8-31.3-50.9-13.8 3.5zm84.4 154.9l2 12.4c9-1.5 58.4-6.6 58.4-14.1 0-1.4-.6-3.2-.9-4.6-26.8 0-36.9 3.8-59.5 6.3z"]
  };
  var faLetterboxd = {
    prefix: 'fab',
    iconName: 'letterboxd',
    icon: [640, 512, [], "e62d", "M521.3 128C586.9 128 640 181.1 640 246.6S586.9 365.2 521.3 365.2c-42.5 0-79.7-22.3-100.7-55.8 11.4-18.2 18-39.7 18-62.8s-6.6-44.6-18-62.8l.8-1.2c20.8-32.3 56.8-53.9 97.9-54.6l2 0zM320 128c42.5 0 79.7 22.3 100.7 55.8-11.4 18.2-18 39.7-18 62.8s6.6 44.6 18 62.8l-.8 1.2c-20.8 32.3-56.8 53.9-97.9 54.6l-2 0c-42.5 0-79.7-22.3-100.7-55.8 11.4-18.2 18-39.7 18-62.8s-6.6-44.6-18-62.8l.8-1.2c20.8-32.3 56.8-53.9 97.9-54.6l2 0zm-201.3 0c42.5 0 79.7 22.3 100.7 55.8-11.4 18.2-18 39.7-18 62.8s6.6 44.6 18 62.8l-.8 1.2c-20.8 32.3-56.8 53.9-97.9 54.6l-2 0C53.1 365.1 0 312.1 0 246.6S53.1 128 118.7 128z"]
  };
  var faOpera = {
    prefix: 'fab',
    iconName: 'opera',
    icon: [512, 512, [], "f26a", "M321.9 32.7c-170.2 0-252.6 223.8-147.5 355.1 36.5 45.4 88.6 75.6 147.5 75.6 36.3 0 70.3-11.1 99.4-30.4-43.8 39.2-101.9 63-165.3 63-3.9 0-8 0-11.9-.3-131.5-6.1-236.1-114.6-236.1-247.7 0-137 111-248 248-248l.8 0c63.1 .3 120.7 24.1 164.4 63.1-29-19.4-63.1-30.4-99.3-30.4zM423.7 430.4c-40.9 24.7-90.7 23.6-132-5.8 56.2-20.5 97.7-91.6 97.7-176.6 0-84.7-41.2-155.8-97.4-176.6 41.8-29.2 91.2-30.3 132.9-5 105.9 98.7 105.5 265.7-1.2 364z"]
  };
  var faWeibo = {
    prefix: 'fab',
    iconName: 'weibo',
    icon: [512, 512, [], "f18a", "M407 177.6c7.6-24-13.4-46.8-37.4-41.7-22 4.8-28.8-28.1-7.1-32.8 50.1-10.9 92.3 37.1 76.5 84.8-6.8 21.2-38.8 10.8-32-10.3zM214.8 446.7c-106.3 0-214.8-51.4-214.8-136.3 0-44.3 28-95.4 76.3-143.7 99.7-99.7 203.2-100.9 173.6-5.7-4 13.1 12.3 5.7 12.3 6 79.5-33.6 140.5-16.8 114 51.4-3.7 9.4 1.1 10.9 8.3 13.1 135.7 42.3 34.8 215.2-169.7 215.2zM358.5 300.4c-5.4-55.7-78.5-94-163.4-85.7-84.8 8.6-148.8 60.3-143.4 116s78.5 94 163.4 85.7c84.8-8.6 148.8-60.3 143.4-116zM347.9 35.1c-25.9 5.6-16.8 43.7 8.3 38.3 72.3-15.2 134.8 52.8 111.7 124-7.4 24.2 29.1 37 37.4 12 31.9-99.8-55.1-195.9-157.4-174.3zm-78.5 311c-17.1 38.8-66.8 60-109.1 46.3-40.8-13.1-58-53.4-40.3-89.7 17.7-35.4 63.1-55.4 103.4-45.1 42 10.8 63.1 50.2 46 88.5zm-86.3-30c-12.9-5.4-30 .3-38 12.9-8.3 12.9-4.3 28 8.6 34 13.1 6 30.8 .3 39.1-12.9 8-13.1 3.7-28.3-9.7-34zm32.6-13.4c-5.1-1.7-11.4 .6-14.3 5.4-2.9 5.1-1.4 10.6 3.7 12.9 5.1 2 11.7-.3 14.6-5.4 2.8-5.2 1.1-10.9-4-12.9z"]
  };
  var faReadme = {
    prefix: 'fab',
    iconName: 'readme',
    icon: [576, 512, [], "f4d5", "M528.3 46.5l-139.8 0c-48.1 0-89.9 33.3-100.4 80.3-10.6-47-52.3-80.3-100.4-80.3L48 46.5C21.5 46.5 0 68 0 94.5L0 340.3c0 26.5 21.5 48 48 48l89.7 0c102.2 0 132.7 24.4 147.3 75 .7 2.8 5.2 2.8 6 0 14.7-50.6 45.2-75 147.3-75l89.7 0c26.5 0 48-21.5 48-48l0-245.7c0-26.4-21.3-47.9-47.7-48.1zM242 311.9c0 1.9-1.5 3.5-3.5 3.5l-160.3 0c-1.9 0-3.5-1.5-3.5-3.5l0-22.9c0-1.9 1.5-3.5 3.5-3.5l160.4 0c1.9 0 3.5 1.5 3.5 3.5l0 22.9-.1 0zm0-60.9c0 1.9-1.5 3.5-3.5 3.5l-160.3 0c-1.9 0-3.5-1.5-3.5-3.5l0-22.9c0-1.9 1.5-3.5 3.5-3.5l160.4 0c1.9 0 3.5 1.5 3.5 3.5l0 22.9-.1 0zm0-60.9c0 1.9-1.5 3.5-3.5 3.5l-160.3 0c-1.9 0-3.5-1.5-3.5-3.5l0-22.9c0-1.9 1.5-3.5 3.5-3.5l160.4 0c1.9 0 3.5 1.5 3.5 3.5l0 22.9-.1 0zM501.3 311.8c0 1.9-1.5 3.5-3.5 3.5l-160.3 0c-1.9 0-3.5-1.5-3.5-3.5l0-22.9c0-1.9 1.5-3.5 3.5-3.5l160.4 0c1.9 0 3.5 1.5 3.5 3.5l0 22.9-.1 0zm0-60.9c0 1.9-1.5 3.5-3.5 3.5l-160.3 0c-1.9 0-3.5-1.5-3.5-3.5l0-22.9c0-1.9 1.5-3.5 3.5-3.5l160.4 0c1.9 0 3.5 1.5 3.5 3.5l0 22.9-.1 0zm0-60.9c0 1.9-1.5 3.5-3.5 3.5l-160.3 0c-1.9 0-3.5-1.5-3.5-3.5l0-22.8c0-1.9 1.5-3.5 3.5-3.5l160.4 0c1.9 0 3.5 1.5 3.5 3.5l0 22.8-.1 0z"]
  };
  var faGolang = {
    prefix: 'fab',
    iconName: 'golang',
    icon: [640, 512, [], "e40f", "M400.1 194.8c-10.9 2.8-19.9 4.3-29.1 7.6-7.3 1.9-14.7 3.9-23.2 6.1l-.6 .1c-4.2 1.2-4.6 1.3-8.5-3.2-4.7-5.3-8.1-8.7-14.6-11.9-19.7-9.6-38.7-6.8-56.4 4.7-21.2 13.7-32.1 34-31.8 59.2 .3 25 17.4 45.5 41.2 48.9 22 2.8 39.8-4.6 53.8-20.5 2.1-2.6 4-5.3 6.1-8.3 .8-1 1.5-2.1 2.3-3.3l-60.1 0c-6.5 0-8.1-4-5.9-9.3 4-9.7 11.5-25.9 15.9-34 .9-1.8 3.1-5.8 6.9-5.8l101.1 0c4.5-13.4 11.8-26.9 21.6-39.7 22.7-29.9 49.3-45.5 87.2-52 31.8-5.6 61.7-2.5 88.9 15.9 24.6 16.8 39.8 39.6 43.9 69.5 5.3 42.1-6.9 76.3-36.7 105.6-19.7 20.9-44.9 34-73.9 39.9-5.6 1-11.1 1.5-16.5 2-2.9 .2-5.7 .5-8.5 .8-28.3-.6-54.2-8.7-76-27.4-15.3-13.3-25.9-29.6-31.1-48.5-3.7 7.3-8 14.4-14 21.1-21.6 29.6-50.9 48-87.9 52.9-30.6 4.1-58.9-1.8-83.9-20.5-23-17.5-36.1-40.5-39.5-69.2-4.1-34 5.9-65.4 26.4-91.3 22.2-29 51.5-47.4 87.3-53.9 29.3-6.2 57.3-1.9 82.6 15.3 16.5 10.9 28.3 25.8 36.1 43.9 1.9 2.8 .6 4.4-3.1 5.3zM48.3 200.4c-1.3 0-1.6-.6-.9-1.6l6.6-8.4c.6-.9 2.2-1.5 3.4-1.5l111.3 0c1.2 0 1.5 .9 .9 1.8l-5.3 8.1c-.6 1-2.2 1.9-3.1 1.9l-112.8-.3zM1.2 229.1c-1.2 0-1.6-.7-.9-1.6l6.5-8.4c.6-.9 2.2-1.6 3.4-1.6l142.1 0c1.2 0 1.8 1 1.5 1.9l-2.5 7.5c-.3 1.2-1.5 1.9-2.8 1.9L1.2 229.1zm74.5 26.8c-.6 .9-.3 1.8 .9 1.8l68 .3c.9 0 2.2-.9 2.2-2.1l.6-7.5c0-1.3-.6-2.2-1.9-2.2l-62.3 0c-1.2 0-2.5 .9-3.1 1.9l-4.4 7.8zm501.5-18c-.2-2.6-.3-4.8-.7-7-5.6-30.8-34-48.3-63.6-41.4-29 6.5-47.7 24.9-54.5 54.2-5.6 24.3 6.2 48.9 28.6 58.9 17.2 7.5 34.3 6.6 50.8-1.9 24.6-13.6 38-32.7 39.6-59.5-.1-1.2-.1-2.3-.2-3.3z"]
  };
  var faStackExchange = {
    prefix: 'fab',
    iconName: 'stack-exchange',
    icon: [448, 512, [], "f18d", "M18.1 332.3l412.7 0 0 22c0 37.7-29.3 68-65.3 68l-19 0-86.8 89.7 0-89.7-176.3 0c-36 0-65.3-30.3-65.3-68l0-22zm0-23.6l412.7 0 0-85-412.7 0 0 85zm0-109.4l412.7 0 0-85-412.7 0 0 85zM365.4 0L83.4 0c-36 0-65.3 30.3-65.3 67.7l0 22.3 412.7 0 0-22.3C430.7 30.3 401.4 0 365.4 0z"]
  };
  var faGulp = {
    prefix: 'fab',
    iconName: 'gulp',
    icon: [256, 512, [], "f3ae", "M210 391.1l-14.1 24.6-4.6 80.2c0 8.9-28.3 16.1-63.1 16.1s-63.1-7.2-63.1-16.1l-5.8-79.4-14.9-25.4c41.2 17.3 126 16.7 165.6 0zM14 137.8L27.6 263.3c5.9-20 20.8-47 40-55.2 6.3-2.7 12.7-2.7 18.7 .9 5.2 3 9.6 9.3 10.1 11.8 1.2 6.5-2 9.1-4.5 9.1-3 0-5.3-4.6-6.8-7.3-4.1-7.3-10.3-7.6-16.9-2.8-6.9 5-12.9 13.4-17.1 20.7-5.1 8.8-9.4 18.5-12 28.2-1.5 5.6-2.9 14.6-.6 19.9 1 2.2 2.5 3.6 4.9 3.6 5 0 12.3-6.6 15.8-10.1 4.5-4.5 10.3-11.5 12.5-16l5.2-15.5c2.6-6.8 9.9-5.6 9.9 0 0 10.2-3.7 13.6-10 34.7-5.8 19.5-7.6 25.8-7.6 25.8-.7 2.8-3.4 7.5-6.3 7.5-1.2 0-2.1-.4-2.6-1.2-1-1.4-.9-5.3-.8-6.3 .2-3.2 6.3-22.2 7.3-25.2-2 2.2-4.1 4.4-6.4 6.6-5.4 5.1-14.1 11.8-21.5 11.8-3.4 0-5.6-.9-7.7-2.4l7.6 79.6c2 5 39.2 17.1 88.2 17.1 49.1 0 86.3-12.2 88.2-17.1l10.9-94.6c-5.7 5.2-12.3 11.6-19.6 14.8-5.4 2.3-17.4 3.8-17.4-5.7 0-5.2 9.1-14.8 14.4-21.5 1.4-1.7 4.7-5.9 4.7-8.1 0-2.9-6-2.2-11.7 2.5-3.2 2.7-6.2 6.3-8.7 9.7-4.3 6-6.6 11.2-8.5 15.5-6.2 14.2-4.1 8.6-9.1 22-5 13.3-4.2 11.8-5.2 14-.9 1.9-2.2 3.5-4 4.5-1.9 1-4.5 .9-6.1-.3-.9-.6-1.3-1.9-1.3-3.7 0-.9 .1-1.8 .3-2.7 1.5-6.1 7.8-18.1 15-34.3 1.6-3.7 1-2.6 .8-2.3-6.2 6-10.9 8.9-14.4 10.5-5.8 2.6-13 2.6-14.5-4.1-.1-.4-.1-.8-.2-1.2-11.8 9.2-24.3 11.7-20-8.1-4.6 8.2-12.6 14.9-22.4 14.9-4.1 0-7.1-1.4-8.6-5.1-2.3-5.5 1.3-14.9 4.6-23.8 1.7-4.5 4-9.9 7.1-16.2 1.6-3.4 4.2-5.4 7.6-4.5 .6 .2 1.1 .4 1.6 .7 2.6 1.8 1.6 4.5 .3 7.2-3.8 7.5-7.1 13-9.3 20.8-.9 3.3-2 9 1.5 9 2.4 0 4.7-.8 6.9-2.4 4.6-3.4 8.3-8.5 11.1-13.5 2-3.6 4.4-8.3 5.6-12.3 .5-1.7 1.1-3.3 1.8-4.8 1.1-2.5 2.6-5.1 5.2-5.1 1.3 0 2.4 .5 3.2 1.5 1.7 2.2 1.3 4.5 .4 6.9-2 5.6-4.7 10.6-6.9 16.7-1.3 3.5-2.7 8-2.7 11.7 0 3.4 3.7 2.6 6.8 1.2 2.4-1.1 4.8-2.8 6.8-4.5 1.2-4.9 .9-3.8 26.4-68.2 1.3-3.3 3.7-4.7 6.1-4.7 1.2 0 2.2 .4 3.2 1.1 1.7 1.3 1.7 4.1 1 6.2-.7 1.9-.6 1.3-4.5 10.5-5.2 12.1-8.6 20.8-13.2 31.9-1.9 4.6-7.7 18.9-8.7 22.3-.6 2.2-1.3 5.8 1 5.8 5.4 0 19.3-13.1 23.1-17 .2-.3 .5-.4 .9-.6 .6-1.9 1.2-3.7 1.7-5.5 1.4-3.8 2.7-8.2 5.3-11.3 .8-1 1.7-1.6 2.7-1.6 2.8 0 4.2 1.2 4.2 4 0 1.1-.7 5.1-1.1 6.2 1.4-1.5 2.9-3 4.5-4.5 15-13.9 25.7-6.8 25.7 .2 0 7.4-8.9 17.7-13.8 23.4-1.6 1.9-4.9 5.4-5 6.4 0 1.3 .9 1.8 2.2 1.8 2 0 6.4-3.5 8-4.7 5-3.9 11.8-9.9 16.6-14.1l14.8-136.8c-30.5 17.1-197.6 17.2-228.3 .2zm229.7-8.5c0 21-231.2 21-231.2 0 0-8.8 51.8-15.9 115.6-15.9 9 0 17.8 .1 26.3 .4L167 65.1 228.3 .6c1.4-1.4 5.8-.2 9.9 3.5s6.6 7.9 5.3 9.3l-.1 .1-57.3 60.5-10 40.7c39.9 2.6 67.6 8.1 67.6 14.6zm-69.4 4.6c0-.8-.9-1.5-2.5-2.1l-.2 .8c0 1.3-5 2.4-11.1 2.4s-11.1-1.1-11.1-2.4c0-.1 0-.2 .1-.3l.2-.7c-1.8 .6-3 1.4-3 2.3 0 2.1 6.2 3.7 13.7 3.7 7.7 .1 13.9-1.6 13.9-3.7z"]
  };
  var faYelp = {
    prefix: 'fab',
    iconName: 'yelp',
    icon: [384, 512, [], "f1e9", "M42.9 240.3l99.6 48.6c19.2 9.4 16.2 37.5-4.5 42.7L30.5 358.5c-3.2 .8-6.4 .9-9.6 .3s-6.2-1.8-8.9-3.7-4.9-4.3-6.6-7.1-2.7-5.9-3.1-9.2c-3.3-28.8-.2-57.9 9-85.3 1-3.1 2.7-5.9 4.9-8.3s4.9-4.2 7.9-5.5 6.2-1.8 9.5-1.8 6.4 .9 9.3 2.3zm44 239.3c23.8 16.3 50.9 27.3 79.4 32.1 3.2 .6 6.5 .4 9.6-.4s6.1-2.3 8.6-4.4 4.6-4.6 6-7.5 2.3-6.1 2.4-9.4l3.9-110.8c.7-21.3-25.5-31.9-39.8-16.1L82.8 445.5c-2.2 2.4-3.8 5.3-4.8 8.4s-1.3 6.4-.9 9.6 1.5 6.3 3.1 9.1 3.9 5.2 6.6 7l0 0zM232.2 369.7l58.8 94c1.7 2.8 4 5.1 6.8 6.9s5.8 3 9 3.5 6.5 .3 9.7-.5 6.1-2.4 8.6-4.4c22.3-18.4 40.3-41.5 52.7-67.6 1.4-2.9 2.1-6.1 2.2-9.4s-.6-6.5-1.9-9.4-3.2-5.7-5.6-7.8-5.2-3.9-8.3-4.9L258.7 335.7c-20.3-6.5-37.8 15.8-26.5 33.9zM380.6 237.4c-11.5-26.5-28.7-50.2-50.4-69.3-2.4-2.1-5.3-3.7-8.4-4.7s-6.4-1.2-9.6-.8-6.3 1.5-9.1 3.2-5.1 4-6.9 6.7l-62 91.9c-11.9 17.7 4.7 40.6 25.2 34.7L366 268.6c3.1-.9 6-2.5 8.5-4.6s4.5-4.7 5.8-7.7 2.1-6.2 2.2-9.4-.6-6.5-1.9-9.5l0 0zM62.1 30.2c-2.8 1.4-5.4 3.3-7.4 5.7s-3.6 5.2-4.5 8.2-1.2 6.2-.9 9.3 1.3 6.1 2.9 8.9L156.3 242.6c11.7 20.2 42.6 11.9 42.6-11.4l0-208.3c0-3.1-.6-6.3-1.8-9.2s-3.1-5.5-5.4-7.6-5-3.8-8-4.8-6.1-1.4-9.3-1.2c-39 3.1-77 13.3-112.3 30.1z"]
  };
  var faGofore = {
    prefix: 'fab',
    iconName: 'gofore',
    icon: [448, 512, [], "f3a7", "M348 319.8l-13.2 0 0 34.7c-24.5 23.1-56.3 35.8-89.9 35.8-73.2 0-132.4-60.2-132.4-134.4 0-74.1 59.2-134.4 132.4-134.4 35.3 0 68.6 14 93.6 39.4l62.3-63.3c-41.8-42.3-97.1-65.6-156.1-65.6-122.7 0-220.7 100.6-220.7 224 0 122.5 97 224 220.7 224 63.2 0 124.5-26.2 171-82.5-2-27.6-13.4-77.7-67.7-77.7zM335.9 207.3l-106.3 0 0 89 118.4 0c33.5 0 60.5 15.1 76 41.8l0-30.6c0-65.2-40.4-100.2-88.1-100.2z"]
  };
  var faAviato = {
    prefix: 'fab',
    iconName: 'aviato',
    icon: [640, 512, [], "f421", "M107.2 283.5l-19-41.8-52.1 0-19 41.8-17.1 0 62.2-131.4 62.2 131.4-17.2 0zm-45-98.1l-19.6 42.5 39.2 0-19.6-42.5zM174.9 287.8l-62.2-131.4 17.1 0 45.1 96 45.1-96 17 0-62.1 131.4zm80.6-4.3l0-127.1 15.5 0 0 127.1-15.5 0zM464.6 167.9l0 115.6-17.3 0 0-115.6-41.2 0 0-11.5 99.6 0 0 11.5-41.1 0zM640 218.8c0 9.2-1.7 17.8-5.1 25.8s-8.2 15.1-14.2 21.1-13.1 10.8-21.1 14.2-16.6 5.1-25.8 5.1-17.8-1.7-25.8-5.1-15.1-8.2-21.1-14.2-10.8-13-14.2-21.1c-3.4-8-5.1-16.6-5.1-25.8s1.7-17.8 5.1-25.8 8.2-15.1 14.2-21.1 13-8.4 21.1-11.9c8-3.4 16.6-5.1 25.8-5.1s17.8 1.7 25.8 5.1 15.1 5.8 21.1 11.9c6 6 10.7 13.1 14.2 21.1 3.4 8 5.1 16.6 5.1 25.8zm-15.5 0c0-7.3-1.3-14-3.9-20.3s-6.2-11.7-10.8-16.3-10-8.2-16.2-10.9-12.8-4-19.8-4-13.6 1.3-19.8 4-11.6 6.3-16.2 10.9-8.2 10-10.8 16.3-3.9 13.1-3.9 20.3c0 7.3 1.3 14 3.9 20.3s6.2 11.7 10.8 16.3 10 8.2 16.2 10.9 12.8 4 19.8 4 13.6-1.3 19.8-4 11.6-6.3 16.2-10.9 8.2-10 10.8-16.3 3.9-13.1 3.9-20.3zm-94.8 96.7l0-6.3 88.9-10-242.9 13.4c.6-2.2 1.1-4.6 1.4-7.2 .3-2 .5-4.2 .6-6.5l64.8-8.1-64.9 1.9c0-.4-.1-.7-.1-1.1-2.8-17.2-25.5-23.7-25.5-23.7l-1.1-26.3 23.8 0 19 41.8 17.1 0-62.2-131.4-62.2 131.4 17.1 0 19-41.8 23.6 0-1.1 26.4s-22.7 6.5-25.5 23.7c-.1 .3-.1 .7-.1 1.1l-64.9-1.9 64.8 8.1c.1 2.3 .3 4.4 .6 6.5 .3 2.6 .8 5 1.4 7.2l-242.9-13.5 88.9 10 0 6.3c-5.9 .9-10.5 6-10.5 12.2 0 6.8 5.6 12.4 12.4 12.4s12.4-5.6 12.4-12.4c0-6.2-4.6-11.3-10.5-12.2l0-5.8 80.3 9 0 5.4c-5.7 1.1-9.9 6.2-9.9 12.1 0 6.8 5.6 10.2 12.4 10.2s12.4-3.4 12.4-10.2c0-6-4.3-11-9.9-12.1l0-4.9 28.4 3.2 0 23.7-5.9 0 0 13.9 5.9 0 0-6.6 5 0 0 6.6 5.9 0 0-13.8-5.9 0 0-23.2 38.3 4.3c8.1 11.4 19 13.6 19 13.6l-.1 6.7-5.1 .2-.1 12.1 4.1 0 .1-5 5.2 0 .1 5 4.1 0-.1-12.1-5.1-.2-.1-6.7s10.9-2.1 19-13.6l38.3-4.3 0 23.2-5.9 0 0 13.8 5.9 0 0-6.6 5 0 0 6.6 5.9 0 0-13.8-5.9 0 0-23.7 28.4-3.2 0 4.9c-5.7 1.1-9.9 6.2-9.9 12.1 0 6.8 5.6 10.2 12.4 10.2s12.4-3.4 12.4-10.2c0-6-4.3-11-9.9-12.1l0-5.4 80.3-9 0 5.8c-5.9 .9-10.5 6-10.5 12.2 0 6.8 5.6 12.4 12.4 12.4s12.4-5.6 12.4-12.4c-.2-6.3-4.7-11.4-10.7-12.3zM328.9 227.9l19.6-42.5 19.6 42.5-17.9 0-1.7-40.3-1.7 40.3-17.9 0z"]
  };
  var faPadlet = {
    prefix: 'fab',
    iconName: 'padlet',
    icon: [640, 512, [], "e4a0", "M297.9 0l.1 0c7.6 .1 14.4 4.7 17.5 11.8l132 308.5 .3-.1 .2 .4-2.8 10-42.9 158c-3.7 16.2-19.7 26.3-35.8 22.6l-68.4-15.6-68.5 15.6c-16.1 3.7-32.1-6.4-35.8-22.6l-42.9-158-2.7-10 .1-.4 132.1-308.4c3-7 9.9-11.6 17.5-11.8zM160.1 322.1l131 39.1 6.9 122.5 7.9-121.5 130.6-39.3 .2-.1-131 25.1-8.6-320.2-5.2 320.2-131.8-25.8zM426 222.6l94.4-41 73.8 0-157 247.6 31.6-109-42.8-97.6zm171.5-41.2l41.4 76.2c4 7.5-3.9 15.9-11.6 12.2l-47.6-22.7 17.8-65.7zM127.3 318.5L158.7 430 1.6 154.5c-5.9-10.4 5.5-22 15.9-16.2l151.8 84.2-42.1 96z"]
  };
  var faEdgeLegacy = {
    prefix: 'fab',
    iconName: 'edge-legacy',
    icon: [448, 512, [], "e078", "M-6 228.2l.4-.5c0 .2 0 .3-.1 .5l-.3 0zm460.6 15.5c0-44-7.8-84.5-28.8-122.4-41-73.4-113.6-113.3-198.6-113.3-139.9-.3-218.3 105.2-232.8 219.7 42.4-61.3 117.1-121.4 220.4-125 0 0 109.7 0 99.4 105l-175.8 0c6.4-37.4 18.5-59 34.3-78.9-75 34.9-121.8 96.1-120.8 188.3 .8 71.5 50.1 144.8 120.8 172 83.4 31.8 192.8 7.2 240.1-21.3l0-104.4c-80.9 56.5-270.9 60.9-272.3-67.6l314.1 0 0-52.1z"]
  };
  var faSquareLastfm = {
    prefix: 'fab',
    iconName: 'square-lastfm',
    icon: [448, 512, ["lastfm-square"], "f203", "M448 96c0-35.3-28.7-64-64-64L64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320zM210.7 280.8c-1.8-5.5-3.4-10.8-5-15.9-12.9-41.9-21-68.4-58-68.4-22.4 0-45.1 16.1-45.1 61.2 0 35.2 18 57.2 43.3 57.2 28.6 0 47.6-21.3 47.6-21.3l11.7 31.9s-19.8 19.4-61.2 19.4c-51.3 0-79.9-30.1-79.9-85.8 0-57.9 28.6-92 82.5-92 67.9 0 79.3 35.3 96.4 88.4 1.4 4.4 2.9 8.9 4.4 13.5 8.8 26.8 24.2 46.2 61.2 46.2 24.9 0 38.1-5.5 38.1-19.1 0-17.5-16.9-21.2-40-26.4-3.2-.7-6.5-1.4-9.9-2.2-30.4-7.3-42.5-23.1-42.5-48 0-40 32.3-52.4 65.2-52.4 37.4 0 60.1 13.6 63 46.6l-36.7 4.4c-1.5-15.8-11-22.4-28.6-22.4-16.1 0-26 7.3-26 19.8 0 11 4.8 17.6 20.9 21.3 2.2 .5 4.5 1 6.7 1.4 31.1 6.5 65.1 13.7 65.1 56.1 .1 36.7-30.7 50.6-76.1 50.6-63.4 0-85.4-28.6-97.1-64.1z"]
  };
  var faLastfmSquare = faSquareLastfm;
  var faGoodreadsG = {
    prefix: 'fab',
    iconName: 'goodreads-g',
    icon: [320, 512, [], "f3a9", "M10.8 403.3l2.8 0c12.7 0 25.5 0 38.2 .1 1.6 0 3.1-.4 3.6 2.1 7.1 34.9 30 54.6 62.9 63.9 26.9 7.6 54.1 7.8 81.3 1.8 33.8-7.4 56-28.3 68-60.4 8-21.5 10.7-43.8 11-66.5 .1-5.8 .3-47-.2-52.8l-.9-.3c-.8 1.5-1.7 2.9-2.5 4.4-22.1 43.1-61.3 67.4-105.4 69.1-103 4-169.4-57-172-176.2-.5-23.7 1.8-46.9 8.3-69.7 20.6-71.1 74.6-118.2 153.9-118.8 61.3-.4 101.5 38.7 116.2 70.3 .5 1.1 1.3 2.3 2.4 1.9l0-61.6 44.3 0c0 280.3 .1 332.2 .1 332.2-.1 78.5-26.7 143.7-103 162.2-69.5 16.9-159 4.8-196-57.2-8-13.5-11.8-28.3-13-44.5zM157.1 36.5c-52.5-.5-108.5 40.7-115 133.8-4.1 59 14.8 122.2 71.5 148.6 27.6 12.9 74.3 15 108.3-8.7 47.6-33.2 62.7-97 54.8-154-9.7-71.1-47.8-120-119.6-119.7z"]
  };
  var faCcMastercard = {
    prefix: 'fab',
    iconName: 'cc-mastercard',
    icon: [576, 512, [], "f1f1", "M482.9 410.3c0 6.8-4.6 11.7-11.2 11.7-6.8 0-11.2-5.2-11.2-11.7s4.4-11.7 11.2-11.7c6.6 0 11.2 5.2 11.2 11.7zM172.1 398.6c-7.1 0-11.2 5.2-11.2 11.7S165 422 172.1 422c6.5 0 10.9-4.9 10.9-11.7-.1-6.5-4.4-11.7-10.9-11.7zm117.5-.3c-5.4 0-8.7 3.5-9.5 8.7l19.1 0c-.9-5.7-4.4-8.7-9.6-8.7zm107.8 .3c-6.8 0-10.9 5.2-10.9 11.7s4.1 11.7 10.9 11.7 11.2-4.9 11.2-11.7c0-6.5-4.4-11.7-11.2-11.7zm105.9 26.1c0 .3 .3 .5 .3 1.1 0 .3-.3 .5-.3 1.1-.3 .3-.3 .5-.5 .8-.3 .3-.5 .5-1.1 .5-.3 .3-.5 .3-1.1 .3-.3 0-.5 0-1.1-.3-.3 0-.5-.3-.8-.5-.3-.3-.5-.5-.5-.8-.3-.5-.3-.8-.3-1.1 0-.5 0-.8 .3-1.1 0-.5 .3-.8 .5-1.1 .3-.3 .5-.3 .8-.5 .5-.3 .8-.3 1.1-.3 .5 0 .8 0 1.1 .3 .5 .3 .8 .3 1.1 .5s.2 .6 .5 1.1zm-2.2 1.4c.5 0 .5-.3 .8-.3 .3-.3 .3-.5 .3-.8s0-.5-.3-.8c-.3 0-.5-.3-1.1-.3l-1.6 0 0 3.5 .8 0 0-1.4 .3 0 1.1 1.4 .8 0-1.1-1.3zM576 81l0 352c0 26.5-21.5 48-48 48L48 481c-26.5 0-48-21.5-48-48L0 81C0 54.5 21.5 33 48 33l480 0c26.5 0 48 21.5 48 48zM64 220.6c0 76.5 62.1 138.5 138.5 138.5 27.2 0 53.9-8.2 76.5-23.1-72.9-59.3-72.4-171.2 0-230.5-22.6-15-49.3-23.1-76.5-23.1-76.4-.1-138.5 62-138.5 138.2zM288 329.4c70.5-55 70.2-162.2 0-217.5-70.2 55.3-70.5 162.6 0 217.5zM145.7 405.7c0-8.7-5.7-14.4-14.7-14.7-4.6 0-9.5 1.4-12.8 6.5-2.4-4.1-6.5-6.5-12.2-6.5-3.8 0-7.6 1.4-10.6 5.4l0-4.4-8.2 0 0 36.7 8.2 0c0-18.9-2.5-30.2 9-30.2 10.2 0 8.2 10.2 8.2 30.2l7.9 0c0-18.3-2.5-30.2 9-30.2 10.2 0 8.2 10 8.2 30.2l8.2 0 0-23-.2 0zM190.6 392l-7.9 0 0 4.4c-2.7-3.3-6.5-5.4-11.7-5.4-10.3 0-18.2 8.2-18.2 19.3 0 11.2 7.9 19.3 18.2 19.3 5.2 0 9-1.9 11.7-5.4l0 4.6 7.9 0 0-36.8zm40.5 25.6c0-15-22.9-8.2-22.9-15.2 0-5.7 11.9-4.8 18.5-1.1l3.3-6.5c-9.4-6.1-30.2-6-30.2 8.2 0 14.3 22.9 8.3 22.9 15 0 6.3-13.5 5.8-20.7 .8l-3.5 6.3c11.2 7.6 32.6 6 32.6-7.5zm35.4 9.3l-2.2-6.8c-3.8 2.1-12.2 4.4-12.2-4.1l0-16.6 13.1 0 0-7.4-13.1 0 0-11.2-8.2 0 0 11.2-7.6 0 0 7.3 7.6 0 0 16.7c0 17.6 17.3 14.4 22.6 10.9zm13.3-13.4l27.5 0c0-16.2-7.4-22.6-17.4-22.6-10.6 0-18.2 7.9-18.2 19.3 0 20.5 22.6 23.9 33.8 14.2l-3.8-6c-7.8 6.4-19.6 5.8-21.9-4.9zM338.9 392c-4.6-2-11.6-1.8-15.2 4.4l0-4.4-8.2 0 0 36.7 8.2 0 0-20.7c0-11.6 9.5-10.1 12.8-8.4l2.4-7.6zm10.6 18.3c0-11.4 11.6-15.1 20.7-8.4l3.8-6.5c-11.6-9.1-32.7-4.1-32.7 15 0 19.8 22.4 23.8 32.7 15l-3.8-6.5c-9.2 6.5-20.7 2.6-20.7-8.6zM416.2 392l-8.2 0 0 4.4c-8.3-11-29.9-4.8-29.9 13.9 0 19.2 22.4 24.7 29.9 13.9l0 4.6 8.2 0 0-36.8zm33.7 0c-2.4-1.2-11-2.9-15.2 4.4l0-4.4-7.9 0 0 36.7 7.9 0 0-20.7c0-11 9-10.3 12.8-8.4l2.4-7.6zm40.3-14.9l-7.9 0 0 19.3c-8.2-10.9-29.9-5.1-29.9 13.9 0 19.4 22.5 24.6 29.9 13.9l0 4.6 7.9 0 0-51.7zm7.6-75.1l0 4.6 .8 0 0-4.6 1.9 0 0-.8-4.6 0 0 .8 1.9 0zm6.6 123.8c0-.5 0-1.1-.3-1.6-.3-.3-.5-.8-.8-1.1s-.8-.5-1.1-.8c-.5 0-1.1-.3-1.6-.3-.3 0-.8 .3-1.4 .3-.5 .3-.8 .5-1.1 .8-.5 .3-.8 .8-.8 1.1-.3 .5-.3 1.1-.3 1.6 0 .3 0 .8 .3 1.4 0 .3 .3 .8 .8 1.1 .3 .3 .5 .5 1.1 .8 .5 .3 1.1 .3 1.4 .3 .5 0 1.1 0 1.6-.3 .3-.3 .8-.5 1.1-.8s.5-.8 .8-1.1c.3-.6 .3-1.1 .3-1.4zm3.2-124.7l-1.4 0-1.6 3.5-1.6-3.5-1.4 0 0 5.4 .8 0 0-4.1 1.6 3.5 1.1 0 1.4-3.5 0 4.1 1.1 0 0-5.4zm4.4-80.5c0-76.2-62.1-138.3-138.5-138.3-27.2 0-53.9 8.2-76.5 23.1 72.1 59.3 73.2 171.5 0 230.5 22.6 15 49.5 23.1 76.5 23.1 76.4 .1 138.5-61.9 138.5-138.4z"]
  };
  var faDiscourse = {
    prefix: 'fab',
    iconName: 'discourse',
    icon: [448, 512, [], "f393", "M225.9 32C103.3 32 0 130.5 0 252.1 0 256 .1 480 .1 480l225.8-.2C348.6 479.8 448 377.5 448 255.9S348.6 32 225.9 32zM224 384c-19.4 0-37.9-4.3-54.4-12.1L88.5 392 111.4 317c-9.8-18.1-15.4-38.9-15.4-61 0-70.7 57.3-128 128-128s128 57.3 128 128-57.3 128-128 128z"]
  };
  var faBlackTie = {
    prefix: 'fab',
    iconName: 'black-tie',
    icon: [448, 512, [], "f27e", "M0 32l0 448 448 0 0-448-448 0zM316.5 357.2l-92.5 88.7-92.5-88.7 64.5-184-64.5-86.6 184.9 0-64.4 86.6 64.5 184z"]
  };
  var faSquareFacebook = {
    prefix: 'fab',
    iconName: 'square-facebook',
    icon: [448, 512, ["facebook-square"], "f082", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l98.2 0 0-145.8-52.8 0 0-78.2 52.8 0 0-33.7c0-87.1 39.4-127.5 125-127.5 16.2 0 44.2 3.2 55.7 6.4l0 70.8c-6-.6-16.5-1-29.6-1-42 0-58.2 15.9-58.2 57.2l0 27.8 83.6 0-14.4 78.2-69.3 0 0 145.8 129 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32z"]
  };
  var faFacebookSquare = faSquareFacebook;
  var faBattleNet = {
    prefix: 'fab',
    iconName: 'battle-net',
    icon: [512, 512, [], "f835", "M448.8 225.6c26.9 .2 35.6-7.4 38.9-12.4 12.5-16.3-7.1-47.6-52.8-71.3 17.8-33.6 30.1-63.7 36.3-85.3 3.4-11.8 1.1-19 .5-20.3-1.7 10.5-15.8 48.5-48.2 100-25-11.2-56.5-20.1-93.8-23.8-8.9-16.9-34.9-63.9-60.5-88.9-16.8-16.5-30.3-22.6-40.8-23.5l0 0c-13.8-1.6-22.7 5.8-27.4 11-17.2 18.5-24.3 48.9-25 84.1-7.2-12.3-17.2-24.6-28.5-25.9l-.2 0c-20.7-3.5-38.4 29.2-36 81.3-38.4 1.4-71 5.8-93 11.2-9.9 2.4-16.2 7.3-17.8 9.7 1-.4 22.4-9.2 111.6-9.2 5.2 53 29.8 101.8 26 93.2-9.7 15.4-38.2 62.4-47.3 97.7-5.9 22.9-4.4 37.6 .2 47.1 5.6 12.8 16.4 16.7 23.2 18.3 25 5.7 55.4-3.6 86.7-21.1-7.5 12.8-13.9 28.5-9.1 39.3 7.3 19.6 44.5 18.7 88.4-9.4 20.2 32.2 40.1 57.9 55.7 74.1 2.6 2.8 5.5 5.2 8.8 7.1 5.1 3.2 8.6 3.4 8.6 3.4-8.2-6.7-34-38-62.5-91.8 22.2-16 45.7-38.9 67.5-69.3 122.8 4.6 143.3-24.8 148-31.6 14.7-19.9 3.4-57.4-57.3-93.7zM371 331.8c23.8-37.7 30.3-67.8 29.4-92.3 27.9 17.6 47.2 37.6 49.1 58.8 1.1 12.9-8.1 29.1-78.5 33.5zM217.1 387.7c9.8-6.2 19.5-13.1 29.2-20.5 6.7 13.3 13.6 26.1 20.6 38.2-40.6 21.9-68.8 12.8-49.8-17.7zm215-171.3c-10.3-5.3-21.2-10.3-32.4-15 7.9-12.1 15.5-24.4 22.7-36.9 39.1 24.1 45.9 53.2 9.6 51.9zM279.4 398c-5.5-11.4-11-23.5-16.5-36.4 43.2 1.3 62.4-18.7 63.3-20.4 0 .1-25 15.6-62.5 12.2 30.6-25.6 59.1-53.7 85.1-84 8.7-10.2 17-20.6 24.9-31.1-.4-.3-1.5-3-16.5-12-51.7 60.3-102.3 98-132.8 115.9-20.6-11.2-40.8-31.8-55.7-61.5-20-39.9-30-82.4-31.6-116.1 12.3 .9 25.3 2.2 38.8 3.9-22.3 36.8-14.4 63-13.5 64.2 0-.1-1-29.2 20.1-59.6 9 52.5 24 103.8 44.7 152.8 .9-.4 1.8 .9 18.7-8.2-26.3-74.5-33.8-138.2-34-173.4 20-12.4 48.2-19.8 81.6-17.8 44.6 2.7 86.4 15.2 116.3 30.7-7.1 10.4-14.9 21.3-23.3 32.5-20.7-37.7-47.3-43.9-48.9-43.7 .1 0 25.9 14.1 41.5 47.2-37.5-13.8-76.1-24.4-115.3-31.7-13.1-2.4-26.2-4.4-39.4-6-.1 .4-1.8 1.8-2.2 20.3 77.9 14.5 136.6 39.9 167.2 57.2 .7 23.6-7 51.6-25.4 79.6-24.6 37.3-56.4 67.2-84.8 85.4zm27.4-287c-44.6-1.7-73.6 7.4-94.7 20.7 2-52.3 21.3-76.4 38.2-75.3 16.9-4.2 54.9 52.2 56.5 54.6zm-130.7 3.1c.5 12.1 1.6 24.6 3.2 37.3-14.6-.9-28.7-1.3-42.4-1.3-.1 3.2-.1-51 24.7-49.6l.1 0c5.8 1.1 10.6 6.9 14.4 13.6zm-28.1 162c20.8 39.7 43.3 60.6 65.3 72.3-46.8 24.8-77.5 20-84.9 4.5-.2-.2-11.1-15.3 19.7-76.8l0 0z"]
  };
  var faBimobject = {
    prefix: 'fab',
    iconName: 'bimobject',
    icon: [448, 512, [], "f378", "M416 32L32 32C14.4 32 0 46.4 0 64L0 448c0 17.6 14.4 32 32 32l384 0c17.6 0 32-14.4 32-32l0-384c0-17.6-14.4-32-32-32zM352 289.4c0 49.4-11.4 82.6-103.8 82.6l-16.9 0c-44.1 0-62.4-14.9-70.4-38.8l-.9 0 0 34.8-64 0 0-232 64 0 0 74.7 1.1 0c4.6-30.5 39.7-38.8 69.7-38.8l17.3 0c92.4 0 103.8 33.1 103.8 82.5l0 35 .1 0zm-64-28.9l0 22.9c0 21.7-3.4 33.8-38.4 33.8l-45.3 0c-28.9 0-44.1-6.5-44.1-35.7l0-19c0-29.3 15.2-35.7 44.1-35.7l45.3 0c35-.2 38.4 12 38.4 33.7z"]
  };
  var icons = {
    faSquareGithub: faSquareGithub,
    faGithubSquare: faGithubSquare,
    faThinkPeaks: faThinkPeaks,
    faGoogleDrive: faGoogleDrive,
    faAutoprefixer: faAutoprefixer,
    faSquareViadeo: faSquareViadeo,
    faViadeoSquare: faViadeoSquare,
    faCpanel: faCpanel,
    faMendeley: faMendeley,
    faDraft2digital: faDraft2digital,
    faReplyd: faReplyd,
    faEmpire: faEmpire,
    faAccessibleIcon: faAccessibleIcon,
    faQuora: faQuora,
    faCcJcb: faCcJcb,
    faFedora: faFedora,
    faDuolingo: faDuolingo,
    faFirstdraft: faFirstdraft,
    faFreebsd: faFreebsd,
    faOdysee: faOdysee,
    faGgCircle: faGgCircle,
    faCloudflare: faCloudflare,
    faHackerrank: faHackerrank,
    faSkyatlas: faSkyatlas,
    faDeskpro: faDeskpro,
    faResolving: faResolving,
    faBlackberry: faBlackberry,
    faStripeS: faStripeS,
    faSquareBehance: faSquareBehance,
    faBehanceSquare: faBehanceSquare,
    faServicestack: faServicestack,
    faRocketchat: faRocketchat,
    faRebel: faRebel,
    faSquareWebAwesome: faSquareWebAwesome,
    faLinktree: faLinktree,
    faSimplybuilt: faSimplybuilt,
    faStubber: faStubber,
    faApper: faApper,
    faGoogleScholar: faGoogleScholar,
    faYarn: faYarn,
    faStackOverflow: faStackOverflow,
    faBluetooth: faBluetooth,
    faCreativeCommonsNcJp: faCreativeCommonsNcJp,
    faReddit: faReddit,
    faConnectdevelop: faConnectdevelop,
    faResearchgate: faResearchgate,
    faSignalMessenger: faSignalMessenger,
    faXing: faXing,
    faSquareJs: faSquareJs,
    faJsSquare: faJsSquare,
    faFonticons: faFonticons,
    faUps: faUps,
    faAmazonPay: faAmazonPay,
    faPandora: faPandora,
    faOpenid: faOpenid,
    faVsco: faVsco,
    faUbuntu: faUbuntu,
    faViacoin: faViacoin,
    faZhihu: faZhihu,
    faYandex: faYandex,
    faPixiv: faPixiv,
    faOpenai: faOpenai,
    faSith: faSith,
    faNfcDirectional: faNfcDirectional,
    faCreativeCommonsBy: faCreativeCommonsBy,
    faUmbraco: faUmbraco,
    faHooli: faHooli,
    faSquareGit: faSquareGit,
    faGitSquare: faGitSquare,
    faOdnoklassniki: faOdnoklassniki,
    faDrupal: faDrupal,
    faBloggerB: faBloggerB,
    faInvision: faInvision,
    faFacebookF: faFacebookF,
    faCentos: faCentos,
    faCcAmazonPay: faCcAmazonPay,
    faEbay: faEbay,
    faContao: faContao,
    faEllo: faEllo,
    faSistrix: faSistrix,
    faPeriscope: faPeriscope,
    faExpeditedssl: faExpeditedssl,
    faNapster: faNapster,
    faDelicious: faDelicious,
    faGuilded: faGuilded,
    faXbox: faXbox,
    faUntappd: faUntappd,
    faGooglePlusG: faGooglePlusG,
    faGithubAlt: faGithubAlt,
    faGetPocket: faGetPocket,
    faGlide: faGlide,
    faBity: faBity,
    faWpexplorer: faWpexplorer,
    faMegaport: faMegaport,
    faMdb: faMdb,
    faPage4: faPage4,
    faTheRedYeti: faTheRedYeti,
    faJira: faJira,
    faFedex: faFedex,
    faEvernote: faEvernote,
    faUsb: faUsb,
    faAngrycreative: faAngrycreative,
    faMizuni: faMizuni,
    faItchIo: faItchIo,
    faWindows: faWindows,
    faStumbleupon: faStumbleupon,
    faGoogle: faGoogle,
    faDiscord: faDiscord,
    faHackerNews: faHackerNews,
    faEleventy: faEleventy,
    fa11ty: fa11ty,
    faTeamspeak: faTeamspeak,
    faSupple: faSupple,
    faSquareTwitter: faSquareTwitter,
    faTwitterSquare: faTwitterSquare,
    faFontAwesome: faFontAwesome,
    faFontAwesomeFlag: faFontAwesomeFlag,
    faFontAwesomeLogoFull: faFontAwesomeLogoFull,
    faWirsindhandwerk: faWirsindhandwerk,
    faWsh: faWsh,
    faConfluence: faConfluence,
    faDigg: faDigg,
    faThreads: faThreads,
    faWpressr: faWpressr,
    faRendact: faRendact,
    faYoast: faYoast,
    faNimblr: faNimblr,
    faPixelfed: faPixelfed,
    faYahoo: faYahoo,
    faBluesky: faBluesky,
    faScribd: faScribd,
    faCreativeCommonsPd: faCreativeCommonsPd,
    faEarlybirds: faEarlybirds,
    faSquareOdnoklassniki: faSquareOdnoklassniki,
    faOdnoklassnikiSquare: faOdnoklassnikiSquare,
    faMarkdown: faMarkdown,
    faTypo3: faTypo3,
    faJoomla: faJoomla,
    faWeixin: faWeixin,
    faGrunt: faGrunt,
    faRockrms: faRockrms,
    faUnsplash: faUnsplash,
    faSquareInstagram: faSquareInstagram,
    faInstagramSquare: faInstagramSquare,
    faFirstOrderAlt: faFirstOrderAlt,
    faFulcrum: faFulcrum,
    faBraveReverse: faBraveReverse,
    faAvianex: faAvianex,
    faNs8: faNs8,
    faSquarePinterest: faSquarePinterest,
    faPinterestSquare: faPinterestSquare,
    faBluetoothB: faBluetoothB,
    faGripfire: faGripfire,
    faSquareGooglePlus: faSquareGooglePlus,
    faGooglePlusSquare: faGooglePlusSquare,
    faAppStore: faAppStore,
    faWix: faWix,
    faIntercom: faIntercom,
    faReacteurope: faReacteurope,
    faWaze: faWaze,
    faCreativeCommonsRemix: faCreativeCommonsRemix,
    faBandcamp: faBandcamp,
    faSquareWebAwesomeStroke: faSquareWebAwesomeStroke,
    faVimeoV: faVimeoV,
    faStrava: faStrava,
    faUniregistry: faUniregistry,
    faCcDinersClub: faCcDinersClub,
    faPinterest: faPinterest,
    faAlgolia: faAlgolia,
    faStackpath: faStackpath,
    faOctopusDeploy: faOctopusDeploy,
    faYammer: faYammer,
    faModx: faModx,
    faSquareThreads: faSquareThreads,
    faOldRepublic: faOldRepublic,
    faSuse: faSuse,
    faAppStoreIos: faAppStoreIos,
    faSquareDribbble: faSquareDribbble,
    faDribbbleSquare: faDribbbleSquare,
    faUikit: faUikit,
    faSuperpowers: faSuperpowers,
    faYoutube: faYoutube,
    faEmber: faEmber,
    faBootstrap: faBootstrap,
    faItunes: faItunes,
    faSquareXing: faSquareXing,
    faXingSquare: faXingSquare,
    faCss3Alt: faCss3Alt,
    faSquarespace: faSquarespace,
    faTrello: faTrello,
    faViadeo: faViadeo,
    faSearchengin: faSearchengin,
    faPaypal: faPaypal,
    faSquareBluesky: faSquareBluesky,
    faDAndDBeyond: faDAndDBeyond,
    faMicrosoft: faMicrosoft,
    faFly: faFly,
    faCcStripe: faCcStripe,
    faWordpressSimple: faWordpressSimple,
    faSellsy: faSellsy,
    faDashcube: faDashcube,
    faGitter: faGitter,
    faWolfPackBattalion: faWolfPackBattalion,
    faLastfm: faLastfm,
    faShopware: faShopware,
    faBlogger: faBlogger,
    faEdge: faEdge,
    faIoxhost: faIoxhost,
    faSchlix: faSchlix,
    faDAndD: faDAndD,
    faVuejs: faVuejs,
    faMeta: faMeta,
    faCreativeCommonsShare: faCreativeCommonsShare,
    faStudiovinari: faStudiovinari,
    faBitbucket: faBitbucket,
    faVk: faVk,
    faGithub: faGithub,
    faCodiepie: faCodiepie,
    faPiedPiper: faPiedPiper,
    faRaspberryPi: faRaspberryPi,
    faCss3: faCss3,
    faHubspot: faHubspot,
    faCmplid: faCmplid,
    faDyalog: faDyalog,
    faElementor: faElementor,
    faFirstOrder: faFirstOrder,
    faDribbble: faDribbble,
    faLinkedin: faLinkedin,
    faCcPaypal: faCcPaypal,
    faDhl: faDhl,
    faTex: faTex,
    faShopify: faShopify,
    faSquareReddit: faSquareReddit,
    faRedditSquare: faRedditSquare,
    faCreativeCommonsNc: faCreativeCommonsNc,
    faGalacticRepublic: faGalacticRepublic,
    faFacebook: faFacebook,
    faGitlab: faGitlab,
    faQq: faQq,
    faStripe: faStripe,
    faDailymotion: faDailymotion,
    faSteam: faSteam,
    faSnapchat: faSnapchat,
    faSnapchatGhost: faSnapchatGhost,
    faGalacticSenate: faGalacticSenate,
    faPhoenixFramework: faPhoenixFramework,
    faGit: faGit,
    faOptinMonster: faOptinMonster,
    faJenkins: faJenkins,
    faSlideshare: faSlideshare,
    faUber: faUber,
    faDigitalOcean: faDigitalOcean,
    faSoundcloud: faSoundcloud,
    faSquareFigma: faSquareFigma,
    faCreativeCommonsSa: faCreativeCommonsSa,
    faChrome: faChrome,
    faTradeFederation: faTradeFederation,
    faVaadin: faVaadin,
    faDeviantart: faDeviantart,
    faMedium: faMedium,
    faMediumM: faMediumM,
    faOpencart: faOpencart,
    faYCombinator: faYCombinator,
    faLine: faLine,
    faAmilia: faAmilia,
    faAsymmetrik: faAsymmetrik,
    faPhabricator: faPhabricator,
    faBots: faBots,
    faVine: faVine,
    faMedrt: faMedrt,
    faOsi: faOsi,
    faGg: faGg,
    faBuysellads: faBuysellads,
    faGooglePlus: faGooglePlus,
    faScreenpal: faScreenpal,
    faBitcoin: faBitcoin,
    faSwift: faSwift,
    faFilesPinwheel: faFilesPinwheel,
    faLaravel: faLaravel,
    faWpforms: faWpforms,
    faSpeakerDeck: faSpeakerDeck,
    faFlickr: faFlickr,
    faCcVisa: faCcVisa,
    faUpwork: faUpwork,
    faKakaoTalk: faKakaoTalk,
    faFlutter: faFlutter,
    faBuffer: faBuffer,
    faGratipay: faGratipay,
    faGooglePay: faGooglePay,
    faApple: faApple,
    faTumblr: faTumblr,
    faPhoenixSquadron: faPhoenixSquadron,
    faCentercode: faCentercode,
    faDebian: faDebian,
    faMastodon: faMastodon,
    faSketch: faSketch,
    faWebAwesome: faWebAwesome,
    faSass: faSass,
    faSquareWhatsapp: faSquareWhatsapp,
    faWhatsappSquare: faWhatsappSquare,
    faSkype: faSkype,
    faAngular: faAngular,
    faOpensuse: faOpensuse,
    faDropbox: faDropbox,
    faDeezer: faDeezer,
    faCreativeCommonsSampling: faCreativeCommonsSampling,
    faJediOrder: faJediOrder,
    faRProject: faRProject,
    faInstalod: faInstalod,
    faCanadianMapleLeaf: faCanadianMapleLeaf,
    faEthereum: faEthereum,
    faHouzz: faHouzz,
    faViber: faViber,
    faKickstarter: faKickstarter,
    faSquareKickstarter: faSquareKickstarter,
    faSpotify: faSpotify,
    faLeanpub: faLeanpub,
    faJava: faJava,
    faNfcSymbol: faNfcSymbol,
    faWodu: faWodu,
    faSquareSteam: faSquareSteam,
    faSteamSquare: faSteamSquare,
    faCreativeCommonsNcEu: faCreativeCommonsNcEu,
    faNpm: faNpm,
    faCloudscale: faCloudscale,
    faThemeco: faThemeco,
    faGooglePlay: faGooglePlay,
    faKorvue: faKorvue,
    faW3c: faW3c,
    faGrav: faGrav,
    faAws: faAws,
    faGlideG: faGlideG,
    faJsfiddle: faJsfiddle,
    faKeybase: faKeybase,
    faLumonDrop: faLumonDrop,
    faWeebly: faWeebly,
    faDocker: faDocker,
    faMagento: faMagento,
    faGitAlt: faGitAlt,
    faFirefoxBrowser: faFirefoxBrowser,
    faCloudsmith: faCloudsmith,
    faWizardsOfTheCoast: faWizardsOfTheCoast,
    faCreativeCommonsNd: faCreativeCommonsNd,
    faUsps: faUsps,
    faSquareLetterboxd: faSquareLetterboxd,
    faMandalorian: faMandalorian,
    faSlack: faSlack,
    faSlackHash: faSlackHash,
    faAngellist: faAngellist,
    faAndroid: faAndroid,
    faMeetup: faMeetup,
    faFonticonsFi: faFonticonsFi,
    faPalfed: faPalfed,
    faWpbeginner: faWpbeginner,
    faDiaspora: faDiaspora,
    faProductHunt: faProductHunt,
    faSquareUpwork: faSquareUpwork,
    faCuttlefish: faCuttlefish,
    faMedapps: faMedapps,
    faPix: faPix,
    faSquareTumblr: faSquareTumblr,
    faTumblrSquare: faTumblrSquare,
    faReact: faReact,
    faJxl: faJxl,
    faSquareLinkedin: faSquareLinkedin,
    faCss: faCss,
    faHashnode: faHashnode,
    faRedditAlien: faRedditAlien,
    faTiktok: faTiktok,
    faWordpress: faWordpress,
    faIdeal: faIdeal,
    faPiedPiperPp: faPiedPiperPp,
    faUssunnah: faUssunnah,
    faFortAwesomeAlt: faFortAwesomeAlt,
    faBuromobelexperte: faBuromobelexperte,
    faBilibili: faBilibili,
    faNeos: faNeos,
    faDev: faDev,
    faHotjar: faHotjar,
    faDochub: faDochub,
    faVimeo: faVimeo,
    faMaxcdn: faMaxcdn,
    faSquareFontAwesomeStroke: faSquareFontAwesomeStroke,
    faFontAwesomeAlt: faFontAwesomeAlt,
    faSpeakap: faSpeakap,
    faFantasyFlightGames: faFantasyFlightGames,
    faLinux: faLinux,
    faCottonBureau: faCottonBureau,
    faGoogleWallet: faGoogleWallet,
    faFoursquare: faFoursquare,
    faShirtsinbulk: faShirtsinbulk,
    faMintbit: faMintbit,
    faStaylinked: faStaylinked,
    faWebflow: faWebflow,
    faRenren: faRenren,
    faRev: faRev,
    faKeycdn: faKeycdn,
    faHireAHelper: faHireAHelper,
    faSquareHackerNews: faSquareHackerNews,
    faHackerNewsSquare: faHackerNewsSquare,
    faCreativeCommonsPdAlt: faCreativeCommonsPdAlt,
    faOrcid: faOrcid,
    faBehance: faBehance,
    faMonero: faMonero,
    faFigma: faFigma,
    faInstagram: faInstagram,
    faPerbyte: faPerbyte,
    faSquareVimeo: faSquareVimeo,
    faVimeoSquare: faVimeoSquare,
    faPushed: faPushed,
    faMixcloud: faMixcloud,
    faYandexInternational: faYandexInternational,
    faHive: faHive,
    faCreativeCommonsZero: faCreativeCommonsZero,
    faSquareSnapchat: faSquareSnapchat,
    faSnapchatSquare: faSnapchatSquare,
    faThemeisle: faThemeisle,
    faDartLang: faDartLang,
    faDeploydog: faDeploydog,
    faFlipboard: faFlipboard,
    faBuyNLarge: faBuyNLarge,
    faWatchmanMonitoring: faWatchmanMonitoring,
    faHips: faHips,
    faCloudversify: faCloudversify,
    faGoodreads: faGoodreads,
    faTidal: faTidal,
    faUnity: faUnity,
    faTencentWeibo: faTencentWeibo,
    faFreeCodeCamp: faFreeCodeCamp,
    faXTwitter: faXTwitter,
    faStickerMule: faStickerMule,
    faTwitch: faTwitch,
    faKickstarterK: faKickstarterK,
    faCriticalRole: faCriticalRole,
    faSteamSymbol: faSteamSymbol,
    faMailchimp: faMailchimp,
    faLumon: faLumon,
    faNutritionix: faNutritionix,
    faCreativeCommonsSamplingPlus: faCreativeCommonsSamplingPlus,
    faRedhat: faRedhat,
    faSquarePiedPiper: faSquarePiedPiper,
    faPiedPiperSquare: faPiedPiperSquare,
    faWhatsapp: faWhatsapp,
    faImdb: faImdb,
    faPython: faPython,
    faCashApp: faCashApp,
    faPinterestP: faPinterestP,
    faWhmcs: faWhmcs,
    faJoget: faJoget,
    faSquareYoutube: faSquareYoutube,
    faYoutubeSquare: faYoutubeSquare,
    faAtlassian: faAtlassian,
    faPiedPiperHat: faPiedPiperHat,
    faInternetExplorer: faInternetExplorer,
    faAirbnb: faAirbnb,
    faJs: faJs,
    faQuinscape: faQuinscape,
    faAdversal: faAdversal,
    faCreativeCommons: faCreativeCommons,
    faNotion: faNotion,
    faChromecast: faChromecast,
    faWikipediaW: faWikipediaW,
    faSitrox: faSitrox,
    faSquareGitlab: faSquareGitlab,
    faGitlabSquare: faGitlabSquare,
    faShoelace: faShoelace,
    faSellcast: faSellcast,
    faMix: faMix,
    faCcApplePay: faCcApplePay,
    faBrave: faBrave,
    faEtsy: faEtsy,
    faBtc: faBtc,
    faAdn: faAdn,
    faSquareXTwitter: faSquareXTwitter,
    faSquareFontAwesome: faSquareFontAwesome,
    faForumbee: faForumbee,
    fa42Group: fa42Group,
    faInnosoft: faInnosoft,
    faStumbleuponCircle: faStumbleuponCircle,
    faSymfony: faSymfony,
    faSalesforce: faSalesforce,
    faSourcetree: faSourcetree,
    faLinkedinIn: faLinkedinIn,
    faHtml5: faHtml5,
    faRust: faRust,
    faHornbill: faHornbill,
    faPhp: faPhp,
    faDisqus: faDisqus,
    fa500px: fa500px,
    faAffiliatetheme: faAffiliatetheme,
    faRedRiver: faRedRiver,
    faTwitter: faTwitter,
    faFortAwesome: faFortAwesome,
    faMixer: faMixer,
    faLyft: faLyft,
    faApplePay: faApplePay,
    faArtstation: faArtstation,
    faNodeJs: faNodeJs,
    faUncharted: faUncharted,
    faPlaystation: faPlaystation,
    faMicroblog: faMicroblog,
    faGitkraken: faGitkraken,
    faTelegram: faTelegram,
    faTelegramPlane: faTelegramPlane,
    faItunesNote: faItunesNote,
    faLess: faLess,
    faFirefox: faFirefox,
    faKaggle: faKaggle,
    faFacebookMessenger: faFacebookMessenger,
    faAudible: faAudible,
    faPatreon: faPatreon,
    faVnv: faVnv,
    faPagelines: faPagelines,
    faAmazon: faAmazon,
    faEnvira: faEnvira,
    faLinode: faLinode,
    faAccusoft: faAccusoft,
    faErlang: faErlang,
    faCcDiscover: faCcDiscover,
    faSafari: faSafari,
    faSpaceAwesome: faSpaceAwesome,
    faNode: faNode,
    faCodepen: faCodepen,
    faRavelry: faRavelry,
    faAlipay: faAlipay,
    faCcAmex: faCcAmex,
    faPiedPiperAlt: faPiedPiperAlt,
    faLetterboxd: faLetterboxd,
    faOpera: faOpera,
    faWeibo: faWeibo,
    faReadme: faReadme,
    faGolang: faGolang,
    faStackExchange: faStackExchange,
    faGulp: faGulp,
    faYelp: faYelp,
    faGofore: faGofore,
    faAviato: faAviato,
    faPadlet: faPadlet,
    faEdgeLegacy: faEdgeLegacy,
    faSquareLastfm: faSquareLastfm,
    faLastfmSquare: faLastfmSquare,
    faGoodreadsG: faGoodreadsG,
    faCcMastercard: faCcMastercard,
    faDiscourse: faDiscourse,
    faBlackTie: faBlackTie,
    faSquareFacebook: faSquareFacebook,
    faFacebookSquare: faFacebookSquare,
    faBattleNet: faBattleNet,
    faBimobject: faBimobject
  };

  exports.fab = icons;
  exports.prefix = prefix;
  exports.faSquareGithub = faSquareGithub;
  exports.faGithubSquare = faGithubSquare;
  exports.faThinkPeaks = faThinkPeaks;
  exports.faGoogleDrive = faGoogleDrive;
  exports.faAutoprefixer = faAutoprefixer;
  exports.faSquareViadeo = faSquareViadeo;
  exports.faViadeoSquare = faViadeoSquare;
  exports.faCpanel = faCpanel;
  exports.faMendeley = faMendeley;
  exports.faDraft2digital = faDraft2digital;
  exports.faReplyd = faReplyd;
  exports.faEmpire = faEmpire;
  exports.faAccessibleIcon = faAccessibleIcon;
  exports.faQuora = faQuora;
  exports.faCcJcb = faCcJcb;
  exports.faFedora = faFedora;
  exports.faDuolingo = faDuolingo;
  exports.faFirstdraft = faFirstdraft;
  exports.faFreebsd = faFreebsd;
  exports.faOdysee = faOdysee;
  exports.faGgCircle = faGgCircle;
  exports.faCloudflare = faCloudflare;
  exports.faHackerrank = faHackerrank;
  exports.faSkyatlas = faSkyatlas;
  exports.faDeskpro = faDeskpro;
  exports.faResolving = faResolving;
  exports.faBlackberry = faBlackberry;
  exports.faStripeS = faStripeS;
  exports.faSquareBehance = faSquareBehance;
  exports.faBehanceSquare = faBehanceSquare;
  exports.faServicestack = faServicestack;
  exports.faRocketchat = faRocketchat;
  exports.faRebel = faRebel;
  exports.faSquareWebAwesome = faSquareWebAwesome;
  exports.faLinktree = faLinktree;
  exports.faSimplybuilt = faSimplybuilt;
  exports.faStubber = faStubber;
  exports.faApper = faApper;
  exports.faGoogleScholar = faGoogleScholar;
  exports.faYarn = faYarn;
  exports.faStackOverflow = faStackOverflow;
  exports.faBluetooth = faBluetooth;
  exports.faCreativeCommonsNcJp = faCreativeCommonsNcJp;
  exports.faReddit = faReddit;
  exports.faConnectdevelop = faConnectdevelop;
  exports.faResearchgate = faResearchgate;
  exports.faSignalMessenger = faSignalMessenger;
  exports.faXing = faXing;
  exports.faSquareJs = faSquareJs;
  exports.faJsSquare = faJsSquare;
  exports.faFonticons = faFonticons;
  exports.faUps = faUps;
  exports.faAmazonPay = faAmazonPay;
  exports.faPandora = faPandora;
  exports.faOpenid = faOpenid;
  exports.faVsco = faVsco;
  exports.faUbuntu = faUbuntu;
  exports.faViacoin = faViacoin;
  exports.faZhihu = faZhihu;
  exports.faYandex = faYandex;
  exports.faPixiv = faPixiv;
  exports.faOpenai = faOpenai;
  exports.faSith = faSith;
  exports.faNfcDirectional = faNfcDirectional;
  exports.faCreativeCommonsBy = faCreativeCommonsBy;
  exports.faUmbraco = faUmbraco;
  exports.faHooli = faHooli;
  exports.faSquareGit = faSquareGit;
  exports.faGitSquare = faGitSquare;
  exports.faOdnoklassniki = faOdnoklassniki;
  exports.faDrupal = faDrupal;
  exports.faBloggerB = faBloggerB;
  exports.faInvision = faInvision;
  exports.faFacebookF = faFacebookF;
  exports.faCentos = faCentos;
  exports.faCcAmazonPay = faCcAmazonPay;
  exports.faEbay = faEbay;
  exports.faContao = faContao;
  exports.faEllo = faEllo;
  exports.faSistrix = faSistrix;
  exports.faPeriscope = faPeriscope;
  exports.faExpeditedssl = faExpeditedssl;
  exports.faNapster = faNapster;
  exports.faDelicious = faDelicious;
  exports.faGuilded = faGuilded;
  exports.faXbox = faXbox;
  exports.faUntappd = faUntappd;
  exports.faGooglePlusG = faGooglePlusG;
  exports.faGithubAlt = faGithubAlt;
  exports.faGetPocket = faGetPocket;
  exports.faGlide = faGlide;
  exports.faBity = faBity;
  exports.faWpexplorer = faWpexplorer;
  exports.faMegaport = faMegaport;
  exports.faMdb = faMdb;
  exports.faPage4 = faPage4;
  exports.faTheRedYeti = faTheRedYeti;
  exports.faJira = faJira;
  exports.faFedex = faFedex;
  exports.faEvernote = faEvernote;
  exports.faUsb = faUsb;
  exports.faAngrycreative = faAngrycreative;
  exports.faMizuni = faMizuni;
  exports.faItchIo = faItchIo;
  exports.faWindows = faWindows;
  exports.faStumbleupon = faStumbleupon;
  exports.faGoogle = faGoogle;
  exports.faDiscord = faDiscord;
  exports.faHackerNews = faHackerNews;
  exports.faEleventy = faEleventy;
  exports.fa11ty = fa11ty;
  exports.faTeamspeak = faTeamspeak;
  exports.faSupple = faSupple;
  exports.faSquareTwitter = faSquareTwitter;
  exports.faTwitterSquare = faTwitterSquare;
  exports.faFontAwesome = faFontAwesome;
  exports.faFontAwesomeFlag = faFontAwesomeFlag;
  exports.faFontAwesomeLogoFull = faFontAwesomeLogoFull;
  exports.faWirsindhandwerk = faWirsindhandwerk;
  exports.faWsh = faWsh;
  exports.faConfluence = faConfluence;
  exports.faDigg = faDigg;
  exports.faThreads = faThreads;
  exports.faWpressr = faWpressr;
  exports.faRendact = faRendact;
  exports.faYoast = faYoast;
  exports.faNimblr = faNimblr;
  exports.faPixelfed = faPixelfed;
  exports.faYahoo = faYahoo;
  exports.faBluesky = faBluesky;
  exports.faScribd = faScribd;
  exports.faCreativeCommonsPd = faCreativeCommonsPd;
  exports.faEarlybirds = faEarlybirds;
  exports.faSquareOdnoklassniki = faSquareOdnoklassniki;
  exports.faOdnoklassnikiSquare = faOdnoklassnikiSquare;
  exports.faMarkdown = faMarkdown;
  exports.faTypo3 = faTypo3;
  exports.faJoomla = faJoomla;
  exports.faWeixin = faWeixin;
  exports.faGrunt = faGrunt;
  exports.faRockrms = faRockrms;
  exports.faUnsplash = faUnsplash;
  exports.faSquareInstagram = faSquareInstagram;
  exports.faInstagramSquare = faInstagramSquare;
  exports.faFirstOrderAlt = faFirstOrderAlt;
  exports.faFulcrum = faFulcrum;
  exports.faBraveReverse = faBraveReverse;
  exports.faAvianex = faAvianex;
  exports.faNs8 = faNs8;
  exports.faSquarePinterest = faSquarePinterest;
  exports.faPinterestSquare = faPinterestSquare;
  exports.faBluetoothB = faBluetoothB;
  exports.faGripfire = faGripfire;
  exports.faSquareGooglePlus = faSquareGooglePlus;
  exports.faGooglePlusSquare = faGooglePlusSquare;
  exports.faAppStore = faAppStore;
  exports.faWix = faWix;
  exports.faIntercom = faIntercom;
  exports.faReacteurope = faReacteurope;
  exports.faWaze = faWaze;
  exports.faCreativeCommonsRemix = faCreativeCommonsRemix;
  exports.faBandcamp = faBandcamp;
  exports.faSquareWebAwesomeStroke = faSquareWebAwesomeStroke;
  exports.faVimeoV = faVimeoV;
  exports.faStrava = faStrava;
  exports.faUniregistry = faUniregistry;
  exports.faCcDinersClub = faCcDinersClub;
  exports.faPinterest = faPinterest;
  exports.faAlgolia = faAlgolia;
  exports.faStackpath = faStackpath;
  exports.faOctopusDeploy = faOctopusDeploy;
  exports.faYammer = faYammer;
  exports.faModx = faModx;
  exports.faSquareThreads = faSquareThreads;
  exports.faOldRepublic = faOldRepublic;
  exports.faSuse = faSuse;
  exports.faAppStoreIos = faAppStoreIos;
  exports.faSquareDribbble = faSquareDribbble;
  exports.faDribbbleSquare = faDribbbleSquare;
  exports.faUikit = faUikit;
  exports.faSuperpowers = faSuperpowers;
  exports.faYoutube = faYoutube;
  exports.faEmber = faEmber;
  exports.faBootstrap = faBootstrap;
  exports.faItunes = faItunes;
  exports.faSquareXing = faSquareXing;
  exports.faXingSquare = faXingSquare;
  exports.faCss3Alt = faCss3Alt;
  exports.faSquarespace = faSquarespace;
  exports.faTrello = faTrello;
  exports.faViadeo = faViadeo;
  exports.faSearchengin = faSearchengin;
  exports.faPaypal = faPaypal;
  exports.faSquareBluesky = faSquareBluesky;
  exports.faDAndDBeyond = faDAndDBeyond;
  exports.faMicrosoft = faMicrosoft;
  exports.faFly = faFly;
  exports.faCcStripe = faCcStripe;
  exports.faWordpressSimple = faWordpressSimple;
  exports.faSellsy = faSellsy;
  exports.faDashcube = faDashcube;
  exports.faGitter = faGitter;
  exports.faWolfPackBattalion = faWolfPackBattalion;
  exports.faLastfm = faLastfm;
  exports.faShopware = faShopware;
  exports.faBlogger = faBlogger;
  exports.faEdge = faEdge;
  exports.faIoxhost = faIoxhost;
  exports.faSchlix = faSchlix;
  exports.faDAndD = faDAndD;
  exports.faVuejs = faVuejs;
  exports.faMeta = faMeta;
  exports.faCreativeCommonsShare = faCreativeCommonsShare;
  exports.faStudiovinari = faStudiovinari;
  exports.faBitbucket = faBitbucket;
  exports.faVk = faVk;
  exports.faGithub = faGithub;
  exports.faCodiepie = faCodiepie;
  exports.faPiedPiper = faPiedPiper;
  exports.faRaspberryPi = faRaspberryPi;
  exports.faCss3 = faCss3;
  exports.faHubspot = faHubspot;
  exports.faCmplid = faCmplid;
  exports.faDyalog = faDyalog;
  exports.faElementor = faElementor;
  exports.faFirstOrder = faFirstOrder;
  exports.faDribbble = faDribbble;
  exports.faLinkedin = faLinkedin;
  exports.faCcPaypal = faCcPaypal;
  exports.faDhl = faDhl;
  exports.faTex = faTex;
  exports.faShopify = faShopify;
  exports.faSquareReddit = faSquareReddit;
  exports.faRedditSquare = faRedditSquare;
  exports.faCreativeCommonsNc = faCreativeCommonsNc;
  exports.faGalacticRepublic = faGalacticRepublic;
  exports.faFacebook = faFacebook;
  exports.faGitlab = faGitlab;
  exports.faQq = faQq;
  exports.faStripe = faStripe;
  exports.faDailymotion = faDailymotion;
  exports.faSteam = faSteam;
  exports.faSnapchat = faSnapchat;
  exports.faSnapchatGhost = faSnapchatGhost;
  exports.faGalacticSenate = faGalacticSenate;
  exports.faPhoenixFramework = faPhoenixFramework;
  exports.faGit = faGit;
  exports.faOptinMonster = faOptinMonster;
  exports.faJenkins = faJenkins;
  exports.faSlideshare = faSlideshare;
  exports.faUber = faUber;
  exports.faDigitalOcean = faDigitalOcean;
  exports.faSoundcloud = faSoundcloud;
  exports.faSquareFigma = faSquareFigma;
  exports.faCreativeCommonsSa = faCreativeCommonsSa;
  exports.faChrome = faChrome;
  exports.faTradeFederation = faTradeFederation;
  exports.faVaadin = faVaadin;
  exports.faDeviantart = faDeviantart;
  exports.faMedium = faMedium;
  exports.faMediumM = faMediumM;
  exports.faOpencart = faOpencart;
  exports.faYCombinator = faYCombinator;
  exports.faLine = faLine;
  exports.faAmilia = faAmilia;
  exports.faAsymmetrik = faAsymmetrik;
  exports.faPhabricator = faPhabricator;
  exports.faBots = faBots;
  exports.faVine = faVine;
  exports.faMedrt = faMedrt;
  exports.faOsi = faOsi;
  exports.faGg = faGg;
  exports.faBuysellads = faBuysellads;
  exports.faGooglePlus = faGooglePlus;
  exports.faScreenpal = faScreenpal;
  exports.faBitcoin = faBitcoin;
  exports.faSwift = faSwift;
  exports.faFilesPinwheel = faFilesPinwheel;
  exports.faLaravel = faLaravel;
  exports.faWpforms = faWpforms;
  exports.faSpeakerDeck = faSpeakerDeck;
  exports.faFlickr = faFlickr;
  exports.faCcVisa = faCcVisa;
  exports.faUpwork = faUpwork;
  exports.faKakaoTalk = faKakaoTalk;
  exports.faFlutter = faFlutter;
  exports.faBuffer = faBuffer;
  exports.faGratipay = faGratipay;
  exports.faGooglePay = faGooglePay;
  exports.faApple = faApple;
  exports.faTumblr = faTumblr;
  exports.faPhoenixSquadron = faPhoenixSquadron;
  exports.faCentercode = faCentercode;
  exports.faDebian = faDebian;
  exports.faMastodon = faMastodon;
  exports.faSketch = faSketch;
  exports.faWebAwesome = faWebAwesome;
  exports.faSass = faSass;
  exports.faSquareWhatsapp = faSquareWhatsapp;
  exports.faWhatsappSquare = faWhatsappSquare;
  exports.faSkype = faSkype;
  exports.faAngular = faAngular;
  exports.faOpensuse = faOpensuse;
  exports.faDropbox = faDropbox;
  exports.faDeezer = faDeezer;
  exports.faCreativeCommonsSampling = faCreativeCommonsSampling;
  exports.faJediOrder = faJediOrder;
  exports.faRProject = faRProject;
  exports.faInstalod = faInstalod;
  exports.faCanadianMapleLeaf = faCanadianMapleLeaf;
  exports.faEthereum = faEthereum;
  exports.faHouzz = faHouzz;
  exports.faViber = faViber;
  exports.faKickstarter = faKickstarter;
  exports.faSquareKickstarter = faSquareKickstarter;
  exports.faSpotify = faSpotify;
  exports.faLeanpub = faLeanpub;
  exports.faJava = faJava;
  exports.faNfcSymbol = faNfcSymbol;
  exports.faWodu = faWodu;
  exports.faSquareSteam = faSquareSteam;
  exports.faSteamSquare = faSteamSquare;
  exports.faCreativeCommonsNcEu = faCreativeCommonsNcEu;
  exports.faNpm = faNpm;
  exports.faCloudscale = faCloudscale;
  exports.faThemeco = faThemeco;
  exports.faGooglePlay = faGooglePlay;
  exports.faKorvue = faKorvue;
  exports.faW3c = faW3c;
  exports.faGrav = faGrav;
  exports.faAws = faAws;
  exports.faGlideG = faGlideG;
  exports.faJsfiddle = faJsfiddle;
  exports.faKeybase = faKeybase;
  exports.faLumonDrop = faLumonDrop;
  exports.faWeebly = faWeebly;
  exports.faDocker = faDocker;
  exports.faMagento = faMagento;
  exports.faGitAlt = faGitAlt;
  exports.faFirefoxBrowser = faFirefoxBrowser;
  exports.faCloudsmith = faCloudsmith;
  exports.faWizardsOfTheCoast = faWizardsOfTheCoast;
  exports.faCreativeCommonsNd = faCreativeCommonsNd;
  exports.faUsps = faUsps;
  exports.faSquareLetterboxd = faSquareLetterboxd;
  exports.faMandalorian = faMandalorian;
  exports.faSlack = faSlack;
  exports.faSlackHash = faSlackHash;
  exports.faAngellist = faAngellist;
  exports.faAndroid = faAndroid;
  exports.faMeetup = faMeetup;
  exports.faFonticonsFi = faFonticonsFi;
  exports.faPalfed = faPalfed;
  exports.faWpbeginner = faWpbeginner;
  exports.faDiaspora = faDiaspora;
  exports.faProductHunt = faProductHunt;
  exports.faSquareUpwork = faSquareUpwork;
  exports.faCuttlefish = faCuttlefish;
  exports.faMedapps = faMedapps;
  exports.faPix = faPix;
  exports.faSquareTumblr = faSquareTumblr;
  exports.faTumblrSquare = faTumblrSquare;
  exports.faReact = faReact;
  exports.faJxl = faJxl;
  exports.faSquareLinkedin = faSquareLinkedin;
  exports.faCss = faCss;
  exports.faHashnode = faHashnode;
  exports.faRedditAlien = faRedditAlien;
  exports.faTiktok = faTiktok;
  exports.faWordpress = faWordpress;
  exports.faIdeal = faIdeal;
  exports.faPiedPiperPp = faPiedPiperPp;
  exports.faUssunnah = faUssunnah;
  exports.faFortAwesomeAlt = faFortAwesomeAlt;
  exports.faBuromobelexperte = faBuromobelexperte;
  exports.faBilibili = faBilibili;
  exports.faNeos = faNeos;
  exports.faDev = faDev;
  exports.faHotjar = faHotjar;
  exports.faDochub = faDochub;
  exports.faVimeo = faVimeo;
  exports.faMaxcdn = faMaxcdn;
  exports.faSquareFontAwesomeStroke = faSquareFontAwesomeStroke;
  exports.faFontAwesomeAlt = faFontAwesomeAlt;
  exports.faSpeakap = faSpeakap;
  exports.faFantasyFlightGames = faFantasyFlightGames;
  exports.faLinux = faLinux;
  exports.faCottonBureau = faCottonBureau;
  exports.faGoogleWallet = faGoogleWallet;
  exports.faFoursquare = faFoursquare;
  exports.faShirtsinbulk = faShirtsinbulk;
  exports.faMintbit = faMintbit;
  exports.faStaylinked = faStaylinked;
  exports.faWebflow = faWebflow;
  exports.faRenren = faRenren;
  exports.faRev = faRev;
  exports.faKeycdn = faKeycdn;
  exports.faHireAHelper = faHireAHelper;
  exports.faSquareHackerNews = faSquareHackerNews;
  exports.faHackerNewsSquare = faHackerNewsSquare;
  exports.faCreativeCommonsPdAlt = faCreativeCommonsPdAlt;
  exports.faOrcid = faOrcid;
  exports.faBehance = faBehance;
  exports.faMonero = faMonero;
  exports.faFigma = faFigma;
  exports.faInstagram = faInstagram;
  exports.faPerbyte = faPerbyte;
  exports.faSquareVimeo = faSquareVimeo;
  exports.faVimeoSquare = faVimeoSquare;
  exports.faPushed = faPushed;
  exports.faMixcloud = faMixcloud;
  exports.faYandexInternational = faYandexInternational;
  exports.faHive = faHive;
  exports.faCreativeCommonsZero = faCreativeCommonsZero;
  exports.faSquareSnapchat = faSquareSnapchat;
  exports.faSnapchatSquare = faSnapchatSquare;
  exports.faThemeisle = faThemeisle;
  exports.faDartLang = faDartLang;
  exports.faDeploydog = faDeploydog;
  exports.faFlipboard = faFlipboard;
  exports.faBuyNLarge = faBuyNLarge;
  exports.faWatchmanMonitoring = faWatchmanMonitoring;
  exports.faHips = faHips;
  exports.faCloudversify = faCloudversify;
  exports.faGoodreads = faGoodreads;
  exports.faTidal = faTidal;
  exports.faUnity = faUnity;
  exports.faTencentWeibo = faTencentWeibo;
  exports.faFreeCodeCamp = faFreeCodeCamp;
  exports.faXTwitter = faXTwitter;
  exports.faStickerMule = faStickerMule;
  exports.faTwitch = faTwitch;
  exports.faKickstarterK = faKickstarterK;
  exports.faCriticalRole = faCriticalRole;
  exports.faSteamSymbol = faSteamSymbol;
  exports.faMailchimp = faMailchimp;
  exports.faLumon = faLumon;
  exports.faNutritionix = faNutritionix;
  exports.faCreativeCommonsSamplingPlus = faCreativeCommonsSamplingPlus;
  exports.faRedhat = faRedhat;
  exports.faSquarePiedPiper = faSquarePiedPiper;
  exports.faPiedPiperSquare = faPiedPiperSquare;
  exports.faWhatsapp = faWhatsapp;
  exports.faImdb = faImdb;
  exports.faPython = faPython;
  exports.faCashApp = faCashApp;
  exports.faPinterestP = faPinterestP;
  exports.faWhmcs = faWhmcs;
  exports.faJoget = faJoget;
  exports.faSquareYoutube = faSquareYoutube;
  exports.faYoutubeSquare = faYoutubeSquare;
  exports.faAtlassian = faAtlassian;
  exports.faPiedPiperHat = faPiedPiperHat;
  exports.faInternetExplorer = faInternetExplorer;
  exports.faAirbnb = faAirbnb;
  exports.faJs = faJs;
  exports.faQuinscape = faQuinscape;
  exports.faAdversal = faAdversal;
  exports.faCreativeCommons = faCreativeCommons;
  exports.faNotion = faNotion;
  exports.faChromecast = faChromecast;
  exports.faWikipediaW = faWikipediaW;
  exports.faSitrox = faSitrox;
  exports.faSquareGitlab = faSquareGitlab;
  exports.faGitlabSquare = faGitlabSquare;
  exports.faShoelace = faShoelace;
  exports.faSellcast = faSellcast;
  exports.faMix = faMix;
  exports.faCcApplePay = faCcApplePay;
  exports.faBrave = faBrave;
  exports.faEtsy = faEtsy;
  exports.faBtc = faBtc;
  exports.faAdn = faAdn;
  exports.faSquareXTwitter = faSquareXTwitter;
  exports.faSquareFontAwesome = faSquareFontAwesome;
  exports.faForumbee = faForumbee;
  exports.fa42Group = fa42Group;
  exports.faInnosoft = faInnosoft;
  exports.faStumbleuponCircle = faStumbleuponCircle;
  exports.faSymfony = faSymfony;
  exports.faSalesforce = faSalesforce;
  exports.faSourcetree = faSourcetree;
  exports.faLinkedinIn = faLinkedinIn;
  exports.faHtml5 = faHtml5;
  exports.faRust = faRust;
  exports.faHornbill = faHornbill;
  exports.faPhp = faPhp;
  exports.faDisqus = faDisqus;
  exports.fa500px = fa500px;
  exports.faAffiliatetheme = faAffiliatetheme;
  exports.faRedRiver = faRedRiver;
  exports.faTwitter = faTwitter;
  exports.faFortAwesome = faFortAwesome;
  exports.faMixer = faMixer;
  exports.faLyft = faLyft;
  exports.faApplePay = faApplePay;
  exports.faArtstation = faArtstation;
  exports.faNodeJs = faNodeJs;
  exports.faUncharted = faUncharted;
  exports.faPlaystation = faPlaystation;
  exports.faMicroblog = faMicroblog;
  exports.faGitkraken = faGitkraken;
  exports.faTelegram = faTelegram;
  exports.faTelegramPlane = faTelegramPlane;
  exports.faItunesNote = faItunesNote;
  exports.faLess = faLess;
  exports.faFirefox = faFirefox;
  exports.faKaggle = faKaggle;
  exports.faFacebookMessenger = faFacebookMessenger;
  exports.faAudible = faAudible;
  exports.faPatreon = faPatreon;
  exports.faVnv = faVnv;
  exports.faPagelines = faPagelines;
  exports.faAmazon = faAmazon;
  exports.faEnvira = faEnvira;
  exports.faLinode = faLinode;
  exports.faAccusoft = faAccusoft;
  exports.faErlang = faErlang;
  exports.faCcDiscover = faCcDiscover;
  exports.faSafari = faSafari;
  exports.faSpaceAwesome = faSpaceAwesome;
  exports.faNode = faNode;
  exports.faCodepen = faCodepen;
  exports.faRavelry = faRavelry;
  exports.faAlipay = faAlipay;
  exports.faCcAmex = faCcAmex;
  exports.faPiedPiperAlt = faPiedPiperAlt;
  exports.faLetterboxd = faLetterboxd;
  exports.faOpera = faOpera;
  exports.faWeibo = faWeibo;
  exports.faReadme = faReadme;
  exports.faGolang = faGolang;
  exports.faStackExchange = faStackExchange;
  exports.faGulp = faGulp;
  exports.faYelp = faYelp;
  exports.faGofore = faGofore;
  exports.faAviato = faAviato;
  exports.faPadlet = faPadlet;
  exports.faEdgeLegacy = faEdgeLegacy;
  exports.faSquareLastfm = faSquareLastfm;
  exports.faLastfmSquare = faLastfmSquare;
  exports.faGoodreadsG = faGoodreadsG;
  exports.faCcMastercard = faCcMastercard;
  exports.faDiscourse = faDiscourse;
  exports.faBlackTie = faBlackTie;
  exports.faSquareFacebook = faSquareFacebook;
  exports.faFacebookSquare = faFacebookSquare;
  exports.faBattleNet = faBattleNet;
  exports.faBimobject = faBimobject;

  Object.defineProperty(exports, '__esModule', { value: true });

})));
