"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.checkIsBtcLegacy = exports.getAppAndVersion = void 0;
const invariant_1 = __importDefault(require("invariant"));
const getAppAndVersion = async (transport) => {
    const r = await transport.send(0xb0, 0x01, 0x00, 0x00);
    let i = 0;
    const format = r[i++];
    (0, invariant_1.default)(format === 1, "getAppAndVersion: format not supported");
    const nameLength = r[i++];
    const name = r.slice(i, (i += nameLength)).toString("ascii");
    const versionLength = r[i++];
    const version = r.slice(i, (i += versionLength)).toString("ascii");
    const flagLength = r[i++];
    const flags = r.slice(i, (i += flagLength));
    return {
        name,
        version,
        flags,
    };
};
exports.getAppAndVersion = getAppAndVersion;
const checkIsBtcLegacy = async (transport) => {
    try {
        // Call old btc API, it will throw an exception with new btc app. It is a workaround to differentiate new/old btc nano app
        await transport.send(0xe0, 0xc4, 0, 0);
    }
    catch (e) {
        return false;
    }
    return true;
};
exports.checkIsBtcLegacy = checkIsBtcLegacy;
//# sourceMappingURL=getAppAndVersion.js.map