"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getHashedMessageToSign = getHashedMessageToSign;
exports.serialize = serialize;
exports.validateYParity = validateYParity;
const rlp_1 = require("@ethereumjs/rlp");
const util_1 = require("@ethereumjs/util");
const keccak_js_1 = require("ethereum-cryptography/keccak.js");
const internal_ts_1 = require("../util/internal.js");
const legacy_ts_1 = require("./legacy.js");
function getHashedMessageToSign(tx) {
    const keccakFunction = tx.common.customCrypto.keccak256 ?? keccak_js_1.keccak256;
    return keccakFunction(tx.getMessageToSign());
}
function serialize(tx, base) {
    return (0, util_1.concatBytes)((0, internal_ts_1.txTypeBytes)(tx.type), rlp_1.RLP.encode(base ?? tx.raw()));
}
function validateYParity(tx) {
    const { v } = tx;
    if (v !== undefined && v !== util_1.BIGINT_0 && v !== util_1.BIGINT_1) {
        const msg = (0, legacy_ts_1.errorMsg)(tx, 'The y-parity of the transaction should either be 0 or 1');
        throw (0, util_1.EthereumJSErrorWithoutCode)(msg);
    }
}
//# sourceMappingURL=eip2718.js.map