export type { KeyInfo, Expansion } from './types';
import type { Psbt } from 'bitcoinjs-lib';
import type { DescriptorInstance } from './descriptors';
export { DescriptorsFactory, DescriptorInstance, DescriptorConstructor } from './descriptors';
export { DescriptorChecksum as checksum } from './checksum';
import * as signers from './signers';
export { signers };
export declare function finalizePsbt({ psbt, descriptors, validate }: {
    psbt: Psbt;
    descriptors: DescriptorInstance[];
    validate?: boolean | undefined;
}): void;
export { keyExpressionBIP32, keyExpressionLedger } from './keyExpressions';
import * as scriptExpressions from './scriptExpressions';
export { scriptExpressions };
import { LedgerState, getLedgerMasterFingerPrint, getLedgerXpub, registerLedgerWallet, assertLedgerApp } from './ledger';
export declare const ledger: {
    getLedgerMasterFingerPrint: typeof getLedgerMasterFingerPrint;
    getLedgerXpub: typeof getLedgerXpub;
    registerLedgerWallet: typeof registerLedgerWallet;
    assertLedgerApp: typeof assertLedgerApp;
};
export type { LedgerState };
