"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.monitorCharacteristic = void 0;
const rxjs_1 = require("rxjs");
const errors_1 = require("@ledgerhq/errors");
const logs_1 = require("@ledgerhq/logs");
const LOG_TYPE = "ble-verbose";
const monitorCharacteristic = (characteristic, context) => new rxjs_1.Observable(o => {
    const tracer = new logs_1.LocalTracer(LOG_TYPE, context);
    tracer.trace(`Start monitoring BLE characteristics`, {
        characteristicUuid: characteristic.uuid,
    });
    const subscription = characteristic.monitor((error, c) => {
        if (error) {
            tracer.trace("Error while monitoring characteristics", { error });
            o.error(error);
        }
        else if (!c) {
            tracer.trace("BLE monitored characteristic null value");
            o.error(new errors_1.TransportError("Characteristic monitor null value", "CharacteristicMonitorNull"));
        }
        else {
            try {
                const value = Buffer.from(c.value, "base64");
                o.next(value);
            }
            catch (error) {
                o.error(error);
            }
        }
    });
    return () => {
        subscription.remove();
    };
});
exports.monitorCharacteristic = monitorCharacteristic;
//# sourceMappingURL=monitorCharacteristic.js.map