<img src="https://user-images.githubusercontent.com/4631227/191834116-59cf590e-25cc-4956-ae5c-812ea464f324.png" height="100" />

## @ledgerhq/logs

Utility library that is used by all Ledger libraries to dispatch logs so we can deal with them in a unified way.

## API

<!-- Generated by documentation.js. Update this documentation by updating the source code. -->

#### Table of Contents

*   [Log](#log)
    *   [type](#type)
    *   [data](#data)
    *   [context](#context)
    *   [id](#id)
*   [log](#log-1)
    *   [Parameters](#parameters)
*   [trace](#trace)
    *   [Parameters](#parameters-1)
*   [LocalTracer](#localtracer)
    *   [Parameters](#parameters-2)
    *   [withType](#withtype)
        *   [Parameters](#parameters-3)
    *   [withContext](#withcontext)
        *   [Parameters](#parameters-4)
    *   [withUpdatedContext](#withupdatedcontext)
        *   [Parameters](#parameters-5)
*   [listen](#listen)
    *   [Parameters](#parameters-6)

### Log

A Log object

#### type

A namespaced identifier of the log (not a level like "debug", "error" but more like "apdu", "hw", etc...)

Type: LogType

#### data

Data associated to the log event

Type: LogData

#### context

Context data, coming for example from the caller's parent, to enable a simple tracing system

Type: TraceContext

#### id

Unique id among all logs

Type: [string](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/String)

### log

Logs something

#### Parameters

*   `type` **LogType** a namespaced identifier of the log (it is not a level like "debug", "error" but more like "apdu-in", "apdu-out", etc...)
*   `message` **[string](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/String)?** a clear message of the log associated to the type
*   `data` **LogData?**&#x20;

### trace

A simple tracer function, only expanding the existing log function

Its goal is to capture more context than a log function.
This is simple for now, but can be improved later.

#### Parameters

*   `context` **{type: LogType, message: [string](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/String)?, data: LogData?, context: TraceContext?}** Anything representing the context where the log occurred

    *   `context.type` &#x20;
    *   `context.message` &#x20;
    *   `context.data` &#x20;
    *   `context.context` &#x20;

### LocalTracer

A simple tracer class, that can be used to avoid repetition when using the `trace` function

Its goal is to capture more context than a log function.
This is simple for now, but can be improved later.

#### Parameters

*   `` &#x20;
*   `` &#x20;
*   `type`  A given type (not level) for the current local tracer ("hw", "withDevice", etc.)
*   `context`  Anything representing the context where the log occurred

#### withType

Create a new instance of the LocalTracer with an updated `type`

It does not mutate the calling instance, but returns a new LocalTracer,
following a simple builder pattern.

##### Parameters

*   `type` **LogType**&#x20;

Returns **[LocalTracer](#localtracer)**&#x20;

#### withContext

Create a new instance of the LocalTracer with a new `context`

It does not mutate the calling instance, but returns a new LocalTracer,
following a simple builder pattern.

##### Parameters

*   `context` **TraceContext?** A TraceContext, that can undefined to reset the context

Returns **[LocalTracer](#localtracer)**&#x20;

#### withUpdatedContext

Create a new instance of the LocalTracer with an updated `context`,
on which an additional context is merged with the existing one.

It does not mutate the calling instance, but returns a new LocalTracer,
following a simple builder pattern.

##### Parameters

*   `contextToAdd` **TraceContext**&#x20;

Returns **[LocalTracer](#localtracer)**&#x20;

### listen

Adds a subscribers to the emitted logs.

#### Parameters

*   `cb` **Subscriber** that is called for each future log() with the Log object

Returns **Unsubscribe** a function that can be called to unsubscribe the listener
