"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.hashOutputFull = exports.provideOutputFullChangePath = void 0;
const bip32_1 = require("./bip32");
const constants_1 = require("./constants");
function provideOutputFullChangePath(transport, path) {
    const buffer = (0, bip32_1.bip32asBuffer)(path);
    return transport.send(0xe0, 0x4a, 0xff, 0x00, buffer);
}
exports.provideOutputFullChangePath = provideOutputFullChangePath;
async function hashOutputFull(transport, outputScript, additionals = []) {
    let offset = 0;
    const p1 = Number(0x80);
    const isDecred = additionals.includes("decred");
    ///WARNING: Decred works only with one call (without chunking)
    //TODO: test without this for Decred
    if (isDecred) {
        return transport.send(0xe0, 0x4a, p1, 0x00, outputScript);
    }
    while (offset < outputScript.length) {
        const blockSize = offset + constants_1.MAX_SCRIPT_BLOCK >= outputScript.length
            ? outputScript.length - offset
            : constants_1.MAX_SCRIPT_BLOCK;
        const p1 = offset + blockSize === outputScript.length ? 0x80 : 0x00;
        const data = outputScript.slice(offset, offset + blockSize);
        await transport.send(0xe0, 0x4a, p1, 0x00, data);
        offset += blockSize;
    }
}
exports.hashOutputFull = hashOutputFull;
//# sourceMappingURL=finalizeInput.js.map