import type { Psbt } from 'bitcoinjs-lib';
import type { ECPairInterface } from 'ecpair';
import type { BIP32Interface } from 'bip32';
import type { DescriptorInstance } from './descriptors';
import { LedgerState } from './ledger';
export declare function signInputECPair({ psbt, index, ecpair }: {
    psbt: Psbt;
    index: number;
    ecpair: ECPairInterface;
}): void;
export declare function signECPair({ psbt, ecpair }: {
    psbt: Psbt;
    ecpair: ECPairInterface;
}): void;
export declare function signInputBIP32({ psbt, index, node }: {
    psbt: Psbt;
    index: number;
    node: BIP32Interface;
}): void;
export declare function signBIP32({ psbt, masterNode }: {
    psbt: Psbt;
    masterNode: BIP32Interface;
}): void;
export declare function signInputLedger({ psbt, index, descriptor, ledgerClient, ledgerState }: {
    psbt: Psbt;
    index: number;
    descriptor: DescriptorInstance;
    ledgerClient: unknown;
    ledgerState: LedgerState;
}): Promise<void>;
export declare function signLedger({ psbt, descriptors, ledgerClient, ledgerState }: {
    psbt: Psbt;
    descriptors: DescriptorInstance[];
    ledgerClient: unknown;
    ledgerState: LedgerState;
}): Promise<void>;
