"use strict";
/**
 * formatter.js
 */
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.binToPem = exports.pemToBin = void 0;
const encoder = __importStar(require("./encoder"));
const PemArmorString = {
    'public': 'PUBLIC KEY',
    'private': 'PRIVATE KEY',
    'encryptedPrivate': 'ENCRYPTED PRIVATE KEY',
    'certificate': 'CERTIFICATE',
    'certRequest': 'CERTIFICATE REQUEST'
};
/**
 * Convert PEM armored string to Uint8Array
 * @param keydataB64Pem
 * @return {Uint8Array}
 */
const pemToBin = (keydataB64Pem) => {
    const keydataB64 = dearmorPem(keydataB64Pem);
    return encoder.decodeBase64(keydataB64);
};
exports.pemToBin = pemToBin;
/**
 * Convert ArrayBuffer or TypedArray to PEM armored string with a specified type
 * @param keydata
 * @param type
 * @return {string}
 */
const binToPem = (keydata, type) => {
    const keydataB64 = encoder.encodeBase64(keydata);
    return formatAsPem(keydataB64, type);
};
exports.binToPem = binToPem;
/**
 * Armor the given Base64 string and return PEM formatted string
 * @param str
 * @param type
 * @return {string}
 */
const formatAsPem = (str, type) => {
    const typeString = PemArmorString[type];
    let finalString = `-----BEGIN ${typeString}-----\n`;
    while (str.length > 0) {
        finalString += `${str.substring(0, 64)}\n`;
        str = str.substring(64);
    }
    finalString = `${finalString}-----END ${typeString}-----`;
    return finalString;
};
/**
 * Dearmor the given PEM string and return Base64 string
 * @param str
 * @return {string}
 */
const dearmorPem = (str) => {
    // const beginRegExp = RegExp('^-----[\s]*BEGIN[^-]*KEY-----$', 'gm');
    // const endRegExp = RegExp('^-----[\s]*END[^-]*KEY-----$', 'gm');
    const beginRegExp = RegExp('^-----[\s]*BEGIN[^-]*-----$', 'gm');
    const endRegExp = RegExp('^-----[\s]*END[^-]*-----$', 'gm');
    // check if the object starts from 'begin'
    try {
        let dearmored = str.split(beginRegExp)[1].split(endRegExp)[0];
        dearmored = dearmored.replace(/\r?\n/g, '');
        return dearmored;
    }
    catch (e) {
        throw new Error('Invalid format as PEM');
    }
};
//# sourceMappingURL=formatter.js.map