const isObject = (obj) => {
    if (typeof obj === 'object' && obj !== null) {
        if (typeof Object.getPrototypeOf === 'function') {
            const prototype = Object.getPrototypeOf(obj);
            return prototype === Object.prototype || prototype === null;
        }
        return Object.prototype.toString.call(obj) === '[object Object]';
    }
    return false;
};
const mergeValuesWithPath = (target, value, [key, ...rest]) => {
    if (key === undefined) {
        return mergeValues(target, value);
    }
    else if (!isObject(target)) {
        return { [key]: mergeValuesWithPath({}, value, rest) };
    }
    else {
        return { ...target, [key]: mergeValuesWithPath(target[key], value, rest) };
    }
};
const mergeValues = (target, value) => {
    if (Array.isArray(target) && Array.isArray(value)) {
        return mergeDeepObject.options.mergeArrays
            ? Array.from(new Set(target.concat(value)))
            : value;
    }
    else if (isObject(target) && isObject(value)) {
        return mergeDeepObject(target, value);
    }
    else {
        return value;
    }
};
export const mergeDeepObject = (...objects) => objects.reduce((result, current) => {
    if (Array.isArray(current)) {
        throw new TypeError('Arguments provided to ts-deepmerge must be objects, not arrays.');
    }
    Object.keys(current).forEach(key => {
        if (['__proto__', 'constructor', 'prototype'].includes(key)) {
            return;
        }
        if (mergeDeepObject.options.dotNotation) {
            const [first, ...rest] = key.split('.');
            result[first] = mergeValuesWithPath(result[first], current[key], rest);
        }
        else {
            result[key] = mergeValues(result[key], current[key]);
        }
    });
    return result;
}, {});
const defaultOptions = {
    mergeArrays: true,
    dotNotation: false,
};
mergeDeepObject.options = defaultOptions;
mergeDeepObject.withOptions = (options, ...objects) => {
    mergeDeepObject.options = {
        ...defaultOptions,
        ...options,
    };
    const result = mergeDeepObject(...objects);
    mergeDeepObject.options = defaultOptions;
    return result;
};
//# sourceMappingURL=mergeDeepObject.js.map