import { BigNumber } from './bigNumber';
export const isApproximatelyEqual = (value1, value2, relativeTolerance) => {
    value1 = new BigNumber(value1);
    value2 = new BigNumber(value2);
    relativeTolerance = new BigNumber(relativeTolerance);
    if (value1.eq(0))
        return value1.eq(value2);
    const relativeDifference = value2.minus(value1).abs().dividedBy(value1);
    return relativeDifference.lte(relativeTolerance);
};
//# sourceMappingURL=isApproximatelyEqual.js.map