"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getLocaleSeparators = void 0;
const getLocaleSeparators = (locale) => {
    const numberFormat = new Intl.NumberFormat(locale);
    const parts = numberFormat.formatToParts(10000.1);
    const decimalSeparator = parts.find(({ type }) => type === 'decimal')?.value;
    const thousandsSeparator = parts.find(({ type }) => type === 'group')?.value;
    return { decimalSeparator, thousandsSeparator };
};
exports.getLocaleSeparators = getLocaleSeparators;
//# sourceMappingURL=getLocaleSeparators.js.map