export type UnionSubset<T, U extends T> = U;
export type RequiredKey<M, K extends keyof M> = Omit<M, K> & Required<Pick<M, K>>;
export type ObjectValues<T extends {
    [key: string]: any;
}> = T[keyof T];
export type Keys<T> = T extends any ? keyof T : never;
export type Without<T, K extends keyof T> = T extends any ? Omit<T, K> : never;
export type ConstWithOptionalFields<Const extends {
    [key: string]: any;
}, Fields extends string | number | symbol> = {
    [Key in keyof Const]: {
        [FieldKey in Fields]: Const[Key][FieldKey] extends string | number | {
            [key: string]: any;
        } | boolean ? Const[Key][FieldKey] : undefined;
    };
};
export type DeepPartial<T> = T extends () => any ? T : T extends {
    [key: string]: any;
} ? {
    [P in keyof T]?: DeepPartial<T[P]>;
} : T;
export type PrimitiveType = string | number | boolean | Date | null | undefined;
export type PartialRecord<K extends keyof any, T> = {
    [P in K]?: T;
};
export type DefinedUnionMember<T> = T extends string ? T : never;
export type FilterPropertiesByType<T, ValueFilter> = {
    [Key in keyof T as T[Key] extends ValueFilter ? Key : never]: T[Key];
};
export type FilterOutFromUnionByTypeProperty<Union, KeyName extends keyof Union, ValueToExclude extends Union[KeyName]> = Union extends {
    [K in KeyName]: infer ActualValue;
} ? ActualValue extends ValueToExclude ? never : {
    [K in KeyName]: Exclude<ActualValue, ValueToExclude>;
} & Omit<Union, KeyName> : Union;
//# sourceMappingURL=utils.d.ts.map