"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.setDeepValue = setDeepValue;
exports.getDeepValue = getDeepValue;
function setDeepValue(obj, [prop, ...path], value) {
    if (!path.length) {
        obj[prop] = value;
    }
    else {
        if (!(prop in obj))
            obj[prop] = {};
        setDeepValue(obj[prop], path, value);
    }
}
function getDeepValue(obj, [prop, ...path]) {
    if (!path.length) {
        return obj[prop];
    }
    else {
        if (!(prop in obj))
            return undefined;
        return getDeepValue(obj[prop], path);
    }
}
//# sourceMappingURL=utils.js.map