"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.littleEndianBytesToBigInt = exports.bigEndianBytesToBigInt = exports.getIvFromNonce = exports.hashOfTwo = exports.hkdf = exports.sha256 = exports.hmacSHA256 = void 0;
const tslib_1 = require("tslib");
const crypto = tslib_1.__importStar(require("crypto"));
const hmacSHA256 = (key, data) => crypto.createHmac('sha256', key).update(data).digest();
exports.hmacSHA256 = hmacSHA256;
const sha256 = (buffer) => crypto.createHash('sha256').update(buffer).digest();
exports.sha256 = sha256;
const hkdf = (chainingKey, input) => {
    const tempKey = (0, exports.hmacSHA256)(chainingKey, input);
    const output1 = (0, exports.hmacSHA256)(tempKey, Buffer.from([0x01]));
    const ctxOutput2 = crypto.createHmac('sha256', tempKey).update(output1);
    ctxOutput2.update(Buffer.from([0x02]));
    const output2 = ctxOutput2.digest();
    return [output1, output2];
};
exports.hkdf = hkdf;
const hashOfTwo = (hash1, hash2) => crypto.createHash('sha256').update(hash1).update(hash2).digest();
exports.hashOfTwo = hashOfTwo;
const getIvFromNonce = (nonce) => {
    const iv = new Uint8Array(12);
    const nonceBytes = new Uint8Array(8);
    for (let i = 0; i < 8; i++) {
        nonceBytes[7 - i] = nonce & 0xff;
        nonce = nonce >> 8;
    }
    iv.set(nonceBytes, 4);
    return Buffer.from(iv);
};
exports.getIvFromNonce = getIvFromNonce;
const bigEndianBytesToBigInt = (bytes) => {
    const result = [];
    const { length } = bytes;
    for (let i = 0; i < length; i++) {
        result.push(BigInt(bytes[i] * 256 ** (length - (1 + i))));
    }
    return result.reduce((prev, curr) => prev + curr, BigInt(0));
};
exports.bigEndianBytesToBigInt = bigEndianBytesToBigInt;
const littleEndianBytesToBigInt = (bytes) => {
    let result = 0n;
    for (let i = 0; i < bytes.length; i++) {
        result += BigInt(bytes[i]) << (8n * BigInt(i));
    }
    return result;
};
exports.littleEndianBytesToBigInt = littleEndianBytesToBigInt;
//# sourceMappingURL=tools.js.map