"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isConnectOutdated = void 0;
const versionUtils_1 = require("@trezor/utils/lib/versionUtils");
const isConnectOutdated = (settings) => {
    if (settings?.env !== 'web')
        return false;
    const version = settings.npmVersion || settings.version;
    if (!(0, versionUtils_1.isNewerOrEqual)(version, '9.2.1'))
        return 'error';
    if (!(0, versionUtils_1.isNewerOrEqual)(version, '9.5.0'))
        return 'warning';
    return false;
};
exports.isConnectOutdated = isConnectOutdated;
//# sourceMappingURL=versionCheck.js.map