"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createPopupPromiseManager = void 0;
const utils_1 = require("@trezor/utils");
const createPopupPromiseManager = () => {
    let _popupPromise;
    const ensure = () => _popupPromise ?? (_popupPromise = (0, utils_1.createDeferred)());
    const wait = () => ensure().promise;
    const resolve = () => ensure().resolve();
    const isWaiting = () => !!_popupPromise;
    const reject = (error) => {
        _popupPromise?.reject(error);
        _popupPromise = undefined;
    };
    const clear = () => {
        _popupPromise = undefined;
    };
    return { wait, isWaiting, clear, resolve, reject };
};
exports.createPopupPromiseManager = createPopupPromiseManager;
//# sourceMappingURL=popupPromiseManager.js.map