import { Static } from '@trezor/schema-utils';
import { NEM, PROTO } from '../../../constants';
export type MosaicID = Static<typeof MosaicID>;
export declare const MosaicID: import("@trezor/schema-utils").TObject<{
    namespaceId: import("@trezor/schema-utils").TString;
    name: import("@trezor/schema-utils").TString;
}>;
export type MosaicDefinition = Static<typeof MosaicDefinition>;
export declare const MosaicDefinition: import("@trezor/schema-utils").TObject<{
    levy: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
        type: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TEnum<typeof PROTO.NEMMosaicLevy>>;
        fee: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
        recipient: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        mosaicId: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
            namespaceId: import("@trezor/schema-utils").TString;
            name: import("@trezor/schema-utils").TString;
        }>>;
    }>>;
    id: import("@trezor/schema-utils").TObject<{
        namespaceId: import("@trezor/schema-utils").TString;
        name: import("@trezor/schema-utils").TString;
    }>;
    description: import("@trezor/schema-utils").TString;
    properties: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
        name: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TLiteral<"divisibility">, import("@trezor/schema-utils").TLiteral<"initialSupply">, import("@trezor/schema-utils").TLiteral<"supplyMutable">, import("@trezor/schema-utils").TLiteral<"transferable">]>;
        value: import("@trezor/schema-utils").TString;
    }>>>;
}>;
export type NEMMosaic = Static<typeof NEMMosaic>;
export declare const NEMMosaic: import("@trezor/schema-utils").TObject<{
    mosaicId: import("@trezor/schema-utils").TObject<{
        namespaceId: import("@trezor/schema-utils").TString;
        name: import("@trezor/schema-utils").TString;
    }>;
    quantity: import("@trezor/schema-utils").TNumber;
}>;
export type Modification = Static<typeof Modification>;
export declare const Modification: import("@trezor/schema-utils").TObject<{
    modificationType: import("@trezor/schema-utils").TEnum<typeof PROTO.NEMModificationType>;
    cosignatoryAccount: import("@trezor/schema-utils").TString;
}>;
export type Message = Static<typeof Message>;
export declare const Message: import("@trezor/schema-utils").TObject<{
    payload: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    type: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
    publicKey: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
}>;
export type TransactionCommon = Static<typeof TransactionCommon>;
export declare const TransactionCommon: import("@trezor/schema-utils").TObject<{
    version: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TEnum<typeof NEM.TxVersion>, import("@trezor/schema-utils").TNumber]>;
    timeStamp: import("@trezor/schema-utils").TNumber;
    fee: import("@trezor/schema-utils").TNumber;
    deadline: import("@trezor/schema-utils").TNumber;
    signer: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
}>;
export type NEMTransferTransaction = Static<typeof NEMTransferTransaction>;
export declare const NEMTransferTransaction: import("@trezor/schema-utils").TIntersect<[import("@trezor/schema-utils").TObject<{
    version: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TEnum<typeof NEM.TxVersion>, import("@trezor/schema-utils").TNumber]>;
    timeStamp: import("@trezor/schema-utils").TNumber;
    fee: import("@trezor/schema-utils").TNumber;
    deadline: import("@trezor/schema-utils").TNumber;
    signer: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
}>, import("@trezor/schema-utils").TObject<{
    type: import("@trezor/schema-utils").TLiteral<NEM.TxType.TRANSFER>;
    recipient: import("@trezor/schema-utils").TString;
    amount: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
    mosaics: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
        mosaicId: import("@trezor/schema-utils").TObject<{
            namespaceId: import("@trezor/schema-utils").TString;
            name: import("@trezor/schema-utils").TString;
        }>;
        quantity: import("@trezor/schema-utils").TNumber;
    }>>>;
    message: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
        payload: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        type: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
        publicKey: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    }>>;
}>]>;
export type NEMImportanceTransaction = Static<typeof NEMImportanceTransaction>;
export declare const NEMImportanceTransaction: import("@trezor/schema-utils").TIntersect<[import("@trezor/schema-utils").TObject<{
    version: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TEnum<typeof NEM.TxVersion>, import("@trezor/schema-utils").TNumber]>;
    timeStamp: import("@trezor/schema-utils").TNumber;
    fee: import("@trezor/schema-utils").TNumber;
    deadline: import("@trezor/schema-utils").TNumber;
    signer: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
}>, import("@trezor/schema-utils").TObject<{
    type: import("@trezor/schema-utils").TLiteral<NEM.TxType.IMPORTANCE_TRANSFER>;
    importanceTransfer: import("@trezor/schema-utils").TObject<{
        mode: import("@trezor/schema-utils").TEnum<typeof PROTO.NEMImportanceTransferMode>;
        publicKey: import("@trezor/schema-utils").TString;
    }>;
}>]>;
export type NEMAggregateModificationTransaction = Static<typeof NEMAggregateModificationTransaction>;
export declare const NEMAggregateModificationTransaction: import("@trezor/schema-utils").TIntersect<[import("@trezor/schema-utils").TObject<{
    version: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TEnum<typeof NEM.TxVersion>, import("@trezor/schema-utils").TNumber]>;
    timeStamp: import("@trezor/schema-utils").TNumber;
    fee: import("@trezor/schema-utils").TNumber;
    deadline: import("@trezor/schema-utils").TNumber;
    signer: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
}>, import("@trezor/schema-utils").TObject<{
    type: import("@trezor/schema-utils").TLiteral<NEM.TxType.AGGREGATE_MODIFICATION>;
    modifications: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
        modificationType: import("@trezor/schema-utils").TEnum<typeof PROTO.NEMModificationType>;
        cosignatoryAccount: import("@trezor/schema-utils").TString;
    }>>>;
    minCosignatories: import("@trezor/schema-utils").TObject<{
        relativeChange: import("@trezor/schema-utils").TNumber;
    }>;
}>]>;
export type NEMProvisionNamespaceTransaction = Static<typeof NEMProvisionNamespaceTransaction>;
export declare const NEMProvisionNamespaceTransaction: import("@trezor/schema-utils").TIntersect<[import("@trezor/schema-utils").TObject<{
    version: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TEnum<typeof NEM.TxVersion>, import("@trezor/schema-utils").TNumber]>;
    timeStamp: import("@trezor/schema-utils").TNumber;
    fee: import("@trezor/schema-utils").TNumber;
    deadline: import("@trezor/schema-utils").TNumber;
    signer: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
}>, import("@trezor/schema-utils").TObject<{
    type: import("@trezor/schema-utils").TLiteral<NEM.TxType.PROVISION_NAMESPACE>;
    newPart: import("@trezor/schema-utils").TString;
    parent: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    rentalFeeSink: import("@trezor/schema-utils").TString;
    rentalFee: import("@trezor/schema-utils").TNumber;
}>]>;
export type NEMMosaicCreationTransaction = Static<typeof NEMMosaicCreationTransaction>;
export declare const NEMMosaicCreationTransaction: import("@trezor/schema-utils").TIntersect<[import("@trezor/schema-utils").TObject<{
    version: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TEnum<typeof NEM.TxVersion>, import("@trezor/schema-utils").TNumber]>;
    timeStamp: import("@trezor/schema-utils").TNumber;
    fee: import("@trezor/schema-utils").TNumber;
    deadline: import("@trezor/schema-utils").TNumber;
    signer: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
}>, import("@trezor/schema-utils").TObject<{
    type: import("@trezor/schema-utils").TLiteral<NEM.TxType.MOSAIC_CREATION>;
    mosaicDefinition: import("@trezor/schema-utils").TObject<{
        levy: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
            type: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TEnum<typeof PROTO.NEMMosaicLevy>>;
            fee: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
            recipient: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            mosaicId: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
                namespaceId: import("@trezor/schema-utils").TString;
                name: import("@trezor/schema-utils").TString;
            }>>;
        }>>;
        id: import("@trezor/schema-utils").TObject<{
            namespaceId: import("@trezor/schema-utils").TString;
            name: import("@trezor/schema-utils").TString;
        }>;
        description: import("@trezor/schema-utils").TString;
        properties: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
            name: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TLiteral<"divisibility">, import("@trezor/schema-utils").TLiteral<"initialSupply">, import("@trezor/schema-utils").TLiteral<"supplyMutable">, import("@trezor/schema-utils").TLiteral<"transferable">]>;
            value: import("@trezor/schema-utils").TString;
        }>>>;
    }>;
    creationFeeSink: import("@trezor/schema-utils").TString;
    creationFee: import("@trezor/schema-utils").TNumber;
}>]>;
export type NEMSupplyChangeTransaction = Static<typeof NEMSupplyChangeTransaction>;
export declare const NEMSupplyChangeTransaction: import("@trezor/schema-utils").TIntersect<[import("@trezor/schema-utils").TObject<{
    version: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TEnum<typeof NEM.TxVersion>, import("@trezor/schema-utils").TNumber]>;
    timeStamp: import("@trezor/schema-utils").TNumber;
    fee: import("@trezor/schema-utils").TNumber;
    deadline: import("@trezor/schema-utils").TNumber;
    signer: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
}>, import("@trezor/schema-utils").TObject<{
    type: import("@trezor/schema-utils").TLiteral<NEM.TxType.SUPPLY_CHANGE>;
    mosaicId: import("@trezor/schema-utils").TObject<{
        namespaceId: import("@trezor/schema-utils").TString;
        name: import("@trezor/schema-utils").TString;
    }>;
    supplyType: import("@trezor/schema-utils").TEnum<typeof PROTO.NEMSupplyChangeType>;
    delta: import("@trezor/schema-utils").TNumber;
}>]>;
export type NEMRegularTransaction = Static<typeof NEMRegularTransaction>;
export declare const NEMRegularTransaction: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TIntersect<[import("@trezor/schema-utils").TObject<{
    version: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TEnum<typeof NEM.TxVersion>, import("@trezor/schema-utils").TNumber]>;
    timeStamp: import("@trezor/schema-utils").TNumber;
    fee: import("@trezor/schema-utils").TNumber;
    deadline: import("@trezor/schema-utils").TNumber;
    signer: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
}>, import("@trezor/schema-utils").TObject<{
    type: import("@trezor/schema-utils").TLiteral<NEM.TxType.TRANSFER>;
    recipient: import("@trezor/schema-utils").TString;
    amount: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
    mosaics: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
        mosaicId: import("@trezor/schema-utils").TObject<{
            namespaceId: import("@trezor/schema-utils").TString;
            name: import("@trezor/schema-utils").TString;
        }>;
        quantity: import("@trezor/schema-utils").TNumber;
    }>>>;
    message: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
        payload: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        type: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
        publicKey: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    }>>;
}>]>, import("@trezor/schema-utils").TIntersect<[import("@trezor/schema-utils").TObject<{
    version: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TEnum<typeof NEM.TxVersion>, import("@trezor/schema-utils").TNumber]>;
    timeStamp: import("@trezor/schema-utils").TNumber;
    fee: import("@trezor/schema-utils").TNumber;
    deadline: import("@trezor/schema-utils").TNumber;
    signer: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
}>, import("@trezor/schema-utils").TObject<{
    type: import("@trezor/schema-utils").TLiteral<NEM.TxType.IMPORTANCE_TRANSFER>;
    importanceTransfer: import("@trezor/schema-utils").TObject<{
        mode: import("@trezor/schema-utils").TEnum<typeof PROTO.NEMImportanceTransferMode>;
        publicKey: import("@trezor/schema-utils").TString;
    }>;
}>]>, import("@trezor/schema-utils").TIntersect<[import("@trezor/schema-utils").TObject<{
    version: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TEnum<typeof NEM.TxVersion>, import("@trezor/schema-utils").TNumber]>;
    timeStamp: import("@trezor/schema-utils").TNumber;
    fee: import("@trezor/schema-utils").TNumber;
    deadline: import("@trezor/schema-utils").TNumber;
    signer: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
}>, import("@trezor/schema-utils").TObject<{
    type: import("@trezor/schema-utils").TLiteral<NEM.TxType.AGGREGATE_MODIFICATION>;
    modifications: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
        modificationType: import("@trezor/schema-utils").TEnum<typeof PROTO.NEMModificationType>;
        cosignatoryAccount: import("@trezor/schema-utils").TString;
    }>>>;
    minCosignatories: import("@trezor/schema-utils").TObject<{
        relativeChange: import("@trezor/schema-utils").TNumber;
    }>;
}>]>, import("@trezor/schema-utils").TIntersect<[import("@trezor/schema-utils").TObject<{
    version: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TEnum<typeof NEM.TxVersion>, import("@trezor/schema-utils").TNumber]>;
    timeStamp: import("@trezor/schema-utils").TNumber;
    fee: import("@trezor/schema-utils").TNumber;
    deadline: import("@trezor/schema-utils").TNumber;
    signer: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
}>, import("@trezor/schema-utils").TObject<{
    type: import("@trezor/schema-utils").TLiteral<NEM.TxType.PROVISION_NAMESPACE>;
    newPart: import("@trezor/schema-utils").TString;
    parent: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    rentalFeeSink: import("@trezor/schema-utils").TString;
    rentalFee: import("@trezor/schema-utils").TNumber;
}>]>, import("@trezor/schema-utils").TIntersect<[import("@trezor/schema-utils").TObject<{
    version: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TEnum<typeof NEM.TxVersion>, import("@trezor/schema-utils").TNumber]>;
    timeStamp: import("@trezor/schema-utils").TNumber;
    fee: import("@trezor/schema-utils").TNumber;
    deadline: import("@trezor/schema-utils").TNumber;
    signer: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
}>, import("@trezor/schema-utils").TObject<{
    type: import("@trezor/schema-utils").TLiteral<NEM.TxType.MOSAIC_CREATION>;
    mosaicDefinition: import("@trezor/schema-utils").TObject<{
        levy: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
            type: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TEnum<typeof PROTO.NEMMosaicLevy>>;
            fee: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
            recipient: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            mosaicId: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
                namespaceId: import("@trezor/schema-utils").TString;
                name: import("@trezor/schema-utils").TString;
            }>>;
        }>>;
        id: import("@trezor/schema-utils").TObject<{
            namespaceId: import("@trezor/schema-utils").TString;
            name: import("@trezor/schema-utils").TString;
        }>;
        description: import("@trezor/schema-utils").TString;
        properties: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
            name: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TLiteral<"divisibility">, import("@trezor/schema-utils").TLiteral<"initialSupply">, import("@trezor/schema-utils").TLiteral<"supplyMutable">, import("@trezor/schema-utils").TLiteral<"transferable">]>;
            value: import("@trezor/schema-utils").TString;
        }>>>;
    }>;
    creationFeeSink: import("@trezor/schema-utils").TString;
    creationFee: import("@trezor/schema-utils").TNumber;
}>]>, import("@trezor/schema-utils").TIntersect<[import("@trezor/schema-utils").TObject<{
    version: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TEnum<typeof NEM.TxVersion>, import("@trezor/schema-utils").TNumber]>;
    timeStamp: import("@trezor/schema-utils").TNumber;
    fee: import("@trezor/schema-utils").TNumber;
    deadline: import("@trezor/schema-utils").TNumber;
    signer: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
}>, import("@trezor/schema-utils").TObject<{
    type: import("@trezor/schema-utils").TLiteral<NEM.TxType.SUPPLY_CHANGE>;
    mosaicId: import("@trezor/schema-utils").TObject<{
        namespaceId: import("@trezor/schema-utils").TString;
        name: import("@trezor/schema-utils").TString;
    }>;
    supplyType: import("@trezor/schema-utils").TEnum<typeof PROTO.NEMSupplyChangeType>;
    delta: import("@trezor/schema-utils").TNumber;
}>]>]>;
export type NEMMultisigTransaction = Static<typeof NEMMultisigTransaction>;
export declare const NEMMultisigTransaction: import("@trezor/schema-utils").TIntersect<[import("@trezor/schema-utils").TObject<{
    version: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TEnum<typeof NEM.TxVersion>, import("@trezor/schema-utils").TNumber]>;
    timeStamp: import("@trezor/schema-utils").TNumber;
    fee: import("@trezor/schema-utils").TNumber;
    deadline: import("@trezor/schema-utils").TNumber;
    signer: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
}>, import("@trezor/schema-utils").TObject<{
    type: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TLiteral<NEM.TxType.COSIGNING>, import("@trezor/schema-utils").TLiteral<NEM.TxType.MULTISIG>, import("@trezor/schema-utils").TLiteral<NEM.TxType.MULTISIG_SIGNATURE>]>;
    otherTrans: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TIntersect<[import("@trezor/schema-utils").TObject<{
        version: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TEnum<typeof NEM.TxVersion>, import("@trezor/schema-utils").TNumber]>;
        timeStamp: import("@trezor/schema-utils").TNumber;
        fee: import("@trezor/schema-utils").TNumber;
        deadline: import("@trezor/schema-utils").TNumber;
        signer: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    }>, import("@trezor/schema-utils").TObject<{
        type: import("@trezor/schema-utils").TLiteral<NEM.TxType.TRANSFER>;
        recipient: import("@trezor/schema-utils").TString;
        amount: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
        mosaics: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
            mosaicId: import("@trezor/schema-utils").TObject<{
                namespaceId: import("@trezor/schema-utils").TString;
                name: import("@trezor/schema-utils").TString;
            }>;
            quantity: import("@trezor/schema-utils").TNumber;
        }>>>;
        message: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
            payload: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            type: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
            publicKey: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        }>>;
    }>]>, import("@trezor/schema-utils").TIntersect<[import("@trezor/schema-utils").TObject<{
        version: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TEnum<typeof NEM.TxVersion>, import("@trezor/schema-utils").TNumber]>;
        timeStamp: import("@trezor/schema-utils").TNumber;
        fee: import("@trezor/schema-utils").TNumber;
        deadline: import("@trezor/schema-utils").TNumber;
        signer: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    }>, import("@trezor/schema-utils").TObject<{
        type: import("@trezor/schema-utils").TLiteral<NEM.TxType.IMPORTANCE_TRANSFER>;
        importanceTransfer: import("@trezor/schema-utils").TObject<{
            mode: import("@trezor/schema-utils").TEnum<typeof PROTO.NEMImportanceTransferMode>;
            publicKey: import("@trezor/schema-utils").TString;
        }>;
    }>]>, import("@trezor/schema-utils").TIntersect<[import("@trezor/schema-utils").TObject<{
        version: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TEnum<typeof NEM.TxVersion>, import("@trezor/schema-utils").TNumber]>;
        timeStamp: import("@trezor/schema-utils").TNumber;
        fee: import("@trezor/schema-utils").TNumber;
        deadline: import("@trezor/schema-utils").TNumber;
        signer: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    }>, import("@trezor/schema-utils").TObject<{
        type: import("@trezor/schema-utils").TLiteral<NEM.TxType.AGGREGATE_MODIFICATION>;
        modifications: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
            modificationType: import("@trezor/schema-utils").TEnum<typeof PROTO.NEMModificationType>;
            cosignatoryAccount: import("@trezor/schema-utils").TString;
        }>>>;
        minCosignatories: import("@trezor/schema-utils").TObject<{
            relativeChange: import("@trezor/schema-utils").TNumber;
        }>;
    }>]>, import("@trezor/schema-utils").TIntersect<[import("@trezor/schema-utils").TObject<{
        version: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TEnum<typeof NEM.TxVersion>, import("@trezor/schema-utils").TNumber]>;
        timeStamp: import("@trezor/schema-utils").TNumber;
        fee: import("@trezor/schema-utils").TNumber;
        deadline: import("@trezor/schema-utils").TNumber;
        signer: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    }>, import("@trezor/schema-utils").TObject<{
        type: import("@trezor/schema-utils").TLiteral<NEM.TxType.PROVISION_NAMESPACE>;
        newPart: import("@trezor/schema-utils").TString;
        parent: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        rentalFeeSink: import("@trezor/schema-utils").TString;
        rentalFee: import("@trezor/schema-utils").TNumber;
    }>]>, import("@trezor/schema-utils").TIntersect<[import("@trezor/schema-utils").TObject<{
        version: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TEnum<typeof NEM.TxVersion>, import("@trezor/schema-utils").TNumber]>;
        timeStamp: import("@trezor/schema-utils").TNumber;
        fee: import("@trezor/schema-utils").TNumber;
        deadline: import("@trezor/schema-utils").TNumber;
        signer: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    }>, import("@trezor/schema-utils").TObject<{
        type: import("@trezor/schema-utils").TLiteral<NEM.TxType.MOSAIC_CREATION>;
        mosaicDefinition: import("@trezor/schema-utils").TObject<{
            levy: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
                type: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TEnum<typeof PROTO.NEMMosaicLevy>>;
                fee: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
                recipient: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                mosaicId: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
                    namespaceId: import("@trezor/schema-utils").TString;
                    name: import("@trezor/schema-utils").TString;
                }>>;
            }>>;
            id: import("@trezor/schema-utils").TObject<{
                namespaceId: import("@trezor/schema-utils").TString;
                name: import("@trezor/schema-utils").TString;
            }>;
            description: import("@trezor/schema-utils").TString;
            properties: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                name: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TLiteral<"divisibility">, import("@trezor/schema-utils").TLiteral<"initialSupply">, import("@trezor/schema-utils").TLiteral<"supplyMutable">, import("@trezor/schema-utils").TLiteral<"transferable">]>;
                value: import("@trezor/schema-utils").TString;
            }>>>;
        }>;
        creationFeeSink: import("@trezor/schema-utils").TString;
        creationFee: import("@trezor/schema-utils").TNumber;
    }>]>, import("@trezor/schema-utils").TIntersect<[import("@trezor/schema-utils").TObject<{
        version: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TEnum<typeof NEM.TxVersion>, import("@trezor/schema-utils").TNumber]>;
        timeStamp: import("@trezor/schema-utils").TNumber;
        fee: import("@trezor/schema-utils").TNumber;
        deadline: import("@trezor/schema-utils").TNumber;
        signer: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    }>, import("@trezor/schema-utils").TObject<{
        type: import("@trezor/schema-utils").TLiteral<NEM.TxType.SUPPLY_CHANGE>;
        mosaicId: import("@trezor/schema-utils").TObject<{
            namespaceId: import("@trezor/schema-utils").TString;
            name: import("@trezor/schema-utils").TString;
        }>;
        supplyType: import("@trezor/schema-utils").TEnum<typeof PROTO.NEMSupplyChangeType>;
        delta: import("@trezor/schema-utils").TNumber;
    }>]>]>;
}>]>;
export type NEMTransaction = Static<typeof NEMTransaction>;
export declare const NEMTransaction: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TIntersect<[import("@trezor/schema-utils").TObject<{
    version: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TEnum<typeof NEM.TxVersion>, import("@trezor/schema-utils").TNumber]>;
    timeStamp: import("@trezor/schema-utils").TNumber;
    fee: import("@trezor/schema-utils").TNumber;
    deadline: import("@trezor/schema-utils").TNumber;
    signer: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
}>, import("@trezor/schema-utils").TObject<{
    type: import("@trezor/schema-utils").TLiteral<NEM.TxType.TRANSFER>;
    recipient: import("@trezor/schema-utils").TString;
    amount: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
    mosaics: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
        mosaicId: import("@trezor/schema-utils").TObject<{
            namespaceId: import("@trezor/schema-utils").TString;
            name: import("@trezor/schema-utils").TString;
        }>;
        quantity: import("@trezor/schema-utils").TNumber;
    }>>>;
    message: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
        payload: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        type: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
        publicKey: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    }>>;
}>]>, import("@trezor/schema-utils").TIntersect<[import("@trezor/schema-utils").TObject<{
    version: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TEnum<typeof NEM.TxVersion>, import("@trezor/schema-utils").TNumber]>;
    timeStamp: import("@trezor/schema-utils").TNumber;
    fee: import("@trezor/schema-utils").TNumber;
    deadline: import("@trezor/schema-utils").TNumber;
    signer: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
}>, import("@trezor/schema-utils").TObject<{
    type: import("@trezor/schema-utils").TLiteral<NEM.TxType.IMPORTANCE_TRANSFER>;
    importanceTransfer: import("@trezor/schema-utils").TObject<{
        mode: import("@trezor/schema-utils").TEnum<typeof PROTO.NEMImportanceTransferMode>;
        publicKey: import("@trezor/schema-utils").TString;
    }>;
}>]>, import("@trezor/schema-utils").TIntersect<[import("@trezor/schema-utils").TObject<{
    version: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TEnum<typeof NEM.TxVersion>, import("@trezor/schema-utils").TNumber]>;
    timeStamp: import("@trezor/schema-utils").TNumber;
    fee: import("@trezor/schema-utils").TNumber;
    deadline: import("@trezor/schema-utils").TNumber;
    signer: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
}>, import("@trezor/schema-utils").TObject<{
    type: import("@trezor/schema-utils").TLiteral<NEM.TxType.AGGREGATE_MODIFICATION>;
    modifications: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
        modificationType: import("@trezor/schema-utils").TEnum<typeof PROTO.NEMModificationType>;
        cosignatoryAccount: import("@trezor/schema-utils").TString;
    }>>>;
    minCosignatories: import("@trezor/schema-utils").TObject<{
        relativeChange: import("@trezor/schema-utils").TNumber;
    }>;
}>]>, import("@trezor/schema-utils").TIntersect<[import("@trezor/schema-utils").TObject<{
    version: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TEnum<typeof NEM.TxVersion>, import("@trezor/schema-utils").TNumber]>;
    timeStamp: import("@trezor/schema-utils").TNumber;
    fee: import("@trezor/schema-utils").TNumber;
    deadline: import("@trezor/schema-utils").TNumber;
    signer: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
}>, import("@trezor/schema-utils").TObject<{
    type: import("@trezor/schema-utils").TLiteral<NEM.TxType.PROVISION_NAMESPACE>;
    newPart: import("@trezor/schema-utils").TString;
    parent: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    rentalFeeSink: import("@trezor/schema-utils").TString;
    rentalFee: import("@trezor/schema-utils").TNumber;
}>]>, import("@trezor/schema-utils").TIntersect<[import("@trezor/schema-utils").TObject<{
    version: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TEnum<typeof NEM.TxVersion>, import("@trezor/schema-utils").TNumber]>;
    timeStamp: import("@trezor/schema-utils").TNumber;
    fee: import("@trezor/schema-utils").TNumber;
    deadline: import("@trezor/schema-utils").TNumber;
    signer: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
}>, import("@trezor/schema-utils").TObject<{
    type: import("@trezor/schema-utils").TLiteral<NEM.TxType.MOSAIC_CREATION>;
    mosaicDefinition: import("@trezor/schema-utils").TObject<{
        levy: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
            type: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TEnum<typeof PROTO.NEMMosaicLevy>>;
            fee: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
            recipient: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            mosaicId: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
                namespaceId: import("@trezor/schema-utils").TString;
                name: import("@trezor/schema-utils").TString;
            }>>;
        }>>;
        id: import("@trezor/schema-utils").TObject<{
            namespaceId: import("@trezor/schema-utils").TString;
            name: import("@trezor/schema-utils").TString;
        }>;
        description: import("@trezor/schema-utils").TString;
        properties: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
            name: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TLiteral<"divisibility">, import("@trezor/schema-utils").TLiteral<"initialSupply">, import("@trezor/schema-utils").TLiteral<"supplyMutable">, import("@trezor/schema-utils").TLiteral<"transferable">]>;
            value: import("@trezor/schema-utils").TString;
        }>>>;
    }>;
    creationFeeSink: import("@trezor/schema-utils").TString;
    creationFee: import("@trezor/schema-utils").TNumber;
}>]>, import("@trezor/schema-utils").TIntersect<[import("@trezor/schema-utils").TObject<{
    version: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TEnum<typeof NEM.TxVersion>, import("@trezor/schema-utils").TNumber]>;
    timeStamp: import("@trezor/schema-utils").TNumber;
    fee: import("@trezor/schema-utils").TNumber;
    deadline: import("@trezor/schema-utils").TNumber;
    signer: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
}>, import("@trezor/schema-utils").TObject<{
    type: import("@trezor/schema-utils").TLiteral<NEM.TxType.SUPPLY_CHANGE>;
    mosaicId: import("@trezor/schema-utils").TObject<{
        namespaceId: import("@trezor/schema-utils").TString;
        name: import("@trezor/schema-utils").TString;
    }>;
    supplyType: import("@trezor/schema-utils").TEnum<typeof PROTO.NEMSupplyChangeType>;
    delta: import("@trezor/schema-utils").TNumber;
}>]>]>, import("@trezor/schema-utils").TIntersect<[import("@trezor/schema-utils").TObject<{
    version: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TEnum<typeof NEM.TxVersion>, import("@trezor/schema-utils").TNumber]>;
    timeStamp: import("@trezor/schema-utils").TNumber;
    fee: import("@trezor/schema-utils").TNumber;
    deadline: import("@trezor/schema-utils").TNumber;
    signer: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
}>, import("@trezor/schema-utils").TObject<{
    type: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TLiteral<NEM.TxType.COSIGNING>, import("@trezor/schema-utils").TLiteral<NEM.TxType.MULTISIG>, import("@trezor/schema-utils").TLiteral<NEM.TxType.MULTISIG_SIGNATURE>]>;
    otherTrans: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TIntersect<[import("@trezor/schema-utils").TObject<{
        version: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TEnum<typeof NEM.TxVersion>, import("@trezor/schema-utils").TNumber]>;
        timeStamp: import("@trezor/schema-utils").TNumber;
        fee: import("@trezor/schema-utils").TNumber;
        deadline: import("@trezor/schema-utils").TNumber;
        signer: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    }>, import("@trezor/schema-utils").TObject<{
        type: import("@trezor/schema-utils").TLiteral<NEM.TxType.TRANSFER>;
        recipient: import("@trezor/schema-utils").TString;
        amount: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
        mosaics: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
            mosaicId: import("@trezor/schema-utils").TObject<{
                namespaceId: import("@trezor/schema-utils").TString;
                name: import("@trezor/schema-utils").TString;
            }>;
            quantity: import("@trezor/schema-utils").TNumber;
        }>>>;
        message: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
            payload: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            type: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
            publicKey: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        }>>;
    }>]>, import("@trezor/schema-utils").TIntersect<[import("@trezor/schema-utils").TObject<{
        version: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TEnum<typeof NEM.TxVersion>, import("@trezor/schema-utils").TNumber]>;
        timeStamp: import("@trezor/schema-utils").TNumber;
        fee: import("@trezor/schema-utils").TNumber;
        deadline: import("@trezor/schema-utils").TNumber;
        signer: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    }>, import("@trezor/schema-utils").TObject<{
        type: import("@trezor/schema-utils").TLiteral<NEM.TxType.IMPORTANCE_TRANSFER>;
        importanceTransfer: import("@trezor/schema-utils").TObject<{
            mode: import("@trezor/schema-utils").TEnum<typeof PROTO.NEMImportanceTransferMode>;
            publicKey: import("@trezor/schema-utils").TString;
        }>;
    }>]>, import("@trezor/schema-utils").TIntersect<[import("@trezor/schema-utils").TObject<{
        version: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TEnum<typeof NEM.TxVersion>, import("@trezor/schema-utils").TNumber]>;
        timeStamp: import("@trezor/schema-utils").TNumber;
        fee: import("@trezor/schema-utils").TNumber;
        deadline: import("@trezor/schema-utils").TNumber;
        signer: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    }>, import("@trezor/schema-utils").TObject<{
        type: import("@trezor/schema-utils").TLiteral<NEM.TxType.AGGREGATE_MODIFICATION>;
        modifications: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
            modificationType: import("@trezor/schema-utils").TEnum<typeof PROTO.NEMModificationType>;
            cosignatoryAccount: import("@trezor/schema-utils").TString;
        }>>>;
        minCosignatories: import("@trezor/schema-utils").TObject<{
            relativeChange: import("@trezor/schema-utils").TNumber;
        }>;
    }>]>, import("@trezor/schema-utils").TIntersect<[import("@trezor/schema-utils").TObject<{
        version: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TEnum<typeof NEM.TxVersion>, import("@trezor/schema-utils").TNumber]>;
        timeStamp: import("@trezor/schema-utils").TNumber;
        fee: import("@trezor/schema-utils").TNumber;
        deadline: import("@trezor/schema-utils").TNumber;
        signer: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    }>, import("@trezor/schema-utils").TObject<{
        type: import("@trezor/schema-utils").TLiteral<NEM.TxType.PROVISION_NAMESPACE>;
        newPart: import("@trezor/schema-utils").TString;
        parent: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        rentalFeeSink: import("@trezor/schema-utils").TString;
        rentalFee: import("@trezor/schema-utils").TNumber;
    }>]>, import("@trezor/schema-utils").TIntersect<[import("@trezor/schema-utils").TObject<{
        version: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TEnum<typeof NEM.TxVersion>, import("@trezor/schema-utils").TNumber]>;
        timeStamp: import("@trezor/schema-utils").TNumber;
        fee: import("@trezor/schema-utils").TNumber;
        deadline: import("@trezor/schema-utils").TNumber;
        signer: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    }>, import("@trezor/schema-utils").TObject<{
        type: import("@trezor/schema-utils").TLiteral<NEM.TxType.MOSAIC_CREATION>;
        mosaicDefinition: import("@trezor/schema-utils").TObject<{
            levy: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
                type: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TEnum<typeof PROTO.NEMMosaicLevy>>;
                fee: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
                recipient: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                mosaicId: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
                    namespaceId: import("@trezor/schema-utils").TString;
                    name: import("@trezor/schema-utils").TString;
                }>>;
            }>>;
            id: import("@trezor/schema-utils").TObject<{
                namespaceId: import("@trezor/schema-utils").TString;
                name: import("@trezor/schema-utils").TString;
            }>;
            description: import("@trezor/schema-utils").TString;
            properties: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                name: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TLiteral<"divisibility">, import("@trezor/schema-utils").TLiteral<"initialSupply">, import("@trezor/schema-utils").TLiteral<"supplyMutable">, import("@trezor/schema-utils").TLiteral<"transferable">]>;
                value: import("@trezor/schema-utils").TString;
            }>>>;
        }>;
        creationFeeSink: import("@trezor/schema-utils").TString;
        creationFee: import("@trezor/schema-utils").TNumber;
    }>]>, import("@trezor/schema-utils").TIntersect<[import("@trezor/schema-utils").TObject<{
        version: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TEnum<typeof NEM.TxVersion>, import("@trezor/schema-utils").TNumber]>;
        timeStamp: import("@trezor/schema-utils").TNumber;
        fee: import("@trezor/schema-utils").TNumber;
        deadline: import("@trezor/schema-utils").TNumber;
        signer: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    }>, import("@trezor/schema-utils").TObject<{
        type: import("@trezor/schema-utils").TLiteral<NEM.TxType.SUPPLY_CHANGE>;
        mosaicId: import("@trezor/schema-utils").TObject<{
            namespaceId: import("@trezor/schema-utils").TString;
            name: import("@trezor/schema-utils").TString;
        }>;
        supplyType: import("@trezor/schema-utils").TEnum<typeof PROTO.NEMSupplyChangeType>;
        delta: import("@trezor/schema-utils").TNumber;
    }>]>]>;
}>]>]>;
export type NEMSignTransaction = Static<typeof NEMSignTransaction>;
export declare const NEMSignTransaction: import("@trezor/schema-utils").TObject<{
    path: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TString, import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>]>;
    transaction: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TIntersect<[import("@trezor/schema-utils").TObject<{
        version: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TEnum<typeof NEM.TxVersion>, import("@trezor/schema-utils").TNumber]>;
        timeStamp: import("@trezor/schema-utils").TNumber;
        fee: import("@trezor/schema-utils").TNumber;
        deadline: import("@trezor/schema-utils").TNumber;
        signer: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    }>, import("@trezor/schema-utils").TObject<{
        type: import("@trezor/schema-utils").TLiteral<NEM.TxType.TRANSFER>;
        recipient: import("@trezor/schema-utils").TString;
        amount: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
        mosaics: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
            mosaicId: import("@trezor/schema-utils").TObject<{
                namespaceId: import("@trezor/schema-utils").TString;
                name: import("@trezor/schema-utils").TString;
            }>;
            quantity: import("@trezor/schema-utils").TNumber;
        }>>>;
        message: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
            payload: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            type: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
            publicKey: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        }>>;
    }>]>, import("@trezor/schema-utils").TIntersect<[import("@trezor/schema-utils").TObject<{
        version: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TEnum<typeof NEM.TxVersion>, import("@trezor/schema-utils").TNumber]>;
        timeStamp: import("@trezor/schema-utils").TNumber;
        fee: import("@trezor/schema-utils").TNumber;
        deadline: import("@trezor/schema-utils").TNumber;
        signer: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    }>, import("@trezor/schema-utils").TObject<{
        type: import("@trezor/schema-utils").TLiteral<NEM.TxType.IMPORTANCE_TRANSFER>;
        importanceTransfer: import("@trezor/schema-utils").TObject<{
            mode: import("@trezor/schema-utils").TEnum<typeof PROTO.NEMImportanceTransferMode>;
            publicKey: import("@trezor/schema-utils").TString;
        }>;
    }>]>, import("@trezor/schema-utils").TIntersect<[import("@trezor/schema-utils").TObject<{
        version: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TEnum<typeof NEM.TxVersion>, import("@trezor/schema-utils").TNumber]>;
        timeStamp: import("@trezor/schema-utils").TNumber;
        fee: import("@trezor/schema-utils").TNumber;
        deadline: import("@trezor/schema-utils").TNumber;
        signer: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    }>, import("@trezor/schema-utils").TObject<{
        type: import("@trezor/schema-utils").TLiteral<NEM.TxType.AGGREGATE_MODIFICATION>;
        modifications: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
            modificationType: import("@trezor/schema-utils").TEnum<typeof PROTO.NEMModificationType>;
            cosignatoryAccount: import("@trezor/schema-utils").TString;
        }>>>;
        minCosignatories: import("@trezor/schema-utils").TObject<{
            relativeChange: import("@trezor/schema-utils").TNumber;
        }>;
    }>]>, import("@trezor/schema-utils").TIntersect<[import("@trezor/schema-utils").TObject<{
        version: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TEnum<typeof NEM.TxVersion>, import("@trezor/schema-utils").TNumber]>;
        timeStamp: import("@trezor/schema-utils").TNumber;
        fee: import("@trezor/schema-utils").TNumber;
        deadline: import("@trezor/schema-utils").TNumber;
        signer: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    }>, import("@trezor/schema-utils").TObject<{
        type: import("@trezor/schema-utils").TLiteral<NEM.TxType.PROVISION_NAMESPACE>;
        newPart: import("@trezor/schema-utils").TString;
        parent: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        rentalFeeSink: import("@trezor/schema-utils").TString;
        rentalFee: import("@trezor/schema-utils").TNumber;
    }>]>, import("@trezor/schema-utils").TIntersect<[import("@trezor/schema-utils").TObject<{
        version: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TEnum<typeof NEM.TxVersion>, import("@trezor/schema-utils").TNumber]>;
        timeStamp: import("@trezor/schema-utils").TNumber;
        fee: import("@trezor/schema-utils").TNumber;
        deadline: import("@trezor/schema-utils").TNumber;
        signer: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    }>, import("@trezor/schema-utils").TObject<{
        type: import("@trezor/schema-utils").TLiteral<NEM.TxType.MOSAIC_CREATION>;
        mosaicDefinition: import("@trezor/schema-utils").TObject<{
            levy: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
                type: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TEnum<typeof PROTO.NEMMosaicLevy>>;
                fee: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
                recipient: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                mosaicId: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
                    namespaceId: import("@trezor/schema-utils").TString;
                    name: import("@trezor/schema-utils").TString;
                }>>;
            }>>;
            id: import("@trezor/schema-utils").TObject<{
                namespaceId: import("@trezor/schema-utils").TString;
                name: import("@trezor/schema-utils").TString;
            }>;
            description: import("@trezor/schema-utils").TString;
            properties: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                name: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TLiteral<"divisibility">, import("@trezor/schema-utils").TLiteral<"initialSupply">, import("@trezor/schema-utils").TLiteral<"supplyMutable">, import("@trezor/schema-utils").TLiteral<"transferable">]>;
                value: import("@trezor/schema-utils").TString;
            }>>>;
        }>;
        creationFeeSink: import("@trezor/schema-utils").TString;
        creationFee: import("@trezor/schema-utils").TNumber;
    }>]>, import("@trezor/schema-utils").TIntersect<[import("@trezor/schema-utils").TObject<{
        version: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TEnum<typeof NEM.TxVersion>, import("@trezor/schema-utils").TNumber]>;
        timeStamp: import("@trezor/schema-utils").TNumber;
        fee: import("@trezor/schema-utils").TNumber;
        deadline: import("@trezor/schema-utils").TNumber;
        signer: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    }>, import("@trezor/schema-utils").TObject<{
        type: import("@trezor/schema-utils").TLiteral<NEM.TxType.SUPPLY_CHANGE>;
        mosaicId: import("@trezor/schema-utils").TObject<{
            namespaceId: import("@trezor/schema-utils").TString;
            name: import("@trezor/schema-utils").TString;
        }>;
        supplyType: import("@trezor/schema-utils").TEnum<typeof PROTO.NEMSupplyChangeType>;
        delta: import("@trezor/schema-utils").TNumber;
    }>]>]>, import("@trezor/schema-utils").TIntersect<[import("@trezor/schema-utils").TObject<{
        version: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TEnum<typeof NEM.TxVersion>, import("@trezor/schema-utils").TNumber]>;
        timeStamp: import("@trezor/schema-utils").TNumber;
        fee: import("@trezor/schema-utils").TNumber;
        deadline: import("@trezor/schema-utils").TNumber;
        signer: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    }>, import("@trezor/schema-utils").TObject<{
        type: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TLiteral<NEM.TxType.COSIGNING>, import("@trezor/schema-utils").TLiteral<NEM.TxType.MULTISIG>, import("@trezor/schema-utils").TLiteral<NEM.TxType.MULTISIG_SIGNATURE>]>;
        otherTrans: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TIntersect<[import("@trezor/schema-utils").TObject<{
            version: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TEnum<typeof NEM.TxVersion>, import("@trezor/schema-utils").TNumber]>;
            timeStamp: import("@trezor/schema-utils").TNumber;
            fee: import("@trezor/schema-utils").TNumber;
            deadline: import("@trezor/schema-utils").TNumber;
            signer: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        }>, import("@trezor/schema-utils").TObject<{
            type: import("@trezor/schema-utils").TLiteral<NEM.TxType.TRANSFER>;
            recipient: import("@trezor/schema-utils").TString;
            amount: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
            mosaics: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                mosaicId: import("@trezor/schema-utils").TObject<{
                    namespaceId: import("@trezor/schema-utils").TString;
                    name: import("@trezor/schema-utils").TString;
                }>;
                quantity: import("@trezor/schema-utils").TNumber;
            }>>>;
            message: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
                payload: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                type: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
                publicKey: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            }>>;
        }>]>, import("@trezor/schema-utils").TIntersect<[import("@trezor/schema-utils").TObject<{
            version: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TEnum<typeof NEM.TxVersion>, import("@trezor/schema-utils").TNumber]>;
            timeStamp: import("@trezor/schema-utils").TNumber;
            fee: import("@trezor/schema-utils").TNumber;
            deadline: import("@trezor/schema-utils").TNumber;
            signer: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        }>, import("@trezor/schema-utils").TObject<{
            type: import("@trezor/schema-utils").TLiteral<NEM.TxType.IMPORTANCE_TRANSFER>;
            importanceTransfer: import("@trezor/schema-utils").TObject<{
                mode: import("@trezor/schema-utils").TEnum<typeof PROTO.NEMImportanceTransferMode>;
                publicKey: import("@trezor/schema-utils").TString;
            }>;
        }>]>, import("@trezor/schema-utils").TIntersect<[import("@trezor/schema-utils").TObject<{
            version: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TEnum<typeof NEM.TxVersion>, import("@trezor/schema-utils").TNumber]>;
            timeStamp: import("@trezor/schema-utils").TNumber;
            fee: import("@trezor/schema-utils").TNumber;
            deadline: import("@trezor/schema-utils").TNumber;
            signer: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        }>, import("@trezor/schema-utils").TObject<{
            type: import("@trezor/schema-utils").TLiteral<NEM.TxType.AGGREGATE_MODIFICATION>;
            modifications: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                modificationType: import("@trezor/schema-utils").TEnum<typeof PROTO.NEMModificationType>;
                cosignatoryAccount: import("@trezor/schema-utils").TString;
            }>>>;
            minCosignatories: import("@trezor/schema-utils").TObject<{
                relativeChange: import("@trezor/schema-utils").TNumber;
            }>;
        }>]>, import("@trezor/schema-utils").TIntersect<[import("@trezor/schema-utils").TObject<{
            version: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TEnum<typeof NEM.TxVersion>, import("@trezor/schema-utils").TNumber]>;
            timeStamp: import("@trezor/schema-utils").TNumber;
            fee: import("@trezor/schema-utils").TNumber;
            deadline: import("@trezor/schema-utils").TNumber;
            signer: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        }>, import("@trezor/schema-utils").TObject<{
            type: import("@trezor/schema-utils").TLiteral<NEM.TxType.PROVISION_NAMESPACE>;
            newPart: import("@trezor/schema-utils").TString;
            parent: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            rentalFeeSink: import("@trezor/schema-utils").TString;
            rentalFee: import("@trezor/schema-utils").TNumber;
        }>]>, import("@trezor/schema-utils").TIntersect<[import("@trezor/schema-utils").TObject<{
            version: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TEnum<typeof NEM.TxVersion>, import("@trezor/schema-utils").TNumber]>;
            timeStamp: import("@trezor/schema-utils").TNumber;
            fee: import("@trezor/schema-utils").TNumber;
            deadline: import("@trezor/schema-utils").TNumber;
            signer: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        }>, import("@trezor/schema-utils").TObject<{
            type: import("@trezor/schema-utils").TLiteral<NEM.TxType.MOSAIC_CREATION>;
            mosaicDefinition: import("@trezor/schema-utils").TObject<{
                levy: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
                    type: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TEnum<typeof PROTO.NEMMosaicLevy>>;
                    fee: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
                    recipient: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                    mosaicId: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
                        namespaceId: import("@trezor/schema-utils").TString;
                        name: import("@trezor/schema-utils").TString;
                    }>>;
                }>>;
                id: import("@trezor/schema-utils").TObject<{
                    namespaceId: import("@trezor/schema-utils").TString;
                    name: import("@trezor/schema-utils").TString;
                }>;
                description: import("@trezor/schema-utils").TString;
                properties: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                    name: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TLiteral<"divisibility">, import("@trezor/schema-utils").TLiteral<"initialSupply">, import("@trezor/schema-utils").TLiteral<"supplyMutable">, import("@trezor/schema-utils").TLiteral<"transferable">]>;
                    value: import("@trezor/schema-utils").TString;
                }>>>;
            }>;
            creationFeeSink: import("@trezor/schema-utils").TString;
            creationFee: import("@trezor/schema-utils").TNumber;
        }>]>, import("@trezor/schema-utils").TIntersect<[import("@trezor/schema-utils").TObject<{
            version: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TEnum<typeof NEM.TxVersion>, import("@trezor/schema-utils").TNumber]>;
            timeStamp: import("@trezor/schema-utils").TNumber;
            fee: import("@trezor/schema-utils").TNumber;
            deadline: import("@trezor/schema-utils").TNumber;
            signer: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        }>, import("@trezor/schema-utils").TObject<{
            type: import("@trezor/schema-utils").TLiteral<NEM.TxType.SUPPLY_CHANGE>;
            mosaicId: import("@trezor/schema-utils").TObject<{
                namespaceId: import("@trezor/schema-utils").TString;
                name: import("@trezor/schema-utils").TString;
            }>;
            supplyType: import("@trezor/schema-utils").TEnum<typeof PROTO.NEMSupplyChangeType>;
            delta: import("@trezor/schema-utils").TNumber;
        }>]>]>;
    }>]>]>;
    chunkify: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
}>;
//# sourceMappingURL=index.d.ts.map