import type { BlockchainLinkParams } from '@trezor/blockchain-link';
import { PROTO } from '../../constants';
import type { AccountInfo } from '../account';
import type { Params, Response } from '../params';
export declare const ACCOUNT_TYPES: readonly [{
    readonly symbol: "btc";
    readonly type: "normal";
    readonly path: "m/84'/0'/i'";
}, {
    readonly symbol: "btc";
    readonly type: "taproot";
    readonly path: "m/86'/0'/i'";
}, {
    readonly symbol: "btc";
    readonly type: "segwit";
    readonly path: "m/49'/0'/i'";
}, {
    readonly symbol: "btc";
    readonly type: "legacy";
    readonly path: "m/44'/0'/i'";
}, {
    readonly symbol: "test";
    readonly type: "normal";
    readonly path: "m/84'/1'/i'";
}, {
    readonly symbol: "test";
    readonly type: "taproot";
    readonly path: "m/86'/1'/i'";
}, {
    readonly symbol: "test";
    readonly type: "segwit";
    readonly path: "m/49'/1'/i'";
}, {
    readonly symbol: "test";
    readonly type: "legacy";
    readonly path: "m/44'/1'/i'";
}, {
    readonly symbol: "regtest";
    readonly type: "normal";
    readonly path: "m/84'/1'/i'";
}, {
    readonly symbol: "regtest";
    readonly type: "taproot";
    readonly path: "m/86'/1'/i'";
}, {
    readonly symbol: "regtest";
    readonly type: "segwit";
    readonly path: "m/49'/1'/i'";
}, {
    readonly symbol: "regtest";
    readonly type: "legacy";
    readonly path: "m/44'/1'/i'";
}, {
    readonly symbol: "eth";
    readonly type: "normal";
    readonly path: "m/44'/60'/0'/0/i";
}, {
    readonly symbol: "eth";
    readonly type: "ledger";
    readonly path: "m/44'/60'/i'/0/0";
}, {
    readonly symbol: "eth";
    readonly type: "legacy";
    readonly path: "m/44'/60'/0'/i";
}, {
    readonly symbol: "tsep";
    readonly type: "normal";
    readonly path: "m/44'/1'/0'/0/i";
}, {
    readonly symbol: "thol";
    readonly type: "normal";
    readonly path: "m/44'/1'/0'/0/i";
}, {
    readonly symbol: "pol";
    readonly type: "normal";
    readonly path: "m/44'/60'/0'/0/i";
}, {
    readonly symbol: "pol";
    readonly type: "ledger";
    readonly path: "m/44'/60'/i'/0/0";
}, {
    readonly symbol: "bsc";
    readonly type: "normal";
    readonly path: "m/44'/60'/0'/0/i";
}, {
    readonly symbol: "bsc";
    readonly type: "ledger";
    readonly path: "m/44'/60'/i'/0/0";
}, {
    readonly symbol: "arb";
    readonly type: "normal";
    readonly path: "m/44'/60'/0'/0/i";
}, {
    readonly symbol: "arb";
    readonly type: "ledger";
    readonly path: "m/44'/60'/i'/0/0";
}, {
    readonly symbol: "base";
    readonly type: "normal";
    readonly path: "m/44'/60'/0'/0/i";
}, {
    readonly symbol: "base";
    readonly type: "ledger";
    readonly path: "m/44'/60'/i'/0/0";
}, {
    readonly symbol: "op";
    readonly type: "normal";
    readonly path: "m/44'/60'/0'/0/i";
}, {
    readonly symbol: "op";
    readonly type: "ledger";
    readonly path: "m/44'/60'/i'/0/0";
}, {
    readonly symbol: "sol";
    readonly type: "normal";
    readonly path: "m/44'/501'/i'/0'";
}, {
    readonly symbol: "sol";
    readonly type: "ledger";
    readonly path: "m/44'/501'/i'";
}, {
    readonly symbol: "dsol";
    readonly type: "normal";
    readonly path: "m/44'/501'/i'/0'";
}, {
    readonly symbol: "ada";
    readonly type: "normal";
    readonly path: "m/1852'/1815'/i'";
}, {
    readonly symbol: "ada";
    readonly type: "legacy";
    readonly path: "m/1852'/1815'/i'";
}, {
    readonly symbol: "ada";
    readonly type: "ledger";
    readonly path: "m/1852'/1815'/i'";
}, {
    readonly symbol: "tada";
    readonly type: "normal";
    readonly path: "m/1852'/1815'/i'";
}, {
    readonly symbol: "tada";
    readonly type: "legacy";
    readonly path: "m/1852'/1815'/i'";
}, {
    readonly symbol: "tada";
    readonly type: "ledger";
    readonly path: "m/1852'/1815'/i'";
}, {
    readonly symbol: "etc";
    readonly type: "normal";
    readonly path: "m/44'/61'/0'/0/i";
}, {
    readonly symbol: "xrp";
    readonly type: "normal";
    readonly path: "m/44'/144'/i'/0/0";
}, {
    readonly symbol: "txrp";
    readonly type: "normal";
    readonly path: "m/44'/144'/i'/0/0";
}, {
    readonly symbol: "ltc";
    readonly type: "normal";
    readonly path: "m/84'/2'/i'";
}, {
    readonly symbol: "ltc";
    readonly type: "segwit";
    readonly path: "m/49'/2'/i'";
}, {
    readonly symbol: "ltc";
    readonly type: "legacy";
    readonly path: "m/44'/2'/i'";
}, {
    readonly symbol: "bch";
    readonly type: "normal";
    readonly path: "m/44'/145'/i'";
}, {
    readonly symbol: "doge";
    readonly type: "normal";
    readonly path: "m/44'/3'/i'";
}, {
    readonly symbol: "zec";
    readonly type: "normal";
    readonly path: "m/44'/133'/i'";
}, {
    readonly symbol: "xlm";
    readonly type: "normal";
    readonly path: "m/44'/148'/i'";
}, {
    readonly symbol: "txlm";
    readonly type: "normal";
    readonly path: "m/44'/148'/i'";
}];
export declare const CARDANO_DERIVATIONS: {
    readonly normal: PROTO.CardanoDerivationType.ICARUS;
    readonly legacy: PROTO.CardanoDerivationType.ICARUS_TREZOR;
    readonly ledger: PROTO.CardanoDerivationType.LEDGER;
};
export type AccountTypeItem = (typeof ACCOUNT_TYPES)[number];
type DistributivePick<T, K extends keyof T> = T extends T ? Pick<T, K> : never;
export type AccountTypeKey = DistributivePick<AccountTypeItem, 'symbol' | 'type'>;
export type AdditionalParams = Pick<BlockchainLinkParams<'getAccountInfo'>, 'details' | 'pageSize'> & {
    identity?: string;
};
type CoinParam<T extends AccountTypeKey['symbol'] = AccountTypeKey['symbol']> = T extends T ? AdditionalParams & {
    symbol: T;
    known?: {
        type: Extract<AccountTypeKey, {
            symbol: T;
        }>['type'];
        skip?: number;
    }[];
    knownOnly?: boolean;
} : never;
type DiscoverAccountsParams = {
    coins: CoinParam[];
};
type ProgressBaseType = AccountTypeKey & {
    index: number;
    path: string;
    backendType?: string;
};
type DiscoveryError = {
    failed: true;
    error: string;
    code?: string;
};
export type DiscoverAccountsProgressOk = ProgressBaseType & AccountInfo & {
    failed: false;
};
export type DiscoverAccountsProgressError = ProgressBaseType & DiscoveryError;
export type DiscoverAccountsProgress = DiscoverAccountsProgressOk | DiscoverAccountsProgressError;
type DiscoverAccountsResult = {
    empty: number;
    nonempty: number;
    failed: number;
};
export declare function discoverAccounts(params: Params<DiscoverAccountsParams>): Response<DiscoverAccountsResult>;
export {};
//# sourceMappingURL=discoverAccounts.d.ts.map