import type { EventEmitter } from 'events';
import type { CallMethod } from './events/call';
import type { TrezorConnect } from './types';
import type { InitType } from './types/api/init';
export interface ConnectFactoryDependencies<SettingsType extends Record<string, any>> {
    init: InitType<SettingsType>;
    call: CallMethod;
    eventEmitter: EventEmitter;
    manifest: TrezorConnect['manifest'];
    setTransports: TrezorConnect['setTransports'];
    requestLogin: TrezorConnect['requestLogin'];
    uiResponse: TrezorConnect['uiResponse'];
    cancel: TrezorConnect['cancel'];
    dispose: TrezorConnect['dispose'];
}
export declare const factory: <SettingsType extends Record<string, any>, ExtraMethodsType extends Record<string, any>>({ eventEmitter, manifest, init, call, setTransports, requestLogin, uiResponse, cancel, dispose, }: ConnectFactoryDependencies<SettingsType>, extraMethods?: ExtraMethodsType) => Omit<TrezorConnect, "init"> & {
    init: InitType<SettingsType>;
} & ExtraMethodsType;
//# sourceMappingURL=factory.d.ts.map