"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.EthereumFeeLevels = void 0;
const bigNumber_1 = require("@trezor/utils/lib/bigNumber");
const MiscFeeLevels_1 = require("./MiscFeeLevels");
class EthereumFeeLevels extends MiscFeeLevels_1.MiscFeeLevels {
    coinInfo;
    constructor(coinInfo) {
        super(coinInfo);
        this.coinInfo = coinInfo;
    }
    async load(blockchain, request) {
        try {
            const [response] = await blockchain.estimateFee(request);
            const { eip1559 } = response;
            const maxFeeInWei = new bigNumber_1.BigNumber(this.coinInfo.maxFee).multipliedBy('1e+9').toNumber();
            const minFeeInWei = new bigNumber_1.BigNumber(this.coinInfo.minFee).multipliedBy('1e+9').toNumber();
            const feeInWei = new bigNumber_1.BigNumber(response.feePerUnit).toNumber();
            const feePerUnit = Math.min(maxFeeInWei, Math.max(minFeeInWei, feeInWei)).toString();
            if (eip1559?.baseFeePerGas) {
                const minMaxPriorityFeePerGas = new bigNumber_1.BigNumber(this.coinInfo.minPriorityFee)
                    .multipliedBy('1e+9')
                    .toNumber();
                const levels = ['low', 'medium', 'high'].map(levelKey => {
                    const level = eip1559[levelKey];
                    const label = levelKey === 'medium' ? 'normal' : levelKey;
                    if (!level?.maxFeePerGas || !level?.maxPriorityFeePerGas) {
                        return null;
                    }
                    const maxFeePerGas = bigNumber_1.BigNumber.max(this.coinInfo.minFee, level.maxFeePerGas, minMaxPriorityFeePerGas).toString();
                    const maxPriorityFeePerGas = bigNumber_1.BigNumber.max(minMaxPriorityFeePerGas, bigNumber_1.BigNumber.min(maxFeePerGas, level.maxPriorityFeePerGas)).toString();
                    return {
                        label,
                        feePerUnit,
                        feeLimit: response.feeLimit,
                        blocks: Math.ceil(Math.max(1, (level?.maxWaitTimeEstimate || 0) / 1000 / this.coinInfo.blockTime)),
                        baseFeePerGas: eip1559.baseFeePerGas,
                        maxFeePerGas,
                        maxPriorityFeePerGas,
                    };
                });
                this.levels = levels.filter(level => level);
            }
            else {
                this.levels[0] = {
                    ...this.levels[0],
                    ...response,
                    feePerUnit,
                };
            }
            this.wasFetchedSuccessfully = true;
        }
        catch {
        }
        return this.levels;
    }
}
exports.EthereumFeeLevels = EthereumFeeLevels;
//# sourceMappingURL=EthereumFeeLevels.js.map