"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BitcoinFeeLevels = void 0;
const bigNumber_1 = require("@trezor/utils/lib/bigNumber");
const MiscFeeLevels_1 = require("./MiscFeeLevels");
const defaultFeeLevels_1 = require("../../data/defaultFeeLevels");
class BitcoinFeeLevels extends MiscFeeLevels_1.MiscFeeLevels {
    coinInfo;
    longTermFeeRate;
    constructor(coinInfo) {
        super(coinInfo);
        this.coinInfo = coinInfo;
        this.longTermFeeRate = defaultFeeLevels_1.DEFAULT_BITCOIN_LONGTERM_FEE_RATE;
    }
    async load(blockchain) {
        try {
            const { minFee, maxFee } = this.coinInfo;
            const blocks = this.levels.map(level => level.blocks).filter(b => b > 0);
            const response = await blockchain.estimateFee({ blocks });
            response.forEach(({ feePerUnit: feePerKB }, index) => {
                const feePerB = new bigNumber_1.BigNumber(feePerKB).div(1000).toNumber();
                if (isNaN(feePerB) || feePerB < 0)
                    return;
                const trimmedFeePerUnit = Math.min(maxFee, Math.max(minFee, feePerB));
                this.levels[index].feePerUnit = trimmedFeePerUnit.toString();
            });
            this.wasFetchedSuccessfully = true;
        }
        catch {
        }
        return this.levels;
    }
    updateBitcoinCustomFee(feePerUnit) {
        this.levels = this.levels.filter(l => l.label !== 'custom');
        this.levels.push({
            label: 'custom',
            feePerUnit,
            blocks: -1,
        });
    }
}
exports.BitcoinFeeLevels = BitcoinFeeLevels;
//# sourceMappingURL=BitcoinFeeLevels.js.map